#include	"config.h"
#include	"ldapaddressbook.h"

#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

struct ldapabook *ldapabook_read(const char *filename)
{
char	buf[BUFSIZ];
FILE	*fp;
struct	ldapabook *list, *last;
char	*s;
char	*name;
char	*host;
char	*port;
char	*suffix;
char	*binddn;
char	*bindpw;

	if ((fp=fopen(filename, "r")) == 0)	return (0);

	list=last=0;
	while (fgets(buf, sizeof(buf), fp))
	{
	struct	ldapabook *p;

		s=strchr(buf, '\n');
		if (s)	*s=0;
		if ((s=strchr(buf, '#')) != 0)	*s=0;
		name=buf;
		s=strchr(buf, '\t');
		if (!s)	continue;
		*s++=0;
		host=s;
		s=strchr(s, '\t');
		if (s) *s++=0;
		port=s;
		if (s)	s=strchr(s, '\t');
		if (s)	*s++=0;
		suffix=s;
		if (s)	s=strchr(s, '\t');
		if (s)	*s++=0;
		binddn=s;
		if (s)	s=strchr(s, '\t');
		if (s)	*s++=0;
		bindpw=s;
		if (!port || !*port)	port="389";
		if (!suffix)	suffix="";
		if (!binddn)	binddn="";
		if (!bindpw)	bindpw="";

		if ((p=malloc(sizeof(struct ldapabook))) == 0)
		{
			ldapabook_free(list);
			fclose(fp);
			return (0);
		}

		memset(p, 0, sizeof(*p));

		if ( (p->name=strdup(name)) != 0)
		{
			if ((p->host=strdup(host)) != 0)
			{
				if ((p->port=strdup(port)) != 0)
				{
					if ((p->suffix=strdup(suffix)) != 0)
					{
						if ((p->binddn=strdup(binddn))
							!= 0)
						{
							if ((p->bindpw=strdup
								(bindpw)) != 0)
							{
								if (!list)
								   list=last=p;
								else
								   last->next=p;
								last=p;
								p->next=0;
								continue;
							}
							free(p->binddn);
						}
						free(p->suffix);
					}
					free(p->port);
				}
				free(p->host);
			}
			free(p->name);
		}
		free(p);
		ldapabook_free(list);
		fclose(fp);
		return (0);
	}
	fclose(fp);
	return (list);
}

void ldapabook_free(struct ldapabook *p)
{
	while (p)
	{
	struct ldapabook *n=p->next;

		free(p->bindpw);
		free(p->binddn);
		free(p->suffix);
		free(p->port);
		free(p->host);
		free(p->name);
		free(p);
		p=n;
	}
}
