/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<string.h>
#include	<stdio.h>
#include	<errno.h>
#include	<fcntl.h>
#if	HAVE_UNISTD_H
#include	"unistd.h"
#endif
#if	HAVE_SYSLOG_H
#include	<syslog.h>
#endif

static const char rcsid[]="$Id: logger.c,v 1.3 2001/08/16 01:38:43 mrsam Exp $";

int main(int argc, char **argv)
{
char	buf[512];
char	*p;
int	c;

	if (argc < 2)	return (1);

#if	TESTMODE

#else
	openlog(argv[1], 0

#ifdef	LOG_NDELAY
			| LOG_NDELAY
#else
			| LOG_NOWAIT
#endif

			, LOG_MAIL);
	close(1);
	close(2);
	open("/dev/null", O_WRONLY);
	open("/dev/null", O_WRONLY);
#endif
	chdir("/");

	while (fgets(buf, sizeof(buf), stdin))
	{
		if ((p=strchr(buf, '\n')) != 0)	*p=0;
		else
			while ((c=getchar()) != EOF && c != '\n')
				;

#if	TESTMODE
		fprintf(stderr, "%s: %s\n", argv[1], buf);
#else
		c=LOG_INFO;
		if (strncmp(buf, "ERR:", 4) == 0)
		{
			c=LOG_ERR;
			p=buf+4;
		}
		else if (strncmp(buf, "WARN:", 5) == 0)
		{
			c=LOG_WARNING;
			p=buf+5;
		}
		else if (strncmp(buf, "ALERT:", 5) == 0)
		{
			c=LOG_ALERT;
			p=buf+6;
		}
		else if (strncmp(buf, "INFO:", 5) == 0)
			p=buf+5;
		else	p=buf;

		while (*p == ' ')
			++p;

		syslog(c, "%s", p);
#endif
	}
	return (0);
}
