/*
** Copyright 2000-2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"config.h"
#include	"cmlm.h"
#include	"cmlmmoderate.h"
#include	<fstream>
#include	<fcntl.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<signal.h>
#include	<sysexits.h>

static const char rcsid[]="$Id: cmlmmoderate.C,v 1.4 2001/08/05 20:00:33 mrsam Exp $";

// -----------------------------------------------------------------------
//
// Initial moderator notification.
//
// -----------------------------------------------------------------------

int sendinitmod(afxipipestream &i, const char *filename, const char *tpl)
{
pid_t	p;
CString	boundary;
const char *argv[6];
CString	token;

	argv[0]="sendmail";
	argv[1]="-f";
	argv[2]="";
	argv[3]="-N";
	argv[4]="fail";
	argv[5]=0;

	boundary=mkboundary_msg(i);
	if (boundary.GetLength() <= 0)
		return (EX_OSERR);

	i.clear();
	i.seekg(0);

int	j;

	if (i.bad() || (token << i) || (j=token.Find(':')) < 0)
	{
		perror("seek");
		return (EX_OSERR);
	}

	token=token.Mid(j+1);
	token.TrimLeft();
	token.TrimRight();

afxopipestream	ack(sendmail(argv, p));

CString	retaddr=get_verp_return("moderate", 0);

	ack << "From: " << retaddr << endl
		<< "Reply-To: " << retaddr << endl
		<< "To: " << get_verp_return("owner", 0) << endl;

	{
	ifstream	ifs("modsubject.tmpl");
	CString	buf;

		while ((buf << ifs) == 0)
		{
			ack << buf << endl;
		}
	}

	ack << "MIME-Version: 1.0" << endl;
	ack << "Content-Type: multipart/mixed; boundary=\""
			<< boundary << "\"" << endl;
	ack << "Content-Transfer-Encoding: 8bit" << endl << endl;
	ack << "This is a MIME formatted message." << endl;
	ack << endl << "--" << boundary << endl;

	{
	ifstream	ifs(tpl);
	CString	buf;

		while ((buf << ifs) == 0)
		{
			ack << buf << endl;
		}
	}

	ack << "[" << filename << "]" << endl;
	ack << "[" << token << "]" << endl;

	ack << endl << "--" << boundary << endl;
	ack << "Content-Type: message/rfc822" << endl << endl;

	i.seekg(0);
	if (i.bad())
	{
		perror("seek");
		exit(EX_OSERR);
	}

	{
		char	buf[BUFSIZ];

		i.read(buf, sizeof(buf));

		int	x;

		while ((x=i.gcount()) > 0)
		{
			ack.write(buf, x);
			i.read(buf, sizeof(buf));
		}
		if (ack.bad() || i.bad())
		{
			perror("write");
			exit(EX_OSERR);
		}
	}



	ack << endl << "--" << boundary << "--" << endl;
	ack.flush();
	ack.close();
	return (wait4sendmail(p));
}

static int domodaccept(afxipipestream &, CString);
static int domodreject(afxipipestream &, CString);
static int domodbounce(afxipipestream &, CString);

// Process moderation response.

int cmdmoderate()
{
CString	buf, name, msg, filename, token;
static int (*cmdfunc)(afxipipestream &, CString);

	while ((buf << cin) == 0)
	{
	int	i;

		if (buf.GetLength() <= 0)
			break;
		i=buf.Find(':');
		if (i < 0)	continue;

		name=buf.Left(i);
		name.MakeLower();
		if (name != "subject")	continue;
		buf=buf.Mid(i+1);
		buf.TrimLeft();

		cmdfunc=domodaccept;

		if (strncasecmp(buf, "no", 2) == 0)
			cmdfunc=domodreject;
		else if (strncasecmp(buf, "reject", 6) == 0)
			cmdfunc=domodbounce;

		while ((buf << cin) == 0)
			if (buf.GetLength() == 0)	break;

		while ((buf << cin) == 0)
			if (buf.Find('=') >= 0)
				break;

		msg="";

		while ((buf << cin) == 0)
		{
			if (buf.Find('=') >= 0)
				break;
			if (buf.GetLength() + msg.GetLength() > 50000)
				continue;
			if (*(const char *)buf == '>')	continue;
			msg += buf;
			msg += '\n';
		}

		filename="";
		token="";
		while ((buf << cin) == 0)
		{
			i=buf.Find('[');
			if (i < 0)	continue;
			buf=buf.Mid(i+1);
			i=buf.Find(']');
			if (i < 0)	continue;
			filename=buf.Left(i);
			break;
		}

		while ((buf << cin) == 0)
		{
			i=buf.Find('[');
			if (i < 0)	continue;
			buf=buf.Mid(i+1);
			i=buf.Find(']');
			if (i < 0)	continue;
			token=buf.Left(i);
			break;
		}

		while ((buf << cin) == 0)
			;

		if (token.GetLength() <= 0)	break;

		if (filename.Find('/') >= 0)	break;	/* Script kiddy */

		filename = MODQUEUE "/" + filename;

		{
			ExclusiveLock modqueue_lock(MODQUEUELOCKFILE);
			int i_fd=open(filename, O_RDONLY);

			if (i_fd < 0)
			{
				perror(filename);
				exit(EX_OSERR);
			}

			afxipipestream ifs(i_fd);

			int	rc;

			if (buf << ifs)	break;

			i=buf.Find(':');
			if (i < 0)	break;
			buf=buf.Mid(i+1);
			buf.TrimLeft();

			if (buf != token)	break;

			rc=(*cmdfunc)(ifs, msg);
			ifs.close();
			if (rc == 0)
				unlink(filename);
			return (rc);
		}
	}

	cerr << "Invalid moderation message." << endl;
	return (1);
}

static int docopy_noseek(istream &i, ostream &o)
{
	char	buf[BUFSIZ];

	i.read(buf, sizeof(buf));

	int	x;

	while ((x=i.gcount()) > 0)
	{
		o.write(buf, x);
		i.read(buf, sizeof(buf));
	}
	if (o.bad() || i.bad())
		return (EX_OSERR);
	return (0);
}

static int domodaccept(afxipipestream &i, CString s)
{
	return (postmsg(i, docopy_noseek));
}

static int domodreject(afxipipestream &i, CString s)
{
	// Nothing - silently discard it.

	return (0);
}

static int domodbounce(afxipipestream &i, CString s)
{
CString	buf;
CString	from;
CString	replyto;

	{
	CString	headerbuf="";

		while ((buf << i) == 0)
		{
			if (buf.GetLength() == 0)	break;
			headerbuf += buf;
			headerbuf += '\n';
		}

		from=header(headerbuf, "from");
		replyto=header(headerbuf, "replyto");
	}

CString	boundary=mkboundary_msg(i);

	if (replyto.GetLength())	from=replyto;

const char	*argv[6];

	argv[0]="sendmail";
	argv[1]="-f";

CString	me=get_verp_return("owner", 0);

	argv[2]=me;
	argv[3]="-N";
	argv[4]="fail";
	argv[5]=0;

pid_t	p;
afxopipestream	ack(sendmail(argv, p));

	ack << "From: " << me << endl
		<< "Reply-To: " << me << endl
		<< "To: " << from << endl
		<< "Mime-Version: 1.0" << endl
		<< "Content-Type: multipart/mixed; boundary=\"" << boundary <<
			"\"" << endl
		<< "Content-Transfer-Encoding: 8bit" << endl;

	ack_template(ack, "modrejheader.tmpl", "");

	ack << endl;
	ack << "This is a MIME formatted message." << endl;
	ack << endl << "--" << boundary << endl;
	ack_template(ack, "modrejbody.tmpl", s);
	ack << endl << "--" << boundary << endl;
	ack << "Content-Type: message/rfc822" << endl << endl;

	i.seekg(0);
	if (i.bad())
	{
		perror("seek");
		return (EX_OSERR);
	}
	buf << i;	// Magic-Token: header

int	rc=docopy_noseek(i, ack);

	ack << endl << "--" << boundary << "--" << endl;

	ack.flush();
	if (ack.bad())
	{
		kill(p, SIGTERM);
		wait4sendmail(p);
		return (EX_OSERR);
	}

	ack.close();
int	rc2=wait4sendmail(p);

	if (rc2)	rc=rc2;
	return (rc);
}
