cat >certs/aba-ecom-root-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            d0:1e:40:90:00:00:46:52:00:00:00:01:00:00:00:04
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=DC, L=Washington, O=ABA.ECOM, INC., CN=ABA.ECOM Root CA/emailAddress=admin@digsigtrust.com
        Validity
            Not Before: Jul 12 17:33:53 1999 GMT
            Not After : Jul  9 17:33:53 2009 GMT
        Subject: C=US, ST=DC, L=Washington, O=ABA.ECOM, INC., CN=ABA.ECOM Root CA/emailAddress=admin@digsigtrust.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b1:d3:11:e0:79:55:43:07:08:4c:cb:05:42:00:
                    e2:0d:83:46:3d:e4:93:ba:b6:06:d3:0d:59:bd:3e:
                    c1:ce:43:67:01:8a:21:a8:ef:bc:cc:d0:a2:cc:b0:
                    55:96:53:84:66:05:00:da:44:49:80:d8:54:0a:a5:
                    25:86:94:ed:63:56:ff:70:6c:a3:a1:19:d2:78:be:
                    68:2a:44:5e:2f:cf:cc:18:5e:47:bc:3a:b1:46:3d:
                    1e:f0:b9:2c:34:5f:8c:7c:4c:08:29:9d:40:55:eb:
                    3c:7d:83:de:b5:f0:f7:8a:83:0e:a1:4c:b4:3a:a5:
                    b3:5f:5a:22:97:ec:19:9b:c1:05:68:fd:e6:b7:a9:
                    91:94:2c:e4:78:48:24:1a:25:19:3a:eb:95:9c:39:
                    0a:8a:cf:42:b2:f0:1c:d5:5f:fb:6b:ed:68:56:7b:
                    39:2c:72:38:b0:ee:93:a9:d3:7b:77:3c:eb:71:03:
                    a9:38:4a:16:6c:89:2a:ca:da:33:13:79:c2:55:8c:
                    ed:9c:bb:f2:cb:5b:10:f8:2e:61:35:c6:29:4c:2a:
                    d0:2a:63:d1:65:59:b4:f8:cd:f9:f4:00:84:b6:57:
                    42:85:9d:32:a8:f9:2a:54:fb:ff:78:41:bc:bd:71:
                    28:f4:bb:90:bc:ff:96:34:04:e3:45:9e:a1:46:28:
                    40:81
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE, pathlen:8
    Signature Algorithm: sha1WithRSAEncryption
        04:6f:25:86:e4:e6:96:27:b4:d9:42:c0:d0:c9:00:b1:7f:54:
        3e:87:b2:6d:24:a9:2f:0a:7e:fd:a4:44:b0:f8:54:07:bd:1b:
        9d:9d:ca:7b:50:24:7b:11:5b:49:a3:a6:bf:12:74:d5:89:b7:
        b7:2f:98:64:25:14:b7:61:e9:7f:60:80:6b:d3:64:e8:ab:bd:
        1a:d6:51:fa:c0:b4:5d:77:1a:7f:64:08:5e:79:c6:05:4c:f1:
        7a:dd:4d:7d:ce:e6:48:7b:54:d2:61:92:81:d6:1b:d6:00:f0:
        0e:9e:28:77:a0:4d:88:c7:22:76:19:c3:c7:9e:1b:a6:77:78:
        f8:5f:9b:56:d1:f0:f2:17:ac:8e:9d:59:e6:1f:fe:57:b6:d9:
        5e:e1:5d:9f:45:ec:61:68:19:41:e1:b2:20:26:fe:5a:30:76:
        24:ff:40:72:3c:79:9f:7c:22:48:ab:46:cd:db:b3:86:2c:8f:
        bf:05:41:d3:c1:e3:14:e3:41:17:26:d0:7c:a7:71:4c:19:e8:
        4a:0f:72:58:31:7d:ec:60:7a:a3:22:28:bd:19:24:60:3f:3b:
        87:73:c0:6b:e4:cb:ae:b7:ab:25:43:b2:55:2d:7b:ab:06:0e:
        75:5d:34:e5:5d:73:6d:9e:b2:75:40:a5:59:c9:4f:31:71:88:
        d9:88:7f:54
-----BEGIN CERTIFICATE-----
MIIDtTCCAp2gAwIBAgIRANAeQJAAAEZSAAAAAQAAAAQwDQYJKoZIhvcNAQEFBQAw
gYkxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJEQzETMBEGA1UEBxMKV2FzaGluZ3Rv
bjEXMBUGA1UEChMOQUJBLkVDT00sIElOQy4xGTAXBgNVBAMTEEFCQS5FQ09NIFJv
b3QgQ0ExJDAiBgkqhkiG9w0BCQEWFWFkbWluQGRpZ3NpZ3RydXN0LmNvbTAeFw05
OTA3MTIxNzMzNTNaFw0wOTA3MDkxNzMzNTNaMIGJMQswCQYDVQQGEwJVUzELMAkG
A1UECBMCREMxEzARBgNVBAcTCldhc2hpbmd0b24xFzAVBgNVBAoTDkFCQS5FQ09N
LCBJTkMuMRkwFwYDVQQDExBBQkEuRUNPTSBSb290IENBMSQwIgYJKoZIhvcNAQkB
FhVhZG1pbkBkaWdzaWd0cnVzdC5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
ggEKAoIBAQCx0xHgeVVDBwhMywVCAOINg0Y95JO6tgbTDVm9PsHOQ2cBiiGo77zM
0KLMsFWWU4RmBQDaREmA2FQKpSWGlO1jVv9wbKOhGdJ4vmgqRF4vz8wYXke8OrFG
PR7wuSw0X4x8TAgpnUBV6zx9g9618PeKgw6hTLQ6pbNfWiKX7BmbwQVo/ea3qZGU
LOR4SCQaJRk665WcOQqKz0Ky8BzVX/tr7WhWezkscjiw7pOp03t3POtxA6k4ShZs
iSrK2jMTecJVjO2cu/LLWxD4LmE1xilMKtAqY9FlWbT4zfn0AIS2V0KFnTKo+SpU
+/94Qby9cSj0u5C8/5Y0BONFnqFGKECBAgMBAAGjFjAUMBIGA1UdEwEB/wQIMAYB
Af8CAQgwDQYJKoZIhvcNAQEFBQADggEBAARvJYbk5pYntNlCwNDJALF/VD6Hsm0k
qS8Kfv2kRLD4VAe9G52dyntQJHsRW0mjpr8SdNWJt7cvmGQlFLdh6X9ggGvTZOir
vRrWUfrAtF13Gn9kCF55xgVM8XrdTX3O5kh7VNJhkoHWG9YA8A6eKHegTYjHInYZ
w8eeG6Z3ePhfm1bR8PIXrI6dWeYf/le22V7hXZ9F7GFoGUHhsiAm/lowdiT/QHI8
eZ98IkirRs3bs4Ysj78FQdPB4xTjQRcm0HyncUwZ6EoPclgxfexgeqMiKL0ZJGA/
O4dzwGvky663qyVDslUte6sGDnVdNOVdc22esnVApVnJTzFxiNmIf1Q=
-----END CERTIFICATE-----
...EOF...
cat >certs/addtrust-class-1-ca-root.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Class 1 CA Root
        Validity
            Not Before: May 30 10:38:31 2000 GMT
            Not After : May 30 10:38:31 2020 GMT
        Subject: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Class 1 CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:96:96:d4:21:49:60:e2:6b:e8:41:07:0c:de:c4:
                    e0:dc:13:23:cd:c1:35:c7:fb:d6:4e:11:0a:67:5e:
                    f5:06:5b:6b:a5:08:3b:5b:29:16:3a:e7:87:b2:34:
                    06:c5:bc:05:a5:03:7c:82:cb:29:10:ae:e1:88:81:
                    bd:d6:9e:d3:fe:2d:56:c1:15:ce:e3:26:9d:15:2e:
                    10:fb:06:8f:30:04:de:a7:b4:63:b4:ff:b1:9c:ae:
                    3c:af:77:b6:56:c5:b5:ab:a2:e9:69:3a:3d:0e:33:
                    79:32:3f:70:82:92:99:61:6d:8d:30:08:8f:71:3f:
                    a6:48:57:19:f8:25:dc:4b:66:5c:a5:74:8f:98:ae:
                    c8:f9:c0:06:22:e7:ac:73:df:a5:2e:fb:52:dc:b1:
                    15:65:20:fa:35:66:69:de:df:2c:f1:6e:bc:30:db:
                    2c:24:12:db:eb:35:35:68:90:cb:00:b0:97:21:3d:
                    74:21:23:65:34:2b:bb:78:59:a3:d6:e1:76:39:9a:
                    a4:49:8e:8c:74:af:6e:a4:9a:a3:d9:9b:d2:38:5c:
                    9b:a2:18:cc:75:23:84:be:eb:e2:4d:33:71:8e:1a:
                    f0:c2:f8:c7:1d:a2:ad:03:97:2c:f8:cf:25:c6:f6:
                    b8:24:31:b1:63:5d:92:7f:63:f0:25:c9:53:2e:1f:
                    bf:4d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            95:B1:B4:F0:94:B6:BD:C7:DA:D1:11:09:21:BE:C1:AF:49:FD:10:7B
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Authority Key Identifier: 
            keyid:95:B1:B4:F0:94:B6:BD:C7:DA:D1:11:09:21:BE:C1:AF:49:FD:10:7B
            DirName:/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Class 1 CA Root
            serial:01

    Signature Algorithm: sha1WithRSAEncryption
        2c:6d:64:1b:1f:cd:0d:dd:b9:01:fa:96:63:34:32:48:47:99:
        ae:97:ed:fd:72:16:a6:73:47:5a:f4:eb:dd:e9:f5:d6:fb:45:
        cc:29:89:44:5d:bf:46:39:3d:e8:ee:bc:4d:54:86:1e:1d:6c:
        e3:17:27:43:e1:89:56:2b:a9:6f:72:4e:49:33:e3:72:7c:2a:
        23:9a:bc:3e:ff:28:2a:ed:a3:ff:1c:23:ba:43:57:09:67:4d:
        4b:62:06:2d:f8:ff:6c:9d:60:1e:d8:1c:4b:7d:b5:31:2f:d9:
        d0:7c:5d:f8:de:6b:83:18:78:37:57:2f:e8:33:07:67:df:1e:
        c7:6b:2a:95:76:ae:8f:57:a3:f0:f4:52:b4:a9:53:08:cf:e0:
        4f:d3:7a:53:8b:fd:bb:1c:56:36:f2:fe:b2:b6:e5:76:bb:d5:
        22:65:a7:3f:fe:d1:66:ad:0b:bc:6b:99:86:ef:3f:7d:f3:18:
        32:ca:7b:c6:e3:ab:64:46:95:f8:26:69:d9:55:83:7b:2c:96:
        07:ff:59:2c:44:a3:c6:e5:e9:a9:dc:a1:63:80:5a:21:5e:21:
        cf:53:54:f0:ba:6f:89:db:a8:aa:95:cf:8b:e3:71:cc:1e:1b:
        20:44:08:c0:7a:b6:40:fd:c4:e4:35:e1:1d:16:1c:d0:bc:2b:
        8e:d6:71:d9
-----BEGIN CERTIFICATE-----
MIIEGDCCAwCgAwIBAgIBATANBgkqhkiG9w0BAQUFADBlMQswCQYDVQQGEwJTRTEU
MBIGA1UEChMLQWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFkZFRydXN0IFRUUCBOZXR3
b3JrMSEwHwYDVQQDExhBZGRUcnVzdCBDbGFzcyAxIENBIFJvb3QwHhcNMDAwNTMw
MTAzODMxWhcNMjAwNTMwMTAzODMxWjBlMQswCQYDVQQGEwJTRTEUMBIGA1UEChML
QWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFkZFRydXN0IFRUUCBOZXR3b3JrMSEwHwYD
VQQDExhBZGRUcnVzdCBDbGFzcyAxIENBIFJvb3QwggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCWltQhSWDia+hBBwzexODcEyPNwTXH+9ZOEQpnXvUGW2ul
CDtbKRY654eyNAbFvAWlA3yCyykQruGIgb3WntP+LVbBFc7jJp0VLhD7Bo8wBN6n
tGO0/7Gcrjyvd7ZWxbWroulpOj0OM3kyP3CCkplhbY0wCI9xP6ZIVxn4JdxLZlyl
dI+Yrsj5wAYi56xz36Uu+1LcsRVlIPo1Zmne3yzxbrww2ywkEtvrNTVokMsAsJch
PXQhI2U0K7t4WaPW4XY5mqRJjox0r26kmqPZm9I4XJuiGMx1I4S+6+JNM3GOGvDC
+Mcdoq0Dlyz4zyXG9rgkMbFjXZJ/Y/AlyVMuH79NAgMBAAGjgdIwgc8wHQYDVR0O
BBYEFJWxtPCUtr3H2tERCSG+wa9J/RB7MAsGA1UdDwQEAwIBBjAPBgNVHRMBAf8E
BTADAQH/MIGPBgNVHSMEgYcwgYSAFJWxtPCUtr3H2tERCSG+wa9J/RB7oWmkZzBl
MQswCQYDVQQGEwJTRTEUMBIGA1UEChMLQWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFk
ZFRydXN0IFRUUCBOZXR3b3JrMSEwHwYDVQQDExhBZGRUcnVzdCBDbGFzcyAxIENB
IFJvb3SCAQEwDQYJKoZIhvcNAQEFBQADggEBACxtZBsfzQ3duQH6lmM0MkhHma6X
7f1yFqZzR1r0693p9db7RcwpiURdv0Y5PejuvE1Uhh4dbOMXJ0PhiVYrqW9yTkkz
43J8KiOavD7/KCrto/8cI7pDVwlnTUtiBi34/2ydYB7YHEt9tTEv2dB8Xfjea4MY
eDdXL+gzB2ffHsdrKpV2ro9Xo/D0UrSpUwjP4E/TelOL/bscVjby/rK25Xa71SJl
pz/+0WatC7xrmYbvP33zGDLKe8bjq2RGlfgmadlVg3sslgf/WSxEo8bl6ancoWOA
WiFeIc9TVPC6b4nbqKqVz4vjccweGyBECMB6tkD9xOQ14R0WHNC8K47Wcdk=
-----END CERTIFICATE-----
...EOF...
cat >certs/addtrust-external-ca-root.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust External TTP Network, CN=AddTrust External CA Root
        Validity
            Not Before: May 30 10:48:38 2000 GMT
            Not After : May 30 10:48:38 2020 GMT
        Subject: C=SE, O=AddTrust AB, OU=AddTrust External TTP Network, CN=AddTrust External CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b7:f7:1a:33:e6:f2:00:04:2d:39:e0:4e:5b:ed:
                    1f:bc:6c:0f:cd:b5:fa:23:b6:ce:de:9b:11:33:97:
                    a4:29:4c:7d:93:9f:bd:4a:bc:93:ed:03:1a:e3:8f:
                    cf:e5:6d:50:5a:d6:97:29:94:5a:80:b0:49:7a:db:
                    2e:95:fd:b8:ca:bf:37:38:2d:1e:3e:91:41:ad:70:
                    56:c7:f0:4f:3f:e8:32:9e:74:ca:c8:90:54:e9:c6:
                    5f:0f:78:9d:9a:40:3c:0e:ac:61:aa:5e:14:8f:9e:
                    87:a1:6a:50:dc:d7:9a:4e:af:05:b3:a6:71:94:9c:
                    71:b3:50:60:0a:c7:13:9d:38:07:86:02:a8:e9:a8:
                    69:26:18:90:ab:4c:b0:4f:23:ab:3a:4f:84:d8:df:
                    ce:9f:e1:69:6f:bb:d7:42:d7:6b:44:e4:c7:ad:ee:
                    6d:41:5f:72:5a:71:08:37:b3:79:65:a4:59:a0:94:
                    37:f7:00:2f:0d:c2:92:72:da:d0:38:72:db:14:a8:
                    45:c4:5d:2a:7d:b7:b4:d6:c4:ee:ac:cd:13:44:b7:
                    c9:2b:dd:43:00:25:fa:61:b9:69:6a:58:23:11:b7:
                    a7:33:8f:56:75:59:f5:cd:29:d7:46:b7:0a:2b:65:
                    b6:d3:42:6f:15:b2:b8:7b:fb:ef:e9:5d:53:d5:34:
                    5a:27
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            AD:BD:98:7A:34:B4:26:F7:FA:C4:26:54:EF:03:BD:E0:24:CB:54:1A
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Authority Key Identifier: 
            keyid:AD:BD:98:7A:34:B4:26:F7:FA:C4:26:54:EF:03:BD:E0:24:CB:54:1A
            DirName:/C=SE/O=AddTrust AB/OU=AddTrust External TTP Network/CN=AddTrust External CA Root
            serial:01

    Signature Algorithm: sha1WithRSAEncryption
        b0:9b:e0:85:25:c2:d6:23:e2:0f:96:06:92:9d:41:98:9c:d9:
        84:79:81:d9:1e:5b:14:07:23:36:65:8f:b0:d8:77:bb:ac:41:
        6c:47:60:83:51:b0:f9:32:3d:e7:fc:f6:26:13:c7:80:16:a5:
        bf:5a:fc:87:cf:78:79:89:21:9a:e2:4c:07:0a:86:35:bc:f2:
        de:51:c4:d2:96:b7:dc:7e:4e:ee:70:fd:1c:39:eb:0c:02:51:
        14:2d:8e:bd:16:e0:c1:df:46:75:e7:24:ad:ec:f4:42:b4:85:
        93:70:10:67:ba:9d:06:35:4a:18:d3:2b:7a:cc:51:42:a1:7a:
        63:d1:e6:bb:a1:c5:2b:c2:36:be:13:0d:e6:bd:63:7e:79:7b:
        a7:09:0d:40:ab:6a:dd:8f:8a:c3:f6:f6:8c:1a:42:05:51:d4:
        45:f5:9f:a7:62:21:68:15:20:43:3c:99:e7:7c:bd:24:d8:a9:
        91:17:73:88:3f:56:1b:31:38:18:b4:71:0f:9a:cd:c8:0e:9e:
        8e:2e:1b:e1:8c:98:83:cb:1f:31:f1:44:4c:c6:04:73:49:76:
        60:0f:c7:f8:bd:17:80:6b:2e:e9:cc:4c:0e:5a:9a:79:0f:20:
        0a:2e:d5:9e:63:26:1e:55:92:94:d8:82:17:5a:7b:d0:bc:c7:
        8f:4e:86:04
-----BEGIN CERTIFICATE-----
MIIENjCCAx6gAwIBAgIBATANBgkqhkiG9w0BAQUFADBvMQswCQYDVQQGEwJTRTEU
MBIGA1UEChMLQWRkVHJ1c3QgQUIxJjAkBgNVBAsTHUFkZFRydXN0IEV4dGVybmFs
IFRUUCBOZXR3b3JrMSIwIAYDVQQDExlBZGRUcnVzdCBFeHRlcm5hbCBDQSBSb290
MB4XDTAwMDUzMDEwNDgzOFoXDTIwMDUzMDEwNDgzOFowbzELMAkGA1UEBhMCU0Ux
FDASBgNVBAoTC0FkZFRydXN0IEFCMSYwJAYDVQQLEx1BZGRUcnVzdCBFeHRlcm5h
bCBUVFAgTmV0d29yazEiMCAGA1UEAxMZQWRkVHJ1c3QgRXh0ZXJuYWwgQ0EgUm9v
dDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALf3GjPm8gAELTngTlvt
H7xsD821+iO2zt6bETOXpClMfZOfvUq8k+0DGuOPz+VtUFrWlymUWoCwSXrbLpX9
uMq/NzgtHj6RQa1wVsfwTz/oMp50ysiQVOnGXw94nZpAPA6sYapeFI+eh6FqUNzX
mk6vBbOmcZSccbNQYArHE504B4YCqOmoaSYYkKtMsE8jqzpPhNjfzp/haW+710LX
a0Tkx63ubUFfclpxCDezeWWkWaCUN/cALw3CknLa0Dhy2xSoRcRdKn23tNbE7qzN
E0S3ySvdQwAl+mG5aWpYIxG3pzOPVnVZ9c0p10a3CitlttNCbxWyuHv77+ldU9U0
WicCAwEAAaOB3DCB2TAdBgNVHQ4EFgQUrb2YejS0Jvf6xCZU7wO94CTLVBowCwYD
VR0PBAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wgZkGA1UdIwSBkTCBjoAUrb2YejS0
Jvf6xCZU7wO94CTLVBqhc6RxMG8xCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtBZGRU
cnVzdCBBQjEmMCQGA1UECxMdQWRkVHJ1c3QgRXh0ZXJuYWwgVFRQIE5ldHdvcmsx
IjAgBgNVBAMTGUFkZFRydXN0IEV4dGVybmFsIENBIFJvb3SCAQEwDQYJKoZIhvcN
AQEFBQADggEBALCb4IUlwtYj4g+WBpKdQZic2YR5gdkeWxQHIzZlj7DYd7usQWxH
YINRsPkyPef89iYTx4AWpb9a/IfPeHmJIZriTAcKhjW88t5RxNKWt9x+Tu5w/Rw5
6wwCURQtjr0W4MHfRnXnJK3s9EK0hZNwEGe6nQY1ShjTK3rMUUKhemPR5ruhxSvC
Nr4TDea9Y355e6cJDUCrat2PisP29owaQgVR1EX1n6diIWgVIEM8med8vSTYqZEX
c4g/VhsxOBi0cQ+azcgOno4uG+GMmIPLHzHxREzGBHNJdmAPx/i9F4BrLunMTA5a
mnkPIAou1Z5jJh5VkpTYghdae9C8x49OhgQ=
-----END CERTIFICATE-----
...EOF...
cat >certs/addtrust-public-ca-root.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Public CA Root
        Validity
            Not Before: May 30 10:41:50 2000 GMT
            Not After : May 30 10:41:50 2020 GMT
        Subject: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Public CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e9:1a:30:8f:83:88:14:c1:20:d8:3c:9b:8f:1b:
                    7e:03:74:bb:da:69:d3:46:a5:f8:8e:c2:0c:11:90:
                    51:a5:2f:66:54:40:55:ea:db:1f:4a:56:ee:9f:23:
                    6e:f4:39:cb:a1:b9:6f:f2:7e:f9:5d:87:26:61:9e:
                    1c:f8:e2:ec:a6:81:f8:21:c5:24:cc:11:0c:3f:db:
                    26:72:7a:c7:01:97:07:17:f9:d7:18:2c:30:7d:0e:
                    7a:1e:62:1e:c6:4b:c0:fd:7d:62:77:d3:44:1e:27:
                    f6:3f:4b:44:b3:b7:38:d9:39:1f:60:d5:51:92:73:
                    03:b4:00:69:e3:f3:14:4e:ee:d1:dc:09:cf:77:34:
                    46:50:b0:f8:11:f2:fe:38:79:f7:07:39:fe:51:92:
                    97:0b:5b:08:5f:34:86:01:ad:88:97:eb:66:cd:5e:
                    d1:ff:dc:7d:f2:84:da:ba:77:ad:dc:80:08:c7:a7:
                    87:d6:55:9f:97:6a:e8:c8:11:64:ba:e7:19:29:3f:
                    11:b3:78:90:84:20:52:5b:11:ef:78:d0:83:f6:d5:
                    48:90:d0:30:1c:cf:80:f9:60:fe:79:e4:88:f2:dd:
                    00:eb:94:45:eb:65:94:69:40:ba:c0:d5:b4:b8:ba:
                    7d:04:11:a8:eb:31:05:96:94:4e:58:21:8e:9f:d0:
                    60:fd
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            81:3E:37:D8:92:B0:1F:77:9F:5C:B4:AB:73:AA:E7:F6:34:60:2F:FA
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Authority Key Identifier: 
            keyid:81:3E:37:D8:92:B0:1F:77:9F:5C:B4:AB:73:AA:E7:F6:34:60:2F:FA
            DirName:/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Public CA Root
            serial:01

    Signature Algorithm: sha1WithRSAEncryption
        03:f7:15:4a:f8:24:da:23:56:16:93:76:dd:36:28:b9:ae:1b:
        b8:c3:f1:64:ba:20:18:78:95:29:27:57:05:bc:7c:2a:f4:b9:
        51:55:da:87:02:de:0f:16:17:31:f8:aa:79:2e:09:13:bb:af:
        b2:20:19:12:e5:93:f9:4b:f9:83:e8:44:d5:b2:41:25:bf:88:
        75:6f:ff:10:fc:4a:54:d0:5f:f0:fa:ef:36:73:7d:1b:36:45:
        c6:21:6d:b4:15:b8:4e:cf:9c:5c:a5:3d:5a:00:8e:06:e3:3c:
        6b:32:7b:f2:9f:f0:b6:fd:df:f0:28:18:48:f0:c6:bc:d0:bf:
        34:80:96:c2:4a:b1:6d:8e:c7:90:45:de:2f:67:ac:45:04:a3:
        7a:dc:55:92:c9:47:66:d8:1a:8c:c7:ed:9c:4e:9a:e0:12:bb:
        b5:6a:4c:84:e1:e1:22:0d:87:00:64:fe:8c:7d:62:39:65:a6:
        ef:42:b6:80:25:12:61:01:a8:24:13:70:00:11:26:5f:fa:35:
        50:c5:48:cc:06:47:e8:27:d8:70:8d:5f:64:e6:a1:44:26:5e:
        22:ec:92:cd:ff:42:9a:44:21:6d:5c:c5:e3:22:1d:5f:47:12:
        e7:ce:5f:5d:fa:d8:aa:b1:33:2d:d9:76:f2:4e:3a:33:0c:2b:
        b3:2d:90:06
-----BEGIN CERTIFICATE-----
MIIEFTCCAv2gAwIBAgIBATANBgkqhkiG9w0BAQUFADBkMQswCQYDVQQGEwJTRTEU
MBIGA1UEChMLQWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFkZFRydXN0IFRUUCBOZXR3
b3JrMSAwHgYDVQQDExdBZGRUcnVzdCBQdWJsaWMgQ0EgUm9vdDAeFw0wMDA1MzAx
MDQxNTBaFw0yMDA1MzAxMDQxNTBaMGQxCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtB
ZGRUcnVzdCBBQjEdMBsGA1UECxMUQWRkVHJ1c3QgVFRQIE5ldHdvcmsxIDAeBgNV
BAMTF0FkZFRydXN0IFB1YmxpYyBDQSBSb290MIIBIjANBgkqhkiG9w0BAQEFAAOC
AQ8AMIIBCgKCAQEA6Rowj4OIFMEg2Dybjxt+A3S72mnTRqX4jsIMEZBRpS9mVEBV
6tsfSlbunyNu9DnLoblv8n75XYcmYZ4c+OLspoH4IcUkzBEMP9smcnrHAZcHF/nX
GCwwfQ56HmIexkvA/X1id9NEHif2P0tEs7c42TkfYNVRknMDtABp4/MUTu7R3AnP
dzRGULD4EfL+OHn3Bzn+UZKXC1sIXzSGAa2Il+tmzV7R/9x98oTaunet3IAIx6eH
1lWfl2royBFkuucZKT8Rs3iQhCBSWxHveNCD9tVIkNAwHM+A+WD+eeSI8t0A65RF
62WUaUC6wNW0uLp9BBGo6zEFlpROWCGOn9Bg/QIDAQABo4HRMIHOMB0GA1UdDgQW
BBSBPjfYkrAfd59ctKtzquf2NGAv+jALBgNVHQ8EBAMCAQYwDwYDVR0TAQH/BAUw
AwEB/zCBjgYDVR0jBIGGMIGDgBSBPjfYkrAfd59ctKtzquf2NGAv+qFopGYwZDEL
MAkGA1UEBhMCU0UxFDASBgNVBAoTC0FkZFRydXN0IEFCMR0wGwYDVQQLExRBZGRU
cnVzdCBUVFAgTmV0d29yazEgMB4GA1UEAxMXQWRkVHJ1c3QgUHVibGljIENBIFJv
b3SCAQEwDQYJKoZIhvcNAQEFBQADggEBAAP3FUr4JNojVhaTdt02KLmuG7jD8WS6
IBh4lSknVwW8fCr0uVFV2ocC3g8WFzH4qnkuCRO7r7IgGRLlk/lL+YPoRNWyQSW/
iHVv/xD8SlTQX/D67zZzfRs2RcYhbbQVuE7PnFylPVoAjgbjPGsye/Kf8Lb93/Ao
GEjwxrzQvzSAlsJKsW2Ox5BF3i9nrEUEo3rcVZLJR2bYGozH7ZxOmuASu7VqTITh
4SINhwBk/ox9Yjllpu9CtoAlEmEBqCQTcAARJl/6NVDFSMwGR+gn2HCNX2TmoUQm
XiLsks3/QppEIW1cxeMiHV9HEufOX1362KqxMy3ZdvJOOjMMK7MtkAY=
-----END CERTIFICATE-----
...EOF...
cat >certs/addtrust-qualified-ca-root.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Qualified CA Root
        Validity
            Not Before: May 30 10:44:50 2000 GMT
            Not After : May 30 10:44:50 2020 GMT
        Subject: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Qualified CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e4:1e:9a:fe:dc:09:5a:87:a4:9f:47:be:11:5f:
                    af:84:34:db:62:3c:79:78:b7:e9:30:b5:ec:0c:1c:
                    2a:c4:16:ff:e0:ec:71:eb:8a:f5:11:6e:ed:4f:0d:
                    91:d2:12:18:2d:49:15:01:c2:a4:22:13:c7:11:64:
                    ff:22:12:9a:b9:8e:5c:2f:08:cf:71:6a:b3:67:01:
                    59:f1:5d:46:f3:b0:78:a5:f6:0e:42:7a:e3:7f:1b:
                    cc:d0:f0:b7:28:fd:2a:ea:9e:b3:b0:b9:04:aa:fd:
                    f6:c7:b4:b1:b8:2a:a0:fb:58:f1:19:a0:6f:70:25:
                    7e:3e:69:4a:7f:0f:22:d8:ef:ad:08:11:9a:29:99:
                    e1:aa:44:45:9a:12:5e:3e:9d:6d:52:fc:e7:a0:3d:
                    68:2f:f0:4b:70:7c:13:38:ad:bc:15:25:f1:d6:ce:
                    ab:a2:c0:31:d6:2f:9f:e0:ff:14:59:fc:84:93:d9:
                    87:7c:4c:54:13:eb:9f:d1:2d:11:f8:18:3a:3a:de:
                    25:d9:f7:d3:40:ed:a4:06:12:c4:3b:e1:91:c1:56:
                    35:f0:14:dc:65:36:09:6e:ab:a4:07:c7:35:d1:c2:
                    03:33:36:5b:75:26:6d:42:f1:12:6b:43:6f:4b:71:
                    94:fa:34:1d:ed:13:6e:ca:80:7f:98:2f:6c:b9:65:
                    d8:e9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            39:95:8B:62:8B:5C:C9:D4:80:BA:58:0F:97:3F:15:08:43:CC:98:A7
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Authority Key Identifier: 
            keyid:39:95:8B:62:8B:5C:C9:D4:80:BA:58:0F:97:3F:15:08:43:CC:98:A7
            DirName:/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Qualified CA Root
            serial:01

    Signature Algorithm: sha1WithRSAEncryption
        19:ab:75:ea:f8:8b:65:61:95:13:ba:69:04:ef:86:ca:13:a0:
        c7:aa:4f:64:1b:3f:18:f6:a8:2d:2c:55:8f:05:b7:30:ea:42:
        6a:1d:c0:25:51:2d:a7:bf:0c:b3:ed:ef:08:7f:6c:3c:46:1a:
        ea:18:43:df:76:cc:f9:66:86:9c:2c:68:f5:e9:17:f8:31:b3:
        18:c4:d6:48:7d:23:4c:68:c1:7e:bb:01:14:6f:c5:d9:6e:de:
        bb:04:42:6a:f8:f6:5c:7d:e5:da:fa:87:eb:0d:35:52:67:d0:
        9e:97:76:05:93:3f:95:c7:01:e6:69:55:38:7f:10:61:99:c9:
        e3:5f:a6:ca:3e:82:63:48:aa:e2:08:48:3e:aa:f2:b2:85:62:
        a6:b4:a7:d9:bd:37:9c:68:b5:2d:56:7d:b0:b7:3f:a0:b1:07:
        d6:e9:4f:dc:de:45:71:30:32:7f:1b:2e:09:f9:bf:52:a1:ee:
        c2:80:3e:06:5c:2e:55:40:c1:1b:f5:70:45:b0:dc:5d:fa:f6:
        72:5a:77:d2:63:cd:cf:58:89:00:42:63:3f:79:39:d0:44:b0:
        82:6e:41:19:e8:dd:e0:c1:88:5a:d1:1e:71:93:1f:24:30:74:
        e5:1e:a8:de:3c:27:37:7f:83:ae:9e:77:cf:f0:30:b1:ff:4b:
        99:e8:c6:a1
-----BEGIN CERTIFICATE-----
MIIEHjCCAwagAwIBAgIBATANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJTRTEU
MBIGA1UEChMLQWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFkZFRydXN0IFRUUCBOZXR3
b3JrMSMwIQYDVQQDExpBZGRUcnVzdCBRdWFsaWZpZWQgQ0EgUm9vdDAeFw0wMDA1
MzAxMDQ0NTBaFw0yMDA1MzAxMDQ0NTBaMGcxCzAJBgNVBAYTAlNFMRQwEgYDVQQK
EwtBZGRUcnVzdCBBQjEdMBsGA1UECxMUQWRkVHJ1c3QgVFRQIE5ldHdvcmsxIzAh
BgNVBAMTGkFkZFRydXN0IFF1YWxpZmllZCBDQSBSb290MIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEA5B6a/twJWoekn0e+EV+vhDTbYjx5eLfpMLXsDBwq
xBb/4Oxx64r1EW7tTw2R0hIYLUkVAcKkIhPHEWT/IhKauY5cLwjPcWqzZwFZ8V1G
87B4pfYOQnrjfxvM0PC3KP0q6p6zsLkEqv32x7SxuCqg+1jxGaBvcCV+PmlKfw8i
2O+tCBGaKZnhqkRFmhJePp1tUvznoD1oL/BLcHwTOK28FSXx1s6rosAx1i+f4P8U
WfyEk9mHfExUE+uf0S0R+Bg6Ot4l2ffTQO2kBhLEO+GRwVY18BTcZTYJbqukB8c1
0cIDMzZbdSZtQvESa0NvS3GU+jQd7RNuyoB/mC9suWXY6QIDAQABo4HUMIHRMB0G
A1UdDgQWBBQ5lYtii1zJ1IC6WA+XPxUIQ8yYpzALBgNVHQ8EBAMCAQYwDwYDVR0T
AQH/BAUwAwEB/zCBkQYDVR0jBIGJMIGGgBQ5lYtii1zJ1IC6WA+XPxUIQ8yYp6Fr
pGkwZzELMAkGA1UEBhMCU0UxFDASBgNVBAoTC0FkZFRydXN0IEFCMR0wGwYDVQQL
ExRBZGRUcnVzdCBUVFAgTmV0d29yazEjMCEGA1UEAxMaQWRkVHJ1c3QgUXVhbGlm
aWVkIENBIFJvb3SCAQEwDQYJKoZIhvcNAQEFBQADggEBABmrder4i2VhlRO6aQTv
hsoToMeqT2QbPxj2qC0sVY8FtzDqQmodwCVRLae/DLPt7wh/bDxGGuoYQ992zPlm
hpwsaPXpF/gxsxjE1kh9I0xowX67ARRvxdlu3rsEQmr49lx95dr6h+sNNVJn0J6X
dgWTP5XHAeZpVTh/EGGZyeNfpso+gmNIquIISD6q8rKFYqa0p9m9N5xotS1WfbC3
P6CxB9bpT9zeRXEwMn8bLgn5v1Kh7sKAPgZcLlVAwRv1cEWw3F369nJad9Jjzc9Y
iQBCYz95OdBEsIJuQRno3eDBiFrRHnGTHyQwdOUeqN48Jzd/g66ed8/wMLH/S5no
xqE=
-----END CERTIFICATE-----
...EOF...
cat >certs/american-express-certificate-authority.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 141 (0x8d)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=American Express Company, Inc., OU=American Express Technologies, CN=American Express Certificate Authority
        Validity
            Not Before: Aug 14 22:01:00 1998 GMT
            Not After : Aug 14 23:59:00 2006 GMT
        Subject: C=US, O=American Express Company, Inc., OU=American Express Technologies, CN=American Express Certificate Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c9:f2:49:92:85:ca:fd:15:29:b5:06:b6:44:ec:
                    fc:88:a3:f2:86:ce:ff:14:4f:24:1c:92:f9:c2:23:
                    c1:ce:43:df:5d:34:c8:b8:14:ec:d5:2a:70:91:49:
                    95:d7:56:cd:94:f1:a9:93:d0:68:22:dc:4d:7d:a0:
                    0a:72:2a:47:ea:25:f0:85:00:5f:36:54:61:cf:0b:
                    f9:37:5a:67:9d:e9:1f:e9:64:3f:70:95:61:a7:d0:
                    30:02:de:26:28:a4:66:03:04:e9:30:fb:8f:33:07:
                    f9:6f:61:87:a2:72:db:f3:68:78:63:66:59:a9:c9:
                    b7:66:e1:15:b2:48:36:2c:f9
                Exponent: 65537 (0x10001)
    Signature Algorithm: md5WithRSAEncryption
        68:17:62:b8:73:8b:4c:6c:eb:4a:a5:3e:ab:e5:9d:2e:d2:cd:
        8a:07:57:f3:c6:59:97:76:17:17:f8:52:8e:27:93:d8:58:d8:
        28:6c:f4:a2:04:7a:8a:c2:76:24:b1:02:b4:df:28:f2:f7:f3:
        a8:a7:7e:23:48:61:88:f4:11:68:ae:26:5d:f6:a1:4b:53:25:
        6a:d8:2a:14:02:0e:e0:87:20:6e:9e:19:5c:73:90:0b:23:e2:
        31:97:23:3f:d5:22:a2:d3:06:7b:da:37:f5:d7:b5:41:44:17:
        7a:45:02:d9:85:45:66:d6:8e:c7:f0:7a:0c:99:62:22:69:5b:
        ed:d2
-----BEGIN CERTIFICATE-----
MIICkDCCAfkCAgCNMA0GCSqGSIb3DQEBBAUAMIGPMQswCQYDVQQGEwJVUzEnMCUG
A1UEChMeQW1lcmljYW4gRXhwcmVzcyBDb21wYW55LCBJbmMuMSYwJAYDVQQLEx1B
bWVyaWNhbiBFeHByZXNzIFRlY2hub2xvZ2llczEvMC0GA1UEAxMmQW1lcmljYW4g
RXhwcmVzcyBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNOTgwODE0MjIwMTAwWhcN
MDYwODE0MjM1OTAwWjCBjzELMAkGA1UEBhMCVVMxJzAlBgNVBAoTHkFtZXJpY2Fu
IEV4cHJlc3MgQ29tcGFueSwgSW5jLjEmMCQGA1UECxMdQW1lcmljYW4gRXhwcmVz
cyBUZWNobm9sb2dpZXMxLzAtBgNVBAMTJkFtZXJpY2FuIEV4cHJlc3MgQ2VydGlm
aWNhdGUgQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJ8kmS
hcr9FSm1BrZE7PyIo/KGzv8UTyQckvnCI8HOQ99dNMi4FOzVKnCRSZXXVs2U8amT
0Ggi3E19oApyKkfqJfCFAF82VGHPC/k3Wmed6R/pZD9wlWGn0DAC3iYopGYDBOkw
+48zB/lvYYeictvzaHhjZlmpybdm4RWySDYs+QIDAQABMA0GCSqGSIb3DQEBBAUA
A4GBAGgXYrhzi0xs60qlPqvlnS7SzYoHV/PGWZd2Fxf4Uo4nk9hY2Chs9KIEeorC
diSxArTfKPL386infiNIYYj0EWiuJl32oUtTJWrYKhQCDuCHIG6eGVxzkAsj4jGX
Iz/VIqLTBnvaN/XXtUFEF3pFAtmFRWbWjsfwegyZYiJpW+3S
-----END CERTIFICATE-----
...EOF...
cat >certs/american-express-global-certificate.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 133 (0x85)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=American Express Company, Inc., OU=American Express Technologies, CN=American Express Global Certificate Authority
        Validity
            Not Before: Aug 14 19:06:00 1998 GMT
            Not After : Aug 14 23:59:00 2013 GMT
        Subject: C=US, O=American Express Company, Inc., OU=American Express Technologies, CN=American Express Global Certificate Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:f0:24:26:66:2e:fb:eb:4a:73:71:53:89:47:cb:
                    26:3c:53:92:94:4c:ca:c2:85:b5:0d:f8:c3:57:bd:
                    2f:2a:1f:6a:18:b7:57:af:0c:00:16:fa:a0:b6:90:
                    a6:f7:1a:a1:2e:66:26:c7:68:a3:8a:93:69:66:b5:
                    46:56:2d:1d:82:ea:90:0c:0a:22:c2:89:50:8d:05:
                    f3:d4:ab:73:41:f0:cf:12:ac:28:b4:6f:14:94:96:
                    59:4b:9e:90:75:86:df:e2:47:eb:e1:e9:4f:43:7e:
                    87:ca:27:18:66:9e:b5:c1:40:65:7d:fc:61:6f:ad:
                    9b:72:cf:a9:5e:d8:f3:f9:da:6e:91:10:fa:4c:b5:
                    ea:7e:20:de:a9:39:2f:f5:88:e4:8a:6f:35:c6:20:
                    9c:2b:86:46:33:0a:fc:31:55:a5:6b:ac:16:40:e9:
                    cd:35:59:6f:32:04:c3:7b:b5:0f:7b:77:70:f3:48:
                    bb:2a:52:82:ce:af:29:6d:f1:11:6f:6d:e6:07:00:
                    01:ef:9a:f3:26:0d:a6:79:13:67:af:f8:ab:1c:75:
                    ac:91:b5:6b:be:40:b0:de:9c:0c:b1:69:85:19:71:
                    91:13:45:ca:df:d1:fd:e6:b2:ca:96:83:79:db:c5:
                    b8:aa:5b:7a:90:0b:78:56:3e:c6:d7:9f:94:48:11:
                    f5:ad
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE, pathlen:5
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Certificate Policies: 
            Policy: 1.2.840.113807.10.1.5.1

            X509v3 Subject Key Identifier: 
            57:47:35:7B:36:27:11:A8:08:FC:2F:46:25:EB:24:69
    Signature Algorithm: sha1WithRSAEncryption
        c7:61:45:a8:8a:71:b9:be:34:e9:21:7b:21:cd:56:13:98:d5:
        30:63:e9:18:aa:4b:92:15:bf:0b:1d:bb:ec:92:69:c5:2e:c3:
        61:8b:e8:30:45:cb:10:46:c1:73:38:5c:8b:19:d2:2b:f3:40:
        eb:7c:72:b3:2e:1e:27:e3:75:95:8a:1c:9b:2e:c4:95:05:86:
        72:d0:55:f4:a1:92:52:79:5c:db:f4:f8:dc:e5:d7:12:b1:40:
        c7:3c:86:e4:31:65:4a:ca:37:c6:de:76:57:19:69:4c:46:69:
        fc:2a:ad:16:37:7a:93:ac:f7:21:4b:2d:fb:eb:a9:50:cb:c1:
        d1:40:08:da:03:69:87:a7:37:5e:55:c1:c5:ed:c4:e3:8e:0c:
        26:97:9b:5c:57:4b:72:e3:f2:03:05:d0:02:3b:26:03:40:90:
        9e:be:0b:5b:49:0c:78:f1:d5:4c:55:29:e0:f6:fd:4c:03:a9:
        54:02:32:d1:57:5a:85:ac:43:ed:5b:3b:16:5f:a0:bf:35:db:
        4b:9e:7b:e8:ff:e7:0d:3c:3b:a8:9b:49:41:46:f5:73:4e:ff:
        92:65:21:83:13:55:71:eb:49:3c:7f:88:1a:c2:12:28:25:a1:
        46:4b:41:37:97:7f:ec:8e:f1:d4:a1:96:c2:20:b6:5e:ad:a9:
        1c:1e:11:a0
-----BEGIN CERTIFICATE-----
MIIEBDCCAuygAwIBAgICAIUwDQYJKoZIhvcNAQEFBQAwgZYxCzAJBgNVBAYTAlVT
MScwJQYDVQQKEx5BbWVyaWNhbiBFeHByZXNzIENvbXBhbnksIEluYy4xJjAkBgNV
BAsTHUFtZXJpY2FuIEV4cHJlc3MgVGVjaG5vbG9naWVzMTYwNAYDVQQDEy1BbWVy
aWNhbiBFeHByZXNzIEdsb2JhbCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNOTgw
ODE0MTkwNjAwWhcNMTMwODE0MjM1OTAwWjCBljELMAkGA1UEBhMCVVMxJzAlBgNV
BAoTHkFtZXJpY2FuIEV4cHJlc3MgQ29tcGFueSwgSW5jLjEmMCQGA1UECxMdQW1l
cmljYW4gRXhwcmVzcyBUZWNobm9sb2dpZXMxNjA0BgNVBAMTLUFtZXJpY2FuIEV4
cHJlc3MgR2xvYmFsIENlcnRpZmljYXRlIEF1dGhvcml0eTCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBAPAkJmYu++tKc3FTiUfLJjxTkpRMysKFtQ34w1e9
Lyofahi3V68MABb6oLaQpvcaoS5mJsdoo4qTaWa1RlYtHYLqkAwKIsKJUI0F89Sr
c0HwzxKsKLRvFJSWWUuekHWG3+JH6+HpT0N+h8onGGaetcFAZX38YW+tm3LPqV7Y
8/nabpEQ+ky16n4g3qk5L/WI5IpvNcYgnCuGRjMK/DFVpWusFkDpzTVZbzIEw3u1
D3t3cPNIuypSgs6vKW3xEW9t5gcAAe+a8yYNpnkTZ6/4qxx1rJG1a75AsN6cDLFp
hRlxkRNFyt/R/eayypaDedvFuKpbepALeFY+xteflEgR9a0CAwEAAaNaMFgwEgYD
VR0TAQH/BAgwBgEB/wIBBTAOBgNVHQ8BAf8EBAMCAQYwFwYDVR0gBBAwDjAMBgoq
hkiG+Q8KAQUBMBkGA1UdDgQSBBBXRzV7NicRqAj8L0Yl6yRpMA0GCSqGSIb3DQEB
BQUAA4IBAQDHYUWoinG5vjTpIXshzVYTmNUwY+kYqkuSFb8LHbvskmnFLsNhi+gw
RcsQRsFzOFyLGdIr80DrfHKzLh4n43WVihybLsSVBYZy0FX0oZJSeVzb9Pjc5dcS
sUDHPIbkMWVKyjfG3nZXGWlMRmn8Kq0WN3qTrPchSy3766lQy8HRQAjaA2mHpzde
VcHF7cTjjgwml5tcV0ty4/IDBdACOyYDQJCevgtbSQx48dVMVSng9v1MA6lUAjLR
V1qFrEPtWzsWX6C/NdtLnnvo/+cNPDuom0lBRvVzTv+SZSGDE1Vx60k8f4gawhIo
JaFGS0E3l3/sjvHUoZbCILZerakcHhGg
-----END CERTIFICATE-----
...EOF...
cat >certs/baltimore-cybertrust-code-signing.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 33554623 (0x20000bf)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Code Signing Root
        Validity
            Not Before: May 17 14:01:00 2000 GMT
            Not After : May 17 23:59:00 2025 GMT
        Subject: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Code Signing Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c8:71:9a:18:12:8e:7a:db:f9:9a:fc:41:af:d8:
                    f2:f4:09:8e:ad:3f:fe:67:37:3c:da:c9:26:50:b1:
                    b1:3e:cb:e8:4e:73:00:f2:b2:dc:f3:c5:46:fb:09:
                    ef:18:96:ce:a7:e0:9c:84:5d:20:0e:7a:a0:aa:36:
                    8b:fa:28:b6:78:2e:b3:ec:e8:47:f3:04:f0:90:23:
                    b4:ea:af:e5:53:b8:05:f7:47:5d:2b:86:f1:a7:a4:
                    c6:3b:35:b6:d2:0d:52:41:d7:f4:92:75:e1:a2:0a:
                    50:56:87:be:97:0b:7b:33:85:10:b9:28:18:ee:33:
                    ea:48:11:d7:5b:91:47:76:22:d4:ee:cf:5d:e7:a8:
                    4e:1c:9d:96:91:dd:9c:bd:74:09:a8:72:61:aa:b0:
                    21:3a:f1:3d:2c:03:56:09:d2:c1:dc:c3:b5:c7:54:
                    37:ab:e6:26:a2:b2:46:71:73:ca:11:88:ee:bc:e7:
                    64:f7:d0:11:1a:73:40:5a:c8:49:2c:0f:b7:ef:90:
                    7f:68:80:04:38:0b:1b:0f:3b:d4:f5:a0:b3:c2:8e:
                    e1:34:b4:80:99:6d:9e:76:d4:92:29:40:b1:95:d2:
                    37:a4:67:12:7f:e0:62:bb:ae:35:c5:99:36:82:44:
                    b8:e6:78:18:33:61:71:93:5b:2d:8d:9f:78:95:82:
                    eb:6d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Extended Key Usage: 
            Code Signing
            X509v3 Subject Key Identifier: 
            C8:41:34:5C:15:15:04:E5:40:F2:D1:AB:9A:6F:24:92:7A:87:42:5A
            X509v3 Basic Constraints: critical
            CA:TRUE, pathlen:3
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        52:74:aa:95:4b:22:8c:c7:3d:96:a4:fe:5d:fa:2f:b5:bc:eb:
        f0:0b:e9:56:38:1d:d1:6d:0d:a1:bc:68:8b:f0:c5:80:a5:24:
        34:fd:f2:96:18:11:86:a1:36:f5:37:e7:54:40:d5:64:1f:c3:
        5f:70:42:6b:2d:39:c7:9e:52:05:ce:e7:6a:72:d2:8d:72:3f:
        47:50:83:ab:c7:8d:25:c9:b0:e3:a7:53:16:95:a6:6a:53:ea:
        18:9d:8f:78:a9:77:77:1a:f9:b4:97:47:59:88:27:28:b5:ca:
        e1:2e:d7:3e:0e:a2:0d:b8:22:44:03:e3:d1:63:b0:41:3a:a1:
        f5:a4:2d:f7:76:1e:04:54:99:78:32:40:d7:2b:7c:4d:ba:a6:
        9c:b0:79:6e:07:be:8c:ec:ee:d7:38:69:5b:c1:0c:56:68:9f:
        fe:eb:d1:e1:c8:88:f9:f2:cd:7f:be:85:b4:44:67:00:50:3e:
        f4:26:03:64:ea:77:7d:e8:5e:3e:1c:37:47:c8:d6:ea:a4:f3:
        36:3c:97:c2:39:72:05:94:19:25:c3:d7:37:41:0f:c1:1f:87:
        8a:fd:aa:be:e9:b1:64:57:e4:db:92:a1:cf:e1:49:e8:3b:1f:
        91:13:5a:c3:8f:d9:25:58:49:80:47:0f:c6:03:ae:ac:e3:bf:
        b7:c0:aa:2a
-----BEGIN CERTIFICATE-----
MIIDpjCCAo6gAwIBAgIEAgAAvzANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJJ
RTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MS8wLQYD
VQQDEyZCYWx0aW1vcmUgQ3liZXJUcnVzdCBDb2RlIFNpZ25pbmcgUm9vdDAeFw0w
MDA1MTcxNDAxMDBaFw0yNTA1MTcyMzU5MDBaMGcxCzAJBgNVBAYTAklFMRIwEAYD
VQQKEwlCYWx0aW1vcmUxEzARBgNVBAsTCkN5YmVyVHJ1c3QxLzAtBgNVBAMTJkJh
bHRpbW9yZSBDeWJlclRydXN0IENvZGUgU2lnbmluZyBSb290MIIBIjANBgkqhkiG
9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyHGaGBKOetv5mvxBr9jy9AmOrT/+Zzc82skm
ULGxPsvoTnMA8rLc88VG+wnvGJbOp+CchF0gDnqgqjaL+ii2eC6z7OhH8wTwkCO0
6q/lU7gF90ddK4bxp6TGOzW20g1SQdf0knXhogpQVoe+lwt7M4UQuSgY7jPqSBHX
W5FHdiLU7s9d56hOHJ2Wkd2cvXQJqHJhqrAhOvE9LANWCdLB3MO1x1Q3q+YmorJG
cXPKEYjuvOdk99ARGnNAWshJLA+375B/aIAEOAsbDzvU9aCzwo7hNLSAmW2edtSS
KUCxldI3pGcSf+Biu641xZk2gkS45ngYM2Fxk1stjZ94lYLrbQIDAQABo1owWDAT
BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUyEE0XBUVBOVA8tGrmm8kknqH
QlowEgYDVR0TAQH/BAgwBgEB/wIBAzAOBgNVHQ8BAf8EBAMCAQYwDQYJKoZIhvcN
AQEFBQADggEBAFJ0qpVLIozHPZak/l36L7W86/AL6VY4HdFtDaG8aIvwxYClJDT9
8pYYEYahNvU351RA1WQfw19wQmstOceeUgXO52py0o1yP0dQg6vHjSXJsOOnUxaV
pmpT6hidj3ipd3ca+bSXR1mIJyi1yuEu1z4Oog24IkQD49FjsEE6ofWkLfd2HgRU
mXgyQNcrfE26ppyweW4Hvozs7tc4aVvBDFZon/7r0eHIiPnyzX++hbREZwBQPvQm
A2Tqd33oXj4cN0fI1uqk8zY8l8I5cgWUGSXD1zdBD8Efh4r9qr7psWRX5NuSoc/h
Seg7H5ETWsOP2SVYSYBHD8YDrqzjv7fAqio=
-----END CERTIFICATE-----
...EOF...
cat >certs/baltimore-cybertrust-mobile-root.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 33554616 (0x20000b8)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Mobile Root
        Validity
            Not Before: May 12 18:20:00 2000 GMT
            Not After : May 12 23:59:00 2020 GMT
        Subject: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Mobile Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:a3:6d:b1:38:56:ac:fc:b5:56:21:de:c0:90:5d:
                    26:47:82:c6:7d:8f:1f:a0:85:8f:2f:bb:d4:e1:1c:
                    1d:f2:24:1f:28:b0:2f:b9:a4:a5:6f:a2:22:20:64:
                    fe:84:47:3c:7e:2b:6c:69:6a:b8:d4:c0:96:8e:8c:
                    52:0d:cd:6f:41:d4:bf:04:ae:a7:81:2f:2d:98:48:
                    d2:c1:94:a3:b5:19:5d:5d:51:64:f4:8e:41:b0:9b:
                    c0:2d:22:a0:5e:c6:d8:5a:12:63:bc:11:4a:5e:26:
                    12:1d:e2:26:05:e6:0f:5f:22:1f:7a:5f:76:94:ae:
                    cf:5a:28:0e:ab:45:da:22:31
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            C9:E2:8F:C0:02:26:5A:B6:C0:07:E3:7F:94:07:18:DB:2E:A5:9A:70
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Key Usage: critical
            Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        53:08:0b:26:09:78:42:73:d4:ec:7a:77:47:0d:e3:0b:33:71:
        ef:ae:33:14:4d:fb:fa:fd:1a:b7:51:f5:e4:99:1c:06:71:d7:
        29:19:d7:e6:15:20:51:51:46:6d:4f:de:18:49:98:d0:f8:78:
        bb:71:e8:8d:01:06:d5:d7:64:8f:94:df:47:fe:a0:85:69:36:
        a9:2f:42:7a:68:4a:12:d6:8b:0b:70:44:0a:a4:04:ef:26:88:
        c1:35:71:38:5d:1b:5b:48:42:f0:e7:94:1c:70:95:34:a8:ab:
        f5:ab:e2:78:ad:f5:f0:52:fd:9b:ea:42:0c:e8:d8:54:be:53:
        66:f5
-----BEGIN CERTIFICATE-----
MIICfTCCAeagAwIBAgIEAgAAuDANBgkqhkiG9w0BAQUFADBhMQswCQYDVQQGEwJJ
RTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSkwJwYD
VQQDEyBCYWx0aW1vcmUgQ3liZXJUcnVzdCBNb2JpbGUgUm9vdDAeFw0wMDA1MTIx
ODIwMDBaFw0yMDA1MTIyMzU5MDBaMGExCzAJBgNVBAYTAklFMRIwEAYDVQQKEwlC
YWx0aW1vcmUxEzARBgNVBAsTCkN5YmVyVHJ1c3QxKTAnBgNVBAMTIEJhbHRpbW9y
ZSBDeWJlclRydXN0IE1vYmlsZSBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
iQKBgQCjbbE4Vqz8tVYh3sCQXSZHgsZ9jx+ghY8vu9ThHB3yJB8osC+5pKVvoiIg
ZP6ERzx+K2xparjUwJaOjFINzW9B1L8ErqeBLy2YSNLBlKO1GV1dUWT0jkGwm8At
IqBexthaEmO8EUpeJhId4iYF5g9fIh96X3aUrs9aKA6rRdoiMQIDAQABo0IwQDAd
BgNVHQ4EFgQUyeKPwAImWrbAB+N/lAcY2y6lmnAwDwYDVR0TAQH/BAUwAwEB/zAO
BgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQEFBQADgYEAUwgLJgl4QnPU7Hp3Rw3j
CzNx764zFE37+v0at1H15JkcBnHXKRnX5hUgUVFGbU/eGEmY0Ph4u3HojQEG1ddk
j5TfR/6ghWk2qS9CemhKEtaLC3BECqQE7yaIwTVxOF0bW0hC8OeUHHCVNKir9avi
eK318FL9m+pCDOjYVL5TZvU=
-----END CERTIFICATE-----
...EOF...
cat >certs/baltimore-cybertrust-root.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 33554617 (0x20000b9)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root
        Validity
            Not Before: May 12 18:46:00 2000 GMT
            Not After : May 12 23:59:00 2025 GMT
        Subject: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a3:04:bb:22:ab:98:3d:57:e8:26:72:9a:b5:79:
                    d4:29:e2:e1:e8:95:80:b1:b0:e3:5b:8e:2b:29:9a:
                    64:df:a1:5d:ed:b0:09:05:6d:db:28:2e:ce:62:a2:
                    62:fe:b4:88:da:12:eb:38:eb:21:9d:c0:41:2b:01:
                    52:7b:88:77:d3:1c:8f:c7:ba:b9:88:b5:6a:09:e7:
                    73:e8:11:40:a7:d1:cc:ca:62:8d:2d:e5:8f:0b:a6:
                    50:d2:a8:50:c3:28:ea:f5:ab:25:87:8a:9a:96:1c:
                    a9:67:b8:3f:0c:d5:f7:f9:52:13:2f:c2:1b:d5:70:
                    70:f0:8f:c0:12:ca:06:cb:9a:e1:d9:ca:33:7a:77:
                    d6:f8:ec:b9:f1:68:44:42:48:13:d2:c0:c2:a4:ae:
                    5e:60:fe:b6:a6:05:fc:b4:dd:07:59:02:d4:59:18:
                    98:63:f5:a5:63:e0:90:0c:7d:5d:b2:06:7a:f3:85:
                    ea:eb:d4:03:ae:5e:84:3e:5f:ff:15:ed:69:bc:f9:
                    39:36:72:75:cf:77:52:4d:f3:c9:90:2c:b9:3d:e5:
                    c9:23:53:3f:1f:24:98:21:5c:07:99:29:bd:c6:3a:
                    ec:e7:6e:86:3a:6b:97:74:63:33:bd:68:18:31:f0:
                    78:8d:76:bf:fc:9e:8e:5d:2a:86:a7:4d:90:dc:27:
                    1a:39
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            E5:9D:59:30:82:47:58:CC:AC:FA:08:54:36:86:7B:3A:B5:04:4D:F0
            X509v3 Basic Constraints: critical
            CA:TRUE, pathlen:3
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        85:0c:5d:8e:e4:6f:51:68:42:05:a0:dd:bb:4f:27:25:84:03:
        bd:f7:64:fd:2d:d7:30:e3:a4:10:17:eb:da:29:29:b6:79:3f:
        76:f6:19:13:23:b8:10:0a:f9:58:a4:d4:61:70:bd:04:61:6a:
        12:8a:17:d5:0a:bd:c5:bc:30:7c:d6:e9:0c:25:8d:86:40:4f:
        ec:cc:a3:7e:38:c6:37:11:4f:ed:dd:68:31:8e:4c:d2:b3:01:
        74:ee:be:75:5e:07:48:1a:7f:70:ff:16:5c:84:c0:79:85:b8:
        05:fd:7f:be:65:11:a3:0f:c0:02:b4:f8:52:37:39:04:d5:a9:
        31:7a:18:bf:a0:2a:f4:12:99:f7:a3:45:82:e3:3c:5e:f5:9d:
        9e:b5:c8:9e:7c:2e:c8:a4:9e:4e:08:14:4b:6d:fd:70:6d:6b:
        1a:63:bd:64:e6:1f:b7:ce:f0:f2:9f:2e:bb:1b:b7:f2:50:88:
        73:92:c2:e2:e3:16:8d:9a:32:02:ab:8e:18:dd:e9:10:11:ee:
        7e:35:ab:90:af:3e:30:94:7a:d0:33:3d:a7:65:0f:f5:fc:8e:
        9e:62:cf:47:44:2c:01:5d:bb:1d:b5:32:d2:47:d2:38:2e:d0:
        fe:81:dc:32:6a:1e:b5:ee:3c:d5:fc:e7:81:1d:19:c3:24:42:
        ea:63:39:a9
-----BEGIN CERTIFICATE-----
MIIDdzCCAl+gAwIBAgIEAgAAuTANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJJ
RTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSIwIAYD
VQQDExlCYWx0aW1vcmUgQ3liZXJUcnVzdCBSb290MB4XDTAwMDUxMjE4NDYwMFoX
DTI1MDUxMjIzNTkwMFowWjELMAkGA1UEBhMCSUUxEjAQBgNVBAoTCUJhbHRpbW9y
ZTETMBEGA1UECxMKQ3liZXJUcnVzdDEiMCAGA1UEAxMZQmFsdGltb3JlIEN5YmVy
VHJ1c3QgUm9vdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKMEuyKr
mD1X6CZymrV51Cni4eiVgLGw41uOKymaZN+hXe2wCQVt2yguzmKiYv60iNoS6zjr
IZ3AQSsBUnuId9Mcj8e6uYi1agnnc+gRQKfRzMpijS3ljwumUNKoUMMo6vWrJYeK
mpYcqWe4PwzV9/lSEy/CG9VwcPCPwBLKBsua4dnKM3p31vjsufFoREJIE9LAwqSu
XmD+tqYF/LTdB1kC1FkYmGP1pWPgkAx9XbIGevOF6uvUA65ehD5f/xXtabz5OTZy
dc93Uk3zyZAsuT3lySNTPx8kmCFcB5kpvcY67Oduhjprl3RjM71oGDHweI12v/ye
jl0qhqdNkNwnGjkCAwEAAaNFMEMwHQYDVR0OBBYEFOWdWTCCR1jMrPoIVDaGezq1
BE3wMBIGA1UdEwEB/wQIMAYBAf8CAQMwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3
DQEBBQUAA4IBAQCFDF2O5G9RaEIFoN27TyclhAO992T9Ldcw46QQF+vaKSm2eT92
9hkTI7gQCvlYpNRhcL0EYWoSihfVCr3FvDB81ukMJY2GQE/szKN+OMY3EU/t3Wgx
jkzSswF07r51XgdIGn9w/xZchMB5hbgF/X++ZRGjD8ACtPhSNzkE1akxehi/oCr0
Epn3o0WC4zxe9Z2etciefC7IpJ5OCBRLbf1wbWsaY71k5h+3zvDyny67G7fyUIhz
ksLi4xaNmjICq44Y3ekQEe5+NauQrz4wlHrQMz2nZQ/1/I6eYs9HRCwBXbsdtTLS
R9I4LtD+gdwyah617jzV/OeBHRnDJELqYzmp
-----END CERTIFICATE-----
...EOF...
cat >certs/bankengine.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CA, ST=ON, L=Toronto, O=BankEngine Inc., OU=Certification Authority Division, CN=bankengine/emailAddress=ca@bankengine.com
        Validity
            Not Before: Jan  1 00:00:00 1998 GMT
            Not After : Jan 17 00:00:00 2038 GMT
        Subject: C=CA, ST=ON, L=Toronto, O=BankEngine Inc., OU=Certification Authority Division, CN=bankengine/emailAddress=ca@bankengine.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:d7:82:e8:4d:40:25:d7:f8:44:cb:e2:a1:d6:42:
                    c7:88:17:56:db:30:f7:57:82:21:33:bc:71:4d:52:
                    ac:62:c2:07:e7:a9:eb:eb:d0:13:4c:8c:54:3f:7e:
                    9e:47:37:99:d7:7e:ea:b7:50:31:1c:58:c3:0a:27:
                    64:de:6d:54:97:a9:79:f4:fa:e8:3d:ec:5d:b2:52:
                    cb:33:69:e9:33:77:f6:72:d7:a0:fa:da:32:89:88:
                    92:10:92:a3:cb:32:2e:d7:11:75:8f:da:b3:1a:4c:
                    a6:49:8f:f8:0e:c5:cb:64:d9:3d:15:a7:33:c4:c9:
                    3f:3a:87:3a:3a:cd:4c:dc:0b:de:ac:be:15:1b:8a:
                    d8:21:be:9f:79:1d:f6:70:82:89:f5:0d:5f:1a:ec:
                    8a:93:b8:a9:ab:55:d0:7c:f5:bc:6b:c4:e0:65:d6:
                    c7:6d:ee:d4:f4:69:37:89:ab:06:30:71:ef:a5:1f:
                    44:a7:79:86:6e:07:53:b9:0f:7c:48:11:2e:23:07:
                    b5:05:40:86:83:f3:17:a5:5c:b8:f0:c3:57:7c:03:
                    28:b4:18:06:c3:8a:65:f7:2a:92:8c:c9:e2:d8:50:
                    7e:13:d4:3d:0c:71:6c:d9:18:17:32:ac:ca:ba:8f:
                    33:70:fc:4a:c7:69:19:e8:0a:e3:f3:ed:bb:77:0d:
                    9c:95
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        5a:ba:ea:47:5f:d1:21:a4:2f:eb:e7:b7:7a:6f:99:24:79:6b:
        e8:82:7c:48:3f:df:ff:4c:ee:22:c3:7a:9b:cc:85:c4:90:f5:
        e6:26:6c:15:ce:5c:e8:28:95:aa:8b:26:be:6b:0d:7d:48:fd:
        3e:1b:a0:b3:b0:53:81:a3:ff:5e:86:6c:fe:85:9f:1b:85:85:
        f8:32:39:56:cd:7e:6e:4e:79:21:cf:5e:f6:8f:d7:ce:05:49:
        ab:4d:53:e4:71:12:2c:eb:38:c2:0f:93:d0:00:6a:01:3c:fd:
        7f:65:dc:b6:37:7e:a5:67:45:3b:96:0d:3b:3a:98:ab:8f:fc:
        89:3d:22:5e:33:68:f4:7f:02:05:02:ba:22:55:c9:2f:75:3d:
        01:57:00:7a:4b:f7:0f:68:04:06:3e:08:5b:6e:bd:58:19:29:
        98:ac:ca:e2:4a:ff:36:e4:82:c9:51:fc:73:ac:96:2e:9c:64:
        7d:16:26:3d:39:be:fe:8f:02:70:89:93:12:e0:2c:52:3e:4b:
        6e:b7:1a:ff:de:13:af:af:5f:80:2d:2e:c8:71:56:a4:86:10:
        37:3e:e6:40:25:b7:47:15:17:25:47:da:8c:33:c6:81:9c:16:
        66:7f:e5:2f:dc:ad:ee:85:3f:94:07:3c:d8:eb:9e:14:f5:88:
        b5:25:89:c0
-----BEGIN CERTIFICATE-----
MIID3TCCAsWgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBqDELMAkGA1UEBhMCQ0Ex
CzAJBgNVBAgTAk9OMRAwDgYDVQQHEwdUb3JvbnRvMRgwFgYDVQQKEw9CYW5rRW5n
aW5lIEluYy4xKTAnBgNVBAsTIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IERpdmlz
aW9uMRMwEQYDVQQDEwpiYW5rZW5naW5lMSAwHgYJKoZIhvcNAQkBFhFjYUBiYW5r
ZW5naW5lLmNvbTAeFw05ODAxMDEwMDAwMDBaFw0zODAxMTcwMDAwMDBaMIGoMQsw
CQYDVQQGEwJDQTELMAkGA1UECBMCT04xEDAOBgNVBAcTB1Rvcm9udG8xGDAWBgNV
BAoTD0JhbmtFbmdpbmUgSW5jLjEpMCcGA1UECxMgQ2VydGlmaWNhdGlvbiBBdXRo
b3JpdHkgRGl2aXNpb24xEzARBgNVBAMTCmJhbmtlbmdpbmUxIDAeBgkqhkiG9w0B
CQEWEWNhQGJhbmtlbmdpbmUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
CgKCAQEA14LoTUAl1/hEy+Kh1kLHiBdW2zD3V4IhM7xxTVKsYsIH56nr69ATTIxU
P36eRzeZ137qt1AxHFjDCidk3m1Ul6l59ProPexdslLLM2npM3f2cteg+toyiYiS
EJKjyzIu1xF1j9qzGkymSY/4DsXLZNk9FaczxMk/Ooc6Os1M3AverL4VG4rYIb6f
eR32cIKJ9Q1fGuyKk7ipq1XQfPW8a8TgZdbHbe7U9Gk3iasGMHHvpR9Ep3mGbgdT
uQ98SBEuIwe1BUCGg/MXpVy48MNXfAMotBgGw4pl9yqSjMni2FB+E9Q9DHFs2RgX
MqzKuo8zcPxKx2kZ6Arj8+27dw2clQIDAQABoxAwDjAMBgNVHRMEBTADAQH/MA0G
CSqGSIb3DQEBBQUAA4IBAQBauupHX9EhpC/r57d6b5kkeWvognxIP9//TO4iw3qb
zIXEkPXmJmwVzlzoKJWqiya+aw19SP0+G6CzsFOBo/9ehmz+hZ8bhYX4MjlWzX5u
Tnkhz172j9fOBUmrTVPkcRIs6zjCD5PQAGoBPP1/Zdy2N36lZ0U7lg07Opirj/yJ
PSJeM2j0fwIFAroiVckvdT0BVwB6S/cPaAQGPghbbr1YGSmYrMriSv825ILJUfxz
rJYunGR9FiY9Ob7+jwJwiZMS4CxSPktutxr/3hOvr1+ALS7IcVakhhA3PuZAJbdH
FRclR9qMM8aBnBZmf+Uv3K3uhT+UBzzY654U9Yi1JYnA
-----END CERTIFICATE-----
...EOF...
cat >certs/belsign-object-publishing-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, L=Brussels, O=BelSign NV, OU=BelSign Object Publishing Certificate Authority, CN=BelSign Object Publishing CA/emailAddress=webmaster@belsign.be
        Validity
            Not Before: Sep 19 22:03:00 1997 GMT
            Not After : Sep 19 22:03:00 2007 GMT
        Subject: C=BE, L=Brussels, O=BelSign NV, OU=BelSign Object Publishing Certificate Authority, CN=BelSign Object Publishing CA/emailAddress=webmaster@belsign.be
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c4:2e:1f:b6:bf:ee:82:40:dd:f9:b7:2e:41:d5:
                    9e:05:b1:5a:d0:26:7c:62:55:03:9b:fc:cb:61:de:
                    4b:ef:fe:e8:99:fe:87:b9:88:cf:90:da:0f:09:3c:
                    76:df:17:97:b6:cb:3f:25:45:fd:b4:bc:58:00:be:
                    b0:5a:b6:14:87:8f:ee:67:64:ad:1d:88:83:bb:67:
                    9f:65:61:00:58:08:80:50:9f:80:c9:31:f6:2a:90:
                    1c:2d:f7:4a:6c:10:f6:23:43:5d:38:09:60:88:57:
                    02:cd:16:6c:18:fc:cd:fb:92:2a:77:d0:9e:93:a3:
                    5d:88:64:d0:c8:f8:5d:54:51
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        63:76:17:7c:96:f0:53:a5:5d:01:1c:53:ce:29:c2:7e:75:ac:
        4c:0d:a2:08:73:b4:6a:31:fd:02:06:14:99:dc:54:04:a4:bf:
        c8:96:86:9f:31:43:32:25:57:f6:85:f6:25:bb:37:be:a1:79:
        23:c9:57:06:25:71:6b:45:4f:f8:f4:02:40:16:82:22:af:54:
        ea:32:28:f6:0d:ee:99:ba:4b:08:51:0f:6e:86:23:21:4c:2d:
        25:88:81:c4:2e:0e:f1:13:2c:38:8a:95:02:24:c3:3a:95:63:
        e4:93:8e:48:bb:08:47:72:5f:ae:e6:3a:5a:47:d6:71:c6:9e:
        9a:52
-----BEGIN CERTIFICATE-----
MIIDAzCCAmygAwIBAgIBATANBgkqhkiG9w0BAQQFADCBuzELMAkGA1UEBhMCQkUx
ETAPBgNVBAcTCEJydXNzZWxzMRMwEQYDVQQKEwpCZWxTaWduIE5WMTgwNgYDVQQL
Ey9CZWxTaWduIE9iamVjdCBQdWJsaXNoaW5nIENlcnRpZmljYXRlIEF1dGhvcml0
eTElMCMGA1UEAxMcQmVsU2lnbiBPYmplY3QgUHVibGlzaGluZyBDQTEjMCEGCSqG
SIb3DQEJARYUd2VibWFzdGVyQGJlbHNpZ24uYmUwHhcNOTcwOTE5MjIwMzAwWhcN
MDcwOTE5MjIwMzAwWjCBuzELMAkGA1UEBhMCQkUxETAPBgNVBAcTCEJydXNzZWxz
MRMwEQYDVQQKEwpCZWxTaWduIE5WMTgwNgYDVQQLEy9CZWxTaWduIE9iamVjdCBQ
dWJsaXNoaW5nIENlcnRpZmljYXRlIEF1dGhvcml0eTElMCMGA1UEAxMcQmVsU2ln
biBPYmplY3QgUHVibGlzaGluZyBDQTEjMCEGCSqGSIb3DQEJARYUd2VibWFzdGVy
QGJlbHNpZ24uYmUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMQuH7a/7oJA
3fm3LkHVngWxWtAmfGJVA5v8y2HeS+/+6Jn+h7mIz5DaDwk8dt8Xl7bLPyVF/bS8
WAC+sFq2FIeP7mdkrR2Ig7tnn2VhAFgIgFCfgMkx9iqQHC33SmwQ9iNDXTgJYIhX
As0WbBj8zfuSKnfQnpOjXYhk0Mj4XVRRAgMBAAGjFTATMBEGCWCGSAGG+EIBAQQE
AwIABzANBgkqhkiG9w0BAQQFAAOBgQBjdhd8lvBTpV0BHFPOKcJ+daxMDaIIc7Rq
Mf0CBhSZ3FQEpL/IloafMUMyJVf2hfYluze+oXkjyVcGJXFrRU/49AJAFoIir1Tq
Mij2De6ZuksIUQ9uhiMhTC0liIHELg7xEyw4ipUCJMM6lWPkk45IuwhHcl+u5jpa
R9Zxxp6aUg==
-----END CERTIFICATE-----
...EOF...
cat >certs/belsign-secure-server-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, L=Brussels, O=BelSign NV, OU=BelSign Secure Server Certificate Authority, CN=BelSign Secure Server CA/emailAddress=webmaster@belsign.be
        Validity
            Not Before: Jul 16 22:00:54 1997 GMT
            Not After : Jul 16 22:00:54 2007 GMT
        Subject: C=BE, L=Brussels, O=BelSign NV, OU=BelSign Secure Server Certificate Authority, CN=BelSign Secure Server CA/emailAddress=webmaster@belsign.be
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d6:01:12:78:92:f8:04:42:7f:c9:c7:22:83:fc:
                    7c:47:70:30:2b:49:0b:3e:36:40:90:28:da:21:73:
                    83:53:f2:c4:d1:16:40:c0:53:ff:ae:a6:c6:24:b3:
                    27:6d:a5:b3:3d:39:77:5d:a8:06:f6:e6:e9:bc:63:
                    11:4e:06:65:70:0a:9d:93:f9:a2:40:8b:7f:4a:84:
                    0e:8d:16:b1:d6:cc:08:64:12:0c:e0:28:4b:c8:a5:
                    84:90:17:fb:11:46:2e:d6:a7:85:18:cb:18:ae:63:
                    9a:b0:58:06:f4:00:cf:f8:c4:09:1a:35:0c:a1:f9:
                    ee:4a:fd:6d:de:fe:26:a5:3b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL Client, S/MIME
    Signature Algorithm: md5WithRSAEncryption
        6c:3d:99:c3:05:e2:1d:ca:e5:2d:aa:68:85:8b:40:31:20:66:
        13:68:e6:58:3a:89:d0:8d:75:b2:c5:62:d8:7d:82:8f:f7:d9:
        32:81:77:f6:35:5b:85:29:ce:67:b2:b9:bc:2b:19:78:cf:f3:
        87:fd:46:f1:95:75:b2:09:57:03:30:c1:7a:cd:72:47:71:80:
        ca:7d:9d:c9:65:3c:47:11:22:7d:fa:07:0b:28:78:a1:93:e8:
        05:45:48:e2:32:32:4a:3d:e8:53:1c:10:b7:c7:73:8c:07:50:
        e1:f9:c9:2b:53:41:f5:83:8d:e5:09:39:4a:8e:03:62:aa:40:
        63:8b
-----BEGIN CERTIFICATE-----
MIIC8zCCAlygAwIBAgIBATANBgkqhkiG9w0BAQQFADCBszELMAkGA1UEBhMCQkUx
ETAPBgNVBAcTCEJydXNzZWxzMRMwEQYDVQQKEwpCZWxTaWduIE5WMTQwMgYDVQQL
EytCZWxTaWduIFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MSEw
HwYDVQQDExhCZWxTaWduIFNlY3VyZSBTZXJ2ZXIgQ0ExIzAhBgkqhkiG9w0BCQEW
FHdlYm1hc3RlckBiZWxzaWduLmJlMB4XDTk3MDcxNjIyMDA1NFoXDTA3MDcxNjIy
MDA1NFowgbMxCzAJBgNVBAYTAkJFMREwDwYDVQQHEwhCcnVzc2VsczETMBEGA1UE
ChMKQmVsU2lnbiBOVjE0MDIGA1UECxMrQmVsU2lnbiBTZWN1cmUgU2VydmVyIENl
cnRpZmljYXRlIEF1dGhvcml0eTEhMB8GA1UEAxMYQmVsU2lnbiBTZWN1cmUgU2Vy
dmVyIENBMSMwIQYJKoZIhvcNAQkBFhR3ZWJtYXN0ZXJAYmVsc2lnbi5iZTCBnzAN
BgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA1gESeJL4BEJ/yccig/x8R3AwK0kLPjZA
kCjaIXODU/LE0RZAwFP/rqbGJLMnbaWzPTl3XagG9ubpvGMRTgZlcAqdk/miQIt/
SoQOjRax1swIZBIM4ChLyKWEkBf7EUYu1qeFGMsYrmOasFgG9ADP+MQJGjUMofnu
Sv1t3v4mpTsCAwEAAaMVMBMwEQYJYIZIAYb4QgEBBAQDAgCgMA0GCSqGSIb3DQEB
BAUAA4GBAGw9mcMF4h3K5S2qaIWLQDEgZhNo5lg6idCNdbLFYth9go/32TKBd/Y1
W4UpzmeyubwrGXjP84f9RvGVdbIJVwMwwXrNckdxgMp9ncllPEcRIn36BwsoeKGT
6AVFSOIyMko96FMcELfHc4wHUOH5yStTQfWDjeUJOUqOA2KqQGOL
-----END CERTIFICATE-----
...EOF...
cat >certs/betrusted-root-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 961510791 (0x394f7d87)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=WW, O=beTRUSTed, CN=beTRUSTed Root CAs, CN=beTRUSTed Root CA
        Validity
            Not Before: Jun 20 14:21:04 2000 GMT
            Not After : Jun 20 13:21:04 2010 GMT
        Subject: C=WW, O=beTRUSTed, CN=beTRUSTed Root CAs, CN=beTRUSTed Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:d4:b4:73:7a:13:0a:38:55:01:be:89:56:e1:94:
                    9e:d4:be:5a:eb:4a:34:75:1b:61:29:c4:e1:ad:08:
                    60:21:78:48:ff:b4:d0:fa:5e:41:8d:61:44:87:e8:
                    ed:c9:58:fa:fc:93:9a:df:4f:ea:3e:35:7d:f8:33:
                    7a:e6:f1:d7:cd:6f:49:4b:3d:4f:2d:6e:0e:83:3a:
                    18:78:77:a3:cf:e7:f4:4d:73:d8:9a:3b:1a:1d:be:
                    95:53:cf:20:97:c2:cf:3e:24:52:6c:0c:8e:65:59:
                    c5:71:ff:62:09:8f:aa:c5:8f:cc:60:a0:73:4a:d7:
                    38:3f:15:72:bf:a2:97:b7:70:e8:af:e2:7e:16:06:
                    4c:f5:aa:64:26:72:07:25:ad:35:fc:18:b1:26:d7:
                    d8:ff:19:0e:83:1b:8c:dc:78:45:67:34:3d:f4:af:
                    1c:8d:e4:6d:6b:ed:20:b3:67:9a:b4:61:cb:17:6f:
                    89:35:ff:e7:4e:c0:32:12:e7:ee:ec:df:ff:97:30:
                    74:ed:8d:47:8e:eb:b4:c3:44:e6:a7:4c:7f:56:43:
                    e8:b8:bc:b6:be:fa:83:97:e6:bb:fb:c4:b6:93:be:
                    19:18:3e:8c:81:b9:73:88:16:f4:96:43:9c:67:73:
                    17:90:d8:09:6e:63:ac:4a:b6:23:c4:01:a1:ad:a4:
                    e4:c5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Certificate Policies: 
            Policy: 1.3.6.1.4.1.6334.1.0.0
              User Notice:
                Explicit Text: Reliance on this certificate by any party assumes acceptance of the then applicable standard terms and conditions of use, and certification practice statement, which can be found at beTRUSTed's web site, https://www.beTRUSTed.com/vault/terms
              CPS: https://www.beTRUSTed.com/vault/terms

            X509v3 CRL Distribution Points: 
            DirName:/O=beTRUSTed/C=WW

            X509v3 Subject Key Identifier: 
            2A:B9:9B:69:2E:3B:9B:D8:CD:DE:2A:31:04:34:6B:CA:07:18:AB:67
            X509v3 Authority Key Identifier: 
            keyid:2A:B9:9B:69:2E:3B:9B:D8:CD:DE:2A:31:04:34:6B:CA:07:18:AB:67

            X509v3 Key Usage: critical
            Digital Signature, Non Repudiation, Key Encipherment, Data Encipherment, Key Agreement, Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        79:61:db:a3:5e:6e:16:b1:ea:76:51:f9:cb:15:9b:cb:69:be:
        e6:81:6b:9f:28:1f:65:3e:dd:11:85:92:d4:e8:41:bf:7e:33:
        bd:23:e7:f1:20:bf:a4:b4:a6:19:01:c6:8c:8d:35:7c:65:a4:
        4f:09:a4:d6:d8:23:15:05:13:a7:43:79:af:db:a3:0e:9b:7b:
        78:1a:f3:04:86:5a:c6:f6:8c:20:47:38:49:50:06:9d:72:67:
        3a:f0:98:03:ad:96:67:44:fc:3f:10:0d:86:4d:e4:00:3b:29:
        7b:ce:3b:3b:99:86:61:25:40:84:dc:13:62:b7:fa:ca:59:d6:
        03:1e:d6:53:01:cd:6d:4c:68:55:40:e1:ee:6b:c7:2a:00:00:
        48:82:b3:0a:01:c3:60:2a:0c:f7:82:35:ee:48:86:96:e4:74:
        d4:3d:ea:01:71:ba:04:75:40:a7:a9:7f:39:39:9a:55:97:29:
        65:ae:19:55:25:05:72:47:d3:e8:18:dc:b8:e9:af:43:73:01:
        12:74:a3:e1:5c:5f:15:5d:24:f3:f9:e4:f4:b6:67:67:12:e7:
        64:22:8a:f6:a5:41:a6:1c:b6:60:63:45:8a:10:b4:ba:46:10:
        ae:41:57:65:6c:3f:23:10:3f:21:10:59:b7:e4:40:dd:26:0c:
        23:f6:aa:ae
-----BEGIN CERTIFICATE-----
MIIFLDCCBBSgAwIBAgIEOU99hzANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJX
VzESMBAGA1UEChMJYmVUUlVTVGVkMRswGQYDVQQDExJiZVRSVVNUZWQgUm9vdCBD
QXMxGjAYBgNVBAMTEWJlVFJVU1RlZCBSb290IENBMB4XDTAwMDYyMDE0MjEwNFoX
DTEwMDYyMDEzMjEwNFowWjELMAkGA1UEBhMCV1cxEjAQBgNVBAoTCWJlVFJVU1Rl
ZDEbMBkGA1UEAxMSYmVUUlVTVGVkIFJvb3QgQ0FzMRowGAYDVQQDExFiZVRSVVNU
ZWQgUm9vdCBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANS0c3oT
CjhVAb6JVuGUntS+WutKNHUbYSnE4a0IYCF4SP+00PpeQY1hRIfo7clY+vyTmt9P
6j41ffgzeubx181vSUs9Ty1uDoM6GHh3o8/n9E1z2Jo7Gh2+lVPPIJfCzz4kUmwM
jmVZxXH/YgmPqsWPzGCgc0rXOD8Vcr+il7dw6K/ifhYGTPWqZCZyByWtNfwYsSbX
2P8ZDoMbjNx4RWc0PfSvHI3kbWvtILNnmrRhyxdviTX/507AMhLn7uzf/5cwdO2N
R47rtMNE5qdMf1ZD6Li8tr76g5fmu/vEtpO+GRg+jIG5c4gW9JZDnGdzF5DYCW5j
rEq2I8QBoa2k5MUCAwEAAaOCAfgwggH0MA8GA1UdEwEB/wQFMAMBAf8wggFZBgNV
HSAEggFQMIIBTDCCAUgGCisGAQQBsT4BAAAwggE4MIIBAQYIKwYBBQUHAgIwgfQa
gfFSZWxpYW5jZSBvbiB0aGlzIGNlcnRpZmljYXRlIGJ5IGFueSBwYXJ0eSBhc3N1
bWVzIGFjY2VwdGFuY2Ugb2YgdGhlIHRoZW4gYXBwbGljYWJsZSBzdGFuZGFyZCB0
ZXJtcyBhbmQgY29uZGl0aW9ucyBvZiB1c2UsIGFuZCBjZXJ0aWZpY2F0aW9uIHBy
YWN0aWNlIHN0YXRlbWVudCwgd2hpY2ggY2FuIGJlIGZvdW5kIGF0IGJlVFJVU1Rl
ZCdzIHdlYiBzaXRlLCBodHRwczovL3d3dy5iZVRSVVNUZWQuY29tL3ZhdWx0L3Rl
cm1zMDEGCCsGAQUFBwIBFiVodHRwczovL3d3dy5iZVRSVVNUZWQuY29tL3ZhdWx0
L3Rlcm1zMDQGA1UdHwQtMCswKaAnoCWkIzAhMRIwEAYDVQQKEwliZVRSVVNUZWQx
CzAJBgNVBAYTAldXMB0GA1UdDgQWBBQquZtpLjub2M3eKjEENGvKBxirZzAfBgNV
HSMEGDAWgBQquZtpLjub2M3eKjEENGvKBxirZzAOBgNVHQ8BAf8EBAMCAf4wDQYJ
KoZIhvcNAQEFBQADggEBAHlh26Nebhax6nZR+csVm8tpvuaBa58oH2U+3RGFktTo
Qb9+M70j5/Egv6S0phkBxoyNNXxlpE8JpNbYIxUFE6dDea/bow6be3ga8wSGWsb2
jCBHOElQBp1yZzrwmAOtlmdE/D8QDYZN5AA7KXvOOzuZhmElQITcE2K3+spZ1gMe
1lMBzW1MaFVA4e5rxyoAAEiCswoBw2AqDPeCNe5IhpbkdNQ96gFxugR1QKepfzk5
mlWXKWWuGVUlBXJH0+gY3Ljpr0NzARJ0o+FcXxVdJPP55PS2Z2cS52QiivalQaYc
tmBjRYoQtLpGEK5BV2VsPyMQPyEQWbfkQN0mDCP2qq4=
-----END CERTIFICATE-----
...EOF...
cat >certs/certengine.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CA, ST=ON, L=Toronto, O=CertEngine Inc., OU=Certification Authority Division, CN=certengine/emailAddress=ca@certengine.com
        Validity
            Not Before: Jan  1 00:00:00 1998 GMT
            Not After : Jan 17 00:00:00 2038 GMT
        Subject: C=CA, ST=ON, L=Toronto, O=CertEngine Inc., OU=Certification Authority Division, CN=certengine/emailAddress=ca@certengine.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ed:a4:d7:51:14:a1:69:e5:6d:f6:ef:dd:3f:74:
                    36:75:58:9b:de:34:c2:66:f1:32:73:ac:9f:a4:68:
                    1a:61:67:b0:5d:6b:8f:e0:73:92:7c:8e:21:19:96:
                    e5:6e:99:7e:77:32:5c:e9:18:e1:47:ea:60:b8:84:
                    6d:6d:3e:45:24:1f:12:24:68:d1:aa:8b:a3:04:43:
                    90:3b:1b:55:b5:cd:9f:8c:cf:43:aa:1d:22:3a:f3:
                    16:59:2e:9b:bb:11:c6:e7:91:95:ac:70:10:68:ee:
                    47:5c:44:9c:29:00:5a:f5:9c:8d:9a:94:97:3d:31:
                    01:ac:33:1e:8f:53:80:18:e9:1c:e7:6e:3f:4d:9a:
                    e0:14:f1:78:02:22:4b:2e:4c:42:70:ff:0d:bb:35:
                    0a:95:6d:d6:cc:d3:12:4a:80:ad:8e:45:0a:cb:8c:
                    23:48:b9:40:58:21:4c:d1:3f:43:7f:af:fe:67:c6:
                    54:41:3c:c7:a0:a0:83:9d:c1:f9:42:7c:a7:77:b0:
                    e5:3b:02:90:d8:9c:30:c5:18:58:1a:21:95:4d:43:
                    74:19:4a:bb:a8:0d:75:91:6d:fe:be:76:c5:7a:c2:
                    90:5e:81:7a:a3:63:d5:c7:db:36:61:7b:e2:23:63:
                    57:5d:48:d9:d2:95:67:b2:71:42:73:8e:4f:9b:c5:
                    e8:8f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        4f:fd:a1:ce:28:9d:34:02:4c:dc:f4:75:8c:d5:7d:f4:86:55:
        99:14:16:90:8b:8a:6a:0f:85:21:93:cf:a9:2b:3c:f0:14:fe:
        43:44:b0:4e:cf:c4:d8:05:bb:5d:5e:b4:ba:87:15:4c:af:6b:
        2a:5a:68:55:92:ec:9e:a5:68:47:65:ac:ca:1b:21:d8:ff:2d:
        05:6c:e5:ec:7b:00:15:d5:0c:71:4b:2c:7b:bd:ef:3d:a4:22:
        af:e3:fc:34:ad:07:0f:f7:5e:a2:1d:cf:18:fd:30:a9:9b:3e:
        de:21:36:b7:18:87:7e:f0:7f:d7:4d:a0:62:f0:60:69:f5:7f:
        4e:c3:c9:b6:e4:59:84:07:53:53:f9:e2:70:79:fb:df:74:aa:
        30:8f:2e:2d:4a:8a:ca:75:6f:de:26:ca:71:36:e4:d2:44:69:
        94:cb:c1:bb:d5:6e:5d:62:f8:29:02:5c:7a:99:d9:c7:cb:3c:
        44:1a:f4:58:34:d2:36:6d:2d:22:7d:78:1b:10:53:56:a9:26:
        ac:f6:ad:f8:79:ae:4a:3a:99:09:bb:c4:ff:2b:25:df:49:be:
        ab:3c:eb:01:49:bd:2d:c0:ca:30:c0:6b:42:54:7d:82:e0:bc:
        3f:f3:3a:34:12:38:4c:a5:33:ac:3d:ab:9b:e3:4f:0f:ad:9f:
        8d:43:66:e5
-----BEGIN CERTIFICATE-----
MIID3TCCAsWgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBqDELMAkGA1UEBhMCQ0Ex
CzAJBgNVBAgTAk9OMRAwDgYDVQQHEwdUb3JvbnRvMRgwFgYDVQQKEw9DZXJ0RW5n
aW5lIEluYy4xKTAnBgNVBAsTIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IERpdmlz
aW9uMRMwEQYDVQQDEwpjZXJ0ZW5naW5lMSAwHgYJKoZIhvcNAQkBFhFjYUBjZXJ0
ZW5naW5lLmNvbTAeFw05ODAxMDEwMDAwMDBaFw0zODAxMTcwMDAwMDBaMIGoMQsw
CQYDVQQGEwJDQTELMAkGA1UECBMCT04xEDAOBgNVBAcTB1Rvcm9udG8xGDAWBgNV
BAoTD0NlcnRFbmdpbmUgSW5jLjEpMCcGA1UECxMgQ2VydGlmaWNhdGlvbiBBdXRo
b3JpdHkgRGl2aXNpb24xEzARBgNVBAMTCmNlcnRlbmdpbmUxIDAeBgkqhkiG9w0B
CQEWEWNhQGNlcnRlbmdpbmUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
CgKCAQEA7aTXURShaeVt9u/dP3Q2dVib3jTCZvEyc6yfpGgaYWewXWuP4HOSfI4h
GZblbpl+dzJc6RjhR+pguIRtbT5FJB8SJGjRqoujBEOQOxtVtc2fjM9Dqh0iOvMW
WS6buxHG55GVrHAQaO5HXEScKQBa9ZyNmpSXPTEBrDMej1OAGOkc524/TZrgFPF4
AiJLLkxCcP8NuzUKlW3WzNMSSoCtjkUKy4wjSLlAWCFM0T9Df6/+Z8ZUQTzHoKCD
ncH5Qnynd7DlOwKQ2JwwxRhYGiGVTUN0GUq7qA11kW3+vnbFesKQXoF6o2PVx9s2
YXviI2NXXUjZ0pVnsnFCc45Pm8XojwIDAQABoxAwDjAMBgNVHRMEBTADAQH/MA0G
CSqGSIb3DQEBBQUAA4IBAQBP/aHOKJ00Akzc9HWM1X30hlWZFBaQi4pqD4Uhk8+p
KzzwFP5DRLBOz8TYBbtdXrS6hxVMr2sqWmhVkuyepWhHZazKGyHY/y0FbOXsewAV
1QxxSyx7ve89pCKv4/w0rQcP916iHc8Y/TCpmz7eITa3GId+8H/XTaBi8GBp9X9O
w8m25FmEB1NT+eJwefvfdKowjy4tSorKdW/eJspxNuTSRGmUy8G71W5dYvgpAlx6
mdnHyzxEGvRYNNI2bS0ifXgbEFNWqSas9q34ea5KOpkJu8T/KyXfSb6rPOsBSb0t
wMowwGtCVH2C4Lw/8zo0EjhMpTOsPaub408PrZ+NQ2bl
-----END CERTIFICATE-----
...EOF...
cat >certs/class-1-public-primary-ocsp-responder.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            2b:68:d4:a3:46:9e:c5:3b:28:09:ab:38:5d:7f:27:20
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Validity
            Not Before: Aug  4 00:00:00 2000 GMT
            Not After : Aug  3 23:59:59 2004 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/RPA (c)00, CN=Class 1 Public Primary OCSP Responder
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b9:ed:5e:7a:3a:77:5f:ce:5f:3a:52:fc:cd:64:
                    f7:71:b5:6f:6a:96:c6:59:92:55:94:5d:2f:5b:2e:
                    c1:11:ea:26:8a:cb:a7:81:3c:f6:5a:44:de:7a:13:
                    2f:fd:5a:51:d9:7b:37:26:4a:c0:27:3f:04:03:6a:
                    56:c1:83:2c:e1:6f:5b:a9:54:50:24:4a:c6:2e:7a:
                    4c:a1:5b:37:54:24:21:31:1f:a1:78:18:76:a7:b1:
                    70:da:22:d0:6a:fe:07:62:40:c6:f7:f6:9b:7d:0c:
                    06:b8:4b:c7:28:e4:66:23:84:51:ef:46:b7:93:d8:
                    81:33:cb:e5:36:ac:c6:e8:05
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
            DirName:/CN=OCSP 1-1
            X509v3 CRL Distribution Points: 
            URI:http://crl.verisign.com/pca1.crl

            X509v3 Extended Key Usage: 
            OCSP Signing
            Authority Information Access: 
            OCSP - URI:http://ocsp.verisign.com/ocsp/status

            X509v3 Certificate Policies: 
            Policy: 2.16.840.1.113733.1.7.1.1
              CPS: https://www.verisign.com/RPA

            X509v3 Basic Constraints: 
            CA:FALSE
            X509v3 Key Usage: 
            Digital Signature
    Signature Algorithm: sha1WithRSAEncryption
        70:90:dd:b8:e4:be:53:17:7c:7f:02:e9:d5:f7:8b:99:93:31:
        60:8d:7e:e6:60:6b:24:ef:60:ac:d2:ce:91:de:80:6d:09:a4:
        d3:b8:38:e5:44:ca:72:5e:0d:2d:c1:77:9c:bd:2c:03:78:29:
        8d:a4:a5:77:87:f5:f1:2b:26:ad:cc:07:6c:3a:54:5a:28:e0:
        09:f3:4d:0a:04:ca:d4:58:69:0b:a7:b3:f5:dd:01:a5:e7:dc:
        f0:1f:ba:c1:5d:90:8d:b3:ea:4f:c1:11:59:97:6a:b2:2b:13:
        b1:da:ad:97:a1:b3:b1:a0:20:5b:ca:32:ab:8d:cf:13:f0:1f:
        29:c3
-----BEGIN CERTIFICATE-----
MIIDnjCCAwegAwIBAgIQK2jUo0aexTsoCas4XX8nIDANBgkqhkiG9w0BAQUFADBf
MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsT
LkNsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkw
HhcNMDAwODA0MDAwMDAwWhcNMDQwODAzMjM1OTU5WjCBpzEXMBUGA1UEChMOVmVy
aVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5
BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20v
UlBBIChjKTAwMS4wLAYDVQQDEyVDbGFzcyAxIFB1YmxpYyBQcmltYXJ5IE9DU1Ag
UmVzcG9uZGVyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC57V56Ondfzl86
UvzNZPdxtW9qlsZZklWUXS9bLsER6iaKy6eBPPZaRN56Ey/9WlHZezcmSsAnPwQD
albBgyzhb1upVFAkSsYuekyhWzdUJCExH6F4GHansXDaItBq/gdiQMb39pt9DAa4
S8co5GYjhFHvRreT2IEzy+U2rMboBQIDAQABo4IBEDCCAQwwIAYDVR0RBBkwF6QV
MBMxETAPBgNVBAMTCE9DU1AgMS0xMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9j
cmwudmVyaXNpZ24uY29tL3BjYTEuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMJMEIG
CCsGAQUFBwEBBDYwNDAyBggrBgEFBQcwAaYmFiRodHRwOi8vb2NzcC52ZXJpc2ln
bi5jb20vb2NzcC9zdGF0dXMwRAYDVR0gBD0wOzA5BgtghkgBhvhFAQcBATAqMCgG
CCsGAQUFBwIBFhxodHRwczovL3d3dy52ZXJpc2lnbi5jb20vUlBBMAkGA1UdEwQC
MAAwCwYDVR0PBAQDAgeAMA0GCSqGSIb3DQEBBQUAA4GBAHCQ3bjkvlMXfH8C6dX3
i5mTMWCNfuZgayTvYKzSzpHegG0JpNO4OOVEynJeDS3Bd5y9LAN4KY2kpXeH9fEr
Jq3MB2w6VFoo4AnzTQoEytRYaQuns/XdAaXn3PAfusFdkI2z6k/BEVmXarIrE7Ha
rZehs7GgIFvKMquNzxPwHynD
-----END CERTIFICATE-----
...EOF...
cat >certs/class-2-public-primary-ocsp-responder.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            09:46:17:e6:1d:d8:d4:1c:a0:0c:a0:62:e8:79:8a:a7
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority
        Validity
            Not Before: Aug  1 00:00:00 2000 GMT
            Not After : Jul 31 23:59:59 2004 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/RPA (c)00, CN=Class 2 Public Primary OCSP Responder
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d0:ca:63:31:61:7f:44:34:7c:05:7d:0b:3d:6a:
                    90:cb:79:4b:77:0a:3f:4b:c7:23:e5:c0:62:2d:7e:
                    9c:7e:3e:88:87:91:d0:ac:e8:4d:49:87:a2:96:90:
                    8a:dd:04:a5:02:3f:8c:9b:e9:89:fe:62:a0:e2:5a:
                    bd:c8:dd:b4:78:e6:a5:42:93:08:67:01:c0:20:4d:
                    d7:5c:f4:5d:da:b3:e3:37:a6:52:1a:2c:4c:65:4d:
                    8a:87:d9:a8:a3:f1:49:54:bb:3c:5c:80:51:68:c6:
                    fb:49:ff:0b:55:ab:15:dd:fb:9a:c1:b9:1d:74:0d:
                    b2:8c:44:5d:89:fc:9f:f9:83
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
            DirName:/CN=OCSP 1-2
            X509v3 CRL Distribution Points: 
            URI:http://crl.verisign.com/pca2.crl

            X509v3 Extended Key Usage: 
            OCSP Signing
            Authority Information Access: 
            OCSP - URI:http://ocsp.verisign.com/ocsp/status

            X509v3 Certificate Policies: 
            Policy: 2.16.840.1.113733.1.7.1.1
              CPS: https://www.verisign.com/RPA

            X509v3 Basic Constraints: 
            CA:FALSE
            X509v3 Key Usage: 
            Digital Signature
    Signature Algorithm: sha1WithRSAEncryption
        1f:7d:09:6e:24:46:75:04:9c:f3:26:9b:e3:39:6e:17:ef:bc:
        bd:a2:1b:d2:02:84:86:ab:d0:40:97:2c:c4:43:88:37:19:6b:
        22:a8:03:71:50:9d:20:dc:36:60:20:9a:73:2d:73:55:6c:58:
        9b:2c:c2:b4:34:2c:7a:33:42:ca:91:d9:e9:43:af:cf:1e:e0:
        f5:c4:7a:ab:3f:72:63:1e:a9:37:e1:5b:3b:88:b3:13:86:82:
        90:57:cb:57:ff:f4:56:be:22:dd:e3:97:a8:e1:bc:22:43:c2:
        dd:4d:db:f6:81:9e:92:14:9e:39:0f:13:54:de:82:d8:c0:5e:
        34:8d
-----BEGIN CERTIFICATE-----
MIIDnjCCAwegAwIBAgIQCUYX5h3Y1BygDKBi6HmKpzANBgkqhkiG9w0BAQUFADBf
MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsT
LkNsYXNzIDIgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkw
HhcNMDAwODAxMDAwMDAwWhcNMDQwNzMxMjM1OTU5WjCBpzEXMBUGA1UEChMOVmVy
aVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5
BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20v
UlBBIChjKTAwMS4wLAYDVQQDEyVDbGFzcyAyIFB1YmxpYyBQcmltYXJ5IE9DU1Ag
UmVzcG9uZGVyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDQymMxYX9ENHwF
fQs9apDLeUt3Cj9LxyPlwGItfpx+PoiHkdCs6E1Jh6KWkIrdBKUCP4yb6Yn+YqDi
Wr3I3bR45qVCkwhnAcAgTddc9F3as+M3plIaLExlTYqH2aij8UlUuzxcgFFoxvtJ
/wtVqxXd+5rBuR10DbKMRF2J/J/5gwIDAQABo4IBEDCCAQwwIAYDVR0RBBkwF6QV
MBMxETAPBgNVBAMTCE9DU1AgMS0yMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9j
cmwudmVyaXNpZ24uY29tL3BjYTIuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMJMEIG
CCsGAQUFBwEBBDYwNDAyBggrBgEFBQcwAaYmFiRodHRwOi8vb2NzcC52ZXJpc2ln
bi5jb20vb2NzcC9zdGF0dXMwRAYDVR0gBD0wOzA5BgtghkgBhvhFAQcBATAqMCgG
CCsGAQUFBwIBFhxodHRwczovL3d3dy52ZXJpc2lnbi5jb20vUlBBMAkGA1UdEwQC
MAAwCwYDVR0PBAQDAgeAMA0GCSqGSIb3DQEBBQUAA4GBAB99CW4kRnUEnPMmm+M5
bhfvvL2iG9IChIar0ECXLMRDiDcZayKoA3FQnSDcNmAgmnMtc1VsWJsswrQ0LHoz
QsqR2elDr88e4PXEeqs/cmMeqTfhWzuIsxOGgpBXy1f/9Fa+It3jl6jhvCJDwt1N
2/aBnpIUnjkPE1TegtjAXjSN
-----END CERTIFICATE-----
...EOF...
cat >certs/class-3-public-primary-ocsp-responder.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            2e:96:9e:bf:b6:62:6c:ec:7b:e9:73:cc:e3:6c:c1:84
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Validity
            Not Before: Aug  4 00:00:00 2000 GMT
            Not After : Aug  3 23:59:59 2004 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/RPA (c)00, CN=Class 3 Public Primary OCSP Responder
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:f1:e4:08:0e:83:bb:75:e3:48:e5:b8:db:a6:f0:
                    b9:ab:e9:3c:62:c7:5e:35:5b:d0:02:54:11:d8:c9:
                    d1:56:b9:76:4b:b9:ab:7a:e6:cd:ba:f6:0c:04:d6:
                    7e:d6:b0:0a:65:ac:4e:39:e3:f1:f7:2d:a3:25:39:
                    ef:b0:8b:cf:be:db:0c:5d:6e:70:f4:07:cd:70:f7:
                    3a:c0:3e:35:16:ed:78:8c:43:cf:c2:26:2e:47:d6:
                    86:7d:9c:f1:be:d6:67:0c:22:25:a4:ca:65:e6:1f:
                    7a:78:28:2f:3f:05:db:04:21:bf:e1:45:66:fe:3c:
                    b7:82:ed:5a:b8:16:15:b9:55
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
            DirName:/CN=OCSP 1-3
            X509v3 CRL Distribution Points: 
            URI:http://crl.verisign.com/pca3.1.1.crl

            X509v3 Extended Key Usage: 
            OCSP Signing
            Authority Information Access: 
            OCSP - URI:http://ocsp.verisign.com/ocsp/status

            X509v3 Certificate Policies: 
            Policy: 2.16.840.1.113733.1.7.1.1
              CPS: https://www.verisign.com/RPA

            X509v3 Basic Constraints: 
            CA:FALSE
            X509v3 Key Usage: 
            Digital Signature
    Signature Algorithm: sha1WithRSAEncryption
        02:f6:53:63:c0:a9:1e:f2:d0:8b:33:30:8f:48:9b:4c:b0:56:
        b4:83:71:4a:be:dc:50:d8:f5:b6:e0:0b:db:bd:78:4f:e9:cf:
        09:34:da:29:49:9d:01:73:5a:91:91:82:54:2c:13:0a:d3:77:
        23:cf:37:fc:63:de:a7:e3:f6:b7:b5:69:45:28:49:c3:91:dc:
        aa:47:1c:a9:88:99:2c:05:2a:8d:8d:8a:fa:62:e2:5a:b7:00:
        20:5d:39:c4:28:c2:cb:fc:9e:a8:89:ae:5b:3d:8e:12:ea:32:
        b2:fc:eb:14:d7:09:15:1a:c0:cd:1b:d5:b5:15:4e:41:d5:96:
        e3:4e
-----BEGIN CERTIFICATE-----
MIIDojCCAwugAwIBAgIQLpaev7ZibOx76XPM42zBhDANBgkqhkiG9w0BAQUFADBf
MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsT
LkNsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkw
HhcNMDAwODA0MDAwMDAwWhcNMDQwODAzMjM1OTU5WjCBpzEXMBUGA1UEChMOVmVy
aVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5
BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20v
UlBBIChjKTAwMS4wLAYDVQQDEyVDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IE9DU1Ag
UmVzcG9uZGVyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDx5AgOg7t140jl
uNum8Lmr6Txix141W9ACVBHYydFWuXZLuat65s269gwE1n7WsAplrE454/H3LaMl
Oe+wi8++2wxdbnD0B81w9zrAPjUW7XiMQ8/CJi5H1oZ9nPG+1mcMIiWkymXmH3p4
KC8/BdsEIb/hRWb+PLeC7Vq4FhW5VQIDAQABo4IBFDCCARAwIAYDVR0RBBkwF6QV
MBMxETAPBgNVBAMTCE9DU1AgMS0zMDUGA1UdHwQuMCwwKqAooCaGJGh0dHA6Ly9j
cmwudmVyaXNpZ24uY29tL3BjYTMuMS4xLmNybDATBgNVHSUEDDAKBggrBgEFBQcD
CTBCBggrBgEFBQcBAQQ2MDQwMgYIKwYBBQUHMAGmJhYkaHR0cDovL29jc3AudmVy
aXNpZ24uY29tL29jc3Avc3RhdHVzMEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHAQEw
KjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29tL1JQQTAJBgNV
HRMEAjAAMAsGA1UdDwQEAwIHgDANBgkqhkiG9w0BAQUFAAOBgQAC9lNjwKke8tCL
MzCPSJtMsFa0g3FKvtxQ2PW24AvbvXhP6c8JNNopSZ0Bc1qRkYJULBMK03cjzzf8
Y96n4/a3tWlFKEnDkdyqRxypiJksBSqNjYr6YuJatwAgXTnEKMLL/J6oia5bPY4S
6jKy/OsU1wkVGsDNG9W1FU5B1ZbjTg==
-----END CERTIFICATE-----
...EOF...
cat >certs/cybertrust-japan-root-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 78 (0x4e)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=JP, O=CyberTrust Japan, Inc., CN=CyberTrust JAPAN Root CA
        Validity
            Not Before: Aug  4 07:57:00 1998 GMT
            Not After : Aug  4 23:59:00 2003 GMT
        Subject: C=JP, O=CyberTrust Japan, Inc., CN=CyberTrust JAPAN Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b7:ad:fc:ca:47:10:76:89:fd:67:ac:e4:73:06:
                    7c:81:4b:1d:d6:b5:7c:0e:47:af:ec:a6:54:75:a8:
                    c4:fd:65:af:e7:c8:b1:b1:6c:34:35:8d:f7:b9:64:
                    57:28:0b:21:5a:de:74:fe:dc:78:2e:86:46:12:4c:
                    7f:11:1f:dc:93:bd:5f:be:66:98:86:b8:b7:ec:6d:
                    49:d3:90:d9:e1:79:00:56:68:ba:ad:6c:1f:2c:3b:
                    1f:c9:2c:8c:43:b0:04:42:ea:81:73:a6:ce:33:75:
                    45:0d:8a:45:72:2f:aa:57:55:e4:07:c3:43:e2:75:
                    3a:0f:bc:3c:d0:84:ce:ba:ef
                Exponent: 65537 (0x10001)
    Signature Algorithm: md5WithRSAEncryption
        b7:a6:64:a3:0c:80:3c:1c:c4:d8:ee:41:3b:e5:86:a4:9e:60:
        5d:d6:01:32:a8:6a:64:2d:20:70:40:ba:72:4e:66:fa:07:65:
        4e:03:8e:0b:fd:56:e0:ad:3b:20:a7:32:fa:b2:12:1e:80:df:
        1e:e3:7a:18:cc:57:db:e6:c9:34:60:ef:75:eb:10:16:d0:a4:
        2e:70:d8:24:23:b8:a5:77:73:42:f9:07:3a:dd:01:6c:08:93:
        07:35:26:10:25:60:29:ff:09:e5:64:9f:69:b9:16:49:f3:5c:
        dd:24:63:46:93:0d:b0:53:36:75:bc:48:20:bb:19:b6:8f:d0:
        22:fd
-----BEGIN CERTIFICATE-----
MIICETCCAXoCAU4wDQYJKoZIhvcNAQEEBQAwUTELMAkGA1UEBhMCSlAxHzAdBgNV
BAoTFkN5YmVyVHJ1c3QgSmFwYW4sIEluYy4xITAfBgNVBAMTGEN5YmVyVHJ1c3Qg
SkFQQU4gUm9vdCBDQTAeFw05ODA4MDQwNzU3MDBaFw0wMzA4MDQyMzU5MDBaMFEx
CzAJBgNVBAYTAkpQMR8wHQYDVQQKExZDeWJlclRydXN0IEphcGFuLCBJbmMuMSEw
HwYDVQQDExhDeWJlclRydXN0IEpBUEFOIFJvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEB
BQADgY0AMIGJAoGBALet/MpHEHaJ/Wes5HMGfIFLHda1fA5Hr+ymVHWoxP1lr+fI
sbFsNDWN97lkVygLIVredP7ceC6GRhJMfxEf3JO9X75mmIa4t+xtSdOQ2eF5AFZo
uq1sHyw7H8ksjEOwBELqgXOmzjN1RQ2KRXIvqldV5AfDQ+J1Og+8PNCEzrrvAgMB
AAEwDQYJKoZIhvcNAQEEBQADgYEAt6ZkowyAPBzE2O5BO+WGpJ5gXdYBMqhqZC0g
cEC6ck5m+gdlTgOOC/1W4K07IKcy+rISHoDfHuN6GMxX2+bJNGDvdesQFtCkLnDY
JCO4pXdzQvkHOt0BbAiTBzUmECVgKf8J5WSfabkWSfNc3SRjRpMNsFM2dbxIILsZ
to/QIv0=
-----END CERTIFICATE-----
...EOF...
cat >certs/cybertrust-japan-secure-server.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 79 (0x4f)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=JP, O=CyberTrust Japan, Inc., CN=CyberTrust JAPAN Secure Server CA
        Validity
            Not Before: Aug  4 08:06:32 1998 GMT
            Not After : Aug  4 23:59:00 2003 GMT
        Subject: C=JP, O=CyberTrust Japan, Inc., CN=CyberTrust JAPAN Secure Server CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ac:26:a3:a1:b8:6f:6a:c0:2c:12:f9:db:31:05:
                    92:e7:fd:fa:d4:81:b4:b8:d5:2a:d5:90:fa:f0:43:
                    65:fc:12:15:ca:ec:db:b9:61:de:33:63:37:4f:af:
                    00:3c:7f:92:37:1b:18:73:e5:9f:3c:88:f1:1a:13:
                    44:fe:79:f2:c3:26:95:0f:0b:f0:9e:14:07:21:6c:
                    57:c2:5d:c3:e2:51:b0:cd:8b:5f:cd:5f:86:38:f8:
                    79:97:39:ec:e8:bf:52:2e:b1:5e:aa:a9:ae:8c:ed:
                    ee:d7:c8:b7:2e:31:8b:b4:39:92:3b:7c:81:27:07:
                    1a:01:44:2f:49:73:20:b6:c9
                Exponent: 65537 (0x10001)
    Signature Algorithm: md5WithRSAEncryption
        68:1d:7b:12:ee:5a:79:29:31:ca:01:ac:8b:50:a9:27:99:2c:
        00:fc:38:1a:1c:ff:c2:d5:f0:13:fe:1b:a7:39:f5:80:14:eb:
        51:fa:c0:8d:7b:84:1b:59:ae:b1:35:51:6e:a1:3e:d7:1b:ec:
        a0:9e:df:e0:a5:82:96:e3:b1:3f:d8:a8:f1:cb:79:80:8e:f7:
        f0:44:99:7e:14:f5:23:a3:11:e3:68:4b:05:36:6e:88:e3:ab:
        86:aa:38:53:03:42:3b:d3:b9:f9:e0:bf:05:e9:d3:5f:c3:4a:
        a7:b6:fd:b7:5d:90:49:f8:9a:b2:ad:66:a6:82:00:93:ae:60:
        ff:20
-----BEGIN CERTIFICATE-----
MIICIzCCAYwCAU8wDQYJKoZIhvcNAQEEBQAwWjELMAkGA1UEBhMCSlAxHzAdBgNV
BAoTFkN5YmVyVHJ1c3QgSmFwYW4sIEluYy4xKjAoBgNVBAMTIUN5YmVyVHJ1c3Qg
SkFQQU4gU2VjdXJlIFNlcnZlciBDQTAeFw05ODA4MDQwODA2MzJaFw0wMzA4MDQy
MzU5MDBaMFoxCzAJBgNVBAYTAkpQMR8wHQYDVQQKExZDeWJlclRydXN0IEphcGFu
LCBJbmMuMSowKAYDVQQDEyFDeWJlclRydXN0IEpBUEFOIFNlY3VyZSBTZXJ2ZXIg
Q0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAKwmo6G4b2rALBL52zEFkuf9
+tSBtLjVKtWQ+vBDZfwSFcrs27lh3jNjN0+vADx/kjcbGHPlnzyI8RoTRP558sMm
lQ8L8J4UByFsV8Jdw+JRsM2LX81fhjj4eZc57Oi/Ui6xXqqprozt7tfIty4xi7Q5
kjt8gScHGgFEL0lzILbJAgMBAAEwDQYJKoZIhvcNAQEEBQADgYEAaB17Eu5aeSkx
ygGsi1CpJ5ksAPw4Ghz/wtXwE/4bpzn1gBTrUfrAjXuEG1musTVRbqE+1xvsoJ7f
4KWCluOxP9io8ct5gI738ESZfhT1I6MR42hLBTZuiOOrhqo4UwNCO9O5+eC/BenT
X8NKp7b9t12QSfiasq1mpoIAk65g/yA=
-----END CERTIFICATE-----
...EOF...
cat >certs/deutsche-telekom-root-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 6 (0x6)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, O=Deutsche Telekom AG, OU=TeleSec Trust Center, CN=Deutsche Telekom Root CA
        Validity
            Not Before: Dec  9 09:11:00 1998 GMT
            Not After : Dec  9 23:59:00 2004 GMT
        Subject: C=DE, O=Deutsche Telekom AG, OU=TeleSec Trust Center, CN=Deutsche Telekom Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:dd:05:2c:f9:05:b3:b9:12:d7:69:71:f7:ea:56:
                    30:08:57:14:43:7b:bb:1a:9c:6d:2f:57:61:d7:e2:
                    f5:44:6b:ee:36:41:96:f6:64:ce:e1:c1:b2:b9:a4:
                    14:04:98:50:e8:70:f8:8e:35:9a:7d:49:c1:61:1d:
                    59:ae:da:06:18:95:7d:ad:ce:ec:a9:be:d1:18:0f:
                    40:91:76:2a:a3:e5:fd:fe:89:15:f4:57:f7:e0:55:
                    da:75:ad:00:f4:2c:c1:35:cc:b4:43:26:55:62:44:
                    2e:01:25:9c:8a:5b:f0:c1:d0:00:35:78:fe:35:de:
                    94:40:64:78:83:a1:cc:39:89
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE, pathlen:5
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
            2C:87:59:1F:8B:13:80:B2:F9:86:9D:3E:12:7E:58:96
    Signature Algorithm: md5WithRSAEncryption
        0f:fe:73:b5:07:88:6f:a0:0b:89:ea:ca:50:1f:94:de:94:2b:
        0b:27:5e:4f:f5:1c:95:26:da:8c:96:54:ad:19:91:37:43:5d:
        ab:c9:8b:b3:cd:6f:98:39:3d:ed:dd:35:e3:71:b7:ed:13:93:
        83:e8:86:e5:29:33:13:13:bc:35:7b:fd:28:2f:70:59:d5:d3:
        b4:8d:28:13:59:3b:c8:d5:74:f9:45:c2:07:60:aa:b8:18:54:
        f9:a5:68:ff:d7:05:d5:8f:b6:05:31:2e:41:4a:f4:10:1f:60:
        47:1a:0b:8b:19:4d:92:57:20:d2:ef:50:19:e8:cd:d0:70:bc:
        bc:36
-----BEGIN CERTIFICATE-----
MIICjjCCAfegAwIBAgIBBjANBgkqhkiG9w0BAQQFADBtMQswCQYDVQQGEwJERTEc
MBoGA1UEChMTRGV1dHNjaGUgVGVsZWtvbSBBRzEdMBsGA1UECxMUVGVsZVNlYyBU
cnVzdCBDZW50ZXIxITAfBgNVBAMTGERldXRzY2hlIFRlbGVrb20gUm9vdCBDQTAe
Fw05ODEyMDkwOTExMDBaFw0wNDEyMDkyMzU5MDBaMG0xCzAJBgNVBAYTAkRFMRww
GgYDVQQKExNEZXV0c2NoZSBUZWxla29tIEFHMR0wGwYDVQQLExRUZWxlU2VjIFRy
dXN0IENlbnRlcjEhMB8GA1UEAxMYRGV1dHNjaGUgVGVsZWtvbSBSb290IENBMIGf
MA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDdBSz5BbO5EtdpcffqVjAIVxRDe7sa
nG0vV2HX4vVEa+42QZb2ZM7hwbK5pBQEmFDocPiONZp9ScFhHVmu2gYYlX2tzuyp
vtEYD0CRdiqj5f3+iRX0V/fgVdp1rQD0LME1zLRDJlViRC4BJZyKW/DB0AA1eP41
3pRAZHiDocw5iQIDAQABoz4wPDAPBgNVHRMECDAGAQH/AgEFMA4GA1UdDwEB/wQE
AwIBBjAZBgNVHQ4EEgQQLIdZH4sTgLL5hp0+En5YljANBgkqhkiG9w0BAQQFAAOB
gQAP/nO1B4hvoAuJ6spQH5TelCsLJ15P9RyVJtqMllStGZE3Q12ryYuzzW+YOT3t
3TXjcbftE5OD6IblKTMTE7w1e/0oL3BZ1dO0jSgTWTvI1XT5RcIHYKq4GFT5pWj/
1wXVj7YFMS5BSvQQH2BHGguLGU2SVyDS71AZ6M3QcLy8Ng==
-----END CERTIFICATE-----
...EOF...
cat >certs/digital-signature-trust-co-dstca-00.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 913315222 (0x36701596)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Digital Signature Trust Co., OU=DSTCA E1
        Validity
            Not Before: Dec 10 18:10:23 1998 GMT
            Not After : Dec 10 18:40:23 2018 GMT
        Subject: C=US, O=Digital Signature Trust Co., OU=DSTCA E1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:a0:6c:81:a9:cf:34:1e:24:dd:fe:86:28:cc:de:
                    83:2f:f9:5e:d4:42:d2:e8:74:60:66:13:98:06:1c:
                    a9:51:12:69:6f:31:55:b9:49:72:00:08:7e:d3:a5:
                    62:44:37:24:99:8f:d9:83:48:8f:99:6d:95:13:bb:
                    43:3b:2e:49:4e:88:37:c1:bb:58:7f:fe:e1:bd:f8:
                    bb:61:cd:f3:47:c0:99:a6:f1:f3:91:e8:78:7c:00:
                    cb:61:c9:44:27:71:69:55:4a:7e:49:4d:ed:a2:a3:
                    be:02:4c:00:ca:02:a8:ee:01:02:31:64:0f:52:2d:
                    13:74:76:36:b5:7a:b4:2d:71
                Exponent: 3 (0x3)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
            DirName:/C=US/O=Digital Signature Trust Co./OU=DSTCA E1/CN=CRL1

            X509v3 Private Key Usage Period: 
            Not Before: Dec 10 18:10:23 1998 GMT, Not After: Dec 10 18:10:23 2018 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:6A:79:7E:91:69:46:18:13:0A:02:77:A5:59:5B:60:98:25:0E:A2:F8

            X509v3 Subject Key Identifier: 
            6A:79:7E:91:69:46:18:13:0A:02:77:A5:59:5B:60:98:25:0E:A2:F8
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0
..V4.0....
    Signature Algorithm: sha1WithRSAEncryption
        22:12:d8:7a:1d:dc:81:06:b6:09:65:b2:87:c8:1f:5e:b4:2f:
        e9:c4:1e:f2:3c:c1:bb:04:90:11:4a:83:4e:7e:93:b9:4d:42:
        c7:92:26:a0:5c:34:9a:38:72:f8:fd:6b:16:3e:20:ee:82:8b:
        31:2a:93:36:85:23:88:8a:3c:03:68:d3:c9:09:0f:4d:fc:6c:
        a4:da:28:72:93:0e:89:80:b0:7d:fe:80:6f:65:6d:18:33:97:
        8b:c2:6b:89:ee:60:3d:c8:9b:ef:7f:2b:32:62:73:93:cb:3c:
        e3:7b:e2:76:78:45:bc:a1:93:04:bb:86:9f:3a:5b:43:7a:c3:
        8a:65
-----BEGIN CERTIFICATE-----
MIIDKTCCApKgAwIBAgIENnAVljANBgkqhkiG9w0BAQUFADBGMQswCQYDVQQGEwJV
UzEkMCIGA1UEChMbRGlnaXRhbCBTaWduYXR1cmUgVHJ1c3QgQ28uMREwDwYDVQQL
EwhEU1RDQSBFMTAeFw05ODEyMTAxODEwMjNaFw0xODEyMTAxODQwMjNaMEYxCzAJ
BgNVBAYTAlVTMSQwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4x
ETAPBgNVBAsTCERTVENBIEUxMIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQCg
bIGpzzQeJN3+hijM3oMv+V7UQtLodGBmE5gGHKlREmlvMVW5SXIACH7TpWJENySZ
j9mDSI+ZbZUTu0M7LklOiDfBu1h//uG9+LthzfNHwJmm8fOR6Hh8AMthyUQncWlV
Sn5JTe2io74CTADKAqjuAQIxZA9SLRN0dja1erQtcQIBA6OCASQwggEgMBEGCWCG
SAGG+EIBAQQEAwIABzBoBgNVHR8EYTBfMF2gW6BZpFcwVTELMAkGA1UEBhMCVVMx
JDAiBgNVBAoTG0RpZ2l0YWwgU2lnbmF0dXJlIFRydXN0IENvLjERMA8GA1UECxMI
RFNUQ0EgRTExDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMTk5ODEyMTAxODEw
MjNagQ8yMDE4MTIxMDE4MTAyM1owCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFGp5
fpFpRhgTCgJ3pVlbYJglDqL4MB0GA1UdDgQWBBRqeX6RaUYYEwoCd6VZW2CYJQ6i
+DAMBgNVHRMEBTADAQH/MBkGCSqGSIb2fQdBAAQMMAobBFY0LjADAgSQMA0GCSqG
SIb3DQEBBQUAA4GBACIS2Hod3IEGtgllsofIH160L+nEHvI8wbsEkBFKg05+k7lN
QseSJqBcNJo4cvj9axY+IO6CizEqkzaFI4iKPANo08kJD038bKTaKHKTDomAsH3+
gG9lbRgzl4vCa4nuYD3Im+9/KzJic5PLPON74nZ4RbyhkwS7hp86W0N6w4pl
-----END CERTIFICATE-----
...EOF...
cat >certs/digital-signature-trust-co-dstca-01.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 913232846 (0x366ed3ce)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Digital Signature Trust Co., OU=DSTCA E2
        Validity
            Not Before: Dec  9 19:17:26 1998 GMT
            Not After : Dec  9 19:47:26 2018 GMT
        Subject: C=US, O=Digital Signature Trust Co., OU=DSTCA E2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:bf:93:8f:17:92:ef:33:13:18:eb:10:7f:4e:16:
                    bf:ff:06:8f:2a:85:bc:5e:f9:24:a6:24:88:b6:03:
                    b7:c1:c3:5f:03:5b:d1:6f:ae:7e:42:ea:66:23:b8:
                    63:83:56:fb:28:2d:e1:38:8b:b4:ee:a8:01:e1:ce:
                    1c:b6:88:2a:22:46:85:fb:9f:a7:70:a9:47:14:3f:
                    ce:de:65:f0:a8:71:f7:4f:26:6c:8c:bc:c6:b5:ef:
                    de:49:27:ff:48:2a:7d:e8:4d:03:cc:c7:b2:52:c6:
                    17:31:13:3b:b5:4d:db:c8:c4:f6:c3:0f:24:2a:da:
                    0c:9d:e7:91:5b:80:cd:94:9d
                Exponent: 3 (0x3)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
            DirName:/C=US/O=Digital Signature Trust Co./OU=DSTCA E2/CN=CRL1

            X509v3 Private Key Usage Period: 
            Not Before: Dec  9 19:17:26 1998 GMT, Not After: Dec  9 19:17:26 2018 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:1E:82:4D:28:65:80:3C:C9:41:6E:AC:35:2E:5A:CB:DE:EE:F8:39:5B

            X509v3 Subject Key Identifier: 
            1E:82:4D:28:65:80:3C:C9:41:6E:AC:35:2E:5A:CB:DE:EE:F8:39:5B
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0
..V4.0....
    Signature Algorithm: sha1WithRSAEncryption
        47:8d:83:ad:62:f2:db:b0:9e:45:22:05:b9:a2:d6:03:0e:38:
        72:e7:9e:fc:7b:e6:93:b6:9a:a5:a2:94:c8:34:1d:91:d1:c5:
        d7:f4:0a:25:0f:3d:78:81:9e:0f:b1:67:c4:90:4c:63:dd:5e:
        a7:e2:ba:9f:f5:f7:4d:a5:31:7b:9c:29:2d:4c:fe:64:3e:ec:
        b6:53:fe:ea:9b:ed:82:db:74:75:4b:07:79:6e:1e:d8:19:83:
        73:de:f5:3e:d0:b5:de:e7:4b:68:7d:43:2e:2a:20:e1:7e:a0:
        78:44:9e:08:f5:98:f9:c7:7f:1b:1b:d6:06:20:02:58:a1:c3:
        a2:03
-----BEGIN CERTIFICATE-----
MIIDKTCCApKgAwIBAgIENm7TzjANBgkqhkiG9w0BAQUFADBGMQswCQYDVQQGEwJV
UzEkMCIGA1UEChMbRGlnaXRhbCBTaWduYXR1cmUgVHJ1c3QgQ28uMREwDwYDVQQL
EwhEU1RDQSBFMjAeFw05ODEyMDkxOTE3MjZaFw0xODEyMDkxOTQ3MjZaMEYxCzAJ
BgNVBAYTAlVTMSQwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4x
ETAPBgNVBAsTCERTVENBIEUyMIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQC/
k48Xku8zExjrEH9OFr//Bo8qhbxe+SSmJIi2A7fBw18DW9Fvrn5C6mYjuGODVvso
LeE4i7TuqAHhzhy2iCoiRoX7n6dwqUcUP87eZfCocfdPJmyMvMa1795JJ/9IKn3o
TQPMx7JSxhcxEzu1TdvIxPbDDyQq2gyd55FbgM2UnQIBA6OCASQwggEgMBEGCWCG
SAGG+EIBAQQEAwIABzBoBgNVHR8EYTBfMF2gW6BZpFcwVTELMAkGA1UEBhMCVVMx
JDAiBgNVBAoTG0RpZ2l0YWwgU2lnbmF0dXJlIFRydXN0IENvLjERMA8GA1UECxMI
RFNUQ0EgRTIxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMTk5ODEyMDkxOTE3
MjZagQ8yMDE4MTIwOTE5MTcyNlowCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFB6C
TShlgDzJQW6sNS5ay97u+DlbMB0GA1UdDgQWBBQegk0oZYA8yUFurDUuWsve7vg5
WzAMBgNVHRMEBTADAQH/MBkGCSqGSIb2fQdBAAQMMAobBFY0LjADAgSQMA0GCSqG
SIb3DQEBBQUAA4GBAEeNg61i8tuwnkUiBbmi1gMOOHLnnvx75pO2mqWilMg0HZHR
xdf0CiUPPXiBng+xZ8SQTGPdXqfiup/1902lMXucKS1M/mQ+7LZT/uqb7YLbdHVL
B3luHtgZg3Pe9T7Qtd7nS2h9Qy4qIOF+oHhEngj1mPnHfxsb1gYgAlihw6ID
-----END CERTIFICATE-----
...EOF...
cat >certs/dst-rootca-x1.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            d0:1e:40:8b:00:00:02:7c:00:00:00:02:00:00:00:01
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=us, ST=Utah, L=Salt Lake City, O=Digital Signature Trust Co., OU=DSTCA X1, CN=DST RootCA X1/emailAddress=ca@digsigtrust.com
        Validity
            Not Before: Dec  1 18:18:55 1998 GMT
            Not After : Nov 28 18:18:55 2008 GMT
        Subject: C=us, ST=Utah, L=Salt Lake City, O=Digital Signature Trust Co., OU=DSTCA X1, CN=DST RootCA X1/emailAddress=ca@digsigtrust.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:d2:c6:26:b6:e7:a5:3d:c1:c4:68:d5:50:6f:53:
                    c5:6f:49:13:09:b8:af:2c:48:8d:14:6a:a3:17:5f:
                    5a:f9:d3:2e:75:2f:d8:28:62:d1:93:2f:fc:4d:d4:
                    ab:87:e5:08:c7:99:e7:92:3f:75:bd:eb:25:b4:15:
                    c1:9b:19:3d:d2:44:8d:d7:74:20:6d:37:02:8f:69:
                    93:5b:8a:c4:19:9d:f4:b2:0e:fc:16:6c:b9:b1:05:
                    92:83:d1:85:2c:60:94:3e:45:55:a0:d9:ab:08:21:
                    e6:60:e8:3b:74:f2:99:50:51:68:d0:03:2d:b1:80:
                    be:a3:d8:52:b0:44:cd:43:4a:70:8e:58:85:95:e1:
                    4e:2c:d6:2d:41:6f:d6:84:e7:c8:98:44:ca:47:db:
                    2c:24:a5:69:26:cf:6b:b8:27:62:c3:f4:c9:7a:92:
                    23:ed:13:67:82:ae:45:2e:45:e5:7e:72:3f:85:9d:
                    94:62:10:e6:3c:91:a1:ad:77:00:e0:15:ec:f3:84:
                    80:72:7a:8e:6e:60:97:c7:24:59:10:34:83:5b:e1:
                    a5:a4:69:b6:57:35:1c:78:59:c6:d3:2f:3a:73:67:
                    ee:94:ca:04:13:05:62:06:70:23:b3:f4:7c:ee:45:
                    d9:64:0b:5b:49:aa:a4:43:ce:26:c4:44:12:6c:b8:
                    dd:79
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        a2:37:b2:3f:69:fb:d7:86:79:54:49:31:95:33:2b:f3:d1:09:
        14:49:62:60:86:a5:b0:11:e2:50:c2:1d:06:57:3e:2d:e8:33:
        64:be:9b:aa:ad:5f:1b:4d:d4:99:95:a2:8b:9a:c9:62:72:b5:
        69:ea:d9:58:ab:35:ed:15:a2:43:d6:b6:bc:07:79:65:64:73:
        7d:d7:79:ca:7b:d5:5a:51:c6:e1:53:04:96:8d:38:cf:a3:17:
        ac:39:71:6b:01:c3:8b:53:3c:63:e9:ee:79:c0:e4:be:92:32:
        64:7a:b3:1f:97:94:62:bd:ea:b2:20:15:95:fb:97:f2:78:2f:
        63:36:40:38:e3:46:0f:1d:dd:ac:95:ca:e7:4b:90:7b:b1:4b:
        a9:d4:c5:eb:9a:da:aa:d5:a3:94:14:46:8d:2d:1f:f3:3a:d6:
        93:3a:f6:3e:79:fc:e8:e6:b0:75:ed:ee:3d:c9:70:c7:5d:aa:
        81:4b:46:25:1c:c7:6c:15:e3:95:4e:0f:aa:32:37:94:0a:17:
        24:92:13:84:58:d2:63:6f:2b:f7:e6:5b:62:0b:13:17:b0:0d:
        52:4c:fe:fe:6f:5c:e2:91:6e:1d:fd:a4:62:d7:68:fa:8e:7a:
        4f:d2:08:da:93:dc:f0:92:11:7a:d0:dc:72:93:0c:73:93:62:
        85:68:d0:f4
-----BEGIN CERTIFICATE-----
MIID2DCCAsACEQDQHkCLAAACfAAAAAIAAAABMA0GCSqGSIb3DQEBBQUAMIGpMQsw
CQYDVQQGEwJ1czENMAsGA1UECBMEVXRhaDEXMBUGA1UEBxMOU2FsdCBMYWtlIENp
dHkxJDAiBgNVBAoTG0RpZ2l0YWwgU2lnbmF0dXJlIFRydXN0IENvLjERMA8GA1UE
CxMIRFNUQ0EgWDExFjAUBgNVBAMTDURTVCBSb290Q0EgWDExITAfBgkqhkiG9w0B
CQEWEmNhQGRpZ3NpZ3RydXN0LmNvbTAeFw05ODEyMDExODE4NTVaFw0wODExMjgx
ODE4NTVaMIGpMQswCQYDVQQGEwJ1czENMAsGA1UECBMEVXRhaDEXMBUGA1UEBxMO
U2FsdCBMYWtlIENpdHkxJDAiBgNVBAoTG0RpZ2l0YWwgU2lnbmF0dXJlIFRydXN0
IENvLjERMA8GA1UECxMIRFNUQ0EgWDExFjAUBgNVBAMTDURTVCBSb290Q0EgWDEx
ITAfBgkqhkiG9w0BCQEWEmNhQGRpZ3NpZ3RydXN0LmNvbTCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBANLGJrbnpT3BxGjVUG9TxW9JEwm4ryxIjRRqoxdf
WvnTLnUv2Chi0ZMv/E3Uq4flCMeZ55I/db3rJbQVwZsZPdJEjdd0IG03Ao9pk1uK
xBmd9LIO/BZsubEFkoPRhSxglD5FVaDZqwgh5mDoO3TymVBRaNADLbGAvqPYUrBE
zUNKcI5YhZXhTizWLUFv1oTnyJhEykfbLCSlaSbPa7gnYsP0yXqSI+0TZ4KuRS5F
5X5yP4WdlGIQ5jyRoa13AOAV7POEgHJ6jm5gl8ckWRA0g1vhpaRptlc1HHhZxtMv
OnNn7pTKBBMFYgZwI7P0fO5F2WQLW0mqpEPOJsREEmy43XkCAwEAATANBgkqhkiG
9w0BAQUFAAOCAQEAojeyP2n714Z5VEkxlTMr89EJFEliYIalsBHiUMIdBlc+Legz
ZL6bqq1fG03UmZWii5rJYnK1aerZWKs17RWiQ9a2vAd5ZWRzfdd5ynvVWlHG4VME
lo04z6MXrDlxawHDi1M8Y+nuecDkvpIyZHqzH5eUYr3qsiAVlfuX8ngvYzZAOONG
Dx3drJXK50uQe7FLqdTF65raqtWjlBRGjS0f8zrWkzr2Pnn86Oawde3uPclwx12q
gUtGJRzHbBXjlU4PqjI3lAoXJJIThFjSY28r9+ZbYgsTF7ANUkz+/m9c4pFuHf2k
Ytdo+o56T9II2pPc8JIRetDccpMMc5NihWjQ9A==
-----END CERTIFICATE-----
...EOF...
cat >certs/dst-rootca-x2.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            d0:1e:40:8b:00:00:77:6d:00:00:00:01:00:00:00:04
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=us, ST=Utah, L=Salt Lake City, O=Digital Signature Trust Co., OU=DSTCA X2, CN=DST RootCA X2/emailAddress=ca@digsigtrust.com
        Validity
            Not Before: Nov 30 22:46:16 1998 GMT
            Not After : Nov 27 22:46:16 2008 GMT
        Subject: C=us, ST=Utah, L=Salt Lake City, O=Digital Signature Trust Co., OU=DSTCA X2, CN=DST RootCA X2/emailAddress=ca@digsigtrust.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:dc:75:f0:8c:c0:75:96:9a:c0:62:1f:26:f7:c4:
                    e1:9a:ea:e0:56:73:5b:99:cd:01:44:a8:08:b6:d5:
                    a7:da:1a:04:18:39:92:4a:78:a3:81:c2:f5:77:7a:
                    50:b4:70:ff:9a:ab:c6:c7:ca:6e:83:4f:42:98:fb:
                    26:0b:da:dc:6d:d6:a9:99:55:52:67:e9:28:03:92:
                    dc:e5:b0:05:9a:0f:15:f9:6b:59:72:56:f2:fa:39:
                    fc:aa:68:ee:0f:1f:10:83:2f:fc:9d:fa:17:96:dd:
                    82:e3:e6:45:7d:c0:4b:80:44:1f:ed:2c:e0:84:fd:
                    91:5c:92:54:69:25:e5:62:69:dc:e5:ee:00:52:bd:
                    33:0b:ad:75:02:85:a7:64:50:2d:c5:19:19:30:c0:
                    26:db:c9:d3:fd:2e:99:ad:59:b5:0b:4d:d4:41:ae:
                    85:48:43:59:dc:b7:a8:e2:a2:de:c3:8f:d7:b8:a1:
                    62:a6:68:50:52:e4:cf:31:a7:94:85:da:9f:46:32:
                    17:56:e5:f2:eb:66:3d:12:ff:43:db:98:ef:77:cf:
                    cb:81:8d:34:b1:c6:50:4a:26:d1:e4:3e:41:50:af:
                    6c:ae:22:34:2e:d5:6b:6e:83:ba:79:b8:76:65:48:
                    da:09:29:64:63:22:b9:fb:47:76:85:8c:86:44:cb:
                    09:db
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        b5:36:0e:5d:e1:61:28:5a:11:65:c0:3f:83:03:79:4d:be:28:
        a6:0b:07:02:52:85:cd:f8:91:d0:10:6c:b5:6a:20:5b:1c:90:
        d9:30:3c:c6:48:9e:8a:5e:64:f9:a1:71:77:ef:04:27:1f:07:
        eb:e4:26:f7:73:74:c9:44:18:1a:66:d3:e0:43:af:91:3b:d1:
        cb:2c:d8:74:54:3a:1c:4d:ca:d4:68:cd:23:7c:1d:10:9e:45:
        e9:f6:00:6e:a6:cd:19:ff:4f:2c:29:8f:57:4d:c4:77:92:be:
        e0:4c:09:fb:5d:44:86:66:21:a8:b9:32:a2:56:d5:e9:8c:83:
        7c:59:3f:c4:f1:0b:e7:9d:ec:9e:bd:9c:18:0e:3e:c2:39:79:
        28:b7:03:0d:08:cb:c6:e7:d9:01:37:50:10:ec:cc:61:16:40:
        d4:af:31:74:7b:fc:3f:31:a7:d0:47:73:33:39:1b:cc:4e:6a:
        d7:49:83:11:06:fe:eb:82:58:33:32:4c:f0:56:ac:1e:9c:2f:
        56:9a:7b:c1:4a:1c:a5:fd:55:36:ce:fc:96:4d:f4:b0:f0:ec:
        b7:6c:82:ed:2f:31:99:42:4c:a9:b2:0d:b8:15:5d:f1:df:ba:
        c9:b5:4a:d4:64:98:b3:26:a9:30:c8:fd:a6:ec:ab:96:21:ad:
        7f:c2:78:b6
-----BEGIN CERTIFICATE-----
MIID2DCCAsACEQDQHkCLAAB3bQAAAAEAAAAEMA0GCSqGSIb3DQEBBQUAMIGpMQsw
CQYDVQQGEwJ1czENMAsGA1UECBMEVXRhaDEXMBUGA1UEBxMOU2FsdCBMYWtlIENp
dHkxJDAiBgNVBAoTG0RpZ2l0YWwgU2lnbmF0dXJlIFRydXN0IENvLjERMA8GA1UE
CxMIRFNUQ0EgWDIxFjAUBgNVBAMTDURTVCBSb290Q0EgWDIxITAfBgkqhkiG9w0B
CQEWEmNhQGRpZ3NpZ3RydXN0LmNvbTAeFw05ODExMzAyMjQ2MTZaFw0wODExMjcy
MjQ2MTZaMIGpMQswCQYDVQQGEwJ1czENMAsGA1UECBMEVXRhaDEXMBUGA1UEBxMO
U2FsdCBMYWtlIENpdHkxJDAiBgNVBAoTG0RpZ2l0YWwgU2lnbmF0dXJlIFRydXN0
IENvLjERMA8GA1UECxMIRFNUQ0EgWDIxFjAUBgNVBAMTDURTVCBSb290Q0EgWDIx
ITAfBgkqhkiG9w0BCQEWEmNhQGRpZ3NpZ3RydXN0LmNvbTCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBANx18IzAdZaawGIfJvfE4Zrq4FZzW5nNAUSoCLbV
p9oaBBg5kkp4o4HC9Xd6ULRw/5qrxsfKboNPQpj7Jgva3G3WqZlVUmfpKAOS3OWw
BZoPFflrWXJW8vo5/Kpo7g8fEIMv/J36F5bdguPmRX3AS4BEH+0s4IT9kVySVGkl
5WJp3OXuAFK9MwutdQKFp2RQLcUZGTDAJtvJ0/0uma1ZtQtN1EGuhUhDWdy3qOKi
3sOP17ihYqZoUFLkzzGnlIXan0YyF1bl8utmPRL/Q9uY73fPy4GNNLHGUEom0eQ+
QVCvbK4iNC7Va26Dunm4dmVI2gkpZGMiuftHdoWMhkTLCdsCAwEAATANBgkqhkiG
9w0BAQUFAAOCAQEAtTYOXeFhKFoRZcA/gwN5Tb4opgsHAlKFzfiR0BBstWogWxyQ
2TA8xkieil5k+aFxd+8EJx8H6+Qm93N0yUQYGmbT4EOvkTvRyyzYdFQ6HE3K1GjN
I3wdEJ5F6fYAbqbNGf9PLCmPV03Ed5K+4EwJ+11EhmYhqLkyolbV6YyDfFk/xPEL
553snr2cGA4+wjl5KLcDDQjLxufZATdQEOzMYRZA1K8xdHv8PzGn0EdzMzkbzE5q
10mDEQb+64JYMzJM8FasHpwvVpp7wUocpf1VNs78lk30sPDst2yC7S8xmUJMqbIN
uBVd8d+6ybVK1GSYsyapMMj9puyrliGtf8J4tg==
-----END CERTIFICATE-----
...EOF...
cat >certs/e-certify-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 21841308 (0x14d459c)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ca, O=E-Certify, OU=ID Center, CN=E-Certify CA
        Validity
            Not Before: Sep 28 16:48:29 1999 GMT
            Not After : Sep 28 16:48:29 2004 GMT
        Subject: C=ca, O=E-Certify, OU=ID Center, CN=E-Certify CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ba:9b:a6:71:80:55:74:49:29:55:76:1b:c7:36:
                    95:30:2c:32:09:51:ee:30:a4:6b:68:87:47:d8:28:
                    0a:17:7f:6f:a8:9a:20:b6:ab:01:d2:ae:a0:45:46:
                    35:02:02:fc:da:e0:20:72:0a:33:0d:93:70:b8:04:
                    90:49:f9:68:38:bb:0d:11:6e:39:5d:58:7a:c6:23:
                    66:e9:bb:17:32:26:e8:ec:12:68:87:29:cc:b9:e5:
                    4f:cc:88:1b:ed:95:71:a1:53:22:2e:ed:83:5c:fe:
                    32:57:4c:52:53:38:e1:15:6d:00:55:49:87:24:cb:
                    e4:16:48:b8:99:e5:da:7a:df:a3:85:98:74:c2:f9:
                    ab:6b:49:cd:ff:42:cd:b8:2d:b4:80:cb:4c:7a:35:
                    fc:90:bf:4d:d3:00:ed:cf:8c:ff:4f:39:fb:7a:78:
                    f0:0e:0d:49:7f:53:3e:14:9b:26:a8:aa:c9:bb:e1:
                    d1:1b:dd:1c:30:af:01:e6:9b:26:06:64:bc:ef:58:
                    4c:5a:45:95:50:c4:2c:3e:74:58:e9:3c:af:fb:c3:
                    ab:52:04:da:24:f2:b1:c4:f6:5b:d3:48:e0:c1:84:
                    30:7c:d1:75:3f:e4:53:73:5d:89:d8:ee:40:4f:09:
                    97:97:85:63:8d:d5:a0:ae:86:83:6b:db:54:68:5e:
                    e8:4b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: sha1WithRSAEncryption
        73:3e:19:7c:d8:56:d1:c5:ff:0a:9d:e7:b6:cd:97:f3:a7:e1:
        41:c8:7e:82:35:ff:9b:96:d2:0b:ef:71:f2:10:e5:44:cb:92:
        e8:0e:5a:e6:3e:c4:f4:95:69:02:bc:0b:56:80:b9:71:17:63:
        1e:41:49:2a:35:ea:1c:d5:64:ab:49:ed:0b:3e:8b:54:a1:4d:
        28:68:ea:bd:b7:81:3f:35:79:82:f7:34:bc:79:88:25:9e:80:
        e7:cf:a8:15:af:f2:e1:15:2b:07:51:e0:d4:8d:4a:4a:03:c0:
        22:2b:b9:68:4a:80:c3:a8:85:08:d5:a7:2a:bd:cb:a7:63:7d:
        a3:b0:ca:56:60:6c:45:e1:ca:bf:14:52:0a:c2:c5:65:ec:a1:
        3d:1f:40:f9:50:5a:e4:34:0a:6f:c2:74:ac:7c:cc:27:ea:e3:
        87:a5:53:c8:de:7c:3e:5d:42:52:5a:eb:05:68:a6:18:32:60:
        20:78:6b:70:14:60:21:82:09:3d:1e:56:c0:15:61:00:51:65:
        b2:31:12:f9:c6:4a:06:bc:5f:f4:39:1f:76:9a:89:78:e9:36:
        82:da:b5:6f:8b:7f:89:b5:4c:f7:65:18:5c:81:f3:ee:50:d6:
        dd:ec:69:48:9f:2b:b5:de:3e:bd:fa:bc:6c:6b:67:53:9b:b1:
        93:b9:91:46
-----BEGIN CERTIFICATE-----
MIIDOTCCAiGgAwIBAgIEAU1FnDANBgkqhkiG9w0BAQUFADBMMQswCQYDVQQGEwJj
YTESMBAGA1UEChMJRS1DZXJ0aWZ5MRIwEAYDVQQLEwlJRCBDZW50ZXIxFTATBgNV
BAMTDEUtQ2VydGlmeSBDQTAeFw05OTA5MjgxNjQ4MjlaFw0wNDA5MjgxNjQ4Mjla
MEwxCzAJBgNVBAYTAmNhMRIwEAYDVQQKEwlFLUNlcnRpZnkxEjAQBgNVBAsTCUlE
IENlbnRlcjEVMBMGA1UEAxMMRS1DZXJ0aWZ5IENBMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEAupumcYBVdEkpVXYbxzaVMCwyCVHuMKRraIdH2CgKF39v
qJogtqsB0q6gRUY1AgL82uAgcgozDZNwuASQSfloOLsNEW45XVh6xiNm6bsXMibo
7BJohynMueVPzIgb7ZVxoVMiLu2DXP4yV0xSUzjhFW0AVUmHJMvkFki4meXaet+j
hZh0wvmra0nN/0LNuC20gMtMejX8kL9N0wDtz4z/Tzn7enjwDg1Jf1M+FJsmqKrJ
u+HRG90cMK8B5psmBmS871hMWkWVUMQsPnRY6Tyv+8OrUgTaJPKxxPZb00jgwYQw
fNF1P+RTc12J2O5ATwmXl4VjjdWgroaDa9tUaF7oSwIDAQABoyMwITAMBgNVHRME
BTADAQH/MBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQUFAAOCAQEAcz4Z
fNhW0cX/Cp3nts2X86fhQch+gjX/m5bSC+9x8hDlRMuS6A5a5j7E9JVpArwLVoC5
cRdjHkFJKjXqHNVkq0ntCz6LVKFNKGjqvbeBPzV5gvc0vHmIJZ6A58+oFa/y4RUr
B1Hg1I1KSgPAIiu5aEqAw6iFCNWnKr3Lp2N9o7DKVmBsReHKvxRSCsLFZeyhPR9A
+VBa5DQKb8J0rHzMJ+rjh6VTyN58Pl1CUlrrBWimGDJgIHhrcBRgIYIJPR5WwBVh
AFFlsjES+cZKBrxf9DkfdpqJeOk2gtq1b4t/ibVM92UYXIHz7lDW3expSJ8rtd4+
vfq8bGtnU5uxk7mRRg==
-----END CERTIFICATE-----
...EOF...
cat >certs/e-certify-ra.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 22014736 (0x14feb10)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ca, O=E-Certify, OU=ID Center, CN=E-Certify CA
        Validity
            Not Before: Sep 30 16:58:57 1999 GMT
            Not After : Sep 27 16:58:57 2004 GMT
        Subject: C=ca, O=E-Certify, OU=ID Center, CN=E-Certify RA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:dc:b0:b7:25:fb:ee:0c:ba:d8:a3:72:44:0f:2a:
                    a3:e3:48:04:d1:f4:30:74:06:08:0e:5f:37:c7:36:
                    b7:82:9a:25:4b:ac:6b:49:99:00:1b:17:f2:f0:df:
                    17:17:e9:ed:20:6a:14:6b:fd:c9:cc:0f:e6:0c:6b:
                    86:e5:f5:a4:fa:db:05:2a:00:c8:0d:ea:aa:65:40:
                    36:ca:f3:e5:75:39:8e:dc:66:db:44:1c:9e:c3:8b:
                    43:38:cb:bc:f0:9a:c9:d9:ca:37:13:ca:52:c1:2d:
                    e9:47:20:e5:cc:24:78:e0:e6:1b:4c:b8:d2:54:82:
                    6d:0e:b9:21:60:ef:7c:b4:00:fb:52:c4:2f:0a:f7:
                    04:4e:84:2f:df:18:ac:63:06:20:dd:da:b1:81:c1:
                    e1:ad:7f:18:88:77:f3:eb:f8:ad:cf:7a:10:50:56:
                    79:9e:54:cf:de:1c:9b:d7:42:94:e1:cf:d5:6c:f5:
                    5e:3d:cd:e5:67:13:3b:9a:cd:3a:62:84:f9:61:1e:
                    6d:d5:58:8e:d9:f9:ad:2a:3e:96:f1:ed:aa:7f:10:
                    ee:f6:00:85:3c:b1:05:0b:34:d1:5c:62:e0:8d:12:
                    ae:bd:4c:54:c0:e2:bc:64:71:60:65:86:c6:d9:84:
                    ab:58:60:6a:31:6e:7d:4f:b1:88:a2:fe:14:4c:3a:
                    8c:fb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: sha1WithRSAEncryption
        ad:18:80:cf:30:bc:3b:e8:f2:02:15:57:3d:e8:4c:63:e6:ee:
        32:a3:7f:e5:01:f0:27:b9:2a:d9:c1:a8:9e:23:1e:47:99:d7:
        2e:44:4b:14:cb:d0:bd:26:64:03:f2:06:8f:9f:d7:48:a8:71:
        6b:16:34:c5:3e:b5:79:98:b3:e6:e0:d0:38:11:99:a4:11:7b:
        e3:39:a5:0d:3f:9d:d5:d2:c5:7a:2f:ea:44:14:cd:10:4e:a0:
        34:b3:6b:89:5f:f0:ae:9f:cd:53:d5:7e:7a:50:25:00:21:a4:
        6d:e9:c8:71:00:fb:ad:34:17:48:22:ee:a7:28:6c:86:72:db:
        f9:9b:86:44:78:5e:05:e9:68:34:30:a1:15:65:c1:a9:da:9e:
        5d:9e:23:46:4e:2a:e6:4e:b3:4c:9f:cc:46:08:98:1c:3c:43:
        9f:b4:ce:a0:60:ef:24:ce:4e:1f:e8:c2:a9:72:bb:2f:da:42:
        06:21:f0:9a:e5:78:47:2c:08:74:50:68:60:fd:85:c2:fb:af:
        4a:92:f1:84:9d:00:6a:c8:56:21:8e:6f:c1:31:cb:51:ec:76:
        75:7a:df:01:0e:72:68:a1:f2:26:8e:d9:b8:c6:a3:64:52:fa:
        6d:fb:4a:3d:5a:5d:b8:54:94:ed:55:68:65:9d:3f:52:4c:46:
        92:16:0b:be
-----BEGIN CERTIFICATE-----
MIIDOTCCAiGgAwIBAgIEAU/rEDANBgkqhkiG9w0BAQUFADBMMQswCQYDVQQGEwJj
YTESMBAGA1UEChMJRS1DZXJ0aWZ5MRIwEAYDVQQLEwlJRCBDZW50ZXIxFTATBgNV
BAMTDEUtQ2VydGlmeSBDQTAeFw05OTA5MzAxNjU4NTdaFw0wNDA5MjcxNjU4NTda
MEwxCzAJBgNVBAYTAmNhMRIwEAYDVQQKEwlFLUNlcnRpZnkxEjAQBgNVBAsTCUlE
IENlbnRlcjEVMBMGA1UEAxMMRS1DZXJ0aWZ5IFJBMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEA3LC3JfvuDLrYo3JEDyqj40gE0fQwdAYIDl83xza3gpol
S6xrSZkAGxfy8N8XF+ntIGoUa/3JzA/mDGuG5fWk+tsFKgDIDeqqZUA2yvPldTmO
3GbbRByew4tDOMu88JrJ2co3E8pSwS3pRyDlzCR44OYbTLjSVIJtDrkhYO98tAD7
UsQvCvcEToQv3xisYwYg3dqxgcHhrX8YiHfz6/itz3oQUFZ5nlTP3hyb10KU4c/V
bPVePc3lZxM7ms06YoT5YR5t1ViO2fmtKj6W8e2qfxDu9gCFPLEFCzTRXGLgjRKu
vUxUwOK8ZHFgZYbG2YSrWGBqMW59T7GIov4UTDqM+wIDAQABoyMwITAMBgNVHRME
BTADAQH/MBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQUFAAOCAQEArRiA
zzC8O+jyAhVXPehMY+buMqN/5QHwJ7kq2cGoniMeR5nXLkRLFMvQvSZkA/IGj5/X
SKhxaxY0xT61eZiz5uDQOBGZpBF74zmlDT+d1dLFei/qRBTNEE6gNLNriV/wrp/N
U9V+elAlACGkbenIcQD7rTQXSCLupyhshnLb+ZuGRHheBeloNDChFWXBqdqeXZ4j
Rk4q5k6zTJ/MRgiYHDxDn7TOoGDvJM5OH+jCqXK7L9pCBiHwmuV4RywIdFBoYP2F
wvuvSpLxhJ0AashWIY5vwTHLUex2dXrfAQ5yaKHyJo7ZuMajZFL6bftKPVpduFSU
7VVoZZ0/UkxGkhYLvg==
-----END CERTIFICATE-----
...EOF...
cat >certs/entrust-net-certification-authority.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 946059622 (0x3863b966)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Entrust.net, OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Certification Authority (2048)
        Validity
            Not Before: Dec 24 17:50:51 1999 GMT
            Not After : Dec 24 18:20:51 2019 GMT
        Subject: O=Entrust.net, OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Certification Authority (2048)
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ad:4d:4b:a9:12:86:b2:ea:a3:20:07:15:16:64:
                    2a:2b:4b:d1:bf:0b:4a:4d:8e:ed:80:76:a5:67:b7:
                    78:40:c0:73:42:c8:68:c0:db:53:2b:dd:5e:b8:76:
                    98:35:93:8b:1a:9d:7c:13:3a:0e:1f:5b:b7:1e:cf:
                    e5:24:14:1e:b1:81:a9:8d:7d:b8:cc:6b:4b:03:f1:
                    02:0c:dc:ab:a5:40:24:00:7f:74:94:a1:9d:08:29:
                    b3:88:0b:f5:87:77:9d:55:cd:e4:c3:7e:d7:6a:64:
                    ab:85:14:86:95:5b:97:32:50:6f:3d:c8:ba:66:0c:
                    e3:fc:bd:b8:49:c1:76:89:49:19:fd:c0:a8:bd:89:
                    a3:67:2f:c6:9f:bc:71:19:60:b8:2d:e9:2c:c9:90:
                    76:66:7b:94:e2:af:78:d6:65:53:5d:3c:d6:9c:b2:
                    cf:29:03:f9:2f:a4:50:b2:d4:48:ce:05:32:55:8a:
                    fd:b2:64:4c:0e:e4:98:07:75:db:7f:df:b9:08:55:
                    60:85:30:29:f9:7b:48:a4:69:86:e3:35:3f:1e:86:
                    5d:7a:7a:15:bd:ef:00:8e:15:22:54:17:00:90:26:
                    93:bc:0e:49:68:91:bf:f8:47:d3:9d:95:42:c1:0e:
                    4d:df:6f:26:cf:c3:18:21:62:66:43:70:d6:d5:c0:
                    07:e1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 Authority Key Identifier: 
            keyid:55:E4:81:D1:11:80:BE:D8:89:B9:08:A3:31:F9:A1:24:09:16:B9:70

            X509v3 Subject Key Identifier: 
            55:E4:81:D1:11:80:BE:D8:89:B9:08:A3:31:F9:A1:24:09:16:B9:70
            1.2.840.113533.7.65.0: 
                0...V5.0:4.0....
    Signature Algorithm: sha1WithRSAEncryption
        59:47:ac:21:84:8a:17:c9:9c:89:53:1e:ba:80:85:1a:c6:3c:
        4e:3e:b1:9c:b6:7c:c6:92:5d:18:64:02:e3:d3:06:08:11:61:
        7c:63:e3:2b:9d:31:03:70:76:d2:a3:28:a0:f4:bb:9a:63:73:
        ed:6d:e5:2a:db:ed:14:a9:2b:c6:36:11:d0:2b:eb:07:8b:a5:
        da:9e:5c:19:9d:56:12:f5:54:29:c8:05:ed:b2:12:2a:8d:f4:
        03:1b:ff:e7:92:10:87:b0:3a:b5:c3:9d:05:37:12:a3:c7:f4:
        15:b9:d5:a4:39:16:9b:53:3a:23:91:f1:a8:82:a2:6a:88:68:
        c1:79:02:22:bc:aa:a6:d6:ae:df:b0:14:5f:b8:87:d0:dd:7c:
        7f:7b:ff:af:1c:cf:e6:db:07:ad:5e:db:85:9d:d0:2b:0d:33:
        db:04:d1:e6:49:40:13:2b:76:fb:3e:e9:9c:89:0f:15:ce:18:
        b0:85:78:21:4f:6b:4f:0e:fa:36:67:cd:07:f2:ff:08:d0:e2:
        de:d9:bf:2a:af:b8:87:86:21:3c:04:ca:b7:94:68:7f:cf:3c:
        e9:98:d7:38:ff:ec:c0:d9:50:f0:2e:4b:58:ae:46:6f:d0:2e:
        c3:60:da:72:55:72:bd:4c:45:9e:61:ba:bf:84:81:92:03:d1:
        d2:69:7c:c5
-----BEGIN CERTIFICATE-----
MIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChML
RW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBp
bmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5
IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRp
ZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEy
MjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3
LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxp
YWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEG
A1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgp
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQq
K0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQe
sYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuX
MlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVT
XTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/
HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH
4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGA
vtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0G
CSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEA
WUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMo
oPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQ
h7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18
f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfN
B/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVy
vUxFnmG6v4SBkgPR0ml8xQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/entrust-net-client-certification-00.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 939758062 (0x380391ee)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=Entrust.net, OU=www.entrust.net/Client_CA_Info/CPS incorp. by ref. limits liab., OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Client Certification Authority
        Validity
            Not Before: Oct 12 19:24:30 1999 GMT
            Not After : Oct 12 19:54:30 2019 GMT
        Subject: C=US, O=Entrust.net, OU=www.entrust.net/Client_CA_Info/CPS incorp. by ref. limits liab., OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Client Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c8:3a:99:5e:31:17:df:ac:27:6f:90:7b:e4:19:
                    ff:45:a3:34:c2:db:c1:a8:4f:f0:68:ea:84:fd:9f:
                    75:79:cf:c1:8a:51:94:af:c7:57:03:47:64:9e:ad:
                    82:1b:5a:da:7f:37:78:47:bb:37:98:12:96:ce:c6:
                    13:7d:ef:d2:0c:30:51:a9:39:9e:55:f8:fb:b1:e7:
                    30:de:83:b2:ba:3e:f1:d5:89:3b:3b:85:ba:aa:74:
                    2c:fe:3f:31:6e:af:91:95:6e:06:d4:07:4d:4b:2c:
                    56:47:18:04:52:da:0e:10:93:bf:63:90:9b:e1:df:
                    8c:e6:02:a4:e6:4f:5e:f7:8b
                Exponent: 3 (0x3)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
            DirName:/C=US/O=Entrust.net/OU=www.entrust.net/Client_CA_Info/CPS incorp. by ref. limits liab./OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Client Certification Authority/CN=CRL1
            URI:http://www.entrust.net/CRL/Client1.crl

            X509v3 Private Key Usage Period: 
            Not Before: Oct 12 19:24:30 1999 GMT, Not After: Oct 12 19:24:30 2019 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:C4:FB:9C:29:7B:97:CD:4C:96:FC:EE:5B:B3:CA:99:74:8B:95:EA:4C

            X509v3 Subject Key Identifier: 
            C4:FB:9C:29:7B:97:CD:4C:96:FC:EE:5B:B3:CA:99:74:8B:95:EA:4C
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0
..V4.0....
    Signature Algorithm: md5WithRSAEncryption
        3f:ae:8a:f1:d7:66:03:05:9e:3e:fa:ea:1c:46:bb:a4:5b:8f:
        78:9a:12:48:99:f9:f4:35:de:0c:36:07:02:6b:10:3a:89:14:
        81:9c:31:a6:7c:b2:41:b2:6a:e7:07:01:a1:4b:f9:9f:25:3b:
        96:ca:99:c3:3e:a1:51:1c:f3:c3:2e:44:f7:b0:67:46:aa:92:
        e5:3b:da:1c:19:14:38:30:d5:e2:a2:31:25:2e:f1:ec:45:38:
        ed:f8:06:58:03:73:62:b0:10:31:8f:40:bf:64:e0:5c:3e:c5:
        4f:1f:da:12:43:ff:4c:e6:06:26:a8:9b:19:aa:44:3c:76:b2:
        5c:ec
-----BEGIN CERTIFICATE-----
MIIE7TCCBFagAwIBAgIEOAOR7jANBgkqhkiG9w0BAQQFADCByTELMAkGA1UEBhMC
VVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MUgwRgYDVQQLFD93d3cuZW50cnVzdC5u
ZXQvQ2xpZW50X0NBX0luZm8vQ1BTIGluY29ycC4gYnkgcmVmLiBsaW1pdHMgbGlh
Yi4xJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNV
BAMTKkVudHJ1c3QubmV0IENsaWVudCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAe
Fw05OTEwMTIxOTI0MzBaFw0xOTEwMTIxOTU0MzBaMIHJMQswCQYDVQQGEwJVUzEU
MBIGA1UEChMLRW50cnVzdC5uZXQxSDBGBgNVBAsUP3d3dy5lbnRydXN0Lm5ldC9D
bGllbnRfQ0FfSW5mby9DUFMgaW5jb3JwLiBieSByZWYuIGxpbWl0cyBsaWFiLjEl
MCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMq
RW50cnVzdC5uZXQgQ2xpZW50IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0G
CSqGSIb3DQEBAQUAA4GLADCBhwKBgQDIOpleMRffrCdvkHvkGf9FozTC28GoT/Bo
6oT9n3V5z8GKUZSvx1cDR2SerYIbWtp/N3hHuzeYEpbOxhN979IMMFGpOZ5V+Pux
5zDeg7K6PvHViTs7hbqqdCz+PzFur5GVbgbUB01LLFZHGARS2g4Qk79jkJvh34zm
AqTmT173iwIBA6OCAeAwggHcMBEGCWCGSAGG+EIBAQQEAwIABzCCASIGA1UdHwSC
ARkwggEVMIHkoIHhoIHepIHbMIHYMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50
cnVzdC5uZXQxSDBGBgNVBAsUP3d3dy5lbnRydXN0Lm5ldC9DbGllbnRfQ0FfSW5m
by9DUFMgaW5jb3JwLiBieSByZWYuIGxpbWl0cyBsaWFiLjElMCMGA1UECxMcKGMp
IDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQg
Q2xpZW50IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCyg
KqAohiZodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9DbGllbnQxLmNybDArBgNV
HRAEJDAigA8xOTk5MTAxMjE5MjQzMFqBDzIwMTkxMDEyMTkyNDMwWjALBgNVHQ8E
BAMCAQYwHwYDVR0jBBgwFoAUxPucKXuXzUyW/O5bs8qZdIuV6kwwHQYDVR0OBBYE
FMT7nCl7l81MlvzuW7PKmXSLlepMMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EA
BAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEEBQADgYEAP66K8ddmAwWePvrqHEa7
pFuPeJoSSJn59DXeDDYHAmsQOokUgZwxpnyyQbJq5wcBoUv5nyU7lsqZwz6hURzz
wy5E97BnRqqS5TvaHBkUODDV4qIxJS7x7EU47fgGWANzYrAQMY9Av2TgXD7FTx/a
EkP/TOYGJqibGapEPHayXOw=
-----END CERTIFICATE-----
...EOF...
cat >certs/entrust-net-client-certification-01.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 949941988 (0x389ef6e4)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: O=Entrust.net, OU=www.entrust.net/GCCA_CPS incorp. by ref. (limits liab.), OU=(c) 2000 Entrust.net Limited, CN=Entrust.net Client Certification Authority
        Validity
            Not Before: Feb  7 16:16:40 2000 GMT
            Not After : Feb  7 16:46:40 2020 GMT
        Subject: O=Entrust.net, OU=www.entrust.net/GCCA_CPS incorp. by ref. (limits liab.), OU=(c) 2000 Entrust.net Limited, CN=Entrust.net Client Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:93:74:b4:b6:e4:c5:4b:d6:a1:68:7f:62:d5:ec:
                    f7:51:57:b3:72:4a:98:f5:d0:89:c9:ad:63:cd:4d:
                    35:51:6a:84:d4:ad:c9:68:79:6f:b8:eb:11:db:87:
                    ae:5c:24:51:13:f1:54:25:84:af:29:2b:9f:e3:80:
                    e2:d9:cb:dd:c6:45:49:34:88:90:5e:01:97:ef:ea:
                    53:a6:dd:fc:c1:de:4b:2a:25:e4:e9:35:fa:55:05:
                    06:e5:89:7a:ea:a4:11:57:3b:fc:7c:3d:36:cd:67:
                    35:6d:a4:a9:25:59:bd:66:f5:f9:27:e4:95:67:d6:
                    3f:92:80:5e:f2:34:7d:2b:85
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
            DirName:/O=Entrust.net/OU=www.entrust.net/GCCA_CPS incorp. by ref. (limits liab.)/OU=(c) 2000 Entrust.net Limited/CN=Entrust.net Client Certification Authority/CN=CRL1

            X509v3 Private Key Usage Period: 
            Not Before: Feb  7 16:16:40 2000 GMT, Not After: Feb  7 16:46:40 2020 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:84:8B:74:FD:C5:8D:C0:FF:27:6D:20:37:45:7C:FE:2D:CE:BA:D3:7D

            X509v3 Subject Key Identifier: 
            84:8B:74:FD:C5:8D:C0:FF:27:6D:20:37:45:7C:FE:2D:CE:BA:D3:7D
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V5.0:4.0....
    Signature Algorithm: md5WithRSAEncryption
        4e:6f:35:80:3b:d1:8a:f5:0e:a7:20:cb:2d:65:55:d0:92:f4:
        e7:84:b5:06:26:83:12:84:0b:ac:3b:b2:44:ee:bd:cf:40:db:
        20:0e:ba:6e:14:ea:30:e0:3b:62:7c:7f:8b:6b:7c:4a:a7:d5:
        35:3c:be:a8:5c:ea:4b:bb:93:8e:80:66:ab:0f:29:fd:4d:2d:
        bf:1a:9b:0a:90:c5:ab:da:d1:b3:86:d4:2f:24:52:5c:7a:6d:
        c6:f2:fe:e5:4d:1a:30:8c:90:f2:ba:d7:4a:3e:43:7e:d4:c8:
        50:1a:87:f8:4f:81:c7:76:0b:84:3a:72:9d:ce:65:66:97:ae:
        26:5e
-----BEGIN CERTIFICATE-----
MIIEgzCCA+ygAwIBAgIEOJ725DANBgkqhkiG9w0BAQQFADCBtDEUMBIGA1UEChML
RW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9HQ0NBX0NQUyBp
bmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAw
IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENsaWVu
dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDcxNjE2NDBaFw0yMDAy
MDcxNjQ2NDBaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3
LmVudHJ1c3QubmV0L0dDQ0FfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxp
YWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEG
A1UEAxMqRW50cnVzdC5uZXQgQ2xpZW50IENlcnRpZmljYXRpb24gQXV0aG9yaXR5
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCTdLS25MVL1qFof2LV7PdRV7Ny
Spj10InJrWPNTTVRaoTUrcloeW+46xHbh65cJFET8VQlhK8pK5/jgOLZy93GRUk0
iJBeAZfv6lOm3fzB3ksqJeTpNfpVBQbliXrqpBFXO/x8PTbNZzVtpKklWb1m9fkn
5JVn1j+SgF7yNH0rhQIDAQABo4IBnjCCAZowEQYJYIZIAYb4QgEBBAQDAgAHMIHd
BgNVHR8EgdUwgdIwgc+ggcyggcmkgcYwgcMxFDASBgNVBAoTC0VudHJ1c3QubmV0
MUAwPgYDVQQLFDd3d3cuZW50cnVzdC5uZXQvR0NDQV9DUFMgaW5jb3JwLiBieSBy
ZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5l
dCBMaW1pdGVkMTMwMQYDVQQDEypFbnRydXN0Lm5ldCBDbGllbnQgQ2VydGlmaWNh
dGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAy
MDcxNjE2NDBagQ8yMDIwMDIwNzE2NDY0MFowCwYDVR0PBAQDAgEGMB8GA1UdIwQY
MBaAFISLdP3FjcD/J20gN0V8/i3OutN9MB0GA1UdDgQWBBSEi3T9xY3A/ydtIDdF
fP4tzrrTfTAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4w
AwIEkDANBgkqhkiG9w0BAQQFAAOBgQBObzWAO9GK9Q6nIMstZVXQkvTnhLUGJoMS
hAusO7JE7r3PQNsgDrpuFOow4DtifH+La3xKp9U1PL6oXOpLu5OOgGarDyn9TS2/
GpsKkMWr2tGzhtQvJFJcem3G8v7lTRowjJDyutdKPkN+1MhQGof4T4HHdguEOnKd
zmVml64mXg==
-----END CERTIFICATE-----
...EOF...
cat >certs/entrust-net-secure-server-certification-00.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 927650371 (0x374ad243)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Entrust.net, OU=www.entrust.net/CPS incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Secure Server Certification Authority
        Validity
            Not Before: May 25 16:09:40 1999 GMT
            Not After : May 25 16:39:40 2019 GMT
        Subject: C=US, O=Entrust.net, OU=www.entrust.net/CPS incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Secure Server Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:cd:28:83:34:54:1b:89:f3:0f:af:37:91:31:ff:
                    af:31:60:c9:a8:e8:b2:10:68:ed:9f:e7:93:36:f1:
                    0a:64:bb:47:f5:04:17:3f:23:47:4d:c5:27:19:81:
                    26:0c:54:72:0d:88:2d:d9:1f:9a:12:9f:bc:b3:71:
                    d3:80:19:3f:47:66:7b:8c:35:28:d2:b9:0a:df:24:
                    da:9c:d6:50:79:81:7a:5a:d3:37:f7:c2:4a:d8:29:
                    92:26:64:d1:e4:98:6c:3a:00:8a:f5:34:9b:65:f8:
                    ed:e3:10:ff:fd:b8:49:58:dc:a0:de:82:39:6b:81:
                    b1:16:19:61:b9:54:b6:e6:43
                Exponent: 3 (0x3)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
            DirName:/C=US/O=Entrust.net/OU=www.entrust.net/CPS incorp. by ref. (limits liab.)/OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Secure Server Certification Authority/CN=CRL1
            URI:http://www.entrust.net/CRL/net1.crl

            X509v3 Private Key Usage Period: 
            Not Before: May 25 16:09:40 1999 GMT, Not After: May 25 16:09:40 2019 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:F0:17:62:13:55:3D:B3:FF:0A:00:6B:FB:50:84:97:F3:ED:62:D0:1A

            X509v3 Subject Key Identifier: 
            F0:17:62:13:55:3D:B3:FF:0A:00:6B:FB:50:84:97:F3:ED:62:D0:1A
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0
..V4.0....
    Signature Algorithm: sha1WithRSAEncryption
        90:dc:30:02:fa:64:74:c2:a7:0a:a5:7c:21:8d:34:17:a8:fb:
        47:0e:ff:25:7c:8d:13:0a:fb:e4:98:b5:ef:8c:f8:c5:10:0d:
        f7:92:be:f1:c3:d5:d5:95:6a:04:bb:2c:ce:26:36:65:c8:31:
        c6:e7:ee:3f:e3:57:75:84:7a:11:ef:46:4f:18:f4:d3:98:bb:
        a8:87:32:ba:72:f6:3c:e2:3d:9f:d7:1d:d9:c3:60:43:8c:58:
        0e:22:96:2f:62:a3:2c:1f:ba:ad:05:ef:ab:32:78:87:a0:54:
        73:19:b5:5c:05:f9:52:3e:6d:2d:45:0b:f7:0a:93:ea:ed:06:
        f9:b2
-----BEGIN CERTIFICATE-----
MIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMC
VVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5u
ZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMc
KGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5u
ZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1
MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UE
ChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5j
b3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBF
bnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUg
U2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUA
A4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/
I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3
wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OC
AdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHb
oIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5
BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1p
dHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVk
MTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRp
b24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVu
dHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0
MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8Bdi
E1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAa
MAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZI
hvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN
95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd
2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=
-----END CERTIFICATE-----
...EOF...
cat >certs/entrust-net-secure-server-certification-01.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 949686588 (0x389b113c)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: O=Entrust.net, OU=www.entrust.net/SSL_CPS incorp. by ref. (limits liab.), OU=(c) 2000 Entrust.net Limited, CN=Entrust.net Secure Server Certification Authority
        Validity
            Not Before: Feb  4 17:20:00 2000 GMT
            Not After : Feb  4 17:50:00 2020 GMT
        Subject: O=Entrust.net, OU=www.entrust.net/SSL_CPS incorp. by ref. (limits liab.), OU=(c) 2000 Entrust.net Limited, CN=Entrust.net Secure Server Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c7:c1:5f:4e:71:f1:ce:f0:60:86:0f:d2:58:7f:
                    d3:33:97:2d:17:a2:75:30:b5:96:64:26:2f:68:c3:
                    44:ab:a8:75:e6:00:67:34:57:9e:65:c7:22:9b:73:
                    e6:d3:dd:08:0e:37:55:aa:25:46:81:6c:bd:fe:a8:
                    f6:75:57:57:8c:90:6c:4a:c3:3e:8b:4b:43:0a:c9:
                    11:56:9a:9a:27:22:99:cf:55:9e:61:d9:02:e2:7c:
                    b6:7c:38:07:dc:e3:7f:4f:9a:b9:03:41:80:b6:75:
                    67:13:0b:9f:e8:57:36:c8:5d:00:36:de:66:14:da:
                    6e:76:1f:4f:37:8c:82:13:89
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
            DirName:/O=Entrust.net/OU=www.entrust.net/SSL_CPS incorp. by ref. (limits liab.)/OU=(c) 2000 Entrust.net Limited/CN=Entrust.net Secure Server Certification Authority/CN=CRL1

            X509v3 Private Key Usage Period: 
            Not Before: Feb  4 17:20:00 2000 GMT, Not After: Feb  4 17:50:00 2020 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:CB:6C:C0:6B:E3:BB:3E:CB:FC:22:9C:FE:FB:8B:92:9C:B0:F2:6E:22

            X509v3 Subject Key Identifier: 
            CB:6C:C0:6B:E3:BB:3E:CB:FC:22:9C:FE:FB:8B:92:9C:B0:F2:6E:22
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V5.0:4.0....
    Signature Algorithm: md5WithRSAEncryption
        62:db:81:91:ce:c8:9a:77:42:2f:ec:bd:27:a3:53:0f:50:1b:
        ea:4e:92:f0:a9:af:a9:a0:ba:48:61:cb:ef:c9:06:ef:1f:d5:
        f4:ee:df:56:2d:e6:ca:6a:19:73:aa:53:be:92:b3:50:02:b6:
        85:26:72:63:d8:75:50:62:75:14:b7:b3:50:1a:3f:ca:11:00:
        0b:85:45:69:6d:b6:a5:ae:51:e1:4a:dc:82:3f:6c:8c:34:b2:
        77:6b:d9:02:f6:7f:0e:ea:65:04:f1:cd:54:ca:ba:c9:cc:e0:
        84:f7:c8:3e:11:97:d3:60:09:18:bc:05:ff:6c:89:33:f0:ec:
        15:0f
-----BEGIN CERTIFICATE-----
MIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChML
RW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGlu
Y29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAg
RW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJl
IFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBa
Fw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UE
CxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1p
dHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVk
MTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRp
b24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO
8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaB
bL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2
dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4
QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoT
C0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBp
bmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAw
IEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3Vy
ZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEw
KwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYD
VR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1Ud
DgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2
fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsia
d0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraF
JnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1U
yrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==
-----END CERTIFICATE-----
...EOF...
cat >certs/equifax-equifax-premium-certificate.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 903999262 (0x35e1ef1e)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Equifax, OU=Equifax Premium Certificate Authority
        Validity
            Not Before: Aug 24 22:54:23 1998 GMT
            Not After : Aug 24 22:54:23 2018 GMT
        Subject: C=US, O=Equifax, OU=Equifax Premium Certificate Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ce:a1:06:8e:06:cc:08:0b:c1:86:a8:de:20:d5:
                    0d:0e:d1:0d:c4:9f:ea:6a:d9:b3:c2:32:47:40:6f:
                    8a:88:a4:09:bd:38:2c:1d:e6:cb:e6:a4:f3:36:eb:
                    da:eb:bc:fc:64:b3:07:f6:2d:bc:aa:ce:9f:19:48:
                    68:4a:fc:f5:a2:45:7e:09:10:f5:8f:b3:49:5c:23:
                    06:39:ea:13:8b:b8:0b:cd:91:1d:76:5f:d9:37:a1:
                    44:fb:5f:90:f2:67:b3:cd:18:99:43:1f:76:12:6b:
                    02:f2:95:83:38:43:c2:f6:62:34:ca:c9:78:5d:5f:
                    d2:d8:ba:9a:ff:be:10:60:5b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 CRL Distribution Points: 
            DirName:/C=US/O=Equifax/OU=Equifax Premium Certificate Authority/CN=CRL1

            X509v3 Private Key Usage Period: 
            Not After: Aug 24 22:54:23 2018 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:15:EE:B2:28:59:AB:6E:E5:F8:CF:8B:81:F4:24:E1:AE:3F:75:1B:98

            X509v3 Subject Key Identifier: 
            15:EE:B2:28:59:AB:6E:E5:F8:CF:8B:81:F4:24:E1:AE:3F:75:1B:98
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V3.0c....
    Signature Algorithm: sha1WithRSAEncryption
        bd:0b:9c:27:a9:03:db:28:dc:98:a9:4b:d0:d1:8e:a7:a8:1a:
        5a:91:e0:9c:f1:f7:18:7c:2e:22:9e:36:1f:c9:a8:b5:cd:46:
        4a:6e:fa:35:07:1b:86:08:eb:9f:e2:a8:f9:9d:41:2d:3a:ae:
        5c:5c:b6:5f:34:04:eb:fc:2a:60:b0:fb:74:e4:85:e9:65:38:
        96:ee:15:c7:c6:77:63:12:bd:8a:68:1f:ab:6c:7d:da:ca:5c:
        13:ce:ea:c9:eb:09:5c:c5:73:e7:12:01:d5:d9:53:07:9e:e0:
        0f:96:f0:8b:b4:bb:45:48:9f:86:c5:19:55:a0:cb:96:c5:03:
        fc:48
-----BEGIN CERTIFICATE-----
MIIDIzCCAoygAwIBAgIENeHvHjANBgkqhkiG9w0BAQUFADBPMQswCQYDVQQGEwJV
UzEQMA4GA1UEChMHRXF1aWZheDEuMCwGA1UECxMlRXF1aWZheCBQcmVtaXVtIENl
cnRpZmljYXRlIEF1dGhvcml0eTAeFw05ODA4MjQyMjU0MjNaFw0xODA4MjQyMjU0
MjNaME8xCzAJBgNVBAYTAlVTMRAwDgYDVQQKEwdFcXVpZmF4MS4wLAYDVQQLEyVF
cXVpZmF4IFByZW1pdW0gQ2VydGlmaWNhdGUgQXV0aG9yaXR5MIGfMA0GCSqGSIb3
DQEBAQUAA4GNADCBiQKBgQDOoQaOBswIC8GGqN4g1Q0O0Q3En+pq2bPCMkdAb4qI
pAm9OCwd5svmpPM269rrvPxkswf2Lbyqzp8ZSGhK/PWiRX4JEPWPs0lcIwY56hOL
uAvNkR12X9k3oUT7X5DyZ7PNGJlDH3YSawLylYM4Q8L2YjTKyXhdX9LYupr/vhBg
WwIDAQABo4IBCjCCAQYwcQYDVR0fBGowaDBmoGSgYqRgMF4xCzAJBgNVBAYTAlVT
MRAwDgYDVQQKEwdFcXVpZmF4MS4wLAYDVQQLEyVFcXVpZmF4IFByZW1pdW0gQ2Vy
dGlmaWNhdGUgQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMBoGA1UdEAQTMBGBDzIw
MTgwODI0MjI1NDIzWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAUFe6yKFmrbuX4
z4uB9CThrj91G5gwHQYDVR0OBBYEFBXusihZq27l+M+LgfQk4a4/dRuYMAwGA1Ud
EwQFMAMBAf8wGgYJKoZIhvZ9B0EABA0wCxsFVjMuMGMDAgbAMA0GCSqGSIb3DQEB
BQUAA4GBAL0LnCepA9so3JipS9DRjqeoGlqR4Jzx9xh8LiKeNh/JqLXNRkpu+jUH
G4YI65/iqPmdQS06rlxctl80BOv8KmCw+3TkhellOJbuFcfGd2MSvYpoH6tsfdrK
XBPO6snrCVzFc+cSAdXZUwee4A+W8Iu0u0VIn4bFGVWgy5bFA/xI
-----END CERTIFICATE-----
...EOF...
cat >certs/equifax-equifax-secure-certificate.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 903804111 (0x35def4cf)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Equifax, OU=Equifax Secure Certificate Authority
        Validity
            Not Before: Aug 22 16:41:51 1998 GMT
            Not After : Aug 22 16:41:51 2018 GMT
        Subject: C=US, O=Equifax, OU=Equifax Secure Certificate Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c1:5d:b1:58:67:08:62:ee:a0:9a:2d:1f:08:6d:
                    91:14:68:98:0a:1e:fe:da:04:6f:13:84:62:21:c3:
                    d1:7c:ce:9f:05:e0:b8:01:f0:4e:34:ec:e2:8a:95:
                    04:64:ac:f1:6b:53:5f:05:b3:cb:67:80:bf:42:02:
                    8e:fe:dd:01:09:ec:e1:00:14:4f:fc:fb:f0:0c:dd:
                    43:ba:5b:2b:e1:1f:80:70:99:15:57:93:16:f1:0f:
                    97:6a:b7:c2:68:23:1c:cc:4d:59:30:ac:51:1e:3b:
                    af:2b:d6:ee:63:45:7b:c5:d9:5f:50:d2:e3:50:0f:
                    3a:88:e7:bf:14:fd:e0:c7:b9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 CRL Distribution Points: 
            DirName:/C=US/O=Equifax/OU=Equifax Secure Certificate Authority/CN=CRL1

            X509v3 Private Key Usage Period: 
            Not After: Aug 22 16:41:51 2018 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:48:E6:68:F9:2B:D2:B2:95:D7:47:D8:23:20:10:4F:33:98:90:9F:D4

            X509v3 Subject Key Identifier: 
            48:E6:68:F9:2B:D2:B2:95:D7:47:D8:23:20:10:4F:33:98:90:9F:D4
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V3.0c....
    Signature Algorithm: sha1WithRSAEncryption
        58:ce:29:ea:fc:f7:de:b5:ce:02:b9:17:b5:85:d1:b9:e3:e0:
        95:cc:25:31:0d:00:a6:92:6e:7f:b6:92:63:9e:50:95:d1:9a:
        6f:e4:11:de:63:85:6e:98:ee:a8:ff:5a:c8:d3:55:b2:66:71:
        57:de:c0:21:eb:3d:2a:a7:23:49:01:04:86:42:7b:fc:ee:7f:
        a2:16:52:b5:67:67:d3:40:db:3b:26:58:b2:28:77:3d:ae:14:
        77:61:d6:fa:2a:66:27:a0:0d:fa:a7:73:5c:ea:70:f1:94:21:
        65:44:5f:fa:fc:ef:29:68:a9:a2:87:79:ef:79:ef:4f:ac:07:
        77:38
-----BEGIN CERTIFICATE-----
MIIDIDCCAomgAwIBAgIENd70zzANBgkqhkiG9w0BAQUFADBOMQswCQYDVQQGEwJV
UzEQMA4GA1UEChMHRXF1aWZheDEtMCsGA1UECxMkRXF1aWZheCBTZWN1cmUgQ2Vy
dGlmaWNhdGUgQXV0aG9yaXR5MB4XDTk4MDgyMjE2NDE1MVoXDTE4MDgyMjE2NDE1
MVowTjELMAkGA1UEBhMCVVMxEDAOBgNVBAoTB0VxdWlmYXgxLTArBgNVBAsTJEVx
dWlmYXggU2VjdXJlIENlcnRpZmljYXRlIEF1dGhvcml0eTCBnzANBgkqhkiG9w0B
AQEFAAOBjQAwgYkCgYEAwV2xWGcIYu6gmi0fCG2RFGiYCh7+2gRvE4RiIcPRfM6f
BeC4AfBONOziipUEZKzxa1NfBbPLZ4C/QgKO/t0BCezhABRP/PvwDN1Dulsr4R+A
cJkVV5MW8Q+XarfCaCMczE1ZMKxRHjuvK9buY0V7xdlfUNLjUA86iOe/FP3gx7kC
AwEAAaOCAQkwggEFMHAGA1UdHwRpMGcwZaBjoGGkXzBdMQswCQYDVQQGEwJVUzEQ
MA4GA1UEChMHRXF1aWZheDEtMCsGA1UECxMkRXF1aWZheCBTZWN1cmUgQ2VydGlm
aWNhdGUgQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMBoGA1UdEAQTMBGBDzIwMTgw
ODIyMTY0MTUxWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAUSOZo+SvSspXXR9gj
IBBPM5iQn9QwHQYDVR0OBBYEFEjmaPkr0rKV10fYIyAQTzOYkJ/UMAwGA1UdEwQF
MAMBAf8wGgYJKoZIhvZ9B0EABA0wCxsFVjMuMGMDAgbAMA0GCSqGSIb3DQEBBQUA
A4GBAFjOKer89961zgK5F7WF0bnj4JXMJTENAKaSbn+2kmOeUJXRmm/kEd5jhW6Y
7qj/WsjTVbJmcVfewCHrPSqnI0kBBIZCe/zuf6IWUrVnZ9NA2zsmWLIodz2uFHdh
1voqZiegDfqnc1zqcPGUIWVEX/r87yloqaKHee9570+sB3c4
-----END CERTIFICATE-----
...EOF...
cat >certs/equifax-secure-ebusiness-ca-1.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 4 (0x4)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=Equifax Secure Inc., CN=Equifax Secure eBusiness CA-1
        Validity
            Not Before: Jun 21 04:00:00 1999 GMT
            Not After : Jun 21 04:00:00 2020 GMT
        Subject: C=US, O=Equifax Secure Inc., CN=Equifax Secure eBusiness CA-1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ce:2f:19:bc:17:b7:77:de:93:a9:5f:5a:0d:17:
                    4f:34:1a:0c:98:f4:22:d9:59:d4:c4:68:46:f0:b4:
                    35:c5:85:03:20:c6:af:45:a5:21:51:45:41:eb:16:
                    58:36:32:6f:e2:50:62:64:f9:fd:51:9c:aa:24:d9:
                    f4:9d:83:2a:87:0a:21:d3:12:38:34:6c:8d:00:6e:
                    5a:a0:d9:42:ee:1a:21:95:f9:52:4c:55:5a:c5:0f:
                    38:4f:46:fa:6d:f8:2e:35:d6:1d:7c:eb:e2:f0:b0:
                    75:80:c8:a9:13:ac:be:88:ef:3a:6e:ab:5f:2a:38:
                    62:02:b0:12:7b:fe:8f:a6:03
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Authority Key Identifier: 
            keyid:4A:78:32:52:11:DB:59:16:36:5E:DF:C1:14:36:40:6A:47:7C:4C:A1

            X509v3 Subject Key Identifier: 
            4A:78:32:52:11:DB:59:16:36:5E:DF:C1:14:36:40:6A:47:7C:4C:A1
    Signature Algorithm: md5WithRSAEncryption
        75:5b:a8:9b:03:11:e6:e9:56:4c:cd:f9:a9:4c:c0:0d:9a:f3:
        cc:65:69:e6:25:76:cc:59:b7:d6:54:c3:1d:cd:99:ac:19:dd:
        b4:85:d5:e0:3d:fc:62:20:a7:84:4b:58:65:f1:e2:f9:95:21:
        3f:f5:d4:7e:58:1e:47:87:54:3e:58:a1:b5:b5:f8:2a:ef:71:
        e7:bc:c3:f6:b1:49:46:e2:d7:a0:6b:e5:56:7a:9a:27:98:7c:
        46:62:14:e7:c9:fc:6e:03:12:79:80:38:1d:48:82:8d:fc:17:
        fe:2a:96:2b:b5:62:a6:a6:3d:bd:7f:92:59:cd:5a:2a:82:b2:
        37:79
-----BEGIN CERTIFICATE-----
MIICgjCCAeugAwIBAgIBBDANBgkqhkiG9w0BAQQFADBTMQswCQYDVQQGEwJVUzEc
MBoGA1UEChMTRXF1aWZheCBTZWN1cmUgSW5jLjEmMCQGA1UEAxMdRXF1aWZheCBT
ZWN1cmUgZUJ1c2luZXNzIENBLTEwHhcNOTkwNjIxMDQwMDAwWhcNMjAwNjIxMDQw
MDAwWjBTMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTRXF1aWZheCBTZWN1cmUgSW5j
LjEmMCQGA1UEAxMdRXF1aWZheCBTZWN1cmUgZUJ1c2luZXNzIENBLTEwgZ8wDQYJ
KoZIhvcNAQEBBQADgY0AMIGJAoGBAM4vGbwXt3fek6lfWg0XTzQaDJj0ItlZ1MRo
RvC0NcWFAyDGr0WlIVFFQesWWDYyb+JQYmT5/VGcqiTZ9J2DKocKIdMSODRsjQBu
WqDZQu4aIZX5UkxVWsUPOE9G+m34LjXWHXzr4vCwdYDIqROsvojvOm6rXyo4YgKw
Env+j6YDAgMBAAGjZjBkMBEGCWCGSAGG+EIBAQQEAwIABzAPBgNVHRMBAf8EBTAD
AQH/MB8GA1UdIwQYMBaAFEp4MlIR21kWNl7fwRQ2QGpHfEyhMB0GA1UdDgQWBBRK
eDJSEdtZFjZe38EUNkBqR3xMoTANBgkqhkiG9w0BAQQFAAOBgQB1W6ibAxHm6VZM
zfmpTMANmvPMZWnmJXbMWbfWVMMdzZmsGd20hdXgPfxiIKeES1hl8eL5lSE/9dR+
WB5Hh1Q+WKG1tfgq73HnvMP2sUlG4tega+VWeponmHxGYhTnyfxuAxJ5gDgdSIKN
/Bf+KpYrtWKmpj29f5JZzVoqgrI3eQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/equifax-secure-equifax-secure-ebusiness.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 930140085 (0x3770cfb5)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Equifax Secure, OU=Equifax Secure eBusiness CA-2
        Validity
            Not Before: Jun 23 12:14:45 1999 GMT
            Not After : Jun 23 12:14:45 2019 GMT
        Subject: C=US, O=Equifax Secure, OU=Equifax Secure eBusiness CA-2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e4:39:39:93:1e:52:06:1b:28:36:f8:b2:a3:29:
                    c5:ed:8e:b2:11:bd:fe:eb:e7:b4:74:c2:8f:ff:05:
                    e7:d9:9d:06:bf:12:c8:3f:0e:f2:d6:d1:24:b2:11:
                    de:d1:73:09:8a:d4:b1:2c:98:09:0d:1e:50:46:b2:
                    83:a6:45:8d:62:68:bb:85:1b:20:70:32:aa:40:cd:
                    a6:96:5f:c4:71:37:3f:04:f3:b7:41:24:39:07:1a:
                    1e:2e:61:58:a0:12:0b:e5:a5:df:c5:ab:ea:37:71:
                    cc:1c:c8:37:3a:b9:97:52:a7:ac:c5:6a:24:94:4e:
                    9c:7b:cf:c0:6a:d6:df:21:bd
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 CRL Distribution Points: 
            DirName:/C=US/O=Equifax Secure/OU=Equifax Secure eBusiness CA-2/CN=CRL1

            X509v3 Private Key Usage Period: 
            Not After: Jun 23 12:14:45 2019 GMT
            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:50:9E:0B:EA:AF:5E:B9:20:48:A6:50:6A:CB:FD:D8:20:7A:A7:82:76

            X509v3 Subject Key Identifier: 
            50:9E:0B:EA:AF:5E:B9:20:48:A6:50:6A:CB:FD:D8:20:7A:A7:82:76
            X509v3 Basic Constraints: 
            CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V3.0c....
    Signature Algorithm: sha1WithRSAEncryption
        0c:86:82:ad:e8:4e:1a:f5:8e:89:27:e2:35:58:3d:29:b4:07:
        8f:36:50:95:bf:6e:c1:9e:eb:c4:90:b2:85:a8:bb:b7:42:e0:
        0f:07:39:df:fb:9e:90:b2:d1:c1:3e:53:9f:03:44:b0:7e:4b:
        f4:6f:e4:7c:1f:e7:e2:b1:e4:b8:9a:ef:c3:bd:ce:de:0b:32:
        34:d9:de:28:ed:33:6b:c4:d4:d7:3d:12:58:ab:7d:09:2d:cb:
        70:f5:13:8a:94:a1:27:a4:d6:70:c5:6d:94:b5:c9:7d:9d:a0:
        d2:c6:08:49:d9:66:9b:a6:d3:f4:0b:dc:c5:26:57:e1:91:30:
        ea:cd
-----BEGIN CERTIFICATE-----
MIIDIDCCAomgAwIBAgIEN3DPtTANBgkqhkiG9w0BAQUFADBOMQswCQYDVQQGEwJV
UzEXMBUGA1UEChMORXF1aWZheCBTZWN1cmUxJjAkBgNVBAsTHUVxdWlmYXggU2Vj
dXJlIGVCdXNpbmVzcyBDQS0yMB4XDTk5MDYyMzEyMTQ0NVoXDTE5MDYyMzEyMTQ0
NVowTjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkVxdWlmYXggU2VjdXJlMSYwJAYD
VQQLEx1FcXVpZmF4IFNlY3VyZSBlQnVzaW5lc3MgQ0EtMjCBnzANBgkqhkiG9w0B
AQEFAAOBjQAwgYkCgYEA5Dk5kx5SBhsoNviyoynF7Y6yEb3+6+e0dMKP/wXn2Z0G
vxLIPw7y1tEkshHe0XMJitSxLJgJDR5QRrKDpkWNYmi7hRsgcDKqQM2mll/EcTc/
BPO3QSQ5BxoeLmFYoBIL5aXfxavqN3HMHMg3OrmXUqesxWoklE6ce8/AatbfIb0C
AwEAAaOCAQkwggEFMHAGA1UdHwRpMGcwZaBjoGGkXzBdMQswCQYDVQQGEwJVUzEX
MBUGA1UEChMORXF1aWZheCBTZWN1cmUxJjAkBgNVBAsTHUVxdWlmYXggU2VjdXJl
IGVCdXNpbmVzcyBDQS0yMQ0wCwYDVQQDEwRDUkwxMBoGA1UdEAQTMBGBDzIwMTkw
NjIzMTIxNDQ1WjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAUUJ4L6q9euSBIplBq
y/3YIHqngnYwHQYDVR0OBBYEFFCeC+qvXrkgSKZQasv92CB6p4J2MAwGA1UdEwQF
MAMBAf8wGgYJKoZIhvZ9B0EABA0wCxsFVjMuMGMDAgbAMA0GCSqGSIb3DQEBBQUA
A4GBAAyGgq3oThr1jokn4jVYPSm0B482UJW/bsGe68SQsoWou7dC4A8HOd/7npCy
0cE+U58DRLB+S/Rv5Hwf5+Kx5Lia78O9zt4LMjTZ3ijtM2vE1Nc9ElirfQkty3D1
E4qUoSek1nDFbZS1yX2doNLGCEnZZpum0/QL3MUmV+GRMOrN
-----END CERTIFICATE-----
...EOF...
cat >certs/equifax-secure-global-ebusiness.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=Equifax Secure Inc., CN=Equifax Secure Global eBusiness CA-1
        Validity
            Not Before: Jun 21 04:00:00 1999 GMT
            Not After : Jun 21 04:00:00 2020 GMT
        Subject: C=US, O=Equifax Secure Inc., CN=Equifax Secure Global eBusiness CA-1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ba:e7:17:90:02:65:b1:34:55:3c:49:c2:51:d5:
                    df:a7:d1:37:8f:d1:e7:81:73:41:52:60:9b:9d:a1:
                    17:26:78:ad:c7:b1:e8:26:94:32:b5:de:33:8d:3a:
                    2f:db:f2:9a:7a:5a:73:98:a3:5c:e9:fb:8a:73:1b:
                    5c:e7:c3:bf:80:6c:cd:a9:f4:d6:2b:c0:f7:f9:99:
                    aa:63:a2:b1:47:02:0f:d4:e4:51:3a:12:3c:6c:8a:
                    5a:54:84:70:db:c1:c5:90:cf:72:45:cb:a8:59:c0:
                    cd:33:9d:3f:a3:96:eb:85:33:21:1c:3e:1e:3e:60:
                    6e:76:9c:67:85:c5:c8:c3:61
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Authority Key Identifier: 
            keyid:BE:A8:A0:74:72:50:6B:44:B7:C9:23:D8:FB:A8:FF:B3:57:6B:68:6C

            X509v3 Subject Key Identifier: 
            BE:A8:A0:74:72:50:6B:44:B7:C9:23:D8:FB:A8:FF:B3:57:6B:68:6C
    Signature Algorithm: md5WithRSAEncryption
        30:e2:01:51:aa:c7:ea:5f:da:b9:d0:65:0f:30:d6:3e:da:0d:
        14:49:6e:91:93:27:14:31:ef:c4:f7:2d:45:f8:ec:c7:bf:a2:
        41:0d:23:b4:92:f9:19:00:67:bd:01:af:cd:e0:71:fc:5a:cf:
        64:c4:e0:96:98:d0:a3:40:e2:01:8a:ef:27:07:f1:65:01:8a:
        44:2d:06:65:75:52:c0:86:10:20:21:5f:6c:6b:0f:6c:ae:09:
        1c:af:f2:a2:18:34:c4:75:a4:73:1c:f1:8d:dc:ef:ad:f9:b3:
        76:b4:92:bf:dc:95:10:1e:be:cb:c8:3b:5a:84:60:19:56:94:
        a9:55
-----BEGIN CERTIFICATE-----
MIICkDCCAfmgAwIBAgIBATANBgkqhkiG9w0BAQQFADBaMQswCQYDVQQGEwJVUzEc
MBoGA1UEChMTRXF1aWZheCBTZWN1cmUgSW5jLjEtMCsGA1UEAxMkRXF1aWZheCBT
ZWN1cmUgR2xvYmFsIGVCdXNpbmVzcyBDQS0xMB4XDTk5MDYyMTA0MDAwMFoXDTIw
MDYyMTA0MDAwMFowWjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0VxdWlmYXggU2Vj
dXJlIEluYy4xLTArBgNVBAMTJEVxdWlmYXggU2VjdXJlIEdsb2JhbCBlQnVzaW5l
c3MgQ0EtMTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAuucXkAJlsTRVPEnC
UdXfp9E3j9HngXNBUmCbnaEXJnitx7HoJpQytd4zjTov2/KaelpzmKNc6fuKcxtc
58O/gGzNqfTWK8D3+ZmqY6KxRwIP1ORROhI8bIpaVIRw28HFkM9yRcuoWcDNM50/
o5brhTMhHD4ePmBudpxnhcXIw2ECAwEAAaNmMGQwEQYJYIZIAYb4QgEBBAQDAgAH
MA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAUvqigdHJQa0S3ySPY+6j/s1dr
aGwwHQYDVR0OBBYEFL6ooHRyUGtEt8kj2Puo/7NXa2hsMA0GCSqGSIb3DQEBBAUA
A4GBADDiAVGqx+pf2rnQZQ8w1j7aDRRJbpGTJxQx78T3LUX47Me/okENI7SS+RkA
Z70Br83gcfxaz2TE4JaY0KNA4gGK7ycH8WUBikQtBmV1UsCGECAhX2xrD2yuCRyv
8qIYNMR1pHMc8Y3c7635s3a0kr/clRAevsvIO1qEYBlWlKlV
-----END CERTIFICATE-----
...EOF...
cat >certs/fortengine.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CA, ST=ON, L=Toronto, O=FortEngine Inc., OU=Certification Authority Division, CN=fortengine/emailAddress=ca@fortengine.com
        Validity
            Not Before: Jan  1 00:00:00 1998 GMT
            Not After : Jan 17 00:00:00 2038 GMT
        Subject: C=CA, ST=ON, L=Toronto, O=FortEngine Inc., OU=Certification Authority Division, CN=fortengine/emailAddress=ca@fortengine.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (4096 bit)
                Modulus (4096 bit):
                    00:ca:be:c6:6e:9c:03:c7:1d:6f:dc:46:1b:a3:48:
                    1c:3b:e9:62:80:48:65:0e:a1:b6:7b:bb:bf:01:b5:
                    86:a1:50:2a:73:cf:aa:e9:ab:94:25:4b:73:e2:2e:
                    e8:87:4c:8d:69:db:b5:a3:d9:29:5d:6f:b3:9e:48:
                    0e:d3:39:6b:82:31:ac:92:aa:8c:3b:5a:28:a6:9c:
                    d3:25:d1:72:fc:ff:20:47:ac:75:22:eb:f7:91:6b:
                    57:3a:ec:f0:3c:f1:23:bf:4f:4b:5a:58:72:26:c3:
                    7e:a1:4e:33:b5:35:5f:d3:b2:34:43:dc:d8:ba:97:
                    28:0d:0e:7c:5c:a4:61:78:8f:4a:74:30:76:0d:84:
                    a6:c7:2c:00:59:22:d0:c0:87:86:d1:06:bb:82:fa:
                    24:79:09:69:92:09:04:0b:bb:e2:11:e7:09:df:be:
                    76:29:70:49:1e:78:7b:02:ce:75:9b:19:e5:a6:61:
                    ba:b0:3c:ba:ec:49:62:1c:3c:39:b4:71:13:46:a6:
                    ed:9e:c7:06:06:3b:24:19:00:6a:47:9c:6d:ef:e4:
                    27:9e:d8:59:ac:df:07:24:70:e8:6b:dc:e0:19:ea:
                    61:c2:2c:e1:90:be:38:95:72:c5:60:af:56:e5:78:
                    45:6d:b9:70:d9:cf:a6:01:c1:e4:a2:44:62:c0:3e:
                    c2:3d:e2:28:c8:3d:9a:fc:97:30:de:7e:61:7a:02:
                    93:94:d8:5d:e0:11:46:54:5e:89:47:b8:05:38:59:
                    36:41:f1:d7:8a:de:6e:b6:1b:22:8f:d5:e1:97:b5:
                    80:81:05:2a:2e:08:20:0f:d3:29:86:a3:df:e2:76:
                    3a:e8:e6:54:25:5f:59:b2:60:7e:41:fa:7c:52:2c:
                    c1:d1:60:0e:7a:06:9c:b4:a5:72:46:a1:ed:45:af:
                    8a:20:45:d0:5c:db:59:82:37:26:32:4f:42:62:43:
                    f4:9c:86:ca:b6:02:97:68:7e:be:f5:53:07:34:ea:
                    f2:0a:71:44:ee:94:ac:b8:f5:24:ca:99:dc:15:60:
                    87:19:27:a2:14:ed:f0:e3:0e:09:e1:cb:25:b7:10:
                    40:0d:0c:f1:7d:1b:b9:29:99:e5:4e:84:0d:ed:b5:
                    69:23:f4:37:d6:d5:57:13:96:e3:ac:97:2a:e8:e8:
                    ff:39:3a:99:dc:80:fe:3a:a6:e4:51:d0:20:d2:08:
                    23:44:a7:13:83:19:cb:1d:df:c0:6c:cc:c9:e8:fb:
                    1c:94:30:df:ed:c2:ec:d1:64:a5:c4:cc:50:47:fc:
                    f9:6c:d4:93:d6:b3:6d:4f:da:ec:8a:fd:93:3a:17:
                    ef:08:1c:4e:f4:03:a3:06:2a:0e:f0:f2:ce:d3:7d:
                    87:4c:d1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        57:20:69:3d:67:d3:d9:53:b2:bd:5a:6c:94:62:b1:f2:1d:3e:
        09:63:fc:72:29:72:80:64:6d:64:9e:5d:00:9c:dc:ff:fd:51:
        10:01:dd:bc:af:93:81:9e:05:a3:3d:dd:a8:78:57:23:e4:4d:
        37:41:69:ce:e5:9a:60:c8:d6:65:34:b4:90:09:9c:39:0b:86:
        63:53:a8:e0:f1:a5:3c:72:36:d6:93:73:db:da:05:0d:32:6b:
        d1:99:8b:04:9e:09:29:5b:04:da:ca:09:83:9e:63:76:4f:4c:
        64:70:3b:2b:ff:fb:1c:7f:51:b2:6a:d6:64:e1:39:0d:90:e5:
        af:1a:7a:fa:76:a2:c6:13:30:9e:53:ca:2a:2b:08:cb:d1:8d:
        65:43:ea:19:d5:16:00:13:1d:07:f0:54:55:53:65:35:4e:53:
        b5:6a:48:5d:40:a5:31:df:1a:f9:ea:0a:70:8b:41:79:85:e8:
        c2:41:ce:06:98:a7:3e:40:d7:dd:c9:45:0c:85:1f:5a:2c:34:
        46:8d:3c:b3:c4:ab:ac:5a:91:f1:2c:f0:6e:b8:f9:d9:7b:f5:
        44:ce:7a:a0:6a:82:8e:79:2f:25:cb:71:8a:13:83:57:b3:5c:
        a7:1a:00:16:32:19:a2:40:e8:9b:4a:ba:cc:fa:eb:4d:4b:0b:
        15:0a:2f:3e:5a:2f:73:7c:39:86:60:0b:88:33:2c:85:a4:ef:
        13:59:e6:dc:fb:27:e3:24:3e:16:54:44:f1:ea:53:66:b4:22:
        20:6c:a9:66:46:42:ea:57:33:d2:66:1a:c2:e7:96:71:38:58:
        58:61:61:54:6e:24:b5:0c:ce:8e:33:51:b0:dc:68:a5:6f:96:
        ed:c1:75:cd:04:f1:89:65:03:9f:12:0a:4a:3e:e0:b5:d4:36:
        8e:2b:9b:c4:41:21:7d:56:a0:af:c0:cc:b4:07:1c:35:54:d9:
        55:44:69:1a:2e:7a:4e:9b:4e:3a:ea:2d:ad:3a:aa:0b:ed:86:
        be:25:b8:86:5c:6f:76:f9:ae:40:dd:0e:95:79:54:c3:3c:f6:
        4e:bc:5c:15:a9:8d:9e:e0:39:e2:56:70:ff:c6:ab:2e:dc:6c:
        16:61:eb:72:73:f0:e7:7f:b5:b2:9b:a6:2c:3d:12:e5:49:31:
        1c:db:b8:d2:1e:8b:21:5a:59:cf:71:fe:d2:b2:f3:b8:5a:1f:
        4d:f8:b2:32:37:1f:2b:60:32:1d:04:e0:50:26:ec:ae:f8:0d:
        b8:b0:d0:51:bc:85:19:57:21:74:55:24:87:3b:57:dc:38:44:
        56:7c:67:9e:ba:58:e0:15:63:41:d4:ea:58:8b:f0:ee:51:a5:
        4a:e0:c2:8f:11:10:00:e7
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-partners-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b9:d1:af
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Jan 28 12:00:00 1999 GMT
            Not After : Jan 28 12:00:00 2009 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Partners CA, CN=GlobalSign Partners CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:d2:2c:f8:32:ac:4a:12:7a:37:c8:29:91:a5:ae:
                    8c:6e:1e:0e:c0:34:33:88:e5:33:71:16:1c:78:84:
                    68:c3:18:34:50:2e:16:3e:b1:94:82:4f:b1:9a:9f:
                    00:f8:c6:11:35:c6:69:7b:98:02:ad:00:06:88:6c:
                    e7:4c:33:28:00:88:27:46:1f:87:b3:71:75:63:bc:
                    32:bb:88:de:66:18:0e:50:06:93:b4:f6:bc:14:37:
                    30:3d:22:df:3d:ff:75:7e:d9:0a:1a:c5:9f:b3:fc:
                    d0:ac:b3:08:7a:89:d3:01:e8:00:5c:e7:4a:0b:3d:
                    4d:7b:26:a2:b7:62:06:8b:da:46:dd:93:17:3f:3f:
                    5b:02:4b:0b:b6:88:20:11:92:00:ad:bb:c7:2e:d4:
                    e3:45:ae:f5:89:5a:7c:8d:a4:ad:85:64:32:c0:27:
                    8c:c6:f2:8a:80:92:86:24:56:59:8d:74:68:a2:83:
                    42:b3:9e:3d:50:41:86:6f:20:6e:f6:fd:ce:d3:19:
                    e3:32:cc:8f:ed:9a:5e:6d:1f:28:f5:52:ac:6e:18:
                    5e:f8:3d:d1:92:e5:ba:6c:01:88:4b:0a:f2:2d:de:
                    65:33:05:42:a0:4c:aa:31:76:be:fd:bf:81:78:f9:
                    71:1c:46:5e:2d:15:95:2d:30:59:8e:4c:41:d1:62:
                    ab:3d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
            43:24:8D:70:15:08:62:55:9C:4F:0C:40:17:5D:86:5E:0F:A2:4C:FB
            X509v3 Authority Key Identifier: 
            keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        66:ed:b4:88:69:11:99:82:21:83:ac:a1:6d:8b:9b:84:ad:0f:
        2d:c8:1e:8c:ca:7b:7e:ad:aa:d4:8e:de:07:d6:9e:45:c7:a5:
        b8:9c:07:39:60:25:55:1a:c0:4f:19:e5:cf:17:29:49:89:18:
        35:66:e5:eb:28:40:4e:57:c9:af:b3:e4:b8:20:05:a3:3b:95:
        50:91:49:94:29:7d:2c:e5:88:41:a5:45:88:5e:9d:82:27:f7:
        d2:ef:5b:b5:4f:9f:be:fe:35:65:2c:55:64:9f:e1:51:da:22:
        61:77:ba:58:4e:8f:c6:79:59:59:6e:30:80:a2:4f:90:6e:21:
        0b:ad:d0:68:39:90:10:9b:ed:22:65:6f:1e:11:38:e6:7f:8c:
        d2:f3:39:6d:47:d5:21:e8:ea:75:3a:41:d1:ad:f6:16:9d:5d:
        0b:21:bd:f3:1f:63:06:25:1d:c1:1f:35:71:2c:eb:20:19:d5:
        c1:b0:ec:3d:e5:6f:ed:02:07:3f:13:7b:66:92:d6:44:c1:98:
        f7:5f:50:8b:7a:5b:c2:6f:6d:b0:d1:f8:e5:74:a0:40:37:a3:
        25:0f:e4:3d:ca:64:31:93:90:5c:30:7b:b9:39:31:9a:5e:4c:
        cd:b9:41:4f:50:e4:3d:38:ae:c8:66:d9:c7:3b:5d:51:47:ac:
        9b:ab:f2:ad
-----BEGIN CERTIFICATE-----
MIIDnjCCAoagAwIBAgILAgAAAAAA1ni50a8wDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05OTAxMjgxMjAw
MDBaFw0wOTAxMjgxMjAwMDBaMF8xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRQwEgYDVQQLEwtQYXJ0bmVycyBDQTEfMB0GA1UEAxMWR2xv
YmFsU2lnbiBQYXJ0bmVycyBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
ggEBANIs+DKsShJ6N8gpkaWujG4eDsA0M4jlM3EWHHiEaMMYNFAuFj6xlIJPsZqf
APjGETXGaXuYAq0ABohs50wzKACIJ0Yfh7NxdWO8MruI3mYYDlAGk7T2vBQ3MD0i
3z3/dX7ZChrFn7P80KyzCHqJ0wHoAFznSgs9TXsmordiBovaRt2TFz8/WwJLC7aI
IBGSAK27xy7U40Wu9YlafI2krYVkMsAnjMbyioCShiRWWY10aKKDQrOePVBBhm8g
bvb9ztMZ4zLMj+2aXm0fKPVSrG4YXvg90ZLlumwBiEsK8i3eZTMFQqBMqjF2vv2/
gXj5cRxGXi0VlS0wWY5MQdFiqz0CAwEAAaNjMGEwDgYDVR0PAQH/BAQDAgAGMB0G
A1UdDgQWBBRDJI1wFQhiVZxPDEAXXYZeD6JM+zAfBgNVHSMEGDAWgBRge2YaRQ2X
yolQL30EzTSo//z9SzAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBAUAA4IB
AQBm7bSIaRGZgiGDrKFti5uErQ8tyB6Mynt+rarUjt4H1p5Fx6W4nAc5YCVVGsBP
GeXPFylJiRg1ZuXrKEBOV8mvs+S4IAWjO5VQkUmUKX0s5YhBpUWIXp2CJ/fS71u1
T5++/jVlLFVkn+FR2iJhd7pYTo/GeVlZbjCAok+QbiELrdBoOZAQm+0iZW8eETjm
f4zS8zltR9Uh6Op1OkHRrfYWnV0LIb3zH2MGJR3BHzVxLOsgGdXBsOw95W/tAgc/
E3tmktZEwZj3X1CLelvCb22w0fjldKBAN6MlD+Q9ymQxk5BcMHu5OTGaXkzNuUFP
UOQ9OK7IZtnHO11RR6ybq/Kt
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-primary-class-1-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b8:37:cf
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Sep 15 12:00:00 1998 GMT
            Not After : Jan 28 12:00:00 2009 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Primary Class 1 CA, CN=GlobalSign Primary Class 1 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:bd:20:35:47:d1:28:d6:08:a3:12:39:23:47:0d:
                    bd:70:21:52:0e:57:31:95:a6:34:57:6b:ec:7e:43:
                    79:c3:06:52:48:cd:bc:b5:a1:99:bd:d8:1f:32:bc:
                    cf:d7:6e:72:6d:2e:77:22:90:82:4e:4b:8f:9a:0c:
                    01:42:9a:d9:70:59:b6:9d:1f:e6:63:d1:0c:ad:1d:
                    4e:f8:85:81:f9:ae:ef:9f:a6:52:61:44:79:1a:75:
                    45:e0:61:56:45:6d:42:8c:3d:72:cb:a6:a4:12:b7:
                    9a:f5:d6:60:d0:60:50:b3:8e:a6:a6:ec:b4:f4:12:
                    cd:7f:a8:ce:ef:b3:e1:85:30:fe:72:c4:e6:e7:77:
                    b3:9e:58:41:d6:51:83:88:07:c6:b6:69:4f:36:de:
                    d1:0b:48:3f:bd:d6:9f:21:74:64:6f:27:06:3e:4b:
                    fd:0e:a6:9b:bf:a4:48:57:8c:90:ee:89:18:0b:02:
                    81:18:be:67:fe:53:60:88:27:ba:a3:73:34:4b:5a:
                    56:b4:de:73:05:ed:98:96:5d:ec:4a:e7:40:fc:4b:
                    09:62:eb:d0:e3:31:4f:85:d1:7a:ab:59:67:2b:fb:
                    88:0f:eb:aa:83:bd:35:fd:61:27:ec:66:0e:42:57:
                    f7:69:c2:0c:ef:fc:6a:c2:6e:49:da:8f:41:38:ae:
                    48:a9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
            FC:E0:66:F6:5A:35:99:EB:40:1E:D2:B8:1E:43:BC:98:8E:1F:8A:C3
            X509v3 Authority Key Identifier: 
            keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        9b:a3:08:44:ce:f2:90:9d:71:f3:32:b3:05:6a:b5:ea:cf:29:
        98:de:55:3e:a0:16:7d:06:7a:44:d6:af:d2:fa:13:58:8c:f8:
        1c:c7:ab:1d:b4:1b:ef:69:68:98:5c:08:39:8f:e0:f7:fb:48:
        cc:21:e7:b8:33:db:05:aa:34:24:6c:4a:e5:e9:7b:60:de:83:
        b3:1f:0a:be:41:75:fc:cc:30:48:b7:c1:26:1d:04:33:aa:b6:
        78:ed:2a:cb:ba:56:97:32:6e:f7:31:95:2e:46:f2:14:ee:27:
        c7:f7:62:89:b9:5c:5a:d3:38:8a:64:f5:37:b4:f1:b3:34:72:
        d5:d5:21:3d:4b:d7:78:93:d7:31:66:35:1e:a3:d8:47:49:6f:
        1c:ad:e1:80:7f:f8:98:24:6c:73:ac:0e:c2:1a:77:02:a3:26:
        07:b7:c7:6b:5d:bc:82:d5:2a:48:1d:63:cf:50:32:a6:fb:1c:
        18:47:15:0a:5b:0c:5c:38:24:9a:04:98:a8:08:48:5f:7c:34:
        87:63:ab:2d:8d:4c:00:77:94:1b:76:ba:f5:16:18:a3:15:af:
        2f:94:f6:29:00:76:c1:15:17:d3:e9:37:4d:76:d4:cb:4b:29:
        59:24:ac:da:4a:a0:ea:63:de:5f:54:b1:fa:f3:d1:45:cb:c5:
        64:b4:73:21
-----BEGIN CERTIFICATE-----
MIIDrDCCApSgAwIBAgILAgAAAAAA1ni4N88wDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MTUxMjAw
MDBaFw0wOTAxMjgxMjAwMDBaMG0xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRswGQYDVQQLExJQcmltYXJ5IENsYXNzIDEgQ0ExJjAkBgNV
BAMTHUdsb2JhbFNpZ24gUHJpbWFyeSBDbGFzcyAxIENBMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEAvSA1R9Eo1gijEjkjRw29cCFSDlcxlaY0V2vsfkN5
wwZSSM28taGZvdgfMrzP125ybS53IpCCTkuPmgwBQprZcFm2nR/mY9EMrR1O+IWB
+a7vn6ZSYUR5GnVF4GFWRW1CjD1yy6akErea9dZg0GBQs46mpuy09BLNf6jO77Ph
hTD+csTm53eznlhB1lGDiAfGtmlPNt7RC0g/vdafIXRkbycGPkv9Dqabv6RIV4yQ
7okYCwKBGL5n/lNgiCe6o3M0S1pWtN5zBe2Yll3sSudA/EsJYuvQ4zFPhdF6q1ln
K/uID+uqg701/WEn7GYOQlf3acIM7/xqwm5J2o9BOK5IqQIDAQABo2MwYTAOBgNV
HQ8BAf8EBAMCAAYwHQYDVR0OBBYEFPzgZvZaNZnrQB7SuB5DvJiOH4rDMB8GA1Ud
IwQYMBaAFGB7ZhpFDZfKiVAvfQTNNKj//P1LMA8GA1UdEwEB/wQFMAMBAf8wDQYJ
KoZIhvcNAQEEBQADggEBAJujCETO8pCdcfMyswVqterPKZjeVT6gFn0GekTWr9L6
E1iM+BzHqx20G+9paJhcCDmP4Pf7SMwh57gz2wWqNCRsSuXpe2Deg7MfCr5BdfzM
MEi3wSYdBDOqtnjtKsu6VpcybvcxlS5G8hTuJ8f3Yom5XFrTOIpk9Te08bM0ctXV
IT1L13iT1zFmNR6j2EdJbxyt4YB/+JgkbHOsDsIadwKjJge3x2tdvILVKkgdY89Q
Mqb7HBhHFQpbDFw4JJoEmKgISF98NIdjqy2NTAB3lBt2uvUWGKMVry+U9ikAdsEV
F9PpN0121MtLKVkkrNpKoOpj3l9Usfrz0UXLxWS0cyE=
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-primary-class-2-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b8:8d:8d
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Jan 28 12:00:00 1999 GMT
            Not After : Jan 28 12:00:00 2009 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Primary Class 2 CA, CN=GlobalSign Primary Class 2 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:92:8c:fe:ef:f4:45:8e:17:41:6e:fc:d8:bf:21:
                    6f:ab:06:9d:52:c1:2c:00:9d:3f:8e:85:b8:7f:4a:
                    8f:bd:a0:63:2a:ca:49:27:ae:5a:82:f4:74:e2:55:
                    92:ff:c2:d1:aa:79:a2:b6:fa:d5:9d:82:04:4f:c6:
                    b2:c6:5e:63:a7:3a:ba:d8:ee:eb:8a:6f:9f:b6:bb:
                    28:41:c0:22:fb:4e:48:1a:06:92:d7:bf:d7:cf:b9:
                    d9:bd:38:4f:3b:0d:44:6e:55:41:fe:fc:09:db:d8:
                    bf:f3:8e:21:f1:e8:12:b5:f6:13:a5:d3:c6:4c:93:
                    22:b0:02:ff:ee:1d:0c:c4:a8:6b:4f:75:68:56:e8:
                    dc:28:12:50:f7:a8:24:9d:2e:24:39:fb:09:05:de:
                    e5:a3:64:49:21:d0:68:7e:71:30:91:b1:60:e0:39:
                    f4:50:f8:7a:4d:98:00:6b:7c:79:ba:4e:ce:4a:e2:
                    ba:36:1d:b7:c5:36:15:95:9c:64:42:ea:5f:c4:ba:
                    f5:40:05:be:e1:3a:59:bd:84:a7:19:b8:de:4d:53:
                    50:ce:07:d1:d2:51:d3:ef:0d:81:6c:e6:e7:6d:cb:
                    5d:7c:3f:7c:cc:ec:4f:83:27:25:ff:70:50:f6:83:
                    59:75:84:06:66:58:2c:de:89:8d:00:a6:49:f9:a5:
                    43:77
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
            7C:E7:B2:B1:2C:DE:B1:A7:6B:E9:76:0C:E1:A3:FD:4E:6C:C7:B9:F6
            X509v3 Authority Key Identifier: 
            keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        63:dd:59:ce:8a:79:aa:98:9d:4e:c5:89:64:37:7e:8a:93:67:
        2f:10:ea:6f:27:c3:8d:77:6d:f2:5c:56:94:19:1a:69:60:30:
        46:5d:8f:f2:6d:45:3c:8e:35:97:7c:2f:b8:51:e2:e8:89:bd:
        88:cf:27:1c:08:34:5c:88:c1:68:24:db:91:85:e4:cf:fb:fb:
        43:8d:e8:25:01:1b:c4:0e:f7:00:42:48:86:1f:24:08:58:5a:
        8c:8d:f2:6b:47:2c:68:91:b1:69:42:fd:0d:8d:c9:26:e6:92:
        86:a6:64:6e:92:c5:ce:3e:3c:7d:71:e3:23:a4:ab:c7:d5:a8:
        a9:df:82:a7:3b:e8:86:d5:c3:4f:18:e3:44:d0:e0:dc:f3:c5:
        68:2e:fe:a5:2f:05:84:c8:7e:47:42:53:6b:87:4a:fe:32:ff:
        5e:3e:70:8c:b7:a8:15:cc:17:c2:ff:46:ec:d0:ec:2d:b4:6e:
        12:28:a9:f9:40:e9:eb:d4:66:97:53:a9:69:55:c0:a9:aa:b2:
        2e:cd:d1:69:f4:be:f8:bb:7c:69:ee:54:a6:db:9e:fb:5a:a6:
        3e:fe:9a:ef:94:51:4b:75:ee:d8:d4:e1:9a:f1:02:56:13:89:
        0e:a7:42:8b:96:8b:85:0c:1b:85:be:26:ae:ab:a6:99:bc:22:
        f1:73:df:42
-----BEGIN CERTIFICATE-----
MIIDrDCCApSgAwIBAgILAgAAAAAA1ni4jY0wDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05OTAxMjgxMjAw
MDBaFw0wOTAxMjgxMjAwMDBaMG0xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRswGQYDVQQLExJQcmltYXJ5IENsYXNzIDIgQ0ExJjAkBgNV
BAMTHUdsb2JhbFNpZ24gUHJpbWFyeSBDbGFzcyAyIENBMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEAkoz+7/RFjhdBbvzYvyFvqwadUsEsAJ0/joW4f0qP
vaBjKspJJ65agvR04lWS/8LRqnmitvrVnYIET8ayxl5jpzq62O7rim+ftrsoQcAi
+05IGgaS17/Xz7nZvThPOw1EblVB/vwJ29i/844h8egStfYTpdPGTJMisAL/7h0M
xKhrT3VoVujcKBJQ96gknS4kOfsJBd7lo2RJIdBofnEwkbFg4Dn0UPh6TZgAa3x5
uk7OSuK6Nh23xTYVlZxkQupfxLr1QAW+4TpZvYSnGbjeTVNQzgfR0lHT7w2BbObn
bctdfD98zOxPgycl/3BQ9oNZdYQGZlgs3omNAKZJ+aVDdwIDAQABo2MwYTAOBgNV
HQ8BAf8EBAMCAAYwHQYDVR0OBBYEFHznsrEs3rGna+l2DOGj/U5sx7n2MB8GA1Ud
IwQYMBaAFGB7ZhpFDZfKiVAvfQTNNKj//P1LMA8GA1UdEwEB/wQFMAMBAf8wDQYJ
KoZIhvcNAQEEBQADggEBAGPdWc6KeaqYnU7FiWQ3foqTZy8Q6m8nw413bfJcVpQZ
GmlgMEZdj/JtRTyONZd8L7hR4uiJvYjPJxwINFyIwWgk25GF5M/7+0ON6CUBG8QO
9wBCSIYfJAhYWoyN8mtHLGiRsWlC/Q2NySbmkoamZG6Sxc4+PH1x4yOkq8fVqKnf
gqc76IbVw08Y40TQ4NzzxWgu/qUvBYTIfkdCU2uHSv4y/14+cIy3qBXMF8L/RuzQ
7C20bhIoqflA6evUZpdTqWlVwKmqsi7N0Wn0vvi7fGnuVKbbnvtapj7+mu+UUUt1
7tjU4ZrxAlYTiQ6nQouWi4UMG4W+Jq6rppm8IvFz30I=
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-primary-class-3-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b8:d6:c3
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Jan 28 12:00:00 1999 GMT
            Not After : Jan 28 12:00:00 2009 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Primary Class 3 CA, CN=GlobalSign Primary Class 3 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:91:5e:56:65:d6:c0:c0:04:9c:bf:47:c4:5c:7b:
                    7a:31:01:f9:58:96:99:e3:1c:84:2f:dc:56:8f:ad:
                    f5:59:81:d5:43:66:5d:5a:93:8c:75:ca:a9:e7:11:
                    c1:51:10:14:60:c9:2c:d4:7b:af:c6:77:86:ab:7a:
                    27:ae:6f:95:b9:0b:ca:b6:46:fb:7e:1a:f4:0d:14:
                    6d:d2:c9:4e:b2:ae:f0:54:f6:5c:40:4c:36:48:74:
                    e8:54:8c:65:66:10:a7:bd:2b:b7:20:8d:05:49:ad:
                    78:7d:d2:24:23:50:e3:f0:b4:79:9b:01:39:ff:af:
                    3b:d3:2d:ee:e1:49:8d:8d:2f:3c:6a:41:45:2f:9b:
                    e3:3d:e1:12:e4:91:75:9e:cf:a0:3e:3c:92:81:6f:
                    8a:2e:18:dc:e0:f2:8c:8c:fd:87:d9:07:f4:40:94:
                    c9:4e:4f:43:df:67:56:6f:bd:03:50:7c:99:67:a4:
                    b9:3c:91:6c:02:6e:84:d6:fc:46:f7:cc:6f:18:3e:
                    17:f0:ef:0b:64:16:57:e6:ac:86:f1:48:aa:43:c1:
                    c9:27:78:73:44:45:e2:85:7d:ba:ff:b3:e1:fb:1b:
                    05:a4:4b:3b:99:12:25:01:50:14:6a:af:5d:ea:c8:
                    0c:ee:e4:da:ec:4b:8b:5c:68:13:95:dc:c3:b5:30:
                    3a:d7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
            CC:36:CC:17:B4:45:91:2F:ED:CF:3B:30:48:77:FB:B5:14:99:BE:E3
            X509v3 Authority Key Identifier: 
            keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        57:b2:54:cc:bd:95:17:64:60:89:b6:53:91:0c:45:92:c3:3d:
        a8:6c:c3:cc:b2:18:f5:78:41:74:d8:7d:a3:27:af:77:0d:59:
        3e:94:1d:69:fa:89:d3:0c:bd:1a:01:f4:3f:e8:e0:77:1a:82:
        28:5a:e6:62:d7:b7:e3:36:c9:0e:9f:7a:e3:c2:d3:cc:59:89:
        0c:ef:16:8b:f0:36:77:22:ca:a4:b6:b7:c1:42:67:01:40:63:
        cc:e7:38:64:87:5b:14:96:66:7b:2d:14:ee:bd:49:6d:ff:77:
        d0:e2:4e:5b:d3:80:c2:4d:0f:ca:b8:9d:81:97:a7:34:6e:c7:
        e3:9c:48:e5:b4:aa:45:f5:f6:65:4c:48:f2:12:c2:d2:93:8c:
        c2:15:24:f3:2b:52:ff:e3:08:ae:b8:6e:d6:2c:12:cf:39:cb:
        12:2a:e7:a9:7b:5f:98:3d:a3:e1:cc:a6:63:89:5c:7d:31:75:
        f9:d5:d6:5d:f2:d0:d4:3d:df:9e:71:a8:0e:dc:e4:20:97:78:
        e6:7f:53:a4:0d:51:4f:8e:3b:03:ae:a3:0d:5a:4d:c3:79:e7:
        35:58:70:42:c9:5e:a1:5e:b4:d9:22:a3:44:53:35:a4:d0:cf:
        73:80:c5:cf:9f:56:98:76:f9:14:4c:77:87:82:c9:dc:7e:5d:
        34:d5:36:75
-----BEGIN CERTIFICATE-----
MIIDrDCCApSgAwIBAgILAgAAAAAA1ni41sMwDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05OTAxMjgxMjAw
MDBaFw0wOTAxMjgxMjAwMDBaMG0xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRswGQYDVQQLExJQcmltYXJ5IENsYXNzIDMgQ0ExJjAkBgNV
BAMTHUdsb2JhbFNpZ24gUHJpbWFyeSBDbGFzcyAzIENBMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEAkV5WZdbAwAScv0fEXHt6MQH5WJaZ4xyEL9xWj631
WYHVQ2ZdWpOMdcqp5xHBURAUYMks1HuvxneGq3onrm+VuQvKtkb7fhr0DRRt0slO
sq7wVPZcQEw2SHToVIxlZhCnvSu3II0FSa14fdIkI1Dj8LR5mwE5/6870y3u4UmN
jS88akFFL5vjPeES5JF1ns+gPjySgW+KLhjc4PKMjP2H2Qf0QJTJTk9D32dWb70D
UHyZZ6S5PJFsAm6E1vxG98xvGD4X8O8LZBZX5qyG8UiqQ8HJJ3hzREXihX26/7Ph
+xsFpEs7mRIlAVAUaq9d6sgM7uTa7EuLXGgTldzDtTA61wIDAQABo2MwYTAOBgNV
HQ8BAf8EBAMCAAYwHQYDVR0OBBYEFMw2zBe0RZEv7c87MEh3+7UUmb7jMB8GA1Ud
IwQYMBaAFGB7ZhpFDZfKiVAvfQTNNKj//P1LMA8GA1UdEwEB/wQFMAMBAf8wDQYJ
KoZIhvcNAQEEBQADggEBAFeyVMy9lRdkYIm2U5EMRZLDPahsw8yyGPV4QXTYfaMn
r3cNWT6UHWn6idMMvRoB9D/o4Hcagiha5mLXt+M2yQ6feuPC08xZiQzvFovwNnci
yqS2t8FCZwFAY8znOGSHWxSWZnstFO69SW3/d9DiTlvTgMJND8q4nYGXpzRux+Oc
SOW0qkX19mVMSPISwtKTjMIVJPMrUv/jCK64btYsEs85yxIq56l7X5g9o+HMpmOJ
XH0xdfnV1l3y0NQ9355xqA7c5CCXeOZ/U6QNUU+OOwOuow1aTcN55zVYcELJXqFe
tNkio0RTNaTQz3OAxc+fVph2+RRMd4eCydx+XTTVNnU=
-----END CERTIFICATE-----
...EOF...
cat >certs/globalsign-root-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:00:00:00:00:00:d6:78:b7:94:05
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Sep  1 12:00:00 1998 GMT
            Not After : Jan 28 12:00:00 2014 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:da:0e:e6:99:8d:ce:a3:e3:4f:8a:7e:fb:f1:8b:
                    83:25:6b:ea:48:1f:f1:2a:b0:b9:95:11:04:bd:f0:
                    63:d1:e2:67:66:cf:1c:dd:cf:1b:48:2b:ee:8d:89:
                    8e:9a:af:29:80:65:ab:e9:c7:2d:12:cb:ab:1c:4c:
                    70:07:a1:3d:0a:30:cd:15:8d:4f:f8:dd:d4:8c:50:
                    15:1c:ef:50:ee:c4:2e:f7:fc:e9:52:f2:91:7d:e0:
                    6d:d5:35:30:8e:5e:43:73:f2:41:e9:d5:6a:e3:b2:
                    89:3a:56:39:38:6f:06:3c:88:69:5b:2a:4d:c5:a7:
                    54:b8:6c:89:cc:9b:f9:3c:ca:e5:fd:89:f5:12:3c:
                    92:78:96:d6:dc:74:6e:93:44:61:d1:8d:c7:46:b2:
                    75:0e:86:e8:19:8a:d5:6d:6c:d5:78:16:95:a2:e9:
                    c8:0a:38:eb:f2:24:13:4f:73:54:93:13:85:3a:1b:
                    bc:1e:34:b5:8b:05:8c:b9:77:8b:b1:db:1f:20:91:
                    ab:09:53:6e:90:ce:7b:37:74:b9:70:47:91:22:51:
                    63:16:79:ae:b1:ae:41:26:08:c8:19:2b:d1:46:aa:
                    48:d6:64:2a:d7:83:34:ff:2c:2a:c1:6c:19:43:4a:
                    07:85:e7:d3:7c:f6:21:68:ef:ea:f2:52:9f:7f:93:
                    90:cf
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
            60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        ae:aa:9f:fc:b7:d2:cb:1f:5f:39:29:28:18:9e:34:c9:6c:4f:
        6f:1a:f0:64:a2:70:4a:4f:13:86:9b:60:28:9e:e8:81:49:98:
        7d:0a:bb:e5:b0:9d:3d:36:db:8f:05:51:ff:09:31:2a:1f:dd:
        89:77:9e:0f:2e:6c:95:04:ed:86:cb:b4:00:3f:84:02:4d:80:
        6a:2a:2d:78:0b:ae:6f:2b:a2:83:44:83:1f:cd:50:82:4c:24:
        af:bd:f7:a5:b4:c8:5a:0f:f4:e7:47:5e:49:8e:37:96:fe:9a:
        88:05:3a:d9:c0:db:29:87:e6:19:96:47:a7:3a:a6:8c:8b:3c:
        77:fe:46:63:a7:53:da:21:d1:ac:7e:49:a2:4b:e6:c3:67:59:
        2f:b3:8a:0e:bb:2c:bd:a9:aa:42:7c:35:c1:d8:7f:d5:a7:31:
        3a:4e:63:43:39:af:08:b0:61:34:8c:d3:98:a9:43:34:f6:0f:
        87:29:3b:9d:c2:56:58:98:77:c3:f7:1b:ac:f6:9d:f8:3e:aa:
        a7:54:45:f0:f5:f9:d5:31:65:fe:6b:58:9c:71:b3:1e:d7:52:
        ea:32:17:fc:40:60:1d:c9:79:24:b2:f6:6c:fd:a8:66:0e:82:
        dd:98:cb:da:c2:44:4f:2e:a0:7b:f2:f7:6b:2c:76:11:84:46:
        8a:78:a3:e3
-----BEGIN CERTIFICATE-----
MIIDdTCCAl2gAwIBAgILAgAAAAAA1ni3lAUwDQYJKoZIhvcNAQEEBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAw
MDBaFw0xNDAxMjgxMjAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYDVQQDExJHbG9iYWxT
aWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaDuaZ
jc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavp
xy0Sy6scTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp
1Wrjsok6Vjk4bwY8iGlbKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdG
snUOhugZitVtbNV4FpWi6cgKOOvyJBNPc1STE4U6G7weNLWLBYy5d4ux2x8gkasJ
U26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrXgzT/LCrBbBlDSgeF59N8
9iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIABjAdBgNVHQ4EFgQU
YHtmGkUNl8qJUC99BM00qP/8/UswDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0B
AQQFAAOCAQEArqqf/LfSyx9fOSkoGJ40yWxPbxrwZKJwSk8ThptgKJ7ogUmYfQq7
5bCdPTbbjwVR/wkxKh/diXeeDy5slQTthsu0AD+EAk2AaioteAuubyuig0SDH81Q
gkwkr733pbTIWg/050deSY43lv6aiAU62cDbKYfmGZZHpzqmjIs8d/5GY6dT2iHR
rH5Jokvmw2dZL7OKDrssvamqQnw1wdh/1acxOk5jQzmvCLBhNIzTmKlDNPYPhyk7
ncJWWJh3w/cbrPad+D6qp1RF8PX51TFl/mtYnHGzHtdS6jIX/EBgHcl5JLL2bP2o
Zg6C3ZjL2sJETy6ge/L3ayx2EYRGinij4w==
-----END CERTIFICATE-----
...EOF...
cat >certs/gp-root-2.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 798 (0x31e)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 2
        Validity
            Not Before: Aug 16 22:51:00 2000 GMT
            Not After : Aug 15 23:59:00 2020 GMT
        Subject: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a9:01:70:b5:aa:c4:40:f0:ab:6a:26:61:79:19:
                    00:fc:bf:9b:37:59:0c:af:6f:64:1b:f8:da:95:94:
                    24:69:33:11:70:ca:e3:56:74:a2:17:57:64:5c:20:
                    06:e1:d6:ef:71:b7:3b:f7:ab:c1:69:d0:49:a4:b1:
                    04:d7:f4:57:62:89:5c:b0:75:2d:17:24:69:e3:42:
                    60:e4:ee:74:d6:ab:80:56:d8:88:28:e1:fb:6d:22:
                    fd:23:7c:46:73:4f:7e:54:73:1e:a8:2c:55:58:75:
                    b7:4c:f3:5a:45:a5:02:1a:fa:da:9d:c3:45:c3:22:
                    5e:f3:8b:f1:60:29:d2:c7:5f:b4:0c:3a:51:83:ef:
                    30:f8:d4:e7:c7:f2:fa:99:a3:22:50:be:f9:05:37:
                    a3:ad:ed:9a:c3:e6:ec:88:1b:b6:19:27:1b:38:8b:
                    80:4d:ec:b9:c7:c5:89:cb:fc:1a:32:ed:23:f0:b5:
                    01:58:f9:f6:8f:e0:85:a9:4c:09:72:39:12:db:b3:
                    f5:cf:4e:62:64:da:c6:19:15:3a:63:1d:e9:17:55:
                    a1:4c:22:3c:34:32:46:f8:65:57:ba:2b:ef:36:8c:
                    6a:fa:d9:d9:44:f4:aa:dd:84:d7:0d:1c:b2:54:ac:
                    32:85:b4:64:0d:de:41:bb:b1:34:c6:01:86:32:64:
                    d5:9f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            9E:7D:4B:34:BF:71:AD:C2:05:F6:03:75:80:CE:A9:4F:1A:C4:24:4C
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        21:a5:76:14:55:f9:ad:27:70:8f:3c:f4:d5:6c:c8:cc:0a:ab:
        a3:98:0b:8a:06:23:c5:c9:61:db:99:07:69:35:26:31:fe:c7:
        2e:84:c2:99:61:d4:0d:e9:7d:2e:13:2b:7c:8e:85:b6:85:c7:
        4b:cf:35:b6:2c:47:3d:ce:29:2f:d8:6f:9f:89:1c:64:93:bf:
        08:bd:76:d0:90:8a:94:b3:7f:28:5b:6e:ac:4d:33:2c:ed:65:
        dc:16:cc:e2:cd:ae:a4:3d:62:92:06:95:26:bf:df:b9:e4:20:
        a6:73:6a:c1:be:f7:94:44:d6:4d:6f:2a:0b:6b:18:4d:74:10:
        36:68:6a:5a:c1:6a:a7:dd:36:29:8c:b8:30:8b:4f:21:3f:00:
        2e:54:30:07:3a:ba:8a:e4:c3:9e:ca:d8:b5:d8:7b:ce:75:45:
        66:07:f4:6d:2d:d8:7a:ca:e9:89:8a:f2:23:d8:2f:cb:6e:00:
        36:4f:fb:f0:2f:01:cc:0f:c0:22:65:f4:ab:e2:4e:61:2d:03:
        82:7d:91:16:b5:30:d5:14:de:5e:c7:90:fc:a1:fc:ab:10:af:
        5c:6b:70:a7:07:ef:29:86:e8:b2:25:c7:20:ff:26:dd:77:ef:
        79:44:14:c4:bd:dd:3b:c5:03:9b:77:23:ec:a0:ec:bb:5a:39:
        b5:cc:ad:06
-----BEGIN CERTIFICATE-----
MIIDgDCCAmigAwIBAgICAx4wDQYJKoZIhvcNAQEFBQAwYTELMAkGA1UEBhMCVVMx
DTALBgNVBAoTBFZJU0ExLzAtBgNVBAsTJlZpc2EgSW50ZXJuYXRpb25hbCBTZXJ2
aWNlIEFzc29jaWF0aW9uMRIwEAYDVQQDEwlHUCBSb290IDIwHhcNMDAwODE2MjI1
MTAwWhcNMjAwODE1MjM1OTAwWjBhMQswCQYDVQQGEwJVUzENMAsGA1UEChMEVklT
QTEvMC0GA1UECxMmVmlzYSBJbnRlcm5hdGlvbmFsIFNlcnZpY2UgQXNzb2NpYXRp
b24xEjAQBgNVBAMTCUdQIFJvb3QgMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
AQoCggEBAKkBcLWqxEDwq2omYXkZAPy/mzdZDK9vZBv42pWUJGkzEXDK41Z0ohdX
ZFwgBuHW73G3O/erwWnQSaSxBNf0V2KJXLB1LRckaeNCYOTudNargFbYiCjh+20i
/SN8RnNPflRzHqgsVVh1t0zzWkWlAhr62p3DRcMiXvOL8WAp0sdftAw6UYPvMPjU
58fy+pmjIlC++QU3o63tmsPm7IgbthknGziLgE3sucfFicv8GjLtI/C1AVj59o/g
halMCXI5Etuz9c9OYmTaxhkVOmMd6RdVoUwiPDQyRvhlV7or7zaMavrZ2UT0qt2E
1w0cslSsMoW0ZA3eQbuxNMYBhjJk1Z8CAwEAAaNCMEAwHQYDVR0OBBYEFJ59SzS/
ca3CBfYDdYDOqU8axCRMMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEG
MA0GCSqGSIb3DQEBBQUAA4IBAQAhpXYUVfmtJ3CPPPTVbMjMCqujmAuKBiPFyWHb
mQdpNSYx/scuhMKZYdQN6X0uEyt8joW2hcdLzzW2LEc9zikv2G+fiRxkk78IvXbQ
kIqUs38oW26sTTMs7WXcFsziza6kPWKSBpUmv9+55CCmc2rBvveURNZNbyoLaxhN
dBA2aGpawWqn3TYpjLgwi08hPwAuVDAHOrqK5MOeyti12HvOdUVmB/RtLdh6yumJ
ivIj2C/LbgA2T/vwLwHMD8AiZfSr4k5hLQOCfZEWtTDVFN5ex5D8ofyrEK9ca3Cn
B+8phuiyJccg/ybdd+95RBTEvd07xQObdyPsoOy7Wjm1zK0G
-----END CERTIFICATE-----
...EOF...
cat >certs/gp-root-3.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 799 (0x31f)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 3
        Validity
            Not Before: Aug 16 23:34:00 2000 GMT
            Not After : Aug 15 23:59:00 2020 GMT
        Subject: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ba:ec:43:b8:34:ea:a3:67:df:77:09:1f:1a:10:
                    a2:1e:a9:4e:95:4c:74:e7:0c:dc:6c:c6:98:d0:ab:
                    fa:17:24:9a:67:a3:49:14:64:89:8f:93:12:2f:ef:
                    8f:d8:ce:10:04:8b:85:c0:dc:2f:bc:29:98:af:9c:
                    42:c5:cb:d2:96:cf:f4:a5:c5:2d:6e:4d:8c:38:8e:
                    b2:6a:08:99:d5:91:1b:a8:ed:33:93:49:5d:cb:e7:
                    15:43:6d:52:f1:c8:e8:d7:da:30:e0:98:2a:a9:5b:
                    a3:c3:d1:01:03:81:5d:7e:b6:09:95:e8:db:32:6e:
                    fd:3a:c3:b5:9e:9b:fd:59:19:20:b3:23:c0:e2:6a:
                    ee:44:96:80:ef:68:09:40:94:c2:b7:33:49:83:e5:
                    c9:ae:2d:20:37:90:18:3d:20:36:da:79:39:af:b8:
                    57:9f:7a:ef:60:2a:21:84:f8:ff:a0:39:21:d3:d8:
                    6d:54:c7:c3:6a:3c:c8:5c:1f:2e:47:72:14:6c:55:
                    4b:09:06:cd:8e:c5:6b:0b:e7:07:47:3a:7d:92:5f:
                    7d:0f:b0:5c:33:57:83:83:3f:1e:84:a8:79:90:9f:
                    97:4e:22:dc:75:22:c8:6e:2f:d6:d0:cb:76:e1:0c:
                    57:97:e1:26:8f:29:84:53:f2:e5:8e:93:ca:4b:8a:
                    4c:35
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            A2:5C:6E:0D:65:08:C1:F7:4E:5B:C9:6D:F0:D0:56:1B:39:82:43:BB
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        03:8d:56:08:b3:a1:ad:fd:73:42:d9:67:2c:6e:9a:cf:bf:1e:
        c8:4d:f2:4d:d2:d9:37:c9:38:44:8d:ae:89:0c:ef:8c:99:2b:
        4a:93:f5:6d:ac:66:4a:3f:57:6a:10:a5:a2:1a:13:a6:2c:ea:
        62:e7:80:f9:bd:fd:e4:ff:da:11:9f:39:58:6d:f5:43:f2:f4:
        fd:a6:bf:9d:b1:ab:9a:46:07:df:e1:f0:5b:3f:fe:5d:59:40:
        06:ac:18:08:47:4c:3c:4c:48:46:ce:88:e1:a8:b6:9e:75:a6:
        a0:f7:7e:1b:b6:c4:8d:ed:f0:2a:53:15:4a:db:29:4f:39:53:
        e7:52:58:a3:be:dc:e4:90:2d:b5:c9:ce:98:ff:2c:86:a1:08:
        a0:c8:ce:f7:82:39:09:0c:c1:c2:d4:a9:a4:2a:0e:33:81:c7:
        3c:70:cb:30:6d:a4:56:b7:9b:5c:7c:02:22:be:e5:07:7d:6d:
        24:d1:27:b1:d6:1d:1e:5c:47:3c:bf:2e:6e:f8:1c:84:48:ec:
        f5:e1:a0:95:11:cd:e7:30:eb:5c:f0:29:7b:75:82:02:06:b2:
        f3:93:39:d2:0e:ac:df:5f:24:13:15:30:43:f5:50:d4:c7:83:
        a0:43:39:4f:65:34:bd:a6:e9:ce:e1:74:be:20:df:d2:72:16:
        4b:89:46:76
-----BEGIN CERTIFICATE-----
MIIDgDCCAmigAwIBAgICAx8wDQYJKoZIhvcNAQEFBQAwYTELMAkGA1UEBhMCVVMx
DTALBgNVBAoTBFZJU0ExLzAtBgNVBAsTJlZpc2EgSW50ZXJuYXRpb25hbCBTZXJ2
aWNlIEFzc29jaWF0aW9uMRIwEAYDVQQDEwlHUCBSb290IDMwHhcNMDAwODE2MjMz
NDAwWhcNMjAwODE1MjM1OTAwWjBhMQswCQYDVQQGEwJVUzENMAsGA1UEChMEVklT
QTEvMC0GA1UECxMmVmlzYSBJbnRlcm5hdGlvbmFsIFNlcnZpY2UgQXNzb2NpYXRp
b24xEjAQBgNVBAMTCUdQIFJvb3QgMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
AQoCggEBALrsQ7g06qNn33cJHxoQoh6pTpVMdOcM3GzGmNCr+hckmmejSRRkiY+T
Ei/vj9jOEASLhcDcL7wpmK+cQsXL0pbP9KXFLW5NjDiOsmoImdWRG6jtM5NJXcvn
FUNtUvHI6NfaMOCYKqlbo8PRAQOBXX62CZXo2zJu/TrDtZ6b/VkZILMjwOJq7kSW
gO9oCUCUwrczSYPlya4tIDeQGD0gNtp5Oa+4V59672AqIYT4/6A5IdPYbVTHw2o8
yFwfLkdyFGxVSwkGzY7FawvnB0c6fZJffQ+wXDNXg4M/HoSoeZCfl04i3HUiyG4v
1tDLduEMV5fhJo8phFPy5Y6TykuKTDUCAwEAAaNCMEAwHQYDVR0OBBYEFKJcbg1l
CMH3TlvJbfDQVhs5gkO7MA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEG
MA0GCSqGSIb3DQEBBQUAA4IBAQADjVYIs6Gt/XNC2WcsbprPvx7ITfJN0tk3yThE
ja6JDO+MmStKk/VtrGZKP1dqEKWiGhOmLOpi54D5vf3k/9oRnzlYbfVD8vT9pr+d
sauaRgff4fBbP/5dWUAGrBgIR0w8TEhGzojhqLaedaag934btsSN7fAqUxVK2ylP
OVPnUlijvtzkkC21yc6Y/yyGoQigyM73gjkJDMHC1KmkKg4zgcc8cMswbaRWt5tc
fAIivuUHfW0k0Sex1h0eXEc8vy5u+ByESOz14aCVEc3nMOtc8Cl7dYICBrLzkznS
DqzfXyQTFTBD9VDUx4OgQzlPZTS9punO4XS+IN/SchZLiUZ2
-----END CERTIFICATE-----
...EOF...
cat >certs/gp-root-4.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 800 (0x320)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 4
        Validity
            Not Before: Aug 17 00:19:00 2000 GMT
            Not After : Aug 16 23:59:00 2020 GMT
        Subject: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 4
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b8:eb:f0:8f:a0:e6:f1:e3:00:3f:5e:72:9e:ae:
                    04:0f:f4:4f:ce:ca:da:62:33:ea:ee:5a:c2:c1:f6:
                    2e:38:89:b4:0d:cf:a1:ae:b9:31:b3:fd:a6:c7:b6:
                    c4:6c:83:0c:80:61:38:3a:0a:be:1c:01:a0:19:1b:
                    e7:fb:72:6d:92:63:9b:a6:af:33:f4:b4:5b:1a:e8:
                    28:de:4c:e7:37:f1:14:f1:e0:17:e0:14:48:ec:44:
                    1d:79:a5:4e:aa:e1:a4:84:77:bd:cb:4d:b6:ea:70:
                    7e:5f:aa:17:2c:4b:5b:b0:ea:85:d4:69:a8:11:e9:
                    2b:37:1d:bb:a6:04:ee:9b:41
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            43:C6:48:40:C0:0F:C6:18:5A:49:49:E5:81:80:06:4D:5F:DD:D4:85
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        a4:19:3d:73:ce:87:d1:9f:56:12:5c:c8:38:e5:ee:f9:12:c8:
        d9:01:ea:9d:83:34:c6:a2:6b:8b:77:7a:92:7e:87:c7:55:23:
        14:8d:c2:68:4d:19:f2:69:b4:ea:47:14:91:3b:51:87:18:fa:
        76:9b:e2:7b:1c:13:d3:e6:66:1e:0a:12:b9:5d:90:c6:3b:13:
        14:22:cd:35:8c:2d:45:60:00:04:c8:ef:58:02:c5:5d:99:b4:
        90:6d:de:54:d7:23:e2:39:84:25:c3:68:a3:62:a3:79:d8:98:
        a1:5a:d2:5c:89:fd:e5:16:0c:f4:ab:17:48:7e:ad:eb:80:c0:
        55:81
-----BEGIN CERTIFICATE-----
MIICezCCAeSgAwIBAgICAyAwDQYJKoZIhvcNAQEFBQAwYTELMAkGA1UEBhMCVVMx
DTALBgNVBAoTBFZJU0ExLzAtBgNVBAsTJlZpc2EgSW50ZXJuYXRpb25hbCBTZXJ2
aWNlIEFzc29jaWF0aW9uMRIwEAYDVQQDEwlHUCBSb290IDQwHhcNMDAwODE3MDAx
OTAwWhcNMjAwODE2MjM1OTAwWjBhMQswCQYDVQQGEwJVUzENMAsGA1UEChMEVklT
QTEvMC0GA1UECxMmVmlzYSBJbnRlcm5hdGlvbmFsIFNlcnZpY2UgQXNzb2NpYXRp
b24xEjAQBgNVBAMTCUdQIFJvb3QgNDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkC
gYEAuOvwj6Dm8eMAP15ynq4ED/RPzsraYjPq7lrCwfYuOIm0Dc+hrrkxs/2mx7bE
bIMMgGE4Ogq+HAGgGRvn+3JtkmObpq8z9LRbGugo3kznN/EU8eAX4BRI7EQdeaVO
quGkhHe9y0226nB+X6oXLEtbsOqF1GmoEekrNx27pgTum0ECAwEAAaNCMEAwHQYD
VR0OBBYEFEPGSEDAD8YYWklJ5YGABk1f3dSFMA8GA1UdEwEB/wQFMAMBAf8wDgYD
VR0PAQH/BAQDAgEGMA0GCSqGSIb3DQEBBQUAA4GBAKQZPXPOh9GfVhJcyDjl7vkS
yNkB6p2DNMaia4t3epJ+h8dVIxSNwmhNGfJptOpHFJE7UYcY+nab4nscE9PmZh4K
ErldkMY7ExQizTWMLUVgAATI71gCxV2ZtJBt3lTXI+I5hCXDaKNio3nYmKFa0lyJ
/eUWDPSrF0h+reuAwFWB
-----END CERTIFICATE-----
...EOF...
cat >certs/gp-root-5.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 801 (0x321)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 5
        Validity
            Not Before: Aug 17 00:28:00 2000 GMT
            Not After : Aug 16 23:59:00 2020 GMT
        Subject: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 5
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ad:00:6e:f2:a0:7c:31:11:1c:41:b0:37:8f:83:
                    a2:43:cb:97:5f:02:20:89:0d:6e:bc:2a:b1:f1:a5:
                    64:ef:d8:8e:4a:d6:72:9d:9e:6e:1f:9a:a8:f9:85:
                    03:ac:c1:27:6a:84:e5:66:48:71:9a:5e:42:0f:8a:
                    e2:9f:f6:80:0f:23:ac:53:c3:c1:9f:02:c4:f8:58:
                    46:ea:f4:a9:82:af:6d:07:46:86:f1:2d:fc:06:b8:
                    1e:55:d5:39:61:92:84:8b:f1:d8:8a:33:4e:3c:13:
                    b5:d6:71:fc:6b:3e:b4:1c:7a:0b:87:d5:35:66:34:
                    c3:73:32:63:58:df:12:6b:23
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
            23:4E:F3:02:04:04:D7:D2:A7:00:56:C1:CE:49:2C:8C:15:96:33:2F
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        3c:94:01:87:f2:c8:cf:e1:8f:ae:b9:0b:e2:1c:7d:f1:19:ad:
        d1:ed:f6:01:5b:36:53:0a:80:3e:ae:34:56:67:70:6e:43:54:
        4e:79:cd:8b:d5:50:19:32:d8:49:38:34:fd:b6:73:49:eb:0e:
        49:7a:bf:1a:f7:ea:07:28:25:bb:15:49:1c:51:4a:55:9a:38:
        2f:2d:0f:58:f9:79:d1:02:65:13:8c:59:9f:10:7f:5d:17:3c:
        74:f2:b5:ea:77:81:36:86:6f:32:5b:05:b4:0d:a3:26:67:f0:
        e4:35:0e:47:bd:6b:c1:91:9d:0b:f4:3f:9a:11:7c:94:16:67:
        b6:98
-----BEGIN CERTIFICATE-----
MIICezCCAeSgAwIBAgICAyEwDQYJKoZIhvcNAQEFBQAwYTELMAkGA1UEBhMCVVMx
DTALBgNVBAoTBFZJU0ExLzAtBgNVBAsTJlZpc2EgSW50ZXJuYXRpb25hbCBTZXJ2
aWNlIEFzc29jaWF0aW9uMRIwEAYDVQQDEwlHUCBSb290IDUwHhcNMDAwODE3MDAy
ODAwWhcNMjAwODE2MjM1OTAwWjBhMQswCQYDVQQGEwJVUzENMAsGA1UEChMEVklT
QTEvMC0GA1UECxMmVmlzYSBJbnRlcm5hdGlvbmFsIFNlcnZpY2UgQXNzb2NpYXRp
b24xEjAQBgNVBAMTCUdQIFJvb3QgNTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkC
gYEArQBu8qB8MREcQbA3j4OiQ8uXXwIgiQ1uvCqx8aVk79iOStZynZ5uH5qo+YUD
rMEnaoTlZkhxml5CD4rin/aADyOsU8PBnwLE+FhG6vSpgq9tB0aG8S38BrgeVdU5
YZKEi/HYijNOPBO11nH8az60HHoLh9U1ZjTDczJjWN8SayMCAwEAAaNCMEAwHQYD
VR0OBBYEFCNO8wIEBNfSpwBWwc5JLIwVljMvMA8GA1UdEwEB/wQFMAMBAf8wDgYD
VR0PAQH/BAQDAgEGMA0GCSqGSIb3DQEBBQUAA4GBADyUAYfyyM/hj665C+IcffEZ
rdHt9gFbNlMKgD6uNFZncG5DVE55zYvVUBky2Ek4NP22c0nrDkl6vxr36gcoJbsV
SRxRSlWaOC8tD1j5edECZROMWZ8Qf10XPHTytep3gTaGbzJbBbQNoyZn8OQ1Dke9
a8GRnQv0P5oRfJQWZ7aY
-----END CERTIFICATE-----
...EOF...
cat >certs/gte-cybertrust-global-root.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 421 (0x1a5)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=GTE Corporation, OU=GTE CyberTrust Solutions, Inc., CN=GTE CyberTrust Global Root
        Validity
            Not Before: Aug 13 00:29:00 1998 GMT
            Not After : Aug 13 23:59:00 2018 GMT
        Subject: C=US, O=GTE Corporation, OU=GTE CyberTrust Solutions, Inc., CN=GTE CyberTrust Global Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:95:0f:a0:b6:f0:50:9c:e8:7a:c7:88:cd:dd:17:
                    0e:2e:b0:94:d0:1b:3d:0e:f6:94:c0:8a:94:c7:06:
                    c8:90:97:c8:b8:64:1a:7a:7e:6c:3c:53:e1:37:28:
                    73:60:7f:b2:97:53:07:9f:53:f9:6d:58:94:d2:af:
                    8d:6d:88:67:80:e6:ed:b2:95:cf:72:31:ca:a5:1c:
                    72:ba:5c:02:e7:64:42:e7:f9:a9:2c:d6:3a:0d:ac:
                    8d:42:aa:24:01:39:e6:9c:3f:01:85:57:0d:58:87:
                    45:f8:d3:85:aa:93:69:26:85:70:48:80:3f:12:15:
                    c7:79:b4:1f:05:2f:3b:62:99
                Exponent: 65537 (0x10001)
    Signature Algorithm: md5WithRSAEncryption
        6d:eb:1b:09:e9:5e:d9:51:db:67:22:61:a4:2a:3c:48:77:e3:
        a0:7c:a6:de:73:a2:14:03:85:3d:fb:ab:0e:30:c5:83:16:33:
        81:13:08:9e:7b:34:4e:df:40:c8:74:d7:b9:7d:dc:f4:76:55:
        7d:9b:63:54:18:e9:f0:ea:f3:5c:b1:d9:8b:42:1e:b9:c0:95:
        4e:ba:fa:d5:e2:7c:f5:68:61:bf:8e:ec:05:97:5f:5b:b0:d7:
        a3:85:34:c4:24:a7:0d:0f:95:93:ef:cb:94:d8:9e:1f:9d:5c:
        85:6d:c7:aa:ae:4f:1f:22:b5:cd:95:ad:ba:a7:cc:f9:ab:0b:
        7a:7f
-----BEGIN CERTIFICATE-----
MIICWjCCAcMCAgGlMA0GCSqGSIb3DQEBBAUAMHUxCzAJBgNVBAYTAlVTMRgwFgYD
VQQKEw9HVEUgQ29ycG9yYXRpb24xJzAlBgNVBAsTHkdURSBDeWJlclRydXN0IFNv
bHV0aW9ucywgSW5jLjEjMCEGA1UEAxMaR1RFIEN5YmVyVHJ1c3QgR2xvYmFsIFJv
b3QwHhcNOTgwODEzMDAyOTAwWhcNMTgwODEzMjM1OTAwWjB1MQswCQYDVQQGEwJV
UzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMScwJQYDVQQLEx5HVEUgQ3liZXJU
cnVzdCBTb2x1dGlvbnMsIEluYy4xIzAhBgNVBAMTGkdURSBDeWJlclRydXN0IEds
b2JhbCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCVD6C28FCc6HrH
iM3dFw4usJTQGz0O9pTAipTHBsiQl8i4ZBp6fmw8U+E3KHNgf7KXUwefU/ltWJTS
r41tiGeA5u2ylc9yMcqlHHK6XALnZELn+aks1joNrI1CqiQBOeacPwGFVw1Yh0X4
04Wqk2kmhXBIgD8SFcd5tB8FLztimQIDAQABMA0GCSqGSIb3DQEBBAUAA4GBAG3r
GwnpXtlR22ciYaQqPEh346B8pt5zohQDhT37qw4wxYMWM4ETCJ57NE7fQMh017l9
3PR2VX2bY1QY6fDq81yx2YtCHrnAlU66+tXifPVoYb+O7AWXX1uw16OFNMQkpw0P
lZPvy5TYnh+dXIVtx6quTx8itc2VrbqnzPmrC3p/
-----END CERTIFICATE-----
...EOF...
cat >certs/gte-cybertrust-root-5.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 438 (0x1b6)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=GTE Corporation, OU=GTE CyberTrust Solutions, Inc., CN=GTE CyberTrust Root 5
        Validity
            Not Before: Aug 14 14:50:00 1998 GMT
            Not After : Aug 14 23:59:00 2013 GMT
        Subject: C=US, O=GTE Corporation, OU=GTE CyberTrust Solutions, Inc., CN=GTE CyberTrust Root 5
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:bc:12:6e:3f:8a:7c:7a:97:01:ec:1e:bb:39:5a:
                    02:f4:78:44:a2:48:1b:8e:7b:49:52:7a:b8:7b:47:
                    b3:af:94:9b:6f:bb:96:fa:2b:6a:65:5c:b8:1c:94:
                    73:be:bf:89:0a:22:80:ee:57:fc:8c:05:bb:70:9f:
                    97:39:04:da:a3:87:5c:a8:e5:ca:af:c0:33:9a:d5:
                    37:5c:4b:ac:e4:80:d0:a6:23:60:fb:fd:72:2e:94:
                    9d:c7:ce:c2:04:32:ef:78:60:5d:ed:ad:87:0f:45:
                    65:1e:3c:9a:0a:9a:be:5d:1d:99:ec:e7:f2:d1:c6:
                    7a:17:d9:ad:9b:54:96:7f:c4:7c:60:bf:85:aa:15:
                    35:1d:40:da:11:bc:ec:54:21:28:2d:23:a1:a8:f0:
                    cf:2d:cd:dd:fc:7e:0f:5e:e1:65:07:56:cb:07:b4:
                    d2:56:e8:5e:31:cc:18:63:c4:86:d2:2d:85:cf:93:
                    92:ab:6d:fe:68:39:fb:de:73:bd:86:f8:e4:46:7a:
                    ea:9f:0c:cb:f4:19:fe:63:bc:d1:2c:7b:88:33:36:
                    f6:e4:e1:9c:0c:53:81:60:1c:da:2e:ab:96:a9:16:
                    88:13:50:99:b2:bd:55:df:15:30:7e:e8:e5:98:fb:
                    70:7e:6c:b5:07:fc:fc:46:b7:d0:ed:37:96:7e:32:
                    fe:21
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE, pathlen:5
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Certificate Policies: 
            Policy: 1.2.840.113763.1.2.1.3

            X509v3 Subject Key Identifier: 
            76:0A:49:21:38:4C:9F:DE:F8:C4:49:C7:71:71:91:9D
    Signature Algorithm: sha1WithRSAEncryption
        41:3a:d4:18:5b:da:b8:de:21:1c:e1:8e:09:e5:f1:68:34:ff:
        de:96:f4:07:f5:a7:3c:f3:ac:4a:b1:9b:fa:92:fa:9b:ed:e6:
        32:21:aa:4a:76:c5:dc:4f:38:e5:df:d5:86:e4:d5:c8:76:7d:
        98:d7:b1:cd:8f:4d:b5:91:23:6c:8b:8a:eb:ea:7c:ef:14:94:
        c4:c6:f0:1f:4a:2d:32:71:63:2b:63:91:26:02:09:b6:80:1d:
        ed:e2:cc:b8:7f:db:87:63:c8:e1:d0:6c:26:b1:35:1d:40:66:
        10:1b:cd:95:54:18:33:61:ec:13:4f:da:13:f7:99:af:3e:d0:
        cf:8e:a6:72:a2:b3:c3:05:9a:c9:27:7d:92:cc:7e:52:8d:b3:
        ab:70:6d:9e:89:9f:4d:eb:1a:75:c2:98:aa:d5:02:16:d7:0c:
        8a:bf:25:e4:eb:2d:bc:98:e9:58:38:19:7c:b9:37:fe:db:e2:
        99:08:73:06:c7:97:83:6a:7d:10:01:2f:32:b9:17:05:4a:65:
        e6:2f:ce:be:5e:53:a6:82:e9:9a:53:0a:84:74:2d:83:ca:c8:
        94:16:76:5f:94:61:28:f0:85:a7:39:bb:d7:8b:d9:a8:b2:13:
        1d:54:09:34:24:7d:20:81:7d:66:7e:a2:90:74:5c:10:c6:bd:
        ec:ab:1b:c2
-----BEGIN CERTIFICATE-----
MIIDtjCCAp6gAwIBAgICAbYwDQYJKoZIhvcNAQEFBQAwcDELMAkGA1UEBhMCVVMx
GDAWBgNVBAoTD0dURSBDb3Jwb3JhdGlvbjEnMCUGA1UECxMeR1RFIEN5YmVyVHJ1
c3QgU29sdXRpb25zLCBJbmMuMR4wHAYDVQQDExVHVEUgQ3liZXJUcnVzdCBSb290
IDUwHhcNOTgwODE0MTQ1MDAwWhcNMTMwODE0MjM1OTAwWjBwMQswCQYDVQQGEwJV
UzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMScwJQYDVQQLEx5HVEUgQ3liZXJU
cnVzdCBTb2x1dGlvbnMsIEluYy4xHjAcBgNVBAMTFUdURSBDeWJlclRydXN0IFJv
b3QgNTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALwSbj+KfHqXAewe
uzlaAvR4RKJIG457SVJ6uHtHs6+Um2+7lvoramVcuByUc76/iQoigO5X/IwFu3Cf
lzkE2qOHXKjlyq/AM5rVN1xLrOSA0KYjYPv9ci6UncfOwgQy73hgXe2thw9FZR48
mgqavl0dmezn8tHGehfZrZtUln/EfGC/haoVNR1A2hG87FQhKC0joajwzy3N3fx+
D17hZQdWywe00lboXjHMGGPEhtIthc+Tkqtt/mg5+95zvYb45EZ66p8My/QZ/mO8
0Sx7iDM29uThnAxTgWAc2i6rlqkWiBNQmbK9Vd8VMH7o5Zj7cH5stQf8/Ea30O03
ln4y/iECAwEAAaNaMFgwEgYDVR0TAQH/BAgwBgEB/wIBBTAOBgNVHQ8BAf8EBAMC
AQYwFwYDVR0gBBAwDjAMBgoqhkiG+GMBAgEDMBkGA1UdDgQSBBB2CkkhOEyf3vjE
ScdxcZGdMA0GCSqGSIb3DQEBBQUAA4IBAQBBOtQYW9q43iEc4Y4J5fFoNP/elvQH
9ac886xKsZv6kvqb7eYyIapKdsXcTzjl39WG5NXIdn2Y17HNj021kSNsi4rr6nzv
FJTExvAfSi0ycWMrY5EmAgm2gB3t4sy4f9uHY8jh0GwmsTUdQGYQG82VVBgzYewT
T9oT95mvPtDPjqZyorPDBZrJJ32SzH5SjbOrcG2eiZ9N6xp1wpiq1QIW1wyKvyXk
6y28mOlYOBl8uTf+2+KZCHMGx5eDan0QAS8yuRcFSmXmL86+XlOmgumaUwqEdC2D
ysiUFnZflGEo8IWnObvXi9moshMdVAk0JH0ggX1mfqKQdFwQxr3sqxvC
-----END CERTIFICATE-----
...EOF...
cat >certs/gte-cybertrust-root.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 419 (0x1a3)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=GTE Corporation, CN=GTE CyberTrust Root
        Validity
            Not Before: Feb 23 23:01:00 1996 GMT
            Not After : Feb 23 23:59:00 2006 GMT
        Subject: C=US, O=GTE Corporation, CN=GTE CyberTrust Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b8:e6:4f:ba:db:98:7c:71:7c:af:44:b7:d3:0f:
                    46:d9:64:e5:93:c1:42:8e:c7:ba:49:8d:35:2d:7a:
                    e7:8b:bd:e5:05:31:59:c6:b1:2f:0a:0c:fb:9f:a7:
                    3f:a2:09:66:84:56:1e:37:29:1b:87:e9:7e:0c:ca:
                    9a:9f:a5:7f:f5:15:94:a3:d5:a2:46:82:d8:68:4c:
                    d1:37:15:06:68:af:bd:f8:b0:b3:f0:29:f5:95:5a:
                    09:16:61:77:0a:22:25:d4:4f:45:aa:c7:bd:e5:96:
                    df:f9:d4:a8:8e:42:cc:24:c0:1e:91:27:4a:b5:6d:
                    06:80:63:39:c4:a2:5e:38:03
                Exponent: 65537 (0x10001)
    Signature Algorithm: md5WithRSAEncryption
        12:b3:75:c6:5f:1d:e1:61:55:80:00:d4:81:4b:7b:31:0f:23:
        63:e7:3d:f3:03:f9:f4:36:a8:bb:d9:e3:a5:97:4d:ea:2b:29:
        e0:d6:6a:73:81:e6:c0:89:a3:d3:f1:e0:a5:a5:22:37:9a:63:
        c2:48:20:b4:db:72:e3:c8:f6:d9:7c:be:b1:af:53:da:14:b4:
        21:b8:d6:d5:96:e3:fe:4e:0c:59:62:b6:9a:4a:f9:42:dd:8c:
        6f:81:a9:71:ff:f4:0a:72:6d:6d:44:0e:9d:f3:74:74:a8:d5:
        34:49:e9:5e:9e:e9:b4:7a:e1:e5:5a:1f:84:30:9c:d3:9f:a5:
        25:d8
-----BEGIN CERTIFICATE-----
MIIB+jCCAWMCAgGjMA0GCSqGSIb3DQEBBAUAMEUxCzAJBgNVBAYTAlVTMRgwFgYD
VQQKEw9HVEUgQ29ycG9yYXRpb24xHDAaBgNVBAMTE0dURSBDeWJlclRydXN0IFJv
b3QwHhcNOTYwMjIzMjMwMTAwWhcNMDYwMjIzMjM1OTAwWjBFMQswCQYDVQQGEwJV
UzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMRwwGgYDVQQDExNHVEUgQ3liZXJU
cnVzdCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC45k+625h8cXyv
RLfTD0bZZOWTwUKOx7pJjTUteueLveUFMVnGsS8KDPufpz+iCWaEVh43KRuH6X4M
ypqfpX/1FZSj1aJGgthoTNE3FQZor734sLPwKfWVWgkWYXcKIiXUT0Wqx73llt/5
1KiOQswkwB6RJ0q1bQaAYznEol44AwIDAQABMA0GCSqGSIb3DQEBBAUAA4GBABKz
dcZfHeFhVYAA1IFLezEPI2PnPfMD+fQ2qLvZ46WXTeorKeDWanOB5sCJo9Px4KWl
IjeaY8JIILTbcuPI9tl8vrGvU9oUtCG41tWW4/5ODFlitppK+ULdjG+BqXH/9Apy
bW1EDp3zdHSo1TRJ6V6e6bR64eVaH4QwnNOfpSXY
-----END CERTIFICATE-----
...EOF...
cat >certs/http-www-valicert-com-00.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 1 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Validity
            Not Before: Jun 25 22:23:48 1999 GMT
            Not After : Jun 25 22:23:48 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 1 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d8:59:82:7a:89:b8:96:ba:a6:2f:68:6f:58:2e:
                    a7:54:1c:06:6e:f4:ea:8d:48:bc:31:94:17:f0:f3:
                    4e:bc:b2:b8:35:92:76:b0:d0:a5:a5:01:d7:00:03:
                    12:22:19:08:f8:ff:11:23:9b:ce:07:f5:bf:69:1a:
                    26:fe:4e:e9:d1:7f:9d:2c:40:1d:59:68:6e:a6:f8:
                    58:b0:9d:1a:8f:d3:3f:f1:dc:19:06:81:a8:0e:e0:
                    3a:dd:c8:53:45:09:06:e6:0f:70:c3:fa:40:a6:0e:
                    e2:56:05:0f:18:4d:fc:20:82:d1:73:55:74:8d:76:
                    72:a0:1d:9d:1d:c0:dd:3f:71
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        50:68:3d:49:f4:2c:1c:06:94:df:95:60:7f:96:7b:17:fe:4f:
        71:ad:64:c8:dd:77:d2:ef:59:55:e8:3f:e8:8e:05:2a:21:f2:
        07:d2:b5:a7:52:fe:9c:b1:b6:e2:5b:77:17:40:ea:72:d6:23:
        cb:28:81:32:c3:00:79:18:ec:59:17:89:c9:c6:6a:1e:71:c9:
        fd:b7:74:a5:25:45:69:c5:48:ab:19:e1:45:8a:25:6b:19:ee:
        e5:bb:12:f5:7f:f7:a6:8d:51:c3:f0:9d:74:b7:a9:3e:a0:a5:
        ff:b6:49:03:13:da:22:cc:ed:71:82:2b:99:cf:3a:b7:f5:2d:
        72:c8
-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDEgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNTIyMjM0OFoXDTE5MDYy
NTIyMjM0OFowgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDEgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYWYJ6ibiWuqYvaG9Y
LqdUHAZu9OqNSLwxlBfw8068srg1knaw0KWlAdcAAxIiGQj4/xEjm84H9b9pGib+
TunRf50sQB1ZaG6m+FiwnRqP0z/x3BkGgagO4DrdyFNFCQbmD3DD+kCmDuJWBQ8Y
TfwggtFzVXSNdnKgHZ0dwN0/cQIDAQABMA0GCSqGSIb3DQEBBQUAA4GBAFBoPUn0
LBwGlN+VYH+Wexf+T3GtZMjdd9LvWVXoP+iOBSoh8gfStadS/pyxtuJbdxdA6nLW
I8sogTLDAHkY7FkXicnGah5xyf23dKUlRWnFSKsZ4UWKJWsZ7uW7EvV/96aNUcPw
nXS3qT6gpf+2SQMT2iLM7XGCK5nPOrf1LXLI
-----END CERTIFICATE-----
...EOF...
cat >certs/http-www-valicert-com-01.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 2 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Validity
            Not Before: Jun 26 00:19:54 1999 GMT
            Not After : Jun 26 00:19:54 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 2 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ce:3a:71:ca:e5:ab:c8:59:92:55:d7:ab:d8:74:
                    0e:f9:ee:d9:f6:55:47:59:65:47:0e:05:55:dc:eb:
                    98:36:3c:5c:53:5d:d3:30:cf:38:ec:bd:41:89:ed:
                    25:42:09:24:6b:0a:5e:b3:7c:dd:52:2d:4c:e6:d4:
                    d6:7d:5a:59:a9:65:d4:49:13:2d:24:4d:1c:50:6f:
                    b5:c1:85:54:3b:fe:71:e4:d3:5c:42:f9:80:e0:91:
                    1a:0a:5b:39:36:67:f3:3f:55:7c:1b:3f:b4:5f:64:
                    73:34:e3:b4:12:bf:87:64:f8:da:12:ff:37:27:c1:
                    b3:43:bb:ef:7b:6e:2e:69:f7
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        3b:7f:50:6f:6f:50:94:99:49:62:38:38:1f:4b:f8:a5:c8:3e:
        a7:82:81:f6:2b:c7:e8:c5:ce:e8:3a:10:82:cb:18:00:8e:4d:
        bd:a8:58:7f:a1:79:00:b5:bb:e9:8d:af:41:d9:0f:34:ee:21:
        81:19:a0:32:49:28:f4:c4:8e:56:d5:52:33:fd:50:d5:7e:99:
        6c:03:e4:c9:4c:fc:cb:6c:ab:66:b3:4a:21:8c:e5:b5:0c:32:
        3e:10:b2:cc:6c:a1:dc:9a:98:4c:02:5b:f3:ce:b9:9e:a5:72:
        0e:4a:b7:3f:3c:e6:16:68:f8:be:ed:74:4c:bc:5b:d5:62:1f:
        43:dd
-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDIgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNjAwMTk1NFoXDTE5MDYy
NjAwMTk1NFowgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDIgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDOOnHK5avIWZJV16vY
dA757tn2VUdZZUcOBVXc65g2PFxTXdMwzzjsvUGJ7SVCCSRrCl6zfN1SLUzm1NZ9
WlmpZdRJEy0kTRxQb7XBhVQ7/nHk01xC+YDgkRoKWzk2Z/M/VXwbP7RfZHM047QS
v4dk+NoS/zcnwbNDu+97bi5p9wIDAQABMA0GCSqGSIb3DQEBBQUAA4GBADt/UG9v
UJSZSWI4OB9L+KXIPqeCgfYrx+jFzug6EILLGACOTb2oWH+heQC1u+mNr0HZDzTu
IYEZoDJJKPTEjlbVUjP9UNV+mWwD5MlM/Mtsq2azSiGM5bUMMj4QssxsodyamEwC
W/POuZ6lcg5Ktz885hZo+L7tdEy8W9ViH0Pd
-----END CERTIFICATE-----
...EOF...
cat >certs/http-www-valicert-com-02.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 3 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Validity
            Not Before: Jun 26 00:22:33 1999 GMT
            Not After : Jun 26 00:22:33 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 3 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e3:98:51:96:1c:e8:d5:b1:06:81:6a:57:c3:72:
                    75:93:ab:cf:9e:a6:fc:f3:16:52:d6:2d:4d:9f:35:
                    44:a8:2e:04:4d:07:49:8a:38:29:f5:77:37:e7:b7:
                    ab:5d:df:36:71:14:99:8f:dc:c2:92:f1:e7:60:92:
                    97:ec:d8:48:dc:bf:c1:02:20:c6:24:a4:28:4c:30:
                    5a:76:6d:b1:5c:f3:dd:de:9e:10:71:a1:88:c7:5b:
                    9b:41:6d:ca:b0:b8:8e:15:ee:ad:33:2b:cf:47:04:
                    5c:75:71:0a:98:24:98:29:a7:49:59:a5:dd:f8:b7:
                    43:62:61:f3:d3:e2:d0:55:3f
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        56:bb:02:58:84:67:08:2c:df:1f:db:7b:49:33:f5:d3:67:9d:
        f4:b4:0a:10:b3:c9:c5:2c:e2:92:6a:71:78:27:f2:70:83:42:
        d3:3e:cf:a9:54:f4:f1:d8:92:16:8c:d1:04:cb:4b:ab:c9:9f:
        45:ae:3c:8a:a9:b0:71:33:5d:c8:c5:57:df:af:a8:35:b3:7f:
        89:87:e9:e8:25:92:b8:7f:85:7a:ae:d6:bc:1e:37:58:2a:67:
        c9:91:cf:2a:81:3e:ed:c6:39:df:c0:3e:19:9c:19:cc:13:4d:
        82:41:b5:8c:de:e0:3d:60:08:20:0f:45:7e:6b:a2:7f:a3:8c:
        15:ee
-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDMgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNjAwMjIzM1oXDTE5MDYy
NjAwMjIzM1owgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDMgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDjmFGWHOjVsQaBalfD
cnWTq8+epvzzFlLWLU2fNUSoLgRNB0mKOCn1dzfnt6td3zZxFJmP3MKS8edgkpfs
2Ejcv8ECIMYkpChMMFp2bbFc893enhBxoYjHW5tBbcqwuI4V7q0zK89HBFx1cQqY
JJgpp0lZpd34t0NiYfPT4tBVPwIDAQABMA0GCSqGSIb3DQEBBQUAA4GBAFa7AliE
Zwgs3x/be0kz9dNnnfS0ChCzycUs4pJqcXgn8nCDQtM+z6lU9PHYkhaM0QTLS6vJ
n0WuPIqpsHEzXcjFV9+vqDWzf4mH6eglkrh/hXqu1rweN1gqZ8mRzyqBPu3GOd/A
PhmcGcwTTYJBtYze4D1gCCAPRX5ron+jjBXu
-----END CERTIFICATE-----
...EOF...
cat >certs/http-www-valicert-net.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=Class 1 Validation Authority - OCSP, CN=http://www.valicert.net//emailAddress=info@valicert.com
        Validity
            Not Before: Feb 12 11:50:05 2000 GMT
            Not After : Feb 10 11:50:05 2005 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=Class 1 Validation Authority - OCSP, CN=http://www.valicert.net//emailAddress=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c7:8c:2f:a7:c3:40:87:3b:3d:d7:c4:9a:58:14:
                    64:0a:c3:08:39:62:1a:cf:d2:eb:a9:f1:69:74:8a:
                    ca:0e:5a:76:cc:a2:52:4e:d0:f3:c4:7a:b5:f8:a6:
                    1c:bb:a3:a7:a4:53:87:5b:8d:c0:00:bb:d5:66:24:
                    e7:74:c6:16:c8:af:c8:03:62:d5:32:87:a2:52:91:
                    44:94:95:a8:47:43:6d:a5:48:9c:f6:4c:75:d5:4f:
                    62:e7:c9:ff:7b:f4:24:8c:a7:bc:28:76:b5:32:a0:
                    25:73:b7:47:2f:78:f8:46:f9:87:14:f0:77:fc:0a:
                    77:e8:4f:fd:8c:1f:fa:62:d9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            OCSP No Check: 

            X509v3 Extended Key Usage: 
            OCSP Signing
            X509v3 Key Usage: 
            Digital Signature, Certificate Sign, CRL Sign
            Authority Information Access: 
            OCSP - URI:http://ocsp2.valicert.net

    Signature Algorithm: sha1WithRSAEncryption
        15:c5:e0:b8:34:72:12:06:20:a8:62:95:93:d1:bc:93:ba:90:
        ab:dc:4e:8d:8e:8d:98:4c:e3:32:f5:2b:3f:b3:97:fb:aa:a2:
        ad:40:97:ad:68:bd:5c:ad:53:0e:d0:a6:b3:0d:ac:1a:99:8d:
        aa:30:1e:cf:0e:70:ff:02:b0:77:65:83:cd:da:07:5c:52:cd:
        59:bb:a2:c8:e2:b4:16:83:8f:d4:95:79:93:2d:e8:bf:44:93:
        31:92:30:d3:34:34:f1:10:fb:21:ac:2e:f4:c3:5d:64:63:7a:
        99:e1:9a:ab:42:1d:48:66:a6:77:37:b8:55:3c:ad:fe:65:b0:
        62:e9
-----BEGIN CERTIFICATE-----
MIIDSDCCArGgAwIBAgIBATANBgkqhkiG9w0BAQUFADCBsjEkMCIGA1UEBxMbVmFs
aUNlcnQgVmFsaWRhdGlvbiBOZXR3b3JrMRcwFQYDVQQKEw5WYWxpQ2VydCwgSW5j
LjEsMCoGA1UECxMjQ2xhc3MgMSBWYWxpZGF0aW9uIEF1dGhvcml0eSAtIE9DU1Ax
ITAfBgNVBAMTGGh0dHA6Ly93d3cudmFsaWNlcnQubmV0LzEgMB4GCSqGSIb3DQEJ
ARYRaW5mb0B2YWxpY2VydC5jb20wHhcNMDAwMjEyMTE1MDA1WhcNMDUwMjEwMTE1
MDA1WjCBsjEkMCIGA1UEBxMbVmFsaUNlcnQgVmFsaWRhdGlvbiBOZXR3b3JrMRcw
FQYDVQQKEw5WYWxpQ2VydCwgSW5jLjEsMCoGA1UECxMjQ2xhc3MgMSBWYWxpZGF0
aW9uIEF1dGhvcml0eSAtIE9DU1AxITAfBgNVBAMTGGh0dHA6Ly93d3cudmFsaWNl
cnQubmV0LzEgMB4GCSqGSIb3DQEJARYRaW5mb0B2YWxpY2VydC5jb20wgZ8wDQYJ
KoZIhvcNAQEBBQADgY0AMIGJAoGBAMeML6fDQIc7PdfEmlgUZArDCDliGs/S66nx
aXSKyg5adsyiUk7Q88R6tfimHLujp6RTh1uNwAC71WYk53TGFsivyANi1TKHolKR
RJSVqEdDbaVInPZMddVPYufJ/3v0JIynvCh2tTKgJXO3Ry94+Eb5hxTwd/wKd+hP
/Ywf+mLZAgMBAAGjbDBqMA8GCSsGAQUFBzABBQQCBQAwEwYDVR0lBAwwCgYIKwYB
BQUHAwkwCwYDVR0PBAQDAgGGMDUGCCsGAQUFBwEBBCkwJzAlBggrBgEFBQcwAYYZ
aHR0cDovL29jc3AyLnZhbGljZXJ0Lm5ldDANBgkqhkiG9w0BAQUFAAOBgQAVxeC4
NHISBiCoYpWT0byTupCr3E6Njo2YTOMy9Ss/s5f7qqKtQJetaL1crVMO0KazDawa
mY2qMB7PDnD/ArB3ZYPN2gdcUs1Zu6LI4rQWg4/UlXmTLei/RJMxkjDTNDTxEPsh
rC70w11kY3qZ4ZqrQh1IZqZ3N7hVPK3+ZbBi6Q==
-----END CERTIFICATE-----
...EOF...
cat >certs/mailengine.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CA, ST=ON, L=Toronto, O=MailEngine Inc., OU=Certification Authority Division, CN=mailengine/emailAddress=ca@mailengine.com
        Validity
            Not Before: Jan  1 00:00:00 1998 GMT
            Not After : Jan 17 00:00:00 2038 GMT
        Subject: C=CA, ST=ON, L=Toronto, O=MailEngine Inc., OU=Certification Authority Division, CN=mailengine/emailAddress=ca@mailengine.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a9:79:9f:b1:4f:a5:c7:e3:45:9a:7e:ad:37:5e:
                    d1:4c:ec:9a:75:d1:ea:2e:7a:ff:de:bc:c4:0c:8c:
                    93:f5:33:7e:b4:5f:53:1b:b8:e6:2b:b9:49:26:b8:
                    f9:6a:b4:37:9d:31:5a:2c:5f:09:b8:d0:f6:53:5c:
                    ff:70:b3:f0:eb:f4:d7:fb:5b:44:de:fd:c2:35:40:
                    d2:8d:a8:ac:c9:40:e2:53:2a:77:4c:4f:21:30:c3:
                    33:cd:f6:50:9f:42:6c:1a:03:61:85:6c:6a:cb:38:
                    e1:45:01:ad:28:be:3e:c6:d9:fc:56:c1:7f:f3:31:
                    a0:65:89:1e:ee:79:66:54:ac:ff:16:c9:43:15:39:
                    cd:a2:87:4b:04:01:06:8a:ef:49:41:2f:6a:aa:96:
                    d2:b3:6d:0d:75:9e:8b:5c:f2:f6:03:88:93:8e:7b:
                    0d:14:15:b7:8c:83:15:22:7f:c9:55:5c:9a:c9:c5:
                    3b:b9:ed:a8:16:f8:83:bc:b3:69:91:56:5c:47:b0:
                    3e:8e:32:1d:22:e9:8e:73:95:52:17:4c:bb:cb:be:
                    1c:40:2e:58:c2:44:76:98:b2:bb:50:16:03:2b:a3:
                    42:63:7b:5a:fc:2e:0c:f0:db:0c:d0:5a:66:bd:19:
                    74:f8:0d:62:bd:9b:55:c2:a2:3d:f1:dc:43:b6:9e:
                    c7:79
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        23:7c:d9:f9:04:2c:f1:ca:50:43:6a:41:50:19:62:84:fc:fe:
        37:3d:18:9b:30:e1:33:7d:de:fe:0f:36:d8:58:87:a4:a3:3d:
        e2:d3:40:f0:a0:7d:db:ea:3e:20:c2:50:c9:44:03:aa:e1:d1:
        7a:fc:fb:7f:b8:13:87:0e:8f:e8:a7:e7:9f:fb:d1:2b:98:a3:
        dd:f9:e8:57:37:d8:77:ed:06:dc:71:38:33:ec:3b:55:c0:0e:
        22:46:50:d1:2e:bb:be:26:e5:f3:4f:e3:ac:08:7b:85:64:c3:
        8b:27:e2:83:d8:90:06:87:75:ba:f0:98:dd:70:b9:2b:95:ca:
        6d:01:4d:30:73:96:8e:1c:f3:df:10:17:48:6a:1f:32:f1:0b:
        4d:cd:74:55:ce:80:6d:f3:3c:ef:80:20:11:91:7c:53:4b:6b:
        bf:f5:06:97:47:58:4c:2f:42:6d:0e:04:12:49:d6:7a:29:df:
        12:37:ac:b3:ab:10:fe:6e:e6:03:e6:c3:9f:26:68:c1:17:f9:
        f7:96:a1:47:34:c1:e7:9c:65:f2:d9:30:17:66:d2:00:5b:37:
        df:53:70:34:70:63:c1:37:a1:59:d3:6e:9a:f3:a1:db:17:55:
        f8:93:ec:6c:ce:16:c9:bb:f8:a4:73:3c:ae:5a:70:89:22:0d:
        df:4d:84:83
-----BEGIN CERTIFICATE-----
MIID3TCCAsWgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBqDELMAkGA1UEBhMCQ0Ex
CzAJBgNVBAgTAk9OMRAwDgYDVQQHEwdUb3JvbnRvMRgwFgYDVQQKEw9NYWlsRW5n
aW5lIEluYy4xKTAnBgNVBAsTIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IERpdmlz
aW9uMRMwEQYDVQQDEwptYWlsZW5naW5lMSAwHgYJKoZIhvcNAQkBFhFjYUBtYWls
ZW5naW5lLmNvbTAeFw05ODAxMDEwMDAwMDBaFw0zODAxMTcwMDAwMDBaMIGoMQsw
CQYDVQQGEwJDQTELMAkGA1UECBMCT04xEDAOBgNVBAcTB1Rvcm9udG8xGDAWBgNV
BAoTD01haWxFbmdpbmUgSW5jLjEpMCcGA1UECxMgQ2VydGlmaWNhdGlvbiBBdXRo
b3JpdHkgRGl2aXNpb24xEzARBgNVBAMTCm1haWxlbmdpbmUxIDAeBgkqhkiG9w0B
CQEWEWNhQG1haWxlbmdpbmUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
CgKCAQEAqXmfsU+lx+NFmn6tN17RTOyaddHqLnr/3rzEDIyT9TN+tF9TG7jmK7lJ
Jrj5arQ3nTFaLF8JuND2U1z/cLPw6/TX+1tE3v3CNUDSjaisyUDiUyp3TE8hMMMz
zfZQn0JsGgNhhWxqyzjhRQGtKL4+xtn8VsF/8zGgZYke7nlmVKz/FslDFTnNoodL
BAEGiu9JQS9qqpbSs20NdZ6LXPL2A4iTjnsNFBW3jIMVIn/JVVyaycU7ue2oFviD
vLNpkVZcR7A+jjIdIumOc5VSF0y7y74cQC5YwkR2mLK7UBYDK6NCY3ta/C4M8NsM
0FpmvRl0+A1ivZtVwqI98dxDtp7HeQIDAQABoxAwDjAMBgNVHRMEBTADAQH/MA0G
CSqGSIb3DQEBBQUAA4IBAQAjfNn5BCzxylBDakFQGWKE/P43PRibMOEzfd7+DzbY
WIekoz3i00DwoH3b6j4gwlDJRAOq4dF6/Pt/uBOHDo/op+ef+9ErmKPd+ehXN9h3
7QbccTgz7DtVwA4iRlDRLru+JuXzT+OsCHuFZMOLJ+KD2JAGh3W68JjdcLkrlcpt
AU0wc5aOHPPfEBdIah8y8QtNzXRVzoBt8zzvgCARkXxTS2u/9QaXR1hML0JtDgQS
SdZ6Kd8SN6yzqxD+buYD5sOfJmjBF/n3lqFHNMHnnGXy2TAXZtIAWzffU3A0cGPB
N6FZ026a86HbF1X4k+xszhbJu/ikczyuWnCJIg3fTYSD
-----END CERTIFICATE-----
...EOF...
cat >certs/rsa-data-security-inc-secure-server.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            02:ad:66:7e:4e:45:fe:5e:57:6f:3c:98:19:5e:dd:c0
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=RSA Data Security, Inc., OU=Secure Server Certification Authority
        Validity
            Not Before: Nov  9 00:00:00 1994 GMT
            Not After : Jan  7 23:59:59 2010 GMT
        Subject: C=US, O=RSA Data Security, Inc., OU=Secure Server Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1000 bit)
                Modulus (1000 bit):
                    00:92:ce:7a:c1:ae:83:3e:5a:aa:89:83:57:ac:25:
                    01:76:0c:ad:ae:8e:2c:37:ce:eb:35:78:64:54:03:
                    e5:84:40:51:c9:bf:8f:08:e2:8a:82:08:d2:16:86:
                    37:55:e9:b1:21:02:ad:76:68:81:9a:05:a2:4b:c9:
                    4b:25:66:22:56:6c:88:07:8f:f7:81:59:6d:84:07:
                    65:70:13:71:76:3e:9b:77:4c:e3:50:89:56:98:48:
                    b9:1d:a7:29:1a:13:2e:4a:11:59:9c:1e:15:d5:49:
                    54:2c:73:3a:69:82:b1:97:39:9c:6d:70:67:48:e5:
                    dd:2d:d6:c8:1e:7b
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        65:dd:7e:e1:b2:ec:b0:e2:3a:e0:ec:71:46:9a:19:11:b8:d3:
        c7:a0:b4:03:40:26:02:3e:09:9c:e1:12:b3:d1:5a:f6:37:a5:
        b7:61:03:b6:5b:16:69:3b:c6:44:08:0c:88:53:0c:6b:97:49:
        c7:3e:35:dc:6c:b9:bb:aa:df:5c:bb:3a:2f:93:60:b6:a9:4b:
        4d:f2:20:f7:cd:5f:7f:64:7b:8e:dc:00:5c:d7:fa:77:ca:39:
        16:59:6f:0e:ea:d3:b5:83:7f:4d:4d:42:56:76:b4:c9:5f:04:
        f8:38:f8:eb:d2:5f:75:5f:cd:7b:fc:e5:8e:80:7c:fc:50
-----BEGIN CERTIFICATE-----
MIICNDCCAaECEAKtZn5ORf5eV288mBle3cAwDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYD
VQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk0
MTEwOTAwMDAwMFoXDTEwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxIDAeBgNV
BAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2Vy
dmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGbMA0GCSqGSIb3DQEBAQUAA4GJ
ADCBhQJ+AJLOesGugz5aqomDV6wlAXYMra6OLDfO6zV4ZFQD5YRAUcm/jwjiioII
0haGN1XpsSECrXZogZoFokvJSyVmIlZsiAeP94FZbYQHZXATcXY+m3dM41CJVphI
uR2nKRoTLkoRWZweFdVJVCxzOmmCsZc5nG1wZ0jl3S3WyB57AgMBAAEwDQYJKoZI
hvcNAQECBQADfgBl3X7hsuyw4jrg7HFGmhkRuNPHoLQDQCYCPgmc4RKz0Vr2N6W3
YQO2WxZpO8ZECAyIUwxrl0nHPjXcbLm7qt9cuzovk2C2qUtN8iD3zV9/ZHuO3ABc
1/p3yjkWWW8O6tO1g39NTUJWdrTJXwT4OPjr0l91X817/OWOgHz8UA==
-----END CERTIFICATE-----
...EOF...
cat >certs/secure-server-ocsp-responder.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            ff:45:d5:27:5d:24:fb:b3:c2:39:24:53:57:e1:4f:de
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=RSA Data Security, Inc., OU=Secure Server Certification Authority
        Validity
            Not Before: Aug  4 00:00:00 2000 GMT
            Not After : Aug  3 23:59:59 2004 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/RPA (c)00, CN=Secure Server OCSP Responder
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b8:51:99:64:85:0e:ee:b3:0a:68:f0:bf:63:76:
                    1d:53:f5:fc:a1:78:8c:33:ee:9f:f4:be:39:da:9b:
                    0f:4d:47:a9:8f:20:e8:4b:44:bd:ce:cd:7b:90:d1:
                    30:e8:90:c4:25:7b:89:28:de:bd:f6:93:1d:ff:b9:
                    ff:92:b5:a9:8d:e4:ae:cc:e2:c3:07:83:6a:a3:72:
                    10:01:27:62:22:a6:35:26:39:2d:9e:cf:60:0c:fc:
                    47:a4:d7:d0:42:78:a7:1d:6c:d0:cb:4f:15:a7:29:
                    0a:b4:95:45:c4:b1:e7:5a:09:d7:39:95:d8:1d:35:
                    9e:c2:bd:b3:5d:c1:0c:4b:1f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
            DirName:/CN=OCSP 1-4
            X509v3 CRL Distribution Points: 
            URI:http://crl.verisign.com/RSASecureServer-p.crl

            X509v3 Extended Key Usage: 
            OCSP Signing
            Authority Information Access: 
            OCSP - URI:http://ocsp.verisign.com/ocsp/status

            X509v3 Certificate Policies: 
            Policy: 2.16.840.1.113733.1.7.1.1
              CPS: https://www.verisign.com/RPA

            X509v3 Basic Constraints: 
            CA:FALSE
            X509v3 Key Usage: 
            Digital Signature
    Signature Algorithm: sha1WithRSAEncryption
        00:b3:10:53:66:9c:49:93:2e:31:a0:02:42:d2:58:57:7e:66:
        a1:fe:1b:8a:61:18:50:40:2c:1e:2b:41:a5:d6:db:ff:ac:08:
        1c:5a:05:6d:02:5c:2a:b6:96:4f:47:db:be:4e:db:ce:cc:ba:
        86:b8:18:ce:b1:12:91:5f:63:f7:f3:48:3e:cc:f1:4d:13:e4:
        6d:09:94:78:00:92:cb:a3:20:9d:06:0b:6a:a0:43:07:ce:d1:
        19:6c:8f:18:75:9a:9f:17:33:fd:a9:26:b8:e3:e2:de:c2:a8:
        c4:5a:8a:7f:98:d6:07:06:6b:cc:56:9e:86:70:ce:d4:ef
-----BEGIN CERTIFICATE-----
MIIDnzCCAwygAwIBAgIRAP9F1SddJPuzwjkkU1fhT94wDQYJKoZIhvcNAQEFBQAw
XzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMu
MS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5
MB4XDTAwMDgwNDAwMDAwMFoXDTA0MDgwMzIzNTk1OVowgZ4xFzAVBgNVBAoTDlZl
cmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTsw
OQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
L1JQQSAoYykwMDElMCMGA1UEAxMcU2VjdXJlIFNlcnZlciBPQ1NQIFJlc3BvbmRl
cjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAuFGZZIUO7rMKaPC/Y3YdU/X8
oXiMM+6f9L452psPTUepjyDoS0S9zs17kNEw6JDEJXuJKN699pMd/7n/krWpjeSu
zOLDB4Nqo3IQASdiIqY1Jjktns9gDPxHpNfQQninHWzQy08VpykKtJVFxLHnWgnX
OZXYHTWewr2zXcEMSx8CAwEAAaOCAR0wggEZMCAGA1UdEQQZMBekFTATMREwDwYD
VQQDEwhPQ1NQIDEtNDA+BgNVHR8ENzA1MDOgMaAvhi1odHRwOi8vY3JsLnZlcmlz
aWduLmNvbS9SU0FTZWN1cmVTZXJ2ZXItcC5jcmwwEwYDVR0lBAwwCgYIKwYBBQUH
AwkwQgYIKwYBBQUHAQEENjA0MDIGCCsGAQUFBzABpiYWJGh0dHA6Ly9vY3NwLnZl
cmlzaWduLmNvbS9vY3NwL3N0YXR1czBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBwEB
MCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlzaWduLmNvbS9SUEEwCQYD
VR0TBAIwADALBgNVHQ8EBAMCB4AwDQYJKoZIhvcNAQEFBQADfgAAsxBTZpxJky4x
oAJC0lhXfmah/huKYRhQQCweK0Gl1tv/rAgcWgVtAlwqtpZPR9u+TtvOzLqGuBjO
sRKRX2P380g+zPFNE+RtCZR4AJLLoyCdBgtqoEMHztEZbI8YdZqfFzP9qSa44+Le
wqjEWop/mNYHBmvMVp6GcM7U7w==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-00.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 0 CA/emailAddress=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 13:54:48 1998 GMT
            Not After : Dec 31 13:54:48 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 0 CA/emailAddress=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:df:7d:e6:be:bf:d5:f0:2f:6d:4e:0e:d1:e0:8d:
                    0b:7f:3b:54:e8:8a:e2:b0:9f:28:c5:8a:c6:b9:b3:
                    33:27:f5:27:ca:1a:4c:54:12:6b:b4:b2:46:b3:1d:
                    4b:b3:f4:21:0b:4b:02:2e:a1:c2:34:9c:85:a0:c4:
                    78:11:db:db:6b:27:2b:09:2a:18:4e:40:cc:9f:71:
                    19:67:99:74:a2:7c:3f:c1:d8:8b:23:c8:63:3b:8a:
                    21:ab:5c:de:1e:f4:8d:dc:b4:18:c3:05:73:f4:6a:
                    b4:a1:fa:01:08:2b:01:0f:6d:37:5b:aa:38:86:67:
                    39:d7:e5:5f:fa:e4:7e:cc:a3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
            https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
            http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
            TC TrustCenter Class 0 CA
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        4d:07:7f:5f:09:30:19:92:aa:05:47:7a:94:75:54:2a:ae:cf:
        fc:d8:0c:42:e1:45:38:2b:24:95:b2:ca:87:ca:79:c4:c3:97:
        90:5e:62:18:c6:c9:38:61:4c:68:35:d3:4c:14:11:eb:c4:cd:
        a1:a9:d8:c5:9e:68:27:32:07:35:45:04:f8:5f:21:a0:60:1e:
        1c:00:48:04:58:d2:c5:cb:ae:6d:32:6e:3d:77:95:8c:85:c7:
        e5:ae:50:9d:75:4a:7b:ff:0b:27:79:ea:4d:a4:59:ff:ec:5a:
        ea:26:a5:39:83:a4:d1:78:ce:a7:a9:7e:bc:dd:2b:ca:12:93:
        03:4a
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDAgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTEzNTQ0OFoX
DTA1MTIzMTEzNTQ0OFowgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyAwIENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA333mvr/V
8C9tTg7R4I0LfztU6IrisJ8oxYrGubMzJ/UnyhpMVBJrtLJGsx1Ls/QhC0sCLqHC
NJyFoMR4EdvbaycrCSoYTkDMn3EZZ5l0onw/wdiLI8hjO4ohq1zeHvSN3LQYwwVz
9Gq0ofoBCCsBD203W6o4hmc51+Vf+uR+zKMCAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyAw
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQBNB39fCTAZ
kqoFR3qUdVQqrs/82AxC4UU4KySVssqHynnEw5eQXmIYxsk4YUxoNdNMFBHrxM2h
qdjFnmgnMgc1RQT4XyGgYB4cAEgEWNLFy65tMm49d5WMhcflrlCddUp7/wsneepN
pFn/7FrqJqU5g6TReM6nqX683SvKEpMDSg==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-01.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 2 (0x2)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 1 CA/emailAddress=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 13:56:33 1998 GMT
            Not After : Dec 31 13:56:33 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 1 CA/emailAddress=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b0:29:eb:b4:76:b3:ae:d7:b6:5b:b4:5e:e7:bd:
                    e3:b1:9c:49:04:57:5b:a1:ab:d9:7f:13:1b:fd:ba:
                    61:ab:d8:e7:71:df:2d:00:94:5d:51:48:7d:23:ef:
                    75:62:84:90:3c:0a:1f:59:11:74:2f:8e:80:a5:fd:
                    30:02:3d:29:52:cd:72:1a:49:21:9c:bc:cb:52:8e:
                    48:a1:63:96:c8:10:85:30:69:57:74:45:c0:5a:86:
                    c6:d5:3d:e0:68:57:7d:31:6a:24:8d:45:97:3e:31:
                    7e:68:66:32:6e:24:6d:ec:32:36:c9:41:ca:f0:31:
                    44:c8:a3:61:ca:1b:a0:36:1f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
            https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
            http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
            TC TrustCenter Class 1 CA
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        05:42:52:26:a4:0c:27:01:44:ac:5c:25:28:c2:44:42:54:08:
        b9:1d:c5:3e:6c:59:66:c4:b3:4e:50:a7:f8:f8:96:75:a1:96:
        75:e8:16:38:a0:cd:5d:6e:fa:79:a7:1b:7b:1d:1e:c3:00:b9:
        66:be:5a:d6:62:0f:e7:f2:7b:b8:ef:4c:e0:c0:3f:59:ae:39:
        b7:84:09:9e:ab:f1:a9:2e:6b:69:e2:ad:cc:f2:ea:78:09:05:
        20:38:42:71:18:7e:c7:b2:97:e6:d5:02:05:06:56:a3:5f:f1:
        aa:c2:c4:4f:fe:f7:ef:16:0f:9d:ec:aa:85:cf:3d:29:24:f1:
        04:cd
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBAjANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDEgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTEzNTYzM1oX
DTA1MTIzMTEzNTYzM1owgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyAxIENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAsCnrtHaz
rte2W7Re573jsZxJBFdboavZfxMb/bphq9jncd8tAJRdUUh9I+91YoSQPAofWRF0
L46Apf0wAj0pUs1yGkkhnLzLUo5IoWOWyBCFMGlXdEXAWobG1T3gaFd9MWokjUWX
PjF+aGYybiRt7DI2yUHK8DFEyKNhyhugNh8CAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyAx
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQAFQlImpAwn
AUSsXCUowkRCVAi5HcU+bFlmxLNOUKf4+JZ1oZZ16BY4oM1dbvp5pxt7HR7DALlm
vlrWYg/n8nu470zgwD9Zrjm3hAmeq/GpLmtp4q3M8up4CQUgOEJxGH7Hspfm1QIF
BlajX/GqwsRP/vfvFg+d7KqFzz0pJPEEzQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-02.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 3 (0x3)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 2 CA/emailAddress=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 13:57:44 1998 GMT
            Not After : Dec 31 13:57:44 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 2 CA/emailAddress=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:da:38:e8:ed:32:00:29:71:83:01:0d:bf:8c:01:
                    dc:da:c6:ad:39:a4:a9:8a:2f:d5:8b:5c:68:5f:50:
                    c6:62:f5:66:bd:ca:91:22:ec:aa:1d:51:d7:3d:b3:
                    51:b2:83:4e:5d:cb:49:b0:f0:4c:55:e5:6b:2d:c7:
                    85:0b:30:1c:92:4e:82:d4:ca:02:ed:f7:6f:be:dc:
                    e0:e3:14:b8:05:53:f2:9a:f4:56:8b:5a:9e:85:93:
                    d1:b4:82:56:ae:4d:bb:a8:4b:57:16:bc:fe:f8:58:
                    9e:f8:29:8d:b0:7b:cd:78:c9:4f:ac:8b:67:0c:f1:
                    9c:fb:fc:57:9b:57:5c:4f:0d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
            https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
            http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
            TC TrustCenter Class 2 CA
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        89:1b:f4:ef:e9:38:e2:6c:0c:f6:cd:6f:49:ce:29:cc:fb:a6:
        0f:f9:8d:3e:95:46:d6:fc:47:32:89:b2:c8:06:61:7a:d2:e7:
        0d:13:02:94:0b:d9:8b:56:47:f4:bb:e7:c5:5f:7b:f4:63:4c:
        ae:7c:34:ea:0d:a2:a9:b3:2c:85:f3:e3:fe:27:54:10:92:b0:
        8f:92:c1:98:42:18:70:48:db:4e:2c:eb:0d:24:68:e4:d1:f7:
        be:09:a9:29:87:bb:e8:da:dc:3e:a3:88:42:31:f5:d1:e3:7f:
        ae:d8:8e:00:5a:74:98:b0:4f:c6:ff:23:7b:5c:73:00:78:c9:
        db:4e
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBAzANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDIgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTEzNTc0NFoX
DTA1MTIzMTEzNTc0NFowgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyAyIENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA2jjo7TIA
KXGDAQ2/jAHc2satOaSpii/Vi1xoX1DGYvVmvcqRIuyqHVHXPbNRsoNOXctJsPBM
VeVrLceFCzAckk6C1MoC7fdvvtzg4xS4BVPymvRWi1qehZPRtIJWrk27qEtXFrz+
+Fie+CmNsHvNeMlPrItnDPGc+/xXm1dcTw0CAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyAy
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQCJG/Tv6Tji
bAz2zW9JzinM+6YP+Y0+lUbW/EcyibLIBmF60ucNEwKUC9mLVkf0u+fFX3v0Y0yu
fDTqDaKpsyyF8+P+J1QQkrCPksGYQhhwSNtOLOsNJGjk0fe+Cakph7vo2tw+o4hC
MfXR43+u2I4AWnSYsE/G/yN7XHMAeMnbTg==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-03.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 4 (0x4)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 3 CA/emailAddress=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 13:58:49 1998 GMT
            Not After : Dec 31 13:58:49 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 3 CA/emailAddress=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b6:b4:c1:35:05:2e:0d:8d:ec:a0:40:6a:1c:0e:
                    27:a6:50:92:6b:50:1b:07:de:2e:e7:76:cc:e0:da:
                    fc:84:a8:5e:8c:63:6a:2b:4d:d9:4e:02:76:11:c1:
                    0b:f2:8d:79:ca:00:b6:f1:b0:0e:d7:fb:a4:17:3d:
                    af:ab:69:7a:96:27:bf:af:33:a1:9a:2a:59:aa:c4:
                    b5:37:08:f2:12:a5:31:b6:43:f5:32:96:71:28:28:
                    ab:8d:28:86:df:bb:ee:e3:0c:7d:30:d6:c3:52:ab:
                    8f:5d:27:9c:6b:c0:a3:e7:05:6b:57:49:44:b3:6e:
                    ea:64:cf:d2:8e:7a:50:77:77
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
            https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
            http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
            TC TrustCenter Class 3 CA
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        84:86:50:62:79:a0:27:e1:25:ba:09:b1:34:0f:13:09:ed:2d:
        ca:a3:e6:95:f9:30:ac:cd:17:a5:ce:3d:97:9d:ec:7c:8f:26:
        7f:c0:61:ca:22:f7:91:dd:3c:36:59:9a:9b:75:f7:bc:e4:c8:
        ed:ec:02:b6:22:a7:f3:2c:f1:c8:92:78:6d:b6:ee:c5:28:ec:
        80:20:4f:b9:6b:08:e7:2f:a7:86:1e:7d:b1:08:9f:54:b9:00:
        37:3c:a0:d8:1a:c8:96:1c:f4:32:14:9c:39:95:b7:ee:f0:43:
        49:c2:5e:e8:cb:79:6f:53:bf:fb:49:8a:2c:d8:4b:d9:55:f2:
        12:70
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBBDANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDMgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTEzNTg0OVoX
DTA1MTIzMTEzNTg0OVowgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyAzIENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtrTBNQUu
DY3soEBqHA4nplCSa1AbB94u53bM4Nr8hKhejGNqK03ZTgJ2EcEL8o15ygC28bAO
1/ukFz2vq2l6lie/rzOhmipZqsS1NwjyEqUxtkP1MpZxKCirjSiG37vu4wx9MNbD
UquPXSeca8Cj5wVrV0lEs27qZM/SjnpQd3cCAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyAz
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQCEhlBieaAn
4SW6CbE0DxMJ7S3Ko+aV+TCszRelzj2Xnex8jyZ/wGHKIveR3Tw2WZqbdfe85Mjt
7AK2IqfzLPHIknhttu7FKOyAIE+5awjnL6eGHn2xCJ9UuQA3PKDYGsiWHPQyFJw5
lbfu8ENJwl7oy3lvU7/7SYos2EvZVfIScA==
-----END CERTIFICATE-----
...EOF...
cat >certs/tc-trustcenter-for-security-in-04.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 5 (0x5)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 4 CA/emailAddress=certificate@trustcenter.de
        Validity
            Not Before: Mar  9 14:00:20 1998 GMT
            Not After : Dec 31 14:00:20 2005 GMT
        Subject: C=DE, ST=Hamburg, L=Hamburg, O=TC TrustCenter for Security in Data Networks GmbH, OU=TC TrustCenter Class 4 CA/emailAddress=certificate@trustcenter.de
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:bf:2f:63:d6:36:7b:b2:0d:d3:55:f5:64:6c:e6:
                    25:5d:c6:b4:c8:14:ba:25:38:83:eb:56:62:a5:55:
                    a9:65:a3:f4:23:99:c2:4b:b9:d0:cd:54:67:a6:a3:
                    a0:a3:a9:33:2b:76:e4:bd:ad:77:b2:ed:5c:12:74:
                    c3:c5:b6:0f:52:9a:72:93:43:90:62:66:15:0f:45:
                    a5:dd:e0:dd:b8:6f:40:6e:57:c1:79:72:a3:60:aa:
                    ba:76:1d:12:89:53:5a:fc:02:be:e1:09:13:c5:4a:
                    2f:dc:3d:8b:19:ad:d7:8b:24:45:fb:4c:f4:cd:5c:
                    35:1d:29:4c:51:f3:f2:6c:55
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape CA Revocation Url: 
            https://www.trustcenter.de/cgi-bin/check-rev.cgi?
            Netscape Renewal Url: 
            https://www.trustcenter.de/cgi-bin/Renew.cgi?
            Netscape CA Policy Url: 
            http://www.trustcenter.de/guidelines/index.html
            Netscape Comment: 
            TC TrustCenter Class 4 CA
            Netscape Cert Type: 
            SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: md5WithRSAEncryption
        94:68:14:1b:25:9e:29:99:b1:b2:23:d2:44:b3:95:9f:d1:9e:
        55:04:dd:e3:2f:82:33:55:96:77:19:9d:2b:9e:65:1c:fa:8a:
        e3:c7:8f:25:fc:b1:1e:55:46:0f:8f:ff:4f:37:2f:a4:76:59:
        a6:64:eb:d5:16:70:bd:dd:95:33:0c:a4:0d:24:eb:64:50:b4:
        43:11:f2:43:be:0d:71:98:22:ec:01:af:ec:f7:c7:5c:71:c3:
        75:91:58:19:e8:dd:a0:f4:b4:f1:bc:10:4a:f3:93:b4:06:49:
        bb:1f:66:d2:bd:74:47:e1:9a:f9:eb:d7:ab:6d:1f:ba:e1:1d:
        2c:da
-----BEGIN CERTIFICATE-----
MIIENTCCA56gAwIBAgIBBTANBgkqhkiG9w0BAQQFADCBvDELMAkGA1UEBhMCREUx
EDAOBgNVBAgTB0hhbWJ1cmcxEDAOBgNVBAcTB0hhbWJ1cmcxOjA4BgNVBAoTMVRD
IFRydXN0Q2VudGVyIGZvciBTZWN1cml0eSBpbiBEYXRhIE5ldHdvcmtzIEdtYkgx
IjAgBgNVBAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDQgQ0ExKTAnBgkqhkiG9w0B
CQEWGmNlcnRpZmljYXRlQHRydXN0Y2VudGVyLmRlMB4XDTk4MDMwOTE0MDAyMFoX
DTA1MTIzMTE0MDAyMFowgbwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdIYW1idXJn
MRAwDgYDVQQHEwdIYW1idXJnMTowOAYDVQQKEzFUQyBUcnVzdENlbnRlciBmb3Ig
U2VjdXJpdHkgaW4gRGF0YSBOZXR3b3JrcyBHbWJIMSIwIAYDVQQLExlUQyBUcnVz
dENlbnRlciBDbGFzcyA0IENBMSkwJwYJKoZIhvcNAQkBFhpjZXJ0aWZpY2F0ZUB0
cnVzdGNlbnRlci5kZTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAvy9j1jZ7
sg3TVfVkbOYlXca0yBS6JTiD61ZipVWpZaP0I5nCS7nQzVRnpqOgo6kzK3bkva13
su1cEnTDxbYPUppyk0OQYmYVD0Wl3eDduG9AblfBeXKjYKq6dh0SiVNa/AK+4QkT
xUov3D2LGa3XiyRF+0z0zVw1HSlMUfPybFUCAwEAAaOCAUMwggE/MEAGCWCGSAGG
+EIBAwQzFjFodHRwczovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL2NoZWNr
LXJldi5jZ2k/MEAGCWCGSAGG+EIBBAQzFjFodHRwczovL3d3dy50cnVzdGNlbnRl
ci5kZS9jZ2ktYmluL2NoZWNrLXJldi5jZ2k/MDwGCWCGSAGG+EIBBwQvFi1odHRw
czovL3d3dy50cnVzdGNlbnRlci5kZS9jZ2ktYmluL1JlbmV3LmNnaT8wPgYJYIZI
AYb4QgEIBDEWL2h0dHA6Ly93d3cudHJ1c3RjZW50ZXIuZGUvZ3VpZGVsaW5lcy9p
bmRleC5odG1sMCgGCWCGSAGG+EIBDQQbFhlUQyBUcnVzdENlbnRlciBDbGFzcyA0
IENBMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG9w0BAQQFAAOBgQCUaBQbJZ4p
mbGyI9JEs5Wf0Z5VBN3jL4IzVZZ3GZ0rnmUc+orjx48l/LEeVUYPj/9PNy+kdlmm
ZOvVFnC93ZUzDKQNJOtkULRDEfJDvg1xmCLsAa/s98dcccN1kVgZ6N2g9LTxvBBK
85O0Bkm7H2bSvXRH4Zr569erbR+64R0s2g==
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-personal-basic-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Basic CA/emailAddress=personal-basic@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Basic CA/emailAddress=personal-basic@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:bc:bc:93:53:6d:c0:50:4f:82:15:e6:48:94:35:
                    a6:5a:be:6f:42:fa:0f:47:ee:77:75:72:dd:8d:49:
                    9b:96:57:a0:78:d4:ca:3f:51:b3:69:0b:91:76:17:
                    22:07:97:6a:c4:51:93:4b:e0:8d:ef:37:95:a1:0c:
                    4d:da:34:90:1d:17:89:97:e0:35:38:57:4a:c0:f4:
                    08:70:e9:3c:44:7b:50:7e:61:9a:90:e3:23:d3:88:
                    11:46:27:f5:0b:07:0e:bb:dd:d1:7f:20:0a:88:b9:
                    56:0b:2e:1c:80:da:f1:e3:9e:29:ef:14:bd:0a:44:
                    fb:1b:5b:18:d1:bf:23:93:21
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        2d:e2:99:6b:b0:3d:7a:89:d7:59:a2:94:01:1f:2b:dd:12:4b:
        53:c2:ad:7f:aa:a7:00:5c:91:40:57:25:4a:38:aa:84:70:b9:
        d9:80:0f:a5:7b:5c:fb:73:c6:bd:d7:8a:61:5c:03:e3:2d:27:
        a8:17:e0:84:85:42:dc:5e:9b:c6:b7:b2:6d:bb:74:af:e4:3f:
        cb:a7:b7:b0:e0:5d:be:78:83:25:94:d2:db:81:0f:79:07:6d:
        4f:f4:39:15:5a:52:01:7b:de:32:d6:4d:38:f6:12:5c:06:50:
        df:05:5b:bd:14:4b:a1:df:29:ba:3b:41:8d:f7:63:56:a1:df:
        22:b1
-----BEGIN CERTIFICATE-----
MIIDITCCAoqgAwIBAgIBADANBgkqhkiG9w0BAQQFADCByzELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhhd3RlIFBlcnNvbmFsIEJhc2lj
IENBMSgwJgYJKoZIhvcNAQkBFhlwZXJzb25hbC1iYXNpY0B0aGF3dGUuY29tMB4X
DTk2MDEwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgcsxCzAJBgNVBAYTAlpBMRUw
EwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEaMBgGA1UE
ChMRVGhhd3RlIENvbnN1bHRpbmcxKDAmBgNVBAsTH0NlcnRpZmljYXRpb24gU2Vy
dmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRoYXd0ZSBQZXJzb25hbCBCYXNpYyBD
QTEoMCYGCSqGSIb3DQEJARYZcGVyc29uYWwtYmFzaWNAdGhhd3RlLmNvbTCBnzAN
BgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAvLyTU23AUE+CFeZIlDWmWr5vQvoPR+53
dXLdjUmbllegeNTKP1GzaQuRdhciB5dqxFGTS+CN7zeVoQxN2jSQHReJl+A1OFdK
wPQIcOk8RHtQfmGakOMj04gRRif1CwcOu93RfyAKiLlWCy4cgNrx454p7xS9CkT7
G1sY0b8jkyECAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQQF
AAOBgQAt4plrsD16iddZopQBHyvdEktTwq1/qqcAXJFAVyVKOKqEcLnZgA+le1z7
c8a914phXAPjLSeoF+CEhULcXpvGt7Jtu3Sv5D/Lp7ew4F2+eIMllNLbgQ95B21P
9DkVWlIBe94y1k049hJcBlDfBVu9FEuh3ym6O0GN92NWod8isQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-personal-freemail-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Freemail CA/emailAddress=personal-freemail@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Freemail CA/emailAddress=personal-freemail@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d4:69:d7:d4:b0:94:64:5b:71:e9:47:d8:0c:51:
                    b6:ea:72:91:b0:84:5e:7d:2d:0d:8f:7b:12:df:85:
                    25:75:28:74:3a:42:2c:63:27:9f:95:7b:4b:ef:7e:
                    19:87:1d:86:ea:a3:dd:b9:ce:96:64:1a:c2:14:6e:
                    44:ac:7c:e6:8f:e8:4d:0f:71:1f:40:38:a6:00:a3:
                    87:78:f6:f9:94:86:5e:ad:ea:c0:5e:76:eb:d9:14:
                    a3:5d:6e:7a:7c:0c:a5:4b:55:7f:06:19:29:7f:9e:
                    9a:26:d5:6a:bb:38:24:08:6a:98:c7:b1:da:a3:98:
                    91:fd:79:db:e5:5a:c4:1c:b9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        c7:ec:92:7e:4e:f8:f5:96:a5:67:62:2a:a4:f0:4d:11:60:d0:
        6f:8d:60:58:61:ac:26:bb:52:35:5c:08:cf:30:fb:a8:4a:96:
        8a:1f:62:42:23:8c:17:0f:f4:ba:64:9c:17:ac:47:29:df:9d:
        98:5e:d2:6c:60:71:5c:a2:ac:dc:79:e3:e7:6e:00:47:1f:b5:
        0d:28:e8:02:9d:e4:9a:fd:13:f4:a6:d9:7c:b1:f8:dc:5f:23:
        26:09:91:80:73:d0:14:1b:de:43:a9:83:25:f2:e6:9c:2f:15:
        ca:fe:a6:ab:8a:07:75:8b:0c:dd:51:84:6b:e4:f8:d1:ce:77:
        a2:81
-----BEGIN CERTIFICATE-----
MIIDLTCCApagAwIBAgIBADANBgkqhkiG9w0BAQQFADCB0TELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEkMCIGA1UEAxMbVGhhd3RlIFBlcnNvbmFsIEZyZWVt
YWlsIENBMSswKQYJKoZIhvcNAQkBFhxwZXJzb25hbC1mcmVlbWFpbEB0aGF3dGUu
Y29tMB4XDTk2MDEwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgdExCzAJBgNVBAYT
AlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEa
MBgGA1UEChMRVGhhd3RlIENvbnN1bHRpbmcxKDAmBgNVBAsTH0NlcnRpZmljYXRp
b24gU2VydmljZXMgRGl2aXNpb24xJDAiBgNVBAMTG1RoYXd0ZSBQZXJzb25hbCBG
cmVlbWFpbCBDQTErMCkGCSqGSIb3DQEJARYccGVyc29uYWwtZnJlZW1haWxAdGhh
d3RlLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA1GnX1LCUZFtx6UfY
DFG26nKRsIRefS0Nj3sS34UldSh0OkIsYyeflXtL734Zhx2G6qPduc6WZBrCFG5E
rHzmj+hND3EfQDimAKOHePb5lIZererAXnbr2RSjXW56fAylS1V/Bhkpf56aJtVq
uzgkCGqYx7Hao5iR/Xnb5VrEHLkCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zAN
BgkqhkiG9w0BAQQFAAOBgQDH7JJ+Tvj1lqVnYiqk8E0RYNBvjWBYYawmu1I1XAjP
MPuoSpaKH2JCI4wXD/S6ZJwXrEcp352YXtJsYHFcoqzceePnbgBHH7UNKOgCneSa
/RP0ptl8sfjcXyMmCZGAc9AUG95DqYMl8uacLxXK/qarigd1iwzdUYRr5PjRznei
gQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-personal-premium-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Premium CA/emailAddress=personal-premium@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Premium CA/emailAddress=personal-premium@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c9:66:d9:f8:07:44:cf:b9:8c:2e:f0:a1:ef:13:
                    45:6c:05:df:de:27:16:51:36:41:11:6c:6c:3b:ed:
                    fe:10:7d:12:9e:e5:9b:42:9a:fe:60:31:c3:66:b7:
                    73:3a:48:ae:4e:d0:32:37:94:88:b5:0d:b6:d9:f3:
                    f2:44:d9:d5:88:12:dd:76:4d:f2:1a:fc:6f:23:1e:
                    7a:f1:d8:98:45:4e:07:10:ef:16:42:d0:43:75:6d:
                    4a:de:e2:aa:c9:31:ff:1f:00:70:7c:66:cf:10:25:
                    08:ba:fa:ee:00:e9:46:03:66:27:11:15:3b:aa:5b:
                    f2:98:dd:36:42:b2:da:88:75
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        69:36:89:f7:34:2a:33:72:2f:6d:3b:d4:22:b2:b8:6f:9a:c5:
        36:66:0e:1b:3c:a1:b1:75:5a:e6:fd:35:d3:f8:a8:f2:07:6f:
        85:67:8e:de:2b:b9:e2:17:b0:3a:a0:f0:0e:a2:00:9a:df:f3:
        14:15:6e:bb:c8:85:5a:98:80:f9:ff:be:74:1d:3d:f3:fe:30:
        25:d1:37:34:67:fa:a5:71:79:30:61:29:72:c0:e0:2c:4c:fb:
        56:e4:3a:a8:6f:e5:32:59:52:db:75:28:50:59:0c:f8:0b:19:
        e4:ac:d9:af:96:8d:2f:50:db:07:c3:ea:1f:ab:33:e0:f5:2b:
        31:89
-----BEGIN CERTIFICATE-----
MIIDKTCCApKgAwIBAgIBADANBgkqhkiG9w0BAQQFADCBzzELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEjMCEGA1UEAxMaVGhhd3RlIFBlcnNvbmFsIFByZW1p
dW0gQ0ExKjAoBgkqhkiG9w0BCQEWG3BlcnNvbmFsLXByZW1pdW1AdGhhd3RlLmNv
bTAeFw05NjAxMDEwMDAwMDBaFw0yMDEyMzEyMzU5NTlaMIHPMQswCQYDVQQGEwJa
QTEVMBMGA1UECBMMV2VzdGVybiBDYXBlMRIwEAYDVQQHEwlDYXBlIFRvd24xGjAY
BgNVBAoTEVRoYXd0ZSBDb25zdWx0aW5nMSgwJgYDVQQLEx9DZXJ0aWZpY2F0aW9u
IFNlcnZpY2VzIERpdmlzaW9uMSMwIQYDVQQDExpUaGF3dGUgUGVyc29uYWwgUHJl
bWl1bSBDQTEqMCgGCSqGSIb3DQEJARYbcGVyc29uYWwtcHJlbWl1bUB0aGF3dGUu
Y29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJZtn4B0TPuYwu8KHvE0Vs
Bd/eJxZRNkERbGw77f4QfRKe5ZtCmv5gMcNmt3M6SK5O0DI3lIi1DbbZ8/JE2dWI
Et12TfIa/G8jHnrx2JhFTgcQ7xZC0EN1bUre4qrJMf8fAHB8Zs8QJQi6+u4A6UYD
ZicRFTuqW/KY3TZCstqIdQIDAQABoxMwETAPBgNVHRMBAf8EBTADAQH/MA0GCSqG
SIb3DQEBBAUAA4GBAGk2ifc0KjNyL2071CKyuG+axTZmDhs8obF1Wub9NdP4qPIH
b4Vnjt4rueIXsDqg8A6iAJrf8xQVbrvIhVqYgPn/vnQdPfP+MCXRNzRn+qVxeTBh
KXLA4CxM+1bkOqhv5TJZUtt1KFBZDPgLGeSs2a+WjS9Q2wfD6h+rM+D1KzGJ
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-premium-server-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d2:36:36:6a:8b:d7:c2:5b:9e:da:81:41:62:8f:
                    38:ee:49:04:55:d6:d0:ef:1c:1b:95:16:47:ef:18:
                    48:35:3a:52:f4:2b:6a:06:8f:3b:2f:ea:56:e3:af:
                    86:8d:9e:17:f7:9e:b4:65:75:02:4d:ef:cb:09:a2:
                    21:51:d8:9b:d0:67:d0:ba:0d:92:06:14:73:d4:93:
                    cb:97:2a:00:9c:5c:4e:0c:bc:fa:15:52:fc:f2:44:
                    6e:da:11:4a:6e:08:9f:2f:2d:e3:f9:aa:3a:86:73:
                    b6:46:53:58:c8:89:05:bd:83:11:b8:73:3f:aa:07:
                    8d:f4:42:4d:e7:40:9d:1c:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        26:48:2c:16:c2:58:fa:e8:16:74:0c:aa:aa:5f:54:3f:f2:d7:
        c9:78:60:5e:5e:6e:37:63:22:77:36:7e:b2:17:c4:34:b9:f5:
        08:85:fc:c9:01:38:ff:4d:be:f2:16:42:43:e7:bb:5a:46:fb:
        c1:c6:11:1f:f1:4a:b0:28:46:c9:c3:c4:42:7d:bc:fa:ab:59:
        6e:d5:b7:51:88:11:e3:a4:85:19:6b:82:4c:a4:0c:12:ad:e9:
        a4:ae:3f:f1:c3:49:65:9a:8c:c5:c8:3e:25:b7:94:99:bb:92:
        32:71:07:f0:86:5e:ed:50:27:a6:0d:a6:23:f9:bb:cb:a6:07:
        14:42
-----BEGIN CERTIFICATE-----
MIIDJzCCApCgAwIBAgIBATANBgkqhkiG9w0BAQQFADCBzjELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYD
VQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlv
biBTZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhhd3RlIFByZW1pdW0gU2Vy
dmVyIENBMSgwJgYJKoZIhvcNAQkBFhlwcmVtaXVtLXNlcnZlckB0aGF3dGUuY29t
MB4XDTk2MDgwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgc4xCzAJBgNVBAYTAlpB
MRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEdMBsG
A1UEChMUVGhhd3RlIENvbnN1bHRpbmcgY2MxKDAmBgNVBAsTH0NlcnRpZmljYXRp
b24gU2VydmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRoYXd0ZSBQcmVtaXVtIFNl
cnZlciBDQTEoMCYGCSqGSIb3DQEJARYZcHJlbWl1bS1zZXJ2ZXJAdGhhd3RlLmNv
bTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0jY2aovXwlue2oFBYo847kkE
VdbQ7xwblRZH7xhINTpS9CtqBo87L+pW46+GjZ4X9560ZXUCTe/LCaIhUdib0GfQ
ug2SBhRz1JPLlyoAnFxODLz6FVL88kRu2hFKbgifLy3j+ao6hnO2RlNYyIkFvYMR
uHM/qgeN9EJN50CdHDcCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG
9w0BAQQFAAOBgQAmSCwWwlj66BZ0DKqqX1Q/8tfJeGBeXm43YyJ3Nn6yF8Q0ufUI
hfzJATj/Tb7yFkJD57taRvvBxhEf8UqwKEbJw8RCfbz6q1lu1bdRiBHjpIUZa4JM
pAwSremkrj/xw0llmozFyD4lt5SZu5IycQfwhl7tUCemDaYj+bvLpgcUQg==
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-server-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA/emailAddress=server-certs@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA/emailAddress=server-certs@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d3:a4:50:6e:c8:ff:56:6b:e6:cf:5d:b6:ea:0c:
                    68:75:47:a2:aa:c2:da:84:25:fc:a8:f4:47:51:da:
                    85:b5:20:74:94:86:1e:0f:75:c9:e9:08:61:f5:06:
                    6d:30:6e:15:19:02:e9:52:c0:62:db:4d:99:9e:e2:
                    6a:0c:44:38:cd:fe:be:e3:64:09:70:c5:fe:b1:6b:
                    29:b6:2f:49:c8:3b:d4:27:04:25:10:97:2f:e7:90:
                    6d:c0:28:42:99:d7:4c:43:de:c3:f5:21:6d:54:9f:
                    5d:c3:58:e1:c0:e4:d9:5b:b0:b8:dc:b4:7b:df:36:
                    3a:c2:b5:66:22:12:d6:87:0d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        07:fa:4c:69:5c:fb:95:cc:46:ee:85:83:4d:21:30:8e:ca:d9:
        a8:6f:49:1a:e6:da:51:e3:60:70:6c:84:61:11:a1:1a:c8:48:
        3e:59:43:7d:4f:95:3d:a1:8b:b7:0b:62:98:7a:75:8a:dd:88:
        4e:4e:9e:40:db:a8:cc:32:74:b9:6f:0d:c6:e3:b3:44:0b:d9:
        8a:6f:9a:29:9b:99:18:28:3b:d1:e3:40:28:9a:5a:3c:d5:b5:
        e7:20:1b:8b:ca:a4:ab:8d:e9:51:d9:e2:4c:2c:59:a9:da:b9:
        b2:75:1b:f6:42:f2:ef:c7:f2:18:f9:89:bc:a3:ff:8a:23:2e:
        70:47
-----BEGIN CERTIFICATE-----
MIIDEzCCAnygAwIBAgIBATANBgkqhkiG9w0BAQQFADCBxDELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYD
VQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlv
biBTZXJ2aWNlcyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZlciBDQTEm
MCQGCSqGSIb3DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wHhcNOTYwODAx
MDAwMDAwWhcNMjAxMjMxMjM1OTU5WjCBxDELMAkGA1UEBhMCWkExFTATBgNVBAgT
DFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYDVQQKExRUaGF3
dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNl
cyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZlciBDQTEmMCQGCSqGSIb3
DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQAD
gY0AMIGJAoGBANOkUG7I/1Zr5s9dtuoMaHVHoqrC2oQl/Kj0R1HahbUgdJSGHg91
yekIYfUGbTBuFRkC6VLAYttNmZ7iagxEOM3+vuNkCXDF/rFrKbYvScg71CcEJRCX
L+eQbcAoQpnXTEPew/UhbVSfXcNY4cDk2VuwuNy0e982OsK1ZiIS1ocNAgMBAAGj
EzARMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEEBQADgYEAB/pMaVz7lcxG
7oWDTSEwjsrZqG9JGubaUeNgcGyEYRGhGshIPllDfU+VPaGLtwtimHp1it2ITk6e
QNuozDJ0uW8NxuOzRAvZim+aKZuZGCg70eNAKJpaPNW15yAbi8qkq43pUdniTCxZ
qdq5snUb9kLy78fyGPmJvKP/iiMucEc=
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-timestamping-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Durbanville, O=Thawte, OU=Thawte Certification, CN=Thawte Timestamping CA
        Validity
            Not Before: Jan  1 00:00:00 1997 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Durbanville, O=Thawte, OU=Thawte Certification, CN=Thawte Timestamping CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d6:2b:58:78:61:45:86:53:ea:34:7b:51:9c:ed:
                    b0:e6:2e:18:0e:fe:e0:5f:a8:27:d3:b4:c9:e0:7c:
                    59:4e:16:0e:73:54:60:c1:7f:f6:9f:2e:e9:3a:85:
                    24:15:3c:db:47:04:63:c3:9e:c4:94:1a:5a:df:4c:
                    7a:f3:d9:43:1d:3c:10:7a:79:25:db:90:fe:f0:51:
                    e7:30:d6:41:00:fd:9f:28:df:79:be:94:bb:9d:b6:
                    14:e3:23:85:d7:a9:41:e0:4c:a4:79:b0:2b:1a:8b:
                    f2:f8:3b:8a:3e:45:ac:71:92:00:b4:90:41:98:fb:
                    5f:ed:fa:b7:2e:8a:f8:88:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        67:db:e2:c2:e6:87:3d:40:83:86:37:35:7d:1f:ce:9a:c3:0c:
        66:20:a8:ba:aa:04:89:86:c2:f5:10:08:0d:bf:cb:a2:05:8a:
        d0:4d:36:3e:f4:d7:ef:69:c6:5e:e4:b0:94:6f:4a:b9:e7:de:
        5b:88:b6:7b:db:e3:27:e5:76:c3:f0:35:c1:cb:b5:27:9b:33:
        79:dc:90:a6:00:9e:77:fa:fc:cd:27:94:42:16:9c:d3:1c:68:
        ec:bf:5c:dd:e5:a9:7b:10:0a:32:74:54:13:31:8b:85:03:84:
        91:b7:58:01:30:14:38:af:28:ca:fc:b1:50:19:19:09:ac:89:
        49:d3
-----BEGIN CERTIFICATE-----
MIICoTCCAgqgAwIBAgIBADANBgkqhkiG9w0BAQQFADCBizELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTEUMBIGA1UEBxMLRHVyYmFudmlsbGUxDzAN
BgNVBAoTBlRoYXd0ZTEdMBsGA1UECxMUVGhhd3RlIENlcnRpZmljYXRpb24xHzAd
BgNVBAMTFlRoYXd0ZSBUaW1lc3RhbXBpbmcgQ0EwHhcNOTcwMTAxMDAwMDAwWhcN
MjAxMjMxMjM1OTU5WjCBizELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4g
Q2FwZTEUMBIGA1UEBxMLRHVyYmFudmlsbGUxDzANBgNVBAoTBlRoYXd0ZTEdMBsG
A1UECxMUVGhhd3RlIENlcnRpZmljYXRpb24xHzAdBgNVBAMTFlRoYXd0ZSBUaW1l
c3RhbXBpbmcgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANYrWHhhRYZT
6jR7UZztsOYuGA7+4F+oJ9O0yeB8WU4WDnNUYMF/9p8u6TqFJBU820cEY8OexJQa
Wt9MevPZQx08EHp5JduQ/vBR5zDWQQD9nyjfeb6Uu522FOMjhdepQeBMpHmwKxqL
8vg7ij5FrHGSALSQQZj7X+36ty6K+Ig3AgMBAAGjEzARMA8GA1UdEwEB/wQFMAMB
Af8wDQYJKoZIhvcNAQEEBQADgYEAZ9viwuaHPUCDhjc1fR/OmsMMZiCouqoEiYbC
9RAIDb/LogWK0E02PvTX72nGXuSwlG9KuefeW4i2e9vjJ+V2w/A1wcu1J5szedyQ
pgCed/r8zSeUQhac0xxo7L9c3eWpexAKMnRUEzGLhQOEkbdYATAUOK8oyvyxUBkZ
CayJSdM=
-----END CERTIFICATE-----
...EOF...
cat >certs/thawte-universal-ca-root.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Thawte, OU=Thawte Universal CA Root, CN=Thawte Universal CA Root
        Validity
            Not Before: Dec  5 13:56:05 1999 GMT
            Not After : Apr  3 13:56:05 2037 GMT
        Subject: O=Thawte, OU=Thawte Universal CA Root, CN=Thawte Universal CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (16384 bit)
                Modulus (16384 bit):
                    00:e2:89:05:6d:c3:7f:ad:a6:89:3a:ff:bb:c7:cd:
                    9d:37:b1:e1:d2:21:1e:9b:61:2a:15:e7:7b:57:4f:
                    55:3c:d0:bb:f9:d9:3d:3e:a6:bc:ec:b4:ad:53:9a:
                    16:02:eb:0b:72:fd:8a:f2:8f:44:05:c5:eb:d3:e5:
                    bd:b6:44:39:e6:fb:47:bf:6a:9e:0a:95:18:e2:68:
                    e2:d6:96:d6:21:ad:88:fd:f5:17:f5:d3:da:42:a5:
                    90:ed:29:95:96:75:3a:da:87:a1:d4:f5:d3:87:de:
                    05:62:a6:e3:66:74:92:cf:a5:bc:bb:df:68:ff:71:
                    75:56:41:59:35:eb:33:5a:66:51:f2:d2:a3:0a:c1:
                    8c:ce:73:5c:11:6f:2d:8c:95:8c:91:b1:fd:cf:e5:
                    ad:56:95:cc:85:92:83:90:55:41:c9:c2:77:ed:f9:
                    a3:74:42:0a:68:08:f3:d0:d1:65:fd:67:2c:34:ff:
                    24:7f:e7:79:c8:07:3b:25:57:dd:a4:0c:98:3d:be:
                    e0:cc:19:65:db:f2:54:a2:af:42:d4:9d:e2:ae:84:
                    23:25:09:33:12:b5:6a:1e:76:c4:8b:d9:49:00:6c:
                    5e:ba:1f:f2:1b:da:67:ca:27:aa:a3:44:23:1b:83:
                    82:ce:f2:ab:33:ed:54:a4:dc:c9:ab:59:65:d1:38:
                    0e:c1:3e:1b:67:8f:d6:75:01:e0:55:22:dd:76:77:
                    ec:8e:dd:f4:cf:79:22:6d:b9:57:03:f5:99:08:a7:
                    3c:3e:34:fb:c4:17:ae:23:58:cd:24:f3:23:ca:6a:
                    02:28:94:01:81:34:b4:6c:6b:ae:8b:1a:c3:a3:d2:
                    09:3c:16:54:f5:36:5f:24:e3:9f:4a:a1:e2:64:c6:
                    16:c3:a6:81:7a:24:36:47:8e:c1:5e:0e:fb:f9:15:
                    78:04:d6:0e:59:d9:9d:58:66:62:d2:94:29:32:32:
                    c8:78:b9:66:f6:b5:56:e1:6c:c6:14:4b:96:52:59:
                    91:02:24:6a:55:47:d7:3f:b6:23:1a:60:77:97:2e:
                    e2:40:af:9e:04:57:9e:ad:11:c5:c9:43:70:ef:48:
                    b4:5e:ac:1c:69:2e:2e:82:d5:5b:8b:be:82:be:19:
                    14:5e:e7:0d:22:c7:51:1b:ff:1e:9b:f1:30:8f:71:
                    31:06:b3:34:27:8f:5f:7a:66:82:4f:8a:2d:13:ab:
                    42:cf:21:56:9e:97:8e:66:36:0f:96:9b:e5:2b:f4:
                    02:a9:2a:6a:8c:2c:c4:c3:b8:70:2c:2d:29:1e:3f:
                    50:77:1e:6d:2a:54:e4:55:0a:91:38:a1:c5:b5:66:
                    a2:76:5a:ee:0f:bf:b4:67:e1:28:6e:0f:e1:36:a1:
                    82:d1:bf:d4:77:e1:c4:67:32:93:78:c8:e7:54:53:
                    fe:23:79:e6:68:cc:26:90:f6:10:63:5d:2a:6f:91:
                    2d:a4:73:32:51:21:f2:bb:15:df:aa:24:08:48:06:
                    de:a1:9e:26:bf:ba:83:bf:7c:a4:c8:a0:8c:bd:d2:
                    ff:bc:84:69:27:13:24:18:c4:45:18:23:26:5e:18:
                    14:ca:2e:88:87:62:a3:53:e6:21:b7:b8:85:7b:9a:
                    85:bb:15:26:72:f8:b9:f7:6a:74:0f:49:3f:92:be:
                    a9:05:b7:99:27:bf:bf:09:17:4b:99:4c:ad:11:10:
                    7c:df:74:31:f6:8f:26:5f:aa:88:ae:38:57:c8:55:
                    2d:d3:fb:d8:1b:51:99:be:25:1b:3a:ba:c0:7d:1b:
                    ed:ce:d2:49:b9:cf:f3:c5:7d:89:90:81:d8:69:48:
                    20:10:a3:f8:ef:92:51:18:32:8b:11:18:c0:3f:1b:
                    85:56:ce:57:c9:f2:82:64:c6:df:02:09:2e:4a:11:
                    2f:b1:27:6d:37:52:f0:f0:16:61:f1:67:8d:df:87:
                    72:af:87:da:cf:fb:50:94:6e:d4:94:85:eb:8a:2c:
                    ea:21:f5:96:4a:44:d5:e0:ce:6a:74:44:4d:d0:05:
                    d3:87:15:ed:36:d0:a4:8b:66:55:70:93:ee:47:06:
                    c1:7e:2e:a5:18:79:67:f3:28:85:f1:70:f7:0e:83:
                    a4:7e:54:9e:5a:76:32:cb:65:1b:b8:cd:fb:c8:28:
                    03:d2:54:91:d1:a7:c5:85:43:08:17:76:a5:e6:2f:
                    67:08:d8:a1:a2:82:2d:0c:f8:c1:af:63:d4:50:77:
                    6d:6b:46:4a:41:85:d5:90:5f:79:2d:c4:ec:d7:11:
                    87:40:8a:e1:68:e2:64:f8:55:32:fb:6f:93:2c:da:
                    77:d9:21:c1:17:e5:36:2c:4e:7e:90:7f:ac:94:2b:
                    32:67:be:38:50:76:b8:ae:41:b9:d7:21:c5:09:4c:
                    60:c8:a3:51:c4:34:9b:57:37:df:cb:c9:33:57:8b:
                    eb:fb:76:9f:19:4d:c5:6a:1f:2a:45:ae:2b:ed:2f:
                    8d:a7:a5:00:cb:04:fa:25:62:2e:74:48:1b:ca:2a:
                    8c:ba:db:b6:7e:f6:bb:02:7c:a9:c3:db:58:78:a1:
                    bf:f0:fe:1a:10:55:11:ce:e8:69:4e:96:65:c6:17:
                    03:d6:07:68:8c:54:82:ae:1c:22:55:3f:f1:f4:09:
                    97:28:c0:46:f7:4e:0b:25:1d:f7:07:d7:09:1d:3a:
                    18:57:38:3b:e8:33:06:e7:8f:78:46:1e:5b:f5:06:
                    b6:ec:b8:a6:0d:f1:ba:13:4b:d6:18:20:dd:69:33:
                    4a:33:15:ae:b8:c8:98:8a:27:2c:93:bc:2d:fb:ee:
                    33:bf:66:e6:4d:ba:b6:9b:06:55:60:97:4b:bc:44:
                    cd:7e:f4:a1:d8:aa:2f:c0:02:28:21:16:62:78:db:
                    08:54:f2:fc:f4:34:e3:c6:8f:1c:43:57:ce:90:1a:
                    4b:dc:2e:3b:28:91:89:3f:7a:da:35:1d:8e:2c:ee:
                    49:ec:f4:33:ad:c9:53:a8:8c:9f:04:53:3e:24:1c:
                    52:c9:12:f9:62:57:a3:bc:ee:2c:eb:40:7c:20:23:
                    70:2b:95:f9:73:17:8a:d1:c1:1c:69:a6:b7:38:9a:
                    67:f7:70:1d:7a:5a:0c:40:cf:62:0f:85:3c:c2:02:
                    4e:7e:b5:f6:c5:2a:29:84:b3:1f:37:2a:e1:aa:72:
                    42:c4:ed:6b:1a:8f:92:1c:5d:be:d1:f2:5b:f2:ab:
                    aa:a9:d2:f5:b8:a4:41:2b:2b:91:6e:12:48:ca:98:
                    d8:37:8d:c8:ed:00:30:b5:b6:04:4e:7e:9c:da:84:
                    ec:c0:fa:7b:e5:1d:88:a4:53:46:b0:94:e4:5c:1b:
                    a1:25:2c:0f:48:52:77:97:09:6c:ec:5b:18:33:83:
                    02:e5:82:7e:cd:85:21:30:11:fd:27:4f:cf:e4:1e:
                    ec:3f:a5:57:6c:e9:2a:30:19:2a:88:e5:c3:69:38:
                    ab:6f:39:71:7f:84:e1:41:c3:e1:cc:2a:89:20:52:
                    2e:83:0f:6c:39:3f:4b:2d:16:ac:2d:f0:24:ac:00:
                    73:f4:9b:b3:06:3f:05:b8:14:85:1f:ab:9e:5c:3c:
                    9e:62:9d:0e:6d:3b:80:09:fc:02:ea:a2:97:74:ca:
                    c7:f9:e3:56:e1:c3:ca:a5:a6:9a:c0:90:e0:24:12:
                    53:d2:c2:8b:da:be:ed:02:43:5e:67:e1:89:98:79:
                    ee:cb:aa:ca:c3:1b:dc:e7:a5:46:a5:7c:6b:16:87:
                    b6:5a:28:d7:db:27:3c:5e:a5:bd:b6:51:dd:1f:43:
                    cf:3b:26:c8:3a:8d:25:61:c1:49:f4:3c:1b:c9:44:
                    ea:af:1c:c2:2b:94:01:2a:0e:30:d1:5b:8b:2b:47:
                    e5:c3:d1:04:03:9b:0e:39:2c:d6:27:d4:e6:70:5a:
                    d9:75:cf:2a:d8:c9:00:05:e4:13:88:ec:c3:39:fb:
                    87:61:30:36:43:03:c8:9e:9c:a2:06:c2:2f:c5:fc:
                    f0:80:63:b1:54:04:a0:4c:a9:2e:c6:f5:76:7a:d8:
                    d0:e4:d4:94:11:e5:15:b5:78:06:dc:b8:80:8f:99:
                    a9:20:33:3d:10:85:4c:65:09:ca:3e:58:5e:60:93:
                    9a:aa:62:5d:c0:51:06:1c:5d:60:a0:0d:9c:4b:43:
                    f6:a7:16:21:a4:87:aa:f2:c1:2e:ee:92:30:b8:9e:
                    df:df:10:01:8b:86:09:70:d8:6c:a8:b7:50:1e:16:
                    96:b4:f7:67:fd:35:3a:21:90:2a:32:c7:00:7b:4d:
                    07:10:09:b9:2f:73:d8:18:7e:67:99:04:4f:06:fc:
                    50:c7:85:9b:9d:40:9d:b3:96:37:fa:a5:dc:b2:72:
                    4e:ef:4e:09:2c:fd:91:fd:4d:f7:bb:a6:a1:3e:ab:
                    7b:a2:03:40:a6:a9:55:27:e2:fa:f9:19:ce:87:75:
                    aa:f1:75:36:f3:f3:b8:91:f8:91:c3:8b:75:13:8e:
                    4c:65:9a:16:39:6a:e5:34:e8:7a:96:59:7f:35:b0:
                    00:fd:5b:69:fc:43:26:fa:f5:28:6e:fe:87:d9:7e:
                    24:fb:b4:a0:82:6e:54:a2:ff:ae:bf:62:b4:f4:72:
                    01:c2:cb:98:47:98:e1:4c:b5:17:80:80:ce:8f:a6:
                    28:ee:1e:45:6a:fb:df:f1:1d:fc:5a:3b:d6:ea:f4:
                    6c:1d:62:49:57:3b:8a:8f:86:ea:f0:53:04:ce:9c:
                    16:68:ff:ba:b9:fc:88:0f:47:f7:02:44:72:40:b8:
                    ca:3b:2d:53:9d:dc:3c:56:8c:59:7b:68:1a:2c:8d:
                    71:bb:6c:00:c7:1a:ce:6f:40:92:b1:a3:2f:0f:d9:
                    44:f2:a3:70:2e:9e:ee:0e:ae:32:d0:3b:3e:8b:07:
                    ea:e6:79:b3:5c:29:e2:7d:6b:a8:5e:f9:5a:31:e8:
                    08:96:a2:8c:03:98:46:f1:b8:7d:90:54:26:ed:76:
                    62:fe:9e:e9:9a:6e:5e:c9:49:c7:5c:34:53:29:54:
                    d9:ec:e4:46:e1:80:3b:75:d9:df:fb:79:d5:87:f1:
                    ba:9e:eb:19:ce:4c:52:73:e6:5b:87:ae:25:4f:39:
                    79:cc:c6:b8:f9:10:7b:ec:f0:9b:71:a4:05:a0:d3:
                    29:d3:4e:7f:1f:f4:2d:28:78:cc:55:95:7b:1e:91:
                    2f:cc:56:18:73:8b:b2:db:bc:69:07:e6:d0:d8:4f:
                    ed:a2:ff:58:85:a3:6d:e0:4a:53:b7:67:7d:8d:0c:
                    5c:5b:7b:77:28:02:35:44:7a:04:d3:28:43:c8:6b:
                    30:17:5d:32:b8:29:35:ba:76:da:3b:14:4a:76:18:
                    58:a4:f8:92:3c:9e:4d:33:6f:46:6b:08:d9:31:48:
                    68:dd:f4:fb:24:56:34:b2:cf:69:66:be:48:d2:8a:
                    66:22:cd:f2:69:cd:c2:53:13:45:29:41:22:d6:5d:
                    98:1f:b6:a4:b2:a3:c2:ee:02:2f:51:1b:dc:83:a4:
                    ec:70:25:a8:d4:08:61:32:6f:e4:a1:81:2e:7c:63:
                    72:fa:29:65:bc:70:44:cf:5d
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        55:9a:34:6a:22:06:69:09:45:33:c7:ae:a9:5c:c7:09:4e:9b:
        86:bc:41:90:d4:94:52:f6:cd:23:29:94:4b:22:cd:e8:bd:fe:
        9d:cd:52:f2:bd:ed:ab:87:c9:ab:ab:46:04:b4:bd:a2:3f:22:
        30:47:50:c0:4b:8c:76:0f:03:f5:92:d2:b1:2d:c4:7a:35:9c:
        c9:73:87:eb:a6:9f:de:0f:73:8d:d3:7f:99:d8:ba:8f:6f:c4:
        f3:be:1a:ae:8b:a2:94:36:90:e2:e5:eb:8d:05:f4:fc:65:df:
        95:f1:c4:94:4d:17:56:d7:9f:3c:8f:50:3c:e7:77:bf:95:86:
        26:64:fb:6a:ff:c6:da:e9:8c:ae:42:bb:69:e5:33:c6:d8:e9:
        0d:c6:55:21:49:c1:0c:b4:a3:f9:9b:4b:5c:de:83:4f:41:03:
        ce:2a:79:68:38:7d:f0:54:49:20:f5:b6:10:ff:08:dc:33:66:
        96:9b:ff:06:de:00:9e:d7:ce:56:43:9a:51:fc:70:cd:f6:f0:
        51:a3:b7:cd:b4:5c:85:62:cd:71:b7:c6:2b:23:2b:dd:c3:6e:
        40:42:fa:37:ff:37:1c:f6:7a:57:94:87:85:23:d7:d4:c9:c7:
        5f:c1:4d:2f:c9:0d:d7:5c:ec:9c:25:ee:9e:30:82:91:96:72:
        b8:75:1d:f8:09:68:57:97:b2:2d:4b:ee:25:ec:7a:24:29:ee:
        72:d4:9c:13:db:ab:dc:03:0a:d8:4a:14:c9:08:57:44:5d:a1:
        b5:53:80:34:f2:14:97:cf:52:de:a2:0e:8a:10:e9:14:ef:d0:
        60:be:61:a1:f1:25:5d:d5:18:73:3f:93:10:ca:96:ee:b3:40:
        d2:db:a3:55:cf:57:5a:a5:0e:4f:75:47:df:ea:f7:90:9a:6d:
        f5:70:2e:1d:14:1c:37:64:04:59:50:b0:dc:72:86:6f:9c:37:
        3d:5d:28:af:73:55:ef:d2:ee:24:74:74:13:ef:dc:db:31:49:
        fb:3f:63:f5:d3:08:3e:33:a5:e7:9d:0a:de:53:2c:51:8e:67:
        db:9b:41:65:41:50:bd:d4:a4:96:6c:87:bc:12:e0:94:c7:d3:
        c0:e4:cb:73:58:00:83:e1:ac:27:85:d6:9d:53:9d:5c:bd:0a:
        3e:03:43:9c:0c:91:f5:6d:7b:f8:40:72:75:ab:11:76:91:2b:
        e1:c6:aa:1f:70:69:76:70:15:09:fe:93:d0:d6:2d:b7:15:6a:
        9b:67:5c:b4:69:9f:25:a6:7d:8a:fb:7d:22:a9:71:f2:ce:4e:
        8c:b8:21:2d:de:fe:41:71:0d:ff:9d:ec:73:a6:bb:07:4f:88:
        0e:58:47:2e:7e:a9:c2:c7:78:dd:ba:7a:9e:4e:e0:30:4e:63:
        6f:85:d4:20:41:e9:fa:fe:43:45:e7:fb:af:7a:b2:ce:a4:05:
        1d:22:9a:58:86:df:e4:ce:4c:a9:fe:d8:16:a5:6f:fb:d8:ce:
        56:7b:f5:d6:20:ef:e4:47:cd:63:24:ff:b9:be:f1:48:a3:c1:
        01:72:e6:bd:c0:ad:ed:26:0d:ca:34:9f:fc:02:2d:20:4f:05:
        20:ae:21:3d:0c:c2:20:3c:3f:f0:04:84:dc:cf:89:fd:b9:25:
        91:8e:d0:43:e6:b3:20:ab:5c:2d:d5:40:9e:a0:4b:d8:f4:b2:
        cc:7d:f1:58:0a:8e:87:ed:88:ac:36:96:e4:56:a0:11:8a:f2:
        9a:d0:b3:57:a3:34:bb:19:ab:38:e1:74:6b:22:c4:31:ce:01:
        d5:1b:36:e3:1e:38:4c:33:93:df:40:e3:59:57:4e:ac:6e:7b:
        1e:5a:3d:c5:1d:5b:ac:c8:10:82:35:02:22:b2:fc:75:e8:10:
        91:8d:c4:7d:78:93:47:9e:1c:9d:ac:6b:62:02:58:8c:d6:1c:
        23:d6:af:78:c2:80:9c:a4:aa:24:54:14:b5:14:98:c6:f8:2b:
        1a:24:cb:71:32:0a:e2:9b:0e:69:6b:dd:7e:8c:64:d1:2e:63:
        ef:0e:7f:b1:3e:88:4c:9d:55:e5:c9:6e:17:04:b7:41:ff:bd:
        8a:41:cb:25:31:6f:44:77:3f:47:b1:fc:81:88:07:8e:05:49:
        20:b7:11:d9:69:03:2a:03:9d:b9:33:84:9a:df:df:7a:e3:46:
        73:a3:d8:a2:8c:53:19:88:55:4c:74:b8:f6:44:84:2b:d1:14:
        2d:4e:39:2e:92:68:ff:69:fc:85:62:1b:eb:55:4f:ef:25:84:
        62:45:99:d6:d8:4e:6f:3f:53:08:7d:1d:06:95:81:80:7f:4f:
        4e:74:36:98:b5:e2:87:70:98:dc:d7:f5:dc:52:15:e6:c6:d6:
        79:96:39:7f:8f:95:cf:ab:80:53:ad:1b:0b:45:40:0e:d4:18:
        bd:2c:de:8a:77:76:fd:f2:44:47:c6:21:d0:e4:74:f0:d8:18:
        05:c8:7c:30:72:c7:df:f1:bb:fc:02:30:a9:f4:42:26:59:0d:
        93:05:82:a1:73:ed:34:e5:38:5d:cd:50:90:fe:94:fc:13:bc:
        bd:fc:a8:a2:88:a7:73:c4:b2:a8:d1:5d:88:c4:02:a2:7a:f1:
        04:c9:fe:8c:74:c9:ef:1d:64:41:9f:ac:1e:96:67:64:ac:ab:
        28:41:c7:9d:f7:c0:98:1b:6e:07:c2:64:7d:5a:83:66:56:28:
        36:9c:e7:fb:1c:77:0e:28:a0:c4:f7:6b:79:39:04:20:84:c7:
        57:93:bc:1b:a0:ea:bc:eb:42:e5:a8:11:fe:fc:ac:65:cc:fd:
        f8:28:88:f4:a5:9a:e5:73:51:e0:a8:9b:0d:03:77:4e:e5:e0:
        98:b3:88:da:7d:e6:c6:9e:7c:14:66:c1:2e:53:4a:92:07:37:
        a0:7e:e9:3d:09:e4:15:7c:cf:fd:b8:41:a5:ef:9e:66:9d:c4:
        5e:07:1d:87:f8:41:ad:ea:e7:2f:d2:41:63:18:37:f9:14:e3:
        4d:d0:e5:f7:43:fd:15:e3:f9:36:73:06:26:df:01:4f:a9:c3:
        4e:de:20:46:77:98:b4:7a:24:2b:3b:75:2b:4e:58:8d:9b:5d:
        a4:c7:16:a0:bc:32:88:3f:a1:83:f3:00:c8:f8:d8:58:e9:63:
        5d:4c:2b:b5:f0:72:41:d8:ab:77:37:d6:72:74:ae:b6:36:9c:
        c8:a6:83:49:4b:e0:c9:56:0b:29:be:00:30:cb:dd:d6:c8:42:
        8a:00:d9:ec:15:d1:34:71:f2:5b:64:87:f6:27:d2:b7:eb:86:
        b0:90:bf:29:db:21:9e:36:8c:e3:20:2f:95:23:51:6c:1b:c2:
        a4:d5:e6:d8:02:43:67:a0:fe:9b:50:03:44:7f:bb:e4:72:d5:
        d1:e4:da:8f:92:14:64:fb:5d:14:10:12:4a:95:06:c9:65:08:
        29:ca:21:a3:26:38:11:c9:27:df:70:67:04:fd:ca:48:32:7f:
        63:b2:45:74:31:50:4f:87:d9:20:70:d2:21:70:b1:d6:10:9d:
        33:5d:78:83:91:6d:55:82:ec:da:e4:62:63:c7:81:46:d7:19:
        65:72:2a:43:19:90:b8:d7:23:4d:4c:1c:e0:44:a9:66:67:ac:
        ee:71:79:27:26:78:6d:72:0e:f5:5d:4b:23:b5:7c:7c:65:e9:
        17:c6:3a:0b:0d:dd:5e:1e:51:c3:86:b8:ec:7f:c7:27:4a:a5:
        46:e8:6a:2d:19:c1:87:a3:cb:99:93:87:64:a2:55:14:4c:b7:
        43:a5:93:d7:e7:d2:4e:79:40:ca:65:99:46:3d:3f:7a:80:7a:
        88:6a:cc:1e:e5:6b:33:46:f4:50:c0:d5:1f:09:b8:cd:8a:2e:
        a1:27:eb:5d:73:a7:e8:6b:0a:e5:57:82:2a:b0:fc:e2:54:52:
        56:f0:ab:a9:12:c6:23:96:07:24:9c:e0:bc:46:a5:b4:20:04:
        da:09:93:63:e5:d4:2e:c2:7e:c5:31:ed:b5:15:74:86:17:b9:
        b3:f3:26:8a:1d:02:6a:da:1a:3f:e8:ba:f1:04:6d:94:51:54:
        e2:5a:b4:59:83:1d:60:d0:2d:73:cc:07:b5:26:8c:f9:d7:c6:
        88:91:ef:80:cf:5d:0f:a1:60:cb:45:d4:42:22:d1:b1:70:1d:
        fd:d0:b7:30:90:3a:c6:48:6d:67:e5:32:da:8f:db:e3:a8:e3:
        1d:20:25:a2:1c:e1:4c:b9:a4:f6:c6:3f:5c:58:0d:bb:c6:b2:
        77:01:16:91:9f:17:06:0d:b7:40:3e:cc:8f:8e:9c:4b:e0:9d:
        7e:9b:1e:05:ab:88:22:fa:d3:28:1b:57:14:64:4a:3e:24:2c:
        38:4d:21:69:00:73:2e:d0:55:2d:74:f2:15:e8:94:43:3e:40:
        2a:c6:c6:b9:6a:5b:de:a2:cc:18:50:54:5d:4e:2a:85:6c:f6:
        92:8b:29:19:7e:e7:ea:4a:e0:22:2b:25:bc:f7:66:cf:77:9a:
        41:74:f2:3c:14:0d:74:69:f5:50:83:cd:cd:2f:21:db:22:46:
        8a:d0:f7:51:1a:95:57:f2:05:8b:1a:19:ed:3b:45:e8:36:c2:
        6e:7e:fb:57:22:00:1f:06:53:a9:ae:93:c6:8f:71:2a:31:45:
        92:e7:8e:6d:e6:99:22:c0:83:fc:ef:dc:57:66:77:4f:a2:36:
        31:fb:a1:13:8d:e5:ca:a3:95:7d:01:0c:64:70:3b:53:42:68:
        80:c7:bb:9d:a8:00:35:69:98:0c:a8:67:d8:43:e5:aa:cf:95:
        e0:51:95:a4:17:3f:42:9d:b8:04:ce:d3:79:79:c8:d3:8a:16:
        32:92:e0:d7:a2:ee:d7:37:4c:2f:ac:b8:7b:be:45:f6:f1:18:
        33:9c:7b:37:a6:24:d9:bc:40:ab:00:e9:c3:37:8b:ab:d8:b6:
        f3:5e:81:4e:b0:14:6b:07:3e:1f:ec:c2:f6:44:22:95:bb:b3:
        e6:6f:d6:f9:70:65:ba:0a:83:65:aa:0e:13:2f:83:13:23:53:
        8b:40:16:fa:ce:2f:fc:4d:04:f8:eb:d8:ac:c5:36:c2:15:57:
        48:38:ec:55:b3:b4:1e:ba:ad:d2:42:06:17:0d:73:c8:57:a6:
        be:96:4d:a9:f2:c0:fb:7a:21:1c:f5:c9:70:a9:82:90:b5:f1:
        0c:d4:79:10:be:81:a6:e9:5c:61:9c:77:79:9a:a4:c3:37:26:
        57:37:c9:52:2c:fa:08:ff:d0:5f:c6:61:c0:f4:76:be:fc:de:
        4e:cf:ab:51:99:71:c7:df:7e:f4:d6:cf:06:56:19:13:53:0b:
        6d:74:59:48:19:9b:53:05:2d:9d:32:54:d3:e5:2c:53:8b:64:
        3e:d4:64:7b:e3:80:09:14:cc:fe:16:46:63:6b:71:69:f8:f9:
        cb:27:f6:88:54:bc:45:b3:ce:02:c8:94:ee:40:5b:f9:42:02:
        c2:ff:b0:d8:2c:eb:28:7f:5e:c9:26:01:99:a7
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
...EOF...
cat >certs/traderengine.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CA, ST=ON, L=Toronto, O=TraderEngine Inc., OU=Certification Authority Division, CN=traderengine/emailAddress=ca@traderengine.com
        Validity
            Not Before: Jan  1 00:00:00 1998 GMT
            Not After : Jan 17 00:00:00 2038 GMT
        Subject: C=CA, ST=ON, L=Toronto, O=TraderEngine Inc., OU=Certification Authority Division, CN=traderengine/emailAddress=ca@traderengine.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:cf:25:f9:40:4f:b9:48:df:b3:80:d9:f5:bf:7c:
                    e9:f4:79:8f:e2:14:0e:59:6f:16:b8:45:48:b5:95:
                    4f:f5:bb:7f:c6:3e:4d:78:97:75:93:23:cb:fd:2a:
                    a7:17:6a:87:70:bd:e8:ff:be:2b:d0:66:b9:e5:a2:
                    87:9e:2c:0a:62:04:13:96:9e:44:2c:67:d0:e7:af:
                    10:41:e3:7d:c4:d2:07:b5:45:de:4a:d2:3d:cc:23:
                    59:c9:90:be:e1:8a:8e:6d:d3:11:fe:2b:ca:03:f5:
                    ac:2d:f5:15:32:5d:a5:57:92:73:24:9c:f5:04:e1:
                    34:80:a1:18:88:4c:b3:80:8a:b9:a0:bc:e4:3f:f9:
                    8e:5e:81:d1:bd:64:99:0f:60:f4:78:76:08:3b:ba:
                    2f:57:67:a9:54:52:bb:83:ba:7e:74:2e:10:a1:e2:
                    14:12:58:be:18:5f:cc:ca:0f:3c:75:5f:ea:9a:2f:
                    92:c9:b7:24:d9:12:cf:5d:af:0d:87:6e:ff:11:35:
                    50:ee:41:35:11:a7:e6:c7:b1:32:0a:a2:21:1b:ee:
                    65:c0:90:32:dc:7c:07:50:1c:00:62:ec:e3:8a:e6:
                    73:e6:50:fc:69:09:ab:f1:22:ae:bf:2d:de:38:7f:
                    52:54:de:70:87:76:01:96:b3:46:c1:34:ad:90:44:
                    95:2f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        16:38:f0:14:85:97:77:c7:d1:10:88:52:5c:bb:11:53:31:df:
        6a:6b:18:1c:ae:20:b3:26:c3:3a:0f:de:ac:60:69:28:f7:14:
        de:2e:15:ff:96:bd:5b:96:25:58:23:90:25:ba:9a:0b:5c:07:
        4c:cc:61:c9:90:e8:1a:4e:2a:ca:8d:05:eb:17:d9:f2:98:37:
        54:58:a7:b7:4e:6c:06:a1:be:74:d7:a9:d0:94:7e:ea:44:ab:
        c6:3b:78:64:6b:4a:ce:19:12:b6:53:fd:89:4f:fe:10:a7:c8:
        87:fc:31:62:e9:cc:8c:b8:fd:2a:f2:7e:b8:48:09:31:65:72:
        f3:52:e1:50:5e:a7:fb:53:f4:8d:8f:36:fd:5c:94:04:20:07:
        63:a7:b7:98:77:74:1b:e2:30:ec:0d:c5:f4:16:b2:8c:17:56:
        95:af:47:42:0e:74:bb:6a:6e:d6:4d:73:d8:08:31:9d:4a:43:
        e0:10:71:2d:2d:82:18:1f:79:59:a7:9b:0a:75:56:7d:c2:5e:
        05:d1:63:45:91:15:91:52:be:c0:5c:f8:f0:e7:4b:8b:99:43:
        66:28:27:7c:25:92:cc:18:0d:53:44:d4:93:8b:b5:3d:11:ca:
        d6:b7:43:a4:31:69:bb:e1:3d:96:56:70:20:36:c0:ef:d9:6a:
        d6:b0:67:e3
-----BEGIN CERTIFICATE-----
MIID6TCCAtGgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBrjELMAkGA1UEBhMCQ0Ex
CzAJBgNVBAgTAk9OMRAwDgYDVQQHEwdUb3JvbnRvMRowGAYDVQQKExFUcmFkZXJF
bmdpbmUgSW5jLjEpMCcGA1UECxMgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgRGl2
aXNpb24xFTATBgNVBAMTDHRyYWRlcmVuZ2luZTEiMCAGCSqGSIb3DQEJARYTY2FA
dHJhZGVyZW5naW5lLmNvbTAeFw05ODAxMDEwMDAwMDBaFw0zODAxMTcwMDAwMDBa
MIGuMQswCQYDVQQGEwJDQTELMAkGA1UECBMCT04xEDAOBgNVBAcTB1Rvcm9udG8x
GjAYBgNVBAoTEVRyYWRlckVuZ2luZSBJbmMuMSkwJwYDVQQLEyBDZXJ0aWZpY2F0
aW9uIEF1dGhvcml0eSBEaXZpc2lvbjEVMBMGA1UEAxMMdHJhZGVyZW5naW5lMSIw
IAYJKoZIhvcNAQkBFhNjYUB0cmFkZXJlbmdpbmUuY29tMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEAzyX5QE+5SN+zgNn1v3zp9HmP4hQOWW8WuEVItZVP
9bt/xj5NeJd1kyPL/SqnF2qHcL3o/74r0Ga55aKHniwKYgQTlp5ELGfQ568QQeN9
xNIHtUXeStI9zCNZyZC+4YqObdMR/ivKA/WsLfUVMl2lV5JzJJz1BOE0gKEYiEyz
gIq5oLzkP/mOXoHRvWSZD2D0eHYIO7ovV2epVFK7g7p+dC4QoeIUEli+GF/Myg88
dV/qmi+Sybck2RLPXa8Nh27/ETVQ7kE1Eafmx7EyCqIhG+5lwJAy3HwHUBwAYuzj
iuZz5lD8aQmr8SKuvy3eOH9SVN5wh3YBlrNGwTStkESVLwIDAQABoxAwDjAMBgNV
HRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQAWOPAUhZd3x9EQiFJcuxFTMd9q
axgcriCzJsM6D96sYGko9xTeLhX/lr1bliVYI5AlupoLXAdMzGHJkOgaTirKjQXr
F9nymDdUWKe3TmwGob5016nQlH7qRKvGO3hka0rOGRK2U/2JT/4Qp8iH/DFi6cyM
uP0q8n64SAkxZXLzUuFQXqf7U/SNjzb9XJQEIAdjp7eYd3Qb4jDsDcX0FrKMF1aV
r0dCDnS7am7WTXPYCDGdSkPgEHEtLYIYH3lZp5sKdVZ9wl4F0WNFkRWRUr7AXPjw
50uLmUNmKCd8JZLMGA1TRNSTi7U9EcrWt0OkMWm74T2WVnAgNsDv2WrWsGfj
-----END CERTIFICATE-----
...EOF...
cat >certs/usps-production-ca-1.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 10117 (0x2785)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=United States Postal Service, OU=www.usps.com/CPS, CN=USPS Root CA
        Validity
            Not Before: Apr 13 16:56:54 2001 GMT
            Not After : Aug 14 17:00:40 2020 GMT
        Subject: C=US, O=United States Postal Service, OU=www.usps.com/CPS, CN=USPS Production CA 1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c6:d6:b9:ef:b2:53:38:ca:d2:77:0c:6c:36:28:
                    30:c2:d0:28:02:78:71:4e:0d:89:42:c7:59:27:b3:
                    90:08:27:d4:97:5a:1e:b6:78:44:40:6b:74:c6:8d:
                    ab:51:8b:e8:a6:ed:51:a6:d6:75:17:ec:7a:54:5e:
                    56:83:e7:f0:6d:c4:49:f4:17:bd:06:0b:12:c6:55:
                    ef:e9:a8:e1:28:2f:a0:43:8f:75:f4:ff:d9:dc:7d:
                    fe:aa:d4:78:f3:9c:93:c5:99:da:62:46:9b:f5:76:
                    24:54:09:0a:29:eb:14:45:42:0b:ff:0d:76:03:1f:
                    a7:65:88:a2:a4:7f:6f:d0:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Certificate Policies: 
            Policy: 2.16.840.1.113901.102.1
              CPS: http://www.usps.com/CPS
              User Notice:
                Explicit Text: See USPS CPS at http://www.usps.com/CPS. This certificate is to be used only in accordance with USPS regulations and policies.
            Policy: 2.16.840.1.113901.102.2
              CPS: http://www.usps.com/CPS
              User Notice:
                Explicit Text: See USPS CPS at http://www.usps.com/CPS. This certificate is to be used only in accordance with USPS regulations and policies.
            Policy: 2.16.840.1.113901.102.3
              CPS: http://www.usps.com/CPS
              User Notice:
                Explicit Text: See USPS CPS at http://www.usps.com/CPS. This certificate is to be used only in accordance with USPS regulations and policies.
            Policy: 2.16.840.1.113901.102.4
              CPS: http://www.usps.com/CPS
              User Notice:
                Explicit Text: See USPS CPS at http://www.usps.com/CPS. This certificate is to be used only in accordance with USPS regulations and policies.
            Policy: 2.16.840.1.113901.102.5
              CPS: http://www.usps.com/CPS
              User Notice:
                Explicit Text: See USPS CPS at http://www.usps.com/CPS. This certificate is to be used only in accordance with USPS regulations and policies.
            Policy: 2.16.840.1.113901.102.6
              CPS: http://www.usps.com/CPS
              User Notice:
                Explicit Text: See USPS CPS at http://www.usps.com/CPS. This certificate is to be used only in accordance with USPS regulations and policies.
            Policy: 2.16.840.1.113901.102.7
              CPS: http://www.usps.com/CPS
              User Notice:
                Explicit Text: See USPS CPS at http://www.usps.com/CPS. This certificate is to be used only in accordance with USPS regulations and policies.

            X509v3 Subject Key Identifier: 
            25:E5:A0:EF:2D:72:4F:6D:95:1F:37:1F:20:D6:C3:01:44:03:C7:D0
            X509v3 Authority Key Identifier: 
            keyid:D3:CE:82:74:F3:2F:4B:89:60:72:A4:5E:11:BF:5F:75:03:A2:02:AB

            X509v3 Issuer Alternative Name: 
            email:root10001@usps.com
            X509v3 Subject Alternative Name: 
            email:caadmin@email.usps.com
            X509v3 Key Usage: critical
            Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        60:bf:49:6d:32:ca:84:db:f0:96:40:c8:ac:58:e9:49:e9:9b:
        1c:72:5e:c5:06:a3:3d:34:c3:1c:ae:0d:d5:74:19:de:98:d7:
        7d:01:3d:e5:48:98:40:7f:bd:22:af:5c:7a:f6:eb:62:3e:ab:
        bc:bd:8f:62:58:cb:82:3a:d4:c4:40:e7:8b:b8:0f:10:50:0f:
        2c:38:23:39:94:e5:20:c7:d4:b8:f9:e1:51:42:44:94:6c:63:
        5e:e3:7e:5e:62:de:ef:3d:46:b4:3c:5b:a8:9b:0e:7a:9e:1d:
        56:ed:bc:05:b4:c5:f1:59:09:af:6f:49:85:59:db:3a:11:65:
        cd:e9
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
...EOF...
cat >certs/usps-root-ca.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 10116 (0x2784)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=United States Postal Service, OU=www.usps.com/CPS, CN=USPS Root CA
        Validity
            Not Before: Apr 13 16:38:50 2001 GMT
            Not After : Aug 14 19:00:00 2020 GMT
        Subject: C=US, O=United States Postal Service, OU=www.usps.com/CPS, CN=USPS Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b7:a9:25:ac:63:da:b0:92:cf:94:36:b0:04:ff:
                    16:6e:76:04:5b:f5:c6:3c:9f:c6:b9:42:26:55:fb:
                    93:71:85:11:65:c9:61:27:88:c4:5e:9b:fe:2a:78:
                    4a:52:6a:45:9f:a8:fb:91:b4:e3:26:5d:f5:43:14:
                    26:b9:de:3c:6d:2c:66:f5:53:7d:de:e4:56:57:b2:
                    a2:79:f5:e1:b4:da:6a:f7:24:e5:b3:28:fe:9e:77:
                    96:e2:0e:c7:05:03:cc:e9:51:f6:96:fc:11:c0:96:
                    2d:73:35:ff:58:73:5f:f2:48:35:e5:44:4b:d0:7e:
                    d5:00:1e:84:6d:d8:25:d8:d1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Certificate Policies: 
            Policy: 2.16.840.1.113901.102.1
            Policy: 2.16.840.1.113901.102.2
            Policy: 2.16.840.1.113901.102.3
            Policy: 2.16.840.1.113901.102.4
            Policy: 2.16.840.1.113901.102.5
            Policy: 2.16.840.1.113901.102.6
            Policy: 2.16.840.1.113901.102.7
            Policy: 2.5.29.32.0

            X509v3 Subject Key Identifier: 
            D3:CE:82:74:F3:2F:4B:89:60:72:A4:5E:11:BF:5F:75:03:A2:02:AB
            X509v3 Authority Key Identifier: 
            keyid:D3:CE:82:74:F3:2F:4B:89:60:72:A4:5E:11:BF:5F:75:03:A2:02:AB

            X509v3 Issuer Alternative Name: 
            email:root10001@usps.com
            X509v3 Subject Alternative Name: 
            email:caadmin@email.usps.com
            X509v3 Key Usage: critical
            Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
            CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        35:31:8a:99:de:2a:b8:bb:e4:6f:d8:e9:d0:8d:df:41:5e:48:
        27:8f:66:85:16:12:b3:47:13:eb:01:09:7e:3e:f8:55:35:35:
        85:0a:4f:b3:e8:82:a7:af:ad:97:5d:86:4e:d7:b7:ad:ac:8f:
        a0:a0:54:4b:a5:4f:f4:75:07:bb:2f:2e:19:1b:1e:8e:ed:6d:
        4b:d5:4d:83:c8:76:97:57:86:f6:24:42:05:f5:b2:ec:16:ef:
        bc:ec:bd:e6:90:6c:8f:92:b3:1b:19:67:26:3a:af:a5:c7:1e:
        f2:f4:75:4e:69:d9:bb:fb:0f:6c:5c:3a:c8:dd:ad:8e:0a:97:
        1d:8f
-----BEGIN CERTIFICATE-----
MIIDWjCCAsOgAwIBAgICJ4QwDQYJKoZIhvcNAQEFBQAwZjELMAkGA1UEBhMCVVMx
JTAjBgNVBAoTHFVuaXRlZCBTdGF0ZXMgUG9zdGFsIFNlcnZpY2UxGTAXBgNVBAsT
EHd3dy51c3BzLmNvbS9DUFMxFTATBgNVBAMTDFVTUFMgUm9vdCBDQTAeFw0wMTA0
MTMxNjM4NTBaFw0yMDA4MTQxOTAwMDBaMGYxCzAJBgNVBAYTAlVTMSUwIwYDVQQK
ExxVbml0ZWQgU3RhdGVzIFBvc3RhbCBTZXJ2aWNlMRkwFwYDVQQLExB3d3cudXNw
cy5jb20vQ1BTMRUwEwYDVQQDEwxVU1BTIFJvb3QgQ0EwgZ8wDQYJKoZIhvcNAQEB
BQADgY0AMIGJAoGBALepJaxj2rCSz5Q2sAT/Fm52BFv1xjyfxrlCJlX7k3GFEWXJ
YSeIxF6b/ip4SlJqRZ+o+5G04yZd9UMUJrnePG0sZvVTfd7kVleyonn14bTaavck
5bMo/p53luIOxwUDzOlR9pb8EcCWLXM1/1hzX/JINeVES9B+1QAehG3YJdjRAgMB
AAGjggEVMIIBETBsBgNVHSAEZTBjMAsGCWCGSAGG+W1mATALBglghkgBhvltZgIw
CwYJYIZIAYb5bWYDMAsGCWCGSAGG+W1mBDALBglghkgBhvltZgUwCwYJYIZIAYb5
bWYGMAsGCWCGSAGG+W1mBzAGBgRVHSAAMB0GA1UdDgQWBBTTzoJ08y9LiWBypF4R
v191A6ICqzAfBgNVHSMEGDAWgBTTzoJ08y9LiWBypF4Rv191A6ICqzAdBgNVHRIE
FjAUgRJyb290MTAwMDFAdXNwcy5jb20wIQYDVR0RBBowGIEWY2FhZG1pbkBlbWFp
bC51c3BzLmNvbTAOBgNVHQ8BAf8EBAMCAcYwDwYDVR0TAQH/BAUwAwEB/zANBgkq
hkiG9w0BAQUFAAOBgQA1MYqZ3iq4u+Rv2OnQjd9BXkgnj2aFFhKzRxPrAQl+PvhV
NTWFCk+z6IKnr62XXYZO17etrI+goFRLpU/0dQe7Ly4ZGx6O7W1L1U2DyHaXV4b2
JEIF9bLsFu+87L3mkGyPkrMbGWcmOq+lxx7y9HVOadm7+w9sXDrI3a2OCpcdjw==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-class-1-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            8b:5b:75:56:84:54:85:0b:00:cf:af:38:48:ce:b1:a4
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 1 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 1 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:dd:84:d4:b9:b4:f9:a7:d8:f3:04:78:9c:de:3d:
                    dc:6c:13:16:d9:7a:dd:24:51:66:c0:c7:26:59:0d:
                    ac:06:08:c2:94:d1:33:1f:f0:83:35:1f:6e:1b:c8:
                    de:aa:6e:15:4e:54:27:ef:c4:6d:1a:ec:0b:e3:0e:
                    f0:44:a5:57:c7:40:58:1e:a3:47:1f:71:ec:60:f6:
                    6d:94:c8:18:39:ed:fe:42:18:56:df:e4:4c:49:10:
                    78:4e:01:76:35:63:12:36:dd:66:bc:01:04:36:a3:
                    55:68:d5:a2:36:09:ac:ab:21:26:54:06:ad:3f:ca:
                    14:e0:ac:ca:ad:06:1d:95:e2:f8:9d:f1:e0:60:ff:
                    c2:7f:75:2b:4c:cc:da:fe:87:99:21:ea:ba:fe:3e:
                    54:d7:d2:59:78:db:3c:6e:cf:a0:13:00:1a:b8:27:
                    a1:e4:be:67:96:ca:a0:c5:b3:9c:dd:c9:75:9e:eb:
                    30:9a:5f:a3:cd:d9:ae:78:19:3f:23:e9:5c:db:29:
                    bd:ad:55:c8:1b:54:8c:63:f6:e8:a6:ea:c7:37:12:
                    5c:a3:29:1e:02:d9:db:1f:3b:b4:d7:0f:56:47:81:
                    15:04:4a:af:83:27:d1:c5:58:88:c1:dd:f6:aa:a7:
                    a3:18:da:68:aa:6d:11:51:e1:bf:65:6b:9f:96:76:
                    d1:3d
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        ab:66:8d:d7:b3:ba:c7:9a:b6:e6:55:d0:05:f1:9f:31:8d:5a:
        aa:d9:aa:46:26:0f:71:ed:a5:ad:53:56:62:01:47:2a:44:e9:
        fe:3f:74:0b:13:9b:b9:f4:4d:1b:b2:d1:5f:b2:b6:d2:88:5c:
        b3:9f:cd:cb:d4:a7:d9:60:95:84:3a:f8:c1:37:1d:61:ca:e7:
        b0:c5:e5:91:da:54:a6:ac:31:81:ae:97:de:cd:08:ac:b8:c0:
        97:80:7f:6e:72:a4:e7:69:13:95:65:1f:c4:93:3c:fd:79:8f:
        04:d4:3e:4f:ea:f7:9e:ce:cd:67:7c:4f:65:02:ff:91:85:54:
        73:c7:ff:36:f7:86:2d:ec:d0:5e:4f:ff:11:9f:72:06:d6:b8:
        1a:f1:4c:0d:26:65:e2:44:80:1e:c7:9f:e3:dd:e8:0a:da:ec:
        a5:20:80:69:68:a1:4f:7e:e1:6b:cf:07:41:fa:83:8e:bc:38:
        dd:b0:2e:11:b1:6b:b2:42:cc:9a:bc:f9:48:22:79:4a:19:0f:
        b2:1c:3e:20:74:d9:6a:c3:be:f2:28:78:13:56:79:4f:6d:50:
        ea:1b:b0:b5:57:b1:37:66:58:23:f3:dc:0f:df:0a:87:c4:ef:
        86:05:d5:38:14:60:99:a3:4b:de:06:96:71:2c:f2:db:b6:1f:
        a4:ef:3f:ee
-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCLW3VWhFSFCwDPrzhIzrGkMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN2E1Lm0+afY8wR4
nN493GwTFtl63SRRZsDHJlkNrAYIwpTRMx/wgzUfbhvI3qpuFU5UJ+/EbRrsC+MO
8ESlV8dAWB6jRx9x7GD2bZTIGDnt/kIYVt/kTEkQeE4BdjVjEjbdZrwBBDajVWjV
ojYJrKshJlQGrT/KFOCsyq0GHZXi+J3x4GD/wn91K0zM2v6HmSHquv4+VNfSWXjb
PG7PoBMAGrgnoeS+Z5bKoMWznN3JdZ7rMJpfo83ZrngZPyPpXNspva1VyBtUjGP2
6KbqxzcSXKMpHgLZ2x87tNcPVkeBFQRKr4Mn0cVYiMHd9qqnoxjaaKptEVHhv2Vr
n5Z20T0CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAq2aN17O6x5q25lXQBfGfMY1a
qtmqRiYPce2lrVNWYgFHKkTp/j90CxObufRNG7LRX7K20ohcs5/Ny9Sn2WCVhDr4
wTcdYcrnsMXlkdpUpqwxga6X3s0IrLjAl4B/bnKk52kTlWUfxJM8/XmPBNQ+T+r3
ns7NZ3xPZQL/kYVUc8f/NveGLezQXk//EZ9yBta4GvFMDSZl4kSAHsef493oCtrs
pSCAaWihT37ha88HQfqDjrw43bAuEbFrskLMmrz5SCJ5ShkPshw+IHTZasO+8ih4
E1Z5T21Q6huwtVexN2ZYI/PcD98Kh8TvhgXVOBRgmaNL3gaWcSzy27YfpO8/7g==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-class-2-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            61:70:cb:49:8c:5f:98:45:29:e7:b0:a6:d9:50:5b:7a
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 2 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 2 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:af:0a:0d:c2:d5:2c:db:67:b9:2d:e5:94:27:dd:
                    a5:be:e0:b0:4d:8f:b3:61:56:3c:d6:7c:c3:f4:cd:
                    3e:86:cb:a2:88:e2:e1:d8:a4:69:c5:b5:e2:bf:c1:
                    a6:47:50:5e:46:39:8b:d5:96:ba:b5:6f:14:bf:10:
                    ce:27:13:9e:05:47:9b:31:7a:13:d8:1f:d9:d3:02:
                    37:8b:ad:2c:47:f0:8e:81:06:a7:0d:30:0c:eb:f7:
                    3c:0f:20:1d:dc:72:46:ee:a5:02:c8:5b:c3:c9:56:
                    69:4c:c5:18:c1:91:7b:0b:d5:13:00:9b:bc:ef:c3:
                    48:3e:46:60:20:85:2a:d5:90:b6:cd:8b:a0:cc:32:
                    dd:b7:fd:40:55:b2:50:1c:56:ae:cc:8d:77:4d:c7:
                    20:4d:a7:31:76:ef:68:92:8a:90:1e:08:81:56:b2:
                    ad:69:a3:52:d0:cb:1c:c4:23:3d:1f:99:fe:4c:e8:
                    16:63:8e:c6:08:8e:f6:31:f6:d2:fa:e5:76:dd:b5:
                    1c:92:a3:49:cd:cd:01:cd:68:cd:a9:69:ba:a3:eb:
                    1d:0d:9c:a4:20:a6:c1:a0:c5:d1:46:4c:17:6d:d2:
                    ac:66:3f:96:8c:e0:84:d4:36:ff:22:59:c5:f9:11:
                    60:a8:5f:04:7d:f2:1a:f6:25:42:61:0f:c4:4a:b8:
                    3e:89
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        34:26:15:3c:c0:8d:4d:43:49:1d:bd:e9:21:92:d7:66:9c:b7:
        de:c5:b8:d0:e4:5d:5f:76:22:c0:26:f9:84:3a:3a:f9:8c:b5:
        fb:ec:60:f1:e8:ce:04:b0:c8:dd:a7:03:8f:30:f3:98:df:a4:
        e6:a4:31:df:d3:1c:0b:46:dc:72:20:3f:ae:ee:05:3c:a4:33:
        3f:0b:39:ac:70:78:73:4b:99:2b:df:30:c2:54:b0:a8:3b:55:
        a1:fe:16:28:cd:42:bd:74:6e:80:db:27:44:a7:ce:44:5d:d4:
        1b:90:98:0d:1e:42:94:b1:00:2c:04:d0:74:a3:02:05:22:63:
        63:cd:83:b5:fb:c1:6d:62:6b:69:75:fd:5d:70:41:b9:f5:bf:
        7c:df:be:c1:32:73:22:21:8b:58:81:7b:15:91:7a:ba:e3:64:
        48:b0:7f:fb:36:25:da:95:d0:f1:24:14:17:dd:18:80:6b:46:
        23:39:54:f5:8e:62:09:04:1d:94:90:a6:9b:e6:25:e2:42:45:
        aa:b8:90:ad:be:08:8f:a9:0b:42:18:94:cf:72:39:e1:b1:43:
        e0:28:cf:b7:e7:5a:6c:13:6b:49:b3:ff:e3:18:7c:89:8b:33:
        5d:ac:33:d7:a7:f9:da:3a:55:c9:58:10:f9:aa:ef:5a:b6:cf:
        4b:4b:df:2a
-----BEGIN CERTIFICATE-----
MIIEGTCCAwECEGFwy0mMX5hFKeewptlQW3owDQYJKoZIhvcNAQEFBQAwgcoxCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVy
aVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDE5OTkgVmVyaVNpZ24s
IEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVyaVNp
Z24gQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0
eSAtIEczMB4XDTk5MTAwMTAwMDAwMFoXDTM2MDcxNjIzNTk1OVowgcoxCzAJBgNV
BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
Z24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDE5OTkgVmVyaVNpZ24sIElu
Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVyaVNpZ24g
Q2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAt
IEczMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArwoNwtUs22e5LeWU
J92lvuCwTY+zYVY81nzD9M0+hsuiiOLh2KRpxbXiv8GmR1BeRjmL1Za6tW8UvxDO
JxOeBUebMXoT2B/Z0wI3i60sR/COgQanDTAM6/c8DyAd3HJG7qUCyFvDyVZpTMUY
wZF7C9UTAJu878NIPkZgIIUq1ZC2zYugzDLdt/1AVbJQHFauzI13TccgTacxdu9o
koqQHgiBVrKtaaNS0MscxCM9H5n+TOgWY47GCI72MfbS+uV23bUckqNJzc0BzWjN
qWm6o+sdDZykIKbBoMXRRkwXbdKsZj+WjOCE1Db/IlnF+RFgqF8EffIa9iVCYQ/E
Srg+iQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQA0JhU8wI1NQ0kdvekhktdmnLfe
xbjQ5F1fdiLAJvmEOjr5jLX77GDx6M4EsMjdpwOPMPOY36TmpDHf0xwLRtxyID+u
7gU8pDM/CzmscHhzS5kr3zDCVLCoO1Wh/hYozUK9dG6A2ydEp85EXdQbkJgNHkKU
sQAsBNB0owIFImNjzYO1+8FtYmtpdf1dcEG59b98377BMnMiIYtYgXsVkXq642RI
sH/7NiXaldDxJBQX3RiAa0YjOVT1jmIJBB2UkKab5iXiQkWquJCtvgiPqQtCGJTP
cjnhsUPgKM+351psE2tJs//jGHyJizNdrDPXp/naOlXJWBD5qu9ats9LS98q
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-class-3-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            9b:7e:06:49:a3:3e:62:b9:d5:ee:90:48:71:29:ef:57
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:cb:ba:9c:52:fc:78:1f:1a:1e:6f:1b:37:73:bd:
                    f8:c9:6b:94:12:30:4f:f0:36:47:f5:d0:91:0a:f5:
                    17:c8:a5:61:c1:16:40:4d:fb:8a:61:90:e5:76:20:
                    c1:11:06:7d:ab:2c:6e:a6:f5:11:41:8e:fa:2d:ad:
                    2a:61:59:a4:67:26:4c:d0:e8:bc:52:5b:70:20:04:
                    58:d1:7a:c9:a4:69:bc:83:17:64:ad:05:8b:bc:d0:
                    58:ce:8d:8c:f5:eb:f0:42:49:0b:9d:97:27:67:32:
                    6e:e1:ae:93:15:1c:70:bc:20:4d:2f:18:de:92:88:
                    e8:6c:85:57:11:1a:e9:7e:e3:26:11:54:a2:45:96:
                    55:83:ca:30:89:e8:dc:d8:a3:ed:2a:80:3f:7f:79:
                    65:57:3e:15:20:66:08:2f:95:93:bf:aa:47:2f:a8:
                    46:97:f0:12:e2:fe:c2:0a:2b:51:e6:76:e6:b7:46:
                    b7:e2:0d:a6:cc:a8:c3:4c:59:55:89:e6:e8:53:5c:
                    1c:ea:9d:f0:62:16:0b:a7:c9:5f:0c:f0:de:c2:76:
                    ce:af:f7:6a:f2:fa:41:a6:a2:33:14:c9:e5:7a:63:
                    d3:9e:62:37:d5:85:65:9e:0e:e6:53:24:74:1b:5e:
                    1d:12:53:5b:c7:2c:e7:83:49:3b:15:ae:8a:68:b9:
                    57:97
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        11:14:96:c1:ab:92:08:f7:3f:2f:c9:b2:fe:e4:5a:9f:64:de:
        db:21:4f:86:99:34:76:36:57:dd:d0:15:2f:c5:ad:7f:15:1f:
        37:62:73:3e:d4:e7:5f:ce:17:03:db:35:fa:2b:db:ae:60:09:
        5f:1e:5f:8f:6e:bb:0b:3d:ea:5a:13:1e:0c:60:6f:b5:c0:b5:
        23:22:2e:07:0b:cb:a9:74:cb:47:bb:1d:c1:d7:a5:6b:cc:2f:
        d2:42:fd:49:dd:a7:89:cf:53:ba:da:00:5a:28:bf:82:df:f8:
        ba:13:1d:50:86:82:fd:8e:30:8f:29:46:b0:1e:3d:35:da:38:
        62:16:18:4a:ad:e6:b6:51:6c:de:af:62:eb:01:d0:1e:24:fe:
        7a:8f:12:1a:12:68:b8:fb:66:99:14:14:45:5c:ae:e7:ae:69:
        17:81:2b:5a:37:c9:5e:2a:f4:c6:e2:a1:5c:54:9b:a6:54:00:
        cf:f0:f1:c1:c7:98:30:1a:3b:36:16:db:a3:6e:ea:fd:ad:b2:
        c2:da:ef:02:47:13:8a:c0:f1:b3:31:ad:4f:1c:e1:4f:9c:af:
        0f:0c:9d:f7:78:0d:d8:f4:35:56:80:da:b7:6d:17:8f:9d:1e:
        81:64:e1:fe:c5:45:ba:ad:6b:b9:0a:7a:4e:4f:4b:84:ee:4b:
        f1:7d:dd:11
-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCbfgZJoz5iudXukEhxKe9XMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMu6nFL8eB8aHm8b
N3O9+MlrlBIwT/A2R/XQkQr1F8ilYcEWQE37imGQ5XYgwREGfassbqb1EUGO+i2t
KmFZpGcmTNDovFJbcCAEWNF6yaRpvIMXZK0Fi7zQWM6NjPXr8EJJC52XJ2cybuGu
kxUccLwgTS8Y3pKI6GyFVxEa6X7jJhFUokWWVYPKMIno3Nij7SqAP395ZVc+FSBm
CC+Vk7+qRy+oRpfwEuL+wgorUeZ25rdGt+INpsyow0xZVYnm6FNcHOqd8GIWC6fJ
Xwzw3sJ2zq/3avL6QaaiMxTJ5Xpj055iN9WFZZ4O5lMkdBteHRJTW8cs54NJOxWu
imi5V5cCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAERSWwauSCPc/L8my/uRan2Te
2yFPhpk0djZX3dAVL8WtfxUfN2JzPtTnX84XA9s1+ivbrmAJXx5fj267Cz3qWhMe
DGBvtcC1IyIuBwvLqXTLR7sdwdela8wv0kL9Sd2nic9TutoAWii/gt/4uhMdUIaC
/Y4wjylGsB49Ndo4YhYYSq3mtlFs3q9i6wHQHiT+eo8SGhJouPtmmRQURVyu565p
F4ErWjfJXir0xuKhXFSbplQAz/DxwceYMBo7Nhbbo27q/a2ywtrvAkcTisDxszGt
TxzhT5yvDwyd93gN2PQ1VoDat20Xj50egWTh/sVFuq1ruQp6Tk9LhO5L8X3dEQ==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-class-4-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            ec:a0:a7:8b:6e:75:6a:01:cf:c4:7c:cc:2f:94:5e:d7
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 4 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 4 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ad:cb:a5:11:69:c6:59:ab:f1:8f:b5:19:0f:56:
                    ce:cc:b5:1f:20:e4:9e:26:25:4b:e0:73:65:89:59:
                    de:d0:83:e4:f5:0f:b5:bb:ad:f1:7c:e8:21:fc:e4:
                    e8:0c:ee:7c:45:22:19:76:92:b4:13:b7:20:5b:09:
                    fa:61:ae:a8:f2:a5:8d:85:c2:2a:d6:de:66:36:d2:
                    9b:02:f4:a8:92:60:7c:9c:69:b4:8f:24:1e:d0:86:
                    52:f6:32:9c:41:58:1e:22:bd:cd:45:62:95:08:6e:
                    d0:66:dd:53:a2:cc:f0:10:dc:54:73:8b:04:a1:46:
                    33:33:5c:17:40:b9:9e:4d:d3:f3:be:55:83:e8:b1:
                    89:8e:5a:7c:9a:96:22:90:3b:88:25:f2:d2:53:88:
                    02:0c:0b:78:f2:e6:37:17:4b:30:46:07:e4:80:6d:
                    a6:d8:96:2e:e8:2c:f8:11:b3:38:0d:66:a6:9b:ea:
                    c9:23:5b:db:8e:e2:f3:13:8e:1a:59:2d:aa:02:f0:
                    ec:a4:87:66:dc:c1:3f:f5:d8:b9:f4:ec:82:c6:d2:
                    3d:95:1d:e5:c0:4f:84:c9:d9:a3:44:28:06:6a:d7:
                    45:ac:f0:6b:6a:ef:4e:5f:f8:11:82:1e:38:63:34:
                    66:50:d4:3e:93:73:fa:30:c3:66:ad:ff:93:2d:97:
                    ef:03
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        8f:fa:25:6b:4f:5b:e4:a4:4e:27:55:ab:22:15:59:3c:ca:b5:
        0a:d4:4a:db:ab:dd:a1:5f:53:c5:a0:57:39:c2:ce:47:2b:be:
        3a:c8:56:bf:c2:d9:27:10:3a:b1:05:3c:c0:77:31:bb:3a:d3:
        05:7b:6d:9a:1c:30:8c:80:cb:93:93:2a:83:ab:05:51:82:02:
        00:11:67:6b:f3:88:61:47:5f:03:93:d5:5b:0d:e0:f1:d4:a1:
        32:35:85:b2:3a:db:b0:82:ab:d1:cb:0a:bc:4f:8c:5b:c5:4b:
        00:3b:1f:2a:82:a6:7e:36:85:dc:7e:3c:67:00:b5:e4:3b:52:
        e0:a8:eb:5d:15:f9:c6:6d:f0:ad:1d:0e:85:b7:a9:9a:73:14:
        5a:5b:8f:41:28:c0:d5:e8:2d:4d:a4:5e:cd:aa:d9:ed:ce:dc:
        d8:d5:3c:42:1d:17:c1:12:5d:45:38:c3:38:f3:fc:85:2e:83:
        46:48:b2:d7:20:5f:92:36:8f:e7:79:0f:98:5e:99:e8:f0:d0:
        a4:bb:f5:53:bd:2a:ce:59:b0:af:6e:7f:6c:bb:d2:1e:00:b0:
        21:ed:f8:41:62:82:b9:d8:b2:c4:bb:46:50:f3:31:c5:8f:01:
        a8:74:eb:f5:78:27:da:e7:f7:66:43:f3:9e:83:3e:20:aa:c3:
        35:60:91:ce
-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQDsoKeLbnVqAc/EfMwvlF7XMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDQgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDQgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK3LpRFpxlmr8Y+1
GQ9Wzsy1HyDkniYlS+BzZYlZ3tCD5PUPtbut8XzoIfzk6AzufEUiGXaStBO3IFsJ
+mGuqPKljYXCKtbeZjbSmwL0qJJgfJxptI8kHtCGUvYynEFYHiK9zUVilQhu0Gbd
U6LM8BDcVHOLBKFGMzNcF0C5nk3T875Vg+ixiY5afJqWIpA7iCXy0lOIAgwLePLm
NxdLMEYH5IBtptiWLugs+BGzOA1mppvqySNb247i8xOOGlktqgLw7KSHZtzBP/XY
ufTsgsbSPZUd5cBPhMnZo0QoBmrXRazwa2rvTl/4EYIeOGM0ZlDUPpNz+jDDZq3/
ky2X7wMCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAj/ola09b5KROJ1WrIhVZPMq1
CtRK26vdoV9TxaBXOcLORyu+OshWv8LZJxA6sQU8wHcxuzrTBXttmhwwjIDLk5Mq
g6sFUYICABFna/OIYUdfA5PVWw3g8dShMjWFsjrbsIKr0csKvE+MW8VLADsfKoKm
fjaF3H48ZwC15DtS4KjrXRX5xm3wrR0OhbepmnMUWluPQSjA1egtTaRezarZ7c7c
2NU8Qh0XwRJdRTjDOPP8hS6DRkiy1yBfkjaP53kPmF6Z6PDQpLv1U70qzlmwr25/
bLvSHgCwIe34QWKCudiyxLtGUPMxxY8BqHTr9Xgn2uf3ZkPznoM+IKrDNWCRzg==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-class-1-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            cd:ba:7f:56:f0:df:e4:bc:54:fe:22:ac:b3:72:aa:55
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e5:19:bf:6d:a3:56:61:2d:99:48:71:f6:67:de:
                    b9:8d:eb:b7:9e:86:80:0a:91:0e:fa:38:25:af:46:
                    88:82:e5:73:a8:a0:9b:24:5d:0d:1f:cc:65:6e:0c:
                    b0:d0:56:84:18:87:9a:06:9b:10:a1:73:df:b4:58:
                    39:6b:6e:c1:f6:15:d5:a8:a8:3f:aa:12:06:8d:31:
                    ac:7f:b0:34:d7:8f:34:67:88:09:cd:14:11:e2:4e:
                    45:56:69:1f:78:02:80:da:dc:47:91:29:bb:36:c9:
                    63:5c:c5:e0:d7:2d:87:7b:a1:b7:32:b0:7b:30:ba:
                    2a:2f:31:aa:ee:a3:67:da:db
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        4c:3f:b8:8b:c6:68:df:ee:43:33:0e:5d:e9:a6:cb:07:84:4d:
        7a:33:ff:92:1b:f4:36:ad:d8:95:22:36:68:11:6c:7c:42:cc:
        f3:9c:2e:c4:07:3f:14:b0:0f:4f:ff:90:92:76:f9:e2:bc:4a:
        e9:8f:cd:a0:80:0a:f7:c5:29:f1:82:22:5d:b8:b1:dd:81:23:
        a3:7b:25:15:46:30:79:16:f8:ea:05:4b:94:7f:1d:c2:1c:c8:
        e3:b7:f4:10:40:3c:13:c3:5f:1f:53:e8:48:e4:86:b4:7b:a1:
        35:b0:7b:25:ba:b8:d3:8e:ab:3f:38:9d:00:34:00:98:f3:d1:
        71:94
-----BEGIN CERTIFICATE-----
MIICPTCCAaYCEQDNun9W8N/kvFT+IqyzcqpVMA0GCSqGSIb3DQEBAgUAMF8xCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xh
c3MgMSBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05
NjAxMjkwMDAwMDBaFw0yODA4MDEyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYD
VQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMSBQdWJsaWMgUHJp
bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOB
jQAwgYkCgYEA5Rm/baNWYS2ZSHH2Z965jeu3noaACpEO+jglr0aIguVzqKCbJF0N
H8xlbgyw0FaEGIeaBpsQoXPftFg5a27B9hXVqKg/qhIGjTGsf7A01480Z4gJzRQR
4k5FVmkfeAKA2txHkSm7NsljXMXg1y2He6G3MrB7MLoqLzGq7qNn2tsCAwEAATAN
BgkqhkiG9w0BAQIFAAOBgQBMP7iLxmjf7kMzDl3ppssHhE16M/+SG/Q2rdiVIjZo
EWx8QszznC7EBz8UsA9P/5CSdvnivErpj82ggAr3xSnxgiJduLHdgSOjeyUVRjB5
FvjqBUuUfx3CHMjjt/QQQDwTw18fU+hI5Ia0e6E1sHslurjTjqs/OJ0ANACY89Fx
lA==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-class-2-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            2d:1b:fc:4a:17:8d:a3:91:eb:e7:ff:f5:8b:45:be:0b
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b6:5a:8b:a3:0d:6a:23:83:80:6b:cf:39:87:f4:
                    21:13:33:06:4c:25:a2:ed:55:12:97:c5:a7:80:b9:
                    fa:83:c1:20:a0:fa:2f:15:0d:7c:a1:60:6b:7e:79:
                    2c:fa:06:0f:3a:ae:f6:1b:6f:b1:d2:ff:2f:28:52:
                    5f:83:7d:4b:c4:7a:b7:f8:66:1f:80:54:fc:b7:c2:
                    8e:59:4a:14:57:46:d1:9a:93:be:41:91:03:bb:15:
                    80:93:5c:eb:e7:cc:08:6c:3f:3e:b3:4a:fc:ff:4b:
                    6c:23:d5:50:82:26:44:19:8e:23:c3:71:ea:19:24:
                    47:04:9e:75:bf:c8:a6:00:1f
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        8a:1b:2b:fa:39:c1:74:d7:5e:d8:19:64:a2:58:4a:2d:37:e0:
        33:47:0f:ac:ed:f7:aa:db:1e:e4:8b:06:5c:60:27:ca:45:52:
        ce:16:ef:3f:06:64:e7:94:68:7c:60:33:15:11:69:af:9d:62:
        8d:a3:03:54:6b:a6:be:e5:ee:05:18:60:04:bf:42:80:fd:d0:
        a8:a8:1e:01:3b:f7:a3:5c:af:a3:dc:e6:26:80:23:3c:b8:44:
        74:f7:0a:ae:49:8b:61:78:cc:24:bf:88:8a:a7:0e:ea:73:19:
        41:fd:4d:03:f0:88:d1:e5:78:8d:a5:2a:4f:f6:97:0d:17:77:
        ca:d8
-----BEGIN CERTIFICATE-----
MIICPDCCAaUCEC0b/EoXjaOR6+f/9YtFvgswDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQC2WoujDWojg4BrzzmH9CETMwZMJaLtVRKXxaeAufqDwSCg+i8VDXyh
YGt+eSz6Bg86rvYbb7HS/y8oUl+DfUvEerf4Zh+AVPy3wo5ZShRXRtGak75BkQO7
FYCTXOvnzAhsPz6zSvz/S2wj1VCCJkQZjiPDceoZJEcEnnW/yKYAHwIDAQABMA0G
CSqGSIb3DQEBAgUAA4GBAIobK/o5wXTXXtgZZKJYSi034DNHD6zt96rbHuSLBlxg
J8pFUs4W7z8GZOeUaHxgMxURaa+dYo2jA1Rrpr7l7gUYYAS/QoD90KioHgE796Nc
r6Pc5iaAIzy4RHT3Cq5Ji2F4zCS/iIqnDupzGUH9TQPwiNHleI2lKk/2lw0Xd8rY
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-class-3-public-primary.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            70:ba:e4:1d:10:d9:29:34:b6:38:ca:7b:03:cc:ba:bf
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c9:5c:59:9e:f2:1b:8a:01:14:b4:10:df:04:40:
                    db:e3:57:af:6a:45:40:8f:84:0c:0b:d1:33:d9:d9:
                    11:cf:ee:02:58:1f:25:f7:2a:a8:44:05:aa:ec:03:
                    1f:78:7f:9e:93:b9:9a:00:aa:23:7d:d6:ac:85:a2:
                    63:45:c7:72:27:cc:f4:4c:c6:75:71:d2:39:ef:4f:
                    42:f0:75:df:0a:90:c6:8e:20:6f:98:0f:f8:ac:23:
                    5f:70:29:36:a4:c9:86:e7:b1:9a:20:cb:53:a5:85:
                    e7:3d:be:7d:9a:fe:24:45:33:dc:76:15:ed:0f:a2:
                    71:64:4c:65:2e:81:68:45:a7
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        bb:4c:12:2b:cf:2c:26:00:4f:14:13:dd:a6:fb:fc:0a:11:84:
        8c:f3:28:1c:67:92:2f:7c:b6:c5:fa:df:f0:e8:95:bc:1d:8f:
        6c:2c:a8:51:cc:73:d8:a4:c0:53:f0:4e:d6:26:c0:76:01:57:
        81:92:5e:21:f1:d1:b1:ff:e7:d0:21:58:cd:69:17:e3:44:1c:
        9c:19:44:39:89:5c:dc:9c:00:0f:56:8d:02:99:ed:a2:90:45:
        4c:e4:bb:10:a4:3d:f0:32:03:0e:f1:ce:f8:e8:c9:51:8c:e6:
        62:9f:e6:9f:c0:7d:b7:72:9c:c9:36:3a:6b:9f:4e:a8:ff:64:
        0d:64
-----BEGIN CERTIFICATE-----
MIICPDCCAaUCEHC65B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhE
BarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/is
I19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0G
CSqGSIb3DQEBAgUAA4GBALtMEivPLCYATxQT3ab7/AoRhIzzKBxnki98tsX63/Do
lbwdj2wsqFHMc9ikwFPwTtYmwHYBV4GSXiHx0bH/59AhWM1pF+NEHJwZRDmJXNyc
AA9WjQKZ7aKQRUzkuxCkPfAyAw7xzvjoyVGM5mKf5p/AfbdynMk2OmufTqj/ZA1k
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-verisign-trust-network-00.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            4c:c7:ea:aa:98:3e:71:d3:93:10:f8:3d:3a:89:91:92
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:aa:d0:ba:be:16:2d:b8:83:d4:ca:d2:0f:bc:76:
                    31:ca:94:d8:1d:93:8c:56:02:bc:d9:6f:1a:6f:52:
                    36:6e:75:56:0a:55:d3:df:43:87:21:11:65:8a:7e:
                    8f:bd:21:de:6b:32:3f:1b:84:34:95:05:9d:41:35:
                    eb:92:eb:96:dd:aa:59:3f:01:53:6d:99:4f:ed:e5:
                    e2:2a:5a:90:c1:b9:c4:a6:15:cf:c8:45:eb:a6:5d:
                    8e:9c:3e:f0:64:24:76:a5:cd:ab:1a:6f:b6:d8:7b:
                    51:61:6e:a6:7f:87:c8:e2:b7:e5:34:dc:41:88:ea:
                    09:40:be:73:92:3d:6b:e7:75
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        a9:4f:c3:0d:c7:67:be:2c:cb:d9:a8:cd:2d:75:e7:7e:15:9e:
        3b:72:eb:7e:eb:5c:2d:09:87:d6:6b:6d:60:7c:e5:ae:c5:90:
        23:0c:5c:4a:d0:af:b1:5d:f3:c7:b6:0a:db:e0:15:93:0d:dd:
        03:bc:c7:76:8a:b5:dd:4f:c3:9b:13:75:b8:01:c0:e6:c9:5b:
        6b:a5:b8:89:dc:ac:a4:dd:72:ed:4e:a1:f7:4f:bc:06:d3:ea:
        c8:64:74:7b:c2:95:41:9c:65:73:58:f1:90:9a:3c:6a:b1:98:
        c9:c4:87:bc:cf:45:6d:45:e2:6e:22:3f:fe:bc:0f:31:5c:e8:
        f2:d9
-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEEzH6qqYPnHTkxD4PTqJkZIwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgMSBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgMSBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQCq0Lq+Fi24g9TK0g+8djHKlNgdk4xWArzZbxpvUjZudVYK
VdPfQ4chEWWKfo+9Id5rMj8bhDSVBZ1BNeuS65bdqlk/AVNtmU/t5eIqWpDBucSm
Fc/IReumXY6cPvBkJHalzasab7bYe1FhbqZ/h8jit+U03EGI6glAvnOSPWvndQID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAKlPww3HZ74sy9mozS11534Vnjty637rXC0J
h9ZrbWB85a7FkCMMXErQr7Fd88e2CtvgFZMN3QO8x3aKtd1Pw5sTdbgBwObJW2ul
uIncrKTdcu1OofdPvAbT6shkdHvClUGcZXNY8ZCaPGqxmMnEh7zPRW1F4m4iP/68
DzFc6PLZ
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-verisign-trust-network-01.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            b9:2f:60:cc:88:9f:a1:7a:46:09:b8:5b:70:6c:8a:af
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:a7:88:01:21:74:2c:e7:1a:03:f0:98:e1:97:3c:
                    0f:21:08:f1:9c:db:97:e9:9a:fc:c2:04:06:13:be:
                    5f:52:c8:cc:1e:2c:12:56:2c:b8:01:69:2c:cc:99:
                    1f:ad:b0:96:ae:79:04:f2:13:39:c1:7b:98:ba:08:
                    2c:e8:c2:84:13:2c:aa:69:e9:09:f4:c7:a9:02:a4:
                    42:c2:23:4f:4a:d8:f0:0e:a2:fb:31:6c:c9:e6:6f:
                    99:27:07:f5:e6:f4:4c:78:9e:6d:eb:46:86:fa:b9:
                    86:c9:54:f2:b2:c4:af:d4:46:1c:5a:c9:15:30:ff:
                    0d:6c:f5:2d:0e:6d:ce:7f:77
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        72:2e:f9:7f:d1:f1:71:fb:c4:9e:f6:c5:5e:51:8a:40:98:b8:
        68:f8:9b:1c:83:d8:e2:9d:bd:ff:ed:a1:e6:66:ea:2f:09:f4:
        ca:d7:ea:a5:2b:95:f6:24:60:86:4d:44:2e:83:a5:c4:2d:a0:
        d3:ae:78:69:6f:72:da:6c:ae:08:f0:63:92:37:e6:bb:c4:30:
        17:ad:77:cc:49:35:aa:cf:d8:8f:d1:be:b7:18:96:47:73:6a:
        54:22:34:64:2d:b6:16:9b:59:5b:b4:51:59:3a:b3:0b:14:f4:
        12:df:67:a0:f4:ad:32:64:5e:b1:46:72:27:8c:12:7b:c5:44:
        b4:ae
-----BEGIN CERTIFICATE-----
MIIDAzCCAmwCEQC5L2DMiJ+hekYJuFtwbIqvMA0GCSqGSIb3DQEBBQUAMIHBMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xPDA6BgNVBAsTM0Ns
YXNzIDIgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBH
MjE6MDgGA1UECxMxKGMpIDE5OTggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9y
aXplZCB1c2Ugb25seTEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazAe
Fw05ODA1MTgwMDAwMDBaFw0yODA4MDEyMzU5NTlaMIHBMQswCQYDVQQGEwJVUzEX
MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xPDA6BgNVBAsTM0NsYXNzIDIgUHVibGlj
IFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjE6MDgGA1UECxMx
KGMpIDE5OTggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25s
eTEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazCBnzANBgkqhkiG9w0B
AQEFAAOBjQAwgYkCgYEAp4gBIXQs5xoD8JjhlzwPIQjxnNuX6Zr8wgQGE75fUsjM
HiwSViy4AWkszJkfrbCWrnkE8hM5wXuYuggs6MKEEyyqaekJ9MepAqRCwiNPStjw
DqL7MWzJ5m+ZJwf15vRMeJ5t60aG+rmGyVTyssSv1EYcWskVMP8NbPUtDm3Of3cC
AwEAATANBgkqhkiG9w0BAQUFAAOBgQByLvl/0fFx+8Se9sVeUYpAmLho+Jscg9ji
nb3/7aHmZuovCfTK1+qlK5X2JGCGTUQug6XELaDTrnhpb3LabK4I8GOSN+a7xDAX
rXfMSTWqz9iP0b63GJZHc2pUIjRkLbYWm1lbtFFZOrMLFPQS32eg9K0yZF6xRnIn
jBJ7xUS0rg==
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-verisign-trust-network-02.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            7d:d9:fe:07:cf:a8:1e:b7:10:79:67:fb:a7:89:34:c6
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:cc:5e:d1:11:5d:5c:69:d0:ab:d3:b9:6a:4c:99:
                    1f:59:98:30:8e:16:85:20:46:6d:47:3f:d4:85:20:
                    84:e1:6d:b3:f8:a4:ed:0c:f1:17:0f:3b:f9:a7:f9:
                    25:d7:c1:cf:84:63:f2:7c:63:cf:a2:47:f2:c6:5b:
                    33:8e:64:40:04:68:c1:80:b9:64:1c:45:77:c7:d8:
                    6e:f5:95:29:3c:50:e8:34:d7:78:1f:a8:ba:6d:43:
                    91:95:8f:45:57:5e:7e:c5:fb:ca:a4:04:eb:ea:97:
                    37:54:30:6f:bb:01:47:32:33:cd:dc:57:9b:64:69:
                    61:f8:9b:1d:1c:89:4f:5c:67
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        51:4d:cd:be:5c:cb:98:19:9c:15:b2:01:39:78:2e:4d:0f:67:
        70:70:99:c6:10:5a:94:a4:53:4d:54:6d:2b:af:0d:5d:40:8b:
        64:d3:d7:ee:de:56:61:92:5f:a6:c4:1d:10:61:36:d3:2c:27:
        3c:e8:29:09:b9:11:64:74:cc:b5:73:9f:1c:48:a9:bc:61:01:
        ee:e2:17:a6:0c:e3:40:08:3b:0e:e7:eb:44:73:2a:9a:f1:69:
        92:ef:71:14:c3:39:ac:71:a7:91:09:6f:e4:71:06:b3:ba:59:
        57:26:79:00:f6:f8:0d:a2:33:30:28:d4:aa:58:a0:9d:9d:69:
        91:fd
-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEH3Z/gfPqB63EHln+6eJNMYwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgMyBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQDMXtERXVxp0KvTuWpMmR9ZmDCOFoUgRm1HP9SFIIThbbP4
pO0M8RcPO/mn+SXXwc+EY/J8Y8+iR/LGWzOOZEAEaMGAuWQcRXfH2G71lSk8UOg0
13gfqLptQ5GVj0VXXn7F+8qkBOvqlzdUMG+7AUcyM83cV5tkaWH4mx0ciU9cZwID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAFFNzb5cy5gZnBWyATl4Lk0PZ3BwmcYQWpSk
U01UbSuvDV1Ai2TT1+7eVmGSX6bEHRBhNtMsJzzoKQm5EWR0zLVznxxIqbxhAe7i
F6YM40AIOw7n60RzKprxaZLvcRTDOaxxp5EJb+RxBrO6WVcmeQD2+A2iMzAo1KpY
oJ2daZH9
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-inc-verisign-trust-network-03.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            32:88:8e:9a:d2:f5:eb:13:47:f8:7f:c4:20:37:25:f8
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 4 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 4 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ba:f0:e4:cf:f9:c4:ae:85:54:b9:07:57:f9:8f:
                    c5:7f:68:11:f8:c4:17:b0:44:dc:e3:30:73:d5:2a:
                    62:2a:b8:d0:cc:1c:ed:28:5b:7e:bd:6a:dc:b3:91:
                    24:ca:41:62:3c:fc:02:01:bf:1c:16:31:94:05:97:
                    76:6e:a2:ad:bd:61:17:6c:4e:30:86:f0:51:37:2a:
                    50:c7:a8:62:81:dc:5b:4a:aa:c1:a0:b4:6e:eb:2f:
                    e5:57:c5:b1:2b:40:70:db:5a:4d:a1:8e:1f:bd:03:
                    1f:d8:03:d4:8f:4c:99:71:bc:e2:82:cc:58:e8:98:
                    3a:86:d3:86:38:f3:00:29:1f
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        85:8c:12:c1:a7:b9:50:15:7a:cb:3e:ac:b8:43:8a:dc:aa:dd:
        14:ba:89:81:7e:01:3c:23:71:21:88:2f:82:dc:63:fa:02:45:
        ac:45:59:d7:2a:58:44:5b:b7:9f:81:3b:92:68:3d:e2:37:24:
        f5:7b:6c:8f:76:35:96:09:a8:59:9d:b9:ce:23:ab:74:d6:83:
        fd:32:73:27:d8:69:3e:43:74:f6:ae:c5:89:9a:e7:53:7c:e9:
        7b:f6:4b:f3:c1:65:83:de:8d:8a:9c:3c:88:8d:39:59:fc:aa:
        3f:22:8d:a1:c1:66:50:81:72:4c:ed:22:64:4f:4f:ca:80:91:
        b6:29
-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEDKIjprS9esTR/h/xCA3JfgwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgNCBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgNCBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQC68OTP+cSuhVS5B1f5j8V/aBH4xBewRNzjMHPVKmIquNDM
HO0oW369atyzkSTKQWI8/AIBvxwWMZQFl3Zuoq29YRdsTjCG8FE3KlDHqGKB3FtK
qsGgtG7rL+VXxbErQHDbWk2hjh+9Ax/YA9SPTJlxvOKCzFjomDqG04Y48wApHwID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAIWMEsGnuVAVess+rLhDityq3RS6iYF+ATwj
cSGIL4LcY/oCRaxFWdcqWERbt5+BO5JoPeI3JPV7bI92NZYJqFmduc4jq3TWg/0y
cyfYaT5DdPauxYma51N86Xv2S/PBZYPejYqcPIiNOVn8qj8ijaHBZlCBckztImRP
T8qAkbYp
-----END CERTIFICATE-----
...EOF...
cat >certs/verisign-time-stamping-authority.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            53:61:b2:60:ae:db:71:8e:a7:94:b3:13:33:f4:07:09
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: Sep 26 00:00:00 2000 GMT
            Not After : Sep 25 23:59:59 2010 GMT
        Subject: O=VeriSign, Inc., OU=VeriSign Trust Network, OU=Terms of use at https://www.verisign.com/rpa (c)00, CN=VeriSign Time Stamping Authority CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d2:19:9d:67:c2:00:21:59:62:ce:b4:09:22:44:
                    69:8a:f8:25:5a:db:ed:0d:b7:36:7e:4e:e0:bb:94:
                    3e:90:25:87:c2:61:47:29:d9:bd:54:b8:63:cc:2c:
                    7d:69:b4:33:36:f4:37:07:9a:c1:dd:40:54:fc:e0:
                    78:9d:a0:93:b9:09:3d:23:51:7f:44:c2:14:74:db:
                    0a:be:cb:c9:30:34:40:98:3e:d0:d7:25:10:81:94:
                    bd:07:4f:9c:d6:54:27:df:2e:a8:bf:cb:90:8c:8d:
                    75:4b:bc:e2:e8:44:87:cd:e6:41:0a:25:6e:e8:f4:
                    24:02:c5:52:0f:6e:ec:98:75
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
            CA:TRUE, pathlen:0
            X509v3 Certificate Policies: 
            Policy: 2.16.840.1.113733.1.7.23.1.3
              CPS: https://www.verisign.com/rpa

            X509v3 CRL Distribution Points: 
            URI:http://crl.verisign.com/pca3.crl

            X509v3 Key Usage: 
            Certificate Sign, CRL Sign
            Authority Information Access: 
            OCSP - URI:http://ocsp.verisign.com/ocsp/status

    Signature Algorithm: sha1WithRSAEncryption
        82:70:68:95:df:b6:0d:c2:01:70:19:4a:d2:54:56:1e:ac:f2:
        45:4c:87:b8:f5:35:eb:78:4b:05:a9:c8:9d:3b:19:21:2e:70:
        34:4a:a2:f5:89:e0:15:75:45:e7:28:37:00:34:27:29:e8:37:
        4b:f2:ef:44:97:6b:17:51:1a:c3:56:9d:3c:1a:8a:f6:4a:46:
        46:37:8c:fa:cb:f5:64:5a:38:68:2e:1c:c3:ef:70:ce:b8:46:
        06:16:bf:f7:7e:e7:b5:a8:3e:45:ac:a9:25:75:22:7b:6f:3f:
        b0:9c:94:e7:c7:73:ab:ac:1f:ee:25:9b:c0:16:ed:b7:ca:5b:
        f0:14
-----BEGIN CERTIFICATE-----
MIIDzTCCAzagAwIBAgIQU2GyYK7bcY6nlLMTM/QHCTANBgkqhkiG9w0BAQUFADCB
wTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTwwOgYDVQQL
EzNDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5
IC0gRzIxOjA4BgNVBAsTMShjKSAxOTk4IFZlcmlTaWduLCBJbmMuIC0gRm9yIGF1
dGhvcml6ZWQgdXNlIG9ubHkxHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdv
cmswHhcNMDAwOTI2MDAwMDAwWhcNMTAwOTI1MjM1OTU5WjCBpTEXMBUGA1UEChMO
VmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2lnbi5j
b20vcnBhIChjKTAwMSwwKgYDVQQDEyNWZXJpU2lnbiBUaW1lIFN0YW1waW5nIEF1
dGhvcml0eSBDQTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0hmdZ8IAIVli
zrQJIkRpivglWtvtDbc2fk7gu5Q+kCWHwmFHKdm9VLhjzCx9abQzNvQ3B5rB3UBU
/OB4naCTuQk9I1F/RMIUdNsKvsvJMDRAmD7Q1yUQgZS9B0+c1lQn3y6ov8uQjI11
S7zi6ESHzeZBCiVu6PQkAsVSD27smHUCAwEAAaOB3zCB3DAPBgNVHRMECDAGAQH/
AgEAMEUGA1UdIAQ+MDwwOgYMYIZIAYb4RQEHFwEDMCowKAYIKwYBBQUHAgEWHGh0
dHBzOi8vd3d3LnZlcmlzaWduLmNvbS9ycGEwMQYDVR0fBCowKDAmoCSgIoYgaHR0
cDovL2NybC52ZXJpc2lnbi5jb20vcGNhMy5jcmwwCwYDVR0PBAQDAgEGMEIGCCsG
AQUFBwEBBDYwNDAyBggrBgEFBQcwAaYmFiRodHRwOi8vb2NzcC52ZXJpc2lnbi5j
b20vb2NzcC9zdGF0dXMwDQYJKoZIhvcNAQEFBQADgYEAgnBold+2DcIBcBlK0lRW
HqzyRUyHuPU163hLBanInTsZIS5wNEqi9YngFXVF5yg3ADQnKeg3S/LvRJdrF1Ea
w1adPBqK9kpGRjeM+sv1ZFo4aC4cw+9wzrhGBha/937ntag+RaypJXUie28/sJyU
58dzq6wf7iWbwBbtt8pb8BQ=
-----END CERTIFICATE-----
...EOF...
cat >certs/visa-visa-international-service.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 797 (0x31d)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VISA, OU=Visa International Service Association
        Validity
            Not Before: Aug 16 21:52:00 2000 GMT
            Not After : Aug 15 23:59:00 2020 GMT
        Subject: C=US, O=VISA, OU=Visa International Service Association
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c5:1d:4d:73:41:95:e1:20:b4:6c:6c:ce:67:ea:
                    75:06:ac:c4:04:c2:60:2f:08:92:cf:20:ed:6e:a9:
                    c9:71:26:56:a2:fd:da:bb:0c:f8:95:09:c9:f9:f2:
                    1d:cf:44:95:ed:31:4a:da:6d:e0:bd:fc:75:16:96:
                    c2:ef:0a:7a:0c:c7:b8:b4:90:46:2e:a9:17:0a:e0:
                    47:44:84:7c:1c:3d:20:46:06:43:43:85:72:eb:5d:
                    e1:03:bc:32:9a:cb:ee:09:c6:57:15:b3:2e:da:32:
                    60:a7:12:98:92:9b:d3:ca:23:42:b0:23:f7:50:69:
                    4e:8c:9b:68:a1:37:30:92:c9:21:2f:68:8a:a0:d6:
                    84:a9:58:4d:0c:eb:55:3d:ba:0a:46:48:fa:c2:be:
                    b9:07:c0:ec:bd:93:34:79:39:3d:b7:9a:34:a0:0c:
                    3d:a3:ff:9a:84:e6:fa:e0:3f:aa:54:84:01:33:4a:
                    85:c6:a8:14:5e:15:c1:d7:60:d5:f0:69:78:69:64:
                    78:d7:14:ee:13:d8:a3:f2:ff:75:61:38:6c:d4:26:
                    b2:d7:68:88:19:67:0e:eb:e1:bf:bc:8e:9a:ea:c8:
                    94:e9:b6:cc:f8:15:85:93:6d:66:77:2b:b1:17:0b:
                    88:26:6c:46:a2:df:ce:43:a5:6e:f7:fd:1b:47:6e:
                    58:f7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Subject Key Identifier: 
            CB:C3:C6:63:CA:DE:71:7F:DB:A7:D7:FF:42:74:F6:CB:CC:B6:50:32
    Signature Algorithm: sha1WithRSAEncryption
        b6:18:84:a4:be:e6:7f:cd:fb:46:91:14:7d:00:40:77:77:86:
        b9:8d:71:1d:9c:fe:f1:d8:e5:01:3f:d9:a2:60:1b:cd:ba:73:
        34:2c:ee:5e:04:92:c4:22:44:56:ec:ea:fb:f7:c9:01:16:fd:
        e8:28:ed:f8:de:fd:3c:3e:2e:98:8c:8d:e3:78:e2:cf:8e:8b:
        e0:af:c1:8d:60:14:82:82:56:b1:87:2e:f0:e9:12:15:1d:3e:
        69:0a:ad:8e:a6:58:f4:99:fc:11:46:ee:f7:c9:ed:c6:af:2c:
        b9:86:25:d2:97:fe:4f:9d:d8:32:e1:c2:66:51:73:86:0d:dd:
        75:e3:8a:fa:f4:8a:35:66:dd:88:67:ad:79:a8:fc:69:f5:db:
        fa:af:95:b4:9c:90:1f:5f:c1:16:c9:c8:08:80:1a:d7:03:f2:
        5e:71:a3:56:63:1e:45:36:7d:71:be:31:67:74:86:2f:d9:ec:
        88:c2:20:bd:99:4d:3d:55:05:d0:a2:5a:4c:55:22:98:d0:f1:
        75:f4:17:fa:d8:e3:fe:e2:14:e0:0f:65:fa:b2:d6:69:2c:33:
        50:c9:27:a0:ac:90:31:4b:14:e5:eb:63:64:e0:3d:e3:fc:12:
        4a:c5:96:82:2d:da:25:39:fe:d4:7f:2e:41:c7:62:48:d7:71:
        45:3b:78:92
-----BEGIN CERTIFICATE-----
MIIDWDCCAkCgAwIBAgICAx0wDQYJKoZIhvcNAQEFBQAwTTELMAkGA1UEBhMCVVMx
DTALBgNVBAoTBFZJU0ExLzAtBgNVBAsTJlZpc2EgSW50ZXJuYXRpb25hbCBTZXJ2
aWNlIEFzc29jaWF0aW9uMB4XDTAwMDgxNjIxNTIwMFoXDTIwMDgxNTIzNTkwMFow
TTELMAkGA1UEBhMCVVMxDTALBgNVBAoTBFZJU0ExLzAtBgNVBAsTJlZpc2EgSW50
ZXJuYXRpb25hbCBTZXJ2aWNlIEFzc29jaWF0aW9uMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEAxR1Nc0GV4SC0bGzOZ+p1BqzEBMJgLwiSzyDtbqnJcSZW
ov3auwz4lQnJ+fIdz0SV7TFK2m3gvfx1FpbC7wp6DMe4tJBGLqkXCuBHRIR8HD0g
RgZDQ4Vy613hA7wymsvuCcZXFbMu2jJgpxKYkpvTyiNCsCP3UGlOjJtooTcwkskh
L2iKoNaEqVhNDOtVPboKRkj6wr65B8DsvZM0eTk9t5o0oAw9o/+ahOb64D+qVIQB
M0qFxqgUXhXB12DV8Gl4aWR41xTuE9ij8v91YThs1Cay12iIGWcO6+G/vI6a6siU
6bbM+BWFk21mdyuxFwuIJmxGot/OQ6Vu9/0bR25Y9wIDAQABo0IwQDAOBgNVHQ8B
Af8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUy8PGY8recX/bp9f/
QnT2y8y2UDIwDQYJKoZIhvcNAQEFBQADggEBALYYhKS+5n/N+0aRFH0AQHd3hrmN
cR2c/vHY5QE/2aJgG826czQs7l4EksQiRFbs6vv3yQEW/ego7fje/Tw+LpiMjeN4
4s+Oi+CvwY1gFIKCVrGHLvDpEhUdPmkKrY6mWPSZ/BFG7vfJ7cavLLmGJdKX/k+d
2DLhwmZRc4YN3XXjivr0ijVm3YhnrXmo/Gn12/qvlbSckB9fwRbJyAiAGtcD8l5x
o1ZjHkU2fXG+MWd0hi/Z7IjCIL2ZTT1VBdCiWkxVIpjQ8XX0F/rY4/7iFOAPZfqy
1mksM1DJJ6CskDFLFOXrY2TgPeP8EkrFloIt2iU5/tR/LkHHYkjXcUU7eJI=
-----END CERTIFICATE-----
...EOF...
cat >certs/xcert-ez-by-dst.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            d0:1e:40:90:00:00:27:4b:00:00:00:01:00:00:00:04
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=Utah, L=Salt Lake City, O=Xcert EZ by DST, CN=Xcert EZ by DST/emailAddress=ca@digsigtrust.com
        Validity
            Not Before: Jul 14 16:14:18 1999 GMT
            Not After : Jul 11 16:14:18 2009 GMT
        Subject: C=US, ST=Utah, L=Salt Lake City, O=Xcert EZ by DST, CN=Xcert EZ by DST/emailAddress=ca@digsigtrust.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ad:54:18:de:b4:bf:f7:ad:e8:74:aa:ed:8b:7c:
                    8f:c2:d4:75:1a:d5:84:b9:b6:62:fc:89:ef:e4:97:
                    61:92:fb:1d:b8:e1:5a:47:34:9e:9e:06:22:fb:d3:
                    ea:38:cb:b8:8b:07:f7:1a:a0:17:77:07:5a:30:1c:
                    d4:29:38:20:d7:27:40:d8:50:93:43:bf:d2:18:a2:
                    29:76:05:72:aa:6b:b6:69:98:ab:79:1e:1c:65:f5:
                    6a:8b:fc:c5:16:aa:a2:72:da:60:ed:4e:6e:19:25:
                    7a:0a:1d:30:e3:50:9b:42:3c:44:eb:a1:b0:20:1e:
                    db:02:7e:fe:3d:1f:bf:d0:00:8a:db:40:76:a6:18:
                    a5:15:a7:57:b6:52:c2:01:17:98:77:8f:8a:81:c6:
                    1a:b4:6a:2a:e6:af:a9:d6:00:ac:cf:d8:15:49:7c:
                    db:1b:a1:fe:81:fa:87:f9:d3:90:c1:02:c0:f9:d0:
                    42:e9:91:68:25:5f:c6:bf:87:39:e9:95:00:60:28:
                    bf:83:2c:c0:e7:5e:b6:d7:36:16:e7:60:87:76:e8:
                    e7:27:b2:25:0d:8b:7a:e5:aa:1d:e5:59:cd:ce:0b:
                    0e:6f:c6:c8:9c:e3:10:d9:85:39:d3:b7:9b:fa:c6:
                    ba:7c:74:d2:5d:75:56:ab:74:a4:a2:51:bf:52:7c:
                    ee:71
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Authority Key Identifier: 
            keyid:08:20:6C:66:EB:81:0A:6C:5C:D5:B5:A6:3C:41:DD:1C:96:91:27:77

            X509v3 Subject Key Identifier: 
            08:20:6C:66:EB:81:0A:6C:5C:D5:B5:A6:3C:41:DD:1C:96:91:27:77
    Signature Algorithm: sha1WithRSAEncryption
        5a:87:58:8f:2d:ab:76:21:6b:54:0c:d9:f1:41:f6:4e:cd:2b:
        9e:e3:1f:9b:a3:2d:7f:d9:2b:7d:58:c8:67:a4:29:f5:e9:ec:
        d5:bd:96:3f:a3:73:f8:c4:5b:36:7c:d0:63:2c:34:39:9b:48:
        b8:3d:6f:f6:14:c5:9e:63:e6:a7:34:6e:d3:e8:33:b3:c7:3c:
        18:6e:23:ae:43:92:99:3f:98:c5:69:30:f1:36:3b:ad:b9:30:
        82:d6:b6:59:16:96:02:0b:29:12:61:b4:11:89:f7:0c:2f:94:
        90:85:98:28:9c:53:6c:7e:63:dd:73:f4:19:ff:4a:81:d1:b2:
        52:23:fd:3c:4a:34:ce:5a:1b:e0:50:8a:ed:4f:81:95:d8:60:
        e7:e4:c4:0d:bb:58:3e:58:f7:4e:68:6f:3e:67:c9:cb:7a:97:
        16:27:ec:42:61:14:76:bb:00:c5:eb:08:3d:15:7f:4b:b6:22:
        5d:87:3b:90:f4:f3:c0:fe:37:b3:e9:d9:62:0c:c0:c3:59:af:
        60:bd:1f:0d:db:a1:34:1f:30:c4:3d:8b:ad:b0:1d:04:93:ed:
        5f:d5:e4:bf:20:30:04:f4:48:e9:33:01:d1:2e:90:27:52:b3:
        9b:de:3a:1c:ab:a9:97:7f:9b:eb:c2:8d:c2:6d:ec:dc:13:d3:
        46:c5:79:7c
-----BEGIN CERTIFICATE-----
MIID+DCCAuCgAwIBAgIRANAeQJAAACdLAAAAAQAAAAQwDQYJKoZIhvcNAQEFBQAw
gYwxCzAJBgNVBAYTAlVTMQ0wCwYDVQQIEwRVdGFoMRcwFQYDVQQHEw5TYWx0IExh
a2UgQ2l0eTEYMBYGA1UEChMPWGNlcnQgRVogYnkgRFNUMRgwFgYDVQQDEw9YY2Vy
dCBFWiBieSBEU1QxITAfBgkqhkiG9w0BCQEWEmNhQGRpZ3NpZ3RydXN0LmNvbTAe
Fw05OTA3MTQxNjE0MThaFw0wOTA3MTExNjE0MThaMIGMMQswCQYDVQQGEwJVUzEN
MAsGA1UECBMEVXRhaDEXMBUGA1UEBxMOU2FsdCBMYWtlIENpdHkxGDAWBgNVBAoT
D1hjZXJ0IEVaIGJ5IERTVDEYMBYGA1UEAxMPWGNlcnQgRVogYnkgRFNUMSEwHwYJ
KoZIhvcNAQkBFhJjYUBkaWdzaWd0cnVzdC5jb20wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCtVBjetL/3reh0qu2LfI/C1HUa1YS5tmL8ie/kl2GS+x24
4VpHNJ6eBiL70+o4y7iLB/caoBd3B1owHNQpOCDXJ0DYUJNDv9IYoil2BXKqa7Zp
mKt5Hhxl9WqL/MUWqqJy2mDtTm4ZJXoKHTDjUJtCPETrobAgHtsCfv49H7/QAIrb
QHamGKUVp1e2UsIBF5h3j4qBxhq0airmr6nWAKzP2BVJfNsbof6B+of505DBAsD5
0ELpkWglX8a/hznplQBgKL+DLMDnXrbXNhbnYId26OcnsiUNi3rlqh3lWc3OCw5v
xsic4xDZhTnTt5v6xrp8dNJddVardKSiUb9SfO5xAgMBAAGjUzBRMA8GA1UdEwEB
/wQFMAMBAf8wHwYDVR0jBBgwFoAUCCBsZuuBCmxc1bWmPEHdHJaRJ3cwHQYDVR0O
BBYEFAggbGbrgQpsXNW1pjxB3RyWkSd3MA0GCSqGSIb3DQEBBQUAA4IBAQBah1iP
Lat2IWtUDNnxQfZOzSue4x+boy1/2St9WMhnpCn16ezVvZY/o3P4xFs2fNBjLDQ5
m0i4PW/2FMWeY+anNG7T6DOzxzwYbiOuQ5KZP5jFaTDxNjutuTCC1rZZFpYCCykS
YbQRifcML5SQhZgonFNsfmPdc/QZ/0qB0bJSI/08SjTOWhvgUIrtT4GV2GDn5MQN
u1g+WPdOaG8+Z8nLepcWJ+xCYRR2uwDF6wg9FX9LtiJdhzuQ9PPA/jez6dliDMDD
Wa9gvR8N26E0HzDEPYutsB0Ek+1f1eS/IDAE9EjpMwHRLpAnUrOb3jocq6mXf5vr
wo3CbezcE9NGxXl8
-----END CERTIFICATE-----
...EOF...
cat >certs/xcert-international-inc-xcert-root-00.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0a:01:01:01:00:00:02:7c:00:00:00:02:00:00:00:02
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Xcert International Inc., OU=Xcert Root CA
        Validity
            Not Before: Aug 18 18:18:17 2000 GMT
            Not After : Aug 15 19:03:17 2025 GMT
        Subject: O=Xcert International Inc., OU=Xcert Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a8:b4:61:8b:1d:1c:3e:90:7b:70:32:40:6d:8d:
                    16:ca:35:61:61:b5:e2:fb:15:c9:f4:21:5e:81:1b:
                    cf:22:9c:ac:ab:bb:60:d0:a0:33:de:11:53:1a:09:
                    0f:3b:1a:13:a9:d4:87:cc:58:f7:2d:52:a9:a2:c2:
                    a9:3a:ed:cf:34:9d:a1:02:ef:b8:f2:b8:2b:57:88:
                    10:93:b5:a9:35:63:bb:05:42:43:22:7f:bf:70:5e:
                    d3:28:a5:55:28:20:4b:93:49:8f:a7:bf:3d:40:28:
                    0d:11:af:72:26:09:05:34:09:c5:ab:01:93:57:a1:
                    ac:66:54:98:22:9c:23:eb:ba:0c:64:9c:b6:3d:fb:
                    e2:c6:96:c2:cf:0b:4f:ea:c8:30:fa:8a:2b:ca:1c:
                    11:96:1a:29:00:8c:eb:72:d4:51:45:a9:9d:77:20:
                    d5:12:bb:b5:f2:7f:06:38:82:4d:7d:92:1e:e8:d5:
                    fa:c8:29:47:69:1a:15:11:8c:af:a6:2c:c1:28:f4:
                    69:5b:69:9e:e4:3c:13:ee:c0:a1:60:ea:41:bf:c2:
                    62:4b:6d:a2:37:84:3a:3e:f3:b0:32:ae:8a:6b:6c:
                    13:f3:3a:21:0a:7b:96:58:33:29:5e:6e:a8:ca:69:
                    a2:be:8e:06:45:5d:f1:66:39:55:4a:1c:5a:24:b1:
                    4b:d1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:44:A8:49:38:75:31:6C:AB:28:E7:71:F2:D8:D4:C8:AF:41:0F:47:91

            X509v3 Subject Key Identifier: 
            44:A8:49:38:75:31:6C:AB:28:E7:71:F2:D8:D4:C8:AF:41:0F:47:91
    Signature Algorithm: sha1WithRSAEncryption
        3d:73:5e:a5:0a:bb:b5:11:c3:f1:67:d1:12:1a:a2:47:29:11:
        4c:4e:59:37:20:86:09:40:f2:45:f1:49:79:39:1a:3d:25:d7:
        2f:29:d0:08:05:15:14:fb:e4:44:6c:3f:7e:5e:b5:52:d8:91:
        58:3c:96:fb:d4:4a:ef:f1:2e:c1:56:1e:4c:69:0c:d9:60:1d:
        4a:47:27:b5:03:33:db:18:bb:db:53:9e:a1:7b:51:6a:90:d3:
        a5:15:c8:82:0b:c0:b7:37:32:75:85:54:5e:55:10:7c:91:3b:
        a9:2b:60:c6:31:76:ac:c4:30:49:03:c4:b6:56:40:a5:f0:63:
        af:69:4a:88:af:d7:ab:0b:ee:3a:db:bd:13:83:a8:3b:a2:e9:
        b9:45:f5:51:4d:94:f0:59:a9:db:a1:37:67:d2:14:9e:a7:7b:
        d7:19:aa:15:23:6b:69:75:d1:13:3e:58:f4:f3:01:e8:88:c4:
        94:56:c9:c0:fe:df:4f:47:55:1f:6b:81:4e:54:ed:13:5f:72:
        fc:26:86:04:36:8f:4f:12:4d:9c:50:e2:4e:5a:56:ac:b9:fd:
        2c:1f:58:7b:05:12:07:63:38:ef:19:e3:f4:3c:91:5a:a2:25:
        62:57:bc:c6:94:a0:77:9c:cf:34:62:e0:bf:fb:75:3c:e9:1b:
        26:1b:9c:64
-----BEGIN CERTIFICATE-----
MIIDYzCCAkugAwIBAgIQCgEBAQAAAnwAAAACAAAAAjANBgkqhkiG9w0BAQUFADA7
MSEwHwYDVQQKExhYY2VydCBJbnRlcm5hdGlvbmFsIEluYy4xFjAUBgNVBAsTDVhj
ZXJ0IFJvb3QgQ0EwHhcNMDAwODE4MTgxODE3WhcNMjUwODE1MTkwMzE3WjA7MSEw
HwYDVQQKExhYY2VydCBJbnRlcm5hdGlvbmFsIEluYy4xFjAUBgNVBAsTDVhjZXJ0
IFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCotGGLHRw+
kHtwMkBtjRbKNWFhteL7Fcn0IV6BG88inKyru2DQoDPeEVMaCQ87GhOp1IfMWPct
Uqmiwqk67c80naEC77jyuCtXiBCTtak1Y7sFQkMif79wXtMopVUoIEuTSY+nvz1A
KA0Rr3ImCQU0CcWrAZNXoaxmVJginCPrugxknLY9++LGlsLPC0/qyDD6iivKHBGW
GikAjOty1FFFqZ13INUSu7XyfwY4gk19kh7o1frIKUdpGhURjK+mLMEo9GlbaZ7k
PBPuwKFg6kG/wmJLbaI3hDo+87AyroprbBPzOiEKe5ZYMylebqjKaaK+jgZFXfFm
OVVKHFoksUvRAgMBAAGjYzBhMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQD
AgEGMB8GA1UdIwQYMBaAFESoSTh1MWyrKOdx8tjUyK9BD0eRMB0GA1UdDgQWBBRE
qEk4dTFsqyjncfLY1MivQQ9HkTANBgkqhkiG9w0BAQUFAAOCAQEAPXNepQq7tRHD
8WfREhqiRykRTE5ZNyCGCUDyRfFJeTkaPSXXLynQCAUVFPvkRGw/fl61UtiRWDyW
+9RK7/EuwVYeTGkM2WAdSkcntQMz2xi721OeoXtRapDTpRXIggvAtzcydYVUXlUQ
fJE7qStgxjF2rMQwSQPEtlZApfBjr2lKiK/XqwvuOtu9E4OoO6LpuUX1UU2U8Fmp
26E3Z9IUnqd71xmqFSNraXXREz5Y9PMB6IjElFbJwP7fT0dVH2uBTlTtE19y/CaG
BDaPTxJNnFDiTlpWrLn9LB9YewUSB2M47xnj9DyRWqIlYle8xpSgd5zPNGLgv/t1
POkbJhucZA==
-----END CERTIFICATE-----
...EOF...
cat >certs/xcert-international-inc-xcert-root-01.pem <<...EOF...
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0a:01:01:01:00:00:02:7c:00:00:00:03:00:00:00:02
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Xcert International Inc., OU=Xcert Root CA 1024
        Validity
            Not Before: Aug 18 18:31:32 2000 GMT
            Not After : Aug 15 19:00:56 2025 GMT
        Subject: O=Xcert International Inc., OU=Xcert Root CA 1024
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d6:be:37:89:11:a9:a2:f7:47:2c:2a:cf:6a:00:
                    26:65:28:44:a4:8a:e4:de:a0:43:55:99:44:6b:bc:
                    6e:b8:c7:ce:c6:63:b6:d3:e8:6f:c5:98:2b:24:91:
                    b8:9e:a2:ba:71:48:de:34:20:21:7a:d6:d2:c5:89:
                    32:a5:89:c6:dc:85:84:54:f2:9e:48:ed:cc:44:b6:
                    06:ff:8e:c4:ce:59:ad:9f:6c:e9:22:58:c1:3f:14:
                    0a:43:80:87:19:52:50:e3:28:07:c8:ac:18:e2:b1:
                    1a:aa:a3:e2:60:b7:76:51:07:29:39:5e:48:e9:66:
                    70:81:2e:38:9a:bd:19:7d:eb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
            CA:TRUE
            X509v3 Key Usage: critical
            Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
            keyid:84:79:C7:4F:07:59:B1:6B:C1:3A:35:BA:B8:F4:D5:99:27:C8:BA:0E

            X509v3 Subject Key Identifier: 
            84:79:C7:4F:07:59:B1:6B:C1:3A:35:BA:B8:F4:D5:99:27:C8:BA:0E
    Signature Algorithm: sha1WithRSAEncryption
        73:b0:e1:00:ed:ae:68:d2:60:03:46:eb:f9:1c:f1:a5:a6:7c:
        5c:32:7c:ec:02:61:d3:1c:1d:73:31:2c:ba:8e:bd:49:4d:c8:
        dd:d9:77:75:41:e7:92:21:9a:6c:29:db:a7:6c:70:86:a0:5c:
        c3:e4:f3:32:cc:01:84:59:d7:88:39:38:f3:a8:e2:e2:1a:b0:
        97:cd:2b:17:dc:64:04:0f:aa:6a:73:94:d6:eb:08:c6:80:69:
        4d:de:7a:d5:c5:37:f1:92:17:3c:6d:d3:8a:21:cc:64:10:aa:
        de:62:87:1f:8f:b8:f8:aa:75:4a:f4:08:2c:f5:dc:66:cf:c3:
        38:7e
-----BEGIN CERTIFICATE-----
MIICaDCCAdGgAwIBAgIQCgEBAQAAAnwAAAADAAAAAjANBgkqhkiG9w0BAQUFADBA
MSEwHwYDVQQKExhYY2VydCBJbnRlcm5hdGlvbmFsIEluYy4xGzAZBgNVBAsTElhj
ZXJ0IFJvb3QgQ0EgMTAyNDAeFw0wMDA4MTgxODMxMzJaFw0yNTA4MTUxOTAwNTZa
MEAxITAfBgNVBAoTGFhjZXJ0IEludGVybmF0aW9uYWwgSW5jLjEbMBkGA1UECxMS
WGNlcnQgUm9vdCBDQSAxMDI0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDW
vjeJEami90csKs9qACZlKESkiuTeoENVmURrvG64x87GY7bT6G/FmCskkbieorpx
SN40ICF61tLFiTKlicbchYRU8p5I7cxEtgb/jsTOWa2fbOkiWME/FApDgIcZUlDj
KAfIrBjisRqqo+Jgt3ZRByk5XkjpZnCBLjiavRl96wIDAQABo2MwYTAPBgNVHRMB
Af8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAfBgNVHSMEGDAWgBSEecdPB1mxa8E6
Nbq49NWZJ8i6DjAdBgNVHQ4EFgQUhHnHTwdZsWvBOjW6uPTVmSfIug4wDQYJKoZI
hvcNAQEFBQADgYEAc7DhAO2uaNJgA0br+RzxpaZ8XDJ87AJh0xwdczEsuo69SU3I
3dl3dUHnkiGabCnbp2xwhqBcw+TzMswBhFnXiDk486ji4hqwl80rF9xkBA+qanOU
1usIxoBpTd561cU38ZIXPG3TiiHMZBCq3mKHH4+4+Kp1SvQILPXcZs/DOH4=
-----END CERTIFICATE-----
...EOF...
cat >certs/xcert-international-inc-xcert-root-02.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            0a:01:01:01:00:00:02:7c:00:00:00:04:00:00:00:02
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Xcert International Inc., OU=Xcert Root CA v1
        Validity
            Not Before: Aug 18 18:40:50 2000 GMT
            Not After : Aug 15 19:00:38 2025 GMT
        Subject: O=Xcert International Inc., OU=Xcert Root CA v1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c1:92:ab:f2:b6:35:36:02:48:0f:85:f4:4e:2f:
                    82:65:cd:48:be:b1:b7:3d:b3:7b:ae:ba:32:34:86:
                    3c:98:bf:f8:b0:bd:fb:c2:cc:f6:09:97:38:5c:8d:
                    a5:23:4e:e1:c8:84:e6:90:67:74:3b:a3:f6:6e:99:
                    2b:8f:c3:07:d2:97:51:07:4f:04:cb:9e:b2:f8:3c:
                    f7:38:e6:96:4a:3a:eb:15:6f:e7:62:e6:43:33:07:
                    b2:0d:5a:cf:95:29:39:67:88:13:23:d4:8c:6d:5f:
                    8e:21:e0:31:f3:b5:dc:99:c5:c4:ed:85:10:7e:92:
                    d4:a2:1d:3c:1f:0b:b3:23:e6:c0:cb:24:9b:6c:10:
                    a6:cd:14:d6:a3:9d:53:8f:f7:1e:41:9a:b6:1b:1d:
                    08:5c:f7:39:41:c3:1e:de:4c:26:a3:60:7c:2e:13:
                    87:91:6c:d7:c2:23:2f:e7:7d:19:1f:cd:5b:ea:98:
                    c5:b9:46:7d:35:46:e4:7b:8b:4a:d9:93:e0:06:ab:
                    c0:cc:4a:fd:db:da:0b:30:3f:b8:5c:e0:07:13:a8:
                    c5:30:fc:bc:86:f6:aa:bf:0e:63:2f:8f:49:72:10:
                    d1:9e:85:f9:41:ed:48:3c:78:0c:fd:a0:2a:06:1b:
                    af:d3:dd:67:2f:ec:48:2f:51:49:36:22:b7:48:cd:
                    49:ef
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        a8:dc:b3:20:2e:fd:57:48:10:0f:e6:8d:60:52:1b:76:1d:9c:
        66:a0:6f:fa:68:06:d8:a7:9c:cb:a1:0c:8e:25:e8:ae:c7:df:
        3a:70:ad:a9:f8:2a:24:bc:bc:c7:aa:c7:09:b7:bb:10:e9:1f:
        5a:d5:a2:01:46:8b:05:c4:a3:75:49:0b:40:c7:b1:6b:9f:db:
        58:16:63:32:84:5a:10:8d:62:96:ab:98:66:9b:ba:fa:56:08:
        1b:ba:62:f3:ef:39:6b:fc:64:b1:c9:ae:ef:5e:94:e1:a2:80:
        f9:08:83:16:12:36:96:d9:09:90:d9:98:3a:af:3d:85:d8:91:
        2a:92:1c:5c:b9:cc:d5:5c:73:38:8e:7b:73:52:0c:ba:9f:f2:
        8e:bf:c8:7c:0a:13:ba:72:91:a0:3b:20:ef:89:2a:c3:0c:80:
        69:56:73:10:f4:60:19:e0:1e:16:4a:64:ab:fc:46:3a:d0:0b:
        d3:97:b1:5c:d9:9c:ac:18:3a:20:07:7a:22:f9:b7:10:65:ba:
        ec:e6:53:d4:aa:e4:c3:41:bc:9b:df:c2:dd:9a:01:46:d4:8e:
        45:ed:c9:ca:16:34:84:8d:32:54:3c:54:62:90:8d:1a:66:52:
        cd:fa:1c:cc:0c:fc:b1:e3:93:c8:a7:d9:eb:68:63:8f:d0:7e:
        2e:2d:dd:29
-----BEGIN CERTIFICATE-----
MIIC/zCCAecCEAoBAQEAAAJ8AAAABAAAAAIwDQYJKoZIhvcNAQEFBQAwPjEhMB8G
A1UEChMYWGNlcnQgSW50ZXJuYXRpb25hbCBJbmMuMRkwFwYDVQQLExBYY2VydCBS
b290IENBIHYxMB4XDTAwMDgxODE4NDA1MFoXDTI1MDgxNTE5MDAzOFowPjEhMB8G
A1UEChMYWGNlcnQgSW50ZXJuYXRpb25hbCBJbmMuMRkwFwYDVQQLExBYY2VydCBS
b290IENBIHYxMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwZKr8rY1
NgJID4X0Ti+CZc1IvrG3PbN7rroyNIY8mL/4sL37wsz2CZc4XI2lI07hyITmkGd0
O6P2bpkrj8MH0pdRB08Ey56y+Dz3OOaWSjrrFW/nYuZDMweyDVrPlSk5Z4gTI9SM
bV+OIeAx87XcmcXE7YUQfpLUoh08HwuzI+bAyySbbBCmzRTWo51Tj/ceQZq2Gx0I
XPc5QcMe3kwmo2B8LhOHkWzXwiMv530ZH81b6pjFuUZ9NUbke4tK2ZPgBqvAzEr9
29oLMD+4XOAHE6jFMPy8hvaqvw5jL49JchDRnoX5Qe1IPHgM/aAqBhuv091nL+xI
L1FJNiK3SM1J7wIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQCo3LMgLv1XSBAP5o1g
Uht2HZxmoG/6aAbYp5zLoQyOJeiux986cK2p+CokvLzHqscJt7sQ6R9a1aIBRosF
xKN1SQtAx7Frn9tYFmMyhFoQjWKWq5hmm7r6VggbumLz7zlr/GSxya7vXpThooD5
CIMWEjaW2QmQ2Zg6rz2F2JEqkhxcuczVXHM4jntzUgy6n/KOv8h8ChO6cpGgOyDv
iSrDDIBpVnMQ9GAZ4B4WSmSr/EY60AvTl7Fc2ZysGDogB3oi+bcQZbrs5lPUquTD
Qbyb38LdmgFG1I5F7cnKFjSEjTJUPFRikI0aZlLN+hzMDPyx45PIp9nraGOP0H4u
Ld0p
-----END CERTIFICATE-----
...EOF...
cat >certs/xcert-international-inc-xcert-root-03.pem <<...EOF...
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            0a:01:01:01:00:00:02:7c:00:00:00:05:00:00:00:02
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Xcert International Inc., OU=Xcert Root CA v1 1024
        Validity
            Not Before: Aug 18 18:50:56 2000 GMT
            Not After : Aug 15 19:01:08 2025 GMT
        Subject: O=Xcert International Inc., OU=Xcert Root CA v1 1024
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:a7:09:c3:d2:a9:a6:19:70:ec:29:e9:45:7b:36:
                    e0:ea:3e:c9:99:70:40:d1:b6:60:f4:dd:23:c7:59:
                    79:9d:1e:a5:be:35:63:00:e6:c0:2e:6c:40:53:e6:
                    d1:76:46:f1:a0:cb:83:45:54:98:19:cf:7b:9a:38:
                    f8:74:33:33:3f:a9:25:20:28:26:5d:28:71:46:86:
                    20:3d:30:2b:ab:e6:4d:fa:3f:ea:44:40:4c:fb:73:
                    d4:dc:96:74:f4:4e:e4:6a:1d:1b:97:a0:7c:30:e1:
                    c0:73:b6:0d:a2:77:7a:f1:18:f8:4a:71:71:9e:f8:
                    a8:75:fe:62:f8:aa:3d:cf:7d
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        7b:d3:d5:4c:7f:4c:a2:7e:7c:d7:56:61:d9:95:98:85:8a:d7:
        49:dc:8c:47:aa:07:ec:b8:db:79:24:9e:e7:a5:92:57:66:09:
        8f:14:b0:fe:04:f2:bd:51:10:b8:38:c3:a1:12:db:90:83:7e:
        b5:63:58:ab:33:ad:97:1e:46:50:42:10:ac:c8:ab:2d:1d:35:
        6c:c6:e6:43:50:28:03:a1:ac:fb:11:95:ff:e9:d5:4a:0f:91:
        e5:03:e4:88:30:3c:1c:76:d1:97:f0:0a:d4:87:a0:0c:9a:8f:
        61:ce:da:7e:72:b3:3b:50:c0:80:84:0f:21:20:94:68:2a:da:
        8c:be
-----BEGIN CERTIFICATE-----
MIICBDCCAW0CEAoBAQEAAAJ8AAAABQAAAAIwDQYJKoZIhvcNAQEFBQAwQzEhMB8G
A1UEChMYWGNlcnQgSW50ZXJuYXRpb25hbCBJbmMuMR4wHAYDVQQLExVYY2VydCBS
b290IENBIHYxIDEwMjQwHhcNMDAwODE4MTg1MDU2WhcNMjUwODE1MTkwMTA4WjBD
MSEwHwYDVQQKExhYY2VydCBJbnRlcm5hdGlvbmFsIEluYy4xHjAcBgNVBAsTFVhj
ZXJ0IFJvb3QgQ0EgdjEgMTAyNDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA
pwnD0qmmGXDsKelFezbg6j7JmXBA0bZg9N0jx1l5nR6lvjVjAObALmxAU+bRdkbx
oMuDRVSYGc97mjj4dDMzP6klICgmXShxRoYgPTArq+ZN+j/qREBM+3PU3JZ09E7k
ah0bl6B8MOHAc7YNond68Rj4SnFxnviodf5i+Ko9z30CAwEAATANBgkqhkiG9w0B
AQUFAAOBgQB709VMf0yifnzXVmHZlZiFitdJ3IxHqgfsuNt5JJ7npZJXZgmPFLD+
BPK9URC4OMOhEtuQg361Y1irM62XHkZQQhCsyKstHTVsxuZDUCgDoaz7EZX/6dVK
D5HlA+SIMDwcdtGX8ArUh6AMmo9hztp+crM7UMCAhA8hIJRoKtqMvg==
-----END CERTIFICATE-----
...EOF...
