/**************************************************************************/
/*                                                                        */
/*  cpbk - a mirroring utility for backing up your files                  */
/*  Copyright (C) 1998 Kevin Lindsay <klindsay@mkintraweb.com>            */
/*  Copyright (C) 2001 Yuuki NINOMIYA <gm@debian.or.jp>                   */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2, or (at your option)   */
/*  any later version.                                                    */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful,       */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*  GNU General Public License for more details.                          */
/*                                                                        */
/*  You should have received a copy of the GNU General Public License     */
/*  along with this program; if not, write to the                         */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,          */
/*  Boston, MA 02111-1307, USA.                                           */
/*                                                                        */
/**************************************************************************/

/* $Id: exclude.c,v 1.5 2001/03/30 12:04:55 gm Exp $ */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "intl.h"
#include "strlib.h"
#include "variable.h"
#include "proto.h"


/* --- PUBLIC FUNCTIONS --- */

void parse_linear_exclude_path(void)
{
	char *path_dir;

	if (command_line_option.linear_exclude_path == NULL || (path_dir = strtok(command_line_option.linear_exclude_path, ",")) == NULL) {
		return;
	}

	do {
		config.exclude_path = insert_list_head(config.exclude_path, str_dup(path_dir));
	} while ((path_dir = strtok(NULL, ",")) != NULL);
}


void prepare_exclude_path(void)
{
	cfgList *l;

	for (l = config.exclude_path; l != NULL; l = l->next) {
		l->str = canonicalize_path(l->str, _("exclude"));
	}
}


bool is_exclude_path(const char *path, const char *displayed_path)
{
	cfgList *l;
	size_t exclude_path_len;

	for (l = config.exclude_path; l != NULL; l = l->next) {
		exclude_path_len = strlen(l->str);
		if (strncmp(l->str, path, exclude_path_len) == 0 &&
		    (path[exclude_path_len] == '/' || path[exclude_path_len] == '\0')) {
			if (config.verbose) {
				printf(_("\n`%s' is excluded according to the configuration.\n"), displayed_path);
			}
			return (TRUE);
		}
	}
	return (FALSE);
}


/* --- PRIVATE FUNCTIONS --- */
