/*
 * This file is part of the FORS Data Reduction Pipeline
 * Copyright (C) 2002-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef FORS_CCD_CONFIG_H
#define FORS_CCD_CONFIG_H

#include <memory>
#include "fiera_config.h"

std::auto_ptr<mosca::fiera_config> fors_ccd_settings_equal(const cpl_frameset * fset);

void fors_update_ccd_ron(mosca::ccd_config ccd_config, 
                         cpl_propertylist * master_bias_header);

std::auto_ptr<mosca::fiera_config>  fors_ccd_config_read
(const cpl_frame * target, const cpl_frame * bias_frame);

#endif /* FORS_CCD_CONFIG_H */

