/* 
 * init_pud.c
 *
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "crafted.h"
#include "craftedintl.h"

void init_pud(int width, int height)
{
  int i;

  Pud.path        = g_strdup("untitled");
  Pud.is_loaded   = TRUE;
  Pud.readonly    = FALSE;
  Pud.modified    = FALSE;
  Pud.version     = 1;
  Pud.sub_version = 1;

  /* get description */
  Pud.description = g_strdup(_("new pud"));
  Pud.terrain     = 0; /* 0 = SUMMER */
  Pud.width       = width;
  Pud.height      = height;
  for (i=0 ; i<15 ; i++)
  {
    Pud.player[i].owner = 3; /* nobody */
    Pud.player[i].side = 0; /* human */
    Pud.player[i].gold = 5000;
    Pud.player[i].wood = 2000;
    Pud.player[i].oil = 2000;
  }
  Pud.player[15].owner = 2; /* neutral */
  Pud.player[15].side = 2; /* neutral */
  Pud.player[15].gold = 1000;
  Pud.player[15].wood = 1000;
  Pud.player[15].oil = 1000;

  Pud.fields = g_new(guint16, Pud.width * Pud.height);
  Pud.units = NULL;
  for (i = 0 ; i < Pud.width * Pud.height ; i++)
    Pud.fields[i] = 0x0050;
  after_load();
}

