// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// initwindow.h
//
// Changes:
//   08-11-2001 - windows are subclasses of ButtonHook; this
//                removes the need for a separate hook class
//                for each window
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_INITWINDOW_H
#define _INCLUDE_INITWINDOW_H

#include "window.h"
#include "textbox.h"
#include "button.h"

class InitWindow : public Window, public ButtonHook {
public:
  InitWindow( View *view );
  ~InitWindow( void );

  void Draw( void );
  GUI_Status Activate( ButtonWidget *button, Window *win );

private:
  TextListWidget *levwidget;
  ButtonWidget *startwidget;
  ButtonWidget *listctrlwidget;
  ButtonWidget *videowidget;
  CheckboxWidget *pbemwidget;
  CheckboxWidget *aiwidget;

  List levels;
  List saves;

  Image *logo;
};


class VideoOptionsWindow : public Window, public ButtonHook {
public:
  VideoOptionsWindow( View *view );
  ~VideoOptionsWindow( void );

  void Draw( void );
  GUI_Status Activate( ButtonWidget *button, Window *win );

private:
  TextListWidget *modewidget;
  CheckboxWidget *fswidget;

  List modes;
};

#endif	/* _INCLUDE_INITWINDOW_H */

