// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// mapwindow.h
//
// Changes:
//   22-04-2001 - added FOG_ALPHA
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_MAPWINDOW_H
#define _INCLUDE_MAPWINDOW_H

#include "window.h"
#include "map.h"
#include "misc.h"

#define GFX_WIDTH       32
#define GFX_HEIGHT      28
#define GFX_OVERLAP_X   9
#define GFX_OVERLAP_Y   14
#define GFX_PER_LINE    18

#define FOG_ALPHA	128

#define ANIM_SPEED_UNIT		150  // time it takes for a unit to move one hex (ms)
#define ANIM_SPEED_CURSOR	40   // speed when moveing cursor

// special hex graphics
#define IMG_CURSOR_IDLE         51
#define IMG_CURSOR_SELECT       50
#define IMG_CURSOR_ATTACK       52
#define IMG_CURSOR_HIGHLIGHT    47
#define IMG_RECESSED_HEX        49
#define IMG_SHADOW              48
#define IMG_NOT_AVAILABLE       53
#define IMG_DESTROYED		IMG_SHADOW


#define DEFAULT_PANEL_HEIGHT	(20)

// the small info panel at the bottom of the map window
class Panel : public Window {
public:
  Panel( class MapWindow *mw, View *view );

  void Draw( void );
  void Update( Unit *unit );
  virtual GUI_Status HandleEvent( const SDL_Event &event );

private:
  Unit *unit;
  MapWindow *mapwin;
};



class MapWindow : public Window, public Map {
public:
  MapWindow( short x, short y, unsigned short w, unsigned short h,
             unsigned short flags, View *view );
  ~MapWindow( void );

  void Init( void );                 // call after loading map
  void Reset( void );
  void VideoModeChange( void );
  int LoadMapGfx( SDL_RWops *file );

  void ShowOff( void );
  virtual void Draw( void ) { Draw( 0, 0, w, h ); }
  void Draw( short x, short y, unsigned short w, unsigned short h );

  void DrawMap( short x, short y, unsigned short w, unsigned short h,
             Surface *dest, short dx, short dy );
  void DrawHex( unsigned short n, Surface *dest,
                short px, short py, const Rect &clip );
  void DrawFog( Surface *dest, short px, short py, const Rect &clip );
  void FogOn( void ) { fog = true; }
  void FogOff( void ) { fog = false; }

  int Pixel2Hex( short px, short py, Point &hex ) const;
  void Hex2Pixel( short hx, short hy, Point &pix ) const;
  bool HexOnScreen( short hx, short hy ) const;

  void UpdateHex( short hx, short hy );
  void MoveHex( unsigned short img, short hx1, short hy1,
                short hx2, short hy2, unsigned short speed );

  void CenterOnHex( short hx, short hy );
  void BoxAvoidHexes( Rect &rect, short hx1, short hy1,
                      short hx2, short hy2 ) const;

  void CheckScroll( void );
  void Scroll( short px, short py );
  unsigned short MinXHex( short x ) const;
  unsigned short MinYHex( short y ) const;
  unsigned short MaxXHex( short x, unsigned short w ) const;
  unsigned short MaxYHex( short y, unsigned short h ) const;

  void CursorOff( void );
  const Point *Cursor( void ) { return &cursor; }
  void UnsetCursor( void );
  void SetCursor( short hx, short hy, bool upd );
  void SetCursorImage( unsigned short img ) { cursor_image = img; }
  int MoveCursor( Direction dir );

  void DrawUnitInfo( const UnitType *type, Surface *dest, const Rect &rect );

protected:
  Point cursor;
  unsigned short cursor_image;

  unsigned short curx;		// current map offsets
  unsigned short cury;
  unsigned short maxx;		// maximum map offsets
  unsigned short maxy;

  Unit *unit;			// current unit
  Player *player;		// current player

  Surface *tiles;
  Panel *panel;

  bool fog;			// draw fog?
  bool show;			// display off?
};

#endif	/* _INCLUDE_MAPWINDOW_H */

