// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000, 2001 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

///////////////////////////////////////////////////////////////
// slider.h - slider widget class
//
// Changes:
//   22-06-2001 - added ProgressBar widget
///////////////////////////////////////////////////////////////

#ifndef _INCLUDE_SLIDER_H
#define _INCLUDE_SLIDER_H

#include "widget.h"

#define DEFAULT_SLIDER_SIZE	12

// Scrollable class used by the widget
class Scrollable {
public:
  Scrollable( void ) {}
  Scrollable( short start ) { current = start; }

  virtual void Scroll( short delta ) { Set( current + delta ); }
  virtual void Set( short level ) { current = level; }

protected:
  short current;	// current scroller value
};


class SliderWidget : public Widget {
public:
  SliderWidget( short id, short x, short y, unsigned short w,
    unsigned short h, short min, short max, short start,
    short ksize, short key, unsigned short flags,
    const char *title, Window *window );

  void Adjust( short newmin, short newmax, short newsize );
  virtual void Draw( void );
  void ScrollTo( short level );
  void SetScrollable( Scrollable *scle ) { scrollable = scle; }

  virtual GUI_Status MouseMove( const SDL_MouseMotionEvent &motion );
  virtual GUI_Status MouseDown( const SDL_MouseButtonEvent &button );
  virtual GUI_Status MouseUp( const SDL_MouseButtonEvent &button );
  virtual GUI_Status KeyDown( const SDL_keysym &key );
  virtual GUI_Status KeyUp( const SDL_keysym &key );

  short Level( void ) const { return current; }

private:
  Rect knob;              // the slider knob

  Scrollable *scrollable; // this is sent a Scrollable::Scroll
  short min;
  short max;
  short current;

  short size;
  float step;             // number of pixels to move knob per value
  bool mousehit;          // status var used for mouse dragging
};


class ProgressWidget : public Widget {
public:
  ProgressWidget( short id, short x, short y, unsigned short w,
               unsigned short h, short min, short max,
               unsigned short flags, const char *title, Window *window );
  void SetColor( const Color &col ) { this->col = col; }
  void SetLevel( short lev );
  short Level( void ) const { return level + min; }

  void Draw( void );

private:
  unsigned short level;
  short min;
  short max;

  Color col;
};

#endif	/* _INCLUDE_SLIDER_H */

