; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppName=Crimson Fields Mobile
AppVerName=Crimson Fields Mobile 0.5.0
AppPublisher=software@iaccarino.de
AppPublisherURL=http://www.iaccarino.de/silvio/ppcstuff.htm
AppSupportURL=http://www.iaccarino.de/silvio/ppcstuff.htm
AppUpdatesURL=http://www.iaccarino.de/silvio/ppcstuff.htm
DefaultDirName={code:LocateAppManagerPath}\CrimsonFields
DefaultGroupName=Crimson Fields
OutputBaseFilename=CrimsonFieldsPPCSetup
Compression=lzma/ultra
SolidCompression=true
InternalCompressLevel=ultra
VersionInfoVersion=0.5.0.0
VersionInfoCompany=software@iaccarino.de
VersionInfoDescription=Crimson Fields Pocket PC Port
VersionInfoTextVersion=0.5.0
VersionInfoCopyright=2006 Jens Granseuer
AppCopyright=2006 Jens Granseuer
InfoBeforeFile=release\docs\README
LicenseFile=release\docs\COPYING
ShowLanguageDialog=auto
AppVersion=0.5.0
AppID={{E9D11AB4-7E40-4AE6-BA65-A96DAE666872}
AppComments=Pocket PC Port by Silvio Iaccarino
AppContact=software@iaccarino.de
AppReadmeFile={app}\docs\README
UninstallDisplayIcon={app}\crimson.exe
UninstallDisplayName=Iaccarino's Crimson Fields for Pocket PCs
WizardImageFile=gfx\setupBig.bmp
WizardSmallImageFile=gfx\setupSmall.bmp
InfoAfterFile=release\docs\NEWS
SetupIconFile=gfx\setup.ico
RestartIfNeededByRun=false
DisableDirPage=true
UsePreviousAppDir=false
AllowUNCPath=false
DisableProgramGroupPage=true
AlwaysShowComponentsList=false
ShowComponentSizes=false
FlatComponentsList=false
DisableReadyPage=true

[Languages]
Name: english; MessagesFile: compiler:Default.isl
Name: french; MessagesFile: compiler:Languages\French.isl
Name: german; MessagesFile: compiler:Languages\German.isl
Name: hungarian; MessagesFile: compiler:Languages\Hungarian.isl
Name: polish; MessagesFile: compiler:Languages\Polish.isl
Name: slovak; MessagesFile: compiler:Languages\Slovak.isl

[CustomMessages]
german.NO_AS=Es ist kein Active Sync installiert. Das Programm kann nicht installiert werden!
english.NO_AS=Active Sync is not installed. The application can not be installed!
german.RUN_Tutorial=Anleitung anzeigen
english.RUN_Tutorial=Display tutorial now
german.CreateTutIcon=Verknpfung zur Anleitung auf meinem Desktop anlegen
english.CreateTutIcon=Create a shortcut to the tutorial on my desktop

[Files]
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
Source: CrimsonFields.ini; DestDir: {app}; Languages: 
Source: Output\CrimsonFieldsPPC.CAB; DestDir: {app}
Source: gfx\crimsonsync.ico; DestDir: {app}
Source: gfx\crimson.ico; DestDir: {app}

[INI]
Filename: {app}\CrimsonFields.ini; Section: CEAppManager; Key: Version; String: 1.0
Filename: {app}\CrimsonFields.ini; Section: CEAppManager; Key: Component; String: CrimsonFields
Filename: {app}\CrimsonFields.ini; Section: CrimsonFields; Key: Description; String: Crimson Fields for Windows Mobile Devices
Filename: {app}\CrimsonFields.ini; Section: CrimsonFields; Key: CabFiles; String: CrimsonFieldsPPC.cab
Filename: {app}\CrimsonFields.ini; Section: CrimsonFields; Key: Uninstall; String: {{E9D11AB4-7E40-4AE6-BA65-A96DAE666872}_is1
Filename: {app}\CrimsonFields.ini; Section: CrimsonFields; Key: IconFile; String: crimsonsync.ico
Filename: {app}\CrimsonFields.ini; Section: CrimsonFields; Key: IconIndex; String: 0
Filename: {app}\CrimsonFields.ini; Section: CrimsonFields; Key: DeviceFile; String: crimson.exe

[Run]
Filename: {code:LocateAppManager}; Parameters: """{app}\CrimsonFields.ini"""; WorkingDir: {code:LocateAppManagerPath}

[Code]
function LocateAppManager(Default: string) : String;
var
	s	: string;
begin
	s := Default;
	RegQueryStringValue(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\CEAPPMGR.EXE','',s);
	Result := s;
end;

function LocateAppManagerPath(Default: string) : String;
begin
	Result := ExtractFilePath(LocateAppManager(''));
end;

function InitializeSetup(): boolean;
var
	s	: string;
begin
	s := LocateAppManager('');
	if Length(s) = 0 then begin
		MsgBox(CustomMessage('NO_AS'),mbError, MB_OK);
		Result := false
	end
	else
		Result := true
end;
