// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#include <Trace.hpp>
#include <Random.hpp>
#include <BaseSurface.hpp>
#include <PuckMaze.hpp>
#include <Constants.hpp>

//make new maze and add elements
PuckMaze::PuckMaze( int w, int h):
Maze( w, h)
{
    AddElements();
}

//add elements
void PuckMaze::AddElements( void)
{
    int i;
    for( i=0; i < width * height; i++)
    {
	map[ i] |= POINT;
    }
    points = i;
}

void PuckMaze::AddPowerpoints( int numPoints)
{
    for( int i=0; i < numPoints; i++)
    {
	map[ Random::random() % (width*height)] |= POWERPOINT;
    }
}

//redo the maze
void PuckMaze::MakeNew( void)
{
    Create();
    Simplify();
    AddElements();
}

void PuckMaze::Redraw( int X, int Y, int W, int H)
{
    int pos = 0;
    int x,y,i;

    if( (Y+H) > height) H = height - Y;
    if( (X+W) > width) W = width - X;

    int maxPos = width*height;

    for( y=Y; y<(Y+H); y++)
    {
	pos = y*width+X;
	for( x=X; x<(X+W); x++)
	{
	    char c[16];
	    for( i=0; i<16; i++)
	    {
		c[ i] = BGCOLOR;
	    }

	    if( map[ pos] & WallDN)
	    {
		c[ 12] = WALLCOLOR;
		c[ 13] = WALLCOLOR;
		c[ 14] = WALLCOLOR;
		c[ 15] = WALLCOLOR;
	    }
	    if( map[ pos] & WallRT)
	    {
		c[ 3]  = WALLCOLOR;
		c[ 7]  = WALLCOLOR;
		c[ 11] = WALLCOLOR;
		c[ 15] = WALLCOLOR;
	    }
	    if( (map[ pos+1] & WallDN) || 
		((pos+width)<maxPos) && (map[ pos+width] & WallRT) )
	    {
		c[ 15] = WALLCOLOR;
	    }

	    if( map[ pos] & POINT)
	    {
		c[5]=POINTCOLOR;
	    }
	    if( map[ pos] & POWERPOINT)
	    {
		c[0]=PPOINTCOLOR;
		c[1]=PPOINTCOLOR;
		c[2]=PPOINTCOLOR;
		c[4]=PPOINTCOLOR;
		c[6]=PPOINTCOLOR;
		c[8]=PPOINTCOLOR;
		c[9]=PPOINTCOLOR;
		c[10]=PPOINTCOLOR;
	    }

	    for( int yy=0; yy<4; yy++)
	    {
		for( int xx=0; xx<4; xx++)
		{
		    SurfaceS()->SetPixel(x*4+xx+1,y*4+yy+1,c[yy*4+xx]);
		}
	    }

	    pos++;
	}
    }

    pos = Y*width;
    for( y=Y; y<(Y+H); y++)
    {
	if( map[ pos] & WallLT)
	{
	    SurfaceS()->SetPixel( 0, y*4+0, WALLCOLOR);
	    SurfaceS()->SetPixel( 0, y*4+1, WALLCOLOR);
	    SurfaceS()->SetPixel( 0, y*4+2, WALLCOLOR);
	    SurfaceS()->SetPixel( 0, y*4+3, WALLCOLOR);
	}
	pos += width;
    }

    pos = X;
    for( x=X; x<(X+W); x++)
    {
	if( map[ pos] & WallUP)
	{
	    SurfaceS()->SetPixel( x*4+0, 0, WALLCOLOR);
	    SurfaceS()->SetPixel( x*4+1, 0, WALLCOLOR);
	    SurfaceS()->SetPixel( x*4+2, 0, WALLCOLOR);
	    SurfaceS()->SetPixel( x*4+3, 0, WALLCOLOR);
	}
	pos++;
    }
}

//draw the maze...
void PuckMaze::Draw( void)
{
    Redraw( 0, 0, width, height);
}
