// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __SoftSurface_hpp__
#define __SoftSurface_hpp__

#include "SDL.h"

#include <BaseSurface.hpp>

const string SURFACE_SDL_SOFT = "Soft-Surface";

class SoftSurface: public BaseSurface
{
public:
    SoftSurface( int w, int h);
    virtual ~SoftSurface();

    virtual void SetColor( int index, int red, int green, int blue);
    virtual void SetPixel( int x, int y, unsigned char colorIndex);
    virtual unsigned char GetPixel( int x, int y);
    virtual void Flip( void);
    virtual void Snapshot( void);

    virtual const string &Type( void)
    {
	return SURFACE_SDL_SOFT;
    }

private:
    SDL_Surface *_surface;
};

#endif
