#include "netbuffer"

string Netbuffer::printable (char ch) const {
    ostringstream o;
    
    if (isprint(ch) && ch != '\\') {
	o << ch;
	return (o.str());
    } else if (ch == '\n')
	return ("\\n");
    else if (ch == '\r')
	return ("\\r");
    else if (ch == '\t')
	return ("\\t");
    else {
	char buf[10];
	sprintf (buf, "%3.3o", ch & 0xff);
	o << "\\" << buf;
	return (o.str());
    }

    // Avoid warnings
    return (".");
}
