/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2004 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#ifndef _P11_USB_DEVICES_HH_
#define _P11_USB_DEVICES_HH_

#include <vector>

#include "P11Device.hh"

/* Do we need a real class for this ? */
namespace Cryptonit
{
    struct p11_usb_device {
	char vendorID[5];
	char productID[5];
	char *vendor;
	char *product;
	char *filename;
	char *path;
    };


#define REGISTRY_USB_SUBKEY "SYSTEM\\CurrentControlSet\\Enum\\USB"


#define MAX_KNOWN_USB_DEVICES 5

    /** List of known USB PKCS#11 */
    static struct p11_usb_device knownUSBDevices[MAX_KNOWN_USB_DEVICES] =
    //     VendorID ProductID    Description
	{
	    // Rainbow Technologies, Inc. iKey 3000 Token (iKey 3000)
	    {"04b9", "1300", "Rainbow Technologies, Inc", "iKey 3000 Token",
#ifdef __WIN32__
	     "ikey.dll", ""
#else
	     "ikey.so", "/usr/lib/"
#endif
	    },

	    // OmniKey AG                                 (Oberthur Cardman 3121)
	    {"076b", "3021", "Omnikey AG", "Cardman 3121",
#ifdef __WIN32__
	     "OCSCryptolib_P11.dll", ""
#else
	     "OCSCryptolib_P11.so", "/usr/lib/"
#endif
	    },

	    // ??                                         (id3/GMP Biothentic)
	    {"0b81", "0001", "id3/GMP Biothentic", "Biothentic",
#ifdef __WIN32__
	     "biothentic.dll", ""
#else
	     "biothentic.so", "/usr/lib/"
#endif
	    },

	    // OmniKey AG CardMan 2020                    (Oberthur OCR 150)
	    {"076b", "0596", "Omnikey AG", "Cardman 2020/Oberthur OCR 150",
#ifdef __WIN32__
	     "OCSCryptolib_P11.dll", ""
#else
	     "OCSCryptolib_P11.so", "/usr/lib/"
#endif
	    },

	    // ActivCard, Inc.                            (ActivCard) -- A TESTER --
	    {"09c3", "0008", "ActivCard, Inc.", "ActivCard",
#ifdef __WIN32__
	     "activcard.dll", ""
#else
	     "activcard.so", "/usr/lib/"
#endif
	    }

	};


    int getUSBDevices( std::vector<P11Device>& devices);

};

#endif
