
function CreateRoom(matname)
	print('Start creating polygons from Lua script...')
	engine=iObjectRegistry_Query_iEngine(object_reg)

	sectlist=iEngine_GetSectors(engine)
	room=iSectorList_FindByName(sectlist, "room")
	walls=iEngine_CreateSectorWallsMesh(engine,room,"walls")
	thingstate=iMeshObject_Query_iThingState(iMeshWrapper_GetMeshObject(walls))
	matlist=iEngine_GetMaterialList(engine)
	material=iMaterialList_FindByName(matlist,matname)

	poly=iThingState_CreatePolygon(thingstate,'floor')
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,0,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,0,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,0,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,0,-5))
	iPolygon3D_SetTextureSpace(poly,iPolygon3D_GetVertex(poly,0), iPolygon3D_GetVertex(poly,1), 3)
	iPolygon3D_SetMaterial(poly,material)

	poly=iThingState_CreatePolygon(thingstate,'ceiling')
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,20,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,20,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,20,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,20,5))
	iPolygon3D_SetTextureSpace(poly,iPolygon3D_GetVertex(poly,0), iPolygon3D_GetVertex(poly,1), 3)
	iPolygon3D_SetMaterial(poly,material)

	poly=iThingState_CreatePolygon(thingstate,'w1')
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,20,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,20,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,0,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,0,5))
	iPolygon3D_SetTextureSpace(poly,iPolygon3D_GetVertex(poly,0), iPolygon3D_GetVertex(poly,1), 3)
	iPolygon3D_SetMaterial(poly,material)

	poly=iThingState_CreatePolygon(thingstate,'w2')
	iPolygon3D_CreateVertex(poly,new_csVector3(5,20,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,20,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,0,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,0,5))
	iPolygon3D_SetTextureSpace(poly,iPolygon3D_GetVertex(poly,0), iPolygon3D_GetVertex(poly,1), 3)
	iPolygon3D_SetMaterial(poly,material)

	poly=iThingState_CreatePolygon(thingstate,'w3')
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,20,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,20,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,0,5))
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,0,-5))
	iPolygon3D_SetTextureSpace(poly,iPolygon3D_GetVertex(poly,0), iPolygon3D_GetVertex(poly,1), 3)
	iPolygon3D_SetMaterial(poly,material)

	poly=iThingState_CreatePolygon(thingstate,'w4')
	iPolygon3D_CreateVertex(poly,new_csVector3(5,20,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,20,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(-5,0,-5))
	iPolygon3D_CreateVertex(poly,new_csVector3(5,0,-5))
	iPolygon3D_SetTextureSpace(poly,iPolygon3D_GetVertex(poly,0), iPolygon3D_GetVertex(poly,1), 3)
	iPolygon3D_SetMaterial(poly,material)
	iThingState_DecRef(thingstate)
	print('Finished!') 
end
