# filter.rb : The base class for filters
# Copyright (C) 2006 Vincent Fourmond

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA


module SciYAG

  module Backends

    #  The base class for filters. Just an interface, in the java meaning of
    #  the term. A filter just provides a function to apply itself.
    class Filter
      # Import the main description functions into the appropriate
      # namespaces
      extend  Descriptions::DescriptionExtend
      include Descriptions::DescriptionInclude


      def initialize
      end

      # Creates a description object with the given texts and associates
      # it with the class. To be used in Filter subclasses, simply this way:
      #
      #  describe "biniou", "Biniou filter", "A filter to take out Binious"
      #
      # Please remember also that if you don't set a description for
      # your Filter, it will most likely be of no use to anyone...

      def Filter.describe(name, longname, desc)
        d = FilterDescription.new(self,name, longname, desc)
        set_description(d)
        register_description(d)
      end

      # Gets a Function (or assimilate ?) and applies the filter on them.
      # The functions  *should not modify any data in ary*.
      # By default, the mechanism is to make a copy of the data and apply
      # apply! on it.
      def apply(a)
        f = Dobjects::Function.new(a.x.dup, a.y.dup)
        apply!(f)
        return f
      end

      # This version modifies directly the Function inside the +f+. 
      def apply!(func)
        return func
      end
    end

    # Specializes Descriptions for filters
    class FilterDescription < Descriptions::Description
      
    end
  end
end
