#!/bin/sh
# This file contains some 'visual tests' for ctioga to make sure that when
# I add some features to ctioga, I don't break everything existing.
# As such, it also stands as a 'feature list' for ctioga.

# Test for legends

. ./test_style.sh

ctioga -t 'Normal legends' 'sin(x)' 'cos(x)'

ctioga -t 'Normal legends + line' 'sin(x)' --legend-line \
    'One line between' 'cos(x)'

# Legends of the second axes must show where the first axes are
ctioga -t 'Legends and second axes' 'sin(x)' 'cos(x)' \
    --y2 -l '$x^2$ (2nd)' 'x**2' 

# Legends and insets
ctioga -N -t 'Legends and insets' -l '$x^2$' 'x**2'  \
    --inset .5,.5:.4 -l '$\sin x$' 'sin(x)' \
    -l '$\cos x$' 'cos(x)'

# Legends and markers
ctioga -N -t 'Legends and markers' --marker auto \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'No line' 'x**2 + 2*x + 1'

# Legends inside
ctioga -N -t 'Legends inside' \
    --legend-inside 0.5,0.7:0.3 \
    --marker auto \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'No line' 'x**2 + 2*x + 1'

# A (bad) use case of --legend-dy
ctioga -N -t 'Crammed legends inside' \
    --legend-inside 0.5,0.7:0.3 \
    --marker auto   --legend-dy 1.0 \
    -l '$x^2$' 'x**2' --line-style none \
    --legend-line \
    'One (crammed) line between'  \
    'cos(x)' \
    -l 'No line' 'x**2 + 2*x + 1'


# New position scheme
ctioga -N -t 'Top left in the middle' \
    --legend-inside tl:0.5,0.5 \
    --marker auto \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'Intentionally long legend' 'x**2 + 2*x + 1'


ctioga -N -t 'Bottom right in the middle' \
    --legend-inside br:0.5,0.5 \
    --marker auto \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'Intentionally long legend' 'x**2 + 2*x + 1'

ctioga -N -t 'Center in the middle' \
    --legend-inside cc:0.5,0.5 \
    --marker auto \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'Intentionally long legend' 'x**2 + 2*x + 1'

ctioga -N -t 'Center in the middle, simpler spec' \
    --legend-inside cc --marker auto \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'Intentionally long legend' 'x**2 + 2*x + 1'

# Frames around legends...
ctioga -N -t 'Bottom right in the middle, framed (square)' \
    --legend-inside br:0.5,0.5 \
    --marker auto \
    --legend-frame square \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'Intentionally long legend' 'x**2 + 2*x + 1'

ctioga -N -t 'Bottom right in the middle, framed (round)' \
    --legend-inside br:0.5,0.5 \
    --marker auto \
    --legend-frame round \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'Intentionally long legend' 'x**2 + 2*x + 1'

# Colors...
ctioga -N -t 'Colored frames' \
    --legend-inside cc:0.5,0.5 \
    --legend-color Green --legend-background 0.9,1.0,0.9 \
    --marker auto \
    --legend-frame round \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'Intentionally long legend' 'x**2 + 2*x + 1'

ctioga -N -t 'Transparent background' \
    --legend-inside cc:0.5,0.5 --math-samples 1000 \
    --legend-color Green --legend-background White \
    --legend-transparency 0.4 \
    --marker auto \
    --legend-frame round \
    -l '$\cos 2x$' 'cos(2*x)'  \
    -l '$\sin 2x$ (still decently long)' 'sin(2*x)'

ctioga -N -t 'Fancy frames' \
    --legend-inside cc:0.5,0.5 --math-samples 100 \
    --legend-line-width 0.7 \
    --legend-line-style Dots \
    --legend-background Cornsilk \
    --marker auto \
    --legend-frame round \
    -l '$x^2$' 'x**2' --line-style none \
    -l 'Intentionally long legend' 'x**2 + 2*x + 1'
