.\"
.\" "$Id: ipptool.man 11642 2014-02-27 15:57:59Z msweet $"
.\"
.\" ipptool man page for CUPS.
.\"
.\" Copyright 2010-2014 by Apple Inc.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH ipptool 1 "CUPS" "20 February 2014" "Apple Inc."
.SH NAME
ipptool - perform internet printing protocol requests
.SH SYNOPSIS
.B ipptool
[ --help ] [ --stop-after-include-error ] [ --version ]
[ -4 ] [ -6 ] [ -C ] [ -E ] [ -I ] [ -L ] [ -S ] [ -T
.I seconds
] [ -V
.I version
] [ -X ] [ -c ] [ -d
.I name=value
] [ -f
.I filename
] [ -i
.I seconds
] [ -n
.I repeat-count
] [ -q ] [ -t ] [ -v ]
.I URI
.I filename
[
.I ... filenameN
]
.SH DESCRIPTION
\fIipptool\fR sends IPP requests to the specified URI and tests and/or displays the results. Each named file defines one or more requests, including the expected response status, attributes, and values. Output is either a plain text, formatted text, CSV, or XML report on the standard output, with a non-zero exit status indicating that one or more tests have failed. The file format is described in \fIipptoolfile(5)\fR.
.SH OPTIONS
The following options are recognized by \fIipptool\fR:
.TP 5
--help
Shows program help.
.TP 5
--stop-after-include-error
Tells \fIipptool\fR to stop if an error occurs in an included file. Normally \fIipptool\fR will continue with subsequent tests after the INCLUDE directive.
.TP 5
--version
Shows the version of \fIipptool\fR being used.
.TP 5
-4
Specifies that \fIipptool\fR must connect to the printer or server using IPv4.
.TP 5
-6
Specifies that \fIipptool\fR must connect to the printer or server using IPv6.
.TP 5
-C
Specifies that requests should be sent using the HTTP/1.1 "Transfer-Encoding: chunked" header, which is required for conformance by all versions of IPP. The default is to use "Transfer-Encoding: chunked" for requests with attached files and "Content-Length:" for requests without attached files.
.TP 5
-E
Forces TLS encryption when connecting to the server using the HTTP "Upgrade" header.
.TP 5
-I
Specifies that \fIipptool\fR will continue past errors.
.TP 5
-L
Specifies that requests should be sent using the HTTP/1.0 "Content-Length:" header, which is required for conformance by all versions of IPP. The default is to use "Transfer-Encoding: chunked" for requests with attached files and "Content-Length:" for requests without attached files.
.TP 5
-S
Forces (dedicated) SSL encryption when connecting to the server.
.TP 5
-T seconds
Specifies a timeout for IPP requests in seconds.
.TP 5
-V version
Specifies the default IPP version to use: 1.0, 1.1, 2.0, 2.1, or 2.2. If not specified, version 1.1 is used.
.TP 5
-X
Specifies that XML (Apple plist) output is desired instead of the plain text report. This option is incompatible with the \fI-i\fR (interval) and \fI-n\fR (repeat-count) options.
.TP 5
-c
Specifies that CSV (comma-separated values) output is desired instead of the plain text output.
.TP 5
-d name=value
Defines the named variable.
.TP 5
-f filename
Defines the default request filename for tests.
.TP 5
-i seconds
Specifies that the (last) file should be repeated at the specified interval. This option is incompatible with the \fI-X\fR (XML plist output) option.
.TP 5
-l
Specifies that plain text output is desired.
.TP 5
-n repeat-count
Specifies that the (last) file should be repeated the specified number of times. This option is incompatible with the \fI-X\fR (XML plist output) option.
.TP 5
-t
Specifies that CUPS test report output is desired instead of the plain text output.
.TP 5
-v
Specifies that all request and response attributes should be output in CUPS test mode (\fI-t\fR). This is the default for XML output.
.SH EXIT CODE
The \fIipptool\fR program returns 0 if all tests were sucessful and 1 otherwise.
.SH COMPATIBILITY
The \fIipptool\fR program is unique to CUPS.
.SH EXAMPLES
Get a list of completed jobs for "myprinter":
.nf
    ipptool ipp://localhost/printers/myprinter get-completed-jobs.test
.fi
.LP
Send email notifications to "user@example.com" when "myprinter" changes:
.nf
    ipptool -d recipient=mailto:user@example.com \
        ipp://localhost/printers/myprinter create-printer-subscription.test
.fi
.SH STANDARD FILES
The following standard files are available:
.nf
    color.jpg
    create-printer-subscription.test
    document-a4.pdf
    document-a4.ps
    document-letter.pdf
    document-letter.ps
    get-completed-jobs.test
    get-jobs.test
    get-notifications.test
    get-printer-attributes.test
    get-subscriptions.test
    gray.jpg
    ipp-1.1.test
    ipp-2.0.test
    ipp-2.1.test
    ipp-2.2.test
    ipp-everywhere.test
    onepage-a4.pdf
    onepage-a4.ps
    onepage-letter.pdf
    onepage-letter.ps
    print-job.test
    print-job-deflate.test
    print-job-gzip.test
    testfile.jpg
    testfile.pcl
    testfile.pdf
    testfile.ps
    testfile.txt
    validate-job.test
.fi
.SH SEE ALSO
\fIipptoolfile(5)\fR, RFC 2911,
.br
http://localhost:631/help
.br
http://www.iana.org/assignments/ipp-registrations
.br
http://www.pwg.org/ipp
.SH COPYRIGHT
Copyright 2007-2014 by Apple Inc.
.\"
.\" End of "$Id: ipptool.man 11642 2014-02-27 15:57:59Z msweet $".
.\"
