/*
 * PT
 * Copyright (C) 2002  The Printing Tool Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * printsys.c
 */

#ifndef PRINTSYS_H
#define PRINTSYS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <time.h>
#include <cups/cups.h>
#include <gtk/gtk.h>

#ifndef DEFINITIONS_H
#include "definitions.h"
#endif /*DEFINITIONS_H*/


/*
 * typedef
 */

typedef gchar *print_job_t[12];

typedef gchar *dest_t[1];

typedef union
{
	gchar *dest;
	gint *priority;
}
multi_arg_t;

/*
 * functions
 */

gint p_get_jobs (print_job_t **j, const gchar *host, gint port,
	const gchar *username, http_encryption_t ssl, gint allocation,
	const gchar *filter_dest);
gchar *p_time (const time_t *t);
gchar *p_jstate (ipp_jstate_t state);
void p_free_jobs (print_job_t *j, gint n);
void p_multi_request (const gint *selected_row, gint r,
	const gchar *host, gint port, const gchar *username,
	http_encryption_t ssl, ipp_op_t w, const multi_arg_t multi_arg);
gint p_get_dests (dest_t **dest, const gchar *host, gint port,
	const gchar *username, http_encryption_t ssl, gint allocation);

#endif /*PRINTSYS_H*/
