
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: redirect.m,v 1.2 2000/08/12 11:06:50 stes Exp $
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include <Object.h>
#include <ocstring.h>
#include "redirect.h"
#include "process.h"

@implementation Redirection

- what:(STR)w
{
  what = w;return self;
}

- digit:w
{
  char *p = [w str];
  while (*p && (*p == ' ' || *p == '\t')) { p++; }
  digit = [String str:p];
  return self;
}

- word:w
{
  char *p = [w str];
  while (*p && (*p == ' ' || *p == '\t')) { p++; }
  word = [String str:p];
  return self;
}

- openproc:proc
{
  id b;

  assert(what);
  assert([word str]);

  fd = -1;

  if (!strcmp(what,">")) {
     fd = open([word str],O_WRONLY|O_CREAT|O_TRUNC,00666);
     if (digit == nil) [proc setdstfd:fd];
     if ([digit asInt] == 2) [proc seterrfd:fd];
  }
  if (!strcmp(what,">>")) {
     fd = open([word str],O_WRONLY|O_CREAT|O_APPEND,00666);
     if (digit == nil) [proc setdstfd:fd];
     if ([digit asInt] == 2) [proc seterrfd:fd];
  }
  if (!strcmp(what,"<")) {
     fd = open([word str],O_RDONLY);
     [proc setsrcfd:fd];
  }
  if (digit==nil && (!strcmp(what,">&") || !strcmp(what,"&<"))) {
     fd = open([word str],O_WRONLY|O_CREAT|O_TRUNC,00666);
     [proc setdstfd:fd];
     [proc seterrfd:fd];
  }
  if (digit!=nil && !strcmp(what,">&")) {
     int ifd = [word asInt];
     int ofd = [digit asInt];
     if (ifd == 1 && ofd == 2) {
       if ((b=[proc dstbuf])) {
         [proc seterrbuf:b];
       } else {
         [proc seterrfd:[proc dstfd]];
       }
     }
     if (ifd == 2 && ofd == 1) {
       if ((b=[proc errbuf])) {
         [proc setdstbuf:b];
       } else {
         [proc setdstfd:[proc errfd]];
       }
     }
  }

  return self;
}

- close
{
  if (fd >= 0) {
    int ok = close(fd);
    assert(ok == 0);
  }
  return self;
} 

@end

