
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: stmtlist.m,v 1.2 2000/08/12 15:27:22 stes Exp $
 */

#include <assert.h>
#include <stdlib.h>
#include <ctype.h>
#include <curses.h>
#include <signal.h>
#include <limits.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <Object.h>
#include <ordcltn.h>
#include <ocstring.h>
#include "process.h"
#include "stmt.h"
#include "stmtlist.h"
#include "cursel.h"
#include "doubleq.h"
#include "singleq.h"
#include "redirect.h"

static BOOL canignore(char*s)
{
  int i,n;
  for(i=0,n=strlen(s);i<n;i++) if (!isspace(s[i])) return NO;
  return YES;
}

id mkstmtlist(id lhs,id rhs)
{
  if ([lhs isKindOf:(id)[StatementList class]]) {
    return [lhs add:rhs];
  } else {
    return [[[StatementList new] add:lhs] add:rhs];
  }
}

@implementation StatementList

- add:x
{
  if (x == nil || ([x isKindOf:(id)[String class]] && canignore([x str]))) {
    return self;
  } else {
    if (!stmts) stmts=[OrdCltn new];
    assert([x isKindOf:(id)[Process class]]);
    [stmts add:x];
  }
  return self;
}

- go
{
  int r = 0;
  int i,n,ok;
  assert(makepipe == NO);
  for(i=0,n=[stmts size];i<n;i++) {
    id stmt = [stmts at:i];
    [stmt setsrcfd:srcfd];
    if (dstbuf) {[stmt setdstbuf:dstbuf];} else {[stmt setdstfd:dstfd];}
    if (errbuf) {[stmt seterrbuf:errbuf];} else {[stmt seterrfd:errfd];}
    [stmt go];
    r = [stmt exitcode]; /* sync */
  }
  exitcode = r;
  return self;
}

@end

