
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: var.m,v 1.2 2000/08/12 16:02:13 stes Exp $
 */

#include <Object.h>
#include <ocstring.h>
#include <ordcltn.h>
#include <dictnary.h>
#include "var.h"

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "cursel.h"

id mkvar(char *s)
{
  return [[Var new] name:[String str:s]];
}

@implementation Var

static id vardic;

+ define:(STR)n as:val env:(BOOL)senv filename:(STR)fn
{
  char *s;

  if (!vardic) vardic = [Dictionary new];

  [vardic atKeySTR:n put:val];

  s = [val str];
  dbg("defining '%s' as '%s'\n",n,s);
  if (senv) {
    id buf = [String sprintf:"%s=%s",n,s];
    putenv([buf str]);
  }

  if (fn) {
    FILE *f = fopen(fn,"a");
    if (f) {
       fprintf(f,"%s=%s\n",n,s);
       fclose(f);
    } else {
       fprintf(stderr,"Cannot open %s for writing",fn);
    }
  }

  return self;
}

+ define:(STR)n as:val filename:(STR)fn
{
  return [self define:n as:val env:NO filename:fn];
}

+ define:(STR)n as:val env:(BOOL)senv
{
  return [self define:n as:val env:senv filename:NULL];
}

+ define:(STR)n as:val
{
  return [self define:n as:val env:NO];
}

+ undefineIfDefined:n
{
  dbg("undefining %s\n",[n str]);
  if ([vardic atKey:n]) [vardic removeKey:n];
  unsetenv([n str]);
  return self;
}

+ undefine:(STR)n
{
  return [self undefineIfDefined:[String str:n]];
}

- defaultval:v
{
  defaultval = v;
  return self;
}

- name:v
{
  name = v;
  return self;
}

- fromfile:v
{
  fromfile = v;
  return self;
}

- (STR)str
{
  id v;
  STR s;
  STR n = [name str];
  dbg("looking up value for '%s'\n",n);
  if ((v=[vardic atKeySTR:n])) return [v str];
  if ((s=getenv(n))) return s;
  return (defaultval)?[expandstr(defaultval) str]:"";
}

static id argn;

+ defargs:v
{
  int i,n;
  if (!argn) argn=[OrdCltn new];
  for(i=[argn size],n=[v size];i<n;i++) {
    [argn add:[String sprintf:"ARG%i",i+1]];
  }
  for(i=0,n=[v size];i<n;i++) {
    [Var define:[[argn at:i] str] as:[v at:i]];
  }
  return self;
}

+ undefargs
{
  int i,n;
  for(i=0,n=[argn size];i<n;i++) {
    [Var undefineIfDefined:[argn at:i]];
  }
  return self;
}

@end

