/***************************************************************************
                          pfaditerator.cpp  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "inkompatibel.h"

#include <cstdlib>
#include <cstdio>
#include <cstring>

#include "fehler.h"
#include "pfaditerator.h"
#include "cuyointl.h"


#define pfad_default 0
#define pfad_aktueller 1
#define pfad_uninstalliert 2
#define pfad_installation 3
#define anz_pfade 4


__String PfadIterator::mLokalPfad;
int PfadIterator::mDefaultPfad = 1;


PfadIterator::PfadIterator(__String dat, bool setzDefault /*= false*/):
  mPos(0), mDatei(dat), mSetzDefault(setzDefault)
{
}
PfadIterator::~PfadIterator() {
  /** Soll der default-Pfad gesetzt werden? */
  if (mSetzDefault)
    if (mPos != pfad_default && mPos < anz_pfade)
      mDefaultPfad = mPos;
}


/** Nchster Pfad */
PfadIterator & PfadIterator::operator++() {
  mPos++;

  /* Nicht noch ein zweites Mal im Default-Pfad suchen */
  if (mPos == mDefaultPfad) mPos++;

  if (mPos >= anz_pfade) {
    __String t;
    t.sprintf(_("Could not load \"%s\"."), mDatei.data());
    throw Fehler(t);
  }
  return *this;
}

	
/** Aktueller Pfad */
__String PfadIterator::pfad() const {
  __String r;

  /* Als erstes im default-Pfad nachschauen */
  int n = mPos;
  if (n == pfad_default) n = mDefaultPfad;

  switch (n) {
  case pfad_installation:
    /* PKGDATADIR wird mit -D bergeben. (Siehe src/Makefile.am)
       Unter WIN32 wird PKGDATADIR als "cuyo-x.xx\\data" definiert,
       falls es nicht bergeben wurde. */
    r.sprintf("%s/%s", PKGDATADIR, mDatei.data());
    break;
  case pfad_uninstalliert:
    r.sprintf("%s../data/%s", mLokalPfad.data(), mDatei.data());
    break;
  case pfad_aktueller:
    r.sprintf("./%s", mDatei.data());
    break;
  default:
    ASSERT(false);
  }
  // Debug-Ausgabe:
  // printf("%s\n", r.data());fflush(stdout);
  return r;
}



/** Muss einmal am Anfang von main() aufgerufen werden */
void PfadIterator::init(int argc, char ** argv) {
  char * a = argv[0];
  char * e = a + strlen(a);
  /* Alles nach dem letzten '/' abschneiden */
  while (e != a && *e != '/')
    e--;
  if (*e == '/') e++;

  mLokalPfad = __String(a, e - a + 1); // +1, weil man ein '\0' am ende mitrechnen muss!
}
