/***************************************************************************
                          code.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CODE_H
#define CODE_H


#include <cstdlib>
#include <cstdio>

#include <qstring.h>

#include "inkompatibel.h"
#include "definition.h"



#define undefiniert_code 0
#define stapel_code 1
#define push_code 2
#define mal_code 5
#define mal_code_relativ 6
#define nop_code 7
#define folge_code 8
#define buchstabe_code 9
#define zahl_code 10
#define bedingung_code 11
/* Die nachfolgenden 6 Codes sind von der Art "bla X= blub". */
#define set_code 12
#define add_code 13
#define sub_code 14
#define mul_code 15
#define div_code 16
#define mod_code 17
#define busy_code 18
#define bonus_code 19
#define message_code 20
#define explode_code 21

/* Ausdrucks-Codeen */
#define variable_acode 30
#define zahl_acode 31
#define manchmal_acode 32
#define nachbar_acode 33
#define intervall_acode 35
#define und_acode 37
#define oder_acode 38
#define not_acode 39
#define rnd_acode 40
#define add_acode 41
#define sub_acode 42
#define mul_acode 43
#define div_acode 44
#define mod_acode 45
#define neg_acode 46
#define eq_acode 50
#define ne_acode 51
#define gt_acode 52
#define lt_acode 53
#define ge_acode 54
#define le_acode 55


/* Konstanten fr die verschiedenen Pfeilsorten bei Entscheidungscodeen.
   Man bergebe als Zahl an den Constructor fr Entscheidungscodeen
     xxx_merk_pfeil + 2 * yyy_merk_pfeil,
   wenn der Code folgendermaen aussieht:
   {
     bla xxx> blub1;
     yyy> blub2;
   } */
#define ohne_merk_pfeil 0  // ->
#define mit_merk_pfeil 1   // =>
//#define erster_pfeil 1
//#define zweiter_pfeil 2


class Variable;
class Blop;
class DefKnoten;

/** Ein Cual-Code-Baum. Diese Bume werden beim Parsen der ld-Dateien
    erzeugt und dann erst mal in Knoten abgespeichert. Wenn ein Level
    geladen wird, werden die entsprechenden Code-Pointer in die Sorten-
    Objekte gespeichert.
    Code-Objekte, die eigene interne Variablen brauchen (busy-Flag),
    reservieren sich schon bei ihrer Erzeugung die Variablen-Nummern.
    (Normale Variablen-Nummern werden allerdings von VarDefinition
    reserviert.)
*/
class Code: public Definition {

  int mArt;

  /** Nr. der Bool-Var, die angibt, ob der Code "beschaeftigt" ist. */
  int mBeschaeftigtNr;

  /** Datei, in der dieser Code definiert wurde (fr Fehlermeldungen) */
  __String mDateiName;
  /** Zeilen-Nr, in der dieser Code definiert wurde (fr Fehlermeldungen) */
  int mZeilenNr;

  Code * mF1;
  Code * mF2;
  Code * mF3;
  Variable * mVar1;
  Variable * mVar2;
  int mZahl;
  int mZahl2;
  __String mString;
  
  
public:

  /* Die ganzen (normalen) Konstruktoren brauchen alle ein paar Standard-
     Parameter, die ich nicht jedes mal tippen will... */
     
#define STDPAR DefKnoten * knoten, __String datna, int znr, int art

  Code(STDPAR);
  
  Code(STDPAR, int zahl, int zahl2 = 0);

  Code(STDPAR, Variable * v1);

  Code(STDPAR, Variable * v1, Variable * v2);

  Code(STDPAR, Variable * v1, int zahl);

  Code(STDPAR, Code * f1, Variable * v1);

  Code(STDPAR, Code * f1, int zahl = 0, int zahl2 = 0);
  
  Code(STDPAR, Code * f1, Code * f2, Code * f3 = 0, int zahl = 0);
  
  Code(STDPAR, Code * f1, Code * f2, Variable * v1);

  Code(STDPAR, __String str);
  
#undef STDPAR

  Code(const Code & f);
  
  
  ~Code() {
    deepLoesch();
  }
  
  /** Noch provisorisch. Am besten die print-Routinen von
      Knoten durch toString() ersetzen. */
  //void print() const { printf("%s\n", toString().data()); }
  
  
  Code & operator= (const Code & f) {
    deepLoesch();
    kopiere(f);
    return *this;
  }
  
  
  private:
  
  void deepLoesch();
  
  
  void kopiere(const Code & f);
  
  
  /* Wird von eval vom Vater aufgerufen, wenn er wissen will, ob
     das Kind beschftigt ist. */
  bool istBeschaeftigt(Blop & b) const;

  /** Setzt, ob dieser Code beschftigt ist. Wird von eval()
      aufgerufen. */
  void setBeschaeftigt(Blop & b, bool besch) const;

  /** Liefert einen String zurck, der angibt, wo dieser Code
      definiert wurde (fr Fehlermeldungen) */
  __String getDefString() const;

  public:
  

  /** Liefert zurck, wie viele Bilder dieser Code hchstens gleichzeitig
      malt. Dabei wird (im Moment) der Einfachheit halber davon ausgegangen,
      dass Ausdrcke nix malen knnen; dementsprechend darf getAnzBilder()
      dafr auch nicht aufgerufen werden. nsh wird um die Anzahl der
      Nachbarstapel-Malungen erhht. */
  int getStapelHoehe(int & nsh) const;
    



  int eval(Blop & b) const;

  /** Setzt das Busy-Flag dieses Codes auf false zurck (ggf. rekursiv).
      Erwartet, dass aus (x busy) auch (vater-von-x busy) folgt. */
  void busyReset(Blop & b) const;

  
};


/** Erzeugt einen Code, der prft, ob es die
    gewnschten Nachbarn gibt (aus "01?"-String).
    Der "01?"-String kann Lnge 6 oder 8 haben. */
Code * newNachbarCode(DefKnoten * knoten, __String datna, int znr,
                      __String * str);


#endif
