/***************************************************************************
                          tastenbtn.cpp  -  description
                             -------------------
    begin                : Wed Jun 6 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdio>
#include <qkeycode.h>
#include "tastenbtn.h"

TastenBtn::TastenBtn(QWidget *parent, const char *name ) : QPushButton(name,parent) {
//QButton(parent, name) {
	setMinimumSize(40, 30);
	resize(40, 30);
	//connect(this, SIGNAL(clicked()), SLOT(klick()));
	setFocusPolicy(QWidget::StrongFocus);
}
TastenBtn::~TastenBtn(){
}
/** Wenn der Benutzer eine Taste drckt, wird der
Text dieses Buttons auf die Taste gesetzt... */
void TastenBtn::keyPressEvent(QKeyEvent * e ){
	int t = e->key();
	if (t != Key_Return && t != Key_Enter && t != Key_Tab && t != Key_Backtab)
		setTaste(t);
	else
		e->ignore();
}
/** Setzt die angezeigte Taste auf code. */
void TastenBtn::setTaste(int code){
	mTastenCode = code;
	char s[111];
	if (code >= 32 && code < 255)
		sprintf(s, "%c", code);
	else {
		switch (code) {
		case Key_Left: sprintf(s, "<-"); break;
		case Key_Right: sprintf(s, "->"); break;
		case Key_Up: sprintf(s, "up"); break;
		case Key_Down: sprintf(s, "dn"); break;
		default: sprintf(s, "??"); break;
		}
	}
	setText(s);
	setMinimumSize(40, 30);
	resize(40, 30);
}

/** Liefert den aktuell angezeigten Tastencode. */
int TastenBtn::getTaste() const {
	return mTastenCode;
}
