/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : ../../../../src/parser/smt2/Smt2.g
 *     -                            On : 2018-06-25 14:34:30
 *     -                for the parser : Smt2ParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2016 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "Smt2Parser.h"


#include <set>
#include <sstream>
#include <string>
#include <unordered_set>
#include <vector>

#include "base/output.h"
#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "options/set_language.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"
#include "parser/smt2/smt2.h"
#include "util/floatingpoint.h"
#include "util/hash.h"
#include "util/integer.h"
#include "util/rational.h"
// \todo Review the need for this header
#include "math.h"

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which
 * will be defined by ANTLR *after* this section. (If they were functions,
 * PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Smt2*)PARSER->super)
#undef EXPR_MANAGER
#define EXPR_MANAGER PARSER_STATE->getExprManager()
#undef MK_EXPR
#define MK_EXPR EXPR_MANAGER->mkExpr
#undef MK_CONST
#define MK_CONST EXPR_MANAGER->mkConst
#define UNSUPPORTED PARSER_STATE->unimplementedFeature

static bool isClosed(const Expr& e, std::set<Expr>& free, std::unordered_set<Expr, ExprHashFunction>& closedCache) {
  if(closedCache.find(e) != closedCache.end()) {
    return true;
  }

  if(e.getKind() == kind::FORALL || e.getKind() == kind::EXISTS || e.getKind() == kind::LAMBDA) {
    isClosed(e[1], free, closedCache);
    for(Expr::const_iterator i = e[0].begin(); i != e[0].end(); ++i) {
      free.erase(*i);
    }
  } else if(e.getKind() == kind::BOUND_VARIABLE) {
    free.insert(e);
    return false;
  } else {
    if(e.hasOperator()) {
      isClosed(e.getOperator(), free, closedCache);
    }
    for(Expr::const_iterator i = e.begin(); i != e.end(); ++i) {
      isClosed(*i, free, closedCache);
    }
  }

  if(free.empty()) {
    closedCache.insert(e);
    return true;
  } else {
    return false;
  }
}

static inline bool isClosed(const Expr& e, std::set<Expr>& free) {
  std::unordered_set<Expr, ExprHashFunction> cache;
  return isClosed(e, free, cache);
}  
  

/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pSmt2Parser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pSmt2Parser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pSmt2Parser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pSmt2Parser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   Smt2ParserTokenNames[163+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ALPHA",
        (pANTLR3_UINT8) "AMPERSAND_TOK",
        (pANTLR3_UINT8) "AND_TOK",
        (pANTLR3_UINT8) "ASSERT_TOK",
        (pANTLR3_UINT8) "AS_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_INST_LEVEL",
        (pANTLR3_UINT8) "ATTRIBUTE_NAMED_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_NO_PATTERN_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_PATTERN_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_RR_PRIORITY",
        (pANTLR3_UINT8) "ATTRIBUTE_TOK",
        (pANTLR3_UINT8) "AT_TOK",
        (pANTLR3_UINT8) "BINARY_LITERAL",
        (pANTLR3_UINT8) "BV2NAT_TOK",
        (pANTLR3_UINT8) "CHECK_SAT_ASSUMING_TOK",
        (pANTLR3_UINT8) "CHECK_SAT_TOK",
        (pANTLR3_UINT8) "CHECK_SYNTH_TOK",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "CONSTRAINT_TOK",
        (pANTLR3_UINT8) "CONST_TOK",
        (pANTLR3_UINT8) "DECIMAL_LITERAL",
        (pANTLR3_UINT8) "DECLARE_CODATATYPES_2_5_TOK",
        (pANTLR3_UINT8) "DECLARE_CODATATYPES_TOK",
        (pANTLR3_UINT8) "DECLARE_CODATATYPE_TOK",
        (pANTLR3_UINT8) "DECLARE_CONST_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPES_2_5_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPES_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPE_TOK",
        (pANTLR3_UINT8) "DECLARE_FUNS_TOK",
        (pANTLR3_UINT8) "DECLARE_FUN_TOK",
        (pANTLR3_UINT8) "DECLARE_PREDS_TOK",
        (pANTLR3_UINT8) "DECLARE_PRIMED_VAR_TOK",
        (pANTLR3_UINT8) "DECLARE_SORTS_TOK",
        (pANTLR3_UINT8) "DECLARE_SORT_TOK",
        (pANTLR3_UINT8) "DECLARE_VAR_TOK",
        (pANTLR3_UINT8) "DEFINE_CONST_TOK",
        (pANTLR3_UINT8) "DEFINE_FUNS_REC_TOK",
        (pANTLR3_UINT8) "DEFINE_FUN_REC_TOK",
        (pANTLR3_UINT8) "DEFINE_FUN_TOK",
        (pANTLR3_UINT8) "DEFINE_SORT_TOK",
        (pANTLR3_UINT8) "DEFINE_TOK",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "DISTINCT_TOK",
        (pANTLR3_UINT8) "DIVISIBLE_TOK",
        (pANTLR3_UINT8) "DIV_TOK",
        (pANTLR3_UINT8) "DTSIZE_TOK",
        (pANTLR3_UINT8) "ECHO_TOK",
        (pANTLR3_UINT8) "EMPTYSET_TOK",
        (pANTLR3_UINT8) "EQUAL_TOK",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXIT_TOK",
        (pANTLR3_UINT8) "FMFCARDVAL_TOK",
        (pANTLR3_UINT8) "FMFCARD_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "FP_NAN_TOK",
        (pANTLR3_UINT8) "FP_NINF_TOK",
        (pANTLR3_UINT8) "FP_NZERO_TOK",
        (pANTLR3_UINT8) "FP_PINF_TOK",
        (pANTLR3_UINT8) "FP_PZERO_TOK",
        (pANTLR3_UINT8) "FP_RNA_FULL_TOK",
        (pANTLR3_UINT8) "FP_RNA_TOK",
        (pANTLR3_UINT8) "FP_RNE_FULL_TOK",
        (pANTLR3_UINT8) "FP_RNE_TOK",
        (pANTLR3_UINT8) "FP_RTN_FULL_TOK",
        (pANTLR3_UINT8) "FP_RTN_TOK",
        (pANTLR3_UINT8) "FP_RTP_FULL_TOK",
        (pANTLR3_UINT8) "FP_RTP_TOK",
        (pANTLR3_UINT8) "FP_RTZ_FULL_TOK",
        (pANTLR3_UINT8) "FP_RTZ_TOK",
        (pANTLR3_UINT8) "FP_TO_FPBV_TOK",
        (pANTLR3_UINT8) "FP_TO_FPFP_TOK",
        (pANTLR3_UINT8) "FP_TO_FPR_TOK",
        (pANTLR3_UINT8) "FP_TO_FPS_TOK",
        (pANTLR3_UINT8) "FP_TO_FPU_TOK",
        (pANTLR3_UINT8) "FP_TO_FP_TOK",
        (pANTLR3_UINT8) "FP_TO_SBV_TOK",
        (pANTLR3_UINT8) "FP_TO_UBV_TOK",
        (pANTLR3_UINT8) "GET_ASSERTIONS_TOK",
        (pANTLR3_UINT8) "GET_ASSIGNMENT_TOK",
        (pANTLR3_UINT8) "GET_INFO_TOK",
        (pANTLR3_UINT8) "GET_MODEL_TOK",
        (pANTLR3_UINT8) "GET_OPTION_TOK",
        (pANTLR3_UINT8) "GET_PROOF_TOK",
        (pANTLR3_UINT8) "GET_QE_DISJUNCT_TOK",
        (pANTLR3_UINT8) "GET_QE_TOK",
        (pANTLR3_UINT8) "GET_UNSAT_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "GET_UNSAT_CORE_TOK",
        (pANTLR3_UINT8) "GET_VALUE_TOK",
        (pANTLR3_UINT8) "GREATER_THAN_EQUAL_TOK",
        (pANTLR3_UINT8) "GREATER_THAN_TOK",
        (pANTLR3_UINT8) "HEX_DIGIT",
        (pANTLR3_UINT8) "HEX_LITERAL",
        (pANTLR3_UINT8) "HO_ARROW_TOK",
        (pANTLR3_UINT8) "HO_LAMBDA_TOK",
        (pANTLR3_UINT8) "IMPLIES_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "INDEX_TOK",
        (pANTLR3_UINT8) "INST_CLOSURE_TOK",
        (pANTLR3_UINT8) "INT2BV_TOK",
        (pANTLR3_UINT8) "INTEGER_LITERAL",
        (pANTLR3_UINT8) "INV_CONSTRAINT_TOK",
        (pANTLR3_UINT8) "ITE_TOK",
        (pANTLR3_UINT8) "KEYWORD",
        (pANTLR3_UINT8) "LESS_THAN_EQUAL_TOK",
        (pANTLR3_UINT8) "LESS_THAN_TOK",
        (pANTLR3_UINT8) "LET_TOK",
        (pANTLR3_UINT8) "LPAREN_TOK",
        (pANTLR3_UINT8) "MATCH_TOK",
        (pANTLR3_UINT8) "META_INFO_TOK",
        (pANTLR3_UINT8) "MINUS_TOK",
        (pANTLR3_UINT8) "NILREF_TOK",
        (pANTLR3_UINT8) "NOT_TOK",
        (pANTLR3_UINT8) "NUMERAL",
        (pANTLR3_UINT8) "OR_TOK",
        (pANTLR3_UINT8) "PAR_TOK",
        (pANTLR3_UINT8) "PLUS_TOK",
        (pANTLR3_UINT8) "POP_TOK",
        (pANTLR3_UINT8) "PROPAGATION_RULE_TOK",
        (pANTLR3_UINT8) "PUSH_TOK",
        (pANTLR3_UINT8) "QUOTED_SYMBOL",
        (pANTLR3_UINT8) "REALLCHAR_TOK",
        (pANTLR3_UINT8) "REAL_PI_TOK",
        (pANTLR3_UINT8) "REDUCTION_RULE_TOK",
        (pANTLR3_UINT8) "RENOSTR_TOK",
        (pANTLR3_UINT8) "RESET_ASSERTIONS_TOK",
        (pANTLR3_UINT8) "RESET_TOK",
        (pANTLR3_UINT8) "REWRITE_RULE_TOK",
        (pANTLR3_UINT8) "RPAREN_TOK",
        (pANTLR3_UINT8) "SET_INFO_TOK",
        (pANTLR3_UINT8) "SET_LOGIC_TOK",
        (pANTLR3_UINT8) "SET_OPTIONS_TOK",
        (pANTLR3_UINT8) "SET_OPTION_TOK",
        (pANTLR3_UINT8) "SIMPLE_SYMBOL",
        (pANTLR3_UINT8) "SIMPLIFY_TOK",
        (pANTLR3_UINT8) "STAR_TOK",
        (pANTLR3_UINT8) "STRING_LITERAL_2_0",
        (pANTLR3_UINT8) "STRING_LITERAL_2_5",
        (pANTLR3_UINT8) "SYGUS_CONSTANT_TOK",
        (pANTLR3_UINT8) "SYGUS_ENUM_CONS_TOK",
        (pANTLR3_UINT8) "SYGUS_ENUM_TOK",
        (pANTLR3_UINT8) "SYGUS_INPUT_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYGUS_LET_TOK",
        (pANTLR3_UINT8) "SYGUS_LOCAL_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYGUS_QUOTED_LITERAL",
        (pANTLR3_UINT8) "SYGUS_VARIABLE_TOK",
        (pANTLR3_UINT8) "SYMBOL_CHAR",
        (pANTLR3_UINT8) "SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE",
        (pANTLR3_UINT8) "SYNTH_FUN_TOK",
        (pANTLR3_UINT8) "SYNTH_INV_TOK",
        (pANTLR3_UINT8) "TESTER_TOK",
        (pANTLR3_UINT8) "TUPLE_CONST_TOK",
        (pANTLR3_UINT8) "TUPLE_SEL_TOK",
        (pANTLR3_UINT8) "UNIVSET_TOK",
        (pANTLR3_UINT8) "UNTERMINATED_QUOTED_SYMBOL",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "XOR_TOK",
        (pANTLR3_UINT8) "'\\\\'",
        (pANTLR3_UINT8) "'extract'",
        (pANTLR3_UINT8) "'repeat'",
        (pANTLR3_UINT8) "'rotate_left'",
        (pANTLR3_UINT8) "'rotate_right'",
        (pANTLR3_UINT8) "'sign_extend'",
        (pANTLR3_UINT8) "'zero_extend'"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::parser::smt2::myExpr
	parseExpr    (pSmt2Parser ctx);
static 
 CVC4::Command*
	parseCommand    (pSmt2Parser ctx);
static 
 CVC4::Command*
	parseSygus    (pSmt2Parser ctx);
static 
 void
	command    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	sygusCommand    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	sygusGTerm    (pSmt2Parser ctx, CVC4::SygusGTerm& sgt, std::string& fun);
static 
 void
	metaInfoInternal    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	setOptionInternal    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	smt25Command    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	extendedCommand    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	datatypes_2_5_DefCommand    (pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	datatypeDefCommand    (pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	datatypesDefCommand    (pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	datatypesDef    (pSmt2Parser ctx, bool isCo, const std::vector<std::string>& dnames, const std::vector<int>& arities, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	rewriterulesCommand    (pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd);
static 
 void
	rewritePropaKind    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	pattern    (pSmt2Parser ctx, CVC4::Expr& expr);
static 
 void
	simpleSymbolicExprNoKeyword    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	keyword    (pSmt2Parser ctx, std::string& s);
static 
 void
	simpleSymbolicExpr    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	symbolicExpr    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	term    (pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& expr2);
static 
 void
	termNonVariable    (pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& expr2);
static 
 void
	attribute    (pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& retExpr, std::string& attr);
static 
 void
	indexedFunctionName    (pSmt2Parser ctx, CVC4::Expr& op, CVC4::Kind& kind);
static 
 void
	badIndexedFunctionName    (pSmt2Parser ctx);
static 
 void
	termList    (pSmt2Parser ctx, std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr);
static 
 void
	str    (pSmt2Parser ctx, std::string& s, bool fsmtlib);
static 
 void
	builtinOp    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	quantOp    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	functionName    (pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check);
static 
 void
	sortList    (pSmt2Parser ctx, std::vector<CVC4::Type>& sorts);
static 
 void
	nonemptySortList    (pSmt2Parser ctx, std::vector<CVC4::Type>& sorts);
static 
 void
	sortedVarList    (pSmt2Parser ctx, std::vector<std::pair<std::string, CVC4::Type> >& sortedVars);
static 
 void
	sortName    (pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check);
static 
 void
	sortSymbol    (pSmt2Parser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	symbolList    (pSmt2Parser ctx, std::vector<std::string>& names, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	symbol    (pSmt2Parser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	nonemptyNumeralList    (pSmt2Parser ctx, std::vector<uint64_t>& numerals);
static 
 void
	datatypeDef    (pSmt2Parser ctx, bool isCo, std::vector<CVC4::Datatype>& datatypes, std::vector< CVC4::Type >& params);
static 
 void
	constructorDef    (pSmt2Parser ctx, CVC4::Datatype& type);
static 
 void
	selector    (pSmt2Parser ctx, CVC4::DatatypeConstructor& ctor);
static void	Smt2ParserFree(pSmt2Parser ctx);
static void     Smt2ParserReset (pSmt2Parser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "../../../../src/parser/smt2/Smt2.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new Smt2Parser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSmt2Parser
Smt2ParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return Smt2ParserNewSSD(instream, NULL);
}

/** \brief Create a new Smt2Parser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSmt2Parser
Smt2ParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pSmt2Parser ctx;	    /* Context structure we will build and return   */

    ctx	= (pSmt2Parser) ANTLR3_CALLOC(1, sizeof(Smt2Parser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in Smt2Parser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our Smt2Parser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->parseSygus	= parseSygus;
    ctx->command	= command;
    ctx->sygusCommand	= sygusCommand;
    ctx->sygusGTerm	= sygusGTerm;
    ctx->metaInfoInternal	= metaInfoInternal;
    ctx->setOptionInternal	= setOptionInternal;
    ctx->smt25Command	= smt25Command;
    ctx->extendedCommand	= extendedCommand;
    ctx->datatypes_2_5_DefCommand	= datatypes_2_5_DefCommand;
    ctx->datatypeDefCommand	= datatypeDefCommand;
    ctx->datatypesDefCommand	= datatypesDefCommand;
    ctx->datatypesDef	= datatypesDef;
    ctx->rewriterulesCommand	= rewriterulesCommand;
    ctx->rewritePropaKind	= rewritePropaKind;
    ctx->pattern	= pattern;
    ctx->simpleSymbolicExprNoKeyword	= simpleSymbolicExprNoKeyword;
    ctx->keyword	= keyword;
    ctx->simpleSymbolicExpr	= simpleSymbolicExpr;
    ctx->symbolicExpr	= symbolicExpr;
    ctx->term	= term;
    ctx->termNonVariable	= termNonVariable;
    ctx->attribute	= attribute;
    ctx->indexedFunctionName	= indexedFunctionName;
    ctx->badIndexedFunctionName	= badIndexedFunctionName;
    ctx->termList	= termList;
    ctx->str	= str;
    ctx->builtinOp	= builtinOp;
    ctx->quantOp	= quantOp;
    ctx->functionName	= functionName;
    ctx->sortList	= sortList;
    ctx->nonemptySortList	= nonemptySortList;
    ctx->sortedVarList	= sortedVarList;
    ctx->sortName	= sortName;
    ctx->sortSymbol	= sortSymbol;
    ctx->symbolList	= symbolList;
    ctx->symbol	= symbol;
    ctx->nonemptyNumeralList	= nonemptyNumeralList;
    ctx->datatypeDef	= datatypeDef;
    ctx->constructorDef	= constructorDef;
    ctx->selector	= selector;
    ctx->free			= Smt2ParserFree;
    ctx->reset			= Smt2ParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = Smt2ParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
Smt2ParserReset (pSmt2Parser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 Smt2ParserFree(pSmt2Parser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return Smt2ParserTokenNames;
}


/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_parseExpr119  */
static	ANTLR3_BITWORD FOLLOW_term_in_parseExpr119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_parseExpr119	= { FOLLOW_term_in_parseExpr119_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr126  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr126_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr126	= { FOLLOW_EOF_in_parseExpr126_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand155  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand155_bits[]	= { ANTLR3_UINT64_LIT(0x00441FB7FE0C0080), ANTLR3_UINT64_LIT(0x470100000FFE0000), ANTLR3_UINT64_LIT(0x00000000000003B7) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand155	= { FOLLOW_LPAREN_TOK_in_parseCommand155_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_parseCommand157  */
static	ANTLR3_BITWORD FOLLOW_command_in_parseCommand157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_parseCommand157	= { FOLLOW_command_in_parseCommand157_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand160  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand160_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand160	= { FOLLOW_RPAREN_TOK_in_parseCommand160_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand173  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand173_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand173	= { FOLLOW_LPAREN_TOK_in_parseCommand173_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_parseCommand175  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_parseCommand175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000001800) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_parseCommand175	= { FOLLOW_INCLUDE_TOK_in_parseCommand175_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_parseCommand177  */
static	ANTLR3_BITWORD FOLLOW_str_in_parseCommand177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_parseCommand177	= { FOLLOW_str_in_parseCommand177_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand180  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand180	= { FOLLOW_RPAREN_TOK_in_parseCommand180_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand193  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand193	= { FOLLOW_EOF_in_parseCommand193_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseSygus222  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseSygus222_bits[]	= { ANTLR3_UINT64_LIT(0x00441FFFFE5C0080), ANTLR3_UINT64_LIT(0x470101000FFE0000), ANTLR3_UINT64_LIT(0x00000000018003B7) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseSygus222	= { FOLLOW_LPAREN_TOK_in_parseSygus222_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusCommand_in_parseSygus224  */
static	ANTLR3_BITWORD FOLLOW_sygusCommand_in_parseSygus224_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusCommand_in_parseSygus224	= { FOLLOW_sygusCommand_in_parseSygus224_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseSygus227  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseSygus227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseSygus227	= { FOLLOW_RPAREN_TOK_in_parseSygus227_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseSygus233  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseSygus233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseSygus233	= { FOLLOW_EOF_in_parseSygus233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_LOGIC_TOK_in_command261  */
static	ANTLR3_BITWORD FOLLOW_SET_LOGIC_TOK_in_command261_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_LOGIC_TOK_in_command261	= { FOLLOW_SET_LOGIC_TOK_in_command261_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command263  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command263	= { FOLLOW_symbol_in_command263_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_INFO_TOK_in_command282  */
static	ANTLR3_BITWORD FOLLOW_SET_INFO_TOK_in_command282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_INFO_TOK_in_command282	= { FOLLOW_SET_INFO_TOK_in_command282_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_metaInfoInternal_in_command284  */
static	ANTLR3_BITWORD FOLLOW_metaInfoInternal_in_command284_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_metaInfoInternal_in_command284	= { FOLLOW_metaInfoInternal_in_command284_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_INFO_TOK_in_command297  */
static	ANTLR3_BITWORD FOLLOW_GET_INFO_TOK_in_command297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_INFO_TOK_in_command297	= { FOLLOW_GET_INFO_TOK_in_command297_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command299  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command299	= { FOLLOW_KEYWORD_in_command299_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_OPTION_TOK_in_command317  */
static	ANTLR3_BITWORD FOLLOW_SET_OPTION_TOK_in_command317_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_OPTION_TOK_in_command317	= { FOLLOW_SET_OPTION_TOK_in_command317_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_setOptionInternal_in_command319  */
static	ANTLR3_BITWORD FOLLOW_setOptionInternal_in_command319_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_setOptionInternal_in_command319	= { FOLLOW_setOptionInternal_in_command319_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_OPTION_TOK_in_command332  */
static	ANTLR3_BITWORD FOLLOW_GET_OPTION_TOK_in_command332_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_OPTION_TOK_in_command332	= { FOLLOW_GET_OPTION_TOK_in_command332_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command334  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command334	= { FOLLOW_KEYWORD_in_command334_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_SORT_TOK_in_command352  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_SORT_TOK_in_command352_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_SORT_TOK_in_command352	= { FOLLOW_DECLARE_SORT_TOK_in_command352_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command366  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command366_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command366	= { FOLLOW_symbol_in_command366_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command381  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command381_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command381	= { FOLLOW_INTEGER_LITERAL_in_command381_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_SORT_TOK_in_command399  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_SORT_TOK_in_command399_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_SORT_TOK_in_command399	= { FOLLOW_DEFINE_SORT_TOK_in_command399_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command407  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command407	= { FOLLOW_symbol_in_command407_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command420  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command420_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command420	= { FOLLOW_LPAREN_TOK_in_command420_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolList_in_command422  */
static	ANTLR3_BITWORD FOLLOW_symbolList_in_command422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolList_in_command422	= { FOLLOW_symbolList_in_command422_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command425  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command425_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command425	= { FOLLOW_RPAREN_TOK_in_command425_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command437  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command437_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command437	= { FOLLOW_sortSymbol_in_command437_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_FUN_TOK_in_command456  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_FUN_TOK_in_command456_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_FUN_TOK_in_command456	= { FOLLOW_DECLARE_FUN_TOK_in_command456_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command464  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command464	= { FOLLOW_symbol_in_command464_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command477  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command477_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command477	= { FOLLOW_LPAREN_TOK_in_command477_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_command479  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_command479_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_command479	= { FOLLOW_sortList_in_command479_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command482  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command482_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command482	= { FOLLOW_RPAREN_TOK_in_command482_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command488  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command488_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command488	= { FOLLOW_sortSymbol_in_command488_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUN_TOK_in_command507  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUN_TOK_in_command507_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUN_TOK_in_command507	= { FOLLOW_DEFINE_FUN_TOK_in_command507_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command515  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command515_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command515	= { FOLLOW_symbol_in_command515_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command528  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command528_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command528	= { FOLLOW_LPAREN_TOK_in_command528_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_command530  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_command530_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_command530	= { FOLLOW_sortedVarList_in_command530_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command533  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command533_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command533	= { FOLLOW_RPAREN_TOK_in_command533_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command539  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command539_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command539	= { FOLLOW_sortSymbol_in_command539_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command552  */
static	ANTLR3_BITWORD FOLLOW_term_in_command552_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command552	= { FOLLOW_term_in_command552_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_VALUE_TOK_in_command571  */
static	ANTLR3_BITWORD FOLLOW_GET_VALUE_TOK_in_command571_bits[]	= { ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFF0), ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFFF), ANTLR3_UINT64_LIT(0x0000007FFFFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_VALUE_TOK_in_command571	= { FOLLOW_GET_VALUE_TOK_in_command571_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command581  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command581_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command581	= { FOLLOW_LPAREN_TOK_in_command581_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_command583  */
static	ANTLR3_BITWORD FOLLOW_termList_in_command583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_command583	= { FOLLOW_termList_in_command583_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command586  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command586	= { FOLLOW_RPAREN_TOK_in_command586_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_command602  */
static	ANTLR3_BITWORD FOLLOW_set_in_command602_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_command602	= { FOLLOW_set_in_command602_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ASSIGNMENT_TOK_in_command629  */
static	ANTLR3_BITWORD FOLLOW_GET_ASSIGNMENT_TOK_in_command629_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ASSIGNMENT_TOK_in_command629	= { FOLLOW_GET_ASSIGNMENT_TOK_in_command629_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERT_TOK_in_command649  */
static	ANTLR3_BITWORD FOLLOW_ASSERT_TOK_in_command649_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERT_TOK_in_command649	= { FOLLOW_ASSERT_TOK_in_command649_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command669  */
static	ANTLR3_BITWORD FOLLOW_term_in_command669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command669	= { FOLLOW_term_in_command669_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SAT_TOK_in_command688  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SAT_TOK_in_command688_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510002), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SAT_TOK_in_command688	= { FOLLOW_CHECK_SAT_TOK_in_command688_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command704  */
static	ANTLR3_BITWORD FOLLOW_term_in_command704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command704	= { FOLLOW_term_in_command704_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command745  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command745_bits[]	= { ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFF0), ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFFF), ANTLR3_UINT64_LIT(0x0000007FFFFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command745	= { FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command745_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command755  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command755_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command755	= { FOLLOW_LPAREN_TOK_in_command755_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_command757  */
static	ANTLR3_BITWORD FOLLOW_termList_in_command757_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_command757	= { FOLLOW_termList_in_command757_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command760  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command760_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command760	= { FOLLOW_RPAREN_TOK_in_command760_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_command776  */
static	ANTLR3_BITWORD FOLLOW_set_in_command776_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_command776	= { FOLLOW_set_in_command776_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ASSERTIONS_TOK_in_command803  */
static	ANTLR3_BITWORD FOLLOW_GET_ASSERTIONS_TOK_in_command803_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ASSERTIONS_TOK_in_command803	= { FOLLOW_GET_ASSERTIONS_TOK_in_command803_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_PROOF_TOK_in_command823  */
static	ANTLR3_BITWORD FOLLOW_GET_PROOF_TOK_in_command823_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_PROOF_TOK_in_command823	= { FOLLOW_GET_PROOF_TOK_in_command823_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command843  */
static	ANTLR3_BITWORD FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command843_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command843	= { FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command843_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_UNSAT_CORE_TOK_in_command863  */
static	ANTLR3_BITWORD FOLLOW_GET_UNSAT_CORE_TOK_in_command863_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_UNSAT_CORE_TOK_in_command863	= { FOLLOW_GET_UNSAT_CORE_TOK_in_command863_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_TOK_in_command883  */
static	ANTLR3_BITWORD FOLLOW_PUSH_TOK_in_command883_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_TOK_in_command883	= { FOLLOW_PUSH_TOK_in_command883_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command901  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command901_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command901	= { FOLLOW_INTEGER_LITERAL_in_command901_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_TOK_in_command925  */
static	ANTLR3_BITWORD FOLLOW_POP_TOK_in_command925_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_TOK_in_command925	= { FOLLOW_POP_TOK_in_command925_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command943  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command943	= { FOLLOW_INTEGER_LITERAL_in_command943_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXIT_TOK_in_command977  */
static	ANTLR3_BITWORD FOLLOW_EXIT_TOK_in_command977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXIT_TOK_in_command977	= { FOLLOW_EXIT_TOK_in_command977_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_smt25Command_in_command996  */
static	ANTLR3_BITWORD FOLLOW_smt25Command_in_command996_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_smt25Command_in_command996	= { FOLLOW_smt25Command_in_command996_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_extendedCommand_in_command1016  */
static	ANTLR3_BITWORD FOLLOW_extendedCommand_in_command1016_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_extendedCommand_in_command1016	= { FOLLOW_extendedCommand_in_command1016_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_command1036  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_command1036_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_command1036	= { FOLLOW_SIMPLE_SYMBOL_in_command1036_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1068  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1068_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1068	= { FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1068_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1076  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1076_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1076	= { FOLLOW_symbol_in_sygusCommand1076_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1089  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1089_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1089	= { FOLLOW_sortSymbol_in_sygusCommand1089_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1108  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1108_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1108	= { FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1108_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1116  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1116_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1116	= { FOLLOW_symbol_in_sygusCommand1116_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1129  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1129_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1129	= { FOLLOW_sortSymbol_in_sygusCommand1129_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1151  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1151_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1151	= { FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1151_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_INV_TOK_in_sygusCommand1155  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_INV_TOK_in_sygusCommand1155_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_INV_TOK_in_sygusCommand1155	= { FOLLOW_SYNTH_INV_TOK_in_sygusCommand1155_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1171  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1171_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1171	= { FOLLOW_symbol_in_sygusCommand1171_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1178  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1178	= { FOLLOW_LPAREN_TOK_in_sygusCommand1178_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_sygusCommand1180  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_sygusCommand1180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_sygusCommand1180	= { FOLLOW_sortedVarList_in_sygusCommand1180_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1183  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1183_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500002), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1183	= { FOLLOW_RPAREN_TOK_in_sygusCommand1183_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1191  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1191	= { FOLLOW_sortSymbol_in_sygusCommand1191_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1205  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1205_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1205	= { FOLLOW_LPAREN_TOK_in_sygusCommand1205_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1213  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1213_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1213	= { FOLLOW_LPAREN_TOK_in_sygusCommand1213_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1221  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1221_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1221	= { FOLLOW_symbol_in_sygusCommand1221_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusCommand1231  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusCommand1231_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusCommand1231	= { FOLLOW_sortSymbol_in_sygusCommand1231_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusCommand1262  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusCommand1262_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801940) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusCommand1262	= { FOLLOW_LPAREN_TOK_in_sygusCommand1262_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGTerm_in_sygusCommand1266  */
static	ANTLR3_BITWORD FOLLOW_sygusGTerm_in_sygusCommand1266_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGTerm_in_sygusCommand1266	= { FOLLOW_sygusGTerm_in_sygusCommand1266_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1287  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1287_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1287	= { FOLLOW_RPAREN_TOK_in_sygusCommand1287_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1297  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1297	= { FOLLOW_RPAREN_TOK_in_sygusCommand1297_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusCommand1311  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusCommand1311_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusCommand1311	= { FOLLOW_RPAREN_TOK_in_sygusCommand1311_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONSTRAINT_TOK_in_sygusCommand1338  */
static	ANTLR3_BITWORD FOLLOW_CONSTRAINT_TOK_in_sygusCommand1338_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_CONSTRAINT_TOK_in_sygusCommand1338	= { FOLLOW_CONSTRAINT_TOK_in_sygusCommand1338_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_sygusCommand1346  */
static	ANTLR3_BITWORD FOLLOW_term_in_sygusCommand1346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_sygusCommand1346	= { FOLLOW_term_in_sygusCommand1346_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1359  */
static	ANTLR3_BITWORD FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1359_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1359	= { FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1359_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusCommand1369  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusCommand1369_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500002), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusCommand1369	= { FOLLOW_symbol_in_sygusCommand1369_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1393  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1393_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1393	= { FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1393_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_sygusCommand1411  */
static	ANTLR3_BITWORD FOLLOW_command_in_sygusCommand1411_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_sygusCommand1411	= { FOLLOW_command_in_sygusCommand1411_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGTerm1452  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGTerm1452_bits[]	= { ANTLR3_UINT64_LIT(0x0193404800520040), ANTLR3_UINT64_LIT(0x08AA1B2430000000), ANTLR3_UINT64_LIT(0x00000004A1972540) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGTerm1452	= { FOLLOW_LPAREN_TOK_in_sygusGTerm1452_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_builtinOp_in_sygusGTerm1465  */
static	ANTLR3_BITWORD FOLLOW_builtinOp_in_sygusGTerm1465_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_builtinOp_in_sygusGTerm1465	= { FOLLOW_builtinOp_in_sygusGTerm1465_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_LET_TOK_in_sygusGTerm1476  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_LET_TOK_in_sygusGTerm1476_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_LET_TOK_in_sygusGTerm1476	= { FOLLOW_SYGUS_LET_TOK_in_sygusGTerm1476_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGTerm1478  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGTerm1478_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGTerm1478	= { FOLLOW_LPAREN_TOK_in_sygusGTerm1478_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sygusGTerm1491  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sygusGTerm1491_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sygusGTerm1491	= { FOLLOW_LPAREN_TOK_in_sygusGTerm1491_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1502  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1502_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1502	= { FOLLOW_symbol_in_sygusGTerm1502_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1514  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1514_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801940) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1514	= { FOLLOW_sortSymbol_in_sygusGTerm1514_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGTerm_in_sygusGTerm1528  */
static	ANTLR3_BITWORD FOLLOW_sygusGTerm_in_sygusGTerm1528_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGTerm_in_sygusGTerm1528	= { FOLLOW_sygusGTerm_in_sygusGTerm1528_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGTerm1539  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGTerm1539_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGTerm1539	= { FOLLOW_RPAREN_TOK_in_sygusGTerm1539_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGTerm1544  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGTerm1544_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGTerm1544	= { FOLLOW_RPAREN_TOK_in_sygusGTerm1544_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1552  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1552_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1552	= { FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1552_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1554  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1554_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1554	= { FOLLOW_sortSymbol_in_sygusGTerm1554_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1572  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1572_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1572	= { FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1572_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1574  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1574_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1574	= { FOLLOW_sortSymbol_in_sygusGTerm1574_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1591  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1591_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1591	= { FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1591_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1593  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1593_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1593	= { FOLLOW_sortSymbol_in_sygusGTerm1593_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1610  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1610_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1610	= { FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1610_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sygusGTerm1612  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sygusGTerm1612_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sygusGTerm1612	= { FOLLOW_sortSymbol_in_sygusGTerm1612_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1629  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1629_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1629	= { FOLLOW_symbol_in_sygusGTerm1629_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sygusGTerm_in_sygusGTerm1657  */
static	ANTLR3_BITWORD FOLLOW_sygusGTerm_in_sygusGTerm1657_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800510000), ANTLR3_UINT64_LIT(0x0800418080000000), ANTLR3_UINT64_LIT(0x0000000421801948) };
static  ANTLR3_BITSET_LIST FOLLOW_sygusGTerm_in_sygusGTerm1657	= { FOLLOW_sygusGTerm_in_sygusGTerm1657_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sygusGTerm1680  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sygusGTerm1680_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sygusGTerm1680	= { FOLLOW_RPAREN_TOK_in_sygusGTerm1680_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_sygusGTerm1688  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_sygusGTerm1688_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_sygusGTerm1688	= { FOLLOW_INTEGER_LITERAL_in_sygusGTerm1688_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_sygusGTerm1700  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_sygusGTerm1700_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_sygusGTerm1700	= { FOLLOW_HEX_LITERAL_in_sygusGTerm1700_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_sygusGTerm1712  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_sygusGTerm1712_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_sygusGTerm1712	= { FOLLOW_BINARY_LITERAL_in_sygusGTerm1712_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_sygusGTerm1724  */
static	ANTLR3_BITWORD FOLLOW_str_in_sygusGTerm1724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_sygusGTerm1724	= { FOLLOW_str_in_sygusGTerm1724_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1737  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1737_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1737	= { FOLLOW_symbol_in_sygusGTerm1737_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1746  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1746_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1746	= { FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1746_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sygusGTerm1748  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sygusGTerm1748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sygusGTerm1748	= { FOLLOW_symbol_in_sygusGTerm1748_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_metaInfoInternal1790  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_metaInfoInternal1790_bits[]	= { ANTLR3_UINT64_LIT(0x01D74F6A415F00C0), ANTLR3_UINT64_LIT(0x4FAA5FA4BE7E0000), ANTLR3_UINT64_LIT(0x00000004A1801FF7) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_metaInfoInternal1790	= { FOLLOW_KEYWORD_in_metaInfoInternal1790_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_metaInfoInternal1792  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_metaInfoInternal1792_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_metaInfoInternal1792	= { FOLLOW_symbolicExpr_in_metaInfoInternal1792_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_keyword_in_setOptionInternal1818  */
static	ANTLR3_BITWORD FOLLOW_keyword_in_setOptionInternal1818_bits[]	= { ANTLR3_UINT64_LIT(0x01D74F6A415F00C0), ANTLR3_UINT64_LIT(0x4FAA5FA4BE7E0000), ANTLR3_UINT64_LIT(0x00000004A1801FF7) };
static  ANTLR3_BITSET_LIST FOLLOW_keyword_in_setOptionInternal1818	= { FOLLOW_keyword_in_setOptionInternal1818_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_setOptionInternal1821  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_setOptionInternal1821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_setOptionInternal1821	= { FOLLOW_symbolicExpr_in_setOptionInternal1821_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_META_INFO_TOK_in_smt25Command1853  */
static	ANTLR3_BITWORD FOLLOW_META_INFO_TOK_in_smt25Command1853_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_META_INFO_TOK_in_smt25Command1853	= { FOLLOW_META_INFO_TOK_in_smt25Command1853_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_metaInfoInternal_in_smt25Command1855  */
static	ANTLR3_BITWORD FOLLOW_metaInfoInternal_in_smt25Command1855_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_metaInfoInternal_in_smt25Command1855	= { FOLLOW_metaInfoInternal_in_smt25Command1855_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CONST_TOK_in_smt25Command1869  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CONST_TOK_in_smt25Command1869_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CONST_TOK_in_smt25Command1869	= { FOLLOW_DECLARE_CONST_TOK_in_smt25Command1869_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command1877  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command1877_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command1877	= { FOLLOW_symbol_in_smt25Command1877_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command1890  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command1890_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command1890	= { FOLLOW_sortSymbol_in_smt25Command1890_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_MODEL_TOK_in_smt25Command1910  */
static	ANTLR3_BITWORD FOLLOW_GET_MODEL_TOK_in_smt25Command1910_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_MODEL_TOK_in_smt25Command1910	= { FOLLOW_GET_MODEL_TOK_in_smt25Command1910_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ECHO_TOK_in_smt25Command1931  */
static	ANTLR3_BITWORD FOLLOW_ECHO_TOK_in_smt25Command1931_bits[]	= { ANTLR3_UINT64_LIT(0x01D74F6A415F00C2), ANTLR3_UINT64_LIT(0x4FAA1FA4BE7E0000), ANTLR3_UINT64_LIT(0x00000004A1801FF7) };
static  ANTLR3_BITSET_LIST FOLLOW_ECHO_TOK_in_smt25Command1931	= { FOLLOW_ECHO_TOK_in_smt25Command1931_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_smt25Command1939  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_smt25Command1939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_smt25Command1939	= { FOLLOW_simpleSymbolicExpr_in_smt25Command1939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_smt25Command1975  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_smt25Command1975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_smt25Command1975	= { FOLLOW_RESET_TOK_in_smt25Command1975_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1993  */
static	ANTLR3_BITWORD FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1993_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1993	= { FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1993_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2005  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2005_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2005	= { FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2005_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command2017  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command2017_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command2017	= { FOLLOW_symbol_in_smt25Command2017_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2030  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2030_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2030	= { FOLLOW_LPAREN_TOK_in_smt25Command2030_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_smt25Command2032  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_smt25Command2032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_smt25Command2032	= { FOLLOW_sortedVarList_in_smt25Command2032_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2035  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2035_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2035	= { FOLLOW_RPAREN_TOK_in_smt25Command2035_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command2041  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command2041_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command2041	= { FOLLOW_sortSymbol_in_smt25Command2041_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_smt25Command2054  */
static	ANTLR3_BITWORD FOLLOW_term_in_smt25Command2054_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_smt25Command2054	= { FOLLOW_term_in_smt25Command2054_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2067  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2067_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2067	= { FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2067_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2079  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2079_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2079	= { FOLLOW_LPAREN_TOK_in_smt25Command2079_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2087  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2087_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2087	= { FOLLOW_LPAREN_TOK_in_smt25Command2087_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_smt25Command2095  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_smt25Command2095_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_smt25Command2095	= { FOLLOW_symbol_in_smt25Command2095_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2112  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2112	= { FOLLOW_LPAREN_TOK_in_smt25Command2112_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_smt25Command2114  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_smt25Command2114_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_smt25Command2114	= { FOLLOW_sortedVarList_in_smt25Command2114_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2117  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2117_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2117	= { FOLLOW_RPAREN_TOK_in_smt25Command2117_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_smt25Command2125  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_smt25Command2125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_smt25Command2125	= { FOLLOW_sortSymbol_in_smt25Command2125_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2142  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2142_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2142	= { FOLLOW_RPAREN_TOK_in_smt25Command2142_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2155  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2155_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2155	= { FOLLOW_RPAREN_TOK_in_smt25Command2155_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_smt25Command2161  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_smt25Command2161_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_smt25Command2161	= { FOLLOW_LPAREN_TOK_in_smt25Command2161_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_smt25Command2179  */
static	ANTLR3_BITWORD FOLLOW_term_in_smt25Command2179_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801948) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_smt25Command2179	= { FOLLOW_term_in_smt25Command2179_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_smt25Command2199  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_smt25Command2199_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_smt25Command2199	= { FOLLOW_RPAREN_TOK_in_smt25Command2199_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2230  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2230_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2230	= { FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2230_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2232  */
static	ANTLR3_BITWORD FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2232	= { FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2232_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2239  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2239	= { FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2239_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2241  */
static	ANTLR3_BITWORD FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2241_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2241	= { FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2241_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2248  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2248_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2248	= { FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2248_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDefCommand_in_extendedCommand2250  */
static	ANTLR3_BITWORD FOLLOW_datatypeDefCommand_in_extendedCommand2250_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDefCommand_in_extendedCommand2250	= { FOLLOW_datatypeDefCommand_in_extendedCommand2250_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2257  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2257_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2257	= { FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2257_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDefCommand_in_extendedCommand2259  */
static	ANTLR3_BITWORD FOLLOW_datatypeDefCommand_in_extendedCommand2259_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDefCommand_in_extendedCommand2259	= { FOLLOW_datatypeDefCommand_in_extendedCommand2259_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2266  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2266_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2266	= { FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2266_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDefCommand_in_extendedCommand2268  */
static	ANTLR3_BITWORD FOLLOW_datatypesDefCommand_in_extendedCommand2268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDefCommand_in_extendedCommand2268	= { FOLLOW_datatypesDefCommand_in_extendedCommand2268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2275  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2275	= { FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2275_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDefCommand_in_extendedCommand2277  */
static	ANTLR3_BITWORD FOLLOW_datatypesDefCommand_in_extendedCommand2277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDefCommand_in_extendedCommand2277	= { FOLLOW_datatypesDefCommand_in_extendedCommand2277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rewriterulesCommand_in_extendedCommand2284  */
static	ANTLR3_BITWORD FOLLOW_rewriterulesCommand_in_extendedCommand2284_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_rewriterulesCommand_in_extendedCommand2284	= { FOLLOW_rewriterulesCommand_in_extendedCommand2284_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2299  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2299	= { FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2299_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2319  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2319_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2319	= { FOLLOW_LPAREN_TOK_in_extendedCommand2319_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2327  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2327_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2327	= { FOLLOW_symbol_in_extendedCommand2327_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2349  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2349_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2349	= { FOLLOW_RPAREN_TOK_in_extendedCommand2349_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2362  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2362	= { FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2362_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2376  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2376_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2376	= { FOLLOW_LPAREN_TOK_in_extendedCommand2376_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2384  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2384_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2384	= { FOLLOW_LPAREN_TOK_in_extendedCommand2384_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2386  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2386_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2386	= { FOLLOW_symbol_in_extendedCommand2386_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptySortList_in_extendedCommand2403  */
static	ANTLR3_BITWORD FOLLOW_nonemptySortList_in_extendedCommand2403_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptySortList_in_extendedCommand2403	= { FOLLOW_nonemptySortList_in_extendedCommand2403_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2406  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2406_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2406	= { FOLLOW_RPAREN_TOK_in_extendedCommand2406_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2427  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2427_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2427	= { FOLLOW_RPAREN_TOK_in_extendedCommand2427_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2440  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2440_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2440	= { FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2440_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2454  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2454_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2454	= { FOLLOW_LPAREN_TOK_in_extendedCommand2454_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2462  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2462_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2462	= { FOLLOW_LPAREN_TOK_in_extendedCommand2462_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2464  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2464_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2464	= { FOLLOW_symbol_in_extendedCommand2464_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_extendedCommand2481  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_extendedCommand2481_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_extendedCommand2481	= { FOLLOW_sortList_in_extendedCommand2481_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2484  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2484_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2484	= { FOLLOW_RPAREN_TOK_in_extendedCommand2484_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2505  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2505_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2505	= { FOLLOW_RPAREN_TOK_in_extendedCommand2505_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_TOK_in_extendedCommand2518  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_TOK_in_extendedCommand2518_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_TOK_in_extendedCommand2518	= { FOLLOW_DEFINE_TOK_in_extendedCommand2518_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2528  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2528_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2528	= { FOLLOW_symbol_in_extendedCommand2528_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2545  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2545_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2545	= { FOLLOW_term_in_extendedCommand2545_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand2562  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand2562_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand2562	= { FOLLOW_LPAREN_TOK_in_extendedCommand2562_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2570  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2570_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2570	= { FOLLOW_symbol_in_extendedCommand2570_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_extendedCommand2587  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_extendedCommand2587_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_extendedCommand2587	= { FOLLOW_sortedVarList_in_extendedCommand2587_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand2590  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand2590_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand2590	= { FOLLOW_RPAREN_TOK_in_extendedCommand2590_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2606  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2606_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2606	= { FOLLOW_term_in_extendedCommand2606_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2627  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2627_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2627	= { FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2627_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand2635  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand2635_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand2635	= { FOLLOW_symbol_in_extendedCommand2635_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_extendedCommand2648  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_extendedCommand2648_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_extendedCommand2648	= { FOLLOW_sortSymbol_in_extendedCommand2648_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2661  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2661_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2661	= { FOLLOW_term_in_extendedCommand2661_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLIFY_TOK_in_extendedCommand2675  */
static	ANTLR3_BITWORD FOLLOW_SIMPLIFY_TOK_in_extendedCommand2675_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLIFY_TOK_in_extendedCommand2675	= { FOLLOW_SIMPLIFY_TOK_in_extendedCommand2675_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2683  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2683_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2683	= { FOLLOW_term_in_extendedCommand2683_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_QE_TOK_in_extendedCommand2696  */
static	ANTLR3_BITWORD FOLLOW_GET_QE_TOK_in_extendedCommand2696_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_QE_TOK_in_extendedCommand2696	= { FOLLOW_GET_QE_TOK_in_extendedCommand2696_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2704  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2704	= { FOLLOW_term_in_extendedCommand2704_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2717  */
static	ANTLR3_BITWORD FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2717_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2717	= { FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2717_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand2725  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand2725_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand2725	= { FOLLOW_term_in_extendedCommand2725_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2756  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2756_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2756	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2756_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypes_2_5_DefCommand2764  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypes_2_5_DefCommand2764_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypes_2_5_DefCommand2764	= { FOLLOW_symbol_in_datatypes_2_5_DefCommand2764_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2780  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2780_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2780	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2780_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2784  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2784_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2784	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2784_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2788  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2788_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2788	= { FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2788_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2790  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2790_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2790	= { FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2790_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2793  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2793_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2793	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2793_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2798  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2798_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2798	= { FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2798_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypeDefCommand2827  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypeDefCommand2827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypeDefCommand2827	= { FOLLOW_symbol_in_datatypeDefCommand2827_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDef_in_datatypeDefCommand2834  */
static	ANTLR3_BITWORD FOLLOW_datatypesDef_in_datatypeDefCommand2834_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDef_in_datatypeDefCommand2834	= { FOLLOW_datatypesDef_in_datatypeDefCommand2834_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2859  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2859	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2859_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2867  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2867_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2867	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2867_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypesDefCommand2869  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypesDefCommand2869_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypesDefCommand2869	= { FOLLOW_symbol_in_datatypesDefCommand2869_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2874  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2874_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2874	= { FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2874_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2876  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2876_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2876	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2876_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2891  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2891_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2891	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2891_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand2896  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand2896_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand2896	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand2896_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDef_in_datatypesDefCommand2901  */
static	ANTLR3_BITWORD FOLLOW_datatypesDef_in_datatypesDefCommand2901_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDef_in_datatypesDefCommand2901	= { FOLLOW_datatypesDef_in_datatypesDefCommand2901_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef2935  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef2935_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef2935	= { FOLLOW_LPAREN_TOK_in_datatypesDef2935_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PAR_TOK_in_datatypesDef2945  */
static	ANTLR3_BITWORD FOLLOW_PAR_TOK_in_datatypesDef2945_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PAR_TOK_in_datatypesDef2945	= { FOLLOW_PAR_TOK_in_datatypesDef2945_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef2949  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef2949_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef2949	= { FOLLOW_LPAREN_TOK_in_datatypesDef2949_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypesDef2959  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypesDef2959_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypesDef2959	= { FOLLOW_symbol_in_datatypesDef2959_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef2987  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef2987_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef2987	= { FOLLOW_RPAREN_TOK_in_datatypesDef2987_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef2997  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef2997_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef2997	= { FOLLOW_LPAREN_TOK_in_datatypesDef2997_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef3007  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef3007_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef3007	= { FOLLOW_LPAREN_TOK_in_datatypesDef3007_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypesDef3009  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypesDef3009_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypesDef3009	= { FOLLOW_constructorDef_in_datatypesDef3009_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3012  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3012_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3012	= { FOLLOW_RPAREN_TOK_in_datatypesDef3012_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3023  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3023_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3023	= { FOLLOW_RPAREN_TOK_in_datatypesDef3023_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDef3044  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDef3044_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDef3044	= { FOLLOW_LPAREN_TOK_in_datatypesDef3044_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypesDef3046  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypesDef3046_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypesDef3046	= { FOLLOW_constructorDef_in_datatypesDef3046_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3049  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3049_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3049	= { FOLLOW_RPAREN_TOK_in_datatypesDef3049_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDef3064  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDef3064_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDef3064	= { FOLLOW_RPAREN_TOK_in_datatypesDef3064_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3100  */
static	ANTLR3_BITWORD FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3100_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3100	= { FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3100_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3106  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3106_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3106	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3106_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_rewriterulesCommand3108  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_rewriterulesCommand3108_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_rewriterulesCommand3108	= { FOLLOW_sortedVarList_in_rewriterulesCommand3108_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3111  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3111_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3111	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3111_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3123  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3123	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3123_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pattern_in_rewriterulesCommand3127  */
static	ANTLR3_BITWORD FOLLOW_pattern_in_rewriterulesCommand3127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_pattern_in_rewriterulesCommand3127	= { FOLLOW_pattern_in_rewriterulesCommand3127_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3135  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3135_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3135	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3135_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3141  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3141_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801948) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3141	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3141_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand3144  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand3144_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand3144	= { FOLLOW_termList_in_rewriterulesCommand3144_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3149  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3149_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3149	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3149_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand3155  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand3155_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand3155	= { FOLLOW_term_in_rewriterulesCommand3155_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand3158  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand3158_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand3158	= { FOLLOW_term_in_rewriterulesCommand3158_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rewritePropaKind_in_rewriterulesCommand3177  */
static	ANTLR3_BITWORD FOLLOW_rewritePropaKind_in_rewriterulesCommand3177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_rewritePropaKind_in_rewriterulesCommand3177	= { FOLLOW_rewritePropaKind_in_rewriterulesCommand3177_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3184  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3184_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3184	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3184_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_rewriterulesCommand3186  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_rewriterulesCommand3186_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_rewriterulesCommand3186	= { FOLLOW_sortedVarList_in_rewriterulesCommand3186_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3189  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3189_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3189	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3189_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3201  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3201_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3201	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3201_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pattern_in_rewriterulesCommand3205  */
static	ANTLR3_BITWORD FOLLOW_pattern_in_rewriterulesCommand3205_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_pattern_in_rewriterulesCommand3205	= { FOLLOW_pattern_in_rewriterulesCommand3205_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3213  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3213_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3213	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3213_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3219  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3219_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801948) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3219	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3219_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand3222  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand3222_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand3222	= { FOLLOW_termList_in_rewriterulesCommand3222_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3227  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3227	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3227_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand3233  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand3233_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801948) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand3233	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand3233_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand3236  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand3236_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand3236	= { FOLLOW_termList_in_rewriterulesCommand3236_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand3241  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand3241_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand3241	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand3241_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand3247  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand3247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand3247	= { FOLLOW_term_in_rewriterulesCommand3247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3268  */
static	ANTLR3_BITWORD FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3268	= { FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3279  */
static	ANTLR3_BITWORD FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3279_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3279	= { FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3279_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_pattern3301  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_pattern3301_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_pattern3301	= { FOLLOW_LPAREN_TOK_in_pattern3301_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_pattern3303  */
static	ANTLR3_BITWORD FOLLOW_termList_in_pattern3303_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_pattern3303	= { FOLLOW_termList_in_pattern3303_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_pattern3306  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_pattern3306_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_pattern3306	= { FOLLOW_RPAREN_TOK_in_pattern3306_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3331  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3331_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3331	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3331_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3343  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3343_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3343	= { FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3343_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3355  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3355_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3355	= { FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3355_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3367  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3367	= { FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3367_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_simpleSymbolicExprNoKeyword3379  */
static	ANTLR3_BITWORD FOLLOW_str_in_simpleSymbolicExprNoKeyword3379_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_simpleSymbolicExprNoKeyword3379	= { FOLLOW_str_in_simpleSymbolicExprNoKeyword3379_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3399  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3399_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3399	= { FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3399_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_simpleSymbolicExprNoKeyword3414  */
static	ANTLR3_BITWORD FOLLOW_set_in_simpleSymbolicExprNoKeyword3414_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_simpleSymbolicExprNoKeyword3414	= { FOLLOW_set_in_simpleSymbolicExprNoKeyword3414_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3624  */
static	ANTLR3_BITWORD FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3624_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3624	= { FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3624_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_keyword3645  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_keyword3645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_keyword3645	= { FOLLOW_KEYWORD_in_keyword3645_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3665  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3665_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3665	= { FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3665_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_simpleSymbolicExpr3672  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_simpleSymbolicExpr3672_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_simpleSymbolicExpr3672	= { FOLLOW_KEYWORD_in_simpleSymbolicExpr3672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_symbolicExpr3697  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_symbolicExpr3697_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_symbolicExpr3697	= { FOLLOW_simpleSymbolicExpr_in_symbolicExpr3697_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_symbolicExpr3704  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_symbolicExpr3704_bits[]	= { ANTLR3_UINT64_LIT(0x01D74F6A415F00C0), ANTLR3_UINT64_LIT(0x4FAA5FA4BE7E0000), ANTLR3_UINT64_LIT(0x00000004A1801FFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_symbolicExpr3704	= { FOLLOW_LPAREN_TOK_in_symbolicExpr3704_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_symbolicExpr3712  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_symbolicExpr3712_bits[]	= { ANTLR3_UINT64_LIT(0x01D74F6A415F00C0), ANTLR3_UINT64_LIT(0x4FAA5FA4BE7E0000), ANTLR3_UINT64_LIT(0x00000004A1801FFF) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_symbolicExpr3712	= { FOLLOW_symbolicExpr_in_symbolicExpr3712_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_symbolicExpr3720  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_symbolicExpr3720_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_symbolicExpr3720	= { FOLLOW_RPAREN_TOK_in_symbolicExpr3720_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termNonVariable_in_term3745  */
static	ANTLR3_BITWORD FOLLOW_termNonVariable_in_term3745_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_termNonVariable_in_term3745	= { FOLLOW_termNonVariable_in_term3745_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term3758  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term3758_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term3758	= { FOLLOW_symbol_in_term3758_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3792  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3792_bits[]	= { ANTLR3_UINT64_LIT(0x0193400000020040), ANTLR3_UINT64_LIT(0x00AA1A2430000000), ANTLR3_UINT64_LIT(0x0000000080000400) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3792	= { FOLLOW_LPAREN_TOK_in_termNonVariable3792_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_builtinOp_in_termNonVariable3794  */
static	ANTLR3_BITWORD FOLLOW_builtinOp_in_termNonVariable3794_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_builtinOp_in_termNonVariable3794	= { FOLLOW_builtinOp_in_termNonVariable3794_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_termNonVariable3797  */
static	ANTLR3_BITWORD FOLLOW_termList_in_termNonVariable3797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_termNonVariable3797	= { FOLLOW_termList_in_termNonVariable3797_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3800  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3800_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3800	= { FOLLOW_RPAREN_TOK_in_termNonVariable3800_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3812  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3812_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3812	= { FOLLOW_LPAREN_TOK_in_termNonVariable3812_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AS_TOK_in_termNonVariable3814  */
static	ANTLR3_BITWORD FOLLOW_AS_TOK_in_termNonVariable3814_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_AS_TOK_in_termNonVariable3814	= { FOLLOW_AS_TOK_in_termNonVariable3814_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termNonVariable_in_termNonVariable3818  */
static	ANTLR3_BITWORD FOLLOW_termNonVariable_in_termNonVariable3818_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_termNonVariable_in_termNonVariable3818	= { FOLLOW_termNonVariable_in_termNonVariable3818_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable3823  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable3823_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable3823	= { FOLLOW_symbol_in_termNonVariable3823_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_termNonVariable3835  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_termNonVariable3835_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_termNonVariable3835	= { FOLLOW_sortSymbol_in_termNonVariable3835_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3838  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3838_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3838	= { FOLLOW_RPAREN_TOK_in_termNonVariable3838_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3850  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3850_bits[]	= { ANTLR3_UINT64_LIT(0x0220000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3850	= { FOLLOW_LPAREN_TOK_in_termNonVariable3850_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quantOp_in_termNonVariable3852  */
static	ANTLR3_BITWORD FOLLOW_quantOp_in_termNonVariable3852_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_quantOp_in_termNonVariable3852	= { FOLLOW_quantOp_in_termNonVariable3852_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3859  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3859_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3859	= { FOLLOW_LPAREN_TOK_in_termNonVariable3859_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_termNonVariable3861  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_termNonVariable3861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_termNonVariable3861	= { FOLLOW_sortedVarList_in_termNonVariable3861_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3864  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3864_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3864	= { FOLLOW_RPAREN_TOK_in_termNonVariable3864_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable3876  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable3876_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable3876	= { FOLLOW_term_in_termNonVariable3876_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3879  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3879_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3879	= { FOLLOW_RPAREN_TOK_in_termNonVariable3879_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3891  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3891_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3891	= { FOLLOW_LPAREN_TOK_in_termNonVariable3891_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_functionName_in_termNonVariable3893  */
static	ANTLR3_BITWORD FOLLOW_functionName_in_termNonVariable3893_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_functionName_in_termNonVariable3893	= { FOLLOW_functionName_in_termNonVariable3893_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_termNonVariable3911  */
static	ANTLR3_BITWORD FOLLOW_termList_in_termNonVariable3911_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_termNonVariable3911	= { FOLLOW_termList_in_termNonVariable3911_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3914  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3914_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3914	= { FOLLOW_RPAREN_TOK_in_termNonVariable3914_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3927  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3927_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3927	= { FOLLOW_LPAREN_TOK_in_termNonVariable3927_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_indexedFunctionName_in_termNonVariable3943  */
static	ANTLR3_BITWORD FOLLOW_indexedFunctionName_in_termNonVariable3943_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_indexedFunctionName_in_termNonVariable3943	= { FOLLOW_indexedFunctionName_in_termNonVariable3943_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_termNonVariable3946  */
static	ANTLR3_BITWORD FOLLOW_termList_in_termNonVariable3946_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_termNonVariable3946	= { FOLLOW_termList_in_termNonVariable3946_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3949  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3949_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3949	= { FOLLOW_RPAREN_TOK_in_termNonVariable3949_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable3967  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable3967_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable3967	= { FOLLOW_LPAREN_TOK_in_termNonVariable3967_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AS_TOK_in_termNonVariable3969  */
static	ANTLR3_BITWORD FOLLOW_AS_TOK_in_termNonVariable3969_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000800000) };
static  ANTLR3_BITSET_LIST FOLLOW_AS_TOK_in_termNonVariable3969	= { FOLLOW_AS_TOK_in_termNonVariable3969_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONST_TOK_in_termNonVariable3971  */
static	ANTLR3_BITWORD FOLLOW_CONST_TOK_in_termNonVariable3971_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_CONST_TOK_in_termNonVariable3971	= { FOLLOW_CONST_TOK_in_termNonVariable3971_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_termNonVariable3973  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_termNonVariable3973_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_termNonVariable3973	= { FOLLOW_sortSymbol_in_termNonVariable3973_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3982  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3982_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3982	= { FOLLOW_RPAREN_TOK_in_termNonVariable3982_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable3984  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable3984_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable3984	= { FOLLOW_term_in_termNonVariable3984_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable3987  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable3987_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable3987	= { FOLLOW_RPAREN_TOK_in_termNonVariable3987_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4013  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4013_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000200000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4013	= { FOLLOW_LPAREN_TOK_in_termNonVariable4013_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_termNonVariable4024  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_termNonVariable4024_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_termNonVariable4024	= { FOLLOW_LET_TOK_in_termNonVariable4024_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4026  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4026_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4026	= { FOLLOW_LPAREN_TOK_in_termNonVariable4026_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4044  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4044_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4044	= { FOLLOW_LPAREN_TOK_in_termNonVariable4044_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4046  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4046_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4046	= { FOLLOW_symbol_in_termNonVariable4046_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4057  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4057_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4057	= { FOLLOW_term_in_termNonVariable4057_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4068  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4068_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4068	= { FOLLOW_RPAREN_TOK_in_termNonVariable4068_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_LET_TOK_in_termNonVariable4109  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_LET_TOK_in_termNonVariable4109_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_LET_TOK_in_termNonVariable4109	= { FOLLOW_SYGUS_LET_TOK_in_termNonVariable4109_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4111  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4111_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4111	= { FOLLOW_LPAREN_TOK_in_termNonVariable4111_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4129  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4129_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4129	= { FOLLOW_LPAREN_TOK_in_termNonVariable4129_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4131  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4131_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4131	= { FOLLOW_symbol_in_termNonVariable4131_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_termNonVariable4142  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_termNonVariable4142_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_termNonVariable4142	= { FOLLOW_sortSymbol_in_termNonVariable4142_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4153  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4153_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4153	= { FOLLOW_term_in_termNonVariable4153_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4164  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4164_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4164	= { FOLLOW_RPAREN_TOK_in_termNonVariable4164_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4209  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4209_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4209	= { FOLLOW_RPAREN_TOK_in_termNonVariable4209_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4215  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4215	= { FOLLOW_term_in_termNonVariable4215_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4222  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4222_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4222	= { FOLLOW_RPAREN_TOK_in_termNonVariable4222_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4240  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4240_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4240	= { FOLLOW_LPAREN_TOK_in_termNonVariable4240_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MATCH_TOK_in_termNonVariable4242  */
static	ANTLR3_BITWORD FOLLOW_MATCH_TOK_in_termNonVariable4242_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_MATCH_TOK_in_termNonVariable4242	= { FOLLOW_MATCH_TOK_in_termNonVariable4242_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4244  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4244_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4244	= { FOLLOW_term_in_termNonVariable4244_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4253  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4253_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4253	= { FOLLOW_LPAREN_TOK_in_termNonVariable4253_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4277  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4277	= { FOLLOW_LPAREN_TOK_in_termNonVariable4277_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_termNonVariable4279  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_termNonVariable4279_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_termNonVariable4279	= { FOLLOW_INDEX_TOK_in_termNonVariable4279_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4281  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4281	= { FOLLOW_term_in_termNonVariable4281_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4294  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4294_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4294	= { FOLLOW_RPAREN_TOK_in_termNonVariable4294_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4304  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4304_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4304	= { FOLLOW_LPAREN_TOK_in_termNonVariable4304_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4306  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4306_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4306	= { FOLLOW_LPAREN_TOK_in_termNonVariable4306_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4308  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4308_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4308	= { FOLLOW_term_in_termNonVariable4308_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4334  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4334_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4334	= { FOLLOW_symbol_in_termNonVariable4334_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4360  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4360_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4360	= { FOLLOW_RPAREN_TOK_in_termNonVariable4360_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4371  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4371_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4371	= { FOLLOW_term_in_termNonVariable4371_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4385  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4385_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4385	= { FOLLOW_RPAREN_TOK_in_termNonVariable4385_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4408  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4408_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4408	= { FOLLOW_LPAREN_TOK_in_termNonVariable4408_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4410  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4410_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4410	= { FOLLOW_symbol_in_termNonVariable4410_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4424  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4424_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4424	= { FOLLOW_term_in_termNonVariable4424_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4438  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4438_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4438	= { FOLLOW_RPAREN_TOK_in_termNonVariable4438_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4451  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4451_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4451	= { FOLLOW_RPAREN_TOK_in_termNonVariable4451_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4453  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4453_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4453	= { FOLLOW_RPAREN_TOK_in_termNonVariable4453_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4462  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4462_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4462	= { FOLLOW_symbol_in_termNonVariable4462_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYGUS_ENUM_CONS_TOK_in_termNonVariable4465  */
static	ANTLR3_BITWORD FOLLOW_SYGUS_ENUM_CONS_TOK_in_termNonVariable4465_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_SYGUS_ENUM_CONS_TOK_in_termNonVariable4465	= { FOLLOW_SYGUS_ENUM_CONS_TOK_in_termNonVariable4465_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_termNonVariable4471  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_termNonVariable4471_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_termNonVariable4471	= { FOLLOW_symbol_in_termNonVariable4471_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4491  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4491_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4491	= { FOLLOW_LPAREN_TOK_in_termNonVariable4491_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4493  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4493_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4493	= { FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4493_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4495  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4495_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000003E00), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4495	= { FOLLOW_term_in_termNonVariable4495_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_attribute_in_termNonVariable4504  */
static	ANTLR3_BITWORD FOLLOW_attribute_in_termNonVariable4504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000003E00), ANTLR3_UINT64_LIT(0x0000040000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_attribute_in_termNonVariable4504	= { FOLLOW_attribute_in_termNonVariable4504_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4522  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4522_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4522	= { FOLLOW_RPAREN_TOK_in_termNonVariable4522_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4540  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4540_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4540	= { FOLLOW_LPAREN_TOK_in_termNonVariable4540_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4542  */
static	ANTLR3_BITWORD FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4542_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4542	= { FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4542_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4548  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4548_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4548	= { FOLLOW_LPAREN_TOK_in_termNonVariable4548_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_termNonVariable4550  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_termNonVariable4550_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_termNonVariable4550	= { FOLLOW_sortedVarList_in_termNonVariable4550_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4553  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4553_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4553	= { FOLLOW_RPAREN_TOK_in_termNonVariable4553_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termNonVariable4565  */
static	ANTLR3_BITWORD FOLLOW_term_in_termNonVariable4565_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termNonVariable4565	= { FOLLOW_term_in_termNonVariable4565_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4568  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4568_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4568	= { FOLLOW_RPAREN_TOK_in_termNonVariable4568_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4586  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4586	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4586_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_termNonVariable4599  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_termNonVariable4599_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_termNonVariable4599	= { FOLLOW_DECIMAL_LITERAL_in_termNonVariable4599_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable4612  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable4612_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable4612	= { FOLLOW_LPAREN_TOK_in_termNonVariable4612_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_termNonVariable4614  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_termNonVariable4614_bits[]	= { ANTLR3_UINT64_LIT(0x7C00000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_termNonVariable4614	= { FOLLOW_INDEX_TOK_in_termNonVariable4614_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_termNonVariable4625  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_termNonVariable4625_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_termNonVariable4625	= { FOLLOW_SIMPLE_SYMBOL_in_termNonVariable4625_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4629  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4629_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4629	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4629_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_PINF_TOK_in_termNonVariable4646  */
static	ANTLR3_BITWORD FOLLOW_FP_PINF_TOK_in_termNonVariable4646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_PINF_TOK_in_termNonVariable4646	= { FOLLOW_FP_PINF_TOK_in_termNonVariable4646_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4650  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4650_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4650	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4650_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4654  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4654_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4654	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4654_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_NINF_TOK_in_termNonVariable4670  */
static	ANTLR3_BITWORD FOLLOW_FP_NINF_TOK_in_termNonVariable4670_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_NINF_TOK_in_termNonVariable4670	= { FOLLOW_FP_NINF_TOK_in_termNonVariable4670_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4674  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4674_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4674	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4674_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4678  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4678_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4678	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4678_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_NAN_TOK_in_termNonVariable4694  */
static	ANTLR3_BITWORD FOLLOW_FP_NAN_TOK_in_termNonVariable4694_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_NAN_TOK_in_termNonVariable4694	= { FOLLOW_FP_NAN_TOK_in_termNonVariable4694_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4698  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4698_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4698	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4698_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4702  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4702_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4702	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4702_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_PZERO_TOK_in_termNonVariable4719  */
static	ANTLR3_BITWORD FOLLOW_FP_PZERO_TOK_in_termNonVariable4719_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_PZERO_TOK_in_termNonVariable4719	= { FOLLOW_FP_PZERO_TOK_in_termNonVariable4719_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4723  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4723	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4723_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4727  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4727	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4727_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_NZERO_TOK_in_termNonVariable4743  */
static	ANTLR3_BITWORD FOLLOW_FP_NZERO_TOK_in_termNonVariable4743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_NZERO_TOK_in_termNonVariable4743	= { FOLLOW_FP_NZERO_TOK_in_termNonVariable4743_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4747  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4747_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4747	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4747_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_termNonVariable4751  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_termNonVariable4751_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_termNonVariable4751	= { FOLLOW_INTEGER_LITERAL_in_termNonVariable4751_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable4777  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable4777_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable4777	= { FOLLOW_RPAREN_TOK_in_termNonVariable4777_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_termNonVariable4784  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_termNonVariable4784_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_termNonVariable4784	= { FOLLOW_HEX_LITERAL_in_termNonVariable4784_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_termNonVariable4797  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_termNonVariable4797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_termNonVariable4797	= { FOLLOW_BINARY_LITERAL_in_termNonVariable4797_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_termNonVariable4810  */
static	ANTLR3_BITWORD FOLLOW_str_in_termNonVariable4810_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_termNonVariable4810	= { FOLLOW_str_in_termNonVariable4810_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RNE_TOK_in_termNonVariable4823  */
static	ANTLR3_BITWORD FOLLOW_FP_RNE_TOK_in_termNonVariable4823_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RNE_TOK_in_termNonVariable4823	= { FOLLOW_FP_RNE_TOK_in_termNonVariable4823_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RNA_TOK_in_termNonVariable4836  */
static	ANTLR3_BITWORD FOLLOW_FP_RNA_TOK_in_termNonVariable4836_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RNA_TOK_in_termNonVariable4836	= { FOLLOW_FP_RNA_TOK_in_termNonVariable4836_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTP_TOK_in_termNonVariable4849  */
static	ANTLR3_BITWORD FOLLOW_FP_RTP_TOK_in_termNonVariable4849_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTP_TOK_in_termNonVariable4849	= { FOLLOW_FP_RTP_TOK_in_termNonVariable4849_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTN_TOK_in_termNonVariable4862  */
static	ANTLR3_BITWORD FOLLOW_FP_RTN_TOK_in_termNonVariable4862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTN_TOK_in_termNonVariable4862	= { FOLLOW_FP_RTN_TOK_in_termNonVariable4862_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTZ_TOK_in_termNonVariable4875  */
static	ANTLR3_BITWORD FOLLOW_FP_RTZ_TOK_in_termNonVariable4875_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTZ_TOK_in_termNonVariable4875	= { FOLLOW_FP_RTZ_TOK_in_termNonVariable4875_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RNE_FULL_TOK_in_termNonVariable4888  */
static	ANTLR3_BITWORD FOLLOW_FP_RNE_FULL_TOK_in_termNonVariable4888_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RNE_FULL_TOK_in_termNonVariable4888	= { FOLLOW_FP_RNE_FULL_TOK_in_termNonVariable4888_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RNA_FULL_TOK_in_termNonVariable4896  */
static	ANTLR3_BITWORD FOLLOW_FP_RNA_FULL_TOK_in_termNonVariable4896_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RNA_FULL_TOK_in_termNonVariable4896	= { FOLLOW_FP_RNA_FULL_TOK_in_termNonVariable4896_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTP_FULL_TOK_in_termNonVariable4904  */
static	ANTLR3_BITWORD FOLLOW_FP_RTP_FULL_TOK_in_termNonVariable4904_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTP_FULL_TOK_in_termNonVariable4904	= { FOLLOW_FP_RTP_FULL_TOK_in_termNonVariable4904_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTN_FULL_TOK_in_termNonVariable4912  */
static	ANTLR3_BITWORD FOLLOW_FP_RTN_FULL_TOK_in_termNonVariable4912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTN_FULL_TOK_in_termNonVariable4912	= { FOLLOW_FP_RTN_FULL_TOK_in_termNonVariable4912_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_RTZ_FULL_TOK_in_termNonVariable4920  */
static	ANTLR3_BITWORD FOLLOW_FP_RTZ_FULL_TOK_in_termNonVariable4920_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_RTZ_FULL_TOK_in_termNonVariable4920	= { FOLLOW_FP_RTZ_FULL_TOK_in_termNonVariable4920_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REAL_PI_TOK_in_termNonVariable4929  */
static	ANTLR3_BITWORD FOLLOW_REAL_PI_TOK_in_termNonVariable4929_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REAL_PI_TOK_in_termNonVariable4929	= { FOLLOW_REAL_PI_TOK_in_termNonVariable4929_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RENOSTR_TOK_in_termNonVariable4938  */
static	ANTLR3_BITWORD FOLLOW_RENOSTR_TOK_in_termNonVariable4938_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RENOSTR_TOK_in_termNonVariable4938	= { FOLLOW_RENOSTR_TOK_in_termNonVariable4938_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REALLCHAR_TOK_in_termNonVariable4951  */
static	ANTLR3_BITWORD FOLLOW_REALLCHAR_TOK_in_termNonVariable4951_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REALLCHAR_TOK_in_termNonVariable4951	= { FOLLOW_REALLCHAR_TOK_in_termNonVariable4951_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EMPTYSET_TOK_in_termNonVariable4964  */
static	ANTLR3_BITWORD FOLLOW_EMPTYSET_TOK_in_termNonVariable4964_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EMPTYSET_TOK_in_termNonVariable4964	= { FOLLOW_EMPTYSET_TOK_in_termNonVariable4964_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNIVSET_TOK_in_termNonVariable4977  */
static	ANTLR3_BITWORD FOLLOW_UNIVSET_TOK_in_termNonVariable4977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNIVSET_TOK_in_termNonVariable4977	= { FOLLOW_UNIVSET_TOK_in_termNonVariable4977_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NILREF_TOK_in_termNonVariable4990  */
static	ANTLR3_BITWORD FOLLOW_NILREF_TOK_in_termNonVariable4990_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NILREF_TOK_in_termNonVariable4990	= { FOLLOW_NILREF_TOK_in_termNonVariable4990_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_termNonVariable5008  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_termNonVariable5008_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_termNonVariable5008	= { FOLLOW_LPAREN_TOK_in_termNonVariable5008_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5010  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5010_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5010	= { FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5010_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_termNonVariable5012  */
static	ANTLR3_BITWORD FOLLOW_termList_in_termNonVariable5012_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_termNonVariable5012	= { FOLLOW_termList_in_termNonVariable5012_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_termNonVariable5015  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_termNonVariable5015_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_termNonVariable5015	= { FOLLOW_RPAREN_TOK_in_termNonVariable5015_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5030  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5030_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5030	= { FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5030_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_attribute5057  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_attribute5057_bits[]	= { ANTLR3_UINT64_LIT(0x01D74F6A415F00C2), ANTLR3_UINT64_LIT(0x4FAA1BA4BE7E0000), ANTLR3_UINT64_LIT(0x00000004A1801FF7) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_attribute5057	= { FOLLOW_KEYWORD_in_attribute5057_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExprNoKeyword_in_attribute5061  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExprNoKeyword_in_attribute5061_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExprNoKeyword_in_attribute5061	= { FOLLOW_simpleSymbolicExprNoKeyword_in_attribute5061_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute5077  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute5077_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute5077	= { FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute5077_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_attribute5079  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_attribute5079_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_attribute5079	= { FOLLOW_LPAREN_TOK_in_attribute5079_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_attribute5087  */
static	ANTLR3_BITWORD FOLLOW_term_in_attribute5087_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801948) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_attribute5087	= { FOLLOW_term_in_attribute5087_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_attribute5105  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_attribute5105_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_attribute5105	= { FOLLOW_RPAREN_TOK_in_attribute5105_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute5117  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute5117_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute5117	= { FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute5117_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_attribute5119  */
static	ANTLR3_BITWORD FOLLOW_term_in_attribute5119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_attribute5119	= { FOLLOW_term_in_attribute5119_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_attribute5134  */
static	ANTLR3_BITWORD FOLLOW_set_in_attribute5134_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_attribute5134	= { FOLLOW_set_in_attribute5134_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_attribute5144  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_attribute5144_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_attribute5144	= { FOLLOW_INTEGER_LITERAL_in_attribute5144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5156  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5156_bits[]	= { ANTLR3_UINT64_LIT(0x01D74F6A415F00C0), ANTLR3_UINT64_LIT(0x4FAA5FA4BE7E0000), ANTLR3_UINT64_LIT(0x00000004A1801FF7) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5156	= { FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5156_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_attribute5158  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_attribute5158_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_attribute5158	= { FOLLOW_symbolicExpr_in_attribute5158_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_indexedFunctionName5186  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_indexedFunctionName5186_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000001000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_indexedFunctionName5186	= { FOLLOW_LPAREN_TOK_in_indexedFunctionName5186_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_indexedFunctionName5188  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_indexedFunctionName5188_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000), ANTLR3_UINT64_LIT(0x080000400001FE00), ANTLR3_UINT64_LIT(0x0000007E2A000100) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_indexedFunctionName5188	= { FOLLOW_INDEX_TOK_in_indexedFunctionName5188_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_161_in_indexedFunctionName5196  */
static	ANTLR3_BITWORD FOLLOW_161_in_indexedFunctionName5196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_161_in_indexedFunctionName5196	= { FOLLOW_161_in_indexedFunctionName5196_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5200  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5200	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5200_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5204  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5204	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5204_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_162_in_indexedFunctionName5220  */
static	ANTLR3_BITWORD FOLLOW_162_in_indexedFunctionName5220_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_162_in_indexedFunctionName5220	= { FOLLOW_162_in_indexedFunctionName5220_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5224  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5224_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5224	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5224_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_166_in_indexedFunctionName5240  */
static	ANTLR3_BITWORD FOLLOW_166_in_indexedFunctionName5240_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_166_in_indexedFunctionName5240	= { FOLLOW_166_in_indexedFunctionName5240_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5244  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5244_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5244	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5244_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_165_in_indexedFunctionName5260  */
static	ANTLR3_BITWORD FOLLOW_165_in_indexedFunctionName5260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_165_in_indexedFunctionName5260	= { FOLLOW_165_in_indexedFunctionName5260_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5264  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5264_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5264	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5264_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_163_in_indexedFunctionName5280  */
static	ANTLR3_BITWORD FOLLOW_163_in_indexedFunctionName5280_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_163_in_indexedFunctionName5280	= { FOLLOW_163_in_indexedFunctionName5280_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5284  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5284_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5284	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5284_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_164_in_indexedFunctionName5300  */
static	ANTLR3_BITWORD FOLLOW_164_in_indexedFunctionName5300_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_164_in_indexedFunctionName5300	= { FOLLOW_164_in_indexedFunctionName5300_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5304  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5304_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5304	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5304_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName5320  */
static	ANTLR3_BITWORD FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName5320_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName5320	= { FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName5320_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5324  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5324	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5324_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT2BV_TOK_in_indexedFunctionName5340  */
static	ANTLR3_BITWORD FOLLOW_INT2BV_TOK_in_indexedFunctionName5340_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INT2BV_TOK_in_indexedFunctionName5340	= { FOLLOW_INT2BV_TOK_in_indexedFunctionName5340_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5344  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5344_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5344	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5344_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5360  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5360_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5360	= { FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5360_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5364  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5364_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5364	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5364_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5368  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5368_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5368	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5368_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5384  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5384_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5384	= { FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5384_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5388  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5388_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5388	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5388_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5392  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5392_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5392	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5392_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5408  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5408_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5408	= { FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5408_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5412  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5412_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5412	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5412_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5416  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5416	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5416_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5432  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5432_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5432	= { FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5432_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5436  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5436_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5436	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5436_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5440  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5440_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5440	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5440_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5456  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5456_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5456	= { FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5456_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5460  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5460_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5460	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5460_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5464  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5464	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5464_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5480  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5480_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5480	= { FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5480_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5484  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5484_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5484	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5484_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5488  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5488_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5488	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5488_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5504  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5504_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5504	= { FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5504_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5508  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5508_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5508	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5508_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5524  */
static	ANTLR3_BITWORD FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5524_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5524	= { FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5524_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5528  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5528_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5528	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5528_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TESTER_TOK_in_indexedFunctionName5544  */
static	ANTLR3_BITWORD FOLLOW_TESTER_TOK_in_indexedFunctionName5544_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510000), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_TESTER_TOK_in_indexedFunctionName5544	= { FOLLOW_TESTER_TOK_in_indexedFunctionName5544_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_indexedFunctionName5546  */
static	ANTLR3_BITWORD FOLLOW_term_in_indexedFunctionName5546_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_indexedFunctionName5546	= { FOLLOW_term_in_indexedFunctionName5546_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TUPLE_SEL_TOK_in_indexedFunctionName5557  */
static	ANTLR3_BITWORD FOLLOW_TUPLE_SEL_TOK_in_indexedFunctionName5557_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TUPLE_SEL_TOK_in_indexedFunctionName5557	= { FOLLOW_TUPLE_SEL_TOK_in_indexedFunctionName5557_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5561  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5561_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5561	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5561_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_badIndexedFunctionName_in_indexedFunctionName5572  */
static	ANTLR3_BITWORD FOLLOW_badIndexedFunctionName_in_indexedFunctionName5572_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_badIndexedFunctionName_in_indexedFunctionName5572	= { FOLLOW_badIndexedFunctionName_in_indexedFunctionName5572_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_indexedFunctionName5584  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_indexedFunctionName5584_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_indexedFunctionName5584	= { FOLLOW_RPAREN_TOK_in_indexedFunctionName5584_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_badIndexedFunctionName5606  */
static	ANTLR3_BITWORD FOLLOW_set_in_badIndexedFunctionName5606_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_badIndexedFunctionName5606	= { FOLLOW_set_in_badIndexedFunctionName5606_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termList5647  */
static	ANTLR3_BITWORD FOLLOW_term_in_termList5647_bits[]	= { ANTLR3_UINT64_LIT(0x8008004801510002), ANTLR3_UINT64_LIT(0xB8044180800001FF), ANTLR3_UINT64_LIT(0x0000000435801940) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termList5647	= { FOLLOW_term_in_termList5647_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_2_0_in_str5669  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_2_0_in_str5669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_2_0_in_str5669	= { FOLLOW_STRING_LITERAL_2_0_in_str5669_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_2_5_in_str5681  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_2_5_in_str5681_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_2_5_in_str5681	= { FOLLOW_STRING_LITERAL_2_5_in_str5681_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_builtinOp5708  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_builtinOp5708_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_builtinOp5708	= { FOLLOW_NOT_TOK_in_builtinOp5708_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPLIES_TOK_in_builtinOp5721  */
static	ANTLR3_BITWORD FOLLOW_IMPLIES_TOK_in_builtinOp5721_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPLIES_TOK_in_builtinOp5721	= { FOLLOW_IMPLIES_TOK_in_builtinOp5721_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_builtinOp5730  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_builtinOp5730_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_builtinOp5730	= { FOLLOW_AND_TOK_in_builtinOp5730_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_builtinOp5743  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_builtinOp5743_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_builtinOp5743	= { FOLLOW_OR_TOK_in_builtinOp5743_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_XOR_TOK_in_builtinOp5757  */
static	ANTLR3_BITWORD FOLLOW_XOR_TOK_in_builtinOp5757_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_XOR_TOK_in_builtinOp5757	= { FOLLOW_XOR_TOK_in_builtinOp5757_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_builtinOp5770  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_builtinOp5770_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_builtinOp5770	= { FOLLOW_EQUAL_TOK_in_builtinOp5770_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_TOK_in_builtinOp5781  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_TOK_in_builtinOp5781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_TOK_in_builtinOp5781	= { FOLLOW_DISTINCT_TOK_in_builtinOp5781_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ITE_TOK_in_builtinOp5789  */
static	ANTLR3_BITWORD FOLLOW_ITE_TOK_in_builtinOp5789_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ITE_TOK_in_builtinOp5789	= { FOLLOW_ITE_TOK_in_builtinOp5789_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GREATER_THAN_TOK_in_builtinOp5802  */
static	ANTLR3_BITWORD FOLLOW_GREATER_THAN_TOK_in_builtinOp5802_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GREATER_THAN_TOK_in_builtinOp5802	= { FOLLOW_GREATER_THAN_TOK_in_builtinOp5802_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5827  */
static	ANTLR3_BITWORD FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5827	= { FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5852  */
static	ANTLR3_BITWORD FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5852_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5852	= { FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5852_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LESS_THAN_TOK_in_builtinOp5877  */
static	ANTLR3_BITWORD FOLLOW_LESS_THAN_TOK_in_builtinOp5877_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LESS_THAN_TOK_in_builtinOp5877	= { FOLLOW_LESS_THAN_TOK_in_builtinOp5877_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_TOK_in_builtinOp5902  */
static	ANTLR3_BITWORD FOLLOW_PLUS_TOK_in_builtinOp5902_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_TOK_in_builtinOp5902	= { FOLLOW_PLUS_TOK_in_builtinOp5902_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_builtinOp5914  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_builtinOp5914_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_builtinOp5914	= { FOLLOW_MINUS_TOK_in_builtinOp5914_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STAR_TOK_in_builtinOp5925  */
static	ANTLR3_BITWORD FOLLOW_STAR_TOK_in_builtinOp5925_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STAR_TOK_in_builtinOp5925	= { FOLLOW_STAR_TOK_in_builtinOp5925_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIV_TOK_in_builtinOp5937  */
static	ANTLR3_BITWORD FOLLOW_DIV_TOK_in_builtinOp5937_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DIV_TOK_in_builtinOp5937	= { FOLLOW_DIV_TOK_in_builtinOp5937_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BV2NAT_TOK_in_builtinOp5951  */
static	ANTLR3_BITWORD FOLLOW_BV2NAT_TOK_in_builtinOp5951_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BV2NAT_TOK_in_builtinOp5951	= { FOLLOW_BV2NAT_TOK_in_builtinOp5951_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DTSIZE_TOK_in_builtinOp5964  */
static	ANTLR3_BITWORD FOLLOW_DTSIZE_TOK_in_builtinOp5964_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DTSIZE_TOK_in_builtinOp5964	= { FOLLOW_DTSIZE_TOK_in_builtinOp5964_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FMFCARD_TOK_in_builtinOp5978  */
static	ANTLR3_BITWORD FOLLOW_FMFCARD_TOK_in_builtinOp5978_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FMFCARD_TOK_in_builtinOp5978	= { FOLLOW_FMFCARD_TOK_in_builtinOp5978_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FMFCARDVAL_TOK_in_builtinOp5991  */
static	ANTLR3_BITWORD FOLLOW_FMFCARDVAL_TOK_in_builtinOp5991_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FMFCARDVAL_TOK_in_builtinOp5991	= { FOLLOW_FMFCARDVAL_TOK_in_builtinOp5991_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INST_CLOSURE_TOK_in_builtinOp6001  */
static	ANTLR3_BITWORD FOLLOW_INST_CLOSURE_TOK_in_builtinOp6001_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INST_CLOSURE_TOK_in_builtinOp6001	= { FOLLOW_INST_CLOSURE_TOK_in_builtinOp6001_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_quantOp6043  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_quantOp6043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_quantOp6043	= { FOLLOW_EXISTS_TOK_in_quantOp6043_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_quantOp6054  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_quantOp6054_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_quantOp6054	= { FOLLOW_FORALL_TOK_in_quantOp6054_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_functionName6075  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_functionName6075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_functionName6075	= { FOLLOW_symbol_in_functionName6075_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sortList6099  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sortList6099_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500002), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sortList6099	= { FOLLOW_sortSymbol_in_sortList6099_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_nonemptySortList6126  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_nonemptySortList6126_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500002), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_nonemptySortList6126	= { FOLLOW_sortSymbol_in_nonemptySortList6126_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortedVarList6155  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortedVarList6155_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortedVarList6155	= { FOLLOW_LPAREN_TOK_in_sortedVarList6155_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortedVarList6157  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortedVarList6157_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortedVarList6157	= { FOLLOW_symbol_in_sortedVarList6157_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sortedVarList6166  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sortedVarList6166_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sortedVarList6166	= { FOLLOW_sortSymbol_in_sortedVarList6166_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortedVarList6169  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortedVarList6169_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortedVarList6169	= { FOLLOW_RPAREN_TOK_in_sortedVarList6169_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortName6200  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortName6200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortName6200	= { FOLLOW_symbol_in_sortName6200_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortName_in_sortSymbol6220  */
static	ANTLR3_BITWORD FOLLOW_sortName_in_sortSymbol6220_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortName_in_sortSymbol6220	= { FOLLOW_sortName_in_sortSymbol6220_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortSymbol6233  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortSymbol6233_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800011000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortSymbol6233	= { FOLLOW_LPAREN_TOK_in_sortSymbol6233_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_sortSymbol6236  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_sortSymbol6236_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_sortSymbol6236	= { FOLLOW_INDEX_TOK_in_sortSymbol6236_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortSymbol6249  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortSymbol6249_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800418000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortSymbol6249	= { FOLLOW_symbol_in_sortSymbol6249_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptyNumeralList_in_sortSymbol6258  */
static	ANTLR3_BITWORD FOLLOW_nonemptyNumeralList_in_sortSymbol6258_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptyNumeralList_in_sortSymbol6258	= { FOLLOW_nonemptyNumeralList_in_sortSymbol6258_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_sortSymbol6275  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_sortSymbol6275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_sortSymbol6275	= { FOLLOW_sortList_in_sortSymbol6275_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortSymbol6292  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortSymbol6292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortSymbol6292	= { FOLLOW_RPAREN_TOK_in_sortSymbol6292_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortSymbol6298  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortSymbol6298_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortSymbol6298	= { FOLLOW_LPAREN_TOK_in_sortSymbol6298_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HO_ARROW_TOK_in_sortSymbol6300  */
static	ANTLR3_BITWORD FOLLOW_HO_ARROW_TOK_in_sortSymbol6300_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800148) };
static  ANTLR3_BITSET_LIST FOLLOW_HO_ARROW_TOK_in_sortSymbol6300	= { FOLLOW_HO_ARROW_TOK_in_sortSymbol6300_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_sortSymbol6302  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_sortSymbol6302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_sortSymbol6302	= { FOLLOW_sortList_in_sortSymbol6302_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortSymbol6305  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortSymbol6305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortSymbol6305	= { FOLLOW_RPAREN_TOK_in_sortSymbol6305_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_symbolList6334  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_symbolList6334_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500002), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_symbolList6334	= { FOLLOW_symbol_in_symbolList6334_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_symbol6356  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_symbol6356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_symbol6356	= { FOLLOW_SIMPLE_SYMBOL_in_symbol6356_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_162_in_symbol6370  */
static	ANTLR3_BITWORD FOLLOW_162_in_symbol6370_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_162_in_symbol6370	= { FOLLOW_162_in_symbol6370_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_OPTIONS_TOK_in_symbol6386  */
static	ANTLR3_BITWORD FOLLOW_SET_OPTIONS_TOK_in_symbol6386_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_OPTIONS_TOK_in_symbol6386	= { FOLLOW_SET_OPTIONS_TOK_in_symbol6386_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_VAR_TOK_in_symbol6396  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_VAR_TOK_in_symbol6396_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_VAR_TOK_in_symbol6396	= { FOLLOW_DECLARE_VAR_TOK_in_symbol6396_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6406  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6406_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6406	= { FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6406_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_FUN_TOK_in_symbol6416  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_FUN_TOK_in_symbol6416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_FUN_TOK_in_symbol6416	= { FOLLOW_SYNTH_FUN_TOK_in_symbol6416_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SYNTH_INV_TOK_in_symbol6426  */
static	ANTLR3_BITWORD FOLLOW_SYNTH_INV_TOK_in_symbol6426_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SYNTH_INV_TOK_in_symbol6426	= { FOLLOW_SYNTH_INV_TOK_in_symbol6426_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONSTRAINT_TOK_in_symbol6436  */
static	ANTLR3_BITWORD FOLLOW_CONSTRAINT_TOK_in_symbol6436_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CONSTRAINT_TOK_in_symbol6436	= { FOLLOW_CONSTRAINT_TOK_in_symbol6436_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INV_CONSTRAINT_TOK_in_symbol6446  */
static	ANTLR3_BITWORD FOLLOW_INV_CONSTRAINT_TOK_in_symbol6446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INV_CONSTRAINT_TOK_in_symbol6446	= { FOLLOW_INV_CONSTRAINT_TOK_in_symbol6446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_SYNTH_TOK_in_symbol6456  */
static	ANTLR3_BITWORD FOLLOW_CHECK_SYNTH_TOK_in_symbol6456_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_SYNTH_TOK_in_symbol6456	= { FOLLOW_CHECK_SYNTH_TOK_in_symbol6456_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUOTED_SYMBOL_in_symbol6476  */
static	ANTLR3_BITWORD FOLLOW_QUOTED_SYMBOL_in_symbol6476_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_QUOTED_SYMBOL_in_symbol6476	= { FOLLOW_QUOTED_SYMBOL_in_symbol6476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6488  */
static	ANTLR3_BITWORD FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6488_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6488	= { FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6488_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_symbol6496  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_symbol6496_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_symbol6496	= { FOLLOW_EOF_in_symbol6496_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_160_in_symbol6512  */
static	ANTLR3_BITWORD FOLLOW_160_in_symbol6512_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_160_in_symbol6512	= { FOLLOW_160_in_symbol6512_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6544  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6544_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6544	= { FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6544_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypeDef6586  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypeDef6586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypeDef6586	= { FOLLOW_symbol_in_datatypeDef6586_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypeDef6609  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypeDef6609_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypeDef6609	= { FOLLOW_LPAREN_TOK_in_datatypeDef6609_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef6611  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef6611_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef6611	= { FOLLOW_constructorDef_in_datatypeDef6611_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypeDef6614  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypeDef6614_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypeDef6614	= { FOLLOW_RPAREN_TOK_in_datatypeDef6614_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_constructorDef6644  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_constructorDef6644_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_constructorDef6644	= { FOLLOW_symbol_in_constructorDef6644_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_constructorDef6659  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_constructorDef6659_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800010000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_constructorDef6659	= { FOLLOW_LPAREN_TOK_in_constructorDef6659_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef6661  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef6661_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef6661	= { FOLLOW_selector_in_constructorDef6661_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_constructorDef6664  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_constructorDef6664_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_constructorDef6664	= { FOLLOW_RPAREN_TOK_in_constructorDef6664_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_selector6692  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_selector6692_bits[]	= { ANTLR3_UINT64_LIT(0x0000004800500000), ANTLR3_UINT64_LIT(0x0800410000000000), ANTLR3_UINT64_LIT(0x0000000421800140) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_selector6692	= { FOLLOW_symbol_in_selector6692_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_selector6695  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_selector6695_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_selector6695	= { FOLLOW_sortSymbol_in_selector6695_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * ../../../../src/parser/smt2/Smt2.g:196:1: parseExpr returns [CVC4::parser::smt2::myExpr expr] : ( term[expr, expr2] | EOF );
 */
static CVC4::parser::smt2::myExpr
parseExpr(pSmt2Parser ctx)
{
    CVC4::parser::smt2::myExpr expr;



      Expr expr2;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:200:3: ( term[expr, expr2] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case EMPTYSET_TOK:
            case FP_RNA_FULL_TOK:
            case FP_RNA_TOK:
            case FP_RNE_FULL_TOK:
            case FP_RNE_TOK:
            case FP_RTN_FULL_TOK:
            case FP_RTN_TOK:
            case FP_RTP_FULL_TOK:
            case FP_RTP_TOK:
            case FP_RTZ_FULL_TOK:
            case FP_RTZ_TOK:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case INV_CONSTRAINT_TOK:
            case LPAREN_TOK:
            case NILREF_TOK:
            case QUOTED_SYMBOL:
            case REALLCHAR_TOK:
            case REAL_PI_TOK:
            case RENOSTR_TOK:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case TUPLE_CONST_TOK:
            case UNIVSET_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 162:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:200:5: term[expr, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_term_in_parseExpr119);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:201:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr126);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * ../../../../src/parser/smt2/Smt2.g:208:1: parseCommand returns [CVC4::Command* cmd_return = NULL] : ( LPAREN_TOK command[&cmd] RPAREN_TOK | LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK | EOF );
 */
static CVC4::Command*
parseCommand(pSmt2Parser ctx)
{
    CVC4::Command* cmd_return;



      std::unique_ptr<CVC4::Command> cmd;
      std::string name;

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:216:3: ( LPAREN_TOK command[&cmd] RPAREN_TOK | LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK | EOF )

            ANTLR3_UINT32 alt2;

            alt2=3;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case INCLUDE_TOK:
            			{
            				alt2=2;
            			}
            		    break;
            		case ASSERT_TOK:
            		case CHECK_SAT_ASSUMING_TOK:
            		case CHECK_SAT_TOK:
            		case DECLARE_CODATATYPES_2_5_TOK:
            		case DECLARE_CODATATYPES_TOK:
            		case DECLARE_CODATATYPE_TOK:
            		case DECLARE_CONST_TOK:
            		case DECLARE_DATATYPES_2_5_TOK:
            		case DECLARE_DATATYPES_TOK:
            		case DECLARE_DATATYPE_TOK:
            		case DECLARE_FUNS_TOK:
            		case DECLARE_FUN_TOK:
            		case DECLARE_PREDS_TOK:
            		case DECLARE_SORTS_TOK:
            		case DECLARE_SORT_TOK:
            		case DEFINE_CONST_TOK:
            		case DEFINE_FUNS_REC_TOK:
            		case DEFINE_FUN_REC_TOK:
            		case DEFINE_FUN_TOK:
            		case DEFINE_SORT_TOK:
            		case DEFINE_TOK:
            		case ECHO_TOK:
            		case EXIT_TOK:
            		case GET_ASSERTIONS_TOK:
            		case GET_ASSIGNMENT_TOK:
            		case GET_INFO_TOK:
            		case GET_MODEL_TOK:
            		case GET_OPTION_TOK:
            		case GET_PROOF_TOK:
            		case GET_QE_DISJUNCT_TOK:
            		case GET_QE_TOK:
            		case GET_UNSAT_ASSUMPTIONS_TOK:
            		case GET_UNSAT_CORE_TOK:
            		case GET_VALUE_TOK:
            		case META_INFO_TOK:
            		case POP_TOK:
            		case PROPAGATION_RULE_TOK:
            		case PUSH_TOK:
            		case REDUCTION_RULE_TOK:
            		case RESET_ASSERTIONS_TOK:
            		case RESET_TOK:
            		case REWRITE_RULE_TOK:
            		case SET_INFO_TOK:
            		case SET_LOGIC_TOK:
            		case SET_OPTION_TOK:
            		case SIMPLE_SYMBOL:
            		case SIMPLIFY_TOK:
            			{
            				alt2=1;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 2;
            		    EXCEPTION->state        = 1;


            		    goto ruleparseCommandEx;

            		}

            	}
                break;
            case EOF:
            	{
            		alt2=3;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:216:5: LPAREN_TOK command[&cmd] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand155);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_command_in_parseCommand157);
        	        command(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand160);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:221:5: LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand173);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_parseCommand175);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_str_in_parseCommand177);
        	        str(ctx, name, true);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand180);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {
        	             if(!PARSER_STATE->canIncludeFile()) {
        	                    PARSER_STATE->parseError("include-file feature was disabled for this "
        	                                             "run.");
        	                  }
        	                  if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError("Extended commands are not permitted while "
        	                                             "operating in strict compliance mode.");
        	                  }
        	                  PARSER_STATE->includeFile(name);
        	                  // The command of the included file will be produced at the next
        	                  // parseCommand() call
        	                  cmd.reset(new EmptyCommand("include::" + name));
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:236:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand193);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                      cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start parseSygus
 * ../../../../src/parser/smt2/Smt2.g:244:1: parseSygus returns [CVC4::Command* cmd_return = NULL] : ( LPAREN_TOK sygusCommand[&cmd] RPAREN_TOK | EOF );
 */
static CVC4::Command*
parseSygus(pSmt2Parser ctx)
{
    CVC4::Command* cmd_return;



      std::unique_ptr<CVC4::Command> cmd;
      std::string name;

    /* Initialize rule variables
     */
    cmd_return =  NULL;


    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:252:3: ( LPAREN_TOK sygusCommand[&cmd] RPAREN_TOK | EOF )

            ANTLR3_UINT32 alt3;

            alt3=2;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt3=1;
            	}
                break;
            case EOF:
            	{
            		alt3=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 3;
                EXCEPTION->state        = 0;


                goto ruleparseSygusEx;

            }

            switch (alt3)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:252:5: LPAREN_TOK sygusCommand[&cmd] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseSygus222);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sygusCommand_in_parseSygus224);
        	        sygusCommand(ctx, &cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseSygus227);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:253:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseSygus233);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseSygusEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseSygusEx; /* Prevent compiler warnings */
    ruleparseSygusEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
            else
            {
                {

                      cmd_return = cmd.release();

                }
            }


    return cmd_return;
}
/* $ANTLR end parseSygus */

/**
 * $ANTLR start command
 * ../../../../src/parser/smt2/Smt2.g:260:1: command[std::unique_ptr<CVC4::Command>* cmd] : ( SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT] | SET_INFO_TOK metaInfoInternal[cmd] | GET_INFO_TOK KEYWORD | SET_OPTION_TOK setOptionInternal[cmd] | GET_OPTION_TOK KEYWORD | DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL | DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DECLARE_FUN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSIGNMENT_TOK | ASSERT_TOK term[expr, expr2] | CHECK_SAT_TOK ( term[expr, expr2] |) | CHECK_SAT_ASSUMING_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | PUSH_TOK (k= INTEGER_LITERAL |) | POP_TOK (k= INTEGER_LITERAL |) | EXIT_TOK | smt25Command[cmd] | extendedCommand[cmd] | SIMPLE_SYMBOL );
 */
static void
command(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::string name;
      std::vector<std::string> names;
      Expr expr, expr2;
      Type t;
      std::vector<Expr> terms;
      std::vector<Type> sorts;
      std::vector<std::pair<std::string, Type> > sortedVarNames;
      std::vector<Expr> flattenVars;

    pANTLR3_COMMON_TOKEN    n;
    pANTLR3_COMMON_TOKEN    k;
    pANTLR3_COMMON_TOKEN    KEYWORD1;
    pANTLR3_COMMON_TOKEN    KEYWORD2;
    pANTLR3_COMMON_TOKEN    SIMPLE_SYMBOL3;

    /* Initialize rule variables
     */

    n       = NULL;
    k       = NULL;
    KEYWORD1       = NULL;
    KEYWORD2       = NULL;
    SIMPLE_SYMBOL3       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:271:3: ( SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT] | SET_INFO_TOK metaInfoInternal[cmd] | GET_INFO_TOK KEYWORD | SET_OPTION_TOK setOptionInternal[cmd] | GET_OPTION_TOK KEYWORD | DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL | DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DECLARE_FUN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSIGNMENT_TOK | ASSERT_TOK term[expr, expr2] | CHECK_SAT_TOK ( term[expr, expr2] |) | CHECK_SAT_ASSUMING_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | PUSH_TOK (k= INTEGER_LITERAL |) | POP_TOK (k= INTEGER_LITERAL |) | EXIT_TOK | smt25Command[cmd] | extendedCommand[cmd] | SIMPLE_SYMBOL )

            ANTLR3_UINT32 alt9;

            alt9=24;

            switch ( LA(1) )
            {
            case SET_LOGIC_TOK:
            	{
            		alt9=1;
            	}
                break;
            case SET_INFO_TOK:
            	{
            		alt9=2;
            	}
                break;
            case GET_INFO_TOK:
            	{
            		alt9=3;
            	}
                break;
            case SET_OPTION_TOK:
            	{
            		alt9=4;
            	}
                break;
            case GET_OPTION_TOK:
            	{
            		alt9=5;
            	}
                break;
            case DECLARE_SORT_TOK:
            	{
            		alt9=6;
            	}
                break;
            case DEFINE_SORT_TOK:
            	{
            		alt9=7;
            	}
                break;
            case DECLARE_FUN_TOK:
            	{
            		alt9=8;
            	}
                break;
            case DEFINE_FUN_TOK:
            	{
            		alt9=9;
            	}
                break;
            case GET_VALUE_TOK:
            	{
            		alt9=10;
            	}
                break;
            case GET_ASSIGNMENT_TOK:
            	{
            		alt9=11;
            	}
                break;
            case ASSERT_TOK:
            	{
            		alt9=12;
            	}
                break;
            case CHECK_SAT_TOK:
            	{
            		alt9=13;
            	}
                break;
            case CHECK_SAT_ASSUMING_TOK:
            	{
            		alt9=14;
            	}
                break;
            case GET_ASSERTIONS_TOK:
            	{
            		alt9=15;
            	}
                break;
            case GET_PROOF_TOK:
            	{
            		alt9=16;
            	}
                break;
            case GET_UNSAT_ASSUMPTIONS_TOK:
            	{
            		alt9=17;
            	}
                break;
            case GET_UNSAT_CORE_TOK:
            	{
            		alt9=18;
            	}
                break;
            case PUSH_TOK:
            	{
            		alt9=19;
            	}
                break;
            case POP_TOK:
            	{
            		alt9=20;
            	}
                break;
            case EXIT_TOK:
            	{
            		alt9=21;
            	}
                break;
            case DECLARE_CONST_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case ECHO_TOK:
            case GET_MODEL_TOK:
            case META_INFO_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            	{
            		alt9=22;
            	}
                break;
            case DECLARE_CODATATYPES_2_5_TOK:
            case DECLARE_CODATATYPES_TOK:
            case DECLARE_CODATATYPE_TOK:
            case DECLARE_DATATYPES_2_5_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_DATATYPE_TOK:
            case DECLARE_FUNS_TOK:
            case DECLARE_PREDS_TOK:
            case DECLARE_SORTS_TOK:
            case DEFINE_CONST_TOK:
            case DEFINE_TOK:
            case GET_QE_DISJUNCT_TOK:
            case GET_QE_TOK:
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            case REWRITE_RULE_TOK:
            case SIMPLIFY_TOK:
            	{
            		alt9=23;
            	}
                break;
            case SIMPLE_SYMBOL:
            	{
            		alt9=24;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 9;
                EXCEPTION->state        = 0;


                goto rulecommandEx;

            }

            switch (alt9)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:272:5: SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT]
        	    {
        	         MATCHT(SET_LOGIC_TOK, &FOLLOW_SET_LOGIC_TOK_in_command261);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command263);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             Debug("parser") << "set logic: '" << name << "'" << std::endl;
        	                  if( PARSER_STATE->logicIsSet() ) {
        	                    PARSER_STATE->parseError("Only one set-logic is allowed.");
        	                  }
        	                  PARSER_STATE->setLogic(name);
        	                  if( PARSER_STATE->sygus() ){
        	                    cmd->reset(new SetBenchmarkLogicCommand(PARSER_STATE->getLogic().getLogicString()));
        	                  }else{
        	                    cmd->reset(new SetBenchmarkLogicCommand(name));
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:285:5: SET_INFO_TOK metaInfoInternal[cmd]
        	    {
        	         MATCHT(SET_INFO_TOK, &FOLLOW_SET_INFO_TOK_in_command282);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_metaInfoInternal_in_command284);
        	        metaInfoInternal(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:287:5: GET_INFO_TOK KEYWORD
        	    {
        	         MATCHT(GET_INFO_TOK, &FOLLOW_GET_INFO_TOK_in_command297);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        KEYWORD1 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command299);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new GetInfoCommand(
        	                      AntlrInput::tokenText(KEYWORD1).c_str() + 1));
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:292:5: SET_OPTION_TOK setOptionInternal[cmd]
        	    {
        	         MATCHT(SET_OPTION_TOK, &FOLLOW_SET_OPTION_TOK_in_command317);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_setOptionInternal_in_command319);
        	        setOptionInternal(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:294:5: GET_OPTION_TOK KEYWORD
        	    {
        	         MATCHT(GET_OPTION_TOK, &FOLLOW_GET_OPTION_TOK_in_command332);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        KEYWORD2 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command334);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new GetOptionCommand(
        	                      AntlrInput::tokenText(KEYWORD2).c_str() + 1));
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:299:5: DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL
        	    {
        	         MATCHT(DECLARE_SORT_TOK, &FOLLOW_DECLARE_SORT_TOK_in_command352);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_DATATYPES) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS)) {
        	                      PARSER_STATE->parseErrorLogic("Free sort symbols not allowed in ");
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command366);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command381);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             Debug("parser") << "declare sort: '" << name
        	                                  << "' arity=" << n << std::endl;
        	                  unsigned arity = AntlrInput::tokenToUnsigned(n);
        	                  if(arity == 0) {
        	                    Type type = PARSER_STATE->mkSort(name);
        	                    cmd->reset(new DeclareTypeCommand(name, 0, type));
        	                  } else {
        	                    Type type = PARSER_STATE->mkSortConstructor(name, arity);
        	                    cmd->reset(new DeclareTypeCommand(name, arity, type));
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:322:5: DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DEFINE_SORT_TOK, &FOLLOW_DEFINE_SORT_TOK_in_command399);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command407);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command420);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolList_in_command422);
        	        symbolList(ctx, names, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command425);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::string>::const_iterator i = names.begin(),
        	                        iend = names.end();
        	                      i != iend;
        	                      ++i) {
        	                    sorts.push_back(PARSER_STATE->mkSort(*i));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command437);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  // Do NOT call mkSort, since that creates a new sort!
        	                  // This name is not its own distinct sort, it's an alias.
        	                  PARSER_STATE->defineParameterizedType(name, sorts, t);
        	                  cmd->reset(new DefineTypeCommand(name, sorts, t));
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:342:5: DECLARE_FUN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_FUN_TOK, &FOLLOW_DECLARE_FUN_TOK_in_command456);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command464);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command477);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortList_in_command479);
        	        sortList(ctx, sorts);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command482);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command488);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             Debug("parser") << "declare fun: '" << name << "'" << std::endl;
        	                  if( !sorts.empty() ) {
        	                    t = PARSER_STATE->mkFlatFunctionType(sorts, t);
        	                  }
        	                  if(t.isFunction() && !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	                    PARSER_STATE->parseErrorLogic("Functions (of non-zero arity) cannot "
        	                                                  "be declared in logic ");
        	                  }
        	                  // we allow overloading for function declarations
        	                  Expr func = PARSER_STATE->mkVar(name, t, ExprManager::VAR_FLAG_NONE, true);
        	                  cmd->reset(new DeclareFunctionCommand(name, func, t));
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/smt2/Smt2.g:360:5: DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2]
        	    {
        	         MATCHT(DEFINE_FUN_TOK, &FOLLOW_DEFINE_FUN_TOK_in_command507);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command515);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command528);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_command530);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command533);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command539);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             /* add variables to parser state before parsing term */
        	                  Debug("parser") << "define fun: '" << name << "'" << std::endl;
        	                  if( sortedVarNames.size() > 0 ) {
        	                    sorts.reserve(sortedVarNames.size());
        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                          sortedVarNames.begin(), iend = sortedVarNames.end();
        	                        i != iend;
        	                        ++i) {
        	                      sorts.push_back((*i).second);
        	                    }
        	                    t = PARSER_STATE->mkFlatFunctionType(sorts, t, flattenVars);
        	                  }
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command552);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {

        	                  if( !flattenVars.empty() ){
        	                    // if this function has any implicit variables flattenVars,
        	                    // we apply the body of the definition to the flatten vars
        	                    expr = PARSER_STATE->mkHoApply(expr, flattenVars);
        	                    terms.insert(terms.end(), flattenVars.begin(), flattenVars.end());
        	                  }
        	                  PARSER_STATE->popScope();
        	                  // declare the name down here (while parsing term, signature
        	                  // must not be extended with the name itself; no recursion
        	                  // permitted)
        	                  // we allow overloading for function definitions
        	                  Expr func = PARSER_STATE->mkFunction(name, t,
        	                                                       ExprManager::VAR_FLAG_DEFINED, true);
        	                  cmd->reset(new DefineFunctionCommand(name, func, terms, expr));
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/smt2/Smt2.g:403:5: GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	    {
        	         MATCHT(GET_VALUE_TOK, &FOLLOW_GET_VALUE_TOK_in_command571);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:404:5: ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	        {
        	            int alt4=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt4=1;
        	            	}
        	                break;
        	            case ALPHA:
        	            case AMPERSAND_TOK:
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case AS_TOK:
        	            case ATTRIBUTE_INST_LEVEL:
        	            case ATTRIBUTE_NAMED_TOK:
        	            case ATTRIBUTE_NO_PATTERN_TOK:
        	            case ATTRIBUTE_PATTERN_TOK:
        	            case ATTRIBUTE_RR_PRIORITY:
        	            case ATTRIBUTE_TOK:
        	            case AT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case COMMENT:
        	            case CONSTRAINT_TOK:
        	            case CONST_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_CODATATYPES_2_5_TOK:
        	            case DECLARE_CODATATYPES_TOK:
        	            case DECLARE_CODATATYPE_TOK:
        	            case DECLARE_CONST_TOK:
        	            case DECLARE_DATATYPES_2_5_TOK:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_DATATYPE_TOK:
        	            case DECLARE_FUNS_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_PREDS_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORTS_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_CONST_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DEFINE_TOK:
        	            case DIGIT:
        	            case DISTINCT_TOK:
        	            case DIVISIBLE_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case ECHO_TOK:
        	            case EMPTYSET_TOK:
        	            case EQUAL_TOK:
        	            case EXISTS_TOK:
        	            case EXIT_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case FORALL_TOK:
        	            case FP_NAN_TOK:
        	            case FP_NINF_TOK:
        	            case FP_NZERO_TOK:
        	            case FP_PINF_TOK:
        	            case FP_PZERO_TOK:
        	            case FP_RNA_FULL_TOK:
        	            case FP_RNA_TOK:
        	            case FP_RNE_FULL_TOK:
        	            case FP_RNE_TOK:
        	            case FP_RTN_FULL_TOK:
        	            case FP_RTN_TOK:
        	            case FP_RTP_FULL_TOK:
        	            case FP_RTP_TOK:
        	            case FP_RTZ_FULL_TOK:
        	            case FP_RTZ_TOK:
        	            case FP_TO_FPBV_TOK:
        	            case FP_TO_FPFP_TOK:
        	            case FP_TO_FPR_TOK:
        	            case FP_TO_FPS_TOK:
        	            case FP_TO_FPU_TOK:
        	            case FP_TO_FP_TOK:
        	            case FP_TO_SBV_TOK:
        	            case FP_TO_UBV_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_QE_DISJUNCT_TOK:
        	            case GET_QE_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_DIGIT:
        	            case HEX_LITERAL:
        	            case HO_ARROW_TOK:
        	            case HO_LAMBDA_TOK:
        	            case IMPLIES_TOK:
        	            case INCLUDE_TOK:
        	            case INDEX_TOK:
        	            case INST_CLOSURE_TOK:
        	            case INT2BV_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case LET_TOK:
        	            case MATCH_TOK:
        	            case META_INFO_TOK:
        	            case MINUS_TOK:
        	            case NILREF_TOK:
        	            case NOT_TOK:
        	            case NUMERAL:
        	            case OR_TOK:
        	            case PAR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case REALLCHAR_TOK:
        	            case REAL_PI_TOK:
        	            case REDUCTION_RULE_TOK:
        	            case RENOSTR_TOK:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case REWRITE_RULE_TOK:
        	            case RPAREN_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYGUS_CONSTANT_TOK:
        	            case SYGUS_ENUM_CONS_TOK:
        	            case SYGUS_ENUM_TOK:
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            case SYGUS_LET_TOK:
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            case SYGUS_QUOTED_LITERAL:
        	            case SYGUS_VARIABLE_TOK:
        	            case SYMBOL_CHAR:
        	            case SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case TESTER_TOK:
        	            case TUPLE_CONST_TOK:
        	            case TUPLE_SEL_TOK:
        	            case UNIVSET_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case WHITESPACE:
        	            case XOR_TOK:
        	            case 160:
        	            case 161:
        	            case 162:
        	            case 163:
        	            case 164:
        	            case 165:
        	            case 166:
        	            	{
        	            		alt4=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 4;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt4)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:404:7: LPAREN_TOK termList[terms,expr] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command581);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_command583);
        	        	        termList(ctx, terms, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command586);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             cmd->reset(new GetValueCommand(terms)); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:406:7: ~ LPAREN_TOK
        	        	    {
        	        	        if ( ((LA(1) >= ALPHA) && (LA(1) <= LET_TOK)) || ((LA(1) >= MATCH_TOK) && (LA(1) <= 166)) )
        	        	        {
        	        	            CONSUME();
        	        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        	        }
        	        	        else
        	        	        {
        	        	            CONSTRUCTEX();
        	        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	        	            EXCEPTION->expectingSet = NULL;

        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->parseError("The get-value command expects a list of "
        	        	                                             "terms.  Perhaps you forgot a pair of "
        	        	                                             "parentheses?");
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/smt2/Smt2.g:413:5: GET_ASSIGNMENT_TOK
        	    {
        	         MATCHT(GET_ASSIGNMENT_TOK, &FOLLOW_GET_ASSIGNMENT_TOK_in_command629);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetAssignmentCommand()); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/smt2/Smt2.g:416:5: ASSERT_TOK term[expr, expr2]
        	    {
        	         MATCHT(ASSERT_TOK, &FOLLOW_ASSERT_TOK_in_command649);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             PARSER_STATE->clearLastNamedTerm(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command669);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             bool inUnsatCore = PARSER_STATE->lastNamedTerm().first == expr;
        	                  cmd->reset(new AssertCommand(expr, inUnsatCore));
        	                  if(inUnsatCore) {
        	                    // set the expression name, if there was a named term
        	                    std::pair<Expr, std::string> namedTerm = PARSER_STATE->lastNamedTerm();
        	                    Command* csen = new SetExpressionNameCommand(namedTerm.first, namedTerm.second);
        	                    csen->setMuted(true);
        	                    PARSER_STATE->preemptCommand(csen);
        	                  }
        	                  // if sygus, check whether it has a free variable
        	                  // this is because, due to the sygus format, one can write assertions
        	                  // that have free function variables in them
        	                  if (PARSER_STATE->sygus())
        	                  {
        	                    if (expr.hasFreeVariable())
        	                    {
        	                      PARSER_STATE->parseError("Assertion has free variable. Perhaps you "
        	                                               "meant constraint instead of assert?");
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/smt2/Smt2.g:445:5: CHECK_SAT_TOK ( term[expr, expr2] |)
        	    {
        	         MATCHT(CHECK_SAT_TOK, &FOLLOW_CHECK_SAT_TOK_in_command688);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support check-sat command.");
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:450:5: ( term[expr, expr2] |)
        	        {
        	            int alt5=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case EMPTYSET_TOK:
        	            case FP_RNA_FULL_TOK:
        	            case FP_RNA_TOK:
        	            case FP_RNE_FULL_TOK:
        	            case FP_RNE_TOK:
        	            case FP_RTN_FULL_TOK:
        	            case FP_RTN_TOK:
        	            case FP_RTP_FULL_TOK:
        	            case FP_RTP_TOK:
        	            case FP_RTZ_FULL_TOK:
        	            case FP_RTZ_TOK:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case LPAREN_TOK:
        	            case NILREF_TOK:
        	            case QUOTED_SYMBOL:
        	            case REALLCHAR_TOK:
        	            case REAL_PI_TOK:
        	            case RENOSTR_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case TUPLE_CONST_TOK:
        	            case UNIVSET_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 162:
        	            	{
        	            		alt5=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt5=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 5;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt5)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:450:7: term[expr, expr2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_term_in_command704);
        	        	        term(ctx, expr, expr2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Extended commands (such as check-sat with an argument) are not "
        	        	                          "permitted while operating in strict compliance mode.");
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:457:7: 
        	        	    {
        	        	        {
        	        	             expr = Expr(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             cmd->reset(new CheckSatCommand(expr)); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/smt2/Smt2.g:461:5: CHECK_SAT_ASSUMING_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	    {
        	         MATCHT(CHECK_SAT_ASSUMING_TOK, &FOLLOW_CHECK_SAT_ASSUMING_TOK_in_command745);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:462:5: ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	        {
        	            int alt6=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt6=1;
        	            	}
        	                break;
        	            case ALPHA:
        	            case AMPERSAND_TOK:
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case AS_TOK:
        	            case ATTRIBUTE_INST_LEVEL:
        	            case ATTRIBUTE_NAMED_TOK:
        	            case ATTRIBUTE_NO_PATTERN_TOK:
        	            case ATTRIBUTE_PATTERN_TOK:
        	            case ATTRIBUTE_RR_PRIORITY:
        	            case ATTRIBUTE_TOK:
        	            case AT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case COMMENT:
        	            case CONSTRAINT_TOK:
        	            case CONST_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_CODATATYPES_2_5_TOK:
        	            case DECLARE_CODATATYPES_TOK:
        	            case DECLARE_CODATATYPE_TOK:
        	            case DECLARE_CONST_TOK:
        	            case DECLARE_DATATYPES_2_5_TOK:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_DATATYPE_TOK:
        	            case DECLARE_FUNS_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_PREDS_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORTS_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_CONST_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DEFINE_TOK:
        	            case DIGIT:
        	            case DISTINCT_TOK:
        	            case DIVISIBLE_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case ECHO_TOK:
        	            case EMPTYSET_TOK:
        	            case EQUAL_TOK:
        	            case EXISTS_TOK:
        	            case EXIT_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case FORALL_TOK:
        	            case FP_NAN_TOK:
        	            case FP_NINF_TOK:
        	            case FP_NZERO_TOK:
        	            case FP_PINF_TOK:
        	            case FP_PZERO_TOK:
        	            case FP_RNA_FULL_TOK:
        	            case FP_RNA_TOK:
        	            case FP_RNE_FULL_TOK:
        	            case FP_RNE_TOK:
        	            case FP_RTN_FULL_TOK:
        	            case FP_RTN_TOK:
        	            case FP_RTP_FULL_TOK:
        	            case FP_RTP_TOK:
        	            case FP_RTZ_FULL_TOK:
        	            case FP_RTZ_TOK:
        	            case FP_TO_FPBV_TOK:
        	            case FP_TO_FPFP_TOK:
        	            case FP_TO_FPR_TOK:
        	            case FP_TO_FPS_TOK:
        	            case FP_TO_FPU_TOK:
        	            case FP_TO_FP_TOK:
        	            case FP_TO_SBV_TOK:
        	            case FP_TO_UBV_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_QE_DISJUNCT_TOK:
        	            case GET_QE_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_DIGIT:
        	            case HEX_LITERAL:
        	            case HO_ARROW_TOK:
        	            case HO_LAMBDA_TOK:
        	            case IMPLIES_TOK:
        	            case INCLUDE_TOK:
        	            case INDEX_TOK:
        	            case INST_CLOSURE_TOK:
        	            case INT2BV_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case LET_TOK:
        	            case MATCH_TOK:
        	            case META_INFO_TOK:
        	            case MINUS_TOK:
        	            case NILREF_TOK:
        	            case NOT_TOK:
        	            case NUMERAL:
        	            case OR_TOK:
        	            case PAR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case REALLCHAR_TOK:
        	            case REAL_PI_TOK:
        	            case REDUCTION_RULE_TOK:
        	            case RENOSTR_TOK:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case REWRITE_RULE_TOK:
        	            case RPAREN_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYGUS_CONSTANT_TOK:
        	            case SYGUS_ENUM_CONS_TOK:
        	            case SYGUS_ENUM_TOK:
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            case SYGUS_LET_TOK:
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            case SYGUS_QUOTED_LITERAL:
        	            case SYGUS_VARIABLE_TOK:
        	            case SYMBOL_CHAR:
        	            case SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case TESTER_TOK:
        	            case TUPLE_CONST_TOK:
        	            case TUPLE_SEL_TOK:
        	            case UNIVSET_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case WHITESPACE:
        	            case XOR_TOK:
        	            case 160:
        	            case 161:
        	            case 162:
        	            case 163:
        	            case 164:
        	            case 165:
        	            case 166:
        	            	{
        	            		alt6=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 6;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt6)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:462:7: LPAREN_TOK termList[terms,expr] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command755);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_command757);
        	        	        termList(ctx, terms, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command760);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             cmd->reset(new CheckSatAssumingCommand(terms)); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:464:7: ~ LPAREN_TOK
        	        	    {
        	        	        if ( ((LA(1) >= ALPHA) && (LA(1) <= LET_TOK)) || ((LA(1) >= MATCH_TOK) && (LA(1) <= 166)) )
        	        	        {
        	        	            CONSUME();
        	        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        	        }
        	        	        else
        	        	        {
        	        	            CONSTRUCTEX();
        	        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	        	            EXCEPTION->expectingSet = NULL;

        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->parseError("The check-sat-assuming command expects a "
        	        	                                             "list of terms.  Perhaps you forgot a pair of "
        	        	                                             "parentheses?");
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/smt2/Smt2.g:471:5: GET_ASSERTIONS_TOK
        	    {
        	         MATCHT(GET_ASSERTIONS_TOK, &FOLLOW_GET_ASSERTIONS_TOK_in_command803);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetAssertionsCommand()); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/smt2/Smt2.g:474:5: GET_PROOF_TOK
        	    {
        	         MATCHT(GET_PROOF_TOK, &FOLLOW_GET_PROOF_TOK_in_command823);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetProofCommand()); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/smt2/Smt2.g:477:5: GET_UNSAT_ASSUMPTIONS_TOK
        	    {
        	         MATCHT(GET_UNSAT_ASSUMPTIONS_TOK, &FOLLOW_GET_UNSAT_ASSUMPTIONS_TOK_in_command843);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetUnsatAssumptionsCommand); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/smt2/Smt2.g:480:5: GET_UNSAT_CORE_TOK
        	    {
        	         MATCHT(GET_UNSAT_CORE_TOK, &FOLLOW_GET_UNSAT_CORE_TOK_in_command863);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetUnsatCoreCommand); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/smt2/Smt2.g:483:5: PUSH_TOK (k= INTEGER_LITERAL |)
        	    {
        	         MATCHT(PUSH_TOK, &FOLLOW_PUSH_TOK_in_command883);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support push command.");
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:488:5: (k= INTEGER_LITERAL |)
        	        {
        	            int alt7=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt7=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt7=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 7;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt7)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:488:7: k= INTEGER_LITERAL
        	        	    {
        	        	        k = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command901);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             unsigned n = AntlrInput::tokenToUnsigned(k);
        	        	                    if(n == 0) {
        	        	                      cmd->reset(new EmptyCommand());
        	        	                    } else if(n == 1) {
        	        	                      PARSER_STATE->pushScope();
        	        	                      cmd->reset(new PushCommand());
        	        	                    } else {
        	        	                      std::unique_ptr<CommandSequence> seq(new CommandSequence());
        	        	                      do {
        	        	                        PARSER_STATE->pushScope();
        	        	                        Command* push_cmd = new PushCommand();
        	        	                        push_cmd->setMuted(n > 1);
        	        	                        seq->addCommand(push_cmd);
        	        	                        --n;
        	        	                        } while(n > 0);
        	        	                      cmd->reset(seq.release());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:507:7: 
        	        	    {
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Strict compliance mode demands an integer to be provided to "
        	        	                          "PUSH.  Maybe you want (push 1)?");
        	        	                    } else {
        	        	                      PARSER_STATE->pushScope();
        	        	                      cmd->reset(new PushCommand());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/smt2/Smt2.g:516:5: POP_TOK (k= INTEGER_LITERAL |)
        	    {
        	         MATCHT(POP_TOK, &FOLLOW_POP_TOK_in_command925);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if( PARSER_STATE->sygus() ){
        	                    PARSER_STATE->parseError("Sygus does not support pop command.");
        	                  }
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:521:5: (k= INTEGER_LITERAL |)
        	        {
        	            int alt8=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt8=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt8=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 8;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt8)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:521:7: k= INTEGER_LITERAL
        	        	    {
        	        	        k = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command943);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }


        	        	        {
        	        	             unsigned n = AntlrInput::tokenToUnsigned(k);
        	        	                    if(n > PARSER_STATE->scopeLevel()) {
        	        	                      PARSER_STATE->parseError("Attempted to pop above the top stack "
        	        	                                               "frame.");
        	        	                    }
        	        	                    if(n == 0) {
        	        	                      cmd->reset(new EmptyCommand());
        	        	                    } else if(n == 1) {
        	        	                      PARSER_STATE->popScope();
        	        	                      cmd->reset(new PopCommand());
        	        	                    } else {
        	        	                      std::unique_ptr<CommandSequence> seq(new CommandSequence());
        	        	                      do {
        	        	                        PARSER_STATE->popScope();
        	        	                        Command* pop_command = new PopCommand();
        	        	                        pop_command->setMuted(n > 1);
        	        	                        seq->addCommand(pop_command);
        	        	                        --n;
        	        	                      } while(n > 0);
        	        	                      cmd->reset(seq.release());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:544:7: 
        	        	    {
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError(
        	        	                          "Strict compliance mode demands an integer to be provided to POP."
        	        	                          "Maybe you want (pop 1)?");
        	        	                    } else {
        	        	                      PARSER_STATE->popScope();
        	        	                      cmd->reset(new PopCommand());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/smt2/Smt2.g:555:5: EXIT_TOK
        	    {
        	         MATCHT(EXIT_TOK, &FOLLOW_EXIT_TOK_in_command977);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             cmd->reset(new QuitCommand()); 
        	        }


        	    }
        	    break;
        	case 22:
        	    // ../../../../src/parser/smt2/Smt2.g:559:5: smt25Command[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_smt25Command_in_command996);
        	        smt25Command(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             if(PARSER_STATE->v2_0() && PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError(
        	                        "SMT-LIB 2.5 commands are not permitted while operating in strict "
        	                        "compliance mode and in SMT-LIB 2.0 mode.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 23:
        	    // ../../../../src/parser/smt2/Smt2.g:568:5: extendedCommand[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_extendedCommand_in_command1016);
        	        extendedCommand(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError(
        	                        "Extended commands are not permitted while operating in strict "
        	                        "compliance mode.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 24:
        	    // ../../../../src/parser/smt2/Smt2.g:577:5: SIMPLE_SYMBOL
        	    {
        	        SIMPLE_SYMBOL3 = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_command1036);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }


        	        {
        	             std::string id = AntlrInput::tokenText(SIMPLE_SYMBOL3);
        	                  if(id == "benchmark") {
        	                    PARSER_STATE->parseError(
        	                        "In SMT-LIBv2 mode, but got something that looks like SMT-LIBv1. "
        	                        "Use --lang smt1 for SMT-LIBv1.");
        	                  } else {
        	                    PARSER_STATE->parseError("expected SMT-LIBv2 command, got `" + id +
        	                                             "'.");
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecommandEx; /* Prevent compiler warnings */
    rulecommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end command */

/**
 * $ANTLR start sygusCommand
 * ../../../../src/parser/smt2/Smt2.g:590:1: sygusCommand[std::unique_ptr<CVC4::Command>* cmd] : ( DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )? | CONSTRAINT_TOK term[expr, expr2] | INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+ | CHECK_SYNTH_TOK | command[cmd] );
 */
static void
sygusCommand(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::string name, fun;
      std::vector<std::string> names;
      Expr expr, expr2;
      Type t, range;
      std::vector<Expr> terms;
      std::vector<Type> sorts;
      std::vector<Expr> sygus_vars;
      std::vector<std::pair<std::string, Type> > sortedVarNames;
      SExpr sexpr;
      std::unique_ptr<CVC4::CommandSequence> seq;
      std::vector< std::vector< CVC4::SygusGTerm > > sgts;
      std::vector< CVC4::Datatype > datatypes;
      std::vector< std::vector<Expr> > ops;
      std::vector< std::vector< std::string > > cnames;
      std::vector< std::vector< std::vector< CVC4::Type > > > cargs;
      std::vector< bool > allow_const;
      std::vector< std::vector< std::string > > unresolved_gterm_sym;
      bool read_syntax = false;
      Type sygus_ret;
      std::map< CVC4::Type, CVC4::Type > sygus_to_builtin;
      std::map< CVC4::Type, CVC4::Expr > sygus_to_builtin_expr;
      int startIndex = -1;
      Expr synth_fun;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:616:3: ( DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )? | CONSTRAINT_TOK term[expr, expr2] | INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+ | CHECK_SYNTH_TOK | command[cmd] )

            ANTLR3_UINT32 alt16;

            alt16=7;

            switch ( LA(1) )
            {
            case DECLARE_VAR_TOK:
            	{
            		alt16=1;
            	}
                break;
            case DECLARE_PRIMED_VAR_TOK:
            	{
            		alt16=2;
            	}
                break;
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            	{
            		alt16=3;
            	}
                break;
            case CONSTRAINT_TOK:
            	{
            		alt16=4;
            	}
                break;
            case INV_CONSTRAINT_TOK:
            	{
            		alt16=5;
            	}
                break;
            case CHECK_SYNTH_TOK:
            	{
            		alt16=6;
            	}
                break;
            case ASSERT_TOK:
            case CHECK_SAT_ASSUMING_TOK:
            case CHECK_SAT_TOK:
            case DECLARE_CODATATYPES_2_5_TOK:
            case DECLARE_CODATATYPES_TOK:
            case DECLARE_CODATATYPE_TOK:
            case DECLARE_CONST_TOK:
            case DECLARE_DATATYPES_2_5_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_DATATYPE_TOK:
            case DECLARE_FUNS_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_PREDS_TOK:
            case DECLARE_SORTS_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_CONST_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DEFINE_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_QE_DISJUNCT_TOK:
            case GET_QE_TOK:
            case GET_UNSAT_ASSUMPTIONS_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case META_INFO_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case REDUCTION_RULE_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            	{
            		alt16=7;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 16;
                EXCEPTION->state        = 0;


                goto rulesygusCommandEx;

            }

            switch (alt16)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:617:5: DECLARE_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_VAR_TOK, &FOLLOW_DECLARE_VAR_TOK_in_sygusCommand1068);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1076);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1089);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->mkSygusVar(name, t);
        	                  cmd->reset(new EmptyCommand());
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:625:5: DECLARE_PRIMED_VAR_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_PRIMED_VAR_TOK, &FOLLOW_DECLARE_PRIMED_VAR_TOK_in_sygusCommand1108);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1116);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1129);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->mkSygusVar(name, t, true);
        	                  cmd->reset(new EmptyCommand());
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:634:5: ( SYNTH_FUN_TOK | SYNTH_INV_TOK ) symbol[fun,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK ( sortSymbol[range,CHECK_DECLARED] )? ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )?
        	    {
        	        // ../../../../src/parser/smt2/Smt2.g:634:5: ( SYNTH_FUN_TOK | SYNTH_INV_TOK )
        	        {
        	            int alt10=2;
        	            switch ( LA(1) )
        	            {
        	            case SYNTH_FUN_TOK:
        	            	{
        	            		alt10=1;
        	            	}
        	                break;
        	            case SYNTH_INV_TOK:
        	            	{
        	            		alt10=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 10;
        	                EXCEPTION->state        = 0;


        	                goto rulesygusCommandEx;

        	            }

        	            switch (alt10)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:634:7: SYNTH_FUN_TOK
        	        	    {
        	        	         MATCHT(SYNTH_FUN_TOK, &FOLLOW_SYNTH_FUN_TOK_in_sygusCommand1151);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:634:23: SYNTH_INV_TOK
        	        	    {
        	        	         MATCHT(SYNTH_INV_TOK, &FOLLOW_SYNTH_INV_TOK_in_sygusCommand1155);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        {
        	        	             range = EXPR_MANAGER->booleanType(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1171);
        	        symbol(ctx, fun, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1178);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_sygusCommand1180);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1183);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:638:5: ( sortSymbol[range,CHECK_DECLARED] )?
        	        {
        	            int alt11=2;
        	            switch ( LA(1) )
        	            {
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_VAR_TOK:
        	                case INV_CONSTRAINT_TOK:
        	                case QUOTED_SYMBOL:
        	                case SET_OPTIONS_TOK:
        	                case SIMPLE_SYMBOL:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 162:
        	                	{
        	                		alt11=1;
        	                	}
        	                    break;
        	                case LPAREN_TOK:
        	                	{
        	                		switch ( LA(2) )
        	                		{
        	                		    case CHECK_SYNTH_TOK:
        	                		    case CONSTRAINT_TOK:
        	                		    case DECLARE_PRIMED_VAR_TOK:
        	                		    case DECLARE_VAR_TOK:
        	                		    case HO_ARROW_TOK:
        	                		    case INDEX_TOK:
        	                		    case INV_CONSTRAINT_TOK:
        	                		    case QUOTED_SYMBOL:
        	                		    case SET_OPTIONS_TOK:
        	                		    case SIMPLE_SYMBOL:
        	                		    case SYNTH_FUN_TOK:
        	                		    case SYNTH_INV_TOK:
        	                		    case UNTERMINATED_QUOTED_SYMBOL:
        	                		    case 162:
        	                		    	{
        	                		    		alt11=1;
        	                		    	}
        	                		        break;
        	                		}

        	                	}
        	                    break;
        	            }

        	            switch (alt11)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:638:7: sortSymbol[range,CHECK_DECLARED]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1191);
        	        	        sortSymbol(ctx, range, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  if( range.isNull() ){
        	                    PARSER_STATE->parseError("Must supply return type for synth-fun.");
        	                  }
        	                  if( range.isFunction() ){
        	                    PARSER_STATE->parseError("Cannot use synth-fun with function return type.");
        	                  }
        	                  seq.reset(new CommandSequence());
        	                  std::vector<Type> var_sorts;
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	                      ++i) {
        	                    var_sorts.push_back( (*i).second );
        	                  }
        	                  Debug("parser-sygus") << "Define synth fun : " << fun << std::endl;
        	                  Type synth_fun_type;
        	                  if( var_sorts.size()>0 ){
        	                    synth_fun_type = EXPR_MANAGER->mkFunctionType(var_sorts, range);
        	                  }else{
        	                    synth_fun_type = range;
        	                  }
        	                  // we do not allow overloading for synth fun
        	                  synth_fun = PARSER_STATE->mkBoundVar(fun, synth_fun_type);
        	                  // we add a declare function command here
        	                  // this is the single unmuted command in the sequence generated by this smt2 command
        	                  // TODO (as part of #1170) : make this a standard command.
        	                  seq->addCommand(new DeclareFunctionCommand(fun, synth_fun, synth_fun_type));
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	                      ++i) {
        	                    Expr v = PARSER_STATE->mkBoundVar((*i).first, (*i).second);
        	                    terms.push_back( v );
        	                    sygus_vars.push_back( v );
        	                  }
        	                  Expr bvl;
        	                  if( !terms.empty() ){
        	                    bvl = MK_EXPR(kind::BOUND_VAR_LIST, terms);
        	                  }
        	                  terms.clear();
        	                  terms.push_back(bvl);
        	                  // associate this variable list with the synth fun
        	                  std::vector< Expr > attr_val_bvl;
        	                  attr_val_bvl.push_back( bvl );
        	                  Command* cattr_bvl = new SetUserAttributeCommand("sygus-synth-fun-var-list", synth_fun, attr_val_bvl);
        	                  cattr_bvl->setMuted(true);
        	                  PARSER_STATE->preemptCommand(cattr_bvl);
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:686:5: ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK )?
        	        {
        	            int alt14=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt14=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt14)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:686:7: LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+ RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1205);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        // ../../../../src/parser/smt2/Smt2.g:687:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK )+
        	        	        {
        	        	            int cnt13=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt13=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case LPAREN_TOK:
        	        	        		{
        	        	        			alt13=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt13)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // ../../../../src/parser/smt2/Smt2.g:687:7: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] LPAREN_TOK ( sygusGTerm[ sgts.back().back(), fun] )+ RPAREN_TOK RPAREN_TOK
        	        	        	        {
        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1213);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1221);
        	        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusCommand1231);
        	        	        	            sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 std::stringstream ss;
        	        	        	                        ss << fun << "_" << name;
        	        	        	                        if( name=="Start" ){
        	        	        	                          startIndex = datatypes.size();
        	        	        	                        }
        	        	        	                        std::string dname = ss.str();
        	        	        	                        sgts.push_back( std::vector< CVC4::SygusGTerm >() );
        	        	        	                        sgts.back().push_back( CVC4::SygusGTerm() );
        	        	        	                        PARSER_STATE->pushSygusDatatypeDef(
        	        	        	                            t, dname, datatypes, sorts, ops, cnames, cargs, allow_const,
        	        	        	                            unresolved_gterm_sym);
        	        	        	                        Type unres_t;
        	        	        	                        if(!PARSER_STATE->isUnresolvedType(dname)) {
        	        	        	                          // if not unresolved, must be undeclared
        	        	        	                          Debug("parser-sygus") << "Make unresolved type : " << dname
        	        	        	                                                << std::endl;
        	        	        	                          PARSER_STATE->checkDeclaration(dname, CHECK_UNDECLARED, SYM_SORT);
        	        	        	                          unres_t = PARSER_STATE->mkUnresolvedType(dname);
        	        	        	                        }else{
        	        	        	                          Debug("parser-sygus") << "Get sort : " << dname << std::endl;
        	        	        	                          unres_t = PARSER_STATE->getSort(dname);
        	        	        	                        }
        	        	        	                        sygus_to_builtin[unres_t] = t;
        	        	        	                        Debug("parser-sygus") << "--- Read sygus grammar " << name
        	        	        	                                              << " under function " << fun << "..."
        	        	        	                                              << std::endl
        	        	        	                                              << "    type to resolve " << unres_t << std::endl
        	        	        	                                              << "    builtin type " << t << std::endl;
        	        	        	                      
        	        	        	            }


        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusCommand1262);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            // ../../../../src/parser/smt2/Smt2.g:721:18: ( sygusGTerm[ sgts.back().back(), fun] )+
        	        	        	            {
        	        	        	                int cnt12=0;

        	        	        	                for (;;)
        	        	        	                {
        	        	        	                    int alt12=2;
        	        	        	            	switch ( LA(1) )
        	        	        	            	{
        	        	        	            	case BINARY_LITERAL:
        	        	        	            	case CHECK_SYNTH_TOK:
        	        	        	            	case CONSTRAINT_TOK:
        	        	        	            	case DECLARE_PRIMED_VAR_TOK:
        	        	        	            	case DECLARE_VAR_TOK:
        	        	        	            	case HEX_LITERAL:
        	        	        	            	case INTEGER_LITERAL:
        	        	        	            	case INV_CONSTRAINT_TOK:
        	        	        	            	case LPAREN_TOK:
        	        	        	            	case QUOTED_SYMBOL:
        	        	        	            	case SET_OPTIONS_TOK:
        	        	        	            	case SIMPLE_SYMBOL:
        	        	        	            	case STRING_LITERAL_2_0:
        	        	        	            	case STRING_LITERAL_2_5:
        	        	        	            	case SYNTH_FUN_TOK:
        	        	        	            	case SYNTH_INV_TOK:
        	        	        	            	case UNTERMINATED_QUOTED_SYMBOL:
        	        	        	            	case 162:
        	        	        	            		{
        	        	        	            			alt12=1;
        	        	        	            		}
        	        	        	            	    break;

        	        	        	            	}

        	        	        	            	switch (alt12)
        	        	        	            	{
        	        	        	            	    case 1:
        	        	        	            	        // ../../../../src/parser/smt2/Smt2.g:721:20: sygusGTerm[ sgts.back().back(), fun]
        	        	        	            	        {
        	        	        	            	            FOLLOWPUSH(FOLLOW_sygusGTerm_in_sygusCommand1266);
        	        	        	            	            sygusGTerm(ctx, sgts.back().back(), fun);

        	        	        	            	            FOLLOWPOP();
        	        	        	            	            if  (HASEXCEPTION())
        	        	        	            	            {
        	        	        	            	                goto rulesygusCommandEx;
        	        	        	            	            }


        	        	        	            	            {
        	        	        	            	                 sgts.back().push_back( CVC4::SygusGTerm() ); 
        	        	        	            	            }


        	        	        	            	        }
        	        	        	            	        break;

        	        	        	            	    default:

        	        	        	            		if ( cnt12 >= 1 )
        	        	        	            		{
        	        	        	            		    goto loop12;
        	        	        	            		}
        	        	        	            		/* mismatchedSetEx()
        	        	        	            		 */
        	        	        	            		CONSTRUCTEX();
        	        	        	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        	            		goto rulesygusCommandEx;
        	        	        	            	}
        	        	        	            	cnt12++;
        	        	        	                }
        	        	        	                loop12: ;	/* Jump to here if this rule does not match */
        	        	        	            }

        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1287);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 sgts.back().pop_back(); 
        	        	        	            }


        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1297);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusCommandEx;
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt13 >= 1 )
        	        	        		{
        	        	        		    goto loop13;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto rulesygusCommandEx;
        	        	        	}
        	        	        	cnt13++;
        	        	            }
        	        	            loop13: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusCommand1311);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusCommandEx;
        	        	        }


        	        	        {
        	        	             read_syntax = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             // the sygus sym type specifies the required grammar for synth_fun, expressed as a type
        	                  Type sygus_sym_type;
        	                  if( !read_syntax ){
        	                    sygus_sym_type = range;
        	                    PARSER_STATE->popScope();
        	                  }else{
        	                    Debug("parser-sygus") << "--- Process " << sgts.size()
        	                                          << " sygus gterms..." << std::endl;
        	                    for( unsigned i=0; i<sgts.size(); i++ ){
        	                      for( unsigned j=0; j<sgts[i].size(); j++ ){
        	                        Type sub_ret;
        	                        PARSER_STATE->processSygusGTerm(
        	                            sgts[i][j], i, datatypes, sorts, ops, cnames, cargs,
        	                            allow_const, unresolved_gterm_sym, sygus_vars, sygus_to_builtin,
        	                            sygus_to_builtin_expr, sub_ret );
        	                      }
        	                    }
        	                    //swap index if necessary
        	                    Debug("parser-sygus") << "--- Making sygus datatypes..." << std::endl;
        	                    for( unsigned i=0; i<datatypes.size(); i++ ){
        	                      Debug("parser-sygus") << "..." << datatypes[i].getName()
        	                                            << " has builtin sort " << sorts[i]
        	                                            << std::endl;
        	                    }
        	                    for( unsigned i=0; i<datatypes.size(); i++ ){
        	                      Debug("parser-sygus") << "...make " << datatypes[i].getName()
        	                                            << " with builtin sort " << sorts[i]
        	                                            << std::endl;
        	                      if( sorts[i].isNull() ){
        	                        PARSER_STATE->parseError("Internal error : could not infer "
        	                                                 "builtin sort for nested gterm.");
        	                      }
        	                      datatypes[i].setSygus( sorts[i], terms[0], allow_const[i], false );
        	                      PARSER_STATE->mkSygusDatatype(
        	                          datatypes[i], ops[i], cnames[i], cargs[i],
        	                          unresolved_gterm_sym[i], sygus_to_builtin );
        	                    }
        	                    PARSER_STATE->setSygusStartIndex(fun, startIndex, datatypes, sorts, ops);
        	                    //only care about datatypes/sorts/ops past here
        	                    PARSER_STATE->popScope();
        	                    Debug("parser-sygus") << "--- Make " << datatypes.size()
        	                                          << " mutual datatypes..." << std::endl;
        	                    for( unsigned i=0; i<datatypes.size(); i++ ){
        	                      Debug("parser-sygus") << "  " << i << " : " << datatypes[i].getName() << std::endl;
        	                    }
        	                    std::vector<DatatypeType> datatypeTypes =
        	                        PARSER_STATE->mkMutualDatatypeTypes(datatypes);
        	                    Command * cdd = new DatatypeDeclarationCommand(datatypeTypes);
        	                    // we set this command muted since there should only be one success printed
        	                    cdd->setMuted(true);
        	                    seq->addCommand(cdd);
        	                    if( sorts[0]!=range ){
        	                      PARSER_STATE->parseError(std::string("Bad return type in grammar for "
        	                                                           "SyGuS function ") + fun);
        	                    }
        	                    sygus_sym_type = datatypeTypes[0];
        	                  }
        	                  
        	                  // store a dummy variable which stands for second-order quantification, linked to synth fun by an attribute
        	                  PARSER_STATE->addSygusFunSymbol( sygus_sym_type, synth_fun );
        	                  cmd->reset(seq.release());
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:791:5: CONSTRAINT_TOK term[expr, expr2]
        	    {
        	         MATCHT(CONSTRAINT_TOK, &FOLLOW_CONSTRAINT_TOK_in_sygusCommand1338);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             
        	                  PARSER_STATE->checkThatLogicIsSet();
        	                  Debug("parser-sygus") << "Sygus : define sygus funs..." << std::endl;
        	                  Debug("parser-sygus") << "Sygus : read constraint..." << std::endl;
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_sygusCommand1346);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "...read constraint " << expr << std::endl;
        	                  PARSER_STATE->addSygusConstraint(expr);
        	                  cmd->reset(new EmptyCommand());
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:801:5: INV_CONSTRAINT_TOK ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+
        	    {
        	         MATCHT(INV_CONSTRAINT_TOK, &FOLLOW_INV_CONSTRAINT_TOK_in_sygusCommand1359);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	              
        	                  PARSER_STATE->checkThatLogicIsSet();
        	                  Debug("parser-sygus") << "Sygus : define sygus funs..." << std::endl;
        	                  Debug("parser-sygus") << "Sygus : read inv-constraint..." << std::endl;
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:806:5: ( symbol[name,CHECK_NONE,SYM_VARIABLE] )+
        	        {
        	            int cnt15=0;

        	            for (;;)
        	            {
        	                int alt15=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case CHECK_SYNTH_TOK:
        	        	case CONSTRAINT_TOK:
        	        	case DECLARE_PRIMED_VAR_TOK:
        	        	case DECLARE_VAR_TOK:
        	        	case INV_CONSTRAINT_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case SET_OPTIONS_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case SYNTH_FUN_TOK:
        	        	case SYNTH_INV_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 162:
        	        		{
        	        			alt15=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt15)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:806:7: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_symbol_in_sygusCommand1369);
        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesygusCommandEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                        if( !terms.empty() ){
        	        	                          if( !PARSER_STATE->isDefinedFunction(name) ){
        	        	                            std::stringstream ss;
        	        	                            ss << "Function " << name << " in inv-constraint is not defined.";
        	        	                            PARSER_STATE->parseError(ss.str());
        	        	                          }
        	        	                        }
        	        	                        terms.push_back( PARSER_STATE->getVariable(name) );
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt15 >= 1 )
        	        		{
        	        		    goto loop15;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesygusCommandEx;
        	        	}
        	        	cnt15++;
        	            }
        	            loop15: ;	/* Jump to here if this rule does not match */
        	        }

        	        {

        	                  if( terms.size()!=4 ){
        	                    PARSER_STATE->parseError("Bad syntax for inv-constraint: expected 4 "
        	                                             "arguments.");
        	                  }
        	                  //get primed variables
        	                  std::vector< Expr > primed[2];
        	                  std::vector< Expr > all;
        	                  for( unsigned i=0; i<2; i++ ){
        	                    PARSER_STATE->getSygusPrimedVars( primed[i], i==1 );
        	                    all.insert( all.end(), primed[i].begin(), primed[i].end() );
        	                  }
        	                  //make relevant terms
        	                  for( unsigned i=0; i<4; i++ ){
        	                    Expr op = terms[i];
        	                    Debug("parser-sygus") << "Make inv-constraint term #" << i << " : " << op  << "..." << std::endl;
        	                    std::vector< Expr > children;
        	                    children.push_back( op );
        	                    if( i==2 ){
        	                      children.insert( children.end(), all.begin(), all.end() );
        	                    }else{
        	                      children.insert( children.end(), primed[0].begin(), primed[0].end() );
        	                    }
        	                    terms[i] = EXPR_MANAGER->mkExpr( i==0 ? kind::APPLY_UF : kind::APPLY,children);
        	                    if( i==0 ){
        	                      std::vector< Expr > children2;
        	                      children2.push_back( op );
        	                      children2.insert(children2.end(), primed[1].begin(),
        	                                       primed[1].end());
        	                      terms.push_back( EXPR_MANAGER->mkExpr(kind::APPLY_UF,children2) );
        	                    }
        	                  }
        	                  //make constraints
        	                  std::vector< Expr > conj;
        	                  conj.push_back( EXPR_MANAGER->mkExpr(kind::IMPLIES, terms[1],
        	                                                       terms[0] ) );
        	                  const Expr term0_and_2 = EXPR_MANAGER->mkExpr(kind::AND, terms[0],
        	                                                                terms[2] );
        	                  conj.push_back( EXPR_MANAGER->mkExpr(kind::IMPLIES, term0_and_2,
        	                                                       terms[4] ) );
        	                  conj.push_back( EXPR_MANAGER->mkExpr(kind::IMPLIES, terms[0], terms[3]) );
        	                  Expr ic = EXPR_MANAGER->mkExpr( kind::AND, conj );
        	                  Debug("parser-sygus") << "...read invariant constraint " << ic
        	                                        << std::endl;
        	                  PARSER_STATE->addSygusConstraint(ic);
        	                  cmd->reset(new EmptyCommand());
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:864:5: CHECK_SYNTH_TOK
        	    {
        	         MATCHT(CHECK_SYNTH_TOK, &FOLLOW_CHECK_SYNTH_TOK_in_sygusCommand1393);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             Expr sygusVar = EXPR_MANAGER->mkVar("sygus", EXPR_MANAGER->booleanType());
        	                  Expr inst_attr =EXPR_MANAGER->mkExpr(kind::INST_ATTRIBUTE, sygusVar);
        	                  Expr sygusAttr = EXPR_MANAGER->mkExpr(kind::INST_PATTERN_LIST, inst_attr);
        	                  std::vector<Expr> bodyv;
        	                  Debug("parser-sygus") << "Sygus : Constructing sygus constraint..."
        	                                        << std::endl;
        	                  Expr body = EXPR_MANAGER->mkExpr(kind::NOT,
        	                                                   PARSER_STATE->getSygusConstraints());
        	                  Debug("parser-sygus") << "...constructed sygus constraint " << body
        	                                        << std::endl;      
        	                  if( !PARSER_STATE->getSygusVars().empty() ){
        	                    Expr boundVars = EXPR_MANAGER->mkExpr(kind::BOUND_VAR_LIST,
        	                                                          PARSER_STATE->getSygusVars());
        	                    body = EXPR_MANAGER->mkExpr(kind::EXISTS, boundVars, body);
        	                    Debug("parser-sygus") << "...constructed exists " << body << std::endl;
        	                  }
        	                  if( !PARSER_STATE->getSygusFunSymbols().empty() ){
        	                    Expr boundVars = EXPR_MANAGER->mkExpr(
        	                        kind::BOUND_VAR_LIST, PARSER_STATE->getSygusFunSymbols());
        	                    body = EXPR_MANAGER->mkExpr(kind::FORALL, boundVars, body, sygusAttr);
        	                  }
        	                  Debug("parser-sygus") << "...constructed forall " << body << std::endl;   
        	                  Command* c = new SetUserAttributeCommand("sygus", sygusVar);
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                  cmd->reset(new CheckSynthCommand(body));
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:893:5: command[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_command_in_sygusCommand1411);
        	        command(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusCommandEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesygusCommandEx; /* Prevent compiler warnings */
    rulesygusCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sygusCommand */

/**
 * $ANTLR start sygusGTerm
 * ../../../../src/parser/smt2/Smt2.g:910:1: sygusGTerm[CVC4::SygusGTerm& sgt, std::string& fun] : ( LPAREN_TOK ( builtinOp[k] | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK | SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK | INTEGER_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[name,CHECK_NONE,SYM_VARIABLE] ( SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] )? );
 */
static void
sygusGTerm(pSmt2Parser ctx, CVC4::SygusGTerm& sgt, std::string& fun)
{

      std::string name, name2;
      bool readEnum = false;
      Kind k;
      Type t;
      CVC4::DatatypeConstructor* ctor = NULL;
      std::string sname;
      std::vector< Expr > let_vars;
      bool readingLet = false;
      std::string s;

    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL4;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL5;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL6;

    /* Initialize rule variables
     */

    INTEGER_LITERAL4       = NULL;
    HEX_LITERAL5       = NULL;
    BINARY_LITERAL6       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:922:3: ( LPAREN_TOK ( builtinOp[k] | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK | SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK | INTEGER_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[name,CHECK_NONE,SYM_VARIABLE] ( SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] )? )

            ANTLR3_UINT32 alt21;

            alt21=6;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt21=1;
            	}
                break;
            case INTEGER_LITERAL:
            	{
            		alt21=2;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt21=3;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt21=4;
            	}
                break;
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            	{
            		alt21=5;
            	}
                break;
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case QUOTED_SYMBOL:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 162:
            	{
            		alt21=6;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 21;
                EXCEPTION->state        = 0;


                goto rulesygusGTermEx;

            }

            switch (alt21)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:922:5: LPAREN_TOK ( builtinOp[k] | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK | SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] ) ( sygusGTerm[sgt.d_children.back(), fun] )* RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGTerm1452);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:924:5: ( builtinOp[k] | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK | SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED] | symbol[name,CHECK_NONE,SYM_VARIABLE] )
        	        {
        	            int alt18=7;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            case BV2NAT_TOK:
        	            case DISTINCT_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case EQUAL_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case IMPLIES_TOK:
        	            case INST_CLOSURE_TOK:
        	            case ITE_TOK:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case STAR_TOK:
        	            case XOR_TOK:
        	            	{
        	            		alt18=1;
        	            	}
        	                break;
        	            case SYGUS_LET_TOK:
        	            	{
        	            		alt18=2;
        	            	}
        	                break;
        	            case SYGUS_CONSTANT_TOK:
        	            	{
        	            		alt18=3;
        	            	}
        	                break;
        	            case SYGUS_VARIABLE_TOK:
        	            	{
        	            		alt18=4;
        	            	}
        	                break;
        	            case SYGUS_LOCAL_VARIABLE_TOK:
        	            	{
        	            		alt18=5;
        	            	}
        	                break;
        	            case SYGUS_INPUT_VARIABLE_TOK:
        	            	{
        	            		alt18=6;
        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case INV_CONSTRAINT_TOK:
        	            case QUOTED_SYMBOL:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 162:
        	            	{
        	            		alt18=7;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 18;
        	                EXCEPTION->state        = 0;


        	                goto rulesygusGTermEx;

        	            }

        	            switch (alt18)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:924:7: builtinOp[k]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_builtinOp_in_sygusGTerm1465);
        	        	        builtinOp(ctx, k);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             
        	        	                    Debug("parser-sygus") << "Sygus grammar " << fun << " : builtin op : "
        	        	                                          << name << std::endl;
        	        	                    // Since we enforce satisfaction completeness, immediately convert to
        	        	                    // total version.
        	        	                    if( k==CVC4::kind::BITVECTOR_UDIV ){
        	        	                      k = CVC4::kind::BITVECTOR_UDIV_TOTAL;
        	        	                    }else if( k==CVC4::kind::BITVECTOR_UREM ){
        	        	                      k = CVC4::kind::BITVECTOR_UREM_TOTAL;
        	        	                    }else if( k==CVC4::kind::DIVISION ){
        	        	                      k = CVC4::kind::DIVISION_TOTAL;
        	        	                    }else if( k==CVC4::kind::INTS_DIVISION ){
        	        	                      k = CVC4::kind::INTS_DIVISION_TOTAL;
        	        	                    }else if( k==CVC4::kind::INTS_MODULUS ){
        	        	                      k = CVC4::kind::INTS_MODULUS_TOTAL;
        	        	                    }
        	        	                    sgt.d_name = kind::kindToString(k);
        	        	                    sgt.d_gterm_type = SygusGTerm::gterm_op;
        	        	                    sgt.d_expr = EXPR_MANAGER->operatorOf(k);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:944:8: SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+ RPAREN_TOK
        	        	    {
        	        	         MATCHT(SYGUS_LET_TOK, &FOLLOW_SYGUS_LET_TOK_in_sygusGTerm1476);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGTerm1478);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             
        	        	                     sgt.d_name = std::string("let");
        	        	                     sgt.d_gterm_type = SygusGTerm::gterm_let;
        	        	                     PARSER_STATE->pushScope(true);
        	        	                     readingLet = true;
        	        	                   
        	        	        }


        	        	        // ../../../../src/parser/smt2/Smt2.g:950:8: ( LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK )+
        	        	        {
        	        	            int cnt17=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt17=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case LPAREN_TOK:
        	        	        		{
        	        	        			alt17=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt17)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // ../../../../src/parser/smt2/Smt2.g:950:10: LPAREN_TOK symbol[sname,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] sygusGTerm[sgt.d_children.back(), fun] RPAREN_TOK
        	        	        	        {
        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sygusGTerm1491);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1502);
        	        	        	            symbol(ctx, sname, CHECK_NONE, SYM_VARIABLE);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1514);
        	        	        	            sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 
        	        	        	                          Expr v = PARSER_STATE->mkBoundVar(sname,t); 
        	        	        	                          sgt.d_let_vars.push_back( v ); 
        	        	        	                          sgt.addChild();
        	        	        	                        
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_sygusGTerm_in_sygusGTerm1528);
        	        	        	            sygusGTerm(ctx, sgt.d_children.back(), fun);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGTerm1539);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto rulesygusGTermEx;
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt17 >= 1 )
        	        	        		{
        	        	        		    goto loop17;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto rulesygusGTermEx;
        	        	        	}
        	        	        	cnt17++;
        	        	            }
        	        	            loop17: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGTerm1544);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/smt2/Smt2.g:959:7: SYGUS_CONSTANT_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_CONSTANT_TOK, &FOLLOW_SYGUS_CONSTANT_TOK_in_sygusGTerm1552);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1554);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_constant;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar constant." << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // ../../../../src/parser/smt2/Smt2.g:964:7: SYGUS_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_VARIABLE_TOK, &FOLLOW_SYGUS_VARIABLE_TOK_in_sygusGTerm1572);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1574);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar variable." << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 5:
        	        	    // ../../../../src/parser/smt2/Smt2.g:969:7: SYGUS_LOCAL_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_LOCAL_VARIABLE_TOK, &FOLLOW_SYGUS_LOCAL_VARIABLE_TOK_in_sygusGTerm1591);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1593);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_local_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar local variable...ignore."
        	        	                                          << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 6:
        	        	    // ../../../../src/parser/smt2/Smt2.g:975:7: SYGUS_INPUT_VARIABLE_TOK sortSymbol[t,CHECK_DECLARED]
        	        	    {
        	        	         MATCHT(SYGUS_INPUT_VARIABLE_TOK, &FOLLOW_SYGUS_INPUT_VARIABLE_TOK_in_sygusGTerm1610);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sygusGTerm1612);
        	        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             sgt.d_gterm_type = SygusGTerm::gterm_input_variable;
        	        	                    sgt.d_type = t;
        	        	                    Debug("parser-sygus") << "Sygus grammar (input) variable."
        	        	                                          << std::endl;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 7:
        	        	    // ../../../../src/parser/smt2/Smt2.g:981:7: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1629);
        	        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             
        	        	                    bool isBuiltinOperator = PARSER_STATE->isOperatorEnabled(name);
        	        	                    if(isBuiltinOperator) {
        	        	                      Debug("parser-sygus") << "Sygus grammar " << fun << " : builtin op : "
        	        	                                            << name << std::endl;
        	        	                      k = PARSER_STATE->getOperatorKind(name);
        	        	                      if( k==CVC4::kind::BITVECTOR_UDIV ){
        	        	                        k = CVC4::kind::BITVECTOR_UDIV_TOTAL;
        	        	                      }else if( k==CVC4::kind::BITVECTOR_UREM ){
        	        	                        k = CVC4::kind::BITVECTOR_UREM_TOTAL;
        	        	                      }else if( k==CVC4::kind::DIVISION ){
        	        	                        k = CVC4::kind::DIVISION_TOTAL;
        	        	                      }else if( k==CVC4::kind::INTS_DIVISION ){
        	        	                        k = CVC4::kind::INTS_DIVISION_TOTAL;
        	        	                      }else if( k==CVC4::kind::INTS_MODULUS ){
        	        	                        k = CVC4::kind::INTS_MODULUS_TOTAL;
        	        	                      }
        	        	                      sgt.d_name = kind::kindToString(k);
        	        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	        	                      sgt.d_expr = EXPR_MANAGER->operatorOf(k);
        	        	                    }else{
        	        	                      // what is this sygus term trying to accomplish here, if the
        	        	                      // symbol isn't yet declared?!  probably the following line will
        	        	                      // fail, but we need an operator to continue here..
        	        	                      Debug("parser-sygus")
        	        	                          << "Sygus grammar " << fun << " : op (declare="
        	        	                          << PARSER_STATE->isDeclared(name) << ", define="
        	        	                          << PARSER_STATE->isDefinedFunction(name) << ") : " << name
        	        	                          << std::endl;
        	        	                      if(!PARSER_STATE->isDeclared(name) &&
        	        	                         !PARSER_STATE->isDefinedFunction(name) ){
        	        	                        PARSER_STATE->parseError("Functions in sygus grammars must be "
        	        	                                                 "defined.");
        	        	                      }
        	        	                      sgt.d_name = name;
        	        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	        	                      sgt.d_expr = PARSER_STATE->getVariable(name) ;
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             Debug("parser-sygus") << "Read arguments under " << sgt.d_name
        	                                        << std::endl;
        	                  sgt.addChild();
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1026:5: ( sygusGTerm[sgt.d_children.back(), fun] )*

        	        for (;;)
        	        {
        	            int alt19=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 162:
        	            	{
        	            		alt19=1;
        	            	}
        	                break;

        	            }

        	            switch (alt19)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1026:7: sygusGTerm[sgt.d_children.back(), fun]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sygusGTerm_in_sygusGTerm1657);
        	        	        sygusGTerm(ctx, sgt.d_children.back(), fun);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             Debug("parser-sygus") << "Finished read argument #"
        	        	                                          << sgt.d_children.size() << "..." << std::endl;
        	        	                    sgt.addChild();
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop19;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop19: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sygusGTerm1680);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {

        	                  //pop last child index 
        	                  sgt.d_children.pop_back();   
        	                  if( readingLet ){
        	                    PARSER_STATE->popScope();
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1039:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL4 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_sygusGTerm1688);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "Sygus grammar " << fun << " : integer literal "
        	                                        << AntlrInput::tokenText(INTEGER_LITERAL4)
        	                                        << std::endl;
        	                  sgt.d_expr = MK_CONST(Rational(AntlrInput::tokenText(INTEGER_LITERAL4)));
        	                  sgt.d_name = AntlrInput::tokenText(INTEGER_LITERAL4);
        	                  sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1047:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL5 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_sygusGTerm1700);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "Sygus grammar " << fun << " : hex literal "
        	                                        << AntlrInput::tokenText(HEX_LITERAL5) << std::endl;
        	                  assert( AntlrInput::tokenText(HEX_LITERAL5).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL5, 2);
        	                  sgt.d_expr = MK_CONST( BitVector(hexString, 16) );
        	                  sgt.d_name = AntlrInput::tokenText(HEX_LITERAL5);
        	                  sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1056:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL6 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_sygusGTerm1712);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "Sygus grammar " << fun << " : binary literal "
        	                                        << AntlrInput::tokenText(BINARY_LITERAL6)
        	                                        << std::endl;
        	                  assert( AntlrInput::tokenText(BINARY_LITERAL6).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL6, 2);
        	                  sgt.d_expr = MK_CONST( BitVector(binString, 2) );
        	                  sgt.d_name = AntlrInput::tokenText(BINARY_LITERAL6);
        	                  sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1066:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_sygusGTerm1724);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        {
        	             Debug("parser-sygus") << "Sygus grammar " << fun << " : string literal \""
        	                                        << s << "\"" << std::endl;
        	                  sgt.d_expr = MK_CONST( ::CVC4::String(s, true) );
        	                  sgt.d_name = s;
        	                  sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:1073:5: symbol[name,CHECK_NONE,SYM_VARIABLE] ( SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1737);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesygusGTermEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1074:5: ( SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] )?
        	        {
        	            int alt20=2;
        	            switch ( LA(1) )
        	            {
        	                case SYGUS_ENUM_CONS_TOK:
        	                	{
        	                		alt20=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt20)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1074:7: SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE]
        	        	    {
        	        	         MATCHT(SYGUS_ENUM_CONS_TOK, &FOLLOW_SYGUS_ENUM_CONS_TOK_in_sygusGTerm1746);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_symbol_in_sygusGTerm1748);
        	        	        symbol(ctx, name2, CHECK_NONE, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesygusGTermEx;
        	        	        }


        	        	        {
        	        	             readEnum = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             if( readEnum ){
        	                    name = name + "__Enum__" + name2;
        	                    Debug("parser-sygus") << "Sygus grammar " << fun << " : Enum constant "
        	                                          << name << std::endl;
        	                    Expr c = PARSER_STATE->getVariable(name);
        	                    sgt.d_expr = MK_EXPR(kind::APPLY_CONSTRUCTOR,c);
        	                    sgt.d_name = name;
        	                    sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                  }else{
        	                    if( name[0] == '-' ){  //hack for unary minus
        	                      Debug("parser-sygus") << "Sygus grammar " << fun
        	                                            << " : unary minus integer literal " << name
        	                                            << std::endl;
        	                      sgt.d_expr = MK_CONST(Rational(name));
        	                      sgt.d_name = name;
        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                    }else if( PARSER_STATE->isDeclared(name,SYM_VARIABLE) ){
        	                      Debug("parser-sygus") << "Sygus grammar " << fun << " : symbol "
        	                                            << name << std::endl;
        	                      sgt.d_expr = PARSER_STATE->getVariable(name);
        	                      sgt.d_name = name;
        	                      sgt.d_gterm_type = SygusGTerm::gterm_op;
        	                    }else{
        	                      //prepend function name to base sorts when reading an operator
        	                      std::stringstream ss;
        	                      ss << fun << "_" << name;
        	                      name = ss.str();
        	                      if( PARSER_STATE->isDeclared(name, SYM_SORT) ){
        	                        Debug("parser-sygus") << "Sygus grammar " << fun
        	                                              << " : nested sort " << name << std::endl;
        	                        sgt.d_type = PARSER_STATE->getSort(name);
        	                        sgt.d_gterm_type = SygusGTerm::gterm_nested_sort;
        	                      }else{
        	                        Debug("parser-sygus") << "Sygus grammar " << fun
        	                                              << " : unresolved symbol " << name
        	                                              << std::endl;
        	                        sgt.d_gterm_type = SygusGTerm::gterm_unresolved;
        	                        sgt.d_name = name;
        	                      }
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesygusGTermEx; /* Prevent compiler warnings */
    rulesygusGTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sygusGTerm */

/**
 * $ANTLR start metaInfoInternal
 * ../../../../src/parser/smt2/Smt2.g:1122:1: metaInfoInternal[std::unique_ptr<CVC4::Command>* cmd] : KEYWORD symbolicExpr[sexpr] ;
 */
static void
metaInfoInternal(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::string name;
      SExpr sexpr;

    pANTLR3_COMMON_TOKEN    KEYWORD7;

    /* Initialize rule variables
     */

    KEYWORD7       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:1127:3: ( KEYWORD symbolicExpr[sexpr] )
        // ../../../../src/parser/smt2/Smt2.g:1127:5: KEYWORD symbolicExpr[sexpr]
        {
            KEYWORD7 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_metaInfoInternal1790);
            if  (HASEXCEPTION())
            {
                goto rulemetaInfoInternalEx;
            }


            FOLLOWPUSH(FOLLOW_symbolicExpr_in_metaInfoInternal1792);
            symbolicExpr(ctx, sexpr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemetaInfoInternalEx;
            }


            {
                 name = AntlrInput::tokenText(KEYWORD7);
                      if(name == ":cvc4-logic" || name == ":cvc4_logic") {
                        PARSER_STATE->setLogic(sexpr.getValue());
                      }
                      PARSER_STATE->setInfo(name.c_str() + 1, sexpr);
                      cmd->reset(new SetInfoCommand(name.c_str() + 1, sexpr));
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulemetaInfoInternalEx; /* Prevent compiler warnings */
    rulemetaInfoInternalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end metaInfoInternal */

/**
 * $ANTLR start setOptionInternal
 * ../../../../src/parser/smt2/Smt2.g:1137:1: setOptionInternal[std::unique_ptr<CVC4::Command>* cmd] : keyword[name] symbolicExpr[sexpr] ;
 */
static void
setOptionInternal(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{
    /* Initialize rule variables
     */


      std::string name;
      SExpr sexpr;

    {
        // ../../../../src/parser/smt2/Smt2.g:1142:3: ( keyword[name] symbolicExpr[sexpr] )
        // ../../../../src/parser/smt2/Smt2.g:1142:5: keyword[name] symbolicExpr[sexpr]
        {
            FOLLOWPUSH(FOLLOW_keyword_in_setOptionInternal1818);
            keyword(ctx, name);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesetOptionInternalEx;
            }


            FOLLOWPUSH(FOLLOW_symbolicExpr_in_setOptionInternal1821);
            symbolicExpr(ctx, sexpr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesetOptionInternalEx;
            }


            {
                 PARSER_STATE->setOption(name.c_str() + 1, sexpr);
                      cmd->reset(new SetOptionCommand(name.c_str() + 1, sexpr));
                      // Ugly that this changes the state of the parser; but
                      // global-declarations affects parsing, so we can't hold off
                      // on this until some SmtEngine eventually (if ever) executes it.
                      if(name == ":global-declarations") {
                        PARSER_STATE->setGlobalDeclarations(sexpr.getValue() == "true");
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesetOptionInternalEx; /* Prevent compiler warnings */
    rulesetOptionInternalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end setOptionInternal */

/**
 * $ANTLR start smt25Command
 * ../../../../src/parser/smt2/Smt2.g:1154:1: smt25Command[std::unique_ptr<CVC4::Command>* cmd] : ( META_INFO_TOK metaInfoInternal[cmd] | DECLARE_CONST_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | GET_MODEL_TOK | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | RESET_TOK | RESET_ASSERTIONS_TOK | DEFINE_FUN_REC_TOK symbol[fname,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK );
 */
static void
smt25Command(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::string name;
      std::string fname;
      Expr expr, expr2;
      std::vector<std::pair<std::string, Type> > sortedVarNames;
      SExpr sexpr;
      Type t;
      Expr func;
      std::vector<Expr> bvs;
      std::vector< std::vector<std::pair<std::string, Type> > > sortedVarNamesList;
      std::vector<std::vector<Expr>> flattenVarsList;
      std::vector<std::vector<Expr>> formals;
      std::vector<Expr> funcs;
      std::vector<Expr> func_defs;
      Expr aexpr;
      std::unique_ptr<CVC4::CommandSequence> seq;
      std::vector<Type> sorts;
      std::vector<Expr> flattenVars;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1175:3: ( META_INFO_TOK metaInfoInternal[cmd] | DECLARE_CONST_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | GET_MODEL_TOK | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | RESET_TOK | RESET_ASSERTIONS_TOK | DEFINE_FUN_REC_TOK symbol[fname,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK )

            ANTLR3_UINT32 alt25;

            alt25=8;

            switch ( LA(1) )
            {
            case META_INFO_TOK:
            	{
            		alt25=1;
            	}
                break;
            case DECLARE_CONST_TOK:
            	{
            		alt25=2;
            	}
                break;
            case GET_MODEL_TOK:
            	{
            		alt25=3;
            	}
                break;
            case ECHO_TOK:
            	{
            		alt25=4;
            	}
                break;
            case RESET_TOK:
            	{
            		alt25=5;
            	}
                break;
            case RESET_ASSERTIONS_TOK:
            	{
            		alt25=6;
            	}
                break;
            case DEFINE_FUN_REC_TOK:
            	{
            		alt25=7;
            	}
                break;
            case DEFINE_FUNS_REC_TOK:
            	{
            		alt25=8;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 25;
                EXCEPTION->state        = 0;


                goto rulesmt25CommandEx;

            }

            switch (alt25)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1175:5: META_INFO_TOK metaInfoInternal[cmd]
        	    {
        	         MATCHT(META_INFO_TOK, &FOLLOW_META_INFO_TOK_in_smt25Command1853);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_metaInfoInternal_in_smt25Command1855);
        	        metaInfoInternal(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1178:5: DECLARE_CONST_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_CONST_TOK, &FOLLOW_DECLARE_CONST_TOK_in_smt25Command1869);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_smt25Command1877);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command1890);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             // allow overloading here
        	                  Expr c = PARSER_STATE->mkVar(name, t, ExprManager::VAR_FLAG_NONE, true);
        	                  cmd->reset(new DeclareFunctionCommand(name, c, t)); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1187:5: GET_MODEL_TOK
        	    {
        	         MATCHT(GET_MODEL_TOK, &FOLLOW_GET_MODEL_TOK_in_smt25Command1910);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             cmd->reset(new GetModelCommand()); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1191:5: ECHO_TOK ( simpleSymbolicExpr[sexpr] |)
        	    {
        	         MATCHT(ECHO_TOK, &FOLLOW_ECHO_TOK_in_smt25Command1931);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1192:5: ( simpleSymbolicExpr[sexpr] |)
        	        {
        	            int alt22=2;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DISTINCT_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case ECHO_TOK:
        	            case EQUAL_TOK:
        	            case EXIT_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_LITERAL:
        	            case IMPLIES_TOK:
        	            case INST_CLOSURE_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case REDUCTION_RULE_TOK:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case REWRITE_RULE_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case XOR_TOK:
        	            case 162:
        	            	{
        	            		alt22=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt22=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 22;
        	                EXCEPTION->state        = 0;


        	                goto rulesmt25CommandEx;

        	            }

        	            switch (alt22)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1192:7: simpleSymbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_smt25Command1939);
        	        	        simpleSymbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesmt25CommandEx;
        	        	        }


        	        	        {
        	        	             cmd->reset(new EchoCommand(sexpr.toString())); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1194:7: 
        	        	    {
        	        	        {
        	        	             cmd->reset(new EchoCommand()); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1199:5: RESET_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_smt25Command1975);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             cmd->reset(new ResetCommand());
        	                  PARSER_STATE->reset();
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:1205:5: RESET_ASSERTIONS_TOK
        	    {
        	         MATCHT(RESET_ASSERTIONS_TOK, &FOLLOW_RESET_ASSERTIONS_TOK_in_smt25Command1993);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             cmd->reset(new ResetAssertionsCommand());
        	                  PARSER_STATE->resetAssertions();
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:1209:5: DEFINE_FUN_REC_TOK symbol[fname,CHECK_NONE,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2]
        	    {
        	         MATCHT(DEFINE_FUN_REC_TOK, &FOLLOW_DEFINE_FUN_REC_TOK_in_smt25Command2005);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_smt25Command2017);
        	        symbol(ctx, fname, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(fname); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2030);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_smt25Command2032);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2035);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command2041);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {

        	                  func = PARSER_STATE->mkDefineFunRec(fname, sortedVarNames, t, flattenVars);
        	                  PARSER_STATE->pushDefineFunRecScope(sortedVarNames, func, flattenVars, bvs, true );
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_smt25Command2054);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope(); 
        	                  if( !flattenVars.empty() ){
        	                    expr = PARSER_STATE->mkHoApply( expr, flattenVars );
        	                  }
        	                  cmd->reset(new DefineFunctionRecCommand(func,bvs,expr));
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:1226:5: DEFINE_FUNS_REC_TOK LPAREN_TOK ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+ RPAREN_TOK LPAREN_TOK ( term[expr,expr2] )+ RPAREN_TOK
        	    {
        	         MATCHT(DEFINE_FUNS_REC_TOK, &FOLLOW_DEFINE_FUNS_REC_TOK_in_smt25Command2067);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet();
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2079);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1229:5: ( LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )+
        	        {
        	            int cnt23=0;

        	            for (;;)
        	            {
        	                int alt23=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt23=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt23)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1229:7: LPAREN_TOK symbol[fname,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2087);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_smt25Command2095);
        	        	            symbol(ctx, fname, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(fname); 
        	        	            }


        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2112);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortedVarList_in_smt25Command2114);
        	        	            sortedVarList(ctx, sortedVarNames);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2117);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_smt25Command2125);
        	        	            sortSymbol(ctx, t, CHECK_DECLARED);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {

        	        	                        flattenVars.clear();
        	        	                        func = PARSER_STATE->mkDefineFunRec( fname, sortedVarNames, t, flattenVars );
        	        	                        funcs.push_back( func );

        	        	                        // add to lists (need to remember for when parsing the bodies)
        	        	                        sortedVarNamesList.push_back( sortedVarNames );
        	        	                        flattenVarsList.push_back( flattenVars );

        	        	                        // set up parsing the next variable list block
        	        	                        sortedVarNames.clear();
        	        	                        flattenVars.clear();
        	        	                      
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2142);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt23 >= 1 )
        	        		{
        	        		    goto loop23;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesmt25CommandEx;
        	        	}
        	        	cnt23++;
        	            }
        	            loop23: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2155);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_smt25Command2161);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             
        	                  //set up the first scope 
        	                  if( sortedVarNamesList.empty() ){
        	                    PARSER_STATE->parseError("Must define at least one function in "
        	                                             "define-funs-rec");
        	                  }
        	                  bvs.clear();
        	                  PARSER_STATE->pushDefineFunRecScope( sortedVarNamesList[0], funcs[0],
        	                                                       flattenVarsList[0], bvs, true);
        	                
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1261:5: ( term[expr,expr2] )+
        	        {
        	            int cnt24=0;

        	            for (;;)
        	            {
        	                int alt24=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case BINARY_LITERAL:
        	        	case CHECK_SYNTH_TOK:
        	        	case CONSTRAINT_TOK:
        	        	case DECIMAL_LITERAL:
        	        	case DECLARE_PRIMED_VAR_TOK:
        	        	case DECLARE_VAR_TOK:
        	        	case EMPTYSET_TOK:
        	        	case FP_RNA_FULL_TOK:
        	        	case FP_RNA_TOK:
        	        	case FP_RNE_FULL_TOK:
        	        	case FP_RNE_TOK:
        	        	case FP_RTN_FULL_TOK:
        	        	case FP_RTN_TOK:
        	        	case FP_RTP_FULL_TOK:
        	        	case FP_RTP_TOK:
        	        	case FP_RTZ_FULL_TOK:
        	        	case FP_RTZ_TOK:
        	        	case HEX_LITERAL:
        	        	case INTEGER_LITERAL:
        	        	case INV_CONSTRAINT_TOK:
        	        	case LPAREN_TOK:
        	        	case NILREF_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case REALLCHAR_TOK:
        	        	case REAL_PI_TOK:
        	        	case RENOSTR_TOK:
        	        	case SET_OPTIONS_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case STRING_LITERAL_2_0:
        	        	case STRING_LITERAL_2_5:
        	        	case SYNTH_FUN_TOK:
        	        	case SYNTH_INV_TOK:
        	        	case TUPLE_CONST_TOK:
        	        	case UNIVSET_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 162:
        	        		{
        	        			alt24=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt24)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1262:5: term[expr,expr2]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_term_in_smt25Command2179);
        	        	            term(ctx, expr, expr2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulesmt25CommandEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                      unsigned j = func_defs.size();
        	        	                      if( !flattenVarsList[j].empty() ){
        	        	                        expr = PARSER_STATE->mkHoApply( expr, flattenVarsList[j] );
        	        	                      }
        	        	                      func_defs.push_back( expr );
        	        	                      formals.push_back(bvs);
        	        	                      j++;
        	        	                      //set up the next scope 
        	        	                      PARSER_STATE->popScope();
        	        	                      if( func_defs.size()<funcs.size() ){
        	        	                        bvs.clear();
        	        	                        PARSER_STATE->pushDefineFunRecScope( sortedVarNamesList[j], funcs[j], 
        	        	                                                             flattenVarsList[j], bvs, true);
        	        	                      }
        	        	                    
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt24 >= 1 )
        	        		{
        	        		    goto loop24;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulesmt25CommandEx;
        	        	}
        	        	cnt24++;
        	            }
        	            loop24: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_smt25Command2199);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesmt25CommandEx;
        	        }


        	        {
        	             if( funcs.size()!=func_defs.size() ){
        	                    PARSER_STATE->parseError(std::string(
        	                        "Number of functions defined does not match number listed in "
        	                        "define-funs-rec"));
        	                  }
        	                  cmd->reset( new DefineFunctionRecCommand(funcs,formals,func_defs));
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesmt25CommandEx; /* Prevent compiler warnings */
    rulesmt25CommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end smt25Command */

/**
 * $ANTLR start extendedCommand
 * ../../../../src/parser/smt2/Smt2.g:1290:1: extendedCommand[std::unique_ptr<CVC4::Command>* cmd] : ( DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd] | DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd] | DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd] | DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd] | DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd] | DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd] | rewriterulesCommand[cmd] | DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK | DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] ) | DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2] | SIMPLIFY_TOK term[e,e2] | GET_QE_TOK term[e,e2] | GET_QE_DISJUNCT_TOK term[e,e2] );
 */
static void
extendedCommand(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      Expr e, e2;
      Type t;
      std::string name;
      std::vector<std::string> names;
      std::vector<Expr> terms;
      std::vector<Type> sorts;
      std::vector<std::pair<std::string, Type> > sortedVarNames;
      std::unique_ptr<CVC4::CommandSequence> seq;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1304:3: ( DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd] | DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd] | DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd] | DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd] | DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd] | DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd] | rewriterulesCommand[cmd] | DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK | DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] ) | DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2] | SIMPLIFY_TOK term[e,e2] | GET_QE_TOK term[e,e2] | GET_QE_DISJUNCT_TOK term[e,e2] )

            ANTLR3_UINT32 alt30;

            alt30=15;

            switch ( LA(1) )
            {
            case DECLARE_DATATYPES_2_5_TOK:
            	{
            		alt30=1;
            	}
                break;
            case DECLARE_CODATATYPES_2_5_TOK:
            	{
            		alt30=2;
            	}
                break;
            case DECLARE_DATATYPE_TOK:
            	{
            		alt30=3;
            	}
                break;
            case DECLARE_CODATATYPE_TOK:
            	{
            		alt30=4;
            	}
                break;
            case DECLARE_DATATYPES_TOK:
            	{
            		alt30=5;
            	}
                break;
            case DECLARE_CODATATYPES_TOK:
            	{
            		alt30=6;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            case REWRITE_RULE_TOK:
            	{
            		alt30=7;
            	}
                break;
            case DECLARE_SORTS_TOK:
            	{
            		alt30=8;
            	}
                break;
            case DECLARE_FUNS_TOK:
            	{
            		alt30=9;
            	}
                break;
            case DECLARE_PREDS_TOK:
            	{
            		alt30=10;
            	}
                break;
            case DEFINE_TOK:
            	{
            		alt30=11;
            	}
                break;
            case DEFINE_CONST_TOK:
            	{
            		alt30=12;
            	}
                break;
            case SIMPLIFY_TOK:
            	{
            		alt30=13;
            	}
                break;
            case GET_QE_TOK:
            	{
            		alt30=14;
            	}
                break;
            case GET_QE_DISJUNCT_TOK:
            	{
            		alt30=15;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 30;
                EXCEPTION->state        = 0;


                goto ruleextendedCommandEx;

            }

            switch (alt30)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1304:5: DECLARE_DATATYPES_2_5_TOK datatypes_2_5_DefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPES_2_5_TOK, &FOLLOW_DECLARE_DATATYPES_2_5_TOK_in_extendedCommand2230);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2232);
        	        datatypes_2_5_DefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1305:5: DECLARE_CODATATYPES_2_5_TOK datatypes_2_5_DefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPES_2_5_TOK, &FOLLOW_DECLARE_CODATATYPES_2_5_TOK_in_extendedCommand2239);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypes_2_5_DefCommand_in_extendedCommand2241);
        	        datatypes_2_5_DefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1306:5: DECLARE_DATATYPE_TOK datatypeDefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPE_TOK, &FOLLOW_DECLARE_DATATYPE_TOK_in_extendedCommand2248);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDefCommand_in_extendedCommand2250);
        	        datatypeDefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1307:5: DECLARE_CODATATYPE_TOK datatypeDefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPE_TOK, &FOLLOW_DECLARE_CODATATYPE_TOK_in_extendedCommand2257);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDefCommand_in_extendedCommand2259);
        	        datatypeDefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1308:5: DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPES_TOK, &FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand2266);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypesDefCommand_in_extendedCommand2268);
        	        datatypesDefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:1309:5: DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPES_TOK, &FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand2275);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypesDefCommand_in_extendedCommand2277);
        	        datatypesDefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:1310:5: rewriterulesCommand[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_rewriterulesCommand_in_extendedCommand2284);
        	        rewriterulesCommand(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:1314:5: DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_SORTS_TOK, &FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand2299);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_DATATYPES) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS)) {
        	                    PARSER_STATE->parseErrorLogic("Free sort symbols not allowed in ");
        	                  }
        	                
        	        }


        	        {
        	             seq.reset(new CVC4::CommandSequence()); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2319);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1324:5: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+
        	        {
        	            int cnt26=0;

        	            for (;;)
        	            {
        	                int alt26=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case CHECK_SYNTH_TOK:
        	        	case CONSTRAINT_TOK:
        	        	case DECLARE_PRIMED_VAR_TOK:
        	        	case DECLARE_VAR_TOK:
        	        	case INV_CONSTRAINT_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case SET_OPTIONS_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case SYNTH_FUN_TOK:
        	        	case SYNTH_INV_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 162:
        	        		{
        	        			alt26=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt26)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1324:7: symbol[name,CHECK_UNDECLARED,SYM_SORT]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2327);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name);
        	        	                        Type type = PARSER_STATE->mkSort(name);
        	        	                        seq->addCommand(new DeclareTypeCommand(name, 0, type));
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt26 >= 1 )
        	        		{
        	        		    goto loop26;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt26++;
        	            }
        	            loop26: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2349);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/smt2/Smt2.g:1333:5: DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_FUNS_TOK, &FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand2362);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             seq.reset(new CVC4::CommandSequence()); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2376);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1336:5: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+
        	        {
        	            int cnt27=0;

        	            for (;;)
        	            {
        	                int alt27=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt27=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt27)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1336:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2384);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2386);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name); 
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_nonemptySortList_in_extendedCommand2403);
        	        	            nonemptySortList(ctx, sorts);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2406);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 Type t;
        	        	                        if(sorts.size() > 1) {
        	        	                          if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	        	                            PARSER_STATE->parseErrorLogic("Functions (of non-zero arity) "
        	        	                                                          "cannot be declared in logic ");
        	        	                          }
        	        	                          // must flatten
        	        	                          Type range = sorts.back();
        	        	                          sorts.pop_back();
        	        	                          t = PARSER_STATE->mkFlatFunctionType(sorts, range);
        	        	                        } else {
        	        	                          t = sorts[0];
        	        	                        }
        	        	                        // allow overloading
        	        	                        Expr func = PARSER_STATE->mkVar(name, t, ExprManager::VAR_FLAG_NONE, true);
        	        	                        seq->addCommand(new DeclareFunctionCommand(name, func, t));
        	        	                        sorts.clear();
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt27 >= 1 )
        	        		{
        	        		    goto loop27;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt27++;
        	            }
        	            loop27: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2427);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/smt2/Smt2.g:1360:5: DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_PREDS_TOK, &FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand2440);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        {
        	             seq.reset(new CVC4::CommandSequence()); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2454);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1363:5: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+
        	        {
        	            int cnt28=0;

        	            for (;;)
        	            {
        	                int alt28=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt28=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt28)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:1363:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2462);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2464);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name); 
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortList_in_extendedCommand2481);
        	        	            sortList(ctx, sorts);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2484);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }


        	        	            {
        	        	                 Type t = EXPR_MANAGER->booleanType();
        	        	                        if(sorts.size() > 0) {
        	        	                          if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	        	                            PARSER_STATE->parseErrorLogic("Predicates (of non-zero arity) "
        	        	                                                          "cannot be declared in logic ");
        	        	                          }
        	        	                          t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	        	                        }
        	        	                        // allow overloading
        	        	                        Expr func = PARSER_STATE->mkVar(name, t, ExprManager::VAR_FLAG_NONE, true);
        	        	                        seq->addCommand(new DeclareFunctionCommand(name, func, t));
        	        	                        sorts.clear();
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt28 >= 1 )
        	        		{
        	        		    goto loop28;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt28++;
        	            }
        	            loop28: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2505);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(seq.release()); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/smt2/Smt2.g:1383:5: DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] )
        	    {
        	         MATCHT(DEFINE_TOK, &FOLLOW_DEFINE_TOK_in_extendedCommand2518);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1384:5: ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] )
        	        {
        	            int alt29=2;
        	            switch ( LA(1) )
        	            {
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case INV_CONSTRAINT_TOK:
        	            case QUOTED_SYMBOL:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 162:
        	            	{
        	            		alt29=1;
        	            	}
        	                break;
        	            case LPAREN_TOK:
        	            	{
        	            		alt29=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 29;
        	                EXCEPTION->state        = 0;


        	                goto ruleextendedCommandEx;

        	            }

        	            switch (alt29)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1384:7: symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2528);
        	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->checkUserSymbol(name); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2545);
        	        	        term(ctx, e, e2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             Expr func = PARSER_STATE->mkFunction(name, e.getType(),
        	        	                                                         ExprManager::VAR_FLAG_DEFINED);
        	        	                    cmd->reset(new DefineFunctionCommand(name, func, e));
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1391:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2]
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand2562);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2570);
        	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->checkUserSymbol(name); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_extendedCommand2587);
        	        	        sortedVarList(ctx, sortedVarNames);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand2590);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             /* add variables to parser state before parsing term */
        	        	                    Debug("parser") << "define fun: '" << name << "'" << std::endl;
        	        	                    PARSER_STATE->pushScope(true);
        	        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	        	                          sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	        	                        ++i) {
        	        	                      terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	        	                    }
        	        	                  
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2606);
        	        	        term(ctx, e, e2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->popScope();
        	        	                    // declare the name down here (while parsing term, signature
        	        	                    // must not be extended with the name itself; no recursion
        	        	                    // permitted)
        	        	                    Type t = e.getType();
        	        	                    if( sortedVarNames.size() > 0 ) {
        	        	                      std::vector<CVC4::Type> sorts;
        	        	                      sorts.reserve(sortedVarNames.size());
        	        	                      for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator
        	        	                            i = sortedVarNames.begin(), iend = sortedVarNames.end();
        	        	                          i != iend; ++i) {
        	        	                        sorts.push_back((*i).second);
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	        	                    }
        	        	                    Expr func = PARSER_STATE->mkFunction(name, t,
        	        	                                                         ExprManager::VAR_FLAG_DEFINED);
        	        	                    cmd->reset(new DefineFunctionCommand(name, func, terms, e));
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/smt2/Smt2.g:1425:5: DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[e, e2]
        	    {
        	         MATCHT(DEFINE_CONST_TOK, &FOLLOW_DEFINE_CONST_TOK_in_extendedCommand2627);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand2635);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_extendedCommand2648);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             /* add variables to parser state before parsing term */
        	                  Debug("parser") << "define const: '" << name << "'" << std::endl;
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end(); i != iend;
        	                      ++i) {
        	                    terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2661);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  // declare the name down here (while parsing term, signature
        	                  // must not be extended with the name itself; no recursion
        	                  // permitted)
        	                  Expr func = PARSER_STATE->mkFunction(name, t,
        	                                                       ExprManager::VAR_FLAG_DEFINED);
        	                  cmd->reset(new DefineFunctionCommand(name, func, terms, e));
        	                
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/smt2/Smt2.g:1448:5: SIMPLIFY_TOK term[e,e2]
        	    {
        	         MATCHT(SIMPLIFY_TOK, &FOLLOW_SIMPLIFY_TOK_in_extendedCommand2675);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2683);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new SimplifyCommand(e)); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/smt2/Smt2.g:1451:5: GET_QE_TOK term[e,e2]
        	    {
        	         MATCHT(GET_QE_TOK, &FOLLOW_GET_QE_TOK_in_extendedCommand2696);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2704);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new GetQuantifierEliminationCommand(e, true)); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/smt2/Smt2.g:1454:5: GET_QE_DISJUNCT_TOK term[e,e2]
        	    {
        	         MATCHT(GET_QE_DISJUNCT_TOK, &FOLLOW_GET_QE_DISJUNCT_TOK_in_extendedCommand2717);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand2725);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }


        	        {
        	             cmd->reset(new GetQuantifierEliminationCommand(e, false)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleextendedCommandEx; /* Prevent compiler warnings */
    ruleextendedCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end extendedCommand */

/**
 * $ANTLR start datatypes_2_5_DefCommand
 * ../../../../src/parser/smt2/Smt2.g:1460:1: datatypes_2_5_DefCommand[bool isCo, std::unique_ptr<CVC4::Command>* cmd] : LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK ;
 */
static void
datatypes_2_5_DefCommand(pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      std::string name;
      std::vector<Type> sorts;
      std::vector<std::string> dnames;
      std::vector<unsigned> arities;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:1468:3: ( LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:1468:5: LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK
        {
            {
                 PARSER_STATE->checkThatLogicIsSet();
                    /* open a scope to keep the UnresolvedTypes contained */
                    PARSER_STATE->pushScope(true); 
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2756);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:1472:3: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )*

            for (;;)
            {
                int alt31=2;
                switch ( LA(1) )
                {
                case CHECK_SYNTH_TOK:
                case CONSTRAINT_TOK:
                case DECLARE_PRIMED_VAR_TOK:
                case DECLARE_VAR_TOK:
                case INV_CONSTRAINT_TOK:
                case QUOTED_SYMBOL:
                case SET_OPTIONS_TOK:
                case SIMPLE_SYMBOL:
                case SYNTH_FUN_TOK:
                case SYNTH_INV_TOK:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 162:
                	{
                		alt31=1;
                	}
                    break;

                }

                switch (alt31)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:1472:5: symbol[name,CHECK_UNDECLARED,SYM_SORT]
            	    {
            	        FOLLOWPUSH(FOLLOW_symbol_in_datatypes_2_5_DefCommand2764);
            	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypes_2_5_DefCommandEx;
            	        }


            	        {
            	             sorts.push_back( PARSER_STATE->mkSort(name) ); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop31;	/* break out of the loop */
            	    break;
                }
            }
            loop31: ; /* Jump out to here if this rule does not match */


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2780);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2784);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:1476:14: ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+
            {
                int cnt32=0;

                for (;;)
                {
                    int alt32=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt32=1;
            		}
            	    break;

            	}

            	switch (alt32)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:1476:16: LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypes_2_5_DefCommand2788);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_datatypeDef_in_datatypes_2_5_DefCommand2790);
            	            datatypeDef(ctx, isCo, dts, sorts);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2793);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypes_2_5_DefCommandEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt32 >= 1 )
            		{
            		    goto loop32;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypes_2_5_DefCommandEx;
            	}
            	cnt32++;
                }
                loop32: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypes_2_5_DefCommand2798);
            if  (HASEXCEPTION())
            {
                goto ruledatatypes_2_5_DefCommandEx;
            }


            {
                 PARSER_STATE->popScope();
                    cmd->reset(new DatatypeDeclarationCommand(PARSER_STATE->mkMutualDatatypeTypes(dts, true)));
                  
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypes_2_5_DefCommandEx; /* Prevent compiler warnings */
    ruledatatypes_2_5_DefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypes_2_5_DefCommand */

/**
 * $ANTLR start datatypeDefCommand
 * ../../../../src/parser/smt2/Smt2.g:1482:1: datatypeDefCommand[bool isCo, std::unique_ptr<CVC4::Command>* cmd] : symbol[name,CHECK_UNDECLARED,SYM_SORT] datatypesDef[isCo, dnames, arities, cmd] ;
 */
static void
datatypeDefCommand(pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      std::string name;
      std::vector<std::string> dnames;
      std::vector<int> arities;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:1489:2: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] datatypesDef[isCo, dnames, arities, cmd] )
        // ../../../../src/parser/smt2/Smt2.g:1489:4: symbol[name,CHECK_UNDECLARED,SYM_SORT] datatypesDef[isCo, dnames, arities, cmd]
        {
            {
                 PARSER_STATE->checkThatLogicIsSet(); 
            }


            FOLLOWPUSH(FOLLOW_symbol_in_datatypeDefCommand2827);
            symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefCommandEx;
            }


            {

                   dnames.push_back(name);
                   arities.push_back(-1);
                 
            }


            FOLLOWPUSH(FOLLOW_datatypesDef_in_datatypeDefCommand2834);
            datatypesDef(ctx, isCo, dnames, arities, cmd);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefCommandEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefCommandEx; /* Prevent compiler warnings */
    ruledatatypeDefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDefCommand */

/**
 * $ANTLR start datatypesDefCommand
 * ../../../../src/parser/smt2/Smt2.g:1498:1: datatypesDefCommand[bool isCo, std::unique_ptr<CVC4::Command>* cmd] : LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK datatypesDef[isCo, dnames, arities, cmd] RPAREN_TOK ;
 */
static void
datatypesDefCommand(pSmt2Parser ctx, bool isCo, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      std::string name;
      std::vector<std::string> dnames;
      std::vector<int> arities;

    pANTLR3_COMMON_TOKEN    n;

    /* Initialize rule variables
     */

    n       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:1505:3: ( LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK datatypesDef[isCo, dnames, arities, cmd] RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:1505:5: LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )* RPAREN_TOK LPAREN_TOK datatypesDef[isCo, dnames, arities, cmd] RPAREN_TOK
        {
            {
                 PARSER_STATE->checkThatLogicIsSet(); 
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2859);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:1507:3: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK )*

            for (;;)
            {
                int alt33=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt33=1;
                	}
                    break;

                }

                switch (alt33)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:1507:5: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2867);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_symbol_in_datatypesDefCommand2869);
            	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_datatypesDefCommand2874);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2876);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }


            	        {
            	             unsigned arity = AntlrInput::tokenToUnsigned(n);
            	                  Debug("parser-dt") << "Datatype : " << name << ", arity = " << arity << std::endl;
            	                  dnames.push_back(name);
            	                  arities.push_back( static_cast<int>(arity) );
            	                
            	        }


            	    }
            	    break;

            	default:
            	    goto loop33;	/* break out of the loop */
            	    break;
                }
            }
            loop33: ; /* Jump out to here if this rule does not match */


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2891);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand2896);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


            FOLLOWPUSH(FOLLOW_datatypesDef_in_datatypesDefCommand2901);
            datatypesDef(ctx, isCo, dnames, arities, cmd);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand2906);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypesDefCommandEx; /* Prevent compiler warnings */
    ruledatatypesDefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypesDefCommand */

/**
 * $ANTLR start datatypesDef
 * ../../../../src/parser/smt2/Smt2.g:1525:1: datatypesDef[bool isCo,\n const std::vector<std::string>& dnames,\n const std::vector<int>& arities,\n std::unique_ptr<CVC4::Command>* cmd] : ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+ ;
 */
static void
datatypesDef(pSmt2Parser ctx, bool isCo, const std::vector<std::string>& dnames, const std::vector<int>& arities, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<CVC4::Datatype> dts;
      std::string name;
      std::vector<Type> params;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:1534:3: ( ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+ )
        // ../../../../src/parser/smt2/Smt2.g:1534:5: ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+
        {
            {
                 PARSER_STATE->pushScope(true); 
            }


            // ../../../../src/parser/smt2/Smt2.g:1535:5: ( LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK )+
            {
                int cnt38=0;

                for (;;)
                {
                    int alt38=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt38=1;
            		}
            	    break;

            	}

            	switch (alt38)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:1535:7: LPAREN_TOK ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ ) RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef2935);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefEx;
            	            }


            	            {

            	                      params.clear(); 
            	                      Debug("parser-dt") << "Processing datatype #" << dts.size() << std::endl;
            	                      if( dts.size()>=dnames.size() ){
            	                        PARSER_STATE->parseError("Too many datatypes defined in this block.");
            	                      }
            	                    
            	            }


            	            // ../../../../src/parser/smt2/Smt2.g:1542:5: ( PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK | ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ )
            	            {
            	                int alt37=2;
            	                switch ( LA(1) )
            	                {
            	                case PAR_TOK:
            	                	{
            	                		alt37=1;
            	                	}
            	                    break;
            	                case LPAREN_TOK:
            	                	{
            	                		alt37=2;
            	                	}
            	                    break;

            	                default:
            	                    CONSTRUCTEX();
            	                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                    EXCEPTION->message      = (void *)"";
            	                    EXCEPTION->decisionNum  = 37;
            	                    EXCEPTION->state        = 0;


            	                    goto ruledatatypesDefEx;

            	                }

            	                switch (alt37)
            	                {
            	            	case 1:
            	            	    // ../../../../src/parser/smt2/Smt2.g:1542:7: PAR_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+ RPAREN_TOK
            	            	    {
            	            	         MATCHT(PAR_TOK, &FOLLOW_PAR_TOK_in_datatypesDef2945);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        {
            	            	             PARSER_STATE->pushScope(true); 
            	            	        }


            	            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef2949);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        // ../../../../src/parser/smt2/Smt2.g:1543:7: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )*

            	            	        for (;;)
            	            	        {
            	            	            int alt34=2;
            	            	            switch ( LA(1) )
            	            	            {
            	            	            case CHECK_SYNTH_TOK:
            	            	            case CONSTRAINT_TOK:
            	            	            case DECLARE_PRIMED_VAR_TOK:
            	            	            case DECLARE_VAR_TOK:
            	            	            case INV_CONSTRAINT_TOK:
            	            	            case QUOTED_SYMBOL:
            	            	            case SET_OPTIONS_TOK:
            	            	            case SIMPLE_SYMBOL:
            	            	            case SYNTH_FUN_TOK:
            	            	            case SYNTH_INV_TOK:
            	            	            case UNTERMINATED_QUOTED_SYMBOL:
            	            	            case 162:
            	            	            	{
            	            	            		alt34=1;
            	            	            	}
            	            	                break;

            	            	            }

            	            	            switch (alt34)
            	            	            {
            	            	        	case 1:
            	            	        	    // ../../../../src/parser/smt2/Smt2.g:1543:9: symbol[name,CHECK_UNDECLARED,SYM_SORT]
            	            	        	    {
            	            	        	        FOLLOWPUSH(FOLLOW_symbol_in_datatypesDef2959);
            	            	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	            	        	        FOLLOWPOP();
            	            	        	        if  (HASEXCEPTION())
            	            	        	        {
            	            	        	            goto ruledatatypesDefEx;
            	            	        	        }


            	            	        	        {
            	            	        	             params.push_back( PARSER_STATE->mkSort(name) ); 
            	            	        	        }


            	            	        	    }
            	            	        	    break;

            	            	        	default:
            	            	        	    goto loop34;	/* break out of the loop */
            	            	        	    break;
            	            	            }
            	            	        }
            	            	        loop34: ; /* Jump out to here if this rule does not match */


            	            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef2987);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        {

            	            	                    // if the arity was fixed by prelude and is not equal to the number of parameters
            	            	                    if( arities[dts.size()]>=0 && static_cast<int>(params.size())!=arities[dts.size()] ){
            	            	                      PARSER_STATE->parseError("Wrong number of parameters for datatype.");
            	            	                    }
            	            	                    Debug("parser-dt") << params.size() << " parameters for " << dnames[dts.size()] << std::endl;
            	            	                    dts.push_back(Datatype(dnames[dts.size()],params,isCo));
            	            	                  
            	            	        }


            	            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef2997);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        // ../../../../src/parser/smt2/Smt2.g:1555:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	        {
            	            	            int cnt35=0;

            	            	            for (;;)
            	            	            {
            	            	                int alt35=2;
            	            	        	switch ( LA(1) )
            	            	        	{
            	            	        	case LPAREN_TOK:
            	            	        		{
            	            	        			alt35=1;
            	            	        		}
            	            	        	    break;

            	            	        	}

            	            	        	switch (alt35)
            	            	        	{
            	            	        	    case 1:
            	            	        	        // ../../../../src/parser/smt2/Smt2.g:1555:9: LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK
            	            	        	        {
            	            	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef3007);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypesDef3009);
            	            	        	            constructorDef(ctx, dts.back());

            	            	        	            FOLLOWPOP();
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3012);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	        }
            	            	        	        break;

            	            	        	    default:

            	            	        		if ( cnt35 >= 1 )
            	            	        		{
            	            	        		    goto loop35;
            	            	        		}
            	            	        		/* mismatchedSetEx()
            	            	        		 */
            	            	        		CONSTRUCTEX();
            	            	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            	        		goto ruledatatypesDefEx;
            	            	        	}
            	            	        	cnt35++;
            	            	            }
            	            	            loop35: ;	/* Jump to here if this rule does not match */
            	            	        }

            	            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3023);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruledatatypesDefEx;
            	            	        }


            	            	        {
            	            	             PARSER_STATE->popScope(); 
            	            	        }


            	            	    }
            	            	    break;
            	            	case 2:
            	            	    // ../../../../src/parser/smt2/Smt2.g:1557:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	    {
            	            	        {
            	            	             // if the arity was fixed by prelude and is not equal to 0
            	            	                    if( arities[dts.size()]>0 ){
            	            	                      PARSER_STATE->parseError("No parameters given for datatype.");
            	            	                    }
            	            	                    Debug("parser-dt") << params.size() << " parameters for " << dnames[dts.size()] << std::endl;
            	            	                    dts.push_back(Datatype(dnames[dts.size()],params,isCo));
            	            	                  
            	            	        }


            	            	        // ../../../../src/parser/smt2/Smt2.g:1564:7: ( LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK )+
            	            	        {
            	            	            int cnt36=0;

            	            	            for (;;)
            	            	            {
            	            	                int alt36=2;
            	            	        	switch ( LA(1) )
            	            	        	{
            	            	        	case LPAREN_TOK:
            	            	        		{
            	            	        			alt36=1;
            	            	        		}
            	            	        	    break;

            	            	        	}

            	            	        	switch (alt36)
            	            	        	{
            	            	        	    case 1:
            	            	        	        // ../../../../src/parser/smt2/Smt2.g:1564:9: LPAREN_TOK constructorDef[dts.back()] RPAREN_TOK
            	            	        	        {
            	            	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDef3044);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypesDef3046);
            	            	        	            constructorDef(ctx, dts.back());

            	            	        	            FOLLOWPOP();
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3049);
            	            	        	            if  (HASEXCEPTION())
            	            	        	            {
            	            	        	                goto ruledatatypesDefEx;
            	            	        	            }


            	            	        	        }
            	            	        	        break;

            	            	        	    default:

            	            	        		if ( cnt36 >= 1 )
            	            	        		{
            	            	        		    goto loop36;
            	            	        		}
            	            	        		/* mismatchedSetEx()
            	            	        		 */
            	            	        		CONSTRUCTEX();
            	            	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            	        		goto ruledatatypesDefEx;
            	            	        	}
            	            	        	cnt36++;
            	            	            }
            	            	            loop36: ;	/* Jump to here if this rule does not match */
            	            	        }

            	            	    }
            	            	    break;

            	                }
            	            }

            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDef3064);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt38 >= 1 )
            		{
            		    goto loop38;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypesDefEx;
            	}
            	cnt38++;
                }
                loop38: ;	/* Jump to here if this rule does not match */
            }

            {

                    PARSER_STATE->popScope();
                    cmd->reset(new DatatypeDeclarationCommand(PARSER_STATE->mkMutualDatatypeTypes(dts, true))); 
                  
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypesDefEx; /* Prevent compiler warnings */
    ruledatatypesDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypesDef */

/**
 * $ANTLR start rewriterulesCommand
 * ../../../../src/parser/smt2/Smt2.g:1574:1: rewriterulesCommand[std::unique_ptr<CVC4::Command>* cmd] : ( REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2] | rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2] );
 */
static void
rewriterulesCommand(pSmt2Parser ctx, std::unique_ptr<CVC4::Command>* cmd)
{

      std::vector<std::pair<std::string, Type> > sortedVarNames;
      std::vector<Expr> args, guards, heads, triggers;
      Expr head, body, expr, expr2, bvl;
      Kind kind;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1581:3: ( REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2] | rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2] )

            ANTLR3_UINT32 alt44;

            alt44=2;

            switch ( LA(1) )
            {
            case REWRITE_RULE_TOK:
            	{
            		alt44=1;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            	{
            		alt44=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 44;
                EXCEPTION->state        = 0;


                goto rulerewriterulesCommandEx;

            }

            switch (alt44)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1582:5: REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2]
        	    {
        	         MATCHT(REWRITE_RULE_TOK, &FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand3100);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3106);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_rewriterulesCommand3108);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3111);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        {

        	                  kind = CVC4::kind::RR_REWRITE;
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3123);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1595:16: ( pattern[expr] )*

        	        for (;;)
        	        {
        	            int alt39=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt39=1;
        	            	}
        	                break;

        	            }

        	            switch (alt39)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1595:18: pattern[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_pattern_in_rewriterulesCommand3127);
        	        	        pattern(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	        {
        	        	             triggers.push_back( expr ); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop39;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop39: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3135);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3141);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1596:16: ( termList[guards,expr] )?
        	        {
        	            int alt40=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_VAR_TOK:
        	                case EMPTYSET_TOK:
        	                case FP_RNA_FULL_TOK:
        	                case FP_RNA_TOK:
        	                case FP_RNE_FULL_TOK:
        	                case FP_RNE_TOK:
        	                case FP_RTN_FULL_TOK:
        	                case FP_RTN_TOK:
        	                case FP_RTP_FULL_TOK:
        	                case FP_RTP_TOK:
        	                case FP_RTZ_FULL_TOK:
        	                case FP_RTZ_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case INV_CONSTRAINT_TOK:
        	                case LPAREN_TOK:
        	                case NILREF_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case REAL_PI_TOK:
        	                case RENOSTR_TOK:
        	                case SET_OPTIONS_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL_2_0:
        	                case STRING_LITERAL_2_5:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case TUPLE_CONST_TOK:
        	                case UNIVSET_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 162:
        	                	{
        	                		alt40=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt40)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1596:17: termList[guards,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand3144);
        	        	        termList(ctx, guards, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3149);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand3155);
        	        term(ctx, head, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand3158);
        	        term(ctx, body, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        {

        	                  args.clear();
        	                  args.push_back(head);
        	                  args.push_back(body);
        	                  /* triggers */
        	                  if( !triggers.empty() ){
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, triggers);
        	                    args.push_back(expr2);
        	                  };
        	                  expr = MK_EXPR(kind, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                  /* guards */
        	                  switch( guards.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(guards[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, guards);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(expr);
        	                  expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                  cmd->reset(new AssertCommand(expr, false)); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1624:5: rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_rewritePropaKind_in_rewriterulesCommand3177);
        	        rewritePropaKind(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3184);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_rewriterulesCommand3186);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3189);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        {

        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3201);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1636:16: ( pattern[expr] )*

        	        for (;;)
        	        {
        	            int alt41=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt41=1;
        	            	}
        	                break;

        	            }

        	            switch (alt41)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1636:18: pattern[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_pattern_in_rewriterulesCommand3205);
        	        	        pattern(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	        {
        	        	             triggers.push_back( expr ); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop41;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop41: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3213);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3219);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1637:16: ( termList[guards,expr] )?
        	        {
        	            int alt42=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_VAR_TOK:
        	                case EMPTYSET_TOK:
        	                case FP_RNA_FULL_TOK:
        	                case FP_RNA_TOK:
        	                case FP_RNE_FULL_TOK:
        	                case FP_RNE_TOK:
        	                case FP_RTN_FULL_TOK:
        	                case FP_RTN_TOK:
        	                case FP_RTP_FULL_TOK:
        	                case FP_RTP_TOK:
        	                case FP_RTZ_FULL_TOK:
        	                case FP_RTZ_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case INV_CONSTRAINT_TOK:
        	                case LPAREN_TOK:
        	                case NILREF_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case REAL_PI_TOK:
        	                case RENOSTR_TOK:
        	                case SET_OPTIONS_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL_2_0:
        	                case STRING_LITERAL_2_5:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case TUPLE_CONST_TOK:
        	                case UNIVSET_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 162:
        	                	{
        	                		alt42=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt42)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1637:17: termList[guards,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand3222);
        	        	        termList(ctx, guards, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3227);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand3233);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1638:16: ( termList[heads,expr] )?
        	        {
        	            int alt43=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_VAR_TOK:
        	                case EMPTYSET_TOK:
        	                case FP_RNA_FULL_TOK:
        	                case FP_RNA_TOK:
        	                case FP_RNE_FULL_TOK:
        	                case FP_RNE_TOK:
        	                case FP_RTN_FULL_TOK:
        	                case FP_RTN_TOK:
        	                case FP_RTP_FULL_TOK:
        	                case FP_RTP_TOK:
        	                case FP_RTZ_FULL_TOK:
        	                case FP_RTZ_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case INV_CONSTRAINT_TOK:
        	                case LPAREN_TOK:
        	                case NILREF_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case REAL_PI_TOK:
        	                case RENOSTR_TOK:
        	                case SET_OPTIONS_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL_2_0:
        	                case STRING_LITERAL_2_5:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case TUPLE_CONST_TOK:
        	                case UNIVSET_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 162:
        	                	{
        	                		alt43=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt43)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1638:17: termList[heads,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand3236);
        	        	        termList(ctx, heads, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand3241);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand3247);
        	        term(ctx, body, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }


        	        {

        	                  args.clear();
        	                  /* heads */
        	                  switch( heads.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(heads[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, heads);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(body);
        	                  /* triggers */
        	                  if( !triggers.empty() ){
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, triggers);
        	                    args.push_back(expr2);
        	                  };
        	                  expr = MK_EXPR(kind, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                  /* guards */
        	                  switch( guards.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(guards[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, guards);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(expr);
        	                  expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                  cmd->reset(new AssertCommand(expr, false));
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerewriterulesCommandEx; /* Prevent compiler warnings */
    rulerewriterulesCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end rewriterulesCommand */

/**
 * $ANTLR start rewritePropaKind
 * ../../../../src/parser/smt2/Smt2.g:1677:1: rewritePropaKind[CVC4::Kind& kind] : ( REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK );
 */
static void
rewritePropaKind(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1678:3: ( REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK )

            ANTLR3_UINT32 alt45;

            alt45=2;

            switch ( LA(1) )
            {
            case REDUCTION_RULE_TOK:
            	{
            		alt45=1;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            	{
            		alt45=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 45;
                EXCEPTION->state        = 0;


                goto rulerewritePropaKindEx;

            }

            switch (alt45)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1678:5: REDUCTION_RULE_TOK
        	    {
        	         MATCHT(REDUCTION_RULE_TOK, &FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind3268);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewritePropaKindEx;
        	        }


        	        {
        	             kind= CVC4::kind::RR_REDUCTION; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1679:5: PROPAGATION_RULE_TOK
        	    {
        	         MATCHT(PROPAGATION_RULE_TOK, &FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind3279);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewritePropaKindEx;
        	        }


        	        {
        	             kind= CVC4::kind::RR_DEDUCTION; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerewritePropaKindEx; /* Prevent compiler warnings */
    rulerewritePropaKindEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end rewritePropaKind */

/**
 * $ANTLR start pattern
 * ../../../../src/parser/smt2/Smt2.g:1682:1: pattern[CVC4::Expr& expr] : LPAREN_TOK termList[patexpr,expr] RPAREN_TOK ;
 */
static void
pattern(pSmt2Parser ctx, CVC4::Expr& expr)
{

      std::vector<Expr> patexpr;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:1686:3: ( LPAREN_TOK termList[patexpr,expr] RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:1686:5: LPAREN_TOK termList[patexpr,expr] RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_pattern3301);
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }


            FOLLOWPUSH(FOLLOW_termList_in_pattern3303);
            termList(ctx, patexpr, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_pattern3306);
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }


            {

                      expr = MK_EXPR(kind::INST_PATTERN, patexpr);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulepatternEx; /* Prevent compiler warnings */
    rulepatternEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end pattern */

/**
 * $ANTLR start simpleSymbolicExprNoKeyword
 * ../../../../src/parser/smt2/Smt2.g:1692:1: simpleSymbolicExprNoKeyword[CVC4::SExpr& sexpr] : ( INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[s,CHECK_NONE,SYM_SORT] |tok= ( ASSERT_TOK | CHECK_SAT_TOK | CHECK_SAT_ASSUMING_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK ) | builtinOp[k] );
 */
static void
simpleSymbolicExprNoKeyword(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{

      CVC4::Kind k;
      std::string s;
      std::vector<unsigned int> s_vec;

    pANTLR3_COMMON_TOKEN    tok;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL8;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL9;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL10;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL11;

    /* Initialize rule variables
     */

    tok       = NULL;
    INTEGER_LITERAL8       = NULL;
    DECIMAL_LITERAL9       = NULL;
    HEX_LITERAL10       = NULL;
    BINARY_LITERAL11       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1698:3: ( INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[s,CHECK_NONE,SYM_SORT] |tok= ( ASSERT_TOK | CHECK_SAT_TOK | CHECK_SAT_ASSUMING_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK ) | builtinOp[k] )

            ANTLR3_UINT32 alt46;

            alt46=8;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt46=1;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt46=2;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt46=3;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt46=4;
            	}
                break;
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            	{
            		alt46=5;
            	}
                break;
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case QUOTED_SYMBOL:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 162:
            	{
            		alt46=6;
            	}
                break;
            case ASSERT_TOK:
            case CHECK_SAT_ASSUMING_TOK:
            case CHECK_SAT_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_ASSUMPTIONS_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case REDUCTION_RULE_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLIFY_TOK:
            	{
            		alt46=7;
            	}
                break;
            case AND_TOK:
            case BV2NAT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case DTSIZE_TOK:
            case EQUAL_TOK:
            case FMFCARDVAL_TOK:
            case FMFCARD_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case IMPLIES_TOK:
            case INST_CLOSURE_TOK:
            case ITE_TOK:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case STAR_TOK:
            case XOR_TOK:
            	{
            		alt46=8;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 46;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprNoKeywordEx;

            }

            switch (alt46)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1698:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL8 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword3331);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(Integer(AntlrInput::tokenText(INTEGER_LITERAL8))); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1700:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL9 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword3343);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(AntlrInput::tokenToRational(DECIMAL_LITERAL9)); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1702:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL10 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword3355);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL10).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL10, 2);
        	                  sexpr = SExpr(Integer(hexString, 16));
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1707:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL11 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword3367);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL11).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL11, 2);
        	                  sexpr = SExpr(Integer(binString, 2));
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1712:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_simpleSymbolicExprNoKeyword3379);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(s); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:1721:5: symbol[s,CHECK_NONE,SYM_SORT]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_simpleSymbolicExprNoKeyword3399);
        	        symbol(ctx, s, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(SExpr::Keyword(s)); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:1723:5: tok= ( ASSERT_TOK | CHECK_SAT_TOK | CHECK_SAT_ASSUMING_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_FUN_REC_TOK | DEFINE_FUNS_REC_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_ASSUMPTIONS_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | RESET_TOK | RESET_ASSERTIONS_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK )
        	    {
        	        tok=(pANTLR3_COMMON_TOKEN)LT(1);

        	        if ( LA(1) == ASSERT_TOK || ((LA(1) >= CHECK_SAT_ASSUMING_TOK) && (LA(1) <= CHECK_SAT_TOK)) || LA(1) == DECLARE_DATATYPES_TOK || LA(1) == DECLARE_FUN_TOK || LA(1) == DECLARE_SORT_TOK || ((LA(1) >= DEFINE_FUNS_REC_TOK) && (LA(1) <= DEFINE_SORT_TOK)) || LA(1) == ECHO_TOK || LA(1) == EXIT_TOK || ((LA(1) >= GET_ASSERTIONS_TOK) && (LA(1) <= GET_PROOF_TOK)) || ((LA(1) >= GET_UNSAT_ASSUMPTIONS_TOK) && (LA(1) <= GET_VALUE_TOK)) || ((LA(1) >= POP_TOK) && (LA(1) <= PUSH_TOK)) || LA(1) == REDUCTION_RULE_TOK || ((LA(1) >= RESET_ASSERTIONS_TOK) && (LA(1) <= REWRITE_RULE_TOK)) || ((LA(1) >= SET_INFO_TOK) && (LA(1) <= SET_LOGIC_TOK)) || LA(1) == SET_OPTION_TOK || LA(1) == SIMPLIFY_TOK )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        }
        	        else
        	        {
        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             sexpr = SExpr(SExpr::Keyword(AntlrInput::tokenText(tok))); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:1734:5: builtinOp[k]
        	    {
        	        FOLLOWPUSH(FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword3624);
        	        builtinOp(ctx, k);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        {
        	             std::stringstream ss;
        	                  ss << language::SetLanguage(CVC4::language::output::LANG_SMTLIB_V2_5)
        	                     << EXPR_MANAGER->mkConst(k);
        	                  sexpr = SExpr(ss.str());
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprNoKeywordEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprNoKeywordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExprNoKeyword */

/**
 * $ANTLR start keyword
 * ../../../../src/parser/smt2/Smt2.g:1742:1: keyword[std::string& s] : KEYWORD ;
 */
static void
keyword(pSmt2Parser ctx, std::string& s)
{
    pANTLR3_COMMON_TOKEN    KEYWORD12;

    /* Initialize rule variables
     */

    KEYWORD12       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:1743:3: ( KEYWORD )
        // ../../../../src/parser/smt2/Smt2.g:1743:5: KEYWORD
        {
            KEYWORD12 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_keyword3645);
            if  (HASEXCEPTION())
            {
                goto rulekeywordEx;
            }


            {
                 s = AntlrInput::tokenText(KEYWORD12); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulekeywordEx; /* Prevent compiler warnings */
    rulekeywordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end keyword */

/**
 * $ANTLR start simpleSymbolicExpr
 * ../../../../src/parser/smt2/Smt2.g:1747:1: simpleSymbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExprNoKeyword[sexpr] | KEYWORD );
 */
static void
simpleSymbolicExpr(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{
    pANTLR3_COMMON_TOKEN    KEYWORD13;

    /* Initialize rule variables
     */

    KEYWORD13       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1748:3: ( simpleSymbolicExprNoKeyword[sexpr] | KEYWORD )

            ANTLR3_UINT32 alt47;

            alt47=2;

            switch ( LA(1) )
            {
            case AND_TOK:
            case ASSERT_TOK:
            case BINARY_LITERAL:
            case BV2NAT_TOK:
            case CHECK_SAT_ASSUMING_TOK:
            case CHECK_SAT_TOK:
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_SORT_TOK:
            case DECLARE_VAR_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case DTSIZE_TOK:
            case ECHO_TOK:
            case EQUAL_TOK:
            case EXIT_TOK:
            case FMFCARDVAL_TOK:
            case FMFCARD_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_ASSUMPTIONS_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case HEX_LITERAL:
            case IMPLIES_TOK:
            case INST_CLOSURE_TOK:
            case INTEGER_LITERAL:
            case INV_CONSTRAINT_TOK:
            case ITE_TOK:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case QUOTED_SYMBOL:
            case REDUCTION_RULE_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTIONS_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            case STAR_TOK:
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case XOR_TOK:
            case 162:
            	{
            		alt47=1;
            	}
                break;
            case KEYWORD:
            	{
            		alt47=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 47;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprEx;

            }

            switch (alt47)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1748:5: simpleSymbolicExprNoKeyword[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr3665);
        	        simpleSymbolicExprNoKeyword(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1749:5: KEYWORD
        	    {
        	        KEYWORD13 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_simpleSymbolicExpr3672);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }


        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(KEYWORD13)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExpr */

/**
 * $ANTLR start symbolicExpr
 * ../../../../src/parser/smt2/Smt2.g:1753:1: symbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExpr[sexpr] | LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK );
 */
static void
symbolicExpr(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{

      std::vector<SExpr> children;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1757:3: ( simpleSymbolicExpr[sexpr] | LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK )

            ANTLR3_UINT32 alt49;

            alt49=2;

            switch ( LA(1) )
            {
            case AND_TOK:
            case ASSERT_TOK:
            case BINARY_LITERAL:
            case BV2NAT_TOK:
            case CHECK_SAT_ASSUMING_TOK:
            case CHECK_SAT_TOK:
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_SORT_TOK:
            case DECLARE_VAR_TOK:
            case DEFINE_FUNS_REC_TOK:
            case DEFINE_FUN_REC_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case DTSIZE_TOK:
            case ECHO_TOK:
            case EQUAL_TOK:
            case EXIT_TOK:
            case FMFCARDVAL_TOK:
            case FMFCARD_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_ASSUMPTIONS_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case HEX_LITERAL:
            case IMPLIES_TOK:
            case INST_CLOSURE_TOK:
            case INTEGER_LITERAL:
            case INV_CONSTRAINT_TOK:
            case ITE_TOK:
            case KEYWORD:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case QUOTED_SYMBOL:
            case REDUCTION_RULE_TOK:
            case RESET_ASSERTIONS_TOK:
            case RESET_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTIONS_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            case STAR_TOK:
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case XOR_TOK:
            case 162:
            	{
            		alt49=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt49=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 49;
                EXCEPTION->state        = 0;


                goto rulesymbolicExprEx;

            }

            switch (alt49)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1757:5: simpleSymbolicExpr[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_symbolicExpr3697);
        	        simpleSymbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1758:5: LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_symbolicExpr3704);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1759:5: ( symbolicExpr[sexpr] )*

        	        for (;;)
        	        {
        	            int alt48=2;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case CHECK_SAT_ASSUMING_TOK:
        	            case CHECK_SAT_TOK:
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DECLARE_VAR_TOK:
        	            case DEFINE_FUNS_REC_TOK:
        	            case DEFINE_FUN_REC_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DISTINCT_TOK:
        	            case DIV_TOK:
        	            case DTSIZE_TOK:
        	            case ECHO_TOK:
        	            case EQUAL_TOK:
        	            case EXIT_TOK:
        	            case FMFCARDVAL_TOK:
        	            case FMFCARD_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_ASSUMPTIONS_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_LITERAL:
        	            case IMPLIES_TOK:
        	            case INST_CLOSURE_TOK:
        	            case INTEGER_LITERAL:
        	            case INV_CONSTRAINT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case LPAREN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case REDUCTION_RULE_TOK:
        	            case RESET_ASSERTIONS_TOK:
        	            case RESET_TOK:
        	            case REWRITE_RULE_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case XOR_TOK:
        	            case 162:
        	            	{
        	            		alt48=1;
        	            	}
        	                break;

        	            }

        	            switch (alt48)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1759:7: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_symbolicExpr3712);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolicExprEx;
        	        	        }


        	        	        {
        	        	             children.push_back(sexpr); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop48;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop48: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_symbolicExpr3720);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }


        	        {
        	             sexpr = SExpr(children); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolicExprEx; /* Prevent compiler warnings */
    rulesymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolicExpr */

/**
 * $ANTLR start term
 * ../../../../src/parser/smt2/Smt2.g:1767:1: term[CVC4::Expr& expr, CVC4::Expr& expr2] : ( termNonVariable[expr, expr2] | symbol[name,CHECK_DECLARED,SYM_VARIABLE] );
 */
static void
term(pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& expr2)
{
    /* Initialize rule variables
     */


      std::string name;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1771:3: ( termNonVariable[expr, expr2] | symbol[name,CHECK_DECLARED,SYM_VARIABLE] )

            ANTLR3_UINT32 alt50;

            alt50=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case EMPTYSET_TOK:
            case FP_RNA_FULL_TOK:
            case FP_RNA_TOK:
            case FP_RNE_FULL_TOK:
            case FP_RNE_TOK:
            case FP_RTN_FULL_TOK:
            case FP_RTN_TOK:
            case FP_RTP_FULL_TOK:
            case FP_RTP_TOK:
            case FP_RTZ_FULL_TOK:
            case FP_RTZ_TOK:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case LPAREN_TOK:
            case NILREF_TOK:
            case REALLCHAR_TOK:
            case REAL_PI_TOK:
            case RENOSTR_TOK:
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            case TUPLE_CONST_TOK:
            case UNIVSET_TOK:
            	{
            		alt50=1;
            	}
                break;
            case SIMPLE_SYMBOL:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 2;


            		    goto ruletermEx;

            		}

            	}
                break;
            case 162:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 3;


            		    goto ruletermEx;

            		}

            	}
                break;
            case SET_OPTIONS_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 4;


            		    goto ruletermEx;

            		}

            	}
                break;
            case DECLARE_VAR_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 5;


            		    goto ruletermEx;

            		}

            	}
                break;
            case DECLARE_PRIMED_VAR_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 6;


            		    goto ruletermEx;

            		}

            	}
                break;
            case SYNTH_FUN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 7;


            		    goto ruletermEx;

            		}

            	}
                break;
            case SYNTH_INV_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 8;


            		    goto ruletermEx;

            		}

            	}
                break;
            case CONSTRAINT_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 9;


            		    goto ruletermEx;

            		}

            	}
                break;
            case INV_CONSTRAINT_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 10;


            		    goto ruletermEx;

            		}

            	}
                break;
            case CHECK_SYNTH_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 11;


            		    goto ruletermEx;

            		}

            	}
                break;
            case QUOTED_SYMBOL:
            	{
            		switch ( LA(2) )
            		{
            		case SYGUS_ENUM_CONS_TOK:
            			{
            				alt50=1;
            			}
            		    break;
            		case EOF:
            		case ATTRIBUTE_INST_LEVEL:
            		case ATTRIBUTE_NAMED_TOK:
            		case ATTRIBUTE_NO_PATTERN_TOK:
            		case ATTRIBUTE_PATTERN_TOK:
            		case ATTRIBUTE_RR_PRIORITY:
            		case BINARY_LITERAL:
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECIMAL_LITERAL:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case EMPTYSET_TOK:
            		case FP_RNA_FULL_TOK:
            		case FP_RNA_TOK:
            		case FP_RNE_FULL_TOK:
            		case FP_RNE_TOK:
            		case FP_RTN_FULL_TOK:
            		case FP_RTN_TOK:
            		case FP_RTP_FULL_TOK:
            		case FP_RTP_TOK:
            		case FP_RTZ_FULL_TOK:
            		case FP_RTZ_TOK:
            		case HEX_LITERAL:
            		case INTEGER_LITERAL:
            		case INV_CONSTRAINT_TOK:
            		case KEYWORD:
            		case LPAREN_TOK:
            		case NILREF_TOK:
            		case QUOTED_SYMBOL:
            		case REALLCHAR_TOK:
            		case REAL_PI_TOK:
            		case RENOSTR_TOK:
            		case RPAREN_TOK:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case STRING_LITERAL_2_0:
            		case STRING_LITERAL_2_5:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case TUPLE_CONST_TOK:
            		case UNIVSET_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt50=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 12;


            		    goto ruletermEx;

            		}

            	}
                break;
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		switch ( LA(2) )
            		{
            		case EOF:
            			{
            				alt50=1;
            			}
            		    break;
            		case 160:
            			{
            				alt50=1;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 13;


            		    goto ruletermEx;

            		}

            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 50;
                EXCEPTION->state        = 0;


                goto ruletermEx;

            }

            switch (alt50)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1771:3: termNonVariable[expr, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_termNonVariable_in_term3745);
        	        termNonVariable(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1773:5: symbol[name,CHECK_DECLARED,SYM_VARIABLE]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_term3758);
        	        symbol(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	        {
        	             expr = PARSER_STATE->getExpressionForName(name); 
        	                  assert( !expr.isNull() );
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start termNonVariable
 * ../../../../src/parser/smt2/Smt2.g:1783:1: termNonVariable[CVC4::Expr& expr, CVC4::Expr& expr2] : ( LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK ( termNonVariable[f, f2] | symbol[name,CHECK_DECLARED,SYM_VARIABLE] ) sortSymbol[type, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK | LPAREN_TOK ( indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK ) | LPAREN_TOK ( LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+ ) RPAREN_TOK term[expr, f2] RPAREN_TOK | LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK | symbol[name,CHECK_NONE,SYM_VARIABLE] SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] | LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK | LPAREN_TOK HO_LAMBDA_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK | INTEGER_LITERAL | DECIMAL_LITERAL | LPAREN_TOK INDEX_TOK (bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL ) RPAREN_TOK | HEX_LITERAL | BINARY_LITERAL | str[s,false] | FP_RNE_TOK | FP_RNA_TOK | FP_RTP_TOK | FP_RTN_TOK | FP_RTZ_TOK | FP_RNE_FULL_TOK | FP_RNA_FULL_TOK | FP_RTP_FULL_TOK | FP_RTN_FULL_TOK | FP_RTZ_FULL_TOK | REAL_PI_TOK | RENOSTR_TOK | REALLCHAR_TOK | EMPTYSET_TOK | UNIVSET_TOK | NILREF_TOK | LPAREN_TOK TUPLE_CONST_TOK termList[args,expr] RPAREN_TOK | TUPLE_CONST_TOK );
 */
static void
termNonVariable(pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& expr2)
{
    pANTLR3_COMMON_TOKEN    bvLit;
    pANTLR3_COMMON_TOKEN    size;
    pANTLR3_COMMON_TOKEN    eb;
    pANTLR3_COMMON_TOKEN    sb;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL14;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL15;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL16;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL17;

    /* Initialize rule variables
     */


      Debug("parser") << "term: " << AntlrInput::tokenText(LT(1)) << std::endl;
      Kind kind = kind::NULL_EXPR;
      Expr op;
      std::string name, name2;
      std::vector<Expr> args;
      std::vector< std::pair<std::string, Type> > sortedVarNames;
      Expr f, f2, f3, f4;
      std::string attr;
      Expr attexpr;
      std::vector<Expr> patexprs;
      std::vector<Expr> patconds;
      std::unordered_set<std::string> names;
      std::vector< std::pair<std::string, Expr> > binders;
      Type type;
      std::string s;
      bool isBuiltinOperator = false;
      bool isOverloadedFunction = false;
      bool readVariable = false;
      int match_vindex = -1;
      std::vector<Type> match_ptypes;

    bvLit       = NULL;
    size       = NULL;
    eb       = NULL;
    sb       = NULL;
    INTEGER_LITERAL14       = NULL;
    DECIMAL_LITERAL15       = NULL;
    HEX_LITERAL16       = NULL;
    BINARY_LITERAL17       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:1806:3: ( LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK ( termNonVariable[f, f2] | symbol[name,CHECK_DECLARED,SYM_VARIABLE] ) sortSymbol[type, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK | LPAREN_TOK ( indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK ) | LPAREN_TOK ( LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+ ) RPAREN_TOK term[expr, f2] RPAREN_TOK | LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK | symbol[name,CHECK_NONE,SYM_VARIABLE] SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE] | LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK | LPAREN_TOK HO_LAMBDA_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK | INTEGER_LITERAL | DECIMAL_LITERAL | LPAREN_TOK INDEX_TOK (bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL ) RPAREN_TOK | HEX_LITERAL | BINARY_LITERAL | str[s,false] | FP_RNE_TOK | FP_RNA_TOK | FP_RTP_TOK | FP_RTN_TOK | FP_RTZ_TOK | FP_RNE_FULL_TOK | FP_RNA_FULL_TOK | FP_RTP_FULL_TOK | FP_RTN_FULL_TOK | FP_RTZ_FULL_TOK | REAL_PI_TOK | RENOSTR_TOK | REALLCHAR_TOK | EMPTYSET_TOK | UNIVSET_TOK | NILREF_TOK | LPAREN_TOK TUPLE_CONST_TOK termList[args,expr] RPAREN_TOK | TUPLE_CONST_TOK )

            ANTLR3_UINT32 alt60;

            alt60=34;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case AS_TOK:
            			{
            				alt60=2;
            			}
            		    break;
            		case MATCH_TOK:
            			{
            				alt60=7;
            			}
            		    break;
            		case ATTRIBUTE_TOK:
            			{
            				alt60=9;
            			}
            		    break;
            		case HO_LAMBDA_TOK:
            			{
            				alt60=10;
            			}
            		    break;
            		case INDEX_TOK:
            			{
            				alt60=13;
            			}
            		    break;
            		case TUPLE_CONST_TOK:
            			{
            				alt60=33;
            			}
            		    break;
            		case AND_TOK:
            		case BV2NAT_TOK:
            		case DISTINCT_TOK:
            		case DIV_TOK:
            		case DTSIZE_TOK:
            		case EQUAL_TOK:
            		case FMFCARDVAL_TOK:
            		case FMFCARD_TOK:
            		case GREATER_THAN_EQUAL_TOK:
            		case GREATER_THAN_TOK:
            		case IMPLIES_TOK:
            		case INST_CLOSURE_TOK:
            		case ITE_TOK:
            		case LESS_THAN_EQUAL_TOK:
            		case LESS_THAN_TOK:
            		case MINUS_TOK:
            		case NOT_TOK:
            		case OR_TOK:
            		case PLUS_TOK:
            		case STAR_TOK:
            		case XOR_TOK:
            			{
            				alt60=1;
            			}
            		    break;
            		case EXISTS_TOK:
            		case FORALL_TOK:
            			{
            				alt60=3;
            			}
            		    break;
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case INV_CONSTRAINT_TOK:
            		case QUOTED_SYMBOL:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt60=4;
            			}
            		    break;
            		case LPAREN_TOK:
            			{
            				alt60=5;
            			}
            		    break;
            		case LET_TOK:
            		case SYGUS_LET_TOK:
            			{
            				alt60=6;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 60;
            		    EXCEPTION->state        = 1;


            		    goto ruletermNonVariableEx;

            		}

            	}
                break;
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case QUOTED_SYMBOL:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 162:
            	{
            		alt60=8;
            	}
                break;
            case INTEGER_LITERAL:
            	{
            		alt60=11;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt60=12;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt60=14;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt60=15;
            	}
                break;
            case STRING_LITERAL_2_0:
            case STRING_LITERAL_2_5:
            	{
            		alt60=16;
            	}
                break;
            case FP_RNE_TOK:
            	{
            		alt60=17;
            	}
                break;
            case FP_RNA_TOK:
            	{
            		alt60=18;
            	}
                break;
            case FP_RTP_TOK:
            	{
            		alt60=19;
            	}
                break;
            case FP_RTN_TOK:
            	{
            		alt60=20;
            	}
                break;
            case FP_RTZ_TOK:
            	{
            		alt60=21;
            	}
                break;
            case FP_RNE_FULL_TOK:
            	{
            		alt60=22;
            	}
                break;
            case FP_RNA_FULL_TOK:
            	{
            		alt60=23;
            	}
                break;
            case FP_RTP_FULL_TOK:
            	{
            		alt60=24;
            	}
                break;
            case FP_RTN_FULL_TOK:
            	{
            		alt60=25;
            	}
                break;
            case FP_RTZ_FULL_TOK:
            	{
            		alt60=26;
            	}
                break;
            case REAL_PI_TOK:
            	{
            		alt60=27;
            	}
                break;
            case RENOSTR_TOK:
            	{
            		alt60=28;
            	}
                break;
            case REALLCHAR_TOK:
            	{
            		alt60=29;
            	}
                break;
            case EMPTYSET_TOK:
            	{
            		alt60=30;
            	}
                break;
            case UNIVSET_TOK:
            	{
            		alt60=31;
            	}
                break;
            case NILREF_TOK:
            	{
            		alt60=32;
            	}
                break;
            case TUPLE_CONST_TOK:
            	{
            		alt60=34;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 60;
                EXCEPTION->state        = 0;


                goto ruletermNonVariableEx;

            }

            switch (alt60)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:1807:5: LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3792);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_builtinOp_in_termNonVariable3794);
        	        builtinOp(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_termNonVariable3797);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3800);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  if( !PARSER_STATE->strictModeEnabled() &&
        	                      (kind == CVC4::kind::AND || kind == CVC4::kind::OR) &&
        	                      args.size() == 1) {
        	                    /* Unary AND/OR can be replaced with the argument.
        	                     * It just so happens expr should already be the only argument. */
        	                    assert( expr == args[0] );
        	                  } else if( CVC4::kind::isAssociative(kind) &&
        	                             args.size() > EXPR_MANAGER->maxArity(kind) ) {
        	                    /* Special treatment for associative operators with lots of children */
        	                    expr = EXPR_MANAGER->mkAssociative(kind, args);
        	                  } else if( kind == CVC4::kind::MINUS && args.size() == 1 ) {
        	                    expr = MK_EXPR(CVC4::kind::UMINUS, args[0]);
        	                  } else if( ( kind == CVC4::kind::XOR || kind == CVC4::kind::MINUS ) &&
        	                             args.size() > 2 ) {
        	                    /* left-associative, but CVC4 internally only supports 2 args */
        	                    expr = args[0];
        	                    for(size_t i = 1; i < args.size(); ++i) {
        	                      expr = MK_EXPR(kind, expr, args[i]);
        	                    }
        	                  } else if( kind == CVC4::kind::IMPLIES && args.size() > 2 ) {
        	                    /* right-associative, but CVC4 internally only supports 2 args */
        	                    expr = args[args.size() - 1];
        	                    for(size_t i = args.size() - 1; i > 0;) {
        	                      expr = MK_EXPR(kind, args[--i], expr);
        	                    }
        	                  } else if( ( kind == CVC4::kind::EQUAL ||
        	                               kind == CVC4::kind::LT || kind == CVC4::kind::GT ||
        	                               kind == CVC4::kind::LEQ || kind == CVC4::kind::GEQ ) &&
        	                             args.size() > 2 ) {
        	                    /* "chainable", but CVC4 internally only supports 2 args */
        	                    expr = MK_EXPR(MK_CONST(Chain(kind)), args);
        	                  } else if( PARSER_STATE->strictModeEnabled() && kind == CVC4::kind::ABS &&
        	                             args.size() == 1 && !args[0].getType().isInteger() ) {
        	                    /* first, check that ABS is even defined in this logic */
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                    PARSER_STATE->parseError("abs can only be applied to Int, not Real, "
        	                                             "while in strict SMT-LIB compliance mode");
        	                  } else {
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                    expr = MK_EXPR(kind, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:1851:5: LPAREN_TOK AS_TOK ( termNonVariable[f, f2] | symbol[name,CHECK_DECLARED,SYM_VARIABLE] ) sortSymbol[type, CHECK_DECLARED] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3812);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(AS_TOK, &FOLLOW_AS_TOK_in_termNonVariable3814);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1851:23: ( termNonVariable[f, f2] | symbol[name,CHECK_DECLARED,SYM_VARIABLE] )
        	        {
        	            int alt51=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case EMPTYSET_TOK:
        	            case FP_RNA_FULL_TOK:
        	            case FP_RNA_TOK:
        	            case FP_RNE_FULL_TOK:
        	            case FP_RNE_TOK:
        	            case FP_RTN_FULL_TOK:
        	            case FP_RTN_TOK:
        	            case FP_RTP_FULL_TOK:
        	            case FP_RTP_TOK:
        	            case FP_RTZ_FULL_TOK:
        	            case FP_RTZ_TOK:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case LPAREN_TOK:
        	            case NILREF_TOK:
        	            case REALLCHAR_TOK:
        	            case REAL_PI_TOK:
        	            case RENOSTR_TOK:
        	            case STRING_LITERAL_2_0:
        	            case STRING_LITERAL_2_5:
        	            case TUPLE_CONST_TOK:
        	            case UNIVSET_TOK:
        	            	{
        	            		alt51=1;
        	            	}
        	                break;
        	            case SIMPLE_SYMBOL:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 2;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case 162:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 3;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case SET_OPTIONS_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 4;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case DECLARE_VAR_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 5;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case DECLARE_PRIMED_VAR_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 6;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case SYNTH_FUN_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 7;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case SYNTH_INV_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 8;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case CONSTRAINT_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 9;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case INV_CONSTRAINT_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 10;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 11;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case QUOTED_SYMBOL:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case SYGUS_ENUM_CONS_TOK:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case CHECK_SYNTH_TOK:
        	            		case CONSTRAINT_TOK:
        	            		case DECLARE_PRIMED_VAR_TOK:
        	            		case DECLARE_VAR_TOK:
        	            		case INV_CONSTRAINT_TOK:
        	            		case LPAREN_TOK:
        	            		case QUOTED_SYMBOL:
        	            		case SET_OPTIONS_TOK:
        	            		case SIMPLE_SYMBOL:
        	            		case SYNTH_FUN_TOK:
        	            		case SYNTH_INV_TOK:
        	            		case UNTERMINATED_QUOTED_SYMBOL:
        	            		case 162:
        	            			{
        	            				alt51=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 12;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case EOF:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;
        	            		case 160:
        	            			{
        	            				alt51=1;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 51;
        	            		    EXCEPTION->state        = 13;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 51;
        	                EXCEPTION->state        = 0;


        	                goto ruletermNonVariableEx;

        	            }

        	            switch (alt51)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1851:25: termNonVariable[f, f2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termNonVariable_in_termNonVariable3818);
        	        	        termNonVariable(ctx, f, f2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1851:50: symbol[name,CHECK_DECLARED,SYM_VARIABLE]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable3823);
        	        	        symbol(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             readVariable = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_termNonVariable3835);
        	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3838);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  if(readVariable) {
        	                    Trace("parser-overloading") << "Getting variable expression of type " << name << " with type " << type << std::endl;
        	                    // get the variable expression for the type
        	                    f = PARSER_STATE->getExpressionForNameAndType(name, type); 
        	                    assert( !f.isNull() );
        	                  }
        	                  if(f.getKind() == CVC4::kind::APPLY_CONSTRUCTOR && type.isDatatype()) {
        	                    // could be a parametric type constructor or just an overloaded constructor
        	                    if(((DatatypeType)type).isParametric()) {
        	                      std::vector<CVC4::Expr> v;
        	                      Expr e = f.getOperator();
        	                      const DatatypeConstructor& dtc =
        	                          Datatype::datatypeOf(e)[Datatype::indexOf(e)];
        	                      v.push_back(MK_EXPR( CVC4::kind::APPLY_TYPE_ASCRIPTION,
        	                                           MK_CONST(AscriptionType(dtc.getSpecializedConstructorType(type))), f.getOperator() ));
        	                      v.insert(v.end(), f.begin(), f.end());
        	                      expr = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, v);
        	                    }else{
        	                      expr = f;
        	                    }
        	                  } else if(f.getKind() == CVC4::kind::EMPTYSET) {
        	                    Debug("parser") << "Empty set encountered: " << f << " "
        	                                      << f2 << " " << type <<  std::endl;
        	                    expr = MK_CONST( ::CVC4::EmptySet(type) );
        	                  } else if(f.getKind() == CVC4::kind::UNIVERSE_SET) {
        	                    expr = EXPR_MANAGER->mkNullaryOperator(type, kind::UNIVERSE_SET);
        	                  } else if(f.getKind() == CVC4::kind::SEP_NIL) {
        	                    //We don't want the nil reference to be a constant: for instance, it
        	                    //could be of type Int but is not a const rational. However, the
        	                    //expression has 0 children. So we convert to a SEP_NIL variable.
        	                    expr = EXPR_MANAGER->mkNullaryOperator(type, kind::SEP_NIL);
        	                  } else {
        	                    if(f.getType() != type) {
        	                      PARSER_STATE->parseError("Type ascription not satisfied.");
        	                    }else{
        	                      expr = f;
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:1893:5: LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3850);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_quantOp_in_termNonVariable3852);
        	        quantOp(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3859);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_termNonVariable3861);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3864);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  Expr bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable3876);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3879);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  PARSER_STATE->popScope();
        	                  switch(f.getKind()) {
        	                  case CVC4::kind::RR_REWRITE:
        	                  case CVC4::kind::RR_REDUCTION:
        	                  case CVC4::kind::RR_DEDUCTION:
        	                    if(kind == CVC4::kind::EXISTS) {
        	                      PARSER_STATE->parseError("Use Exists instead of Forall for a rewrite "
        	                                               "rule.");
        	                    }
        	                    args.push_back(f2); // guards
        	                    args.push_back(f); // rule
        	                    expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                    break;
        	                  default:
        	                    args.push_back(f);
        	                    if(! f2.isNull()){
        	                      args.push_back(f2);
        	                    }
        	                    expr = MK_EXPR(kind, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:1930:5: LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3891);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_functionName_in_termNonVariable3893);
        	        functionName(ctx, name, CHECK_NONE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             isBuiltinOperator = PARSER_STATE->isOperatorEnabled(name);
        	                  if(isBuiltinOperator) {
        	                    /* A built-in operator not already handled by the lexer */
        	                    kind = PARSER_STATE->getOperatorKind(name);
        	                  } else {
        	                    /* A non-built-in function application */
        	                    PARSER_STATE->checkDeclaration(name, CHECK_DECLARED, SYM_VARIABLE);
        	                    expr = PARSER_STATE->getVariable(name);
        	                    if(!expr.isNull()) {
        	                      //hack to allow constants with parentheses (disabled for now)
        	                      //if( PARSER_STATE->sygus() && !PARSER_STATE->isFunctionLike(expr) ){
        	                      //  op = PARSER_STATE->getVariable(name);
        	                      //}else{
        	                      PARSER_STATE->checkFunctionLike(expr);
        	                      kind = PARSER_STATE->getKindForFunction(expr);
        	                      args.push_back(expr);
        	                    }else{
        	                      isOverloadedFunction = true;
        	                    }
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_termNonVariable3911);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3914);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             Debug("parser") << "args has size " << args.size() << std::endl
        	                                  << "expr is " << expr << std::endl;
        	                  for(std::vector<Expr>::iterator i = args.begin(); i != args.end(); ++i) {
        	                    Debug("parser") << "++ " << *i << std::endl;
        	                  }
        	                  if(isOverloadedFunction) {
        	                    std::vector< Type > argTypes;
        	                    for(std::vector<Expr>::iterator i = args.begin(); i != args.end(); ++i) {
        	                      argTypes.push_back( (*i).getType() );
        	                    }
        	                    expr = PARSER_STATE->getOverloadedFunctionForTypes(name, argTypes);
        	                    if(!expr.isNull()) {
        	                      PARSER_STATE->checkFunctionLike(expr);
        	                      kind = PARSER_STATE->getKindForFunction(expr);
        	                      args.insert(args.begin(),expr);
        	                    }else{
        	                      PARSER_STATE->parseError("Cannot find unambiguous overloaded function for argument types.");
        	                    }
        	                  }
        	                  if(isBuiltinOperator) {
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                  }
        	                  // may be partially applied function, in this case we should use HO_APPLY
        	                  if( args.size()>=2 && args[0].getType().isFunction() &&
        	                      (args.size()-1)<((FunctionType)args[0].getType()).getArity() ){
        	                    Debug("parser") << "Partial application of " << args[0];
        	                    Debug("parser") << " : #argTypes = " << ((FunctionType)args[0].getType()).getArity();
        	                    Debug("parser") << ", #args = " << args.size()-1 << std::endl;
        	                    // must curry the application
        	                    expr = args[0];
        	                    expr = PARSER_STATE->mkHoApply( expr, args, 1 );
        	                  }else{
        	                    expr = MK_EXPR(kind, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:1990:5: LPAREN_TOK ( indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK )
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3927);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:1991:5: ( indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK )
        	        {
        	            int alt52=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		switch ( LA(2) )
        	            		{
        	            		case INDEX_TOK:
        	            			{
        	            				alt52=1;
        	            			}
        	            		    break;
        	            		case AS_TOK:
        	            			{
        	            				alt52=2;
        	            			}
        	            		    break;

        	            		default:
        	            		    CONSTRUCTEX();
        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	            		    EXCEPTION->message      = (void *)"";
        	            		    EXCEPTION->decisionNum  = 52;
        	            		    EXCEPTION->state        = 1;


        	            		    goto ruletermNonVariableEx;

        	            		}

        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 52;
        	                EXCEPTION->state        = 0;


        	                goto ruletermNonVariableEx;

        	            }

        	            switch (alt52)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:1992:7: indexedFunctionName[op, kind] termList[args,expr] RPAREN_TOK
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_indexedFunctionName_in_termNonVariable3943);
        	        	        indexedFunctionName(ctx, op, kind);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_termNonVariable3946);
        	        	        termList(ctx, args, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3949);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             
        	        	                    if(kind==CVC4::kind::APPLY_SELECTOR) {
        	        	                      //tuple selector case
        	        	                      Integer x = op.getConst<CVC4::Rational>().getNumerator();
        	        	                      if (!x.fitsUnsignedInt()) {
        	        	                        PARSER_STATE->parseError("index of tupSel is larger than size of unsigned int");
        	        	                      }
        	        	                      unsigned int n = x.toUnsignedInt();
        	        	                      if (args.size()>1) {
        	        	                        PARSER_STATE->parseError("tupSel applied to more than one tuple argument");
        	        	                      }
        	        	                      Type t = args[0].getType();
        	        	                      if (!t.isTuple()) {
        	        	                        PARSER_STATE->parseError("tupSel applied to non-tuple");
        	        	                      }
        	        	                      size_t length = ((DatatypeType)t).getTupleLength();
        	        	                      if (n >= length) {
        	        	                        std::stringstream ss;
        	        	                        ss << "tuple is of length " << length << "; cannot access index " << n;
        	        	                        PARSER_STATE->parseError(ss.str());
        	        	                      }
        	        	                      const Datatype & dt = ((DatatypeType)t).getDatatype();
        	        	                      op = dt[0][n].getSelector();
        	        	                    }
        	        	                    if (kind!=kind::NULL_EXPR) {
        	        	                      expr = MK_EXPR( kind, op, args );
        	        	                    } else {
        	        	                      expr = MK_EXPR(op, args);
        	        	                    }
        	        	                    PARSER_STATE->checkOperator(expr.getKind(), args.size());
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2024:7: LPAREN_TOK AS_TOK CONST_TOK sortSymbol[type, CHECK_DECLARED] RPAREN_TOK term[f, f2] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable3967);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(AS_TOK, &FOLLOW_AS_TOK_in_termNonVariable3969);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(CONST_TOK, &FOLLOW_CONST_TOK_in_termNonVariable3971);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_termNonVariable3973);
        	        	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3982);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable3984);
        	        	        term(ctx, f, f2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable3987);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {

        	        	                    if(!type.isArray()) {
        	        	                      std::stringstream ss;
        	        	                      ss << "expected array constant term, but cast is not of array type"
        	        	                         << std::endl
        	        	                         << "cast type: " << type;
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if(!f.isConst()) {
        	        	                      std::stringstream ss;
        	        	                      ss << "expected constant term inside array constant, but found "
        	        	                         << "nonconstant term:" << std::endl
        	        	                         << "the term: " << f;
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if(!ArrayType(type).getConstituentType().isComparableTo(f.getType())) {
        	        	                      std::stringstream ss;
        	        	                      ss << "type mismatch inside array constant term:" << std::endl
        	        	                         << "array type:          " << type << std::endl
        	        	                         << "expected const type: " << ArrayType(type).getConstituentType()
        	        	                         << std::endl
        	        	                         << "computed const type: " << f.getType();
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    expr = MK_CONST( ::CVC4::ArrayStoreAll(type, f) );
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:2054:5: LPAREN_TOK ( LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+ ) RPAREN_TOK term[expr, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4013);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2054:16: ( LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ | SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+ )
        	        {
        	            int alt55=2;
        	            switch ( LA(1) )
        	            {
        	            case LET_TOK:
        	            	{
        	            		alt55=1;
        	            	}
        	                break;
        	            case SYGUS_LET_TOK:
        	            	{
        	            		alt55=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 55;
        	                EXCEPTION->state        = 0;


        	                goto ruletermNonVariableEx;

        	            }

        	            switch (alt55)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2055:7: LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+
        	        	    {
        	        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_termNonVariable4024);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4026);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->pushScope(true); 
        	        	        }


        	        	        // ../../../../src/parser/smt2/Smt2.g:2057:7: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+
        	        	        {
        	        	            int cnt53=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt53=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case LPAREN_TOK:
        	        	        		{
        	        	        			alt53=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt53)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // ../../../../src/parser/smt2/Smt2.g:2057:9: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK
        	        	        	        {
        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4044);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4046);
        	        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4057);
        	        	        	            term(ctx, expr, f2);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4068);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 if(names.count(name) == 1) {
        	        	        	                            std::stringstream ss;
        	        	        	                            ss << "warning: symbol `" << name << "' bound multiple times by let;"
        	        	        	                               << " the last binding will be used, shadowing earlier ones";
        	        	        	                            PARSER_STATE->warning(ss.str());
        	        	        	                          } else {
        	        	        	                            names.insert(name);
        	        	        	                          }
        	        	        	                          binders.push_back(std::make_pair(name, expr)); 
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt53 >= 1 )
        	        	        		{
        	        	        		    goto loop53;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto ruletermNonVariableEx;
        	        	        	}
        	        	        	cnt53++;
        	        	            }
        	        	            loop53: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2071:7: SYGUS_LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+
        	        	    {
        	        	         MATCHT(SYGUS_LET_TOK, &FOLLOW_SYGUS_LET_TOK_in_termNonVariable4109);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4111);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->pushScope(true); 
        	        	        }


        	        	        // ../../../../src/parser/smt2/Smt2.g:2073:7: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK )+
        	        	        {
        	        	            int cnt54=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt54=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case LPAREN_TOK:
        	        	        		{
        	        	        			alt54=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt54)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // ../../../../src/parser/smt2/Smt2.g:2073:9: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[type,CHECK_DECLARED] term[expr, f2] RPAREN_TOK
        	        	        	        {
        	        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4129);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4131);
        	        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_sortSymbol_in_termNonVariable4142);
        	        	        	            sortSymbol(ctx, type, CHECK_DECLARED);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4153);
        	        	        	            term(ctx, expr, f2);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4164);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruletermNonVariableEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 if(names.count(name) == 1) {
        	        	        	                            std::stringstream ss;
        	        	        	                            ss << "warning: symbol `" << name << "' bound multiple times by let;"
        	        	        	                               << " the last binding will be used, shadowing earlier ones";
        	        	        	                            PARSER_STATE->warning(ss.str());
        	        	        	                          } else {
        	        	        	                            names.insert(name);
        	        	        	                          }
        	        	        	                          binders.push_back(std::make_pair(name, expr)); 
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt54 >= 1 )
        	        	        		{
        	        	        		    goto loop54;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto ruletermNonVariableEx;
        	        	        	}
        	        	        	cnt54++;
        	        	            }
        	        	            loop54: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             // now implement these bindings
        	                  for(std::vector< std::pair<std::string, Expr> >::iterator
        	                        i = binders.begin(); i != binders.end(); ++i) {
        	                    PARSER_STATE->defineVar((*i).first, (*i).second);
        	                  }
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4209);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable4215);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4222);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:2099:5: LPAREN_TOK MATCH_TOK term[expr, f2] LPAREN_TOK ( LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+ RPAREN_TOK RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4240);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(MATCH_TOK, &FOLLOW_MATCH_TOK_in_termNonVariable4242);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable4244);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  if( !expr.getType().isDatatype() ){
        	                    PARSER_STATE->parseError("Cannot match on non-datatype term.");
        	                  }
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4253);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2105:5: ( LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK )+
        	        {
        	            int cnt57=0;

        	            for (;;)
        	            {
        	                int alt57=4;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			switch ( LA(2) )
        	        			{
        	        			case INDEX_TOK:
        	        				{
        	        					alt57=1;
        	        				}
        	        			    break;
        	        			case LPAREN_TOK:
        	        				{
        	        					alt57=2;
        	        				}
        	        			    break;
        	        			case CHECK_SYNTH_TOK:
        	        			case CONSTRAINT_TOK:
        	        			case DECLARE_PRIMED_VAR_TOK:
        	        			case DECLARE_VAR_TOK:
        	        			case INV_CONSTRAINT_TOK:
        	        			case QUOTED_SYMBOL:
        	        			case SET_OPTIONS_TOK:
        	        			case SIMPLE_SYMBOL:
        	        			case SYNTH_FUN_TOK:
        	        			case SYNTH_INV_TOK:
        	        			case UNTERMINATED_QUOTED_SYMBOL:
        	        			case 162:
        	        				{
        	        					alt57=3;
        	        				}
        	        			    break;

        	        			}

        	        		}
        	        	    break;

        	        	}

        	        	switch (alt57)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2107:8: LPAREN_TOK INDEX_TOK term[f, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4277);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	             MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_termNonVariable4279);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4281);
        	        	            term(ctx, f, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                          if( match_vindex==-1 ){
        	        	                            match_vindex = (int)patexprs.size(); 
        	        	                          }
        	        	                          patexprs.push_back( f ); 
        	        	                          patconds.push_back(MK_CONST(bool(true)));
        	        	                        
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4294);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	        }
        	        	        break;
        	        	    case 2:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2115:9: LPAREN_TOK LPAREN_TOK term[f, f2] ( symbol[name,CHECK_NONE,SYM_VARIABLE] )* RPAREN_TOK term[f3, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4304);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4306);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4308);
        	        	            term(ctx, f, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                           args.clear(); 
        	        	                           PARSER_STATE->pushScope(true); 
        	        	                           //f should be a constructor
        	        	                           type = f.getType();
        	        	                           Debug("parser-dt") << "Pattern head : " << f << " " << f.getType() << std::endl;
        	        	                           if( !type.isConstructor() ){
        	        	                             PARSER_STATE->parseError("Pattern must be application of a constructor or a variable.");
        	        	                           }
        	        	                           if( Datatype::datatypeOf(f).isParametric() ){
        	        	                             type = Datatype::datatypeOf(f)[Datatype::indexOf(f)].getSpecializedConstructorType(expr.getType());
        	        	                           }
        	        	                           match_ptypes = ((ConstructorType)type).getArgTypes();
        	        	                         
        	        	            }


        	        	            // ../../../../src/parser/smt2/Smt2.g:2130:10: ( symbol[name,CHECK_NONE,SYM_VARIABLE] )*

        	        	            for (;;)
        	        	            {
        	        	                int alt56=2;
        	        	                switch ( LA(1) )
        	        	                {
        	        	                case CHECK_SYNTH_TOK:
        	        	                case CONSTRAINT_TOK:
        	        	                case DECLARE_PRIMED_VAR_TOK:
        	        	                case DECLARE_VAR_TOK:
        	        	                case INV_CONSTRAINT_TOK:
        	        	                case QUOTED_SYMBOL:
        	        	                case SET_OPTIONS_TOK:
        	        	                case SIMPLE_SYMBOL:
        	        	                case SYNTH_FUN_TOK:
        	        	                case SYNTH_INV_TOK:
        	        	                case UNTERMINATED_QUOTED_SYMBOL:
        	        	                case 162:
        	        	                	{
        	        	                		alt56=1;
        	        	                	}
        	        	                    break;

        	        	                }

        	        	                switch (alt56)
        	        	                {
        	        	            	case 1:
        	        	            	    // ../../../../src/parser/smt2/Smt2.g:2130:12: symbol[name,CHECK_NONE,SYM_VARIABLE]
        	        	            	    {
        	        	            	        FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4334);
        	        	            	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            	        FOLLOWPOP();
        	        	            	        if  (HASEXCEPTION())
        	        	            	        {
        	        	            	            goto ruletermNonVariableEx;
        	        	            	        }


        	        	            	        {

        	        	            	                         if( args.size()>=match_ptypes.size() ){
        	        	            	                           PARSER_STATE->parseError("Too many arguments for pattern.");
        	        	            	                         }
        	        	            	                         //make of proper type
        	        	            	                         Expr arg = PARSER_STATE->mkBoundVar(name, match_ptypes[args.size()]);
        	        	            	                         args.push_back( arg );
        	        	            	                       
        	        	            	        }


        	        	            	    }
        	        	            	    break;

        	        	            	default:
        	        	            	    goto loop56;	/* break out of the loop */
        	        	            	    break;
        	        	                }
        	        	            }
        	        	            loop56: ; /* Jump out to here if this rule does not match */


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4360);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4371);
        	        	            term(ctx, f3, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {
        	        	                 
        	        	                           const DatatypeConstructor& dtc = Datatype::datatypeOf(f)[Datatype::indexOf(f)];
        	        	                           if( args.size()!=dtc.getNumArgs() ){
        	        	                             PARSER_STATE->parseError("Bad number of arguments for application of constructor in pattern.");
        	        	                           }
        	        	                           //FIXME: make MATCH a kind and make this a rewrite
        	        	                           // build a lambda
        	        	                           std::vector<Expr> largs;
        	        	                           largs.push_back( MK_EXPR( CVC4::kind::BOUND_VAR_LIST, args ) );
        	        	                           largs.push_back( f3 );
        	        	                           std::vector< Expr > aargs;
        	        	                           aargs.push_back( MK_EXPR( CVC4::kind::LAMBDA, largs ) );
        	        	                           for( unsigned i=0; i<dtc.getNumArgs(); i++ ){
        	        	                             //can apply total version since we will be guarded by ITE condition
        	        	                             // however, we need to apply partial version since we don't have the internal selector available
        	        	                             aargs.push_back( MK_EXPR( CVC4::kind::APPLY_SELECTOR, dtc[i].getSelector(), expr ) );
        	        	                           }
        	        	                           patexprs.push_back( MK_EXPR( CVC4::kind::APPLY, aargs ) );
        	        	                           patconds.push_back( MK_EXPR( CVC4::kind::APPLY_TESTER, dtc.getTester(), expr ) );
        	        	                         
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4385);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {
        	        	                 PARSER_STATE->popScope(); 
        	        	            }


        	        	        }
        	        	        break;
        	        	    case 3:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2162:10: LPAREN_TOK symbol[name,CHECK_DECLARED,SYM_VARIABLE] term[f3, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4408);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4410);
        	        	            symbol(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {

        	        	                           f = PARSER_STATE->getVariable(name);
        	        	                           type = f.getType();
        	        	                           if( !type.isConstructor() || !((ConstructorType)type).getArgTypes().empty() ){
        	        	                             PARSER_STATE->parseError("Must apply constructors of arity greater than 0 to arguments in pattern.");
        	        	                           }
        	        	                         
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_termNonVariable4424);
        	        	            term(ctx, f3, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {

        	        	                           const DatatypeConstructor& dtc = Datatype::datatypeOf(f)[Datatype::indexOf(f)];
        	        	                           patexprs.push_back( f3 );
        	        	                           patconds.push_back( MK_EXPR( CVC4::kind::APPLY_TESTER, dtc.getTester(), expr ) );
        	        	                         
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4438);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt57 >= 1 )
        	        		{
        	        		    goto loop57;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermNonVariableEx;
        	        	}
        	        	cnt57++;
        	            }
        	            loop57: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4451);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4453);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             
        	                  if( match_vindex==-1 ){
        	                    const Datatype& dt = ((DatatypeType)expr.getType()).getDatatype();
        	                    std::map< unsigned, bool > processed;
        	                    unsigned count = 0;
        	                    //ensure that all datatype constructors are matched (to ensure exhaustiveness)
        	                    for( unsigned i=0; i<patconds.size(); i++ ){
        	                      unsigned curr_index = Datatype::indexOf(patconds[i].getOperator());
        	                      if( curr_index<0 && curr_index>=dt.getNumConstructors() ){
        	                        PARSER_STATE->parseError("Pattern is not legal for the head of a match.");
        	                      }
        	                      if( processed.find( curr_index )==processed.end() ){
        	                        processed[curr_index] = true;
        	                        count++;
        	                      }
        	                    }
        	                    if( count!=dt.getNumConstructors() ){
        	                      PARSER_STATE->parseError("Patterns are not exhaustive in a match construct.");
        	                    }
        	                  }
        	                  //now, make the ITE
        	                  int end_index = match_vindex==-1 ? patexprs.size()-1 : match_vindex;
        	                  bool first_time = true;
        	                  for( int index = end_index; index>=0; index-- ){
        	                    if( first_time ){
        	                      expr = patexprs[index];
        	                      first_time = false;
        	                    }else{
        	                      expr = MK_EXPR( CVC4::kind::ITE, patconds[index], patexprs[index], expr );
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:2208:5: symbol[name,CHECK_NONE,SYM_VARIABLE] SYGUS_ENUM_CONS_TOK symbol[name2,CHECK_NONE,SYM_VARIABLE]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4462);
        	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(SYGUS_ENUM_CONS_TOK, &FOLLOW_SYGUS_ENUM_CONS_TOK_in_termNonVariable4465);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_termNonVariable4471);
        	        symbol(ctx, name2, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             std::string cname = name + "__Enum__" + name2;
        	                  Debug("parser-sygus") << "Check for enum const " << cname << std::endl;
        	                  expr = PARSER_STATE->getVariable(cname);
        	                  // expr.getType().isConstructor() &&
        	                  // ConstructorType(expr.getType()).getArity()==0;
        	                  expr = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, expr);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/smt2/Smt2.g:2219:5: LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr, attr] )+ RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4491);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(ATTRIBUTE_TOK, &FOLLOW_ATTRIBUTE_TOK_in_termNonVariable4493);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable4495);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2220:5: ( attribute[expr, attexpr, attr] )+
        	        {
        	            int cnt58=0;

        	            for (;;)
        	            {
        	                int alt58=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case ATTRIBUTE_INST_LEVEL:
        	        	case ATTRIBUTE_NAMED_TOK:
        	        	case ATTRIBUTE_NO_PATTERN_TOK:
        	        	case ATTRIBUTE_PATTERN_TOK:
        	        	case ATTRIBUTE_RR_PRIORITY:
        	        	case KEYWORD:
        	        		{
        	        			alt58=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt58)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2220:7: attribute[expr, attexpr, attr]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_attribute_in_termNonVariable4504);
        	        	            attribute(ctx, expr, attexpr, attr);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermNonVariableEx;
        	        	            }


        	        	            {
        	        	                 if( ! attexpr.isNull()) {
        	        	                          patexprs.push_back( attexpr );
        	        	                        }
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt58 >= 1 )
        	        		{
        	        		    goto loop58;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermNonVariableEx;
        	        	}
        	        	cnt58++;
        	            }
        	            loop58: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4522);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  if(attr == ":rewrite-rule") {
        	                    Expr guard;
        	                    Expr body;
        	                    if(expr[1].getKind() == kind::IMPLIES ||
        	                       expr[1].getKind() == kind::EQUAL) {
        	                      guard = expr[0];
        	                      body = expr[1];
        	                    } else {
        	                      guard = MK_CONST(bool(true));
        	                      body = expr;
        	                    }
        	                    expr2 = guard;
        	                    args.push_back(body[0]);
        	                    args.push_back(body[1]);
        	                    if(!f2.isNull()) {
        	                      args.push_back(f2);
        	                    }

        	                    if( body.getKind()==kind::IMPLIES ){  
        	                      kind = kind::RR_DEDUCTION;
        	                    }else if( body.getKind()==kind::EQUAL ){
        	                      kind = body[0].getType().isBoolean() ? kind::RR_REDUCTION : kind::RR_REWRITE;
        	                    }else{
        	                      PARSER_STATE->parseError("Error parsing rewrite rule.");
        	                    }
        	                    expr = MK_EXPR( kind, args );
        	                  } else if(! patexprs.empty()) {
        	                    if( !f2.isNull() && f2.getKind()==kind::INST_PATTERN_LIST ){
        	                      for( size_t i=0; i<f2.getNumChildren(); i++ ){
        	                        if( f2[i].getKind()==kind::INST_PATTERN ){
        	                          patexprs.push_back( f2[i] );
        	                        }else{
        	                          std::stringstream ss;
        	                          ss << "warning: rewrite rules do not support " << f2[i]
        	                             << " within instantiation pattern list";
        	                          PARSER_STATE->warning(ss.str());
        	                        }
        	                      }
        	                    }
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, patexprs);
        	                  } else {
        	                    expr2 = f2;
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/smt2/Smt2.g:2272:5: LPAREN_TOK HO_LAMBDA_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4540);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(HO_LAMBDA_TOK, &FOLLOW_HO_LAMBDA_TOK_in_termNonVariable4542);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4548);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_termNonVariable4550);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4553);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  PARSER_STATE->pushScope(true);
        	                  for(const std::pair<std::string, CVC4::Type>& svn : sortedVarNames){
        	                    args.push_back(PARSER_STATE->mkBoundVar(svn.first, svn.second));
        	                  }
        	                  Expr bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_termNonVariable4565);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4568);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  args.push_back( f );
        	                  PARSER_STATE->popScope();
        	                  expr = MK_EXPR( CVC4::kind::LAMBDA, args );
        	                
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/smt2/Smt2.g:2290:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL14 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4586);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST( AntlrInput::tokenToInteger(INTEGER_LITERAL14) ); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/smt2/Smt2.g:2293:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL15 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_termNonVariable4599);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             // FIXME: This doesn't work because an SMT rational is not a
        	                  // valid GMP rational string
        	                  expr = MK_CONST( AntlrInput::tokenToRational(DECIMAL_LITERAL15) ); 
        	                  if(expr.getType().isInteger()) {
        	                    // Must cast to Real to ensure correct type is passed to parametric type constructors.
        	                    // We do this cast using division with 1.
        	                    // This has the advantage wrt using TO_REAL since (constant) division is always included in the theory.
        	                    expr = MK_EXPR(kind::DIVISION, expr, MK_CONST(Rational(1)));
        	                  }  
        	                
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/smt2/Smt2.g:2305:5: LPAREN_TOK INDEX_TOK (bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable4612);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_termNonVariable4614);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2306:5: (bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL | FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL )
        	        {
        	            int alt59=6;
        	            switch ( LA(1) )
        	            {
        	            case SIMPLE_SYMBOL:
        	            	{
        	            		alt59=1;
        	            	}
        	                break;
        	            case FP_PINF_TOK:
        	            	{
        	            		alt59=2;
        	            	}
        	                break;
        	            case FP_NINF_TOK:
        	            	{
        	            		alt59=3;
        	            	}
        	                break;
        	            case FP_NAN_TOK:
        	            	{
        	            		alt59=4;
        	            	}
        	                break;
        	            case FP_PZERO_TOK:
        	            	{
        	            		alt59=5;
        	            	}
        	                break;
        	            case FP_NZERO_TOK:
        	            	{
        	            		alt59=6;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 59;
        	                EXCEPTION->state        = 0;


        	                goto ruletermNonVariableEx;

        	            }

        	            switch (alt59)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2306:7: bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL
        	        	    {
        	        	        bvLit = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_termNonVariable4625);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        size = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4629);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             if(AntlrInput::tokenText(bvLit).find("bv") == 0) {
        	        	                       expr = MK_CONST( AntlrInput::tokenToBitvector(bvLit, size) );
        	        	                    } else {
        	        	                       PARSER_STATE->parseError("Unexpected symbol `" +
        	        	                                                AntlrInput::tokenText(bvLit) + "'");
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2314:7: FP_PINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(FP_PINF_TOK, &FOLLOW_FP_PINF_TOK_in_termNonVariable4646);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4650);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4654);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             expr = MK_CONST(FloatingPoint::makeInf(FloatingPointSize(AntlrInput::tokenToUnsigned(eb),
        	        	                                                                             AntlrInput::tokenToUnsigned(sb)),
        	        	                                                           false)); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2318:7: FP_NINF_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(FP_NINF_TOK, &FOLLOW_FP_NINF_TOK_in_termNonVariable4670);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4674);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4678);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             expr = MK_CONST(FloatingPoint::makeInf(FloatingPointSize(AntlrInput::tokenToUnsigned(eb),
        	        	                                                                             AntlrInput::tokenToUnsigned(sb)),
        	        	                                                           true)); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2322:7: FP_NAN_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(FP_NAN_TOK, &FOLLOW_FP_NAN_TOK_in_termNonVariable4694);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4698);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4702);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             expr = MK_CONST(FloatingPoint::makeNaN(FloatingPointSize(AntlrInput::tokenToUnsigned(eb),
        	        	                                                                             AntlrInput::tokenToUnsigned(sb)))); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 5:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2326:7: FP_PZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(FP_PZERO_TOK, &FOLLOW_FP_PZERO_TOK_in_termNonVariable4719);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4723);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4727);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             expr = MK_CONST(FloatingPoint::makeZero(FloatingPointSize(AntlrInput::tokenToUnsigned(eb),
        	        	                                                                            AntlrInput::tokenToUnsigned(sb)),
        	        	                                                          false)); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 6:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2330:7: FP_NZERO_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
        	        	    {
        	        	         MATCHT(FP_NZERO_TOK, &FOLLOW_FP_NZERO_TOK_in_termNonVariable4743);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4747);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_termNonVariable4751);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletermNonVariableEx;
        	        	        }


        	        	        {
        	        	             expr = MK_CONST(FloatingPoint::makeZero(FloatingPointSize(AntlrInput::tokenToUnsigned(eb),
        	        	                                                                            AntlrInput::tokenToUnsigned(sb)),
        	        	                                                          true)); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable4777);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/smt2/Smt2.g:2339:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL16 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_termNonVariable4784);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL16).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL16, 2);
        	                  expr = MK_CONST( BitVector(hexString, 16) ); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/smt2/Smt2.g:2344:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL17 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_termNonVariable4797);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL17).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL17, 2);
        	                  expr = MK_CONST( BitVector(binString, 2) ); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/smt2/Smt2.g:2349:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_termNonVariable4810);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST( ::CVC4::String(s, true) ); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/smt2/Smt2.g:2351:5: FP_RNE_TOK
        	    {
        	         MATCHT(FP_RNE_TOK, &FOLLOW_FP_RNE_TOK_in_termNonVariable4823);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundNearestTiesToEven); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/smt2/Smt2.g:2352:5: FP_RNA_TOK
        	    {
        	         MATCHT(FP_RNA_TOK, &FOLLOW_FP_RNA_TOK_in_termNonVariable4836);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundNearestTiesToAway); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/smt2/Smt2.g:2353:5: FP_RTP_TOK
        	    {
        	         MATCHT(FP_RTP_TOK, &FOLLOW_FP_RTP_TOK_in_termNonVariable4849);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardPositive); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/smt2/Smt2.g:2354:5: FP_RTN_TOK
        	    {
        	         MATCHT(FP_RTN_TOK, &FOLLOW_FP_RTN_TOK_in_termNonVariable4862);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardNegative); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/smt2/Smt2.g:2355:5: FP_RTZ_TOK
        	    {
        	         MATCHT(FP_RTZ_TOK, &FOLLOW_FP_RTZ_TOK_in_termNonVariable4875);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardZero); 
        	        }


        	    }
        	    break;
        	case 22:
        	    // ../../../../src/parser/smt2/Smt2.g:2356:5: FP_RNE_FULL_TOK
        	    {
        	         MATCHT(FP_RNE_FULL_TOK, &FOLLOW_FP_RNE_FULL_TOK_in_termNonVariable4888);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundNearestTiesToEven); 
        	        }


        	    }
        	    break;
        	case 23:
        	    // ../../../../src/parser/smt2/Smt2.g:2357:5: FP_RNA_FULL_TOK
        	    {
        	         MATCHT(FP_RNA_FULL_TOK, &FOLLOW_FP_RNA_FULL_TOK_in_termNonVariable4896);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundNearestTiesToAway); 
        	        }


        	    }
        	    break;
        	case 24:
        	    // ../../../../src/parser/smt2/Smt2.g:2358:5: FP_RTP_FULL_TOK
        	    {
        	         MATCHT(FP_RTP_FULL_TOK, &FOLLOW_FP_RTP_FULL_TOK_in_termNonVariable4904);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardPositive); 
        	        }


        	    }
        	    break;
        	case 25:
        	    // ../../../../src/parser/smt2/Smt2.g:2359:5: FP_RTN_FULL_TOK
        	    {
        	         MATCHT(FP_RTN_FULL_TOK, &FOLLOW_FP_RTN_FULL_TOK_in_termNonVariable4912);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardNegative); 
        	        }


        	    }
        	    break;
        	case 26:
        	    // ../../../../src/parser/smt2/Smt2.g:2360:5: FP_RTZ_FULL_TOK
        	    {
        	         MATCHT(FP_RTZ_FULL_TOK, &FOLLOW_FP_RTZ_FULL_TOK_in_termNonVariable4920);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST(roundTowardZero); 
        	        }


        	    }
        	    break;
        	case 27:
        	    // ../../../../src/parser/smt2/Smt2.g:2362:5: REAL_PI_TOK
        	    {
        	         MATCHT(REAL_PI_TOK, &FOLLOW_REAL_PI_TOK_in_termNonVariable4929);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {

        	                  expr = EXPR_MANAGER->mkNullaryOperator(EXPR_MANAGER->realType(), kind::PI);
        	                
        	        }


        	    }
        	    break;
        	case 28:
        	    // ../../../../src/parser/smt2/Smt2.g:2366:5: RENOSTR_TOK
        	    {
        	         MATCHT(RENOSTR_TOK, &FOLLOW_RENOSTR_TOK_in_termNonVariable4938);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             std::vector< Expr > nvec;
        	                  expr = MK_EXPR( CVC4::kind::REGEXP_EMPTY, nvec );
        	                
        	        }


        	    }
        	    break;
        	case 29:
        	    // ../../../../src/parser/smt2/Smt2.g:2371:5: REALLCHAR_TOK
        	    {
        	         MATCHT(REALLCHAR_TOK, &FOLLOW_REALLCHAR_TOK_in_termNonVariable4951);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             std::vector< Expr > nvec;
        	                  expr = MK_EXPR( CVC4::kind::REGEXP_SIGMA, nvec );
        	                
        	        }


        	    }
        	    break;
        	case 30:
        	    // ../../../../src/parser/smt2/Smt2.g:2376:5: EMPTYSET_TOK
        	    {
        	         MATCHT(EMPTYSET_TOK, &FOLLOW_EMPTYSET_TOK_in_termNonVariable4964);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             expr = MK_CONST( ::CVC4::EmptySet(Type())); 
        	        }


        	    }
        	    break;
        	case 31:
        	    // ../../../../src/parser/smt2/Smt2.g:2379:5: UNIVSET_TOK
        	    {
        	         MATCHT(UNIVSET_TOK, &FOLLOW_UNIVSET_TOK_in_termNonVariable4977);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             //booleanType is placeholder here since we don't have type info without type annotation
        	                  expr = EXPR_MANAGER->mkNullaryOperator(EXPR_MANAGER->booleanType(), kind::UNIVERSE_SET); 
        	        }


        	    }
        	    break;
        	case 32:
        	    // ../../../../src/parser/smt2/Smt2.g:2383:5: NILREF_TOK
        	    {
        	         MATCHT(NILREF_TOK, &FOLLOW_NILREF_TOK_in_termNonVariable4990);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             //booleanType is placeholder here since we don't have type info without type annotation
        	                  expr = EXPR_MANAGER->mkNullaryOperator(EXPR_MANAGER->booleanType(), kind::SEP_NIL); 
        	        }


        	    }
        	    break;
        	case 33:
        	    // ../../../../src/parser/smt2/Smt2.g:2388:5: LPAREN_TOK TUPLE_CONST_TOK termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_termNonVariable5008);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(TUPLE_CONST_TOK, &FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5010);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_termNonVariable5012);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_termNonVariable5015);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             std::vector<Type> types;
        	                  for(std::vector<Expr>::const_iterator i = args.begin(); i != args.end(); ++i) {
        	                    types.push_back((*i).getType());
        	                  }
        	                  DatatypeType t = EXPR_MANAGER->mkTupleType(types);
        	                  const Datatype& dt = t.getDatatype();
        	                  args.insert(args.begin(), dt[0].getConstructor());
        	                  expr = MK_EXPR(kind::APPLY_CONSTRUCTOR, args);
        	                
        	        }


        	    }
        	    break;
        	case 34:
        	    // ../../../../src/parser/smt2/Smt2.g:2399:5: TUPLE_CONST_TOK
        	    {
        	         MATCHT(TUPLE_CONST_TOK, &FOLLOW_TUPLE_CONST_TOK_in_termNonVariable5030);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermNonVariableEx;
        	        }


        	        {
        	             std::vector<Type> types;
        	                  DatatypeType t = EXPR_MANAGER->mkTupleType(types);
        	                  const Datatype& dt = t.getDatatype();
        	                  args.insert(args.begin(), dt[0].getConstructor());
        	                  expr = MK_EXPR(kind::APPLY_CONSTRUCTOR, args);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletermNonVariableEx; /* Prevent compiler warnings */
    ruletermNonVariableEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end termNonVariable */

/**
 * $ANTLR start attribute
 * ../../../../src/parser/smt2/Smt2.g:2411:1: attribute[CVC4::Expr& expr, CVC4::Expr& retExpr, std::string& attr] : ( KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )? | ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2] |tok= ( ATTRIBUTE_INST_LEVEL | ATTRIBUTE_RR_PRIORITY ) INTEGER_LITERAL | ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr] );
 */
static void
attribute(pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& retExpr, std::string& attr)
{
    pANTLR3_COMMON_TOKEN    tok;
    pANTLR3_COMMON_TOKEN    KEYWORD18;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL19;

    /* Initialize rule variables
     */


      SExpr sexpr;
      Expr patexpr;
      std::vector<Expr> patexprs;
      Expr e2;
      bool hasValue = false;

    tok       = NULL;
    KEYWORD18       = NULL;
    INTEGER_LITERAL19       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2419:3: ( KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )? | ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2] |tok= ( ATTRIBUTE_INST_LEVEL | ATTRIBUTE_RR_PRIORITY ) INTEGER_LITERAL | ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr] )

            ANTLR3_UINT32 alt63;

            alt63=5;

            switch ( LA(1) )
            {
            case KEYWORD:
            	{
            		alt63=1;
            	}
                break;
            case ATTRIBUTE_PATTERN_TOK:
            	{
            		alt63=2;
            	}
                break;
            case ATTRIBUTE_NO_PATTERN_TOK:
            	{
            		alt63=3;
            	}
                break;
            case ATTRIBUTE_INST_LEVEL:
            case ATTRIBUTE_RR_PRIORITY:
            	{
            		alt63=4;
            	}
                break;
            case ATTRIBUTE_NAMED_TOK:
            	{
            		alt63=5;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 63;
                EXCEPTION->state        = 0;


                goto ruleattributeEx;

            }

            switch (alt63)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2419:5: KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )?
        	    {
        	        KEYWORD18 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_attribute5057);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2419:13: ( simpleSymbolicExprNoKeyword[sexpr] )?
        	        {
        	            int alt61=2;
        	            switch ( LA(1) )
        	            {
        	                case AND_TOK:
        	                case ASSERT_TOK:
        	                case BINARY_LITERAL:
        	                case BV2NAT_TOK:
        	                case CHECK_SAT_ASSUMING_TOK:
        	                case CHECK_SAT_TOK:
        	                case CHECK_SYNTH_TOK:
        	                case CONSTRAINT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_DATATYPES_TOK:
        	                case DECLARE_FUN_TOK:
        	                case DECLARE_PRIMED_VAR_TOK:
        	                case DECLARE_SORT_TOK:
        	                case DECLARE_VAR_TOK:
        	                case DEFINE_FUNS_REC_TOK:
        	                case DEFINE_FUN_REC_TOK:
        	                case DEFINE_FUN_TOK:
        	                case DEFINE_SORT_TOK:
        	                case DISTINCT_TOK:
        	                case DIV_TOK:
        	                case DTSIZE_TOK:
        	                case ECHO_TOK:
        	                case EQUAL_TOK:
        	                case EXIT_TOK:
        	                case FMFCARDVAL_TOK:
        	                case FMFCARD_TOK:
        	                case GET_ASSERTIONS_TOK:
        	                case GET_ASSIGNMENT_TOK:
        	                case GET_INFO_TOK:
        	                case GET_MODEL_TOK:
        	                case GET_OPTION_TOK:
        	                case GET_PROOF_TOK:
        	                case GET_UNSAT_ASSUMPTIONS_TOK:
        	                case GET_UNSAT_CORE_TOK:
        	                case GET_VALUE_TOK:
        	                case GREATER_THAN_EQUAL_TOK:
        	                case GREATER_THAN_TOK:
        	                case HEX_LITERAL:
        	                case IMPLIES_TOK:
        	                case INST_CLOSURE_TOK:
        	                case INTEGER_LITERAL:
        	                case INV_CONSTRAINT_TOK:
        	                case ITE_TOK:
        	                case LESS_THAN_EQUAL_TOK:
        	                case LESS_THAN_TOK:
        	                case MINUS_TOK:
        	                case NOT_TOK:
        	                case OR_TOK:
        	                case PLUS_TOK:
        	                case POP_TOK:
        	                case PROPAGATION_RULE_TOK:
        	                case PUSH_TOK:
        	                case QUOTED_SYMBOL:
        	                case REDUCTION_RULE_TOK:
        	                case RESET_ASSERTIONS_TOK:
        	                case RESET_TOK:
        	                case REWRITE_RULE_TOK:
        	                case SET_INFO_TOK:
        	                case SET_LOGIC_TOK:
        	                case SET_OPTIONS_TOK:
        	                case SET_OPTION_TOK:
        	                case SIMPLE_SYMBOL:
        	                case SIMPLIFY_TOK:
        	                case STAR_TOK:
        	                case STRING_LITERAL_2_0:
        	                case STRING_LITERAL_2_5:
        	                case SYNTH_FUN_TOK:
        	                case SYNTH_INV_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case XOR_TOK:
        	                case 162:
        	                	{
        	                		alt61=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt61)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2419:15: simpleSymbolicExprNoKeyword[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExprNoKeyword_in_attribute5061);
        	        	        simpleSymbolicExprNoKeyword(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleattributeEx;
        	        	        }


        	        	        {
        	        	             hasValue = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                attr = AntlrInput::tokenText(KEYWORD18);
        	                // EXPR_MANAGER->setNamedAttribute( expr, attr );
        	                if(attr == ":rewrite-rule") {
        	                  if(hasValue) {
        	                    std::stringstream ss;
        	                    ss << "warning: Attribute " << attr
        	                       << " does not take a value (ignoring)";
        	                    PARSER_STATE->warning(ss.str());
        	                  }
        	                  // do nothing
        	                } else if(attr==":axiom" || attr==":conjecture" || attr==":fun-def" ||
        	                          attr==":sygus" || attr==":synthesis") {
        	                  if(hasValue) {
        	                    std::stringstream ss;
        	                    ss << "warning: Attribute " << attr
        	                       << " does not take a value (ignoring)";
        	                    PARSER_STATE->warning(ss.str());
        	                  }
        	                  Expr avar;
        	                  bool success = true;
        	                  std::string attr_name = attr;
        	                  attr_name.erase( attr_name.begin() );
        	                  if( attr==":fun-def" ){
        	                    if( expr.getKind()!=kind::EQUAL || expr[0].getKind()!=kind::APPLY_UF ){
        	                      success = false;
        	                    }else{
        	                      FunctionType t = (FunctionType)expr[0].getOperator().getType();
        	                      for( unsigned i=0; i<expr[0].getNumChildren(); i++ ){
        	                        if( expr[0][i].getKind() != kind::BOUND_VARIABLE ||
        	                            expr[0][i].getType() != t.getArgTypes()[i] ){
        	                          success = false;
        	                          break;
        	                        }else{
        	                          for( unsigned j=0; j<i; j++ ){
        	                            if( expr[0][j]==expr[0][i] ){
        	                              success = false;
        	                              break;
        	                            }
        	                          }
        	                        }
        	                      }
        	                    }
        	                    if( !success ){
        	                      std::stringstream ss;
        	                      ss << "warning: Function definition should be an equality whose LHS "
        	                         << "is an uninterpreted function applied to unique variables.";
        	                      PARSER_STATE->warning(ss.str());
        	                    }else{
        	                      avar = expr[0];
        	                    }
        	                  }else{
        	                    Type t = EXPR_MANAGER->booleanType();
        	                    avar = PARSER_STATE->mkVar(attr_name, t);
        	                  }
        	                  if( success ){
        	                    //Will set the attribute on auxiliary var (preserves attribute on
        	                    //formula through rewriting).
        	                    retExpr = MK_EXPR(kind::INST_ATTRIBUTE, avar);
        	                    Command* c = new SetUserAttributeCommand( attr_name, avar );
        	                    c->setMuted(true);
        	                    PARSER_STATE->preemptCommand(c);
        	                  }
        	                } else {
        	                  PARSER_STATE->attributeNotSupported(attr);
        	                }
        	              
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2487:5: ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK
        	    {
        	         MATCHT(ATTRIBUTE_PATTERN_TOK, &FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute5077);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_attribute5079);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2488:5: ( term[patexpr, e2] )+
        	        {
        	            int cnt62=0;

        	            for (;;)
        	            {
        	                int alt62=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case BINARY_LITERAL:
        	        	case CHECK_SYNTH_TOK:
        	        	case CONSTRAINT_TOK:
        	        	case DECIMAL_LITERAL:
        	        	case DECLARE_PRIMED_VAR_TOK:
        	        	case DECLARE_VAR_TOK:
        	        	case EMPTYSET_TOK:
        	        	case FP_RNA_FULL_TOK:
        	        	case FP_RNA_TOK:
        	        	case FP_RNE_FULL_TOK:
        	        	case FP_RNE_TOK:
        	        	case FP_RTN_FULL_TOK:
        	        	case FP_RTN_TOK:
        	        	case FP_RTP_FULL_TOK:
        	        	case FP_RTP_TOK:
        	        	case FP_RTZ_FULL_TOK:
        	        	case FP_RTZ_TOK:
        	        	case HEX_LITERAL:
        	        	case INTEGER_LITERAL:
        	        	case INV_CONSTRAINT_TOK:
        	        	case LPAREN_TOK:
        	        	case NILREF_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case REALLCHAR_TOK:
        	        	case REAL_PI_TOK:
        	        	case RENOSTR_TOK:
        	        	case SET_OPTIONS_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case STRING_LITERAL_2_0:
        	        	case STRING_LITERAL_2_5:
        	        	case SYNTH_FUN_TOK:
        	        	case SYNTH_INV_TOK:
        	        	case TUPLE_CONST_TOK:
        	        	case UNIVSET_TOK:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 162:
        	        		{
        	        			alt62=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt62)
        	        	{
        	        	    case 1:
        	        	        // ../../../../src/parser/smt2/Smt2.g:2488:7: term[patexpr, e2]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_term_in_attribute5087);
        	        	            term(ctx, patexpr, e2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleattributeEx;
        	        	            }


        	        	            {
        	        	                 patexprs.push_back( patexpr ); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt62 >= 1 )
        	        		{
        	        		    goto loop62;
        	        		}
        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleattributeEx;
        	        	}
        	        	cnt62++;
        	            }
        	            loop62: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_attribute5105);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":pattern");
        	                  retExpr = MK_EXPR(kind::INST_PATTERN, patexprs);
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:2495:5: ATTRIBUTE_NO_PATTERN_TOK term[patexpr, e2]
        	    {
        	         MATCHT(ATTRIBUTE_NO_PATTERN_TOK, &FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute5117);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_attribute5119);
        	        term(ctx, patexpr, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":no-pattern");
        	                  retExpr = MK_EXPR(kind::INST_NO_PATTERN, patexpr);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:2500:5: tok= ( ATTRIBUTE_INST_LEVEL | ATTRIBUTE_RR_PRIORITY ) INTEGER_LITERAL
        	    {
        	        tok=(pANTLR3_COMMON_TOKEN)LT(1);

        	        if ( LA(1) == ATTRIBUTE_INST_LEVEL || LA(1) == ATTRIBUTE_RR_PRIORITY )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        }
        	        else
        	        {
        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto ruleattributeEx;
        	        }


        	        INTEGER_LITERAL19 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_attribute5144);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  Expr n = MK_CONST( AntlrInput::tokenToInteger(INTEGER_LITERAL19) );
        	                  std::vector<Expr> values;
        	                  values.push_back( n );
        	                  std::string attr_name(AntlrInput::tokenText(tok));
        	                  attr_name.erase( attr_name.begin() );
        	                  Type t = EXPR_MANAGER->booleanType();
        	                  Expr avar = PARSER_STATE->mkVar(attr_name, t);
        	                  retExpr = MK_EXPR(kind::INST_ATTRIBUTE, avar);
        	                  Command* c = new SetUserAttributeCommand( attr_name, avar, values );
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:2514:5: ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr]
        	    {
        	         MATCHT(ATTRIBUTE_NAMED_TOK, &FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute5156);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_attribute5158);
        	        symbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }


        	        {

        	                  attr = std::string(":named");
        	                  if(!sexpr.isKeyword()) {
        	                    PARSER_STATE->parseError("improperly formed :named annotation");
        	                  }
        	                  std::string name = sexpr.getValue();
        	                  PARSER_STATE->checkUserSymbol(name);
        	                  // ensure expr is a closed subterm
        	                  std::set<Expr> freeVars;
        	                  if(!isClosed(expr, freeVars)) {
        	                    assert(!freeVars.empty());
        	                    std::stringstream ss;
        	                    ss << ":named annotations can only name terms that are closed; this "
        	                       << "one contains free variables:";
        	                    for(std::set<Expr>::const_iterator i = freeVars.begin();
        	                        i != freeVars.end(); ++i) {
        	                      ss << " " << *i;
        	                    }
        	                    PARSER_STATE->parseError(ss.str());
        	                  }
        	                  // check that sexpr is a fresh function symbol, and reserve it
        	                  PARSER_STATE->reserveSymbolAtAssertionLevel(name);
        	                  // define it
        	                  Expr func = PARSER_STATE->mkFunction(name, expr.getType());
        	                  // remember the last term to have been given a :named attribute
        	                  PARSER_STATE->setLastNamedTerm(expr, name);
        	                  // bind name to expr with define-fun
        	                  Command* c =
        	                    new DefineNamedFunctionCommand(name, func, std::vector<Expr>(), expr);
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleattributeEx; /* Prevent compiler warnings */
    ruleattributeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end attribute */

/**
 * $ANTLR start indexedFunctionName
 * ../../../../src/parser/smt2/Smt2.g:2552:1: indexedFunctionName[CVC4::Expr& op, CVC4::Kind& kind] : LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_UBV_TOK m= INTEGER_LITERAL | FP_TO_SBV_TOK m= INTEGER_LITERAL | TESTER_TOK term[expr, expr2] | TUPLE_SEL_TOK m= INTEGER_LITERAL | badIndexedFunctionName ) RPAREN_TOK ;
 */
static void
indexedFunctionName(pSmt2Parser ctx, CVC4::Expr& op, CVC4::Kind& kind)
{
    pANTLR3_COMMON_TOKEN    n1;
    pANTLR3_COMMON_TOKEN    n2;
    pANTLR3_COMMON_TOKEN    n;
    pANTLR3_COMMON_TOKEN    eb;
    pANTLR3_COMMON_TOKEN    sb;
    pANTLR3_COMMON_TOKEN    m;

    /* Initialize rule variables
     */


      Expr expr;
      Expr expr2;

    n1       = NULL;
    n2       = NULL;
    n       = NULL;
    eb       = NULL;
    sb       = NULL;
    m       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:2557:3: ( LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_UBV_TOK m= INTEGER_LITERAL | FP_TO_SBV_TOK m= INTEGER_LITERAL | TESTER_TOK term[expr, expr2] | TUPLE_SEL_TOK m= INTEGER_LITERAL | badIndexedFunctionName ) RPAREN_TOK )
        // ../../../../src/parser/smt2/Smt2.g:2557:5: LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_UBV_TOK m= INTEGER_LITERAL | FP_TO_SBV_TOK m= INTEGER_LITERAL | TESTER_TOK term[expr, expr2] | TUPLE_SEL_TOK m= INTEGER_LITERAL | badIndexedFunctionName ) RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_indexedFunctionName5186);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }


             MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_indexedFunctionName5188);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }


            // ../../../../src/parser/smt2/Smt2.g:2558:5: ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL | FP_TO_UBV_TOK m= INTEGER_LITERAL | FP_TO_SBV_TOK m= INTEGER_LITERAL | TESTER_TOK term[expr, expr2] | TUPLE_SEL_TOK m= INTEGER_LITERAL | badIndexedFunctionName )
            {
                int alt64=19;
                switch ( LA(1) )
                {
                case 161:
                	{
                		alt64=1;
                	}
                    break;
                case 162:
                	{
                		alt64=2;
                	}
                    break;
                case 166:
                	{
                		alt64=3;
                	}
                    break;
                case 165:
                	{
                		alt64=4;
                	}
                    break;
                case 163:
                	{
                		alt64=5;
                	}
                    break;
                case 164:
                	{
                		alt64=6;
                	}
                    break;
                case DIVISIBLE_TOK:
                	{
                		alt64=7;
                	}
                    break;
                case INT2BV_TOK:
                	{
                		alt64=8;
                	}
                    break;
                case FP_TO_FP_TOK:
                	{
                		alt64=9;
                	}
                    break;
                case FP_TO_FPBV_TOK:
                	{
                		alt64=10;
                	}
                    break;
                case FP_TO_FPFP_TOK:
                	{
                		alt64=11;
                	}
                    break;
                case FP_TO_FPR_TOK:
                	{
                		alt64=12;
                	}
                    break;
                case FP_TO_FPS_TOK:
                	{
                		alt64=13;
                	}
                    break;
                case FP_TO_FPU_TOK:
                	{
                		alt64=14;
                	}
                    break;
                case FP_TO_UBV_TOK:
                	{
                		alt64=15;
                	}
                    break;
                case FP_TO_SBV_TOK:
                	{
                		alt64=16;
                	}
                    break;
                case TESTER_TOK:
                	{
                		alt64=17;
                	}
                    break;
                case TUPLE_SEL_TOK:
                	{
                		alt64=18;
                	}
                    break;
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                	{
                		alt64=19;
                	}
                    break;

                default:
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 64;
                    EXCEPTION->state        = 0;


                    goto ruleindexedFunctionNameEx;

                }

                switch (alt64)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2558:7: 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL
            	    {
            	         MATCHT(161, &FOLLOW_161_in_indexedFunctionName5196);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n1 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5200);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n2 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5204);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorExtract(AntlrInput::tokenToUnsigned(n1),
            	                                                   AntlrInput::tokenToUnsigned(n2))); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // ../../../../src/parser/smt2/Smt2.g:2561:7: 'repeat' n= INTEGER_LITERAL
            	    {
            	         MATCHT(162, &FOLLOW_162_in_indexedFunctionName5220);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5224);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorRepeat(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 3:
            	    // ../../../../src/parser/smt2/Smt2.g:2563:7: 'zero_extend' n= INTEGER_LITERAL
            	    {
            	         MATCHT(166, &FOLLOW_166_in_indexedFunctionName5240);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5244);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorZeroExtend(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 4:
            	    // ../../../../src/parser/smt2/Smt2.g:2565:7: 'sign_extend' n= INTEGER_LITERAL
            	    {
            	         MATCHT(165, &FOLLOW_165_in_indexedFunctionName5260);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5264);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorSignExtend(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 5:
            	    // ../../../../src/parser/smt2/Smt2.g:2567:7: 'rotate_left' n= INTEGER_LITERAL
            	    {
            	         MATCHT(163, &FOLLOW_163_in_indexedFunctionName5280);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5284);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorRotateLeft(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 6:
            	    // ../../../../src/parser/smt2/Smt2.g:2569:7: 'rotate_right' n= INTEGER_LITERAL
            	    {
            	         MATCHT(164, &FOLLOW_164_in_indexedFunctionName5300);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5304);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(BitVectorRotateRight(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 7:
            	    // ../../../../src/parser/smt2/Smt2.g:2571:7: DIVISIBLE_TOK n= INTEGER_LITERAL
            	    {
            	         MATCHT(DIVISIBLE_TOK, &FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName5320);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5324);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(Divisible(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 8:
            	    // ../../../../src/parser/smt2/Smt2.g:2573:7: INT2BV_TOK n= INTEGER_LITERAL
            	    {
            	         MATCHT(INT2BV_TOK, &FOLLOW_INT2BV_TOK_in_indexedFunctionName5340);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5344);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(IntToBitVector(AntlrInput::tokenToUnsigned(n)));
            	                    if(PARSER_STATE->strictModeEnabled()) {
            	                      PARSER_STATE->parseError(
            	                          "bv2nat and int2bv are not part of SMT-LIB, and aren't available "
            	                          "in SMT-LIB strict compliance mode");
            	                    } 
            	        }


            	    }
            	    break;
            	case 9:
            	    // ../../../../src/parser/smt2/Smt2.g:2580:7: FP_TO_FP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FP_TOK, &FOLLOW_FP_TO_FP_TOK_in_indexedFunctionName5360);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5364);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5368);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPGeneric(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 10:
            	    // ../../../../src/parser/smt2/Smt2.g:2585:7: FP_TO_FPBV_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPBV_TOK, &FOLLOW_FP_TO_FPBV_TOK_in_indexedFunctionName5384);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5388);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5392);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPIEEEBitVector(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 11:
            	    // ../../../../src/parser/smt2/Smt2.g:2590:7: FP_TO_FPFP_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPFP_TOK, &FOLLOW_FP_TO_FPFP_TOK_in_indexedFunctionName5408);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5412);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5416);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPFloatingPoint(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 12:
            	    // ../../../../src/parser/smt2/Smt2.g:2595:7: FP_TO_FPR_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPR_TOK, &FOLLOW_FP_TO_FPR_TOK_in_indexedFunctionName5432);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5436);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5440);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPReal(AntlrInput::tokenToUnsigned(eb),
            	                                                        AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 13:
            	    // ../../../../src/parser/smt2/Smt2.g:2599:7: FP_TO_FPS_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPS_TOK, &FOLLOW_FP_TO_FPS_TOK_in_indexedFunctionName5456);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5460);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5464);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPSignedBitVector(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 14:
            	    // ../../../../src/parser/smt2/Smt2.g:2604:7: FP_TO_FPU_TOK eb= INTEGER_LITERAL sb= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_FPU_TOK, &FOLLOW_FP_TO_FPU_TOK_in_indexedFunctionName5480);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        eb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5484);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        sb = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5488);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToFPUnsignedBitVector(
            	                            AntlrInput::tokenToUnsigned(eb),
            	                            AntlrInput::tokenToUnsigned(sb)));
            	                  
            	        }


            	    }
            	    break;
            	case 15:
            	    // ../../../../src/parser/smt2/Smt2.g:2609:7: FP_TO_UBV_TOK m= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_UBV_TOK, &FOLLOW_FP_TO_UBV_TOK_in_indexedFunctionName5504);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        m = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5508);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToUBV(AntlrInput::tokenToUnsigned(m))); 
            	        }


            	    }
            	    break;
            	case 16:
            	    // ../../../../src/parser/smt2/Smt2.g:2611:7: FP_TO_SBV_TOK m= INTEGER_LITERAL
            	    {
            	         MATCHT(FP_TO_SBV_TOK, &FOLLOW_FP_TO_SBV_TOK_in_indexedFunctionName5524);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        m = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5528);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             op = MK_CONST(FloatingPointToSBV(AntlrInput::tokenToUnsigned(m))); 
            	        }


            	    }
            	    break;
            	case 17:
            	    // ../../../../src/parser/smt2/Smt2.g:2613:7: TESTER_TOK term[expr, expr2]
            	    {
            	         MATCHT(TESTER_TOK, &FOLLOW_TESTER_TOK_in_indexedFunctionName5544);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_indexedFunctionName5546);
            	        term(ctx, expr, expr2);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {
            	             
            	                    if( expr.getKind()==kind::APPLY_CONSTRUCTOR && expr.getNumChildren()==0 ){
            	                      //for nullary constructors, must get the operator
            	                      expr = expr.getOperator();
            	                    }
            	                    if( !expr.getType().isConstructor() ){
            	                      PARSER_STATE->parseError("Bad syntax for test (_ is X), X must be a constructor.");
            	                    }
            	                    op = Datatype::datatypeOf(expr)[Datatype::indexOf(expr)].getTester();
            	                    kind = CVC4::kind::APPLY_TESTER;
            	                  
            	        }


            	    }
            	    break;
            	case 18:
            	    // ../../../../src/parser/smt2/Smt2.g:2624:7: TUPLE_SEL_TOK m= INTEGER_LITERAL
            	    {
            	         MATCHT(TUPLE_SEL_TOK, &FOLLOW_TUPLE_SEL_TOK_in_indexedFunctionName5557);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        m = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName5561);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	        {

            	                    kind = CVC4::kind::APPLY_SELECTOR;
            	                    //put m in op so that the caller (termNonVariable) can deal with this case
            	                    op = MK_CONST(Rational(AntlrInput::tokenToUnsigned(m)));
            	                  
            	        }


            	    }
            	    break;
            	case 19:
            	    // ../../../../src/parser/smt2/Smt2.g:2629:7: badIndexedFunctionName
            	    {
            	        FOLLOWPUSH(FOLLOW_badIndexedFunctionName_in_indexedFunctionName5572);
            	        badIndexedFunctionName(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }


            	    }
            	    break;

                }
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_indexedFunctionName5584);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleindexedFunctionNameEx; /* Prevent compiler warnings */
    ruleindexedFunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end indexedFunctionName */

/**
 * $ANTLR start badIndexedFunctionName
 * ../../../../src/parser/smt2/Smt2.g:2638:1: badIndexedFunctionName : id= ( SIMPLE_SYMBOL | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ) ;
 */
static void
badIndexedFunctionName(pSmt2Parser ctx)
{

      std::string name;

    pANTLR3_COMMON_TOKEN    id;

    /* Initialize rule variables
     */

    id       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:2642:3: (id= ( SIMPLE_SYMBOL | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ) )
        // ../../../../src/parser/smt2/Smt2.g:2642:5: id= ( SIMPLE_SYMBOL | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL )
        {
            id=(pANTLR3_COMMON_TOKEN)LT(1);

            if ( LA(1) == QUOTED_SYMBOL || LA(1) == SIMPLE_SYMBOL || LA(1) == UNTERMINATED_QUOTED_SYMBOL )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
            }
            else
            {
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebadIndexedFunctionNameEx;
            }


            {
                 PARSER_STATE->parseError(std::string("Unknown indexed function `") +
                          AntlrInput::tokenText(id) + "'");
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebadIndexedFunctionNameEx; /* Prevent compiler warnings */
    rulebadIndexedFunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end badIndexedFunctionName */

/**
 * $ANTLR start termList
 * ../../../../src/parser/smt2/Smt2.g:2656:1: termList[std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr] : ( term[expr, expr2] )+ ;
 */
static void
termList(pSmt2Parser ctx, std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr)
{

      Expr expr2;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2660:3: ( ( term[expr, expr2] )+ )
        // ../../../../src/parser/smt2/Smt2.g:2660:5: ( term[expr, expr2] )+
        {
            // ../../../../src/parser/smt2/Smt2.g:2660:5: ( term[expr, expr2] )+
            {
                int cnt65=0;

                for (;;)
                {
                    int alt65=2;
            	switch ( LA(1) )
            	{
            	case BINARY_LITERAL:
            	case CHECK_SYNTH_TOK:
            	case CONSTRAINT_TOK:
            	case DECIMAL_LITERAL:
            	case DECLARE_PRIMED_VAR_TOK:
            	case DECLARE_VAR_TOK:
            	case EMPTYSET_TOK:
            	case FP_RNA_FULL_TOK:
            	case FP_RNA_TOK:
            	case FP_RNE_FULL_TOK:
            	case FP_RNE_TOK:
            	case FP_RTN_FULL_TOK:
            	case FP_RTN_TOK:
            	case FP_RTP_FULL_TOK:
            	case FP_RTP_TOK:
            	case FP_RTZ_FULL_TOK:
            	case FP_RTZ_TOK:
            	case HEX_LITERAL:
            	case INTEGER_LITERAL:
            	case INV_CONSTRAINT_TOK:
            	case LPAREN_TOK:
            	case NILREF_TOK:
            	case QUOTED_SYMBOL:
            	case REALLCHAR_TOK:
            	case REAL_PI_TOK:
            	case RENOSTR_TOK:
            	case SET_OPTIONS_TOK:
            	case SIMPLE_SYMBOL:
            	case STRING_LITERAL_2_0:
            	case STRING_LITERAL_2_5:
            	case SYNTH_FUN_TOK:
            	case SYNTH_INV_TOK:
            	case TUPLE_CONST_TOK:
            	case UNIVSET_TOK:
            	case UNTERMINATED_QUOTED_SYMBOL:
            	case 162:
            		{
            			alt65=1;
            		}
            	    break;

            	}

            	switch (alt65)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:2660:7: term[expr, expr2]
            	        {
            	            FOLLOWPUSH(FOLLOW_term_in_termList5647);
            	            term(ctx, expr, expr2);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruletermListEx;
            	            }


            	            {
            	                 formulas.push_back(expr); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt65 >= 1 )
            		{
            		    goto loop65;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruletermListEx;
            	}
            	cnt65++;
                }
                loop65: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletermListEx; /* Prevent compiler warnings */
    ruletermListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end termList */

/**
 * $ANTLR start str
 * ../../../../src/parser/smt2/Smt2.g:2666:1: str[std::string& s, bool fsmtlib] : ( STRING_LITERAL_2_0 | STRING_LITERAL_2_5 );
 */
static void
str(pSmt2Parser ctx, std::string& s, bool fsmtlib)
{
    pANTLR3_COMMON_TOKEN    STRING_LITERAL_2_020;
    pANTLR3_COMMON_TOKEN    STRING_LITERAL_2_521;

    /* Initialize rule variables
     */

    STRING_LITERAL_2_020       = NULL;
    STRING_LITERAL_2_521       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2667:3: ( STRING_LITERAL_2_0 | STRING_LITERAL_2_5 )

            ANTLR3_UINT32 alt66;

            alt66=2;

            switch ( LA(1) )
            {
            case STRING_LITERAL_2_0:
            	{
            		alt66=1;
            	}
                break;
            case STRING_LITERAL_2_5:
            	{
            		alt66=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 66;
                EXCEPTION->state        = 0;


                goto rulestrEx;

            }

            switch (alt66)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2667:5: STRING_LITERAL_2_0
        	    {
        	        STRING_LITERAL_2_020 = (pANTLR3_COMMON_TOKEN) MATCHT(STRING_LITERAL_2_0, &FOLLOW_STRING_LITERAL_2_0_in_str5669);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestrEx;
        	        }


        	        {
        	             s = AntlrInput::tokenText(STRING_LITERAL_2_020);
        	                  /* strip off the quotes */
        	                  s = s.substr(1, s.size() - 2);
        	                  for(size_t i=0; i<s.size(); i++) {
        	                    if((unsigned)s[i] > 127 && !isprint(s[i])) {
        	                      PARSER_STATE->parseError("Extended/unprintable characters are not "
        	                                               "part of SMT-LIB, and they must be encoded "
        	                                               "as escape sequences");
        	                    }
        	                  }
        	                  if(fsmtlib) {
        	                    /* handle SMT-LIB standard escapes '\\' and '\"' */
        	                    char* p_orig = strdup(s.c_str());
        	                    char *p = p_orig, *q = p_orig;
        	                    while(*q != '\0') {
        	                      if(*q == '\\') {
        	                        ++q;
        	                        if(*q == '\\' || *q == '"') {
        	                          *p++ = *q++;
        	                        } else {
        	                          assert(*q != '\0');
        	                          *p++ = '\\';
        	                          *p++ = *q++;
        	                        }
        	                      } else {
        	                        *p++ = *q++;
        	                      }
        	                    }
        	                    *p = '\0';
        	                    s = p_orig;
        	                    free(p_orig);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2701:5: STRING_LITERAL_2_5
        	    {
        	        STRING_LITERAL_2_521 = (pANTLR3_COMMON_TOKEN) MATCHT(STRING_LITERAL_2_5, &FOLLOW_STRING_LITERAL_2_5_in_str5681);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestrEx;
        	        }


        	        {
        	             s = AntlrInput::tokenText(STRING_LITERAL_2_521);
        	                  /* strip off the quotes */
        	                  s = s.substr(1, s.size() - 2);
        	                  for(size_t i=0; i<s.size(); i++) {
        	                    if((unsigned)s[i] > 127 && !isprint(s[i])) {
        	                      PARSER_STATE->parseError("Extended/unprintable characters are not "
        	                                               "part of SMT-LIB, and they must be encoded "
        	                                               "as escape sequences");
        	                    }
        	                  }
        	                  // In the 2.5 version, always handle escapes (regardless of fsmtlib flag).
        	                  char* p_orig = strdup(s.c_str());
        	                  char *p = p_orig, *q = p_orig;
        	                  while(*q != '\0') {
        	                    if(*q == '"') {
        	                      ++q;
        	                      assert(*q == '"');
        	                    }
        	                    *p++ = *q++;
        	                  }
        	                  *p = '\0';
        	                  s = p_orig;
        	                  free(p_orig);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulestrEx; /* Prevent compiler warnings */
    rulestrEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end str */

/**
 * $ANTLR start builtinOp
 * ../../../../src/parser/smt2/Smt2.g:2731:1: builtinOp[CVC4::Kind& kind] : ( NOT_TOK | IMPLIES_TOK | AND_TOK | OR_TOK | XOR_TOK | EQUAL_TOK | DISTINCT_TOK | ITE_TOK | GREATER_THAN_TOK | GREATER_THAN_EQUAL_TOK | LESS_THAN_EQUAL_TOK | LESS_THAN_TOK | PLUS_TOK | MINUS_TOK | STAR_TOK | DIV_TOK | BV2NAT_TOK | DTSIZE_TOK | FMFCARD_TOK | FMFCARDVAL_TOK | INST_CLOSURE_TOK );
 */
static void
builtinOp(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */


      Debug("parser") << "builtin: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2735:3: ( NOT_TOK | IMPLIES_TOK | AND_TOK | OR_TOK | XOR_TOK | EQUAL_TOK | DISTINCT_TOK | ITE_TOK | GREATER_THAN_TOK | GREATER_THAN_EQUAL_TOK | LESS_THAN_EQUAL_TOK | LESS_THAN_TOK | PLUS_TOK | MINUS_TOK | STAR_TOK | DIV_TOK | BV2NAT_TOK | DTSIZE_TOK | FMFCARD_TOK | FMFCARDVAL_TOK | INST_CLOSURE_TOK )

            ANTLR3_UINT32 alt67;

            alt67=21;

            switch ( LA(1) )
            {
            case NOT_TOK:
            	{
            		alt67=1;
            	}
                break;
            case IMPLIES_TOK:
            	{
            		alt67=2;
            	}
                break;
            case AND_TOK:
            	{
            		alt67=3;
            	}
                break;
            case OR_TOK:
            	{
            		alt67=4;
            	}
                break;
            case XOR_TOK:
            	{
            		alt67=5;
            	}
                break;
            case EQUAL_TOK:
            	{
            		alt67=6;
            	}
                break;
            case DISTINCT_TOK:
            	{
            		alt67=7;
            	}
                break;
            case ITE_TOK:
            	{
            		alt67=8;
            	}
                break;
            case GREATER_THAN_TOK:
            	{
            		alt67=9;
            	}
                break;
            case GREATER_THAN_EQUAL_TOK:
            	{
            		alt67=10;
            	}
                break;
            case LESS_THAN_EQUAL_TOK:
            	{
            		alt67=11;
            	}
                break;
            case LESS_THAN_TOK:
            	{
            		alt67=12;
            	}
                break;
            case PLUS_TOK:
            	{
            		alt67=13;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt67=14;
            	}
                break;
            case STAR_TOK:
            	{
            		alt67=15;
            	}
                break;
            case DIV_TOK:
            	{
            		alt67=16;
            	}
                break;
            case BV2NAT_TOK:
            	{
            		alt67=17;
            	}
                break;
            case DTSIZE_TOK:
            	{
            		alt67=18;
            	}
                break;
            case FMFCARD_TOK:
            	{
            		alt67=19;
            	}
                break;
            case FMFCARDVAL_TOK:
            	{
            		alt67=20;
            	}
                break;
            case INST_CLOSURE_TOK:
            	{
            		alt67=21;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 67;
                EXCEPTION->state        = 0;


                goto rulebuiltinOpEx;

            }

            switch (alt67)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2735:5: NOT_TOK
        	    {
        	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_builtinOp5708);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::NOT;     
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2736:5: IMPLIES_TOK
        	    {
        	         MATCHT(IMPLIES_TOK, &FOLLOW_IMPLIES_TOK_in_builtinOp5721);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::IMPLIES; 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:2737:5: AND_TOK
        	    {
        	         MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_builtinOp5730);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::AND;     
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:2738:5: OR_TOK
        	    {
        	         MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_builtinOp5743);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::OR;      
        	        }


        	    }
        	    break;
        	case 5:
        	    // ../../../../src/parser/smt2/Smt2.g:2739:5: XOR_TOK
        	    {
        	         MATCHT(XOR_TOK, &FOLLOW_XOR_TOK_in_builtinOp5757);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::XOR;     
        	        }


        	    }
        	    break;
        	case 6:
        	    // ../../../../src/parser/smt2/Smt2.g:2740:5: EQUAL_TOK
        	    {
        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_builtinOp5770);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::EQUAL;   
        	        }


        	    }
        	    break;
        	case 7:
        	    // ../../../../src/parser/smt2/Smt2.g:2741:5: DISTINCT_TOK
        	    {
        	         MATCHT(DISTINCT_TOK, &FOLLOW_DISTINCT_TOK_in_builtinOp5781);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::DISTINCT; 
        	        }


        	    }
        	    break;
        	case 8:
        	    // ../../../../src/parser/smt2/Smt2.g:2742:5: ITE_TOK
        	    {
        	         MATCHT(ITE_TOK, &FOLLOW_ITE_TOK_in_builtinOp5789);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::ITE; 
        	        }


        	    }
        	    break;
        	case 9:
        	    // ../../../../src/parser/smt2/Smt2.g:2743:5: GREATER_THAN_TOK
        	    {
        	         MATCHT(GREATER_THAN_TOK, &FOLLOW_GREATER_THAN_TOK_in_builtinOp5802);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::GT; 
        	        }


        	    }
        	    break;
        	case 10:
        	    // ../../../../src/parser/smt2/Smt2.g:2745:5: GREATER_THAN_EQUAL_TOK
        	    {
        	         MATCHT(GREATER_THAN_EQUAL_TOK, &FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp5827);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::GEQ; 
        	        }


        	    }
        	    break;
        	case 11:
        	    // ../../../../src/parser/smt2/Smt2.g:2747:5: LESS_THAN_EQUAL_TOK
        	    {
        	         MATCHT(LESS_THAN_EQUAL_TOK, &FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp5852);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::LEQ; 
        	        }


        	    }
        	    break;
        	case 12:
        	    // ../../../../src/parser/smt2/Smt2.g:2749:5: LESS_THAN_TOK
        	    {
        	         MATCHT(LESS_THAN_TOK, &FOLLOW_LESS_THAN_TOK_in_builtinOp5877);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::LT; 
        	        }


        	    }
        	    break;
        	case 13:
        	    // ../../../../src/parser/smt2/Smt2.g:2751:5: PLUS_TOK
        	    {
        	         MATCHT(PLUS_TOK, &FOLLOW_PLUS_TOK_in_builtinOp5902);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::PLUS; 
        	        }


        	    }
        	    break;
        	case 14:
        	    // ../../../../src/parser/smt2/Smt2.g:2752:5: MINUS_TOK
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_builtinOp5914);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::MINUS; 
        	        }


        	    }
        	    break;
        	case 15:
        	    // ../../../../src/parser/smt2/Smt2.g:2753:5: STAR_TOK
        	    {
        	         MATCHT(STAR_TOK, &FOLLOW_STAR_TOK_in_builtinOp5925);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::MULT; 
        	        }


        	    }
        	    break;
        	case 16:
        	    // ../../../../src/parser/smt2/Smt2.g:2754:5: DIV_TOK
        	    {
        	         MATCHT(DIV_TOK, &FOLLOW_DIV_TOK_in_builtinOp5937);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::DIVISION; 
        	        }


        	    }
        	    break;
        	case 17:
        	    // ../../../../src/parser/smt2/Smt2.g:2756:5: BV2NAT_TOK
        	    {
        	         MATCHT(BV2NAT_TOK, &FOLLOW_BV2NAT_TOK_in_builtinOp5951);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::BITVECTOR_TO_NAT;
        	                  if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError("bv2nat and int2bv are not part of SMT-LIB, "
        	                                             "and aren't available in SMT-LIB strict "
        	                                             "compliance mode");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 18:
        	    // ../../../../src/parser/smt2/Smt2.g:2765:5: DTSIZE_TOK
        	    {
        	         MATCHT(DTSIZE_TOK, &FOLLOW_DTSIZE_TOK_in_builtinOp5964);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::DT_SIZE; 
        	        }


        	    }
        	    break;
        	case 19:
        	    // ../../../../src/parser/smt2/Smt2.g:2766:5: FMFCARD_TOK
        	    {
        	         MATCHT(FMFCARD_TOK, &FOLLOW_FMFCARD_TOK_in_builtinOp5978);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::CARDINALITY_CONSTRAINT; 
        	        }


        	    }
        	    break;
        	case 20:
        	    // ../../../../src/parser/smt2/Smt2.g:2767:5: FMFCARDVAL_TOK
        	    {
        	         MATCHT(FMFCARDVAL_TOK, &FOLLOW_FMFCARDVAL_TOK_in_builtinOp5991);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::CARDINALITY_VALUE; 
        	        }


        	    }
        	    break;
        	case 21:
        	    // ../../../../src/parser/smt2/Smt2.g:2768:5: INST_CLOSURE_TOK
        	    {
        	         MATCHT(INST_CLOSURE_TOK, &FOLLOW_INST_CLOSURE_TOK_in_builtinOp6001);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::INST_CLOSURE; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebuiltinOpEx; /* Prevent compiler warnings */
    rulebuiltinOpEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end builtinOp */

/**
 * $ANTLR start quantOp
 * ../../../../src/parser/smt2/Smt2.g:2778:1: quantOp[CVC4::Kind& kind] : ( EXISTS_TOK | FORALL_TOK );
 */
static void
quantOp(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */


      Debug("parser") << "quant: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2782:3: ( EXISTS_TOK | FORALL_TOK )

            ANTLR3_UINT32 alt68;

            alt68=2;

            switch ( LA(1) )
            {
            case EXISTS_TOK:
            	{
            		alt68=1;
            	}
                break;
            case FORALL_TOK:
            	{
            		alt68=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 68;
                EXCEPTION->state        = 0;


                goto rulequantOpEx;

            }

            switch (alt68)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2782:5: EXISTS_TOK
        	    {
        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_quantOp6043);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequantOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::EXISTS; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2783:5: FORALL_TOK
        	    {
        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_quantOp6054);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequantOpEx;
        	        }


        	        {
        	             kind= CVC4::kind::FORALL; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulequantOpEx; /* Prevent compiler warnings */
    rulequantOpEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end quantOp */

/**
 * $ANTLR start functionName
 * ../../../../src/parser/smt2/Smt2.g:2790:1: functionName[std::string& name, CVC4::parser::DeclarationCheck check] : symbol[name,check,SYM_VARIABLE] ;
 */
static void
functionName(pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2791:3: ( symbol[name,check,SYM_VARIABLE] )
        // ../../../../src/parser/smt2/Smt2.g:2791:5: symbol[name,check,SYM_VARIABLE]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_functionName6075);
            symbol(ctx, name, check, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulefunctionNameEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulefunctionNameEx; /* Prevent compiler warnings */
    rulefunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end functionName */

/**
 * $ANTLR start sortList
 * ../../../../src/parser/smt2/Smt2.g:2798:1: sortList[std::vector<CVC4::Type>& sorts] : ( sortSymbol[t,CHECK_DECLARED] )* ;
 */
static void
sortList(pSmt2Parser ctx, std::vector<CVC4::Type>& sorts)
{

      Type t;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2802:3: ( ( sortSymbol[t,CHECK_DECLARED] )* )
        // ../../../../src/parser/smt2/Smt2.g:2802:5: ( sortSymbol[t,CHECK_DECLARED] )*
        {
            // ../../../../src/parser/smt2/Smt2.g:2802:5: ( sortSymbol[t,CHECK_DECLARED] )*

            for (;;)
            {
                int alt69=2;
                switch ( LA(1) )
                {
                case CHECK_SYNTH_TOK:
                case CONSTRAINT_TOK:
                case DECLARE_PRIMED_VAR_TOK:
                case DECLARE_VAR_TOK:
                case INV_CONSTRAINT_TOK:
                case LPAREN_TOK:
                case QUOTED_SYMBOL:
                case SET_OPTIONS_TOK:
                case SIMPLE_SYMBOL:
                case SYNTH_FUN_TOK:
                case SYNTH_INV_TOK:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 162:
                	{
                		alt69=1;
                	}
                    break;

                }

                switch (alt69)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2802:7: sortSymbol[t,CHECK_DECLARED]
            	    {
            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sortList6099);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortListEx;
            	        }


            	        {
            	             sorts.push_back(t); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop69;	/* break out of the loop */
            	    break;
                }
            }
            loop69: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortListEx; /* Prevent compiler warnings */
    rulesortListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortList */

/**
 * $ANTLR start nonemptySortList
 * ../../../../src/parser/smt2/Smt2.g:2805:1: nonemptySortList[std::vector<CVC4::Type>& sorts] : ( sortSymbol[t,CHECK_DECLARED] )+ ;
 */
static void
nonemptySortList(pSmt2Parser ctx, std::vector<CVC4::Type>& sorts)
{

      Type t;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2809:3: ( ( sortSymbol[t,CHECK_DECLARED] )+ )
        // ../../../../src/parser/smt2/Smt2.g:2809:5: ( sortSymbol[t,CHECK_DECLARED] )+
        {
            // ../../../../src/parser/smt2/Smt2.g:2809:5: ( sortSymbol[t,CHECK_DECLARED] )+
            {
                int cnt70=0;

                for (;;)
                {
                    int alt70=2;
            	switch ( LA(1) )
            	{
            	case CHECK_SYNTH_TOK:
            	case CONSTRAINT_TOK:
            	case DECLARE_PRIMED_VAR_TOK:
            	case DECLARE_VAR_TOK:
            	case INV_CONSTRAINT_TOK:
            	case LPAREN_TOK:
            	case QUOTED_SYMBOL:
            	case SET_OPTIONS_TOK:
            	case SIMPLE_SYMBOL:
            	case SYNTH_FUN_TOK:
            	case SYNTH_INV_TOK:
            	case UNTERMINATED_QUOTED_SYMBOL:
            	case 162:
            		{
            			alt70=1;
            		}
            	    break;

            	}

            	switch (alt70)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:2809:7: sortSymbol[t,CHECK_DECLARED]
            	        {
            	            FOLLOWPUSH(FOLLOW_sortSymbol_in_nonemptySortList6126);
            	            sortSymbol(ctx, t, CHECK_DECLARED);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulenonemptySortListEx;
            	            }


            	            {
            	                 sorts.push_back(t); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt70 >= 1 )
            		{
            		    goto loop70;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulenonemptySortListEx;
            	}
            	cnt70++;
                }
                loop70: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulenonemptySortListEx; /* Prevent compiler warnings */
    rulenonemptySortListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nonemptySortList */

/**
 * $ANTLR start sortedVarList
 * ../../../../src/parser/smt2/Smt2.g:2816:1: sortedVarList[std::vector<std::pair<std::string, CVC4::Type> >& sortedVars] : ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )* ;
 */
static void
sortedVarList(pSmt2Parser ctx, std::vector<std::pair<std::string, CVC4::Type> >& sortedVars)
{

      std::string name;
      Type t;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2821:3: ( ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )* )
        // ../../../../src/parser/smt2/Smt2.g:2821:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )*
        {
            // ../../../../src/parser/smt2/Smt2.g:2821:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )*

            for (;;)
            {
                int alt71=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt71=1;
                	}
                    break;

                }

                switch (alt71)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2821:7: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortedVarList6155);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_symbol_in_sortedVarList6157);
            	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sortedVarList6166);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortedVarList6169);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }


            	        {
            	             sortedVars.push_back(make_pair(name, t)); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop71;	/* break out of the loop */
            	    break;
                }
            }
            loop71: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortedVarListEx; /* Prevent compiler warnings */
    rulesortedVarListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortedVarList */

/**
 * $ANTLR start sortName
 * ../../../../src/parser/smt2/Smt2.g:2831:1: sortName[std::string& name, CVC4::parser::DeclarationCheck check] : symbol[name,check,SYM_SORT] ;
 */
static void
sortName(pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2832:3: ( symbol[name,check,SYM_SORT] )
        // ../../../../src/parser/smt2/Smt2.g:2832:5: symbol[name,check,SYM_SORT]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_sortName6200);
            symbol(ctx, name, check, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesortNameEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortNameEx; /* Prevent compiler warnings */
    rulesortNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortName */

/**
 * $ANTLR start sortSymbol
 * ../../../../src/parser/smt2/Smt2.g:2835:1: sortSymbol[CVC4::Type& t, CVC4::parser::DeclarationCheck check] : ( sortName[name,CHECK_NONE] | LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK | LPAREN_TOK HO_ARROW_TOK sortList[args] RPAREN_TOK );
 */
static void
sortSymbol(pSmt2Parser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{

      std::string name;
      std::vector<CVC4::Type> args;
      std::vector<uint64_t> numerals;
      bool indexed = false;

    /* Initialize rule variables
     */

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2842:3: ( sortName[name,CHECK_NONE] | LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK | LPAREN_TOK HO_ARROW_TOK sortList[args] RPAREN_TOK )

            ANTLR3_UINT32 alt74;

            alt74=3;

            switch ( LA(1) )
            {
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case QUOTED_SYMBOL:
            case SET_OPTIONS_TOK:
            case SIMPLE_SYMBOL:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 162:
            	{
            		alt74=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case HO_ARROW_TOK:
            			{
            				alt74=3;
            			}
            		    break;
            		case CHECK_SYNTH_TOK:
            		case CONSTRAINT_TOK:
            		case DECLARE_PRIMED_VAR_TOK:
            		case DECLARE_VAR_TOK:
            		case INDEX_TOK:
            		case INV_CONSTRAINT_TOK:
            		case QUOTED_SYMBOL:
            		case SET_OPTIONS_TOK:
            		case SIMPLE_SYMBOL:
            		case SYNTH_FUN_TOK:
            		case SYNTH_INV_TOK:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 162:
            			{
            				alt74=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 74;
            		    EXCEPTION->state        = 13;


            		    goto rulesortSymbolEx;

            		}

            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 74;
                EXCEPTION->state        = 0;


                goto rulesortSymbolEx;

            }

            switch (alt74)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2842:5: sortName[name,CHECK_NONE]
        	    {
        	        FOLLOWPUSH(FOLLOW_sortName_in_sortSymbol6220);
        	        sortName(ctx, name, CHECK_NONE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        {

        	                  if(check == CHECK_DECLARED || PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	                    t = PARSER_STATE->getSort(name);
        	                  } else {
        	                    t = PARSER_STATE->mkUnresolvedType(name);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2850:5: LPAREN_TOK ( INDEX_TOK |) symbol[name,CHECK_NONE,SYM_SORT] ( nonemptyNumeralList[numerals] | sortList[args] ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortSymbol6233);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2850:16: ( INDEX_TOK |)
        	        {
        	            int alt72=2;
        	            switch ( LA(1) )
        	            {
        	            case INDEX_TOK:
        	            	{
        	            		alt72=1;
        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case INV_CONSTRAINT_TOK:
        	            case QUOTED_SYMBOL:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 162:
        	            	{
        	            		alt72=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 72;
        	                EXCEPTION->state        = 0;


        	                goto rulesortSymbolEx;

        	            }

        	            switch (alt72)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2850:17: INDEX_TOK
        	        	    {
        	        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_sortSymbol6236);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	            indexed = true;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2850:47: 
        	        	    {
        	        	        {
        	        	            indexed = false;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        FOLLOWPUSH(FOLLOW_symbol_in_sortSymbol6249);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2852:5: ( nonemptyNumeralList[numerals] | sortList[args] )
        	        {
        	            int alt73=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt73=1;
        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            case CONSTRAINT_TOK:
        	            case DECLARE_PRIMED_VAR_TOK:
        	            case DECLARE_VAR_TOK:
        	            case INV_CONSTRAINT_TOK:
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case RPAREN_TOK:
        	            case SET_OPTIONS_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SYNTH_FUN_TOK:
        	            case SYNTH_INV_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 162:
        	            	{
        	            		alt73=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 73;
        	                EXCEPTION->state        = 0;


        	                goto rulesortSymbolEx;

        	            }

        	            switch (alt73)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2852:7: nonemptyNumeralList[numerals]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_nonemptyNumeralList_in_sortSymbol6258);
        	        	        nonemptyNumeralList(ctx, numerals);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	             // allow sygus inputs to elide the `_'
        	        	                    if( !indexed && !PARSER_STATE->sygus() ) {
        	        	                      std::stringstream ss;
        	        	                      ss << "SMT-LIB requires use of an indexed sort here, e.g. (_ " << name
        	        	                         << " ...)";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if( name == "BitVec" ) {
        	        	                      if( numerals.size() != 1 ) {
        	        	                        PARSER_STATE->parseError("Illegal bitvector type.");
        	        	                      }
        	        	                      if(numerals.front() == 0) {
        	        	                        PARSER_STATE->parseError("Illegal bitvector size: 0");
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkBitVectorType(numerals.front());
        	        	                    } else if ( name == "FloatingPoint" ) {
        	        	                      if( numerals.size() != 2 ) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point type.");
        	        	                      }
        	        	                      if(!validExponentSize(numerals[0])) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point exponent size");
        	        	                      }
        	        	                      if(!validSignificandSize(numerals[1])) {
        	        	                        PARSER_STATE->parseError("Illegal floating-point significand size");
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkFloatingPointType(numerals[0],numerals[1]);
        	        	                    } else {
        	        	                      std::stringstream ss;
        	        	                      ss << "unknown indexed sort symbol `" << name << "'";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2885:7: sortList[args]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_sortList_in_sortSymbol6275);
        	        	        sortList(ctx, args);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesortSymbolEx;
        	        	        }


        	        	        {
        	        	             if( indexed ) {
        	        	                      std::stringstream ss;
        	        	                      ss << "Unexpected use of indexing operator `_' before `" << name
        	        	                         << "', try leaving it out";
        	        	                      PARSER_STATE->parseError(ss.str());
        	        	                    }
        	        	                    if(args.empty()) {
        	        	                      PARSER_STATE->parseError("Extra parentheses around sort name not "
        	        	                                               "permitted in SMT-LIB");
        	        	                    } else if(name == "Array" &&
        	        	                       PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) ) {
        	        	                      if(args.size() != 2) {
        	        	                        PARSER_STATE->parseError("Illegal array type.");
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkArrayType( args[0], args[1] );
        	        	                    } else if(name == "Set" &&
        	        	                              PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS) ) {
        	        	                      if(args.size() != 1) {
        	        	                        PARSER_STATE->parseError("Illegal set type.");
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkSetType( args[0] );
        	        	                    } else if(name == "Tuple") {
        	        	                      t = EXPR_MANAGER->mkTupleType(args); 
        	        	                    } else if(check == CHECK_DECLARED ||
        	        	                              PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	        	                      t = PARSER_STATE->getSort(name, args);
        	        	                    } else {
        	        	                      // make unresolved type
        	        	                      if(args.empty()) {
        	        	                        t = PARSER_STATE->mkUnresolvedType(name);
        	        	                        Debug("parser-param") << "param: make unres type " << name
        	        	                                              << std::endl;
        	        	                      } else {
        	        	                        t = PARSER_STATE->mkUnresolvedTypeConstructor(name,args);
        	        	                        t = SortConstructorType(t).instantiate( args );
        	        	                        Debug("parser-param")
        	        	                            << "param: make unres param type " << name << " " << args.size()
        	        	                            << " " << PARSER_STATE->getArity( name ) << std::endl;
        	        	                      }
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortSymbol6292);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:2928:5: LPAREN_TOK HO_ARROW_TOK sortList[args] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortSymbol6298);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	         MATCHT(HO_ARROW_TOK, &FOLLOW_HO_ARROW_TOK_in_sortSymbol6300);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortList_in_sortSymbol6302);
        	        sortList(ctx, args);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortSymbol6305);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }


        	        {

        	                  if(args.size()<2) {
        	                    PARSER_STATE->parseError("Arrow types must have at least 2 arguments");
        	                  }
        	                  //flatten the type
        	                  Type rangeType = args.back();
        	                  args.pop_back();
        	                  t = PARSER_STATE->mkFlatFunctionType( args, rangeType );
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesortSymbolEx; /* Prevent compiler warnings */
    rulesortSymbolEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortSymbol */

/**
 * $ANTLR start symbolList
 * ../../../../src/parser/smt2/Smt2.g:2944:1: symbolList[std::vector<std::string>& names,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : ( symbol[id,check,type] )* ;
 */
static void
symbolList(pSmt2Parser ctx, std::vector<std::string>& names, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{

      std::string id;

    /* Initialize rule variables
     */

    {
        // ../../../../src/parser/smt2/Smt2.g:2950:3: ( ( symbol[id,check,type] )* )
        // ../../../../src/parser/smt2/Smt2.g:2950:5: ( symbol[id,check,type] )*
        {
            // ../../../../src/parser/smt2/Smt2.g:2950:5: ( symbol[id,check,type] )*

            for (;;)
            {
                int alt75=2;
                switch ( LA(1) )
                {
                case CHECK_SYNTH_TOK:
                case CONSTRAINT_TOK:
                case DECLARE_PRIMED_VAR_TOK:
                case DECLARE_VAR_TOK:
                case INV_CONSTRAINT_TOK:
                case QUOTED_SYMBOL:
                case SET_OPTIONS_TOK:
                case SIMPLE_SYMBOL:
                case SYNTH_FUN_TOK:
                case SYNTH_INV_TOK:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 162:
                	{
                		alt75=1;
                	}
                    break;

                }

                switch (alt75)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:2950:7: symbol[id,check,type]
            	    {
            	        FOLLOWPUSH(FOLLOW_symbol_in_symbolList6334);
            	        symbol(ctx, id, check, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesymbolListEx;
            	        }


            	        {
            	             names.push_back(id); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop75;	/* break out of the loop */
            	    break;
                }
            }
            loop75: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesymbolListEx; /* Prevent compiler warnings */
    rulesymbolListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolList */

/**
 * $ANTLR start symbol
 * ../../../../src/parser/smt2/Smt2.g:2959:1: symbol[std::string& id,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : ( SIMPLE_SYMBOL | ( 'repeat' | SET_OPTIONS_TOK | DECLARE_VAR_TOK | DECLARE_PRIMED_VAR_TOK | SYNTH_FUN_TOK | SYNTH_INV_TOK | CONSTRAINT_TOK | INV_CONSTRAINT_TOK | CHECK_SYNTH_TOK ) | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' ) );
 */
static void
symbol(pSmt2Parser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    pANTLR3_COMMON_TOKEN    SIMPLE_SYMBOL22;
    pANTLR3_COMMON_TOKEN    QUOTED_SYMBOL23;

    /* Initialize rule variables
     */

    SIMPLE_SYMBOL22       = NULL;
    QUOTED_SYMBOL23       = NULL;

    {
        {
            //  ../../../../src/parser/smt2/Smt2.g:2962:3: ( SIMPLE_SYMBOL | ( 'repeat' | SET_OPTIONS_TOK | DECLARE_VAR_TOK | DECLARE_PRIMED_VAR_TOK | SYNTH_FUN_TOK | SYNTH_INV_TOK | CONSTRAINT_TOK | INV_CONSTRAINT_TOK | CHECK_SYNTH_TOK ) | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' ) )

            ANTLR3_UINT32 alt78;

            alt78=4;

            switch ( LA(1) )
            {
            case SIMPLE_SYMBOL:
            	{
            		alt78=1;
            	}
                break;
            case CHECK_SYNTH_TOK:
            case CONSTRAINT_TOK:
            case DECLARE_PRIMED_VAR_TOK:
            case DECLARE_VAR_TOK:
            case INV_CONSTRAINT_TOK:
            case SET_OPTIONS_TOK:
            case SYNTH_FUN_TOK:
            case SYNTH_INV_TOK:
            case 162:
            	{
            		alt78=2;
            	}
                break;
            case QUOTED_SYMBOL:
            	{
            		alt78=3;
            	}
                break;
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt78=4;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 78;
                EXCEPTION->state        = 0;


                goto rulesymbolEx;

            }

            switch (alt78)
            {
        	case 1:
        	    // ../../../../src/parser/smt2/Smt2.g:2962:5: SIMPLE_SYMBOL
        	    {
        	        SIMPLE_SYMBOL22 = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_symbol6356);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        {
        	             id = AntlrInput::tokenText(SIMPLE_SYMBOL22);
        	                  if(!PARSER_STATE->isAbstractValue(id)) {
        	                    // if an abstract value, SmtEngine handles declaration
        	                    PARSER_STATE->checkDeclaration(id, check, type);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // ../../../../src/parser/smt2/Smt2.g:2969:5: ( 'repeat' | SET_OPTIONS_TOK | DECLARE_VAR_TOK | DECLARE_PRIMED_VAR_TOK | SYNTH_FUN_TOK | SYNTH_INV_TOK | CONSTRAINT_TOK | INV_CONSTRAINT_TOK | CHECK_SYNTH_TOK )
        	    {
        	        // ../../../../src/parser/smt2/Smt2.g:2969:5: ( 'repeat' | SET_OPTIONS_TOK | DECLARE_VAR_TOK | DECLARE_PRIMED_VAR_TOK | SYNTH_FUN_TOK | SYNTH_INV_TOK | CONSTRAINT_TOK | INV_CONSTRAINT_TOK | CHECK_SYNTH_TOK )
        	        {
        	            int alt76=9;
        	            switch ( LA(1) )
        	            {
        	            case 162:
        	            	{
        	            		alt76=1;
        	            	}
        	                break;
        	            case SET_OPTIONS_TOK:
        	            	{
        	            		alt76=2;
        	            	}
        	                break;
        	            case DECLARE_VAR_TOK:
        	            	{
        	            		alt76=3;
        	            	}
        	                break;
        	            case DECLARE_PRIMED_VAR_TOK:
        	            	{
        	            		alt76=4;
        	            	}
        	                break;
        	            case SYNTH_FUN_TOK:
        	            	{
        	            		alt76=5;
        	            	}
        	                break;
        	            case SYNTH_INV_TOK:
        	            	{
        	            		alt76=6;
        	            	}
        	                break;
        	            case CONSTRAINT_TOK:
        	            	{
        	            		alt76=7;
        	            	}
        	                break;
        	            case INV_CONSTRAINT_TOK:
        	            	{
        	            		alt76=8;
        	            	}
        	                break;
        	            case CHECK_SYNTH_TOK:
        	            	{
        	            		alt76=9;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 76;
        	                EXCEPTION->state        = 0;


        	                goto rulesymbolEx;

        	            }

        	            switch (alt76)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2969:7: 'repeat'
        	        	    {
        	        	         MATCHT(162, &FOLLOW_162_in_symbol6370);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "repeat"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2972:7: SET_OPTIONS_TOK
        	        	    {
        	        	         MATCHT(SET_OPTIONS_TOK, &FOLLOW_SET_OPTIONS_TOK_in_symbol6386);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "set-options"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2973:7: DECLARE_VAR_TOK
        	        	    {
        	        	         MATCHT(DECLARE_VAR_TOK, &FOLLOW_DECLARE_VAR_TOK_in_symbol6396);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "declare-var"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2974:7: DECLARE_PRIMED_VAR_TOK
        	        	    {
        	        	         MATCHT(DECLARE_PRIMED_VAR_TOK, &FOLLOW_DECLARE_PRIMED_VAR_TOK_in_symbol6406);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "declare-primed-var"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 5:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2975:7: SYNTH_FUN_TOK
        	        	    {
        	        	         MATCHT(SYNTH_FUN_TOK, &FOLLOW_SYNTH_FUN_TOK_in_symbol6416);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "synth-fun"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 6:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2976:7: SYNTH_INV_TOK
        	        	    {
        	        	         MATCHT(SYNTH_INV_TOK, &FOLLOW_SYNTH_INV_TOK_in_symbol6426);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "synth-inv"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 7:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2977:7: CONSTRAINT_TOK
        	        	    {
        	        	         MATCHT(CONSTRAINT_TOK, &FOLLOW_CONSTRAINT_TOK_in_symbol6436);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "constraint"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 8:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2978:7: INV_CONSTRAINT_TOK
        	        	    {
        	        	         MATCHT(INV_CONSTRAINT_TOK, &FOLLOW_INV_CONSTRAINT_TOK_in_symbol6446);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "inv-constraint"; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 9:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2979:7: CHECK_SYNTH_TOK
        	        	    {
        	        	         MATCHT(CHECK_SYNTH_TOK, &FOLLOW_CHECK_SYNTH_TOK_in_symbol6456);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             id = "check-synth"; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {
        	             PARSER_STATE->checkDeclaration(id, check, type); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // ../../../../src/parser/smt2/Smt2.g:2982:5: QUOTED_SYMBOL
        	    {
        	        QUOTED_SYMBOL23 = (pANTLR3_COMMON_TOKEN) MATCHT(QUOTED_SYMBOL, &FOLLOW_QUOTED_SYMBOL_in_symbol6476);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        {
        	             id = AntlrInput::tokenText(QUOTED_SYMBOL23);
        	                  /* strip off the quotes */
        	                  id = id.substr(1, id.size() - 2);
        	                  if(!PARSER_STATE->isAbstractValue(id)) {
        	                    // if an abstract value, SmtEngine handles declaration
        	                    PARSER_STATE->checkDeclaration(id, check, type);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // ../../../../src/parser/smt2/Smt2.g:2991:5: UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' )
        	    {
        	         MATCHT(UNTERMINATED_QUOTED_SYMBOL, &FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol6488);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }


        	        // ../../../../src/parser/smt2/Smt2.g:2992:5: ( EOF | '\\\\' )
        	        {
        	            int alt77=2;
        	            switch ( LA(1) )
        	            {
        	            case EOF:
        	            	{
        	            		alt77=1;
        	            	}
        	                break;
        	            case 160:
        	            	{
        	            		alt77=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 77;
        	                EXCEPTION->state        = 0;


        	                goto rulesymbolEx;

        	            }

        	            switch (alt77)
        	            {
        	        	case 1:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2992:7: EOF
        	        	    {
        	        	         MATCHT(EOF, &FOLLOW_EOF_in_symbol6496);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->unexpectedEOF("unterminated |quoted| symbol"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // ../../../../src/parser/smt2/Smt2.g:2994:7: '\\\\'
        	        	    {
        	        	         MATCHT(160, &FOLLOW_160_in_symbol6512);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->unexpectedEOF("backslash not permitted in |quoted| "
        	        	                                                "symbol"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolEx; /* Prevent compiler warnings */
    rulesymbolEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbol */

/**
 * $ANTLR start nonemptyNumeralList
 * ../../../../src/parser/smt2/Smt2.g:3004:1: nonemptyNumeralList[std::vector<uint64_t>& numerals] : ( INTEGER_LITERAL )+ ;
 */
static void
nonemptyNumeralList(pSmt2Parser ctx, std::vector<uint64_t>& numerals)
{
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL24;

    /* Initialize rule variables
     */

    INTEGER_LITERAL24       = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:3005:3: ( ( INTEGER_LITERAL )+ )
        // ../../../../src/parser/smt2/Smt2.g:3005:5: ( INTEGER_LITERAL )+
        {
            // ../../../../src/parser/smt2/Smt2.g:3005:5: ( INTEGER_LITERAL )+
            {
                int cnt79=0;

                for (;;)
                {
                    int alt79=2;
            	switch ( LA(1) )
            	{
            	case INTEGER_LITERAL:
            		{
            			alt79=1;
            		}
            	    break;

            	}

            	switch (alt79)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:3005:7: INTEGER_LITERAL
            	        {
            	            INTEGER_LITERAL24 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList6544);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulenonemptyNumeralListEx;
            	            }


            	            {
            	                 numerals.push_back(AntlrInput::tokenToUnsigned(INTEGER_LITERAL24)); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt79 >= 1 )
            		{
            		    goto loop79;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulenonemptyNumeralListEx;
            	}
            	cnt79++;
                }
                loop79: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulenonemptyNumeralListEx; /* Prevent compiler warnings */
    rulenonemptyNumeralListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nonemptyNumeralList */

/**
 * $ANTLR start datatypeDef
 * ../../../../src/parser/smt2/Smt2.g:3013:1: datatypeDef[bool isCo, std::vector<CVC4::Datatype>& datatypes,\n std::vector< CVC4::Type >& params] : symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+ ;
 */
static void
datatypeDef(pSmt2Parser ctx, bool isCo, std::vector<CVC4::Datatype>& datatypes, std::vector< CVC4::Type >& params)
{
    /* Initialize rule variables
     */


      std::string id;

    {
        // ../../../../src/parser/smt2/Smt2.g:3022:3: ( symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+ )
        // ../../../../src/parser/smt2/Smt2.g:3022:5: symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+
        {
            FOLLOWPUSH(FOLLOW_symbol_in_datatypeDef6586);
            symbol(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }


            {
                 PARSER_STATE->pushScope(true); 
            }


            {
                 datatypes.push_back(Datatype(id,params,isCo));
                      if(!PARSER_STATE->isUnresolvedType(id)) {
                        // if not unresolved, must be undeclared
                        PARSER_STATE->checkDeclaration(id, CHECK_UNDECLARED, SYM_SORT);
                      }
                    
            }


            // ../../../../src/parser/smt2/Smt2.g:3038:5: ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+
            {
                int cnt80=0;

                for (;;)
                {
                    int alt80=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt80=1;
            		}
            	    break;

            	}

            	switch (alt80)
            	{
            	    case 1:
            	        // ../../../../src/parser/smt2/Smt2.g:3038:7: LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypeDef6609);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDef6611);
            	            constructorDef(ctx, datatypes.back());

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypeDef6614);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt80 >= 1 )
            		{
            		    goto loop80;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypeDefEx;
            	}
            	cnt80++;
                }
                loop80: ;	/* Jump to here if this rule does not match */
            }

            {
                 PARSER_STATE->popScope(); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefEx; /* Prevent compiler warnings */
    ruledatatypeDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDef */

/**
 * $ANTLR start constructorDef
 * ../../../../src/parser/smt2/Smt2.g:3045:1: constructorDef[CVC4::Datatype& type] : symbol[id,CHECK_NONE,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )* ;
 */
static void
constructorDef(pSmt2Parser ctx, CVC4::Datatype& type)
{
    /* Initialize rule variables
     */


      std::string id;
      CVC4::DatatypeConstructor* ctor = NULL;

    {
        // ../../../../src/parser/smt2/Smt2.g:3050:3: ( symbol[id,CHECK_NONE,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )* )
        // ../../../../src/parser/smt2/Smt2.g:3050:5: symbol[id,CHECK_NONE,SYM_VARIABLE] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )*
        {
            FOLLOWPUSH(FOLLOW_symbol_in_constructorDef6644);
            symbol(ctx, id, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconstructorDefEx;
            }


            {
                 // make the tester
                      std::string testerId("is-");
                      testerId.append(id);
                      ctor = new CVC4::DatatypeConstructor(id, testerId);
                    
            }


            // ../../../../src/parser/smt2/Smt2.g:3056:5: ( LPAREN_TOK selector[*ctor] RPAREN_TOK )*

            for (;;)
            {
                int alt81=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt81=1;
                	}
                    break;

                }

                switch (alt81)
                {
            	case 1:
            	    // ../../../../src/parser/smt2/Smt2.g:3056:7: LPAREN_TOK selector[*ctor] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_constructorDef6659);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_selector_in_constructorDef6661);
            	        selector(ctx, *ctor);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_constructorDef6664);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop81;	/* break out of the loop */
            	    break;
                }
            }
            loop81: ; /* Jump out to here if this rule does not match */


            {
                 // make the constructor
                      type.addConstructor(*ctor);
                      Debug("parser-idt") << "constructor: " << id.c_str() << std::endl;
                      delete ctor;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleconstructorDefEx; /* Prevent compiler warnings */
    ruleconstructorDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end constructorDef */

/**
 * $ANTLR start selector
 * ../../../../src/parser/smt2/Smt2.g:3064:1: selector[CVC4::DatatypeConstructor& ctor] : symbol[id,CHECK_NONE,SYM_SORT] sortSymbol[t,CHECK_NONE] ;
 */
static void
selector(pSmt2Parser ctx, CVC4::DatatypeConstructor& ctor)
{
    /* Initialize rule variables
     */


      std::string id;
      Type t, t2;

    {
        // ../../../../src/parser/smt2/Smt2.g:3069:3: ( symbol[id,CHECK_NONE,SYM_SORT] sortSymbol[t,CHECK_NONE] )
        // ../../../../src/parser/smt2/Smt2.g:3069:5: symbol[id,CHECK_NONE,SYM_SORT] sortSymbol[t,CHECK_NONE]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_selector6692);
            symbol(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }


            FOLLOWPUSH(FOLLOW_sortSymbol_in_selector6695);
            sortSymbol(ctx, t, CHECK_NONE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }


            {
                 ctor.addArg(id, t);
                      Debug("parser-idt") << "selector: " << id.c_str()
                                          << " of type " << t << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleselectorEx; /* Prevent compiler warnings */
    ruleselectorEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end selector */
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
