<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA DSSSL>
]>

<style-sheet>
<style-specification id="docbook-plain" use="docbook">
<style-specification-body>


;; ======================================================================
;; Handle table footnotes

(define (table-footnote-number footnote)
  (format-number (component-child-number footnote 
					 ($table-element-list$)) "a"))

(element footnote 
  (if (debug (and (equal? (print-backend) 'tex) bop-footnotes))
      (make sequence
	($ss-seq$ + (literal (footnote-number (current-node))))
	(make page-footnote (process-children)))
      ($ss-seq$ + (literal (footnote-number (current-node))))))

(element (entry footnote)
  (if (and (equal? (print-backend) 'tex) bop-footnotes)
      (next-match)
      ($ss-seq$ + (literal (table-footnote-number (current-node))))))

(element (entry para footnote)
  (if (and (equal? (print-backend) 'tex) bop-footnotes)
      (next-match)
      ($ss-seq$ + (literal (table-footnote-number (current-node))))))

(define (make-table-endnote-header)
  (make paragraph
    font-family-name: %body-font-family%
    font-weight: 'medium
    font-size: %bf-size%
    start-indent: 0pt
    quadding: 'start
    (literal (gentext-table-endnotes))))

(define (make-table-endnotes)
  (if (debug (and (equal? (print-backend) 'tex) bop-footnotes))
      (empty-sosofo)
      (let* ((footnotes (select-elements (descendants (current-node)) 
					 (normalize "footnote")))
	     (headsize (HSIZE 3))
	     (tgroup (ancestor-member (current-node) (list (normalize "tgroup"))))
	     (cols   (string->number (attribute-string (normalize "cols") tgroup))))
	(if (node-list-empty? footnotes) 
	    (empty-sosofo)
	    (make table-row
	      (make table-cell
		n-columns-spanned: cols
		cell-before-row-margin: %cals-cell-before-row-margin%
		cell-after-row-margin: %cals-cell-after-row-margin%
		cell-before-column-margin: %cals-cell-before-column-margin%
		cell-after-column-margin: %cals-cell-after-column-margin%
		start-indent: %cals-cell-content-start-indent%
		end-indent: %cals-cell-content-end-indent%
		(make-table-endnote-header)
		(with-mode table-footnote-mode
		  (process-node-list footnotes))))))))
  
(mode table-footnote-mode
  (element footnote
    (make display-group
      font-family-name: %body-font-family%
      font-weight: 'medium
      font-size: %bf-size%
      start-indent: 0pt
      quadding: 'start
      (process-children)))

  (element (footnote para)
    (let ((fnnum (table-footnote-number (parent (current-node)))))
      (if (= (child-number) 1)
	  (make paragraph
	    start-indent: %footnote-field-width%
	    first-line-start-indent: (- %footnote-field-width%)
	    (make line-field
	      field-width: %footnote-field-width%
	      (literal fnnum 
		       (gentext-label-title-sep (normalize "footnote"))))
	    (process-children-trim))
	  (make paragraph
	    start-indent: %footnote-field-width%
	    (process-children-trim))))))


</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>

