DACS_MANAGED_INFOCAR(8)    DACS Web Services Manual    DACS_MANAGED_INFOCAR(8)



[1mNAME[0m
       dacs_managed_infocard - create a managed Information Card

[1mSYNOPSIS[0m
       [1mdacs_managed_infocard [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacs_managed_infocard [22mweb service is used to create and register a
       managed InfoCard so that it can be used for authentication or other
       purposes. InfoCard-based authentication is performed by
       [34m[1mlocal_infocard_authenticate[0m[1m[22m[2], a [1mDACS [22mauthentication module.

       A managed InfoCard must be registered by [1mdacs_managed_infocard [22mbefore
       it can be used by [1mDACS[22m. After registration, use [34m[1mdacs_infocard(8)[0m[1m[22m[3] or
       [34m[1mdacsinfocard(1)[0m[1m[22m[4] to administer self-issued or managed InfoCards.

       There are several operational modes, determined by the [4mMODE[24m argument.
       In a self-serve mode, an authenticated user requests a managed InfoCard
       (with various limitations imposed); the new InfoCard is either sent
       directly to the user's browser or written to a file that the user can
       access in a separate operation. In an administrative mode, a [1mDACS[0m
       administrator requests a managed InfoCard on behalf of a user and is
       responsible for directing it to the user in a separate, secure
       operation.

       There are many [34m[1mconfiguration directives[0m[1m[22m[5] associated with managed
       InfoCards. One of the most important is [34m[1mINFOCARD_STS_AUTH_TYPE[0m[1m[22m[6],
       which determines the authentication method ("credential type") used
       between an Identity Selector, such as [1mCardSpace[22m, and the managed
       InfoCard's Identity Provider/Secure Token Service (IP/STS), such as
       [34m[1mdacs_sts(8)[0m[1m[22m[7]. The following authentication methods are prescribed by
       the InfoCard specification:

       UsernamePasswordCredential
           This is a username/password type of authentication. See
           [34m[1mINFOCARD_STS_PASSWORD_METHOD[0m[1m[22m[8]. At present, only a global (but
           changeable) password is allowed, or no password at all. A future
           release might allow a per-InfoCard account password, or tie an
           InfoCard account to some other password-based account.

       X509V3Credential
           In this authentication type, an SSL client certificate must be used
           with the request to [1mdacs_managed_infocard [22mfor a managed InfoCard,
           and the same certificate must be used when the managed InfoCard is
           submitted to a Relying Party. A self-signed certificate may be
           used.

       SelfIssuedCredential
           In this authentication type, a self-issued InfoCard must be
           submitted with the request to [34m[1mdacs_managed_infocard(8)[0m[1m[22m[9] for a
           managed InfoCard (more precisely, a secure token obtained from a
           self-issued InfoCard that is passed as the argument [4mxmlToken[24m) and
           the same self-issued InfoCard must be available to the user's
           Identity Selector when the managed InfoCard is submitted to a
           Relying Party.

       KerberosV5Credential
           This is the Kerberos V5 credential type. This authentication
           credential type is currently unsupported.

           [1mNote[0m
           An Identity Selector will display all claim values returned to it
           by an Identity Provider. An Identity Provider must therefore employ
           cryptographic methods to obtain privacy or check authenticity with
           respect to claim values.

       Accounts are accessed through [1mDACS's [22mvirtual filestore using item type
       infocards. It is assumed that file permissions on the account database
       are such that all access is limited to the administrator,
       [1mlocal_infocard_authenticate[22m, [34m[1mdacs_infocard(8)[0m[1m[22m[3], and [34m[1mdacs_sts(8)[0m[1m[22m[7].

   [1mConfiguration[0m
       The following configuration variables are available:

       [4minfocard_card_image_card[0m
           If [34m[1mINFOCARD_STS_AUTH_TYPE[0m[1m[22m[6] is "card", this is used as the
           filename of the image to include with a new managed card, relative
           to the [34m[1mINFOCARD_CARD_IMAGE_BASE_URL[0m[1m[22m[10] URI. The default value is
           the string "dacs_selfissued_credential.png" (or similar).

       [4minfocard_card_image_cert[0m
           If [34m[1mINFOCARD_STS_AUTH_TYPE[0m[1m[22m[6] is "cert", this is used as the
           filename of the image to include with a new managed card, relative
           to the [34m[1mINFOCARD_CARD_IMAGE_BASE_URL[0m[1m[22m[10] URI. The default value is
           the string "dacs_x509certificate_credential.png" (or similar).

       [4minfocard_card_image_passwd[0m
           If [34m[1mINFOCARD_STS_AUTH_TYPE[0m[1m[22m[6] is "passwd", this is used as the
           filename of the image to include with a new managed card, relative
           to the [34m[1mINFOCARD_CARD_IMAGE_BASE_URL[0m[1m[22m[10] URI. The default value is
           the string "dacs_username_password_credential.png" (or similar).

       [4minfocard_sts_title[0m
           This string identifies the IP/STS and may be displayed on web pages
           and Identity Selector prompts, or in error messages. The default
           value is the string "DACS Managed InfoCard IP/STS" (or similar).

       [4minfocard_sts_username_password_prompt_fmt[0m
           This is a [34m[1mprintf(3)[0m[1m[22m[11]-type format string. It may contain at most
           one conversion specification, %s, which will interpolate the value
           of [4minfocard_sts_title[24m.

[1mOPTIONS[0m
   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[12], [1mdacs_managed_infocard[0m
       understands the following CGI arguments:


       [4mxmlToken[0m
           This argument is required if [34m[1mINFOCARD_STS_AUTH_TYPE[0m[1m[22m[6] is set to
           "card". The self-issued InfoCard is registered with the account
           associated with the new managed InfoCard and the user's Identity
           Selector must possess the self-issued InfoCard in order to use the
           managed InfoCard.

       [4mCARD_IMAGE_SUBTYPE[0m
           This optional argument specifies the MIME media subtype (e.g., the
           image format, such as "jpeg") of the image file attached to the new
           InfoCard. By default, the subtype is derived from the extension on
           the end of the last path component of the image's URI. For example,
           if [4mCARD_IMAGE_URL[24m is /card_images/bob.tn.gif, then the extension
           .gif is used to obtain a media subtype of gif and a MIME media type
           of image/gif. It is sometimes necessary to give the image format
           explicitly, however. See [34m[1mINFOCARD_CARD_IMAGE_BASE_URL[0m[1m[22m[10] for
           additional details. Only a [1mDACS [22madministrator may use this
           argument.

       [4mCARD_IMAGE_URL[0m
           This optional argument specifies the location (as a [1mDACS [34mVFS[0m
           [1m[34mURI[0m[1m[22m[13]) of the image file to attach to the new InfoCard,
           overriding the default method that uses only
           [34m[1mINFOCARD_CARD_IMAGE_BASE_URL[0m[1m[22m[10]. If a file is specified (i.e., the
           value begins with a '/' or uses the file scheme), the path is
           relative to the INFOCARD_CARD_IMAGE_BASE_URL, which must specify a
           directory. Only a [1mDACS [22madministrator may use this argument.

       [4mFORMAT[0m
           By default, or if the value of the [34m[4mFORMAT[24m argument[0m[14] is FILE, the
           new card is sent directly to the user's browser (which should
           automatically invoke the user's Identity Selector); no copy is
           retained on the server. If [4mFORMAT[24m is HTML, the new managed InfoCard
           is stored in a file, replacing any existing card of the same name
           (see [34m[1mINFOCARD_CARD_OUTPUTDIR[0m[1m[22m[15]). Output is emitted in HTML and
           includes a link to the file (see [34m[1mINFOCARD_CARDID_BASE_URL[0m[1m[22m[16]).
           Only the owner of new card should be able to access it.

       [4mINFOCARD_IDENTITY[0m
           Normally, this argument is omitted and the managed InfoCard is
           created on behalf of the identity that is invoking
           [1mdacs_managed_infocard[22m. This argument allows a [1mDACS [22madministrator to
           create a card for a specific identity.

       [4mMODE[0m
           This optional argument is used to select how [34m[1mclaim information[0m[1m[22m[17]
           is stored and retrieved. Four values are recognized:

           DACS
               In this usage mode, which is the default, claims are defined
               and filled depending on [1mDACS [22mconfiguration:

               +o   if both [34m[1mINFOCARD_CARD_DEFS_URL[0m[1m[22m[18] and
                   [34m[1mINFOCARD_CARD_FILL_URL[0m[1m[22m[19] are configured, the former web
                   service is called (once, by [1mdacs_managed_infocard[22m) to
                   define the claims that will be assigned to the new managed
                   InfoCard and the latter web service is called (by
                   [34m[1mdacs_sts(8)[0m[1m[22m[7], each time the InfoCard is used) to obtain
                   the values of those claims (or the requested and approved
                   subset). The claim definitions may not be modified, but
                   claim values do not need to be static.

               +o   if neither of those web services are configured, a minimal
                   set of claims is automatically defined to facilitate
                   authentication.

               +o   any other configuration is invalid
                   An identity is always associated with these InfoCards using
                   a claim named dacs_identity in the [1mDACS [22mnamespace
                   (http://dacs.dss.ca/claims). By default, the identity used
                   is that of the requestor. An administrator may instead
                   specify the identity using the [4mINFOCARD_IDENTITY[24m argument,
                   which need only be a syntactically valid [1mDACS [22midentity.

               STATIC
                   In this mode, the caller of [1mdacs_managed_infocard [22mdefines
                   the claims and their values when the card is created; [1mDACS[0m
                   is responsible for storing this information and producing
                   secure tokens from it. Unlike the DACS mode, the values of
                   these claims cannot be changed; a future release may
                   implement this capability.

                   The caller may specify from zero to a compile-time maximum
                   number of claims (MIC_MAX_STATIC_CLAIMS, [1m10[22m). A
                   privatepersonalidentifier (PPID) is always created
                   automatically, so any user request for that claim is
                   ignored. Only a [1mDACS [22madministrator may define the
                   dacs_identity claim in the [1mDACS [22mnamespace; if present, it
                   must be a syntactically valid [1mDACS [22midentity. Therefore,
                   only a [1mDACS [22madministrator may use this mode to create an
                   InfoCard that can be used for [1mDACS [22mauthentication.
                   Similiarly, only a [1mDACS [22madministrator may define the
                   dacs_roles claim in the [1mDACS [22mnamespace; if present, it must
                   be a syntactically valid [34m[1mrole descriptor string[0m[1m[22m[20].

                   The claims are specified by up to MIC_MAX_STATIC_CLAIMS
                   arguments (not counting any PPID claims) of the form
                   CLAIM_[4mnum[24m_[4mtype[24m, where [4mnum[24m starts at one and continues with
                   consecutive integers and [4mtype[24m is:

                   +o   NAME for the name of the claim, which must consist of
                       between one and MIC_MAX_STATIC_NAME_CLAIM_SIZE ([1m32[22m)
                       characters valid in a URI path segment.

                   +o   VALUE is the value associated with the claim and
                       consists of between one and
                       MIC_MAX_STATIC_VALUE_CLAIM_SIZE ([1m64[22m) printable
                       characters.

                   +o   URI is the URI namespace with which NAME is associated;
                       for convenience, "standard" signifies the self-issued
                       InfoCard namespace
                       (http://schemas.xmlsoap.org/ws/2005/05/identity/claims),
                       and "dacs" is short for the [1mDACS [22mnamespace
                       (http://dacs.dss.ca/claims); any other non-empty string
                       can be any syntactically valid URI of up to
                       MIC_MAX_STATIC_URI_CLAIM_SIZE ([1m128[22m), and an empty
                       string indicates that the default URI should be used.

                           [1mNote[0m
                           The [1mDACS [22mnamespace is reserved for use by [1mDACS [22mand
                           identifies claim types with semantics that are
                           defined by [1mDACS[22m.

                   +o   LABEL is a string that an Identity Selector should
                       display with the claim and consists of between one and
                       MIC_MAX_STATIC_LABEL_CLAIM_SIZE ([1m20[22m) printable
                       characters.

                   +o   DESC is a string that an Identity Selector should
                       display with the claim and consists of between one and
                       MIC_MAX_STATIC_DESC_CLAIM_SIZE ([1m40[22m) printable
                       characters; if missing or the empty string, the value
                       of the corresponding LABEL argument is used.

                       The optional argument [4mCLAIM_URI[24m has the same syntax as
                       a CLAIM_[4mnum[24m_URI argument and establishes a default URI
                       that will be used if any CLAIM_[4mnum[24m_URI argument is
                       missing or is the empty string.

                       The optional argument [4mCARD_NAME[24m assigns a name to the
                       InfoCard, which will be displayed by an Identity
                       Selector.

                       The first missing or null-string-valued CLAIM_[4mnum[24m_NAME
                       or CLAIM_[4mnum[24m_VALUE argument indicates the end of the
                       list. For example, if two claims are defined, the
                       following arguments might be passed: [4mCLAIM_1_NAME[24m,
                       [4mCLAIM_1_VALUE[24m, [4mCLAIM_1_URI[24m, [4mCLAIM_1_LABEL[24m,
                       [4mCLAIM_1_DESC[24m, [4mCLAIM_2_NAME[24m, [4mCLAIM_2_VALUE[24m, [4mCLAIM_2_URI[24m,
                       [4mCLAIM_2_LABEL[24m, and [4mCLAIM_2_DESC[24m. Any syntactical or
                       length violation causes a fatal error.

                   ISTATIC
                       This mode is identical to the STATIC mode except that
                       if it is used by an identity other than a [1mDACS[0m
                       administrator, a dacs_identity claim in the dacs
                       namespace is automatically added with the value of the
                       caller's identity. The InfoCard may be used for [1mDACS[0m
                       authentication.

                   DYNAMIC
                       The caller of [1mdacs_managed_infocard [22mprovides URLs for
                       two web services: one to define claims and another to
                       fill claims. The caller is responsible for managing
                       claim definitions and values. These web services are
                       expected to behave exactly the same as those that are
                       specified by [34m[1mINFOCARD_CARD_DEFS_URL[0m[1m[22m[18] and
                       [34m[1mINFOCARD_CARD_FILL_URL[0m[1m[22m[19]. This mode is not
                       implemented.


[1mFILES[0m
       [34m[1mdacs_managed_infocard.css[0m[1m[22m[21]

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       It is currently not possible to just register a managed InfoCard (you
       must create and register it), so you cannot import a card.

       This functionality should probably be integrated with
       [34m[1mdacs_infocard(8)[0m[1m[22m[3] (and [34m[1mdacsinfocard(1)[0m[1m[22m[4]).

       Once a managed InfoCard is created, most of its characteristics cannot
       be changed. There should be a way to "refresh" a managed InfoCard that
       has expired or otherwise become invalid.

       The various constraints on claim types should probably be run-time
       configurable, or possibly done away with altogether. The specification
       imposes no limits on them.

       There should be a web service and utility to allow creation of a
       self-issued InfoCard (which may then be imported into a user's Identity
       Selector).

       In 2011, Microsoft [34m[1mannounced[0m[1m[22m[22] that Windows CardSpace 2.0 will not be
       shipped and they will offer a new technology called U-Prove.

[1mSEE ALSO[0m
       [34m[1mdacsinfocard(1)[0m[1m[22m[4], [34m[1mdacs.conf(5)[0m[1m[22m[23], [34m[1mdacs_authenticate(8)[0m[1m[22m[24],
       [34m[1mdacs_infocard(8)[0m[1m[22m[3], [34m[1mdacs_mex(8)[0m[1m[22m[25], [34m[1mdacs_sts(8)[0m[1m[22m[7], [34m[1mUsing InfoCards[0m
       [1m[34mWith DACS[0m[1m[22m[26]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[27])

[1mCOPYING[0m
       Copyright (C) 2003-2018 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[28] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

        3. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html

        4. dacsinfocard(1)
           http://dacs.dss.ca/man/dacsinfocard.1.html

        5. configuration directives
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_prefixed

        6. INFOCARD_STS_AUTH_TYPE
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_STS_AUTH_TYPE

        7. dacs_sts(8)
           http://dacs.dss.ca/man/dacs_sts.8.html

        8. INFOCARD_STS_PASSWORD_METHOD
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_STS_PASSWORD_METHOD

        9. dacs_managed_infocard(8)
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html

       10. INFOCARD_CARD_IMAGE_BASE_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARD_IMAGE_BASE_URL

       11. printf(3)
           https://www.freebsd.org/cgi/man.cgi?query=printf&apropos=0&sektion=3&manpath=FreeBSD+10.3-RELEASE&format=html

       12. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       13. VFS URI
           http://dacs.dss.ca/man/#VFS

       14. [4mFORMAT[24m argument
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

       15. INFOCARD_CARD_OUTPUTDIR
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARD_OUTPUTDIR

       16. INFOCARD_CARDID_BASE_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARDID_BASE_URL

       17. claim information
           http://dacs.dss.ca/man/dacs_infocard.8.html#about_claims

       18. INFOCARD_CARD_DEFS_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARD_DEFS_URL

       19. INFOCARD_CARD_FILL_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARD_FILL_URL

       20. role descriptor string
           http://dacs.dss.ca/man/dacs.1.html#roles

       21. dacs_managed_infocard.css
           http://dacs.dss.ca/man//css/dacs_managed_infocard.css

       22. announced
           http://blogs.msdn.com/b/card/archive/2011/02/15/beyond-windows-cardspace.aspx

       23. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       24. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       25. dacs_mex(8)
           http://dacs.dss.ca/man/dacs_mex.8.html

       26. Using InfoCards With DACS
           http://dacs.dss.ca/man/using-infocards-with-dacs.html

       27. www.dss.ca
           http://www.dss.ca

       28. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.40                       02/01/2018           DACS_MANAGED_INFOCAR(8)
