{-# OPTIONS -w #-}
{- Workaround.hs

This file was created automatically by configure.  We disable warnings to
avoid issues with duplicate imports.

-}

module Workaround(
           openFd,
installHandler, raiseSignal, Handler(..), Signal,
                         sigINT, sigHUP, sigABRT, sigALRM, sigTERM, sigPIPE,
           getCurrentDirectory,
           createLink,
           createDirectoryIfMissing,
           renameFile,
           bracketOnError,
           fileMode, getFileStatus, setFileMode,
           setExecutable,
 ) where

import qualified GHC.Handle ( openFd )
import System.IO ( Handle, IOMode )
import System.Posix.Internals ( FDType )

import System.Posix.Signals(installHandler, raiseSignal, Handler(..), Signal,
                         sigINT, sigHUP, sigABRT, sigALRM, sigTERM, sigPIPE,)
import System.Directory(getCurrentDirectory)
import System.Posix.Files( createLink )
import System.Directory(createDirectoryIfMissing)
import System.Directory ( renameFile )
import Control.Exception( bracketOnError )
import System.Posix.Files(fileMode,getFileStatus,setFileMode)

import System.Posix.Files (fileMode,getFileStatus, setFileMode, nullFileMode,
                           setFileCreationMask,
                           ownerReadMode, ownerWriteMode, ownerExecuteMode,
                           groupReadMode, groupWriteMode, groupExecuteMode,
                           otherReadMode, otherWriteMode, otherExecuteMode)
import Data.Bits ( (.&.), (.|.), complement )

setExecutable :: FilePath -> Bool -> IO ()
setExecutable f ex =
  do st <- getFileStatus f
     umask <- setFileCreationMask 0
     setFileCreationMask umask
     let rw = fileMode st .&.
              (ownerReadMode .|. ownerWriteMode .|.
               groupReadMode .|. groupWriteMode .|.
               otherReadMode .|. otherWriteMode)
         total = if ex then rw .|.
                           ((ownerExecuteMode .|. groupExecuteMode .|. otherExecuteMode)
                            .&. complement umask)
                       else rw
     setFileMode f total


{-
Work around change in the GHC.Handle.openFd API.
-}
openFd :: Int -> Maybe FDType -> FilePath -> IOMode -> Bool -> Bool -> IO Handle
openFd fd x y z a b = GHC.Handle.openFd fd x b y z a

