#!/usr/bin/env perl

# issue174: behave better when we want to obliterate a patch that comes before a tag.

# Also work from the bugs/ directory
use lib 'lib/perl', '../tests/lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;

$ENV{EMAIL} = 'tester';
cleanup  'temp1';
mkpath 'temp1';
chdir  'temp1';
darcs 'init';

# Setup: Create a patch, a tag and another patch.
 touch qw/a.txt/;
 darcs "add a.txt";
 darcs "record -am 'adding a' a.txt";
 
 darcs "tag first tag";
 
 touch qw/b.txt/;
 darcs "add b.txt";
 darcs "record --ignore-time -a -m 'adding b' b.txt";

 unlike(darcs('obliterate -p "adding a" -a'),qr/no patch/i, "avoid no patch error");


chdir '../';
rm_rf 'temp1';
ok((!-d 'temp1'), 'temp1 directory was deleted');
