/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.Btree
{
	public class BTreeNodeTestCase : Db4objects.Db4o.Tests.Common.Btree.BTreeTestCaseBase
	{
		public static void Main(string[] args)
		{
			new Db4objects.Db4o.Tests.Common.Btree.BTreeNodeTestCase().RunSolo();
		}

		private readonly int[] keys = new int[] { -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 7, 9
			 };

		protected override void Db4oSetupAfterStore()
		{
			base.Db4oSetupAfterStore();
			Add(keys);
			Commit();
		}

		public virtual void TestLastKeyIndex()
		{
			Db4objects.Db4o.Internal.Btree.BTreeNode node = Node(3);
			Db4oUnit.Assert.AreEqual(1, node.LastKeyIndex(Trans()));
			Db4objects.Db4o.Internal.Transaction trans = NewTransaction();
			_btree.Add(trans, 5);
			Db4oUnit.Assert.AreEqual(1, node.LastKeyIndex(Trans()));
			_btree.Commit(trans);
			Db4oUnit.Assert.AreEqual(2, node.LastKeyIndex(Trans()));
		}

		private Db4objects.Db4o.Internal.Btree.BTreeNode Node(int value)
		{
			Db4objects.Db4o.Internal.Btree.IBTreeRange range = Search(value);
			System.Collections.IEnumerator i = range.Pointers();
			i.MoveNext();
			Db4objects.Db4o.Internal.Btree.BTreePointer firstPointer = (Db4objects.Db4o.Internal.Btree.BTreePointer
				)i.Current;
			Db4objects.Db4o.Internal.Btree.BTreeNode node = firstPointer.Node();
			node.DebugLoadFully(SystemTrans());
			return node;
		}

		public virtual void TestLastPointer()
		{
			Db4objects.Db4o.Internal.Btree.BTreeNode node = Node(3);
			Db4objects.Db4o.Internal.Btree.BTreePointer lastPointer = node.LastPointer(Trans(
				));
			AssertPointerKey(4, lastPointer);
		}
	}
}
