/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Tests.Common.CS
{
	public class CallConstructorsConfigTestCase : Db4oUnit.ITestCase
	{
		private const int PORT = unchecked((int)(0xdb40));

		public sealed class Item
		{
		}

		public virtual void Test()
		{
			Db4objects.Db4o.Config.IConfiguration config = Db4objects.Db4o.Db4oFactory.NewConfiguration
				();
			config.CallConstructors(true);
			config.ExceptionsOnNotStorable(true);
			Db4objects.Db4o.IObjectServer server = Db4objects.Db4o.Db4oFactory.OpenServer(config
				, DatabaseFile(), PORT);
			try
			{
				server.GrantAccess("db4o", "db4o");
				WithClient(new _AnonymousInnerClass30(this));
				WithClient(new _AnonymousInnerClass36(this));
			}
			finally
			{
				server.Close();
				Db4objects.Db4o.Foundation.IO.File4.Delete(DatabaseFile());
			}
		}

		private sealed class _AnonymousInnerClass30 : Db4objects.Db4o.Tests.Common.CS.CallConstructorsConfigTestCase.IClientBlock
		{
			public _AnonymousInnerClass30(CallConstructorsConfigTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run(Db4objects.Db4o.IObjectContainer client)
			{
				client.Set(new Db4objects.Db4o.Tests.Common.CS.CallConstructorsConfigTestCase.Item
					());
			}

			private readonly CallConstructorsConfigTestCase _enclosing;
		}

		private sealed class _AnonymousInnerClass36 : Db4objects.Db4o.Tests.Common.CS.CallConstructorsConfigTestCase.IClientBlock
		{
			public _AnonymousInnerClass36(CallConstructorsConfigTestCase _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run(Db4objects.Db4o.IObjectContainer client)
			{
				Db4oUnit.Assert.AreEqual(1, client.Query(typeof(Db4objects.Db4o.Tests.Common.CS.CallConstructorsConfigTestCase.Item)
					).Size());
			}

			private readonly CallConstructorsConfigTestCase _enclosing;
		}

		private string DatabaseFile()
		{
			return System.IO.Path.Combine(System.IO.Path.GetTempPath(), "cc.db4o");
		}

		public interface IClientBlock
		{
			void Run(Db4objects.Db4o.IObjectContainer client);
		}

		private void WithClient(Db4objects.Db4o.Tests.Common.CS.CallConstructorsConfigTestCase.IClientBlock
			 block)
		{
			Db4objects.Db4o.IObjectContainer client = Db4objects.Db4o.Db4oFactory.OpenClient(
				"localhost", PORT, "db4o", "db4o");
			try
			{
				block.Run(client);
			}
			finally
			{
				client.Close();
			}
		}
	}
}
