/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;

using Db4objects.Db4o;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Query;
using Db4objects.Db4o.Config;

/* 
 * Proxy object. Transfers TestValue object over the network
 * and stores it to db4o.
 */
namespace RemotingClasses
{
    public class TestValueServer: MarshalByRefObject
    {
        private TestValue _testValue;

        private const string Db4oFileName = "reference.db4o";

        public TestValue TestValue
        {
            get { return _testValue; }
            set { _testValue = value; }
        }
        // end TestValue
                
        public void StoreData()
        {
            // Store TestValue object to db4o
            File.Delete(Db4oFileName);
            IObjectContainer db = Database();
            try
            {
                db.Set(TestValue);
                db.Commit();
            }
            catch (Exception ex)
            {
                System.Console.WriteLine(ex.Message);
            }
            finally
            {
                db.Close();
            }
        }
        // end StoreData

        public string RetrieveData()
        {
            // Retrieve TestValue object and return its string representation
            IObjectContainer db = Database();
            try
            {
                IObjectSet result = db.Query(typeof(TestValue));
                System.Console.WriteLine(result.Count);
                if (result.Count > 0)
                {
                    return ((TestValue)result.Next()).GetData();
                }

            }
            catch (Exception ex)
            {
                System.Console.WriteLine(ex.Message);
            }
            finally
            {
                db.Close();
            }
            return "No results";
        }
        // end RetrieveData

        private static IObjectContainer Database()
        {
            IObjectContainer container = null;
            try
            {
                container = Db4oFactory.OpenFile(Db4oFileName);
            }
            catch (DatabaseFileLockedException ex)
            {
                System.Console.WriteLine(ex.Message);
            }
            return container;
        }
        // end Database
    }
}
