/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oUnit;
using Db4objects.Db4o;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Query;
using Db4objects.Db4o.Tests.Common.Api;
using Db4objects.Db4o.Tests.Common.References;

namespace Db4objects.Db4o.Tests.Common.References
{
	public class ReferenceSystemIsolationTestCase : TestWithTempFile
	{
		private static readonly string Username = "db4o";

		private static readonly string Password = "db4o";

		public class Item
		{
		}

		public virtual void Test()
		{
			IExtObjectServer server = Db4oFactory.OpenServer(Db4oFactory.NewConfiguration(), 
				TempFile(), -1).Ext();
			server.GrantAccess(Username, Password);
			IExtObjectContainer client = Db4oFactory.OpenClient(Db4oFactory.NewConfiguration(
				), "localhost", server.Port(), Username, Password).Ext();
			EmbeddedClientObjectContainer embeddedClient = (EmbeddedClientObjectContainer)server
				.OpenClient().Ext();
			try
			{
				ReferenceSystemIsolationTestCase.Item item = new ReferenceSystemIsolationTestCase.Item
					();
				client.Store(item);
				int id = (int)client.GetID(item);
				IQuery query = client.Query();
				query.Constrain(typeof(ReferenceSystemIsolationTestCase.Item));
				query.Constrain(new _IEvaluation_39());
				query.Execute();
				Assert.IsNull(embeddedClient.Transaction().ReferenceForId(id));
			}
			finally
			{
				embeddedClient.Close();
				client.Close();
				server.Close();
			}
		}

		private sealed class _IEvaluation_39 : IEvaluation
		{
			public _IEvaluation_39()
			{
			}

			public void Evaluate(ICandidate candidate)
			{
				candidate.Include(true);
			}
		}
	}
}
