% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbGetRowCount}
\alias{dbGetRowCount}
\title{The number of rows fetched so far}
\usage{
dbGetRowCount(res, ...)
}
\arguments{
\item{res}{An object inheriting from \code{\linkS4class{DBIResult}}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
a numeric vector of length 1
}
\description{
This value is increased by calls to \code{\link{dbFetch}}. For a data
modifying query, the return value is 0.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
rs <- dbSendQuery(con, "SELECT * FROM mtcars")

dbGetRowCount(rs)
ret1 <- dbFetch(rs, 10)
dbGetRowCount(rs)
ret2 <- dbFetch(rs)
dbGetRowCount(rs)
nrow(ret1) + nrow(ret2)

dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{SQL}}, \code{\link{dbBind}},
  \code{\link{dbClearResult}}, \code{\link{dbColumnInfo}},
  \code{\link{dbFetch}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}}
}

