#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

/***********************************************************/
/* get the position of the given string in the given array */
/***********************************************************/
/* output: -1 if not found, else index */
/***************************************/
static int str_array_idx(const GPtrArray *array, const char *str)
{
	int i;

	if((array==NULL)||(str==NULL))
		return -1;

	for(i=0;i<array->len;i++)
	{
		char *t;

		t=g_ptr_array_index(array,i);
		if(t&&(!strcmp(t,str)))
		{
			return i;
		}
	}
	return -1;
}

/***********************************************/
/* add the given string inside the given array */
/***********************************************/
GPtrArray *str_array_add(GPtrArray *array, char *str)
{
	if(array==NULL)
	{
		array=g_ptr_array_new();
		g_ptr_array_add(array,strdup(str));
	}
	else
	{
		/* check if str is not still in the array */
		if(str_array_idx(array,str)==-1)
		{
			g_ptr_array_add(array,strdup(str));
		}
	}
	return array;
}

/**************************************************/
/* remove the given string inside the given array */
/**************************************************/
GPtrArray *str_array_del(GPtrArray *array, char *str)
{
	if(array!=NULL)
	{
		int i;

		i=str_array_idx(array,str);

		if(i!=-1)
		{
			char *t;

			t=g_ptr_array_remove_index_fast(array,i);
			if(t!=NULL)
				free(t);
		}
	}
	return array;
}

/*************************************************/
/* check if the given string is inside the array */
/*************************************************/
/* output: FALSE=no, TRUE=yes */
/******************************/
int str_array_is_inside(GPtrArray *array, char *str)
{
	return (str_array_idx(array,str)!=-1);
}

/********************************************************/
/* delete all entries of the array and the array itself */
/********************************************************/
void str_array_destroy(GPtrArray *array)
{
	int i;

	if(array==NULL)
		return;

	for(i=0;i<array->len;i++)
	{
		char *t;

		t=g_ptr_array_remove_index_fast(array,i);
		if(t!=NULL)
			free(t);
	}
	g_ptr_array_free(array,TRUE);
}

