/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * notes_buffer.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: notes_buffer.c,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <gnome.h>

#include "main.h"
#include "misc_gtk.h"
#include "notes_buffer.h"

static void add_modification_handler_to_notes_text_buffer(GtkTextBuffer *gtb);

GString *dc_gui2_note_file=NULL;          /* name of the file containing the 'notes' = "$HOME/.dc_gui2/notes" */
														/* (value initialize by main() */

static int notes_buffer_is_dirty=FALSE;
/*************************************************************/
/* load the previously saved content into the notes_textview */
/*************************************************************/
void load_notes_text_buffer(void)
{
	GtkTextView *gtv;
	GtkTextBuffer *gtb;
	gchar *content;
	gsize length;
	GError *err=NULL;

	gtv=GTK_TEXT_VIEW(get_widget_by_widget_name(main_window,"notes_textview"));
	
	gtb=gtk_text_buffer_new(NULL);
	/* load the note_file content in the buffer */
	if(g_file_get_contents(dc_gui2_note_file->str,&content,&length,&err)==TRUE)
	{
		gtk_text_buffer_insert_at_cursor(gtb,content,length);
		g_free(content);
	}
	else
		g_error_free(err);
	gtk_text_view_set_buffer(gtv,gtb);
	g_object_unref(G_OBJECT(gtb));		/* remove the reference we own on the buffer */

	add_modification_handler_to_notes_text_buffer(gtb);
	notes_buffer_is_dirty=FALSE;
}

/*******************/
/* clear the notes */
/*******************/
void clear_notes_text_buffer(void)
{
	GtkTextView *gtv;
	GtkTextBuffer *gtb;

	gtv=GTK_TEXT_VIEW(get_widget_by_widget_name(main_window,"notes_textview"));
	
	gtb=gtk_text_buffer_new(NULL);
	gtk_text_view_set_buffer(gtv,gtb);
	g_object_unref(G_OBJECT(gtb));		/* remove the reference we own on the buffer */

	add_modification_handler_to_notes_text_buffer(gtb);
	notes_buffer_is_dirty=TRUE;
}

/**********************************/
/* "notes" buffer is set to dirty */
/**********************************/
void set_notes_buffer_to_dirty(void)
{
	notes_buffer_is_dirty=TRUE;
}

/*************************************************/
/* save the notes_textview into the "notes" file */
/*************************************************/
void save_notes_text_buffer(void)
{
	GtkTextBuffer *gtb;
	GtkTextIter iter_b,iter_e;
	int fd;
	gchar *content;

	if(!notes_buffer_is_dirty)		/* don't try to save clean "notes" buffer */
		return;

	fd=open(dc_gui2_note_file->str,O_CREAT|O_TRUNC|O_RDWR,0666);
	if(fd==-1)
	{
		gnome_app_error(GNOME_APP(main_window),_("Fail to create \"notes\" file"));
		return;
	}

	gtb=gtk_text_view_get_buffer(GTK_TEXT_VIEW(get_widget_by_widget_name(main_window,"notes_textview")));
	gtk_text_buffer_get_start_iter(gtb,&iter_b);
	gtk_text_buffer_get_end_iter(gtb,&iter_e);
	content=gtk_text_buffer_get_text(gtb,&iter_b,&iter_e,TRUE);
	if(content)
	{
		if(write(fd,content,strlen(content))!=strlen(content))
		{
			gnome_app_error(GNOME_APP(main_window),_("Fail to write \"notes\" file (Disk full ?)"));
		}
	}
	close(fd);
	g_free(content);
}

/************************************************************************/
/* to detect modification of the text buffer, we set a specific handler */
/************************************************************************/
/* the function must be called after each buffer swap */
/******************************************************/
static void add_modification_handler_to_notes_text_buffer(GtkTextBuffer *gtb)
{
	g_signal_connect (G_OBJECT (gtb), "changed",
                      GTK_SIGNAL_FUNC (set_notes_buffer_to_dirty),
                      NULL);
}


