<?php
/*
 * $Id: class.boPriorities.inc.php,v 1.2.2.1.2.1 2003/11/11 05:48:30 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('bo');

class boPriorities
{
	function showall()
	{
		commonHeader();
		$obj = CreateObject('dcl.htmlPriorities');
		$obj->PrintAll();
	}

	function add()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.htmlPriorities');
		$obj->ShowEntryForm();
	}

	function dbadd()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbPriorities');
		$obj->Connect();
		$obj->InitFromGlobals();
		$obj->Add();

		$objHTML = CreateObject('dcl.htmlPriorities');
		$objHTML->PrintAll();
	}

	function modify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbPriorities');
		$obj->Connect();
		$obj->Load($GLOBALS['id']);
		$objHTML = CreateObject('dcl.htmlPriorities');
		$objHTML->ShowEntryForm($obj);
	}

	function dbmodify()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbPriorities');
		$obj->Connect();
		$obj->InitFromGlobals();
		$obj->Edit();
		$objHTML = CreateObject('dcl.htmlPriorities');
		$objHTML->PrintAll();
	}
	function delete()
	{
		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.dbPriorities');
		$obj->Connect();
		$obj->Load($GLOBALS['id']);
		ShowDeleteYesNo('Priority', 'boPriorities.dbdelete', $obj->id, $obj->name);
	}

	function dbdelete()
	{
		$classSubName = 'Priorities';

		commonHeader();
		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$obj = CreateObject('dcl.db' . $classSubName);
		$obj->connect();
		$obj->Load($GLOBALS['id']);

		$objKey = new dclDB; // Don't really need anything fancy, 'spose...
		$noref = true;
		$objKey->connect($obj->conn);
		while ((list($table, $field) = each($obj->foreignKeys)) && $noref)
		{
			if (is_array($field)) // More than one field in here references this key
			{
				while ((list($dummykey, $onefield) = each($field)) && $noref)
				{
					$obj->Query("SELECT $onefield FROM $table WHERE $onefield=" . $GLOBALS['id']);
					if ($obj->next_record())
						$noref = false;
				}
			}
			else
			{
				$obj->Query("SELECT $field FROM $table WHERE $field=" . $GLOBALS['id']);
				if ($obj->next_record())
					$noref = false;
			}
		}

		if ($noref)
		{
			$obj->Delete();
			print(STR_BO_DELETED);
		}
		else
		{
			$obj->SetActive(false);
			print(STR_BO_DEACTIVATED);
		}

		$objHTML = CreateObject('dcl.html' . $classSubName);
		$objHTML->PrintAll();
	}
}
?>
