<?php
/*
 * $Id: class.dbActions.inc.php,v 1.2 2001/09/23 21:33:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbActions extends dclDB
{
	var $id;
	var $short;
	var $name;
	var $active;

	function dbActions()
	{
           // Table Fields
		$this->fieldArray = array('id', 'short', 'name', 'active');

           // Foreign keys
		$this->foreignKeys = array('timecards' => 'action');

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('actions');
		$query = 'INSERT INTO actions (';
		if ($idSQL != '')
			$query .= 'id,';
		$query .= 'short,name,active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= '\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->name) . '\',\'Y\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_ACTIONINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE actions SET ';
		$query .= 'short=\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= 'name=\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= 'active=\'' . $this->active . '\'';
		$query .= ' WHERE id=' . $this->id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM actions WHERE id=' . $this->id;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE actions SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE id=' . $this->id;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->id = $this->f('id');
			$this->short = trim($this->f('short'));
			$this->name = trim($this->f('name'));
			$this->active = $this->f('active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM actions WHERE id=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->id = 0;
		$this->short = '';
		$this->name = '';
		$this->active = '';
	}
}
?>
