<?php
/*
 * $Id: class.dbFaqtopics.inc.php,v 1.2.4.2 2003/11/05 05:43:22 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbFaqtopics extends dclDB
{
	var $topicid;
	var $seq;
	var $faqid;
	var $name;
	var $description;
	var $createby;
	var $createon;
	var $modifyby;
	var $modifyon;
	var $active;

	function dbFaqtopics()
	{
           // Table Fields
		$this->fieldArray = array(
				'topicid',
				'seq',
				'faqid', 
				'name', 
				'description', 
				'createby', 
				'createon', 
				'modifyby', 
				'modifyon', 
				'active');

           // Foreign keys
		$this->foreignKeys = array('faqquestions' => 'topicid');

		$this->cache = array();
		$this->cacheEnabled = false;

		$this->dclDB();
	}

	function Add()
	{
		$this->AdjustSeq($this->seq);

		$idSQL = $this->GetNewIDSQLForTable('faqtopics');
		$query = 'INSERT INTO faqtopics (';
		if ($idSQL != '')
			$query .= 'topicid,';
		$query .= 'seq,faqid,name,description,createby,createon,active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= $this->seq . ',';
		$query .= $this->faqid . ',';
		$query .= '\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->description) . '\',';
		$query .= $this->DBAddSlashes($this->createby) . ',';
		$query .= $this->GetDateSQL() . ',';
		$query .= '\'Y\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_FAQTOPICINSERTERR, $query) . '<BR>';
		}
	}

	function AdjustSeq($fromThisSeq, $editID = 0)
	{
		$query = "SELECT topicid FROM faqtopics WHERE seq=$fromThisSeq and faqid=" . $this->faqid;
		if ($editID > 0)
			$query .= " AND topicid != $editID";
		$this->Query($query);
           // There is one with this weight and not this ID, so adjust it
		if ($this->next_record())
		{
			$thisID = $this->f('topicid');
			$this->FreeResult();
			$this->AdjustSeq($fromThisSeq + 1);
			$query = "UPDATE faqtopics SET seq=seq+1 WHERE topicid=$thisID";
			$this->Execute($query);
		}
	}

	function Edit()
	{
		$this->AdjustSeq($this->seq, $this->topicid);

		$query = 'UPDATE faqtopics SET ';
		$query .= 'seq=' . $this->seq . ',';
		$query .= 'faqid=' . $this->faqid . ',';
		$query .= 'name=\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= 'description=\'' . $this->DBAddSlashes($this->description) . '\',';
		$query .= 'modifyby=' . $this->modifyby . ',';
		$query .= 'modifyon=' . $this->GetDateSQL() . ',';
		$query .= 'active=\'' . $this->active . '\'';
		$query .= ' WHERE topicid=' . $this->topicid;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM faqtopics WHERE topicid=' . $this->topicid;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE faqtopics SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE topicid=' . $this->topicid;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->topicid = $this->f('topicid');
			$this->seq = $this->f('seq');
			$this->faqid = $this->f('faqid');
			$this->name = trim($this->f('name'));
			$this->description = trim($this->f('description'));
			$this->createby = $this->f('createby');
			$this->createon = $this->FormatTimestampForDisplay($this->f('createon'));
			$this->modifyby = $this->f('modifyby');
			$this->modifyon = $this->FormatTimestampForDisplay($this->f('modifyon'));
			$this->active = $this->f('active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->topicid);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT topicid, seq, faqid, name, description, createby, ';
		$sql .= $this->ConvertTimestamp('createon', 'createon');
		$sql .= ', modifyby, ';
		$sql .= $this->ConvertTimestamp('modifyon', 'modifyon');
		$sql .= ", active FROM faqtopics WHERE topicid=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function LoadByFaqID($id, $orderby = 'seq')
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT topicid, seq, faqid, name, description, createby, ';
		$sql .= $this->ConvertTimestamp('createon', 'createon');
		$sql .= ', modifyby, ';
		$sql .= $this->ConvertTimestamp('modifyon', 'modifyon');
		$sql .= ", active FROM faqtopics WHERE faqid=$id";
		if ($orderby != '')
			$sql .= " ORDER BY $orderby";

		if (!$this->Query($sql))
			return -1;

		return 1;
	}

	function Clear()
	{
		$this->topicid = 0;
		$this->seq = 0;
		$this->faqid = 0;
		$this->name = '';
		$this->description = '';
		$this->createby = 0;
		$this->createon = '';
		$this->modifyby = 0;
		$this->modifyon = '';
		$this->active = '';
	}
}
?>
