<?php
/*
 * $Id: class.dbSccsXref.inc.php,v 1.1.2.1 2003/08/11 03:47:07 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbSccsXref extends dclDB
{
	var $dcl_entity_type_id;
	var $dcl_entity_id;
	var $dcl_entity_id2;
	var $dcl_sccs_id;
	var $personnel_id;
	var $sccs_project_path;
	var $sccs_file_name;
	var $sccs_version;
	var $sccs_comments;
	var $sccs_checkin_on;

	function dbSccsXref()
	{
		//Table Fields
		$this->fieldArray = array('dcl_entity_type_id', 'dcl_entity_id', 'dcl_entity_id2',
									'dcl_sccs_id', 'personnel_id', 'sccs_project_path', 'sccs_file_name',
									'sccs_version', 'sccs_comments', 'sccs_checkin_on');

		// Foreign keys
		$this->foreignKeys = array();

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		// TODO: dbSccsXref::Add
	}

	function Edit()
	{
		// TODO: dbSccsXref::Edit
	}

	function Delete($type, $id1, $id2 = 0)
	{
		// TODO: dbSccsXref::Delete
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->dcl_entity_type_id = $this->f('dcl_entity_type_id');
			$this->dcl_entity_id = $this->f('dcl_entity_id');
			$this->dcl_entity_id2 = $this->f('dcl_entity_id2');
			$this->dcl_sccs_id = $this->f('dcl_sccs_id');
			$this->personnel_id = $this->f('personnel_id');
			$this->sccs_project_path = $this->f('sccs_project_path');
			$this->sccs_file_name = $this->f('sccs_file_name');
			$this->sccs_version = $this->f('sccs_version');
			$this->sccs_comments = $this->f('sccs_comments');
			$this->sccs_checkin_on = $this->FormatTimestampForDisplay($this->f('sccs_checkin_on'));
		}
		else
			$this->Clear();
	}

	function ListChangeLog($type, $id1, $id2 = 0)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT sccs_descr, personnel.short, sccs_project_path, sccs_file_name, ';
		$sql .= 'sccs_version, sccs_comments, ';
		$sql .= $this->ConvertTimestamp('sccs_checkin_on', 'sccs_checkin_on');
		$sql .= " FROM dcl_sccs_xref, dcl_sccs, personnel WHERE dcl_entity_type_id=$type AND ";
		$sql .= "dcl_entity_id = $id1 and dcl_entity_id2 = $id2 AND dcl_sccs_xref.dcl_sccs_id = dcl_sccs.dcl_sccs_id ";
		$sql .= " AND dcl_sccs_xref.personnel_id = personnel.id ";
		$sql .= 'ORDER BY sccs_descr, sccs_project_path, sccs_file_name, sccs_version';
		if (!$this->Query($sql))
			return -1;

		return 1;
	}

	function Clear()
	{
		$this->dcl_entity_type_id = 0;
		$this->dcl_entity_id = 0;
		$this->dcl_entity_id2 = 0;
		$this->dcl_sccs_id = 0;
		$this->personnel_id = 0;
		$this->sccs_project_path = '';
		$this->sccs_file_name = '';
		$this->sccs_version = '';
		$this->sccs_comments = '';
		$this->sccs_checkin_on = '';
	}
}
?>
