<?php
/*
 * $Id: class.dbTicketresolutions.inc.php,v 1.3.4.2 2003/05/30 03:56:39 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');

class dbTicketresolutions extends dclDB
{
	var $resid;
	var $ticketid;
	var $loggedby;
	var $loggedon;
	var $status;
	var $resolution;
	var $startedon;

	function dbTicketresolutions()
	{
			// Table Fields
		$this->fieldArray = array(
				'resid',
				'ticketid', 
				'loggedby', 
				'loggedon', 
				'status', 
				'resolution',
				'startedon');

			// Foreign keys
		$this->foreignKeys = array();

		$this->cacheEnabled = false;
		$this->dclDB();
	}

	function Add()
	{
		global $dcl_domain_info, $dcl_domain;

		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$idSQL = $this->GetNewIDSQLForTable('ticketresolutions');
		$query  = 'INSERT INTO ticketresolutions (';
		if ($idSQL != '')
			$query .= 'resid,';
		$query .= 'ticketid,loggedon,loggedby,status,resolution,startedon) VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= $this->ticketid . ',';
		$query .= $this->GetDateSQL() . ',';
		$query .= $this->loggedby . ',';
		$query .= $this->status . ',';
		$query .= '\'' . $this->DBAddSlashes($this->resolution) . '\',';
		$query .= $this->DisplayToSQL($this->startedon) . ')';

		if ($this->Insert($query) == -1)
			echo sprintf(STR_DB_TICKETINSERTERR, $query);
		else
		{
			if ($this->Load($this->GetLastInsertID('ticketresolutions')) == -1)
				printf(STR_DB_TICKETBYOIDERR, $this->oid);
		}
	}

	function Edit()
	{
		$query = 'UPDATE ticketresolutions SET ';
		$query .= 'status=' . $this->status . ',';
		$query .= 'resolution=\'' . $this->DBAddSlashes($this->resolution) . '\'';
		$query .= ' WHERE resid=' . $this->resid;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM ticketresolutions WHERE resid=' . $this->resid;
		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->resid = $this->f('resid');
			$this->ticketid = $this->f('ticketid');
			$this->loggedby = $this->f('loggedby');
			$this->loggedon = $this->FormatTimestampForDisplay($this->f('loggedon'));
			$this->status = $this->f('status');
			$this->resolution = $this->f('resolution');
			$this->startedon = $this->FormatTimestampForDisplay($this->f('startedon'));
		}
		else
			$this->Clear();
	}

	function GetHoursText()
	{
		$start = new DCLTimestamp;
		$start->SetFromDB($this->f('startedon'));

		$end = new DCLTimestamp;
		$end->SetFromDB($this->f('loggedon'));

		$tempHours = ($end->time - $start->time);
		$hh = intval($tempHours / 3600);
		$tempHours -= ($hh * 3600);
		$mm = intval($tempHours / 60);
		$tempHours -= ($mm * 60);
		$ss = intval($tempHours);

		return sprintf('%02d:%02d:%02d', $hh, $mm, $ss);
	}

	function Load($resid)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT resid, ticketid, loggedby, ';
		$sql .= $this->ConvertTimestamp('loggedon', 'loggedon');
		$sql .= ', status, resolution, ';
		$sql .= $this->ConvertTimestamp('startedon', 'startedon');
		$sql .= " FROM ticketresolutions WHERE resid=$resid";
		if (!$this->Query($sql))
			return -1;

		if (!$this->next_record())
			return -1;

		return $this->GetRow();
	}

	function GetResolutions($ticketid)
	{
		global $dcl_info;

		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT resid, ticketid, loggedby, ';
		$sql .= $this->ConvertTimestamp('loggedon', 'loggedon');
		$sql .= ', status, resolution, ';
		$sql .= $this->ConvertTimestamp('startedon', 'startedon');
		$sql .= " FROM ticketresolutions WHERE ticketid=$ticketid ORDER BY resid " . $dcl_info['DCL_TIME_CARD_ORDER'];
		if (!$this->Query($sql))
			return -1;

		return 1;
	}

	function Clear()
	{
		$this->resid = 0;
		$this->ticketid = 0;
		$this->loggedby = 0;
		$this->loggedon = '';
		$this->status = 0;
		$this->resolution = '';
		$this->startedon = '';
	}
}
?>
