<?php
	/*
	 * $Id: class.htmlAgg.inc.php,v 1.1.2.4 2004/01/02 00:29:21 mdean Exp $
	 *
	 * Double Choco Latte - Source Configuration Management System
	 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
	 *
	 * This program is free software; you can redistribute it and/or
	 * modify it under the terms of the GNU General Public License
	 * as published by the Free Software Foundation; either version 2
	 * of the License, or (at your option) any later version.
	 *
	 * This program is distributed in the hope that it will be useful,
	 * but WITHOUT ANY WARRANTY; without even the implied warranty of
	 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 * GNU General Public License for more details.
	 *
	 * You should have received a copy of the GNU General Public License
	 * along with this program; if not, write to the Free Software
	 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	 *
	 * Select License Info from the Help menu to view the terms and conditions of this license.
	 */

LoadStringResource('wo');
LoadStringResource('tck');
LoadStringResource('menu'); // If we're framed, this isn't loaded every time
class htmlAgg
{
	var $group;
	var $sub;
	var $_aTypeInfo;

	function htmlAgg()
	{
		$this->group = IsSet($GLOBALS[GetSourceArray()]['group']) ? $GLOBALS[GetSourceArray()]['group'] : '';
		$this->sub = IsSet($GLOBALS[GetSourceArray()]['sub']) ? $GLOBALS[GetSourceArray()]['sub'] : '';

		$this->_aTypeInfo = array(
				'workorders' => array( // major group
					'__title__' => DCL_MENU_WORKORDERS,
					'account' => array( // what to aggregate
						'dcl_wo_account', // table to join
						'Accounts', // title
						'a.account_id', // major group field
						'ac.name', // minor group description
						'ac.id', // minor group key
						'' // Additional filter
						),
					'assigned' => array('personnel', STR_WO_RESPONSIBLE, 'w.responsible', 'a.short', 'a.id', ''),
					'reportto' => array('personnel', 'My Minions', 'w.responsible', 'a.short', 'a.id', 'a.reportto = ' . $GLOBALS['DCLID']),
					'product' => array('products', STR_WO_PRODUCT, 'w.product', 'a.name', 'a.id', ''),
					'priority' => array('priorities', STR_WO_PRIORITY, 'w.priority', 'a.name', 'a.id', ''),
					'severity' => array('severities', STR_WO_SEVERITY, 'w.severity', 'a.name', 'a.id', ''),
					'wo_type_id' => array('dcl_wo_type', STR_WO_TYPE, 'w.wo_type_id', 'a.type_name', 'a.wo_type_id', '')
				),
				'tickets' => array( // major group
					'__title__' => DCL_MENU_TICKETS,
					'account' => array( // what to aggregate
						'accounts', // table to join
						'Accounts', // title
						'w.account', // major group field
						'a.name', // minor group description
						'a.id', // minor group key
						'' // Additional filter
						),
					'assigned' => array('personnel', STR_TCK_RESPONSIBLE, 'w.responsible', 'a.short', 'a.id', ''),
					'reportto' => array('personnel', 'My Minions', 'w.responsible', 'a.short', 'a.id', 'a.reportto = ' . $GLOBALS['DCLID']),
					'product' => array('products', STR_TCK_PRODUCT, 'w.product', 'a.name', 'a.id', ''),
					'priority' => array('priorities', STR_TCK_PRIORITY, 'w.priority', 'a.name', 'a.id', ''),
					'severity' => array('severities', STR_TCK_TYPE, 'w.severity', 'a.name', 'a.id', '')
				)
			);
	}

	function GetBox()
	{
	}

	function Init()
	{
		commonHeader();
		$this->ShowAggNav();
	}

	function ShowAggNav()
	{
		global $dcl_info;

		IncludeCalendar();

		$t = CreateTemplate(array('hForm' => 'htmlAggNav.tpl'));
		$t->set_block('hForm', 'group', 'hGroup');
		$t->set_block('hForm', 'sub', 'hSub');

		$t->set_var('hGroup', '');
		$t->set_var('hSub', '');

		$t->set_var('TXT_AGGREGATE', 'Aggregate');
		$t->set_var('TXT_BY', STR_CMMN_BY);
		$t->set_var('TXT_FORDATES', 'For Dates');

		reset($this->_aTypeInfo);
		while (list($key, $val) = each($this->_aTypeInfo))
		{
			$t->set_var('VAL_GROUP', $key);
			$t->set_var('VAL_GROUPDESC', $val['__title__']);
			$t->set_var('VAL_GROUPSELECTED', isset($GLOBALS[GetSourceArray()]['group']) && $GLOBALS[GetSourceArray()]['group'] == $key ? ' selected' : '');
			$t->parse('hGroup', 'group', true);
		}

		reset($this->_aTypeInfo);
		while (list($key, $val) = each($this->_aTypeInfo['workorders']))
		{
			if ($key == '__title__')
				continue;

			$t->set_var('VAL_SUB', $key);
			$t->set_var('VAL_SUBDESC', $val[1]);
			$t->set_var('VAL_SUBSELECTED', isset($GLOBALS[GetSourceArray()]['sub']) && $GLOBALS[GetSourceArray()]['sub'] == $key ? ' selected' : '');
			$t->parse('hSub', 'sub', true);
		}

		$t->set_var('VAL_FORMACTION', menuLink());
		$t->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());

		if (isset($GLOBALS[GetSourceArray()]['chkLimitByDate']) && $GLOBALS[GetSourceArray()]['chkLimitByDate'] == 1)
		{
			$t->set_var('VAL_DATEFROM', $GLOBALS[GetSourceArray()]['dateFrom']);
			$t->set_var('VAL_DATETO', $GLOBALS[GetSourceArray()]['dateTo']);
			$t->set_var('VAL_CHKLIMIT', ' checked');
		}
		else
		{
			$aFewDaysAgo = mktime(0, 0, 0, date('m'), date('d') - 1, date('Y'));
			$t->set_var('VAL_DATEFROM', date($dcl_info['DCL_DATE_FORMAT'], $aFewDaysAgo));
			$t->set_var('VAL_DATETO', date($dcl_info['DCL_DATE_FORMAT']));
			$t->set_var('VAL_CHKLIMIT', '');
		}

		$t->pparse('out', 'hForm');
	}

	function ShowReport()
	{
		$this->Init();

		$oDB = CreateObject('dcl.dbWorkorders');
		$oDB->Connect();
		$oDB->Query($this->_GetSQL());
		$aDetail = array();
		$i = -1;
		$last_id = -1;
		while ($oDB->next_record())
		{
			$id = $oDB->f(1);
			if ($id < 1)
				continue;

			if ($id != $last_id)
			{
				$aDetail[++$i] = array('0', '0', $oDB->f(2));
				$last_id = $id;
			}

			$link = 'menuAction=htmlAgg.Search&group=' . $this->group . '&sub=' . $this->sub . '&col=' . (string)($oDB->f(3) - 1) . '&item=' . $oDB->f(1);
			if (isset($GLOBALS[GetSourceArray()]['chkLimitByDate']) && $GLOBALS[GetSourceArray()]['chkLimitByDate'] == 1)
			{
				$link .= '&dateFrom=' . $GLOBALS[GetSourceArray()]['dateFrom'];
				$link .= '&dateTo=' . $GLOBALS[GetSourceArray()]['dateTo'];
				$link .= '&chkLimitByDate=1';
			}

			$aDetail[$i][$oDB->f(3) - 1] = '<a class="agreyu" href="' . menuLink('', $link) . '">' .  $oDB->f(0) . '</a>';
		}
		
		if (count($aDetail) < 1)
		{
			print('No Matches for Your Filter');
		}
		else
		{
			PrintArrayAsChocoTable(array('Open', 'Completed', $this->_aTypeInfo[$this->group][$this->sub][1]), $aDetail, '');
		}
	}

	function Search()
	{
		$this->Init();
		$aItems = $this->_aTypeInfo[$this->group][$this->sub];

		$objView = CreateObject('dcl.boView');
		$objView->style = 'report';
		$objView->title = 'Aggregate Search Results';
		$objView->table = $this->group;

		if ($this->group == 'workorders')
			$objView->AddDef('order', '', array('priorities.weight', 'severities.weight', 'jcn', 'seq'));
		else if ($this->group == 'tickets')
			$objView->AddDef('order', '', array('priorities.weight', 'severities.weight', 'ticketid'));

		$objView->AddDef('filter', 'statuses.dcl_status_type', $GLOBALS[GetSourceArray()]['col'] + 1);
		
		if ($this->group == 'workorders' && $this->sub == 'account')
			$objView->AddDef('filter', 'dcl_wo_account.account_id', $GLOBALS[GetSourceArray()]['item']);
		else
			$objView->AddDef('filter', substr($aItems[2], 2), $GLOBALS[GetSourceArray()]['item']);
		
		if (isset($GLOBALS[GetSourceArray()]['dateFrom']) && isset($GLOBALS[GetSourceArray()]['dateTo']))
		{
			$field = $GLOBALS[GetSourceArray()]['col'] == 0 ? 'createdon' : 'closedon';
			$objView->AddDef('filterdate', $field, array($GLOBALS[GetSourceArray()]['dateFrom'], $GLOBALS[GetSourceArray()]['dateTo']));
		}

		if ($this->sub != 'product')
		{
			$objView->AddDef('groups', '', array('products.name'));

			if ($this->group == 'workorders')
			{
				$objView->AddDef('columns', '',
					array('jcn', 'seq', 'dcl_wo_type.type_name', 'responsible.short', 'statuses.name', 'eststarton', 'deadlineon',
						'etchours', 'totalhours', 'summary'));

				$objView->AddDef('columnhdrs', '',
					array('', STR_WO_JCN, STR_WO_SEQ, STR_WO_TYPE, STR_WO_RESPONSIBLE,
						STR_WO_STATUS, STR_WO_ESTSTART, STR_WO_DEADLINE, STR_WO_ETCHOURS, STR_WO_ACTHOURS, STR_WO_SUMMARY));
			}
			else
			{
				$objView->AddDef('columns', '',
					array('ticketid', 'responsible.short', 'statuses.name', 'summary'));

				$objView->AddDef('columnhdrs', '',
					array(STR_TCK_TICKETID, STR_TCK_RESPONSIBLE, STR_WO_STATUS, STR_WO_SUMMARY));
			}
		}
		else
		{
			$objView->AddDef('groups', '', array('responsible.short'));

			if ($this->group == 'workorders')
			{
				$objView->AddDef('columns', '',
					array('jcn', 'seq', 'dcl_wo_type.type_name', 'products.name', 'statuses.name', 'eststarton', 'deadlineon',
						'etchours', 'totalhours', 'summary'));

				$objView->AddDef('columnhdrs', '',
					array('', STR_WO_JCN, STR_WO_SEQ, STR_WO_TYPE, STR_WO_PRODUCT,
						STR_WO_STATUS, STR_WO_ESTSTART, STR_WO_DEADLINE, STR_WO_ETCHOURS, STR_WO_ACTHOURS, STR_WO_SUMMARY));
			}
			else
			{
				$objView->AddDef('columns', '',
					array('ticketid', 'responsible.short', 'statuses.name', 'products.name', 'summary'));

				$objView->AddDef('columnhdrs', '',
					array(STR_TCK_TICKETID, STR_TCK_RESPONSIBLE, STR_TCK_STATUS, STR_TCK_PRODUCT, STR_TCK_SUMMARY));
			}
		}

		$obj = CreateViewObject($this->group);
		$obj->Render($objView);
	}

	function _GetSQL()
	{
		$aItems = $this->_aTypeInfo[$this->group][$this->sub];
		$orderby = (IsSet($GLOBALS[GetSourceArray()]['order']) && $GLOBALS[GetSourceArray()]['order'] == 'count') ? 'count(*)' : $aItems[3];

		$sql = sprintf('select count(*), %s, %s, t.dcl_status_type_id, t.dcl_status_type_name from ', $aItems[2], $aItems[3]);
		$sql .= sprintf('%s a, %s w, dcl_status_type t, statuses s', $aItems[0], $this->group);

		if ($this->group == 'workorders' && $this->sub == 'account')
			$sql .= ', accounts ac';

		$sql .= sprintf(' where %s = %s ', $aItems[4], $aItems[2]);
		if ($this->group == 'workorders' && $this->sub == 'account')
			$sql .= ' AND w.jcn = a.wo_id AND w.seq = a.seq ';

		$sql .= 'and w.status = s.id and s.dcl_status_type = t.dcl_status_type_id and ';
		if (isset($GLOBALS['chkLimitByDate']) && $GLOBALS['chkLimitByDate'] == 1)
		{
			global $dateFrom, $dateTo;
			
			$oDB = new dclDB; // for sql side date formatting

			$sql .= '((t.dcl_status_type_id = 1 and w.createdon between ' . $oDB->DisplayToSQL($dateFrom) . ' and ' . $oDB->DisplayToSQL($dateTo) . ') or ';
			$sql .= '(t.dcl_status_type_id = 2 and w.closedon between ' . $oDB->DisplayToSQL($dateFrom) . ' and ' . $oDB->DisplayToSQL($dateTo) . ')) ';
		}
		else
			$sql .= 't.dcl_status_type_id != 3 ';

		if ($aItems[5] != '')
			$sql .= ' and (' . $aItems[5] . ') ';

		$sql .= sprintf('group by %s, %s, t.dcl_status_type_id, t.dcl_status_type_name order by %s', $aItems[2], $aItems[3], $orderby);

		return $sql;
	}
}
?>
