<?php
/*
 * $Id: class.htmlSelector.inc.php,v 1.1.2.1 2003/04/19 23:42:25 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

class htmlSelector
{
	var $vDefault;
	var $t;
	var $oDB;

	function htmlSelector()
	{
		$_SRC = GetSourceArray();
		if (isset($GLOBALS[$_SRC]['initSelected']))
			$this->vDefault = explode(',', $GLOBALS[$_SRC]['initSelected']);
		else
			$this->vDefault = array();
			
		$this->oDB = null;
	}

	function GetHTML()
	{
		global $dcl_info;

		$this->t = CreateTemplate(array('hForm' => 'htmlSelector.tpl'));
		$this->t->set_block('hForm', 'avail', 'hAvail');
		$this->t->set_block('hForm', 'sel', 'hSel');

		$this->t->set_var('hAvail', '');
		$this->t->set_var('hSel', '');

		$this->t->set_var('TXT_TITLE', 'Select Accounts');
		$this->t->set_var('TXT_AVAILABLE', 'Available');
		$this->t->set_var('TXT_SELECTED', 'Selected');
		$this->t->set_var('TXT_SAVE', STR_CMMN_SAVE);
		$this->t->set_var('TXT_CANCEL', STR_CMMN_CANCEL);
		$this->t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$this->t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

		switch ($GLOBALS[GetSourceArray()]['what'])
		{
			case 'accounts':
				$this->SetOptionsFromDb('accounts', 'id', 'name', "active='Y'", 'name');
				break;
			default:
				PrintPermissionDenied();
				return "";
		}

		return $this->t->parse('out', 'hForm');
	}

	function Render()
	{
		echo $this->GetHTML();
	}

	function SetOptionsFromDb($table, $keyField, $valField, $filter = '', $order = '')
	{
		if ($this->oDB == NULL)
		{
			$this->oDB = new dclDB;
			$this->oDB->Connect();
		}

		$sql = "select $keyField, $valField From $table";
		if ($filter != '')
			$sql .= ' Where ' . $filter;

		if ($order == '')
			$sql .= " Order By $valField";
		else
			$sql .= ' Order By ' . $order;

		$oDB = CreateObject('dcl.dbWorkorders');
		$oDB->Connect();
		$oDB->Query($sql);
		while ($oDB->next_record())
		{
			$this->t->set_var('VAL_VALUE', $oDB->f(0));
			$this->t->set_var('VAL_TEXT', $oDB->f(1));

			$bSelected = ((is_array($this->vDefault) && in_array($oDB->f(0), $this->vDefault)) || (!is_array($this->vDefault) && $this->vDefault == $oDB->f(0)));
			if ($bSelected)
				$this->t->parse('hSel', 'sel', true);
			else
				$this->t->parse('hAvail', 'avail', true);
		}
	}

	function select()
	{
		$this->Render();
	}
}
?>
