*-----------------------------------------------------------------------
*     TMSTLN : THE ROUTINE FOR DRAWING STREAM LINES
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2017 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMSTLN( X, Y, U, V, NX, NY, 
     & TRX, TRY, NM )

      IMPLICIT NONE

      INTEGER NXZ
      PARAMETER (NXZ=10)
      INTEGER NYZ
      PARAMETER (NYZ=10)

*-- AGREENMENT
      INTEGER NX                  !* GRID NUMBERS FOR X-DIRECTION
      INTEGER NY                  !* GRID NUMBERS FOR Y-DIRECTION
      REAL    U(NX,NY)            !* VECTOR COMPONENT OF X-DIRECTION
      REAL    V(NX,NY)            !* VECTOR COMPONENT OF Y-DIRECTION
      REAL    X(NX)               !* GRID POINTS OF X-DIRECTION [UNIT:LENGTH]
      REAL    Y(NY)               !* GRID POINTS OF Y-DIRECTION [UNIT:LENGTH]
      REAL    TRX(2,NX*NY,*)  !* STREAM LINE OF X-COORDINATE
      REAL    TRY(2,NX*NY,*)  !* STREAM LINE OF Y-COORDINATE
      INTEGER NM(2,*)         !* ARRAY NUMBER IN EACH STREAM LINE

*-- INTERNAL VARIABLES
      INTEGER GRID_NUM(NXZ,NYZ)
      REAL    TMPX(NXZ*NYZ)
      REAL    TMPY(NXZ*NYZ)

      WRITE(*,*)"OTB:",NX,NXZ

      CALL TMZTLN( X, Y, U, V, NX, NY, TRX, TRY, NM
     & ,GRID_NUM,TMPX,TMPY )

      END SUBROUTINE TMSTLN

