#!/usr/bin/perl -w
#
# Generates cfrun.hosts from dhcpd.conf

$CFRUN = "/etc/cfengine/cfrun.hosts";
$DHCPD = "/etc/dhcp/dhcpd.conf";
$range = "";

# Test if cfrun.hosts already exists
if(-e $CFRUN || !(-e $DHCPD) )
{
	exit(0);
}
else
{
	# Get the range from dhcpd.conf
	open (FIL,$DHCPD) or die "Can't open $DHCPD !\n";
	$line = <FIL>;          # <FIL> return a line from the file    
	while ($line = <FIL>)   # <FIL> returning an empty string at file-end
  	{
  		if($line =~ /range (\d*\.\d*\.\d*\.\d*) (\d*\.\d*\.\d*\.\d*)/i)
   	{
   		$range .= "$1 $2\n"; 		
   	}
   }
   close(FIL);
   
   
    # Creating the file and writing domain and access variables ++
    `touch $CFRUN`;
    chomp($domainname=`/bin/dnsdomainname`); # ex: iu.hio.no
    
    open (OUT, ">$CFRUN") || die ("couldn't open $CFRUN");
    
    print OUT "# This file is generated by the script /etc/cfengine/cfrunhosts.pl\n";
    print OUT "# cfrun.hosts states which hosts will run when the command ::cfrun:: is given\n";
    print OUT "# This file makes it easy for systems using dhcp to utilize cfrun\n";
    print OUT "domain=$domainname\n";
    print OUT "access=root\n";
    print OUT "$range\n";
   
   close (OUT);
}
