## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Map/HTML: HTML output format data map
## ----------------------------------------------------------------------
## Copyright (C) 1999-2002 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
#package DebianDoc_SGML::Map::HTML;
#use strict;
#use vars qw( @ISA @EXPORT );
#use Exporter;
#@ISA = ( 'Exporter' );
#@EXPORT = qw ();

## ----------------------------------------------------------------------
%cdata = (
	  '<' => '&lt;',
	  '>' => '&gt;',
	  '&' => '&amp;',
	  '"' => '&quot;',
	  );

## ----------------------------------------------------------------------
%sdata = (

          ## ISO 8879:1986//ENTITIES Added Latin 1//EN
	  "[aacute]" => "\&aacute;",
	  "[Aacute]" => "\&Aacute;",
	  "[acirc ]" => "\&acirc;",
	  "[Acirc ]" => "\&Acirc;",
	  "[agrave]" => "\&agrave;",
	  "[Agrave]" => "\&Agrave;",
	  "[aring ]" => "\&aring;",
	  "[Aring ]" => "\&Aring;",
	  "[atilde]" => "\&atilde;",
	  "[Atilde]" => "\&Atilde;",
	  "[auml  ]" => "\&auml;",
	  "[Auml  ]" => "\&Auml;",
	  "[aelig ]" => "\&aelig;",
	  "[AElig ]" => "\&AElig;",
	  "[ccedil]" => "\&ccedil;",
	  "[Ccedil]" => "\&Ccedil;",
	  "[eth   ]" => "\&eth;",
	  "[ETH   ]" => "\&ETH;",
	  "[eacute]" => "\&eacute;",
	  "[Eacute]" => "\&Eacute;",
	  "[ecirc ]" => "\&ecirc;",
	  "[Ecirc ]" => "\&Ecirc;",
	  "[egrave]" => "\&egrave;",
	  "[Egrave]" => "\&Egrave;",
	  "[euml  ]" => "\&euml;",
	  "[Euml  ]" => "\&Euml;",
	  "[iacute]" => "\&iacute;",
	  "[Iacute]" => "\&Iacute;",
	  "[icirc ]" => "\&icirc;",
	  "[Icirc ]" => "\&Icirc;",
	  "[igrave]" => "\&igrave;",
	  "[Igrave]" => "\&Igrave;",
	  "[iuml  ]" => "\&iuml;",
	  "[Iuml  ]" => "\&Iuml;",
	  "[ntilde]" => "\&ntilde;",
	  "[Ntilde]" => "\&Ntilde;",
	  "[oacute]" => "\&oacute;",
	  "[Oacute]" => "\&Oacute;",
	  "[ocirc ]" => "\&ocirc;",
	  "[Ocirc ]" => "\&Ocirc;",
	  "[ograve]" => "\&ograve;",
	  "[Ograve]" => "\&Ograve;",
	  "[oslash]" => "\&oslash;",
	  "[Oslash]" => "\&Oslash;",
	  "[otilde]" => "\&otilde;",
	  "[Otilde]" => "\&Otilde;",
	  "[ouml  ]" => "\&ouml;",
	  "[Ouml  ]" => "\&Ouml;",
	  "[szlig ]" => "\&szlig;",
	  "[thorn ]" => "\&thorn;",
	  "[THORN ]" => "\&THORN;",
	  "[uacute]" => "\&uacute;",
	  "[Uacute]" => "\&Uacute;",
	  "[ucirc ]" => "\&ucirc;",
	  "[Ucirc ]" => "\&Ucirc;",
	  "[ugrave]" => "\&ugrave;",
	  "[Ugrave]" => "\&Ugrave;",
	  "[uuml  ]" => "\&uuml;",
	  "[Uuml  ]" => "\&Uuml;",
	  "[yacute]" => "\&yacute;",
	  "[Yacute]" => "\&Yacute;",
	  "[yuml  ]" => "\&yuml;",

          ## ISO 8879:1986//ENTITIES Added Latin 2//EN
	  "[abreve]" => "[abreve]",
	  "[Abreve]" => "[Abreve]",
	  "[amacr ]" => "[amacr]",
	  "[Amacr ]" => "[Amacr]",
	  "[aogon ]" => "[aogon]",
	  "[Aogon ]" => "[Aogon]",
	  "[cacute]" => "[cacute]",
	  "[Cacute]" => "[Cacute]",
	  "[ccaron]" => "[ccaron]",
	  "[Ccaron]" => "[Ccaron]",
	  "[ccirc ]" => "[ccirc]",
	  "[Ccirc ]" => "[Ccirc]",
	  "[cdot  ]" => "[cdot]",
	  "[Cdot  ]" => "[Cdot]",
	  "[dcaron]" => "[dcaron]",
	  "[Dcaron]" => "[Dcaron]",
	  "[dstrok]" => "[dstrok]",
	  "[Dstrok]" => "[Dstrok]",
	  "[ecaron]" => "[ecaron]",
	  "[Ecaron]" => "[Ecaron]",
	  "[edot  ]" => "[edot]",
	  "[Edot  ]" => "[Edot]",
	  "[emacr ]" => "[emacr]",
	  "[Emacr ]" => "[Emacr]",
	  "[eogon ]" => "[eogon]",
	  "[Eogon ]" => "[Eogon]",
	  "[gacute]" => "[gacute]",
	  "[gbreve]" => "[gbreve]",
	  "[Gbreve]" => "[Gbreve]",
	  "[Gcedil]" => "[Gcedil]",
	  "[gcirc ]" => "[gcirc]",
	  "[Gcirc ]" => "[Gcirc]",
	  "[gdot  ]" => "[gdot]",
	  "[Gdot  ]" => "[Gdot]",
	  "[hcirc ]" => "[hcirc]",
	  "[Hcirc ]" => "[Hcirc]",
	  "[hstrok]" => "[hstrok]",
	  "[Hstrok]" => "[Hstrok]",
	  "[Idot  ]" => "[Idot]",
	  "[Imacr ]" => "[Imacr]",
	  "[imacr ]" => "[imacr]",
	  "[ijlig ]" => "ij",
	  "[IJlig ]" => "IJ",
	  "[inodot]" => "[inodot]",
	  "[iogon ]" => "[iogon]",
	  "[Iogon ]" => "[Iogon]",
	  "[itilde]" => "[itilde]",
	  "[Itilde]" => "[Itilde]",
	  "[jcirc ]" => "[jcirc]",
	  "[Jcirc ]" => "[Jcirc]",
	  "[kcedil]" => "[kcedil]",
	  "[Kcedil]" => "[Kcedil]",
	  "[kgreen]" => "[kgreen]",
	  "[lacute]" => "[lacute]",
	  "[Lacute]" => "[Lacute]",
	  "[lcaron]" => "[lcaron]",
	  "[Lcaron]" => "[Lcaron]",
	  "[lcedil]" => "[lcedil]",
	  "[Lcedil]" => "[Lcedil]",
	  "[lmidot]" => "[lmidot]",
	  "[Lmidot]" => "[Lmidot]",
	  "[lstrok]" => "[lstrok]",
	  "[Lstrok]" => "[Lstrok]",
	  "[nacute]" => "[nacute]",
	  "[Nacute]" => "[Nacute]",
	  "[eng   ]" => "[eng]",
	  "[ENG   ]" => "[ENG]",
	  "[napos ]" => "n\&apos;",
	  "[ncaron]" => "[ncaron]",
	  "[Ncaron]" => "[Ncaron]",
	  "[ncedil]" => "[ncedil]",
	  "[Ncedil]" => "[Ncedil]",
	  "[odblac]" => "[odblac]",
	  "[Odblac]" => "[Odblac]",
	  "[omacr ]" => "[omacr]",
	  "[Omacr ]" => "[Omacr]",
	  "[oelig ]" => "\&oelig;",
	  "[OElig ]" => "\&OElig;",
	  "[racute]" => "[racute]",
	  "[Racute]" => "[Racute]",
	  "[rcaron]" => "[rcaron]",
	  "[Rcaron]" => "[Rcaron]",
	  "[rcedil]" => "[rcedil]",
	  "[Rcedil]" => "[Rcedil]",
	  "[sacute]" => "[sacute]",
	  "[Sacute]" => "[Sacute]",
	  "[scaron]" => "\&scaron;",
	  "[Scaron]" => "\&Scaron;",
	  "[scedil]" => "[scedil]",
	  "[Scedil]" => "[Scedil]",
	  "[scirc ]" => "[scirc]",
	  "[Scirc ]" => "[Scirc]",
	  "[tcaron]" => "[tcaron]",
	  "[Tcaron]" => "[Tcaron]",
	  "[tcedil]" => "[tcedil]",
	  "[Tcedil]" => "[Tcedil]",
	  "[tstrok]" => "[tstrok]",
	  "[Tstrok]" => "[Tstrok]",
	  "[ubreve]" => "[ubreve]",
	  "[Ubreve]" => "[Ubreve]",
	  "[udblac]" => "[udblac]",
	  "[Udblac]" => "[Udblac]",
	  "[umacr ]" => "[umacr]",
	  "[Umacr ]" => "[Umacr]",
	  "[uogon ]" => "[uogon]",
	  "[Uogon ]" => "[Uogon]",
	  "[uring ]" => "[uring]",
	  "[Uring ]" => "[Uring]",
	  "[utilde]" => "[utilde]",
	  "[Utilde]" => "[Utilde]",
	  "[wcirc ]" => "[wcirc]",
	  "[Wcirc ]" => "[Wcirc]",
	  "[ycirc ]" => "[ycirc]",
	  "[Ycirc ]" => "[Ycirc]",
	  "[Yuml  ]" => "\&Yuml;",
	  "[zacute]" => "[zacute]",
	  "[Zacute]" => "[Zacute]",
	  "[zcaron]" => "[zcaron]",
	  "[Zcaron]" => "[Zcaron]",
	  "[zdot  ]" => "[zdot]",
	  "[Zdot  ]" => "[Zdot]",

          ## ISO 8879:1986//ENTITIES Greek Letters//EN
	  "[agr   ]" => "[agr]",
	  "[Agr   ]" => "[Agr]",
	  "[bgr   ]" => "[bgr]",
	  "[Bgr   ]" => "[Bgr]",
	  "[ggr   ]" => "[ggr]",
	  "[Ggr   ]" => "[Ggr]",
	  "[dgr   ]" => "[dgr]",
	  "[Dgr   ]" => "[Dgr]",
	  "[egr   ]" => "[egr]",
	  "[Egr   ]" => "[Egr]",
	  "[zgr   ]" => "[zgr]",
	  "[Zgr   ]" => "[Zgr]",
	  "[eegr  ]" => "[eegr]",
	  "[EEgr  ]" => "[EEgr]",
	  "[thgr  ]" => "[thgr]",
	  "[THgr  ]" => "[THgr]",
	  "[igr   ]" => "[igr]",
	  "[Igr   ]" => "[Igr]",
	  "[kgr   ]" => "[kgr]",
	  "[Kgr   ]" => "[Kgr]",
	  "[lgr   ]" => "[lgr]",
	  "[Lgr   ]" => "[Lgr]",
	  "[mgr   ]" => "[mgr]",
	  "[Mgr   ]" => "[Mgr]",
	  "[ngr   ]" => "[ngr]",
	  "[Ngr   ]" => "[Ngr]",
	  "[xgr   ]" => "[xgr]",
	  "[Xgr   ]" => "[Xgr]",
	  "[ogr   ]" => "[ogr]",
	  "[Ogr   ]" => "[Ogr]",
	  "[pgr   ]" => "[pgr]",
	  "[Pgr   ]" => "[Pgr]",
	  "[rgr   ]" => "[rgr]",
	  "[Rgr   ]" => "[Rgr]",
	  "[sgr   ]" => "[sgr]",
	  "[Sgr   ]" => "[Sgr]",
	  "[sfgr  ]" => "[sfgr]",
	  "[tgr   ]" => "[tgr]",
	  "[Tgr   ]" => "[Tgr]",
	  "[ugr   ]" => "[ugr]",
	  "[Ugr   ]" => "[Ugr]",
	  "[phgr  ]" => "[phgr]",
	  "[PHgr  ]" => "[PHgr]",
	  "[khgr  ]" => "[khgr]",
	  "[KHgr  ]" => "[KHgr]",
	  "[psgr  ]" => "[psgr]",
	  "[PSgr  ]" => "[PSgr]",
	  "[ohgr  ]" => "[ohgr]",
	  "[OHgr  ]" => "[OHgr]",

          ## ISO 8879:1986//ENTITIES Monotoniko Greek//EN
	  "[aacgr ]" => "[aacgr]",
	  "[Aacgr ]" => "[Aacgr]",
	  "[eacgr ]" => "[eacgr]",
	  "[Eacgr ]" => "[Eacgr]",
	  "[eeacgr]" => "[eeacgr]",
	  "[EEacgr]" => "[EEacgr]",
	  "[idigr ]" => "[idigr]",
	  "[Idigr ]" => "[Idigr]",
	  "[iacgr ]" => "[iacgr]",
	  "[Iacgr ]" => "[Iacgr]",
	  "[idiagr]" => "[idiagr]",
	  "[oacgr ]" => "[oacgr]",
	  "[Oacgr ]" => "[Oacgr]",
	  "[udigr ]" => "[udigr]",
	  "[Udigr ]" => "[Udigr]",
	  "[uacgr ]" => "[uacgr]",
	  "[Uacgr ]" => "[Uacgr]",
	  "[udiagr]" => "[udiagr]",
	  "[ohacgr]" => "[ohacgr]",
	  "[OHacgr]" => "[OHacgr]",

          ## ISO 8879:1986//ENTITIES Russian Cyrillic//EN
	  "[acy   ]" => "[acy]",
	  "[Acy   ]" => "[Acy]",
	  "[bcy   ]" => "[bcy]",
	  "[Bcy   ]" => "[Bcy]",
	  "[vcy   ]" => "[vcy]",
	  "[Vcy   ]" => "[Vcy]",
	  "[gcy   ]" => "[gcy]",
	  "[Gcy   ]" => "[Gcy]",
	  "[dcy   ]" => "[dcy]",
	  "[Dcy   ]" => "[Dcy]",
	  "[iecy  ]" => "[iecy]",
	  "[IEcy  ]" => "[IEcy]",
	  "[iocy  ]" => "[iocy]",
	  "[IOcy  ]" => "[IOcy]",
	  "[zhcy  ]" => "[zhcy]",
	  "[ZHcy  ]" => "[ZHcy]",
	  "[zcy   ]" => "[zcy]",
	  "[Zcy   ]" => "[Zcy]",
	  "[icy   ]" => "[icy]",
	  "[Icy   ]" => "[Icy]",
	  "[jcy   ]" => "[jcy]",
	  "[Jcy   ]" => "[Jcy]",
	  "[kcy   ]" => "[kcy]",
	  "[Kcy   ]" => "[Kcy]",
	  "[lcy   ]" => "[lcy]",
	  "[Lcy   ]" => "[Lcy]",
	  "[mcy   ]" => "[mcy]",
	  "[Mcy   ]" => "[Mcy]",
	  "[ncy   ]" => "[ncy]",
	  "[Ncy   ]" => "[Ncy]",
	  "[ocy   ]" => "[ocy]",
	  "[Ocy   ]" => "[Ocy]",
	  "[pcy   ]" => "[pcy]",
	  "[Pcy   ]" => "[Pcy]",
	  "[rcy   ]" => "[rcy]",
	  "[Rcy   ]" => "[Rcy]",
	  "[scy   ]" => "[scy]",
	  "[Scy   ]" => "[Scy]",
	  "[tcy   ]" => "[tcy]",
	  "[Tcy   ]" => "[Tcy]",
	  "[ucy   ]" => "[ucy]",
	  "[Ucy   ]" => "[Ucy]",
	  "[fcy   ]" => "[fcy]",
	  "[Fcy   ]" => "[Fcy]",
	  "[khcy  ]" => "[khcy]",
	  "[KHcy  ]" => "[KHcy]",
	  "[tscy  ]" => "[tscy]",
	  "[TScy  ]" => "[TScy]",
	  "[chcy  ]" => "[chcy]",
	  "[CHcy  ]" => "[CHcy]",
	  "[shcy  ]" => "[shcy]",
	  "[SHcy  ]" => "[SHcy]",
	  "[shchcy]" => "[shchcy]",
	  "[SHCHcy]" => "[SHCHcy]",
	  "[hardcy]" => "[hardcy]",
	  "[HARDcy]" => "[HARDcy]",
	  "[ycy   ]" => "[ycy]",
	  "[Ycy   ]" => "[Ycy]",
	  "[softcy]" => "[softcy]",
	  "[SOFTcy]" => "[SOFTcy]",
	  "[ecy   ]" => "[ecy]",
	  "[Ecy   ]" => "[Ecy]",
	  "[yucy  ]" => "[yucy]",
	  "[YUcy  ]" => "[YUcy]",
	  "[yacy  ]" => "[yacy]",
	  "[YAcy  ]" => "[YAcy]",
	  "[numero]" => "[numero]",

          ## ISO 8879:1986//ENTITIES Non-Russian Cyrillic//EN
	  "[djcy  ]" => "[djcy]",
	  "[DJcy  ]" => "[DJcy]",
	  "[gjcy  ]" => "[gjcy]",
	  "[GJcy  ]" => "[GJcy]",
	  "[jukcy ]" => "[jukcy]",
	  "[Jukcy ]" => "[Jukcy]",
	  "[dscy  ]" => "[dscy]",
	  "[DScy  ]" => "[DScy]",
	  "[iukcy ]" => "[iukcy]",
	  "[Iukcy ]" => "[Iukcy]",
	  "[yicy  ]" => "[yicy]",
	  "[YIcy  ]" => "[YIcy]",
	  "[jsercy]" => "[jsercy]",
	  "[Jsercy]" => "[Jsercy]",
	  "[ljcy  ]" => "[ljcy]",
	  "[LJcy  ]" => "[LJcy]",
	  "[njcy  ]" => "[njcy]",
	  "[NJcy  ]" => "[NJcy]",
	  "[tshcy ]" => "[tshcy]",
	  "[TSHcy ]" => "[TSHcy]",
	  "[kjcy  ]" => "[kjcy]",
	  "[KJcy  ]" => "[KJcy]",
	  "[ubrcy ]" => "[ubrcy]",
	  "[Ubrcy ]" => "[Ubrcy]",
	  "[dzcy  ]" => "[dzcy]",
	  "[DZcy  ]" => "[DZcy]",

          ## ISO 8879:1986//ENTITIES Numeric and Special Graphic//EN
	  "[half  ]" => "\&frac12;",
	  "[frac12]" => "\&frac12;",
	  "[frac14]" => "\&frac14;",
	  "[frac34]" => "\&frac34;",
	  "[frac18]" => "1/8",
	  "[frac38]" => "3/8",
	  "[frac58]" => "5/8",
	  "[frac78]" => "7/8",
	  "[sup1  ]" => "\&sup1;",
	  "[sup2  ]" => "\&sup2;",
	  "[sup3  ]" => "\&sup3;",
	  "[plus  ]" => "+",
	  "[plusmn]" => "\&plusmn;",
	  "[lt    ]" => "\&lt;",
	  "[equals]" => "=",
	  "[gt    ]" => "\&gt;",
	  "[divide]" => "\&divide;",
	  "[times ]" => "\&times;",
	  "[curren]" => "\&curren;",
	  "[pound ]" => "\&pound;",
	  "[dollar]" => "\$",
	  "[cent  ]" => "\&cent;",
	  "[yen   ]" => "\&yen;",
	  "[num   ]" => "#",
	  "[percnt]" => "%",
	  "[amp   ]" => "\&amp;",
	  "[ast   ]" => "*",
	  "[commat]" => "\@",
	  "[lsqb  ]" => "[",
	  "[bsol  ]" => "\\",
	  "[rsqb  ]" => "]",
	  "[lcub  ]" => "{",
	  "[horbar]" => "--",
	  "[verbar]" => "|",
	  "[rcub  ]" => "}",
	  "[micro ]" => "\&micro;",
	  "[ohm   ]" => "[ohm]",
	  "[deg   ]" => "\&deg;",
	  "[ordm  ]" => "\&ordm;",
	  "[ordf  ]" => "\&ordf;",
	  "[sect  ]" => "\&sect;",
	  "[para  ]" => "\&para;",
	  "[middot]" => "\&middot;",
	  "[larr  ]" => "\&larr;",
	  "[rarr  ]" => "\&rarr;",
	  "[uarr  ]" => "\&uarr;",
	  "[darr  ]" => "\&darr;",
	  "[copy  ]" => "\&copy;",
	  "[reg   ]" => "\&reg;",
	  "[trade ]" => "\&trade;",
	  "[brvbar]" => "\&brvbar;",
	  "[not   ]" => "\&not;",
	  "[sung  ]" => "[sung]",
	  "[excl  ]" => "!",
	  "[iexcl ]" => "\&iexcl;",
	  "[quot  ]" => "\&quot;",
	  "[apos  ]" => "'",
	  "[lpar  ]" => "(",
	  "[rpar  ]" => ")",
	  "[comma ]" => ",",
	  "[lowbar]" => "_",
	  "[hyphen]" => "-",
	  "[period]" => ".",
	  "[sol   ]" => "/",
	  "[colon ]" => ":",
	  "[semi  ]" => ";",
	  "[quest ]" => "?",
	  "[iquest]" => "\&iquest;",
	  "[laquo ]" => "\&laquo;",
	  "[raquo ]" => "\&raquo;",
	  "[lsquo ]" => "\&lsquo;",
	  "[rsquo ]" => "\&rsquo;",
	  "[ldquo ]" => "\&ldquo;",
	  "[rdquo ]" => "\&rdquo;",
	  "[nbsp  ]" => "\&nbsp;",
	  "[shy   ]" => "\&shy;",

          ## ISO 8879:1986//ENTITIES Diacritical Marks//EN
	  "[acute ]" => "\&acute;",
	  "[breve ]" => "[breve]",
	  "[caron ]" => "[caron]",
	  "[cedil ]" => "\&cedil;",
	  "[circ  ]" => "\&circ;",
	  "[dblac ]" => "''",
	  "[die   ]" => "\&uml;",
	  "[dot   ]" => "[dot]",
	  "[grave ]" => "`",
	  "[macr  ]" => "\&macr;",
	  "[ogon  ]" => "[ogon]",
	  "[ring  ]" => "[ring]",
	  "[tilde ]" => "\&tilde;",
	  "[uml   ]" => "\&uml;",

          ## ISO 8879:1986//ENTITIES Publishing//EN
	  "[emsp  ]" => "\&emsp;",
	  "[ensp  ]" => "\&ensp;",
	  "[emsp3 ]" => "[emsp13]",
	  "[emsp4 ]" => "[emsp14]",
	  "[numsp ]" => "[numsp]",
	  "[puncsp]" => "[puncsp]",
	  "[thinsp]" => "\&thinsp;",
	  "[hairsp]" => "[hairsp]",
	  "[mdash ]" => "\&mdash;",
	  "[ndash ]" => "\&ndash;",
	  "[dash  ]" => "-",
	  "[blank ]" => "_",
	  "[hellip]" => "\&hellip;",
	  "[nldr  ]" => "..",
	  "[frac13]" => "1/3",
	  "[frac23]" => "2/3",
	  "[frac15]" => "1/5",
	  "[frac25]" => "2/5",
	  "[frac35]" => "3/5",
	  "[frac45]" => "4/5",
	  "[frac16]" => "1/6",
	  "[frac56]" => "5/6",
	  "[incare]" => "c/o",
	  "[block ]" => "[block]",
	  "[uhblk ]" => "[uhblk]",
	  "[lhblk ]" => "[lhblk]",
	  "[blk14 ]" => "[blk14]",
	  "[blk12 ]" => "[blk12]",
	  "[blk34 ]" => "[blk34]",
	  "[marker]" => "[marker]",
	  "[cir   ]" => "o",
	  "[squ   ]" => "[squ]",
	  "[rect  ]" => "[rect]",
	  "[utri  ]" => "[utri]",
	  "[dtri  ]" => "[dtri]",
	  "[star  ]" => "[star]",
	  "[bull  ]" => "\&bull;",
	  "[squf  ]" => "[squf]",
	  "[utrif ]" => "[utrif]",
	  "[dtrif ]" => "[dtrif]",
	  "[ltrif ]" => "[ltrif]",
	  "[rtrif ]" => "[rtrif]",
	  "[clubs ]" => "\&clubs;",
	  "[diams ]" => "\&diams;",
	  "[hearts]" => "\&hearts;",
	  "[spades]" => "\&spades;",
	  "[malt  ]" => "[malt]",
	  "[dagger]" => "\&dagger;",
	  "[Dagger]" => "\&Dagger;",
	  "[check ]" => "[check]",
	  "[ballot]" => "x",
	  "[sharp ]" => "#",
	  "[flat  ]" => "[flat]",
	  "[male  ]" => "[male]",
	  "[female]" => "[female]",
	  "[phone ]" => "[phone]",
	  "[telrec]" => "[telrec]",
	  "[copysr]" => "[copysr]",
	  "[caret ]" => "^",
	  "[lsquor]" => "'",
	  "[ldquor]" => "\"",
	  "[fflig ]" => "ff",
	  "[filig ]" => "fi",
	  "[fjlig ]" => "fj",
	  "[ffilig]" => "ffi",
	  "[ffllig]" => "ffl",
	  "[fllig ]" => "fl",
	  "[mldr  ]" => "...",
	  "[rdquor]" => "\"",
	  "[rsquor]" => "'",
	  "[vellip]" => ":",
	  "[hybull]" => "-",
	  "[loz   ]" => "\&loz;",
	  "[lozf  ]" => "[lozf]",
	  "[ltri  ]" => "[ltri]",
	  "[rtri  ]" => "[rtri]",
	  "[starf ]" => "[starf]",
	  "[natur ]" => "[natur]",
	  "[rx    ]" => "[rx]",
	  "[sext  ]" => "[sext]",
	  "[target]" => "[target]",
	  "[dlcrop]" => "[dlcrop]",
	  "[drcrop]" => "[drcrop]",
	  "[ulcrop]" => "[ulcrop]",
	  "[urcrop]" => "[urcrop]",

          ## ISO 8879:1986//ENTITIES Box and Line Drawing//EN
	  "[boxh  ]" => "[boxh]",
	  "[boxv  ]" => "[boxv]",
	  "[boxur ]" => "[boxur]",
	  "[boxul ]" => "[boxul]",
	  "[boxdl ]" => "[boxdl]",
	  "[boxdr ]" => "[boxdr]",
	  "[boxvr ]" => "[boxvr]",
	  "[boxhu ]" => "[boxhu]",
	  "[boxvl ]" => "[boxvl]",
	  "[boxhd ]" => "[boxhd]",
	  "[boxvh ]" => "[boxvh]",
	  "[boxvR ]" => "[boxvR]",
	  "[boxhU ]" => "[boxhU]",
	  "[boxvL ]" => "[boxvL]",
	  "[boxhD ]" => "[boxhD]",
	  "[boxvH ]" => "[boxvH]",
	  "[boxH  ]" => "[boxH]",
	  "[boxV  ]" => "[boxV]",
	  "[boxUR ]" => "[boxUR]",
	  "[boxUL ]" => "[boxUL]",
	  "[boxDL ]" => "[boxDL]",
	  "[boxDR ]" => "[boxDR]",
	  "[boxVR ]" => "[boxVR]",
	  "[boxHU ]" => "[boxHU]",
	  "[boxVL ]" => "[boxVL]",
	  "[boxHD ]" => "[boxHD]",
	  "[boxVH ]" => "[boxVH]",
	  "[boxVr ]" => "[boxVr]",
	  "[boxHu ]" => "[boxHu]",
	  "[boxVl ]" => "[boxVl]",
	  "[boxHd ]" => "[boxHd]",
	  "[boxVh ]" => "[boxVh]",
	  "[boxuR ]" => "[boxuR]",
	  "[boxUl ]" => "[boxUl]",
	  "[boxdL ]" => "[boxdL]",
	  "[boxDr ]" => "[boxDr]",
	  "[boxUr ]" => "[boxUr]",
	  "[boxuL ]" => "[boxuL]",
	  "[boxDl ]" => "[boxDl]",
	  "[boxdR ]" => "[boxdR]",

          ## ISO 8879:1986//ENTITIES General Technical//EN
	  "[aleph ]" => "\&alefsym;",
	  "[and   ]" => "\&and;",
	  "[ang90 ]" => "|_",
	  "[angsph]" => "[angsph]",
	  "[ap    ]" => "[ap]",
	  "[becaus]" => "[becaus]",
	  "[bottom]" => "[bottom]",
	  "[cap   ]" => "\&cap;",
	  "[cong  ]" => "\&cong;",
	  "[conint]" => "[conint]",
	  "[cup   ]" => "\&cup;",
	  "[equiv ]" => "\&equiv;",
	  "[exist ]" => "\&exist;",
	  "[forall]" => "\&forall;",
	  "[fnof  ]" => "\&fnof;",
	  "[ge    ]" => "\&ge;",
	  "[iff   ]" => "\&lt;==\&gt;",
	  "[infin ]" => "\&infin;",
	  "[int   ]" => "\&int;",
	  "[isin  ]" => "\&isin;",
	  "[lang  ]" => "\&lang;",
	  "[lArr  ]" => "\&lArr;",
	  "[le    ]" => "\&le;",
	  "[minus ]" => "\&minus;",
	  "[mnplus]" => "-/+",
	  "[nabla ]" => "\&nabla;",
	  "[ne    ]" => "\&ne;",
	  "[ni    ]" => "\&ni;",
	  "[or    ]" => "\&or;",
	  "[par   ]" => "||",
	  "[part  ]" => "\&part;",
	  "[permil]" => "\&permil;",
	  "[perp  ]" => "\&perp;",
	  "[prime ]" => "\&prime;",
	  "[Prime ]" => "\&Prime;",
	  "[prop  ]" => "\&prop;",
	  "[radic ]" => "\&radic;",
	  "[rang  ]" => "\&rang;",
	  "[rArr  ]" => "\&rArr;",
	  "[sim   ]" => "\&sim;",
	  "[sime  ]" => "[sime]",
	  "[square]" => "[square]",
	  "[sub   ]" => "\&sub;",
	  "[sube  ]" => "\&sube;",
	  "[sup   ]" => "\&sup;",
	  "[supe  ]" => "\&supe;",
	  "[there4]" => "\&there4;",
	  "[Verbar]" => "||",
	  "[angst ]" => "AA",
	  "[bernou]" => "B",
	  "[compfn]" => "o",
	  "[Dot   ]" => "[Dot]",
	  "[DotDot]" => "[DotDot]",
	  "[hamilt]" => "H",
	  "[lagran]" => "L",
	  "[lowast]" => "\&lowast;",
	  "[notin ]" => "\&notin;",
	  "[order ]" => "O",
	  "[phmmat]" => "M",
	  "[tdot  ]" => "[tdot]",
	  "[tprime]" => "'''",
	  "[wedgeq]" => "[wedgeq]",

          ## ISO 8879:1986//ENTITIES Greek Symbols//EN
	  "[alpha ]" => "\&alpha;",
	  "[beta  ]" => "\&beta;",
	  "[gamma ]" => "\&gamma;",
	  "[Gamma ]" => "\&Gamma;",
	  "[gammad]" => "\&Gamma;",
	  "[delta ]" => "\&delta;",
	  "[Delta ]" => "\&Delta;",
	  "[epsi  ]" => "\&epsilon;",
	  "[epsiv ]" => "\&epsilon;",
	  "[epsis ]" => "\&epsilon;",
	  "[zeta  ]" => "\&zeta;",
	  "[eta   ]" => "\&eta;",
	  "[thetas]" => "\&theta;",
	  "[Theta ]" => "\&Theta;",
	  "[thetav]" => "\&thetasym;",
	  "[iota  ]" => "\&iota;",
	  "[kappa ]" => "\&kappa;",
	  "[kappav]" => "\&kappa;",
	  "[lambda]" => "\&lambda;",
	  "[Lambda]" => "\&Lambda;",
	  "[mu    ]" => "\&mu;",
	  "[nu    ]" => "\&nu;",
	  "[xi    ]" => "\&xi;",
	  "[Xi    ]" => "\&Xi;",
	  "[pi    ]" => "\&pi;",
	  "[piv   ]" => "\&piv;",
	  "[Pi    ]" => "\&Pi;",
	  "[rho   ]" => "\&rho;",
	  "[rhov  ]" => "\&rho;",
	  "[sigma ]" => "\&sigma;",
	  "[Sigma ]" => "\&Sigma;",
	  "[sigmav]" => "\&sigmaf;",
	  "[tau   ]" => "\&tau;",
	  "[upsi  ]" => "\&upsilon;",
	  "[Upsi  ]" => "\&Upsilon;",
	  "[phis  ]" => "\&phi;",
	  "[Phi   ]" => "\&Phi;",
	  "[phiv  ]" => "\&phi;",
	  "[chi   ]" => "\&chi;",
	  "[psi   ]" => "\&psi;",
	  "[Psi   ]" => "\&Psi;",
	  "[omega ]" => "\&omega;",
	  "[Omega ]" => "\&Omega;",

          ## ISO 8879:1986//ENTITIES Alternative Greek Symbols//EN
	  "[b.alpha ]" => "\&alpha;",
	  "[b.beta  ]" => "\&beta;",
	  "[b.gamma ]" => "\&gamma;",
	  "[b.Gamma ]" => "\&Gamma;",
	  "[b.gammad]" => "\&Gamma;",
	  "[b.delta ]" => "\&delta;",
	  "[b.Delta ]" => "\&Delta;",
	  "[b.epsi  ]" => "\&epsilon;",
	  "[b.epsiv ]" => "\&epsilon;",
	  "[b.epsis ]" => "\&epsilon;",
	  "[b.zeta  ]" => "\&zeta;",
	  "[b.eta   ]" => "\&eta;",
	  "[b.thetas]" => "\&theta;",
	  "[b.Theta ]" => "\&Theta;",
	  "[b.thetav]" => "\&thetasym;",
	  "[b.iota  ]" => "\&iota;",
	  "[b.kappa ]" => "\&kappa;",
	  "[b.kappav]" => "\&kappa;",
	  "[b.lambda]" => "\&lambda;",
	  "[b.Lambda]" => "\&Lambda;",
	  "[b.mu    ]" => "\&mu;",
	  "[b.nu    ]" => "\&nu;",
	  "[b.xi    ]" => "\&xi;",
	  "[b.Xi    ]" => "\&Xi;",
	  "[b.pi    ]" => "\&pi;",
	  "[b.piv   ]" => "\&piv;",
	  "[b.Pi    ]" => "\&Pi;",
	  "[b.rho   ]" => "\&rho;",
	  "[b.rhov  ]" => "\&rho;",
	  "[b.sigma ]" => "\&sigma;",
	  "[b.Sigma ]" => "\&Sigma;",
	  "[b.sigmav]" => "\&sigmaf;",
	  "[b.tau   ]" => "\&tau;",
	  "[b.upsi  ]" => "\&upsilon;",
	  "[b.Upsi  ]" => "\&Upsilon;",
	  "[b.phis  ]" => "\&phi;",
	  "[b.Phi   ]" => "\&Phi;",
	  "[b.phiv  ]" => "\&phi;",
	  "[b.chi   ]" => "\&chi;",
	  "[b.psi   ]" => "\&psi;",
	  "[b.Psi   ]" => "\&Psi;",
	  "[b.omega ]" => "\&omega;",
	  "[b.Omega ]" => "\&Omega;",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Ordinary//EN
	  "[ang   ]" => "\&ang;",
	  "[angmsd]" => "[angmsd]",
	  "[beth  ]" => "[beth]",
	  "[bprime]" => "`",
	  "[comp  ]" => "C",
	  "[daleth]" => "[daleth]",
	  "[ell   ]" => "l",
	  "[empty ]" => "\&empty;",
	  "[gimel ]" => "[gimel]",
	  "[image ]" => "\&image;",
	  "[inodot]" => "[inodot]",
	  "[jnodot]" => "[jnodot]",
	  "[nexist]" => "[nexist]",
	  "[oS    ]" => "[oS]",
	  "[planck]" => "[planck]",
	  "[real  ]" => "\&real;",
	  "[sbsol ]" => "\\",
	  "[vprime]" => "'",
	  "[weierp]" => "\&weierp;",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Binary Operators//EN
	  "[amalg ]" => "[amalg]",
	  "[Barwed]" => "[Barwed]",
	  "[barwed]" => "[barwed]",
	  "[Cap   ]" => "[Cap]",
	  "[Cup   ]" => "[Cup]",
	  "[cuvee ]" => "[cuvee]",
	  "[cuwed ]" => "[cuwed]",
	  "[diam  ]" => "[diam]",
	  "[divonx]" => "[divonx]",
	  "[intcal]" => "[intcal]",
	  "[lthree]" => "[lthree]",
	  "[ltimes]" => "[ltimes]",
	  "[minusb]" => "[minusb]",
	  "[oast  ]" => "[oast]",
	  "[ocir  ]" => "[ocir]",
	  "[odash ]" => "[odash]",
	  "[odot  ]" => "[odot]",
	  "[ominus]" => "[ominus]",
	  "[oplus ]" => "\&oplus;",
	  "[osol  ]" => "[osol]",
	  "[otimes]" => "\&otimes;",
	  "[plusb ]" => "[plusb]",
	  "[plusdo]" => "[plusdo]",
	  "[rthree]" => "[rthree]",
	  "[rtimes]" => "[rtimes]",
	  "[sdot  ]" => "\&sdot;",
	  "[sdotb ]" => "[sdotb]",
	  "[setmn ]" => "[setmn]",
	  "[sqcap ]" => "[sqcap]",
	  "[sqcup ]" => "[sqcup]",
	  "[ssetmn]" => "[ssetmn]",
	  "[sstarf]" => "[sstarf]",
	  "[timesb]" => "[timesb]",
	  "[top   ]" => "[top]",
	  "[uplus ]" => "[uplus]",
	  "[wreath]" => "[wreath]",
	  "[xcirc ]" => "[xcirc]",
	  "[xdtri ]" => "[xdtri]",
	  "[xutri ]" => "[xutri]",
	  "[coprod]" => "[coprod]",
	  "[prod  ]" => "\&prod;",
	  "[sum   ]" => "\&sum;",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Relations//EN
	  "[ape   ]" => "[ape]",
	  "[asymp ]" => "\&asymp;",
	  "[bcong ]" => "[bcong]",
	  "[bepsi ]" => "[bepsi]",
	  "[bowtie]" => "[bowtie]",
	  "[bsim  ]" => "[bsim]",
	  "[bsime ]" => "[bsime]",
	  "[bump  ]" => "[bump]",
	  "[bumpe ]" => "[bumpe]",
	  "[cire  ]" => "[cire]",
	  "[colone]" => "[colone]",
	  "[cuepr ]" => "[cuepr]",
	  "[cuesc ]" => "[cuesc]",
	  "[cupre ]" => "[cupre]",
	  "[dashv ]" => "[dashv]",
	  "[ecir  ]" => "[ecir]",
	  "[ecolon]" => "[ecolon]",
	  "[eDot  ]" => "[eDot]",
	  "[esdot ]" => "[esdot]",
	  "[efDot ]" => "[efDot]",
	  "[egs   ]" => "[egs]",
	  "[els   ]" => "[els]",
	  "[erDot ]" => "[erDot]",
	  "[fork  ]" => "[fork]",
	  "[frown ]" => "[frown]",
	  "[gap   ]" => "[gap]",
	  "[gsdot ]" => "[gsdot]",
	  "[gE    ]" => "[gE]",
	  "[gel   ]" => "[gel]",
	  "[gEl   ]" => "[gEl]",
	  "[ges   ]" => "[ges]",
	  "[Gg    ]" => "[Gg]",
	  "[gl    ]" => "[gl]",
	  "[gsim  ]" => "[gsim]",
	  "[Gt    ]" => "[Gt]",
	  "[lap   ]" => "[lap]",
	  "[ldot  ]" => "[ldot]",
	  "[lE    ]" => "[lE]",
	  "[lEg   ]" => "[lEg]",
	  "[leg   ]" => "[leg]",
	  "[les   ]" => "[les]",
	  "[lg    ]" => "[lg]",
	  "[Ll    ]" => "[Ll]",
	  "[lsim  ]" => "[lsim]",
	  "[Lt    ]" => "[Lt]",
	  "[ltrie ]" => "[ltrie]",
	  "[mid   ]" => "[mid]",
	  "[models]" => "[models]",
	  "[pr    ]" => "[pr]",
	  "[prap  ]" => "[prap]",
	  "[pre   ]" => "[pre]",
	  "[prsim ]" => "[prsim]",
	  "[rtrie ]" => "[rtrie]",
	  "[samalg]" => "[samalg]",
	  "[sc    ]" => "[sc]",
	  "[scap  ]" => "[scap]",
	  "[sccue ]" => "[sccue]",
	  "[sce   ]" => "[sce]",
	  "[scsim ]" => "[scsim]",
	  "[sfrown]" => "[sfrown]",
	  "[smid  ]" => "[smid]",
	  "[smile ]" => "[smile]",
	  "[spar  ]" => "[spar]",
	  "[sqsub ]" => "[sqsub]",
	  "[sqsube]" => "[sqsube]",
	  "[sqsup ]" => "[sqsup]",
	  "[sqsupe]" => "[sqsupe]",
	  "[ssmile]" => "[ssmile]",
	  "[Sub   ]" => "[Sub]",
	  "[subE  ]" => "[subE]",
	  "[Sup   ]" => "[Sup]",
	  "[supE  ]" => "[supE]",
	  "[thkap ]" => "[thkap]",
	  "[thksim]" => "[thksim]",
	  "[trie  ]" => "[trie]",
	  "[twixt ]" => "[twixt]",
	  "[vdash ]" => "[vdash]",
	  "[Vdash ]" => "[Vdash]",
	  "[vDash ]" => "[vDash]",
	  "[veebar]" => "[veebar]",
	  "[vltri ]" => "[vltri]",
	  "[vprop ]" => "[vprop]",
	  "[vrtri ]" => "[vrtri]",
	  "[Vvdash]" => "[Vvdash]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Negated Relations//EN
	  "[gnap  ]" => "[gnap]",
	  "[gne   ]" => "[gne]",
	  "[gnE   ]" => "[gnE]",
	  "[gnsim ]" => "[gnsim]",
	  "[gvnE  ]" => "[gvnE]",
	  "[lnap  ]" => "[lnap]",
	  "[lnE   ]" => "[lnE]",
	  "[lne   ]" => "[lne]",
	  "[lnsim ]" => "[lnsim]",
	  "[lvnE  ]" => "[lvnE]",
	  "[nap   ]" => "[nap]",
	  "[ncong ]" => "[ncong]",
	  "[nequiv]" => "[nequiv]",
	  "[ngE   ]" => "[ngE]",
	  "[nge   ]" => "[nge]",
	  "[nges  ]" => "[nges]",
	  "[ngt   ]" => "[ngt]",
	  "[nle   ]" => "[nle]",
	  "[nlE   ]" => "[nlE]",
	  "[nles  ]" => "[nles]",
	  "[nlt   ]" => "[nlt]",
	  "[nltri ]" => "[nltri]",
	  "[nltrie]" => "[nltrie]",
	  "[nmid  ]" => "[nmid]",
	  "[npar  ]" => "[npar]",
	  "[npr   ]" => "[npr]",
	  "[npre  ]" => "[npre]",
	  "[nrtri ]" => "[nrtri]",
	  "[nrtrie]" => "[nrtrie]",
	  "[nsc   ]" => "[nsc]",
	  "[nsce  ]" => "[nsce]",
	  "[nsim  ]" => "[nsim]",
	  "[nsime ]" => "[nsime]",
	  "[nsmid ]" => "[nsmid]",
	  "[nspar ]" => "[nspar]",
	  "[nsub  ]" => "\&nsub;",
	  "[nsube ]" => "[nsube]",
	  "[nsubE ]" => "[nsubE]",
	  "[nsup  ]" => "[nsup]",
	  "[nsupE ]" => "[nsupE]",
	  "[nsupe ]" => "[nsupe]",
	  "[nvdash]" => "[nvdash]",
	  "[nvDash]" => "[nvDash]",
	  "[nVDash]" => "[nVDash]",
	  "[nVdash]" => "[nVdash]",
	  "[prnap ]" => "[prnap]",
	  "[prnE  ]" => "[prnE]",
	  "[prnsim]" => "[prnsim]",
	  "[scnap ]" => "[scnap]",
	  "[scnE  ]" => "[scnE]",
	  "[scnsim]" => "[scnsim]",
	  "[subne ]" => "[subne]",
	  "[subnE ]" => "[subnE]",
	  "[supne ]" => "[supne]",
	  "[supnE ]" => "[supnE]",
	  "[vsubnE]" => "[vsubnE]",
	  "[vsubne]" => "[vsubne]",
	  "[vsupne]" => "[vsupne]",
	  "[vsupnE]" => "[vsupnE]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Arrow Relations//EN
	  "[cularr]" => "[cularr]",
	  "[curarr]" => "[curarr]",
	  "[dArr  ]" => "\&dArr;",
	  "[darr2 ]" => "[darr2]",
	  "[dharl ]" => "[dharl]",
	  "[dharr ]" => "[dharr]",
	  "[lAarr ]" => "[lAarr]",
	  "[Larr  ]" => "[Larr]",
	  "[larr2 ]" => "[larr2]",
	  "[larrhk]" => "[larrhk]",
	  "[larrlp]" => "[larrlp]",
	  "[larrtl]" => "[larrtl]",
	  "[lhard ]" => "[lhard]",
	  "[lharu ]" => "[lharu]",
	  "[hArr  ]" => "\&hArr;",
	  "[harr  ]" => "\&harr;",
	  "[lrarr2]" => "[lrarr2]",
	  "[rlarr2]" => "[rlarr2]",
	  "[harrw ]" => "[harrw]",
	  "[rlhar2]" => "[rlhar2]",
	  "[lrhar2]" => "[lrhar2]",
	  "[lsh   ]" => "[lsh]",
	  "[map   ]" => "[map]",
	  "[mumap ]" => "[mumap]",
	  "[nearr ]" => "[nearr]",
	  "[nlArr ]" => "[nlArr]",
	  "[nlarr ]" => "[nlarr]",
	  "[nhArr ]" => "[nhArr]",
	  "[nharr ]" => "[nharr]",
	  "[nrarr ]" => "[nrarr]",
	  "[nrArr ]" => "[nrArr]",
	  "[nwarr ]" => "[nwarr]",
	  "[olarr ]" => "[olarr]",
	  "[orarr ]" => "[orarr]",
	  "[rAarr ]" => "[rAarr]",
	  "[Rarr  ]" => "[Rarr]",
	  "[rarr2 ]" => "[rarr2]",
	  "[rarrhk]" => "[rarrhk]",
	  "[rarrlp]" => "[rarrlp]",
	  "[rarrtl]" => "[rarrtl]",
	  "[rarrw ]" => "[rarrw]",
	  "[rhard ]" => "[rhard]",
	  "[rharu ]" => "[rharu]",
	  "[rsh   ]" => "[rsh]",
	  "[drarr ]" => "[drarr]",
	  "[dlarr ]" => "[dlarr]",
	  "[uArr  ]" => "\&uArr;",
	  "[uarr2 ]" => "[uarr2]",
	  "[vArr  ]" => "[vArr]",
	  "[varr  ]" => "[varr]",
	  "[uharl ]" => "[uharl]",
	  "[uharr ]" => "[uharr]",
	  "[xlArr ]" => "[xlArr]",
	  "[xhArr ]" => "[xhArr]",
	  "[xharr ]" => "[xharr]",
	  "[xrArr ]" => "[xrArr]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Delimiters//EN
	  "[rceil ]" => "\&rceil;",
	  "[rfloor]" => "\&rfloor;",
	  "[rpargt]" => "[rpargt]",
	  "[urcorn]" => "[urcorn]",
	  "[drcorn]" => "[drcorn]",
	  "[lceil ]" => "\&lceil;",
	  "[lfloor]" => "\&lfloor;",
	  "[lpargt]" => "[lpargt]",
	  "[ulcorn]" => "[ulcorn]",
	  "[dlcorn]" => "[dlcorn]",

	  );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
