
/* find.c */

#include "find.h"
#include "strx.h"
#include "argp.h"
#include "datum.h"
#include "xref.h"
#include "prdeb.h"
#include "gen.h"

void print_find( void ) {

  rewind_data();

  for (
    ;
    doc_part <= DEB_X && ( opt.maint_cl_first || opt.deb_cl_first );
    get_datum(0)
  ) if ( datum.type == DEB ) {

    int print = 0;

    {
      struct name_cl **const first [] =
        { &opt  .maint_cl_first, &opt  .deb_cl_first, 0 };
      char           **const dname [] =
        { &datum.maint         , &datum.deb         , 0 };
      char           **const dnameX[] =
        { &datum.maintX        , &datum.debX        , 0 };
      int              const unlink[] =
        { 0                    , 1                  , 0 };
      int i;
      for ( i = 0; first[i]; i++ ) {
        struct name_cl *prev, *name = 0;
        while (1) {
          if ( name ) prev = name, name =  name->next;
          else        prev = 0   , name = *first[i]  ;
          if ( !name ) break;
          if ( !strxcmp( name->name, *dname[i], *dnameX[i] ) ) {
            if ( unlink[i] ) {
              if ( prev ) prev->next = name->next, name = prev;
              else       *first[i]   = name->next, name = 0   ;
            }
            print = 1;
          }
        }
      }
    }

    if ( print && opt.ram_cl_first ) {
      struct xram *xram;
      print = 0;
      for (
        xram = first_selected(0);
        xram;
        xram = next_selected(xram)
      ) if ( !strncmp( datum.ram_s, xram->ram, N_DIG ) ) {
        print = 1;
        break;
      }
    }

    if ( print ) print_deb( 1, 0 );

  }

}

