# Written by John Hoffman
# Modified by Cameron Dale
# see LICENSE.txt for license information
#
# $Id: torrentlistparse.py 266 2007-08-18 02:06:35Z camrdale-guest $

"""Parse a file for a list of torrent hashes.

@type logger: C{logging.Logger}
@var logger: the logger to send all log messages to for this module

"""

from binascii import unhexlify
import logging

logger = logging.getLogger('DebTorrent.torrentlistparse')

def parsetorrentlist(filename, parsed):
    """Parse a file for a list of torrent hashes.
    
    The format is one hash per line in hex format (40 characters).

    @type filename: C{string}
    @param filename: the file to parse
    @type parsed: C{dictionary}
    @param parsed: the cache of all the torrents ever found
    @rtype: (C{dictionary}, C{dictionary}, C{dictionary})
    @return: the cache of all the torrents found, the new torrents that were 
        found, the torrents that are now missing
    
    """
    new_parsed = {}
    added = {}
    removed = parsed
    f = open(filename, 'r')
    while True:
        l = f.readline()
        if not l:
            break
        l = l.strip()
        try:
            if len(l) != 40:
                raise ValueError, 'bad line'
            h = unhexlify(l)
        except:
            logger.warning('could not parse line in torrent list: '+l)
        if parsed.has_key(h):
            del removed[h]
        else:
            added[h] = True
        new_parsed[h] = True
    f.close()
    return (new_parsed, added, removed)

